<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function log1p

Calculate the logarithm of a `value+1`.

For matrices, the function is evaluated element wise.


## Syntax

```js
math.log1p(x)
math.log1p(x, base)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | number &#124; BigNumber &#124; Complex &#124; Array &#124; Matrix |  Value for which to calculate the logarithm of `x+1`.
`base` | number &#124; BigNumber &#124; Complex |  Optional base for the logarithm. If not provided, the natural logarithm of `x+1` is calculated. Default value: e.

### Returns

Type | Description
---- | -----------
number &#124; BigNumber &#124; Complex &#124; Array &#124; Matrix |  Returns the logarithm of `x+1`


### Throws

Type | Description
---- | -----------


## Examples

```js
math.log1p(2.5)                 // returns 1.252762968495368
math.exp(math.log1p(1.4))       // returns 2.4

math.pow(10, 4)                 // returns 10000
math.log1p(9999, 10)            // returns 4
math.log1p(9999) / math.log(10) // returns 4
```


## See also

[exp](exp.md),
[log](log.md),
[log2](log2.md),
[log10](log10.md)
