<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function nthRoot

Calculate the nth root of a value.
The principal nth root of a positive real number A, is the positive real
solution of the equation

    x^root = A

For matrices, the function is evaluated element wise.


## Syntax

```js
math.nthRoot(a)
math.nthRoot(a, root)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`a` | number &#124; BigNumber &#124; Array &#124; Matrix &#124; Complex |  Value for which to calculate the nth root
`root` | number &#124; BigNumber | The root. Default value: 2.

### Returns

Type | Description
---- | -----------
number &#124; Complex &#124; Array &#124; Matrix | Returns the nth root of `a`


### Throws

Type | Description
---- | -----------


## Examples

```js
math.nthRoot(9, 2)    // returns 3, as 3^2 == 9
math.sqrt(9)          // returns 3, as 3^2 == 9
math.nthRoot(64, 3)   // returns 4, as 4^3 == 64
```


## See also

[sqrt](sqrt.md),
[pow](pow.md)
