<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function nthRoots

Calculate the nth roots of a value.
An nth root of a positive real number A,
is a positive real solution of the equation "x^root = A".
This function returns an array of complex values.


## Syntax

```js
math.nthRoots(x)
math.nthRoots(x, root)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | number &#124; BigNumber &#124; Fraction &#124; Complex | Number to be rounded

### Returns

Type | Description
---- | -----------
number &#124; BigNumber &#124; Fraction &#124; Complex | Rounded value


### Throws

Type | Description
---- | -----------


## Examples

```js
math.nthRoots(1)
// returns [
//   {re: 1, im: 0},
//   {re: -1, im: 0}
// ]
nthRoots(1, 3)
// returns [
//   { re: 1, im: 0 },
//   { re: -0.4999999999999998, im: 0.8660254037844387 },
//   { re: -0.5000000000000004, im: -0.8660254037844385 }
]
```


## See also

[nthRoot](nthRoot.md),
[pow](pow.md),
[sqrt](sqrt.md)
