<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function numeric

Convert a numeric input to a specific numeric type: number, BigNumber, or Fraction.


## Syntax

```js
math.numeric(x)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`value` | string &#124; number &#124; BigNumber &#124; Fraction |  A numeric value or a string containing a numeric value
`outputType` | string |  Desired numeric output type. Available values: 'number', 'BigNumber', or 'Fraction'

### Returns

Type | Description
---- | -----------
number &#124; BigNumber &#124; Fraction |  Returns an instance of the numeric in the requested type


### Throws

Type | Description
---- | -----------


## Examples

```js
math.numeric('4')                           // returns number 4
math.numeric('4', 'number')                 // returns number 4
math.numeric('4', 'BigNumber')              // returns BigNumber 4
math.numeric('4', 'Fraction')               // returns Fraction 4
math.numeric(4, 'Fraction')                 // returns Fraction 4
math.numeric(math.fraction(2, 5), 'number') // returns number 0.4
```


## See also

[number](number.md),
[fraction](fraction.md),
[bignumber](bignumber.md),
[string](string.md),
[format](format.md)
