<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function ones

Create a matrix filled with ones. The created matrix can have one or
multiple dimensions.


## Syntax

```js
math.ones(m)
math.ones(m, format)
math.ones(m, n)
math.ones(m, n, format)
math.ones([m, n])
math.ones([m, n], format)
math.ones([m, n, p, ...])
math.ones([m, n, p, ...], format)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`size` | ...number &#124; Array | The size of each dimension of the matrix
`format` | string | The Matrix storage format

### Returns

Type | Description
---- | -----------
Array &#124; Matrix &#124; number | A matrix filled with ones


### Throws

Type | Description
---- | -----------


## Examples

```js
math.ones(3)                   // returns [1, 1, 1]
math.ones(3, 2)                // returns [[1, 1], [1, 1], [1, 1]]
math.ones(3, 2, 'dense')       // returns Dense Matrix [[1, 1], [1, 1], [1, 1]]

const A = [[1, 2, 3], [4, 5, 6]]
math.ones(math.size(A))       // returns [[1, 1, 1], [1, 1, 1]]
```


## See also

[zeros](zeros.md),
[identity](identity.md),
[size](size.md),
[range](range.md)
