<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function qr

Calculate the Matrix QR decomposition. Matrix `A` is decomposed in
two matrices (`Q`, `R`) where `Q` is an
orthogonal matrix and `R` is an upper triangular matrix.


## Syntax

```js
math.qr(A)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`A` | Matrix &#124; Array | A two dimensional matrix or array for which to get the QR decomposition.

### Returns

Type | Description
---- | -----------
{Q: Array &#124; Matrix, R: Array &#124; Matrix} | Q: the orthogonal matrix and R: the upper triangular matrix


### Throws

Type | Description
---- | -----------


## Examples

```js
const m = [
  [1, -1,  4],
  [1,  4, -2],
  [1,  4,  2],
  [1,  -1, 0]
]
const result = math.qr(m)
// r = {
//   Q: [
//     [0.5, -0.5,   0.5],
//     [0.5,  0.5,  -0.5],
//     [0.5,  0.5,   0.5],
//     [0.5, -0.5,  -0.5],
//   ],
//   R: [
//     [2, 3,  2],
//     [0, 5, -2],
//     [0, 0,  4],
//     [0, 0,  0]
//   ]
// }
```


## See also

[lup](lup.md),
[lusolve](lusolve.md)
