<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function resolve

resolve(expr, scope) replaces variable nodes with their scoped values


## Syntax

```js
resolve(expr, scope)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`node` | Node |  The expression tree to be simplified
`scope` | Object |  Scope specifying variables to be resolved

### Returns

Type | Description
---- | -----------
Node | Returns `node` with variables recursively substituted.


### Throws

Type | Description
---- | -----------
ReferenceError |  If there is a cyclic dependency among the variables in `scope`, resolution is impossible and a ReferenceError is thrown.

## Examples

```js
math.resolve('x + y', {x:1, y:2})           // Node {1 + 2}
math.resolve(math.parse('x+y'), {x:1, y:2}) // Node {1 + 2}
math.simplify('x+y', {x:2, y:'x+x'}).toString()      // "6"
```


## See also

[simplify](simplify.md),
[evaluate](evaluate.md)
