<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function rotate

Rotate a vector of size 1x2 counter-clockwise by a given angle
Rotate a vector of size 1x3 counter-clockwise by a given angle around the given axis


## Syntax

```js
math.rotate(w, theta)
math.rotate(w, theta, v)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`w` | Array &#124; Matrix | Vector to rotate
`theta` | number &#124; BigNumber &#124; Complex &#124; Unit | Rotation angle
`v` | Array &#124; Matrix | Rotation axis

### Returns

Type | Description
---- | -----------
Array &#124; Matrix | Multiplication of the rotation matrix and w


### Throws

Type | Description
---- | -----------


## Examples

```js
math.rotate([11, 12], math.pi / 2)                           // returns matrix([-12, 11])
math.rotate(matrix([11, 12]), math.pi / 2)                   // returns matrix([-12, 11])

math.rotate([1, 0, 0], unit('90deg'), [0, 0, 1])             // returns matrix([0, 1, 0])
math.rotate(matrix([1, 0, 0]), unit('90deg'), [0, 0, 1])     // returns matrix([0, 1, 0])

math.rotate([1, 0], math.complex(1 + i))                     // returns matrix([cos(1 + i) - sin(1 + i), sin(1 + i) + cos(1 + i)])
```


## See also

[matrix](matrix.md),
[rotationMatrix](rotationMatrix.md)
