<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function rotationMatrix

Create a 2-dimensional counter-clockwise rotation matrix (2x2) for a given angle (expressed in radians).
Create a 2-dimensional counter-clockwise rotation matrix (3x3) by a given angle (expressed in radians) around a given axis (1x3).


## Syntax

```js
math.rotationMatrix(theta)
math.rotationMatrix(theta, format)
math.rotationMatrix(theta, [v])
math.rotationMatrix(theta, [v], format)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`theta` | number &#124; BigNumber &#124; Complex &#124; Unit | Rotation angle
`v` | Array &#124; Matrix | Rotation axis
`format` | string | Result Matrix storage format

### Returns

Type | Description
---- | -----------
Array &#124; Matrix | Rotation matrix


### Throws

Type | Description
---- | -----------


## Examples

```js
math.rotationMatrix(math.pi / 2)                      // returns [[0, -1], [1, 0]]
math.rotationMatrix(math.bignumber(1))                // returns [[bignumber(cos(1)), bignumber(-sin(1))], [bignumber(sin(1)), bignumber(cos(1))]]
math.rotationMatrix(math.complex(1 + i))              // returns [[cos(1 + i), -sin(1 + i)], [sin(1 + i), cos(1 + i)]]
math.rotationMatrix(math.unit('1rad'))                // returns [[cos(1), -sin(1)], [sin(1), cos(1)]]

math.rotationMatrix(math.pi / 2, [0, 1, 0])           // returns [[0, 0, 1], [0, 1, 0], [-1, 0, 0]]
math.rotationMatrix(math.pi / 2, matrix([0, 1, 0]))   // returns matrix([[0, 0, 1], [0, 1, 0], [-1, 0, 0]])

```


## See also

[matrix](matrix.md),
[cos](cos.md),
[sin](sin.md)
