<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function sech

Calculate the hyperbolic secant of a value,
defined as `sech(x) = 1 / cosh(x)`.

For matrices, the function is evaluated element wise.


## Syntax

```js
math.sech(x)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | number &#124; Complex &#124; Unit &#124; Array &#124; Matrix | Function input

### Returns

Type | Description
---- | -----------
number &#124; Complex &#124; Array &#124; Matrix | Hyperbolic secant of x


### Throws

Type | Description
---- | -----------


## Examples

```js
// sech(x) = 1/ cosh(x)
math.sech(0.5)       // returns 0.886818883970074
1 / math.cosh(0.5)   // returns 0.886818883970074
```


## See also

[cosh](cosh.md),
[csch](csch.md),
[coth](coth.md)
