<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function simplify

Simplify an expression tree.

A list of rules are applied to an expression, repeating over the list until
no further changes are made.
It's possible to pass a custom set of rules to the function as second
argument. A rule can be specified as an object, string, or function:

    const rules = [
      { l: 'n1*n3 + n2*n3', r: '(n1+n2)*n3' },
      'n1*n3 + n2*n3 -> (n1+n2)*n3',
      function (node) {
        // ... return a new node or return the node unchanged
        return node
      }
    ]

String and object rules consist of a left and right pattern. The left is
used to match against the expression and the right determines what matches
are replaced with. The main difference between a pattern and a normal
expression is that variables starting with the following characters are
interpreted as wildcards:

- 'n' - matches any Node
- 'c' - matches any ConstantNode
- 'v' - matches any Node that is not a ConstantNode

The default list of rules is exposed on the function as `simplify.rules`
and can be used as a basis to built a set of custom rules.

To specify a rule as a string, separate the left and right pattern by '->'
When specifying a rule as an object, the following keys are meaningful:
- l - the left pattern
- r - the right pattern
- s - in lieu of l and r, the string form that is broken at -> to give them
- repeat - whether to repeat this rule until the expression stabilizes
- assuming - gives a context object, as in the 'context' option to
    simplify. Every property in the context object must match the current
    context in order, or else the rule will not be applied.
- imposeContext - gives a context object, as in the 'context' option to
    simplify. Any settings specified will override the incoming context
    for all matches of this rule.

For more details on the theory, see:

- [Strategies for simplifying math expressions (Stackoverflow)](https://stackoverflow.com/questions/7540227/strategies-for-simplifying-math-expressions)
- [Symbolic computation - Simplification (Wikipedia)](https://en.wikipedia.org/wiki/Symbolic_computation#Simplification)

 An optional `options` argument can be passed as last argument of `simplify`.
 Currently available options (defaults in parentheses):
 - `consoleDebug` (false): whether to write the expression being simplified
   and any changes to it, along with the rule responsible, to console
 - `context` (simplify.defaultContext): an object giving properties of
   each operator, which determine what simplifications are allowed. The
   currently meaningful properties are commutative, associative,
   total (whether the operation is defined for all arguments), and
   trivial (whether the operation applied to a single argument leaves
   that argument unchanged). The default context is very permissive and
   allows almost all simplifications. Only properties differing from
   the default need to be specified; the default context is used as a
   fallback. Additional contexts `simplify.realContext` and
   `simplify.positiveContext` are supplied to cause simplify to perform
   just simplifications guaranteed to preserve all values of the expression
   assuming all variables and subexpressions are real numbers or
   positive real numbers, respectively. (Note that these are in some cases
   more restrictive than the default context; for example, the default
   context will allow `x/x` to simplify to 1, whereas
   `simplify.realContext` will not, as `0/0` is not equal to 1.)
 - `exactFractions` (true): whether to try to convert all constants to
   exact rational numbers.
 - `fractionsLimit` (10000): when `exactFractions` is true, constants will
   be expressed as fractions only when both numerator and denominator
   are smaller than `fractionsLimit`.


## Syntax

```js
simplify(expr)
simplify(expr, rules)
simplify(expr, rules)
simplify(expr, rules, scope)
simplify(expr, rules, scope, options)
simplify(expr, scope)
simplify(expr, scope, options)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`expr` | Node &#124; string |  The expression to be simplified
`rules` | Array&lt;{l:string, r: string} &#124; string &#124; function&gt; |  Optional list with custom rules

### Returns

Type | Description
---- | -----------
Node | Returns the simplified form of `expr`


### Throws

Type | Description
---- | -----------


## Examples

```js
math.simplify('2 * 1 * x ^ (2 - 1)')      // Node "2 * x"
math.simplify('2 * 3 * x', {x: 4})        // Node "24"
const f = math.parse('2 * 1 * x ^ (2 - 1)')
math.simplify(f)                          // Node "2 * x"
math.simplify('0.4 * x', {}, {exactFractions: true})  // Node "x * 2 / 5"
math.simplify('0.4 * x', {}, {exactFractions: false}) // Node "0.4 * x"
```


## See also

[simplifyCore](simplifyCore.md),
[derivative](derivative.md),
[evaluate](evaluate.md),
[parse](parse.md),
[rationalize](rationalize.md),
[resolve](resolve.md)
