<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function simplifyCore

simplifyCore() performs single pass simplification suitable for
applications requiring ultimate performance. In contrast, simplify()
extends simplifyCore() with additional passes to provide deeper
simplification.


## Syntax

```js
simplifyCore(expr)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`node` | Node |  The expression to be simplified
`options` | Object |  Simplification options, as per simplify()

### Returns

Type | Description
---- | -----------
Node | Returns expression with basic simplifications applied


### Throws

Type | Description
---- | -----------


## Examples

```js
const f = math.parse('2 * 1 * x ^ (2 - 1)')
math.simpifyCore(f)                          // Node {2 * x}
math.simplify('2 * 1 * x ^ (2 - 1)', [math.simplifyCore]) // Node {2 * x}
```


## See also

[simplify](simplify.md),
[resolve](resolve.md),
[derivative](derivative.md)
