<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function slu

Calculate the Sparse Matrix LU decomposition with full pivoting. Sparse Matrix `A` is decomposed in two matrices (`L`, `U`) and two permutation vectors (`pinv`, `q`) where

`P * A * Q = L * U`


## Syntax

```js
math.slu(A, order, threshold)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`A` | SparseMatrix | A two dimensional sparse matrix for which to get the LU decomposition.
`order` | Number | The Symbolic Ordering and Analysis order: 0 - Natural ordering, no permutation vector q is returned 1 - Matrix must be square, symbolic ordering and analisis is performed on M = A + A' 2 - Symbolic ordering and analisis is performed on M = A' * A. Dense columns from A' are dropped, A recreated from A'. This is appropriatefor LU factorization of unsymmetric matrices. 3 - Symbolic ordering and analisis is performed on M = A' * A. This is best used for LU factorization is matrix M has no dense rows. A dense row is a row with more than 10*sqr(columns) entries.
`threshold` | Number | Partial pivoting threshold (1 for partial pivoting)

### Returns

Type | Description
---- | -----------
Object | The lower triangular matrix, the upper triangular matrix and the permutation vectors.


### Throws

Type | Description
---- | -----------


## Examples

```js
const A = math.sparse([[4,3], [6, 3]])
math.slu(A, 1, 0.001)
// returns:
// {
//   L: [[1, 0], [1.5, 1]]
//   U: [[4, 3], [0, -1.5]]
//   p: [0, 1]
//   q: [0, 1]
// }
```


## See also

[lup](lup.md),
[lsolve](lsolve.md),
[usolve](usolve.md),
[lusolve](lusolve.md)
