<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function squeeze

Squeeze a matrix, remove inner and outer singleton dimensions from a matrix.


## Syntax

```js
math.squeeze(x)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | Matrix &#124; Array | Matrix to be squeezed

### Returns

Type | Description
---- | -----------
Matrix &#124; Array | Squeezed matrix


### Throws

Type | Description
---- | -----------


## Examples

```js
math.squeeze([3])           // returns 3
math.squeeze([[3]])         // returns 3

const A = math.zeros(3, 1)    // returns [[0], [0], [0]] (size 3x1)
math.squeeze(A)             // returns [0, 0, 0] (size 3)

const B = math.zeros(1, 3)    // returns [[0, 0, 0]] (size 1x3)
math.squeeze(B)             // returns [0, 0, 0] (size 3)

// only inner and outer dimensions are removed
const C = math.zeros(2, 1, 3) // returns [[[0, 0, 0]], [[0, 0, 0]]] (size 2x1x3)
math.squeeze(C)             // returns [[[0, 0, 0]], [[0, 0, 0]]] (size 2x1x3)
```


## See also

[subset](subset.md)
