<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function symbolicEqual

Attempts to determine if two expressions are symbolically equal, i.e.
one is the result of valid algebraic manipulations on the other.
Currently, this simply checks if the difference of the two expressions
simplifies down to 0. So there are two important caveats:
1. whether two expressions are symbolically equal depends on the
    manipulations allowed. Therefore, this function takes an optional
    third argument, which are the options that control the behavior
    as documented for the `simplify()` function.
2. it is in general intractable to find the minimal simplification of
    an arbitrarily complicated expression. So while a `true` value
    of `symbolicEqual` ensures that the two expressions can be manipulated
    to match each other, a `false` value does not absolutely rule this out.


## Syntax

```js
symbolicEqual(expr1, expr2)
symbolicEqual(expr1, expr2, options)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`expr1` | Node &#124; string | The first expression to compare
`expr2` | Node &#124; string | The second expression to compare
`options` | Object | Optional option object, passed to simplify

### Returns

Type | Description
---- | -----------
boolean |  Returns true if a valid manipulation making the expressions equal is found.


### Throws

Type | Description
---- | -----------


## Examples

```js
symbolicEqual('x*y', 'y*x') // true
symbolicEqual('x*y', 'y*x', {context: {multiply: {commutative: false}}})
    //false
symbolicEqual('x/y', '(y*x^(-1))^(-1)') // true
symbolicEqual('abs(x)','x') // false
symbolicEqual('abs(x)','x', simplify.positiveContext) // true
```


## See also

[simplify](simplify.md),
[evaluate](evaluate.md)
