<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function variance

Compute the variance of a matrix or a  list with values.
In case of a (multi dimensional) array or matrix, the variance over all
elements will be calculated.

Additionally, it is possible to compute the variance along the rows
or columns of a matrix by specifying the dimension as the second argument.

Optionally, the type of normalization can be specified as the final
parameter. The parameter `normalization` can be one of the following values:

- 'unbiased' (default) The sum of squared errors is divided by (n - 1)
- 'uncorrected'        The sum of squared errors is divided by n
- 'biased'             The sum of squared errors is divided by (n + 1)


Note that older browser may not like the variable name `var`. In that
case, the function can be called as `math['var'](...)` instead of
`math.var(...)`.


## Syntax

```js
math.variance(a, b, c, ...)
math.variance(A)
math.variance(A, normalization)
math.variance(A, dimension)
math.variance(A, dimension, normalization)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`array` | Array &#124; Matrix |  A single matrix or or multiple scalar values
`normalization` | string |  Determines how to normalize the variance. Choose 'unbiased' (default), 'uncorrected', or 'biased'. Default value: 'unbiased'.

### Returns

Type | Description
---- | -----------
* | The variance


### Throws

Type | Description
---- | -----------


## Examples

```js
math.variance(2, 4, 6)                     // returns 4
math.variance([2, 4, 6, 8])                // returns 6.666666666666667
math.variance([2, 4, 6, 8], 'uncorrected') // returns 5
math.variance([2, 4, 6, 8], 'biased')      // returns 4

math.variance([[1, 2, 3], [4, 5, 6]])      // returns 3.5
math.variance([[1, 2, 3], [4, 6, 8]], 0)   // returns [4.5, 8, 12.5]
math.variance([[1, 2, 3], [4, 6, 8]], 1)   // returns [1, 4]
math.variance([[1, 2, 3], [4, 6, 8]], 1, 'biased') // returns [0.5, 2]
```


## See also

[mean](mean.md),
[median](median.md),
[max](max.md),
[min](min.md),
[prod](prod.md),
[std](std.md),
[sum](sum.md)
