# Documentation

[Math.js](http://mathjs.org) is an extensive math library for JavaScript and Node.js.
It features a flexible expression parser and offers an integrated solution
to work with numbers, big numbers, complex numbers, units, and matrices.
Powerful and easy to use.

This documentation of contains a getting started tutorial,
an extensive overview describing math.js on a high level, and a reference 
describing all available functions, constants, and units in detail.


## Getting Started

- [Getting Started](getting_started.md)


## Overview

- [Introduction](introduction.md)
- [Expressions](expressions/index.md)
  - [Parsing and evaluation](expressions/parsing.md)
  - [Syntax](expressions/syntax.md)
  - [Expression trees](expressions/expression_trees.md)
  - [Customization](expressions/customization.md)
- [Chaining](chaining.md)
- [Data Types](datatypes/index.md)
  - [Numbers](datatypes/numbers.md)
  - [BigNumbers](datatypes/bignumbers.md)
  - [Fractions](datatypes/fractions.md)
  - [Complex Numbers](datatypes/complex_numbers.md)
  - [Matrices](datatypes/matrices.md)
  - [Units](datatypes/units.md)
- [Configuration](configuration.md)
- [Serialization](serialization.md)
- [Extension](extension.md)
- [Custom bundling](custom_bundling.md)
- [Command Line Interface](command_line_interface.md)

## Examples

- [Examples](http://mathjs.org/examples/index.html)

## Reference

- [Constants](reference/constants.md)
- [Functions (alphabetical)](reference/functions/alphabetical.md)
- [Functions (categorical)](reference/functions/categorical.md)
- [History](../HISTORY.md)
- [Units](reference/units.md)

