# Function lup

Calculate the Matrix LU decomposition with partial pivoting. Matrix `A` is decomposed in two matrices (`L`, `U`) and a
row permutation vector `p` where `A[p,:] = L * U`


## Syntax

```js
math.lup(A);
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`A` | Matrix &#124; Array | A two dimensional matrix or array for which to get the LUP decomposition.

### Returns

Type | Description
---- | -----------
Array<Matrix> | The lower triangular matrix, the upper triangular matrix and the permutation matrix.


## Examples

```js
var m = [[2, 1], [1, 4]];
var r = math.lup();
// r = {
//   L: [[1, 0], [0.5, 1]],
//   U: [[2, 1], [0, 3.5]],
//   P: [0, 1]
// }
```


## See also

[slu](slu.md),
[lsolve](lsolve.md),
[lusolve](lusolve.md),
[usolve](usolve.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
