# Function rightLogShift

Bitwise right logical shift of value x by y number of bits, `x >>> y`.
For matrices, the function is evaluated element wise.
For units, the function is evaluated on the best prefix base.


## Syntax

```js
math.rightLogShift(x, y)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | number &#124; Array &#124; Matrix | Value to be shifted
`y` | number | Amount of shifts

### Returns

Type | Description
---- | -----------
number &#124; Array &#124; Matrix | `x` zero-filled shifted right `y` times


## Examples

```js
math.rightLogShift(4, 2);               // returns number 1

math.rightLogShift([16, -32, 64], 4);   // returns Array [1, 2, 3]
```


## See also

[bitAnd](bitAnd.md),
[bitNot](bitNot.md),
[bitOr](bitOr.md),
[bitXor](bitXor.md),
[leftShift](leftShift.md),
[rightLogShift](rightLogShift.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
