# Function quantileSeq

Compute the prob order quantile of a matrix or a list with values.
The sequence is sorted and the middle value is returned.
Supported types of sequence values are: Number, BigNumber, Unit
Supported types of probability are: Number, BigNumber

In case of a (multi dimensional) array or matrix, the prob order quantile
of all elements will be calculated.


## Syntax

```js
math.quantileSeq(A, prob[, sorted])
math.quantileSeq(A, [prob1, prob2, ...][, sorted])
math.quantileSeq(A, N[, sorted])
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`data` | Array, Matrix | A single matrix or Array
`probOrN` | Number, BigNumber, Array | prob is the order of the quantile, while N is the amount of evenly distributed steps of probabilities; only one of these options can be provided
`sorted` | Boolean | =false              is data sorted in ascending order

### Returns

Type | Description
---- | -----------
Number, BigNumber, Unit, Array | Quantile(s)


## Examples

```js
math.quantileSeq([3, -1, 5, 7], 0.5);         // returns 4
math.quantileSeq([3, -1, 5, 7], [1/3, 2/3]);  // returns [3, 5]
math.quantileSeq([3, -1, 5, 7], 2);           // returns [3, 5]
math.quantileSeq([-1, 3, 5, 7], 0.5, true);   // returns 4
```


## See also

[median](median.md),
[mean](mean.md),
[min](min.md),
[max](max.md),
[sum](sum.md),
[prod](prod.md),
[std](std.md),
[var](var.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
