# Function var

Compute the variance of a matrix or a  list with values.
In case of a (multi dimensional) array or matrix, the variance over all
elements will be calculated.

Optionally, the type of normalization can be specified as second
parameter. The parameter `normalization` can be one of the following values:

- 'unbiased' (default) The sum of squared errors is divided by (n - 1)
- 'uncorrected'        The sum of squared errors is divided by n
- 'biased'             The sum of squared errors is divided by (n + 1)

Note that older browser may not like the variable name `var`. In that
case, the function can be called as `math['var'](...)` instead of
`math.var(...)`.


## Syntax

```js
math.var(a, b, c, ...)
math.var(A)
math.var(A, normalization)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`array` | Array &#124; Matrix |  A single matrix or or multiple scalar values
`normalization` | string |  Determines how to normalize the variance. Choose 'unbiased' (default), 'uncorrected', or 'biased'. Default value: 'unbiased'.

### Returns

Type | Description
---- | -----------
* | The variance


## Examples

```js
math.var(2, 4, 6);                     // returns 4
math.var([2, 4, 6, 8]);                // returns 6.666666666666667
math.var([2, 4, 6, 8], 'uncorrected'); // returns 5
math.var([2, 4, 6, 8], 'biased');      // returns 4

math.var([[1, 2, 3], [4, 5, 6]]);      // returns 3.5
```


## See also

[mean](mean.md),
[median](median.md),
[max](max.md),
[min](min.md),
[prod](prod.md),
[std](std.md),
[sum](sum.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
