# Function xgcd

Calculate the extended greatest common divisor for two values.
See http://en.wikipedia.org/wiki/Extended_Euclidean_algorithm.


## Syntax

```js
math.xgcd(a, b)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`a` | number &#124; BigNumber | An integer number
`b` | number &#124; BigNumber | An integer number

### Returns

Type | Description
---- | -----------
Array | Returns an array containing 3 integers `[div, m, n]` where `div = gcd(a, b)` and `a*m + b*n = div`


## Examples

```js
math.xgcd(8, 12);             // returns [4, -1, 1]
math.gcd(8, 12);              // returns 4
math.xgcd(36163, 21199);      // returns [1247, -7, 12]
```


## See also

[gcd](gcd.md),
[lcm](lcm.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
