# Function distance

Calculates:
   The eucledian distance between two points in 2 and 3 dimensional spaces.
   Distance between point and a line in 2 and 3 dimensional spaces.
   Pairwise distance between a set of 2D or 3D points
NOTE:
   When substituting coefficients of a line(a, b and c), use ax + by + c = 0 instead of ax + by = c
   For parametric equation of a 3D line, x0, y0, z0, a, b, c are from: (x−x0, y−y0, z−z0) = t(a, b, c)


## Syntax

```js
math.distance([x1, y1], [x2, y2])
 math.distance({pointOneX: 4, pointOneY: 5}, {pointTwoX: 2, pointTwoY: 7})
math.distance([x1, y1, z1], [x2, y2, z2])
math.distance({pointOneX: 4, pointOneY: 5, pointOneZ: 8}, {pointTwoX: 2, pointTwoY: 7, pointTwoZ: 9})
math.distance([[A], [B], [C]...])
math.distance([x1, y1], [LinePtX1, LinePtY1], [LinePtX2, LinePtY2])
math.distance({pointX: 1, pointY: 4}, {lineOnePtX: 6, lineOnePtY: 3}, {lineTwoPtX: 2, lineTwoPtY: 8})
math.distance([x1, y1, z1], [LinePtX1, LinePtY1, LinePtZ1], [LinePtX2, LinePtY2, LinePtZ2])
math.distance({pointX: 1, pointY: 4, pointZ: 7}, {lineOnePtX: 6, lineOnePtY: 3, lineOnePtZ: 4}, {lineTwoPtX: 2, lineTwoPtY: 8, lineTwoPtZ: 5})
math.distance([x1, y1], [xCoeffLine, yCoeffLine, constant])
math.distance({pointX: 10, pointY: 10}, {xCoeffLine: 8, yCoeffLine: 1, constant: 3})
math.distance([x1, y1, z1], [x0, y0, z0, a-tCoeff, b-tCoeff, c-tCoeff]) point and parametric equation of 3D line
math.distance([x, y, z], [x0, y0, z0, a, b, c])
math.distance({pointX: 2, pointY: 5, pointZ: 9}, {x0: 4, y0: 6, z0: 3, a: 4, b: 2, c: 0})
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | Array &#124; Matrix &#124; Object | Co-ordinates of first point
`y` | Array &#124; Matrix &#124; Object | Co-ordinates of second point

### Returns

Type | Description
---- | -----------
Number &#124; BigNumber | Returns the distance from two/three points


## Examples

```js
math.distance([0,0], [4,4])                     // Returns 5.6569
math.distance(
 {pointOneX: 0, pointOneY: 0},
 {pointTwoX: 10, pointTwoY: 10})                // Returns 14.142135623730951
math.distance([1, 0, 1], [4, -2, 2])            // Returns 3.74166
math.distance(
 {pointOneX: 4, pointOneY: 5, pointOneZ: 8},
 {pointTwoX: 2, pointTwoY: 7, pointTwoZ: 9})    // Returns 3
math.distance([[1, 2], [1, 2], [1, 3]])         // Returns [0, 1, 1]
math.distance([[1,2,4], [1,2,6], [8,1,3]])      // Returns [2, 7.14142842854285, 7.681145747868608]
math.distance([10, 10], [8, 1, 3])              // Returns 11.535230316796387
math.distance([10, 10], [2, 3], [-8, 0])        // Returns 8.759953130362847
math.distance(
 {pointX: 1, pointY: 4},
 {lineOnePtX: 6, lineOnePtY: 3},
 {lineTwoPtX: 2, lineTwoPtY: 8})                // Returns 2.720549372624744
math.distance([2, 3, 1], [1, 1, 2, 5, 0, 1])    // Returns 2.3204774044612857
math.distance(
 {pointX: 2, pointY: 3, pointZ: 1},
 {x0: 1, y0: 1, z0: 2, a: 5, b: 0, c: 1}        // Returns 2.3204774044612857
```




<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
