# Function divide

Divide two values, `x / y`.
To divide matrices, `x` is multiplied with the inverse of `y`: `x * inv(y)`.


## Syntax

```js
math.divide(x, y)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | number &#124; BigNumber &#124; Fraction &#124; Complex &#124; Unit &#124; Array &#124; Matrix | Numerator
`y` | number &#124; BigNumber &#124; Fraction &#124; Complex &#124; Array &#124; Matrix | Denominator

### Returns

Type | Description
---- | -----------
number &#124; BigNumber &#124; Fraction &#124; Complex &#124; Unit &#124; Array &#124; Matrix | Quotient, `x / y`


## Examples

```js
math.divide(2, 3);            // returns number 0.6666666666666666

var a = math.complex(5, 14);
var b = math.complex(4, 1);
math.divide(a, b);            // returns Complex 2 + 3i

var c = [[7, -6], [13, -4]];
var d = [[1, 2], [4, 3]];
math.divide(c, d);            // returns Array [[-9, 4], [-11, 6]]

var e = math.unit('18 km');
math.divide(e, 4.5);          // returns Unit 4 km
```


## See also

[multiply](multiply.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
