# Function isNumeric

Test whether a value is an numeric value.

The function is evaluated element-wise in case of Array or Matrix input.


## Syntax

```js
math.isNumeric(x)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | * | Value to be tested

### Returns

Type | Description
---- | -----------
boolean | Returns true when `x` is a `number`, `BigNumber`, `Fraction`, or `boolean`. Returns false for other types. Throws an error in case of unknown types.


## Examples

```js
math.isNumeric(2);                     // returns true
math.isNumeric(0);                     // returns true
math.isNumeric(math.bignumber(500));   // returns true
math.isNumeric(math.fraction(4));      // returns true
math.isNumeric(math.complex('2 - 4i'); // returns false
math.isNumeric('3');                   // returns false
math.isNumeric([2.3, 'foo', false]);   // returns [true, false, true]
```


## See also

[isZero](isZero.md),
[isPositive](isPositive.md),
[isNegative](isNegative.md),
[isInteger](isInteger.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
