# Function parse

Parse an expression. Returns a node tree, which can be evaluated by
invoking node.eval();


## Syntax

```js
parse(expr)
parse(expr, options)
parse([expr1, expr2, expr3, ...])
parse([expr1, expr2, expr3, ...], options)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`expr` | string &#124; string[] &#124; Matrix | Expression to be parsed
`options` | {nodes: Object<string, Node>} | Available options: - `nodes` a set of custom nodes

### Returns

Type | Description
---- | -----------
Node &#124; Node[] | node


## Examples

```js
var node = parse('sqrt(3^2 + 4^2)');
node.compile().eval(); // 5

var scope = {a:3, b:4}
var node = parse('a * b'); // 12
var code = node.compile();
code.eval(scope); // 12
scope.a = 5;
code.eval(scope); // 20

var nodes = math.parse(['a = 3', 'b = 4', 'a * b']);
nodes[2].compile().eval(); // 12
```


## See also

[eval](eval.md),
[compile](compile.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
