# Function string

Create a string or convert any object into a string.
Elements of Arrays and Matrices are processed element wise.


## Syntax

```js
math.string(value)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`value` | * &#124; Array &#124; Matrix &#124; null | A value to convert to a string

### Returns

Type | Description
---- | -----------
string &#124; Array &#124; Matrix | The created string


## Examples

```js
math.string(4.2);               // returns string '4.2'
math.string(math.complex(3, 2); // returns string '3 + 2i'

var u = math.unit(5, 'km');
math.string(u.to('m'));         // returns string '5000 m'

math.string([true, false]);     // returns ['true', 'false']
```


## See also

[bignumber](bignumber.md),
[boolean](boolean.md),
[complex](complex.md),
[index](index.md),
[matrix](matrix.md),
[number](number.md),
[unit](unit.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
