# Function acsc

Calculate the inverse cosecant of a value, defined as `acsc(x) = asin(1/x)`.

For matrices, the function is evaluated element wise.


## Syntax

```js
math.acsc(x)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | number &#124; Complex &#124; Array &#124; Matrix | Function input

### Returns

Type | Description
---- | -----------
number &#124; Complex &#124; Array &#124; Matrix | The arc cosecant of x


## Examples

```js
math.acsc(0.5);           // returns number 0.5235987755982989
math.acsc(math.csc(1.5)); // returns number ~1.5

math.acsc(2);             // returns Complex 1.5707963267948966 -1.3169578969248166 i
```


## See also

[csc](csc.md),
[asin](asin.md),
[asec](asec.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
