# Function hypot

Calculate the hypotenusa of a list with values. The hypotenusa is defined as:

    hypot(a, b, c, ...) = sqrt(a^2 + b^2 + c^2 + ...)

For matrix input, the hypotenusa is calculated for all values in the matrix.


## Syntax

```js
math.hypot(a, b, ...)
math.hypot([a, b, c, ...])
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`args` | ... number &#124; BigNumber | 

### Returns

Type | Description
---- | -----------
number &#124; BigNumber | Returns the hypothenusa of the input values.


## Examples

```js
math.hypot(3, 4);      // 5
math.hypot(3, 4, 5);   // 7.0710678118654755
math.hypot([3, 4, 5]); // 7.0710678118654755
math.hypot(-2);        // 2
```


## See also

[abs](abs.md),
[norm](norm.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
