# Function pow

Calculates the power of x to y, `x ^ y`.
Matrix exponentiation is supported for square matrices `x`, and positive
integer exponents `y`.

For cubic roots of negative numbers, the function returns the principal
root by default. In order to let the function return the real root,
math.js can be configured with `math.config({predictable: true})`.
To retrieve all cubic roots of a value, use `math.cbrt(x, true)`.


## Syntax

```js
math.pow(x, y)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | number &#124; BigNumber &#124; Complex &#124; Array &#124; Matrix | The base
`y` | number &#124; BigNumber &#124; Complex | The exponent

### Returns

Type | Description
---- | -----------
number &#124; BigNumber &#124; Complex &#124; Array &#124; Matrix | The value of `x` to the power `y`


## Examples

```js
math.pow(2, 3);               // returns number 8

var a = math.complex(2, 3);
math.pow(a, 2)                // returns Complex -5 + 12i

var b = [[1, 2], [4, 3]];
math.pow(b, 2);               // returns Array [[9, 8], [16, 17]]
```


## See also

[multiply](multiply.md),
[sqrt](sqrt.md),
[cbrt](cbrt.md),
[nthRoot](nthRoot.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
