# Function range

Create an array from a range.
By default, the range end is excluded. This can be customized by providing
an extra parameter `includeEnd`.


## Syntax

```js
math.range(str [, includeEnd])               // Create a range from a string,
                                             // where the string contains the
                                             // start, optional step, and end,
                                             // separated by a colon.
math.range(start, end [, includeEnd])        // Create a range with start and
                                             // end and a step size of 1.
math.range(start, end, step [, includeEnd])  // Create a range with start, step,
                                             // and end.
```

### Where

- `str: string`
  A string 'start:end' or 'start:step:end'
- `start: {number | BigNumber}`
  Start of the range
- `end: number | BigNumber`
  End of the range, excluded by default, included when parameter includeEnd=true
- `step: number | BigNumber`
  Step size. Default value is 1.
- `includeEnd: boolean`
  Option to specify whether to include the end or not. False by default.

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`args` | * | Parameters describing the ranges `start`, `end`, and optional `step`.

### Returns

Type | Description
---- | -----------
Array &#124; Matrix | range


## Examples

```js
math.range(2, 6);        // [2, 3, 4, 5]
math.range(2, -3, -1);   // [2, 1, 0, -1, -2]
math.range('2:1:6');     // [2, 3, 4, 5]
math.range(2, 6, true);  // [2, 3, 4, 5, 6]
```


## See also

[ones](ones.md),
[zeros](zeros.md),
[size](size.md),
[subset](subset.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
