# Function sign

Compute the sign of a value. The sign of a value x is:

-  1 when x > 1
- -1 when x < 0
-  0 when x == 0

For matrices, the function is evaluated element wise.


## Syntax

```js
math.sign(x)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | number &#124; BigNumber &#124; Fraction &#124; Complex &#124; Array &#124; Matrix &#124; Unit |  The number for which to determine the sign

### Returns

Type | Description
---- | -----------
number &#124; BigNumber &#124; Fraction &#124; Complex &#124; Array &#124; Matrix &#124; Unit | e The sign of `x`


## Examples

```js
math.sign(3.5);               // returns 1
math.sign(-4.2);              // returns -1
math.sign(0);                 // returns 0

math.sign([3, 5, -2, 0, 2]);  // returns [1, 1, -1, 0, 1]
```


## See also

[abs](abs.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
