<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function derivative

Takes the derivative of an expression expressed in parser Nodes.
The derivative will be taken over the supplied variable in the
second parameter. If there are multiple variables in the expression,
it will return a partial derivative.

This uses rules of differentiation which can be found here:

- [Differentiation rules (Wikipedia)](http://en.wikipedia.org/wiki/Differentiation_rules)


## Syntax

```js
derivative(expr, variable)
derivative(expr, variable, options)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`expr` | Node &#124; string | The expression to differentiate
`variable` | SymbolNode &#124; string | The variable over which to differentiate
`options` | {simplify: boolean} |  There is one option available, `simplify`, which is true by default. When false, output will not be simplified.

### Returns

Type | Description
---- | -----------
ConstantNode &#124; SymbolNode &#124; ParenthesisNode &#124; FunctionNode &#124; OperatorNode | The derivative of `expr`


## Examples

```js
math.derivative('x^2', 'x');                     // Node {2 * x}
math.derivative('x^2', 'x', {simplify: false});  // Node {2 * 1 * x ^ (2 - 1)
math.derivative('sin(2x)', 'x'));                // Node {2 * cos(2 * x)}
math.derivative('2*x', 'x').eval();              // number 2
math.derivative('x^2', 'x').eval({x: 4});        // number 8
var f = math.parse('x^2');
var x = math.parse('x');
math.derivative(f, x);                           // Node {2 * x}
```


## See also

[simplify](simplify.md),
[parse](parse.md),
[eval](eval.md)
