<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function asec

Calculate the inverse secant of a value. Defined as `asec(x) = acos(1/x)`.

For matrices, the function is evaluated element wise.


## Syntax

```js
math.asec(x)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | number &#124; Complex &#124; Array &#124; Matrix | Function input

### Returns

Type | Description
---- | -----------
number &#124; Complex &#124; Array &#124; Matrix | The arc secant of x


## Examples

```js
math.asec(0.5);           // returns 1.0471975511965979
math.asec(math.sec(1.5)); // returns 1.5

math.asec(2);             // returns 0 + 1.3169578969248166 i
```


## See also

[acos](acos.md),
[acot](acot.md),
[acsc](acsc.md)
