<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function createUnit

Create a user-defined unit and register it with the Unit type.


## Syntax

```js
math.createUnit({
  baseUnit1: {
    aliases: [string, ...]
    prefixes: object
  },
  unit2: {
    definition: string,
    aliases: [string, ...]
    prefixes: object,
    offset: number
  },
  unit3: string    // Shortcut
})
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`name` | string | The name of the new unit. Must be unique. Example: 'knot'
`definition` | string, Unit | Definition of the unit in terms of existing units. For example, '0.514444444 m / s'.
`options` | Object | (optional) An object containing any of the following properties:

### Returns

Type | Description
---- | -----------
Unit | The new unit


## Examples

```js
math.createUnit('foo');
math.createUnit('knot', {definition: '0.514444444 m/s', aliases: ['knots', 'kt', 'kts]});
math.createUnit('mph', '1 mile/hour');
```


## See also

[unit](unit.md)
