<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function cross

Calculate the cross product for two vectors in three dimensional space.
The cross product of `A = [a1, a2, a3]` and `B = [b1, b2, b3]` is defined
as:

   cross(A, B) = [
     a2 * b3 - a3 * b2,
     a3 * b1 - a1 * b3,
     a1 * b2 - a2 * b1
   ]

If one of the input vectors has a dimension greater than 1, the output
vector will be a 1x3 (2-dimensional) matrix.


## Syntax

```js
math.cross(x, y)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | Array &#124; Matrix | First vector
`y` | Array &#124; Matrix | Second vector

### Returns

Type | Description
---- | -----------
Array &#124; Matrix | Returns the cross product of `x` and `y`


## Examples

```js
math.cross([1, 1, 0],   [0, 1, 1]);       // Returns [1, -1, 1]
math.cross([3, -3, 1],  [4, 9, 2]);       // Returns [-15, -2, 39]
math.cross([2, 3, 4],   [5, 6, 7]);       // Returns [-3, 6, -3]
math.cross([[1, 2, 3]], [[4], [5], [6]]); // Returns [[-3, 6, -3]]
```


## See also

[dot](dot.md),
[multiply](multiply.md)
