<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function expm

Compute the matrix exponential, expm(A) = e^A. The matrix must be square.
Not to be confused with exp(a), which performs element-wise
exponentiation.

The exponential is calculated using the Padé approximant with scaling and
squaring; see "Nineteen Dubious Ways to Compute the Exponential of a
Matrix," by Moler and Van Loan.


## Syntax

```js
math.expm(x)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | Matrix | A square Matrix

### Returns

Type | Description
---- | -----------
Matrix | The exponential of x


## Examples

```js
var A = [[0,2],[0,0]]
math.expm(A);        // returns [[1,2],[0,1]]
```


## See also

[exp](exp.md)
