<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function lcm

Calculate the least common multiple for two or more values or arrays.

lcm is defined as:

    lcm(a, b) = abs(a * b) / gcd(a, b)

For matrices, the function is evaluated element wise.


## Syntax

```js
math.lcm(a, b)
math.lcm(a, b, c, ...)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`args` | ... number &#124; BigNumber &#124; Array &#124; Matrix | Two or more integer numbers

### Returns

Type | Description
---- | -----------
number &#124; BigNumber &#124; Array &#124; Matrix | The least common multiple


## Examples

```js
math.lcm(4, 6)               // returns 12
math.lcm(6, 21)              // returns 42
math.lcm(6, 21, 5)           // returns 210

math.lcm([4, 6], [6, 21])    // returns [12, 42]
```


## See also

[gcd](gcd.md),
[xgcd](xgcd.md)
