<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function parse

Parse an expression. Returns a node tree, which can be evaluated by
invoking node.evaluate().

Note the evaluating arbitrary expressions may involve security risks,
see [https://mathjs.org/docs/expressions/security.html](https://mathjs.org/docs/expressions/security.html) for more information.


## Syntax

```js
math.parse(expr)
math.parse(expr, options)
math.parse([expr1, expr2, expr3, ...])
math.parse([expr1, expr2, expr3, ...], options)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`expr` | string &#124; string[] &#124; Matrix | Expression to be parsed
`options` | {nodes: Object&lt;string, Node&gt;} | Available options:</br>- `nodes` a set of custom nodes

### Returns

Type | Description
---- | -----------
Node &#124; Node[] | node


## Examples

```js
const node1 = math.parse('sqrt(3^2 + 4^2)')
node1.compile().evaluate() // 5

let scope = {a:3, b:4}
const node2 = math.parse('a * b') // 12
const code2 = node2.compile()
code2.evaluate(scope) // 12
scope.a = 5
code2.evaluate(scope) // 20

const nodes = math.parse(['a = 3', 'b = 4', 'a * b'])
nodes[2].compile().evaluate() // 12
```


## See also

[evaluate](evaluate.md),
[compile](compile.md)
