<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function subset

Get or set a subset of a matrix or string.


## Syntax

```js
math.subset(value, index)                                // retrieve a subset
math.subset(value, index, replacement [, defaultValue])  // replace a subset
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`matrix` | Array &#124; Matrix &#124; string | An array, matrix, or string
`index` | Index | An index containing ranges for each dimension
`replacement` | * | An array, matrix, or scalar. If provided, the subset is replaced with replacement. If not provided, the subset is returned
`defaultValue` | * | Default value, filled in on new entries when the matrix is resized. If not provided, math.matrix elements will be left undefined. Default value: undefined.

### Returns

Type | Description
---- | -----------
Array &#124; Matrix &#124; string | Either the retrieved subset or the updated matrix.


## Examples

```js
// get a subset
const d = [[1, 2], [3, 4]]
math.subset(d, math.index(1, 0))        // returns 3
math.subset(d, math.index([0, 1], 1))   // returns [[2], [4]]

// replace a subset
const e = []
const f = math.subset(e, math.index(0, [0, 2]), [5, 6])  // f = [[5, 6]]
const g = math.subset(f, math.index(1, 1), 7, 0)         // g = [[5, 6], [0, 7]]
```


## See also

[size](size.md),
[resize](resize.md),
[squeeze](squeeze.md),
[index](index.md)
