<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function xor

Logical `xor`. Test whether one and only one value is defined with a nonzero/nonempty value.
For matrices, the function is evaluated element wise.


## Syntax

```js
math.xor(x, y)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | number &#124; BigNumber &#124; Complex &#124; Unit &#124; Array &#124; Matrix | First value to check
`y` | number &#124; BigNumber &#124; Complex &#124; Unit &#124; Array &#124; Matrix | Second value to check

### Returns

Type | Description
---- | -----------
boolean &#124; Array &#124; Matrix |  Returns true when one and only one input is defined with a nonzero/nonempty value.


## Examples

```js
math.xor(2, 4)   // returns false

a = [2, 0, 0]
b = [2, 7, 0]
c = 0

math.xor(a, b)   // returns [false, true, false]
math.xor(a, c)   // returns [true, false, false]
```


## See also

[and](and.md),
[not](not.md),
[or](or.md)
