<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function zeros

Create a matrix filled with zeros. The created matrix can have one or
multiple dimensions.


## Syntax

```js
math.zeros(m)
math.zeros(m, format)
math.zeros(m, n)
math.zeros(m, n, format)
math.zeros([m, n])
math.zeros([m, n], format)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`size` | ...number &#124; Array | The size of each dimension of the matrix
`format` | string | The Matrix storage format

### Returns

Type | Description
---- | -----------
Array &#124; Matrix | A matrix filled with zeros


## Examples

```js
math.zeros(3)                  // returns [0, 0, 0]
math.zeros(3, 2)               // returns [[0, 0], [0, 0], [0, 0]]
math.zeros(3, 'dense')         // returns [0, 0, 0]

const A = [[1, 2, 3], [4, 5, 6]]
math.zeros(math.size(A))       // returns [[0, 0, 0], [0, 0, 0]]
```


## See also

[ones](ones.md),
[identity](identity.md),
[size](size.md),
[range](range.md)
