"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "createTyped", {
  enumerable: true,
  get: function get() {
    return _typed.createTyped;
  }
});
Object.defineProperty(exports, "createResultSet", {
  enumerable: true,
  get: function get() {
    return _ResultSet.createResultSet;
  }
});
Object.defineProperty(exports, "createRangeClass", {
  enumerable: true,
  get: function get() {
    return _Range.createRangeClass;
  }
});
Object.defineProperty(exports, "createHelpClass", {
  enumerable: true,
  get: function get() {
    return _Help.createHelpClass;
  }
});
Object.defineProperty(exports, "createChainClass", {
  enumerable: true,
  get: function get() {
    return _Chain.createChainClass;
  }
});
Object.defineProperty(exports, "createHelp", {
  enumerable: true,
  get: function get() {
    return _help.createHelp;
  }
});
Object.defineProperty(exports, "createChain", {
  enumerable: true,
  get: function get() {
    return _chain.createChain;
  }
});
Object.defineProperty(exports, "createSimplify", {
  enumerable: true,
  get: function get() {
    return _simplify.createSimplify;
  }
});
Object.defineProperty(exports, "createDerivative", {
  enumerable: true,
  get: function get() {
    return _derivative.createDerivative;
  }
});
Object.defineProperty(exports, "createRationalize", {
  enumerable: true,
  get: function get() {
    return _rationalize.createRationalize;
  }
});
Object.defineProperty(exports, "createNthRoot", {
  enumerable: true,
  get: function get() {
    return _nthRoot.createNthRootNumber;
  }
});
Object.defineProperty(exports, "createRound", {
  enumerable: true,
  get: function get() {
    return _round.createRoundNumber;
  }
});
Object.defineProperty(exports, "createHypot", {
  enumerable: true,
  get: function get() {
    return _hypot.createHypot;
  }
});
Object.defineProperty(exports, "createStirlingS2", {
  enumerable: true,
  get: function get() {
    return _stirlingS.createStirlingS2;
  }
});
Object.defineProperty(exports, "createBellNumbers", {
  enumerable: true,
  get: function get() {
    return _bellNumbers.createBellNumbers;
  }
});
Object.defineProperty(exports, "createCatalan", {
  enumerable: true,
  get: function get() {
    return _catalan.createCatalan;
  }
});
Object.defineProperty(exports, "createComposition", {
  enumerable: true,
  get: function get() {
    return _composition.createComposition;
  }
});
Object.defineProperty(exports, "createE", {
  enumerable: true,
  get: function get() {
    return _constants.createE;
  }
});
Object.defineProperty(exports, "createUppercaseE", {
  enumerable: true,
  get: function get() {
    return _constants.createUppercaseE;
  }
});
Object.defineProperty(exports, "createFalse", {
  enumerable: true,
  get: function get() {
    return _constants.createFalse;
  }
});
Object.defineProperty(exports, "createInfinity", {
  enumerable: true,
  get: function get() {
    return _constants.createInfinity;
  }
});
Object.defineProperty(exports, "createLN10", {
  enumerable: true,
  get: function get() {
    return _constants.createLN10;
  }
});
Object.defineProperty(exports, "createLN2", {
  enumerable: true,
  get: function get() {
    return _constants.createLN2;
  }
});
Object.defineProperty(exports, "createLOG10E", {
  enumerable: true,
  get: function get() {
    return _constants.createLOG10E;
  }
});
Object.defineProperty(exports, "createLOG2E", {
  enumerable: true,
  get: function get() {
    return _constants.createLOG2E;
  }
});
Object.defineProperty(exports, "createNaN", {
  enumerable: true,
  get: function get() {
    return _constants.createNaN;
  }
});
Object.defineProperty(exports, "createNull", {
  enumerable: true,
  get: function get() {
    return _constants.createNull;
  }
});
Object.defineProperty(exports, "createPhi", {
  enumerable: true,
  get: function get() {
    return _constants.createPhi;
  }
});
Object.defineProperty(exports, "createPi", {
  enumerable: true,
  get: function get() {
    return _constants.createPi;
  }
});
Object.defineProperty(exports, "createUppercasePi", {
  enumerable: true,
  get: function get() {
    return _constants.createUppercasePi;
  }
});
Object.defineProperty(exports, "createSQRT1_2", {
  enumerable: true,
  get: function get() {
    return _constants.createSQRT1_2;
  }
});
Object.defineProperty(exports, "createSQRT2", {
  enumerable: true,
  get: function get() {
    return _constants.createSQRT2;
  }
});
Object.defineProperty(exports, "createTau", {
  enumerable: true,
  get: function get() {
    return _constants.createTau;
  }
});
Object.defineProperty(exports, "createTrue", {
  enumerable: true,
  get: function get() {
    return _constants.createTrue;
  }
});
Object.defineProperty(exports, "createVersion", {
  enumerable: true,
  get: function get() {
    return _constants.createVersion;
  }
});
Object.defineProperty(exports, "createNumber", {
  enumerable: true,
  get: function get() {
    return _number2.createNumber;
  }
});
Object.defineProperty(exports, "createString", {
  enumerable: true,
  get: function get() {
    return _string.createString;
  }
});
Object.defineProperty(exports, "createBoolean", {
  enumerable: true,
  get: function get() {
    return _boolean.createBoolean;
  }
});
Object.defineProperty(exports, "createParser", {
  enumerable: true,
  get: function get() {
    return _parser.createParser;
  }
});
Object.defineProperty(exports, "createNode", {
  enumerable: true,
  get: function get() {
    return _Node.createNode;
  }
});
Object.defineProperty(exports, "createAccessorNode", {
  enumerable: true,
  get: function get() {
    return _AccessorNode.createAccessorNode;
  }
});
Object.defineProperty(exports, "createArrayNode", {
  enumerable: true,
  get: function get() {
    return _ArrayNode.createArrayNode;
  }
});
Object.defineProperty(exports, "createAssignmentNode", {
  enumerable: true,
  get: function get() {
    return _AssignmentNode.createAssignmentNode;
  }
});
Object.defineProperty(exports, "createBlockNode", {
  enumerable: true,
  get: function get() {
    return _BlockNode.createBlockNode;
  }
});
Object.defineProperty(exports, "createConditionalNode", {
  enumerable: true,
  get: function get() {
    return _ConditionalNode.createConditionalNode;
  }
});
Object.defineProperty(exports, "createConstantNode", {
  enumerable: true,
  get: function get() {
    return _ConstantNode.createConstantNode;
  }
});
Object.defineProperty(exports, "createFunctionAssignmentNode", {
  enumerable: true,
  get: function get() {
    return _FunctionAssignmentNode.createFunctionAssignmentNode;
  }
});
Object.defineProperty(exports, "createIndexNode", {
  enumerable: true,
  get: function get() {
    return _IndexNode.createIndexNode;
  }
});
Object.defineProperty(exports, "createObjectNode", {
  enumerable: true,
  get: function get() {
    return _ObjectNode.createObjectNode;
  }
});
Object.defineProperty(exports, "createOperatorNode", {
  enumerable: true,
  get: function get() {
    return _OperatorNode.createOperatorNode;
  }
});
Object.defineProperty(exports, "createParenthesisNode", {
  enumerable: true,
  get: function get() {
    return _ParenthesisNode.createParenthesisNode;
  }
});
Object.defineProperty(exports, "createRangeNode", {
  enumerable: true,
  get: function get() {
    return _RangeNode.createRangeNode;
  }
});
Object.defineProperty(exports, "createRelationalNode", {
  enumerable: true,
  get: function get() {
    return _RelationalNode.createRelationalNode;
  }
});
Object.defineProperty(exports, "createSymbolNode", {
  enumerable: true,
  get: function get() {
    return _SymbolNode.createSymbolNode;
  }
});
Object.defineProperty(exports, "createFunctionNode", {
  enumerable: true,
  get: function get() {
    return _FunctionNode.createFunctionNode;
  }
});
Object.defineProperty(exports, "createParse", {
  enumerable: true,
  get: function get() {
    return _parse.createParse;
  }
});
Object.defineProperty(exports, "createCompile", {
  enumerable: true,
  get: function get() {
    return _compile.createCompile;
  }
});
Object.defineProperty(exports, "createEvaluate", {
  enumerable: true,
  get: function get() {
    return _evaluate.createEvaluate;
  }
});
Object.defineProperty(exports, "createParserClass", {
  enumerable: true,
  get: function get() {
    return _Parser.createParserClass;
  }
});
Object.defineProperty(exports, "createApply", {
  enumerable: true,
  get: function get() {
    return _apply.createApply;
  }
});
Object.defineProperty(exports, "createFilter", {
  enumerable: true,
  get: function get() {
    return _filter.createFilter;
  }
});
Object.defineProperty(exports, "createForEach", {
  enumerable: true,
  get: function get() {
    return _forEach.createForEach;
  }
});
Object.defineProperty(exports, "createMap", {
  enumerable: true,
  get: function get() {
    return _map.createMap;
  }
});
Object.defineProperty(exports, "createRange", {
  enumerable: true,
  get: function get() {
    return _range.createRange;
  }
});
Object.defineProperty(exports, "createSize", {
  enumerable: true,
  get: function get() {
    return _size.createSize;
  }
});
Object.defineProperty(exports, "createPartitionSelect", {
  enumerable: true,
  get: function get() {
    return _partitionSelect.createPartitionSelect;
  }
});
Object.defineProperty(exports, "createFactorial", {
  enumerable: true,
  get: function get() {
    return _factorial.createFactorial;
  }
});
Object.defineProperty(exports, "createMultinomial", {
  enumerable: true,
  get: function get() {
    return _multinomial.createMultinomial;
  }
});
Object.defineProperty(exports, "createPermutations", {
  enumerable: true,
  get: function get() {
    return _permutations.createPermutations;
  }
});
Object.defineProperty(exports, "createPickRandom", {
  enumerable: true,
  get: function get() {
    return _pickRandom.createPickRandom;
  }
});
Object.defineProperty(exports, "createRandom", {
  enumerable: true,
  get: function get() {
    return _random.createRandomNumber;
  }
});
Object.defineProperty(exports, "createRandomInt", {
  enumerable: true,
  get: function get() {
    return _randomInt.createRandomInt;
  }
});
Object.defineProperty(exports, "createEqualScalar", {
  enumerable: true,
  get: function get() {
    return _equalScalar.createEqualScalarNumber;
  }
});
Object.defineProperty(exports, "createCompare", {
  enumerable: true,
  get: function get() {
    return _compare.createCompareNumber;
  }
});
Object.defineProperty(exports, "createCompareNatural", {
  enumerable: true,
  get: function get() {
    return _compareNatural.createCompareNatural;
  }
});
Object.defineProperty(exports, "createCompareText", {
  enumerable: true,
  get: function get() {
    return _compareText.createCompareTextNumber;
  }
});
Object.defineProperty(exports, "createEqual", {
  enumerable: true,
  get: function get() {
    return _equal.createEqualNumber;
  }
});
Object.defineProperty(exports, "createEqualText", {
  enumerable: true,
  get: function get() {
    return _equalText.createEqualText;
  }
});
Object.defineProperty(exports, "createSmaller", {
  enumerable: true,
  get: function get() {
    return _smaller.createSmallerNumber;
  }
});
Object.defineProperty(exports, "createSmallerEq", {
  enumerable: true,
  get: function get() {
    return _smallerEq.createSmallerEqNumber;
  }
});
Object.defineProperty(exports, "createLarger", {
  enumerable: true,
  get: function get() {
    return _larger.createLargerNumber;
  }
});
Object.defineProperty(exports, "createLargerEq", {
  enumerable: true,
  get: function get() {
    return _largerEq.createLargerEqNumber;
  }
});
Object.defineProperty(exports, "createDeepEqual", {
  enumerable: true,
  get: function get() {
    return _deepEqual.createDeepEqual;
  }
});
Object.defineProperty(exports, "createUnequal", {
  enumerable: true,
  get: function get() {
    return _unequal.createUnequalNumber;
  }
});
Object.defineProperty(exports, "createErf", {
  enumerable: true,
  get: function get() {
    return _erf.createErf;
  }
});
Object.defineProperty(exports, "createMode", {
  enumerable: true,
  get: function get() {
    return _mode.createMode;
  }
});
Object.defineProperty(exports, "createProd", {
  enumerable: true,
  get: function get() {
    return _prod.createProd;
  }
});
Object.defineProperty(exports, "createMax", {
  enumerable: true,
  get: function get() {
    return _max.createMax;
  }
});
Object.defineProperty(exports, "createMin", {
  enumerable: true,
  get: function get() {
    return _min.createMin;
  }
});
Object.defineProperty(exports, "createSum", {
  enumerable: true,
  get: function get() {
    return _sum.createSum;
  }
});
Object.defineProperty(exports, "createMean", {
  enumerable: true,
  get: function get() {
    return _mean.createMean;
  }
});
Object.defineProperty(exports, "createMedian", {
  enumerable: true,
  get: function get() {
    return _median.createMedian;
  }
});
Object.defineProperty(exports, "createMad", {
  enumerable: true,
  get: function get() {
    return _mad.createMad;
  }
});
Object.defineProperty(exports, "createVariance", {
  enumerable: true,
  get: function get() {
    return _variance.createVariance;
  }
});
Object.defineProperty(exports, "createQuantileSeq", {
  enumerable: true,
  get: function get() {
    return _quantileSeq.createQuantileSeq;
  }
});
Object.defineProperty(exports, "createStd", {
  enumerable: true,
  get: function get() {
    return _std.createStd;
  }
});
Object.defineProperty(exports, "createFormat", {
  enumerable: true,
  get: function get() {
    return _format.createFormat;
  }
});
Object.defineProperty(exports, "createPrint", {
  enumerable: true,
  get: function get() {
    return _print.createPrint;
  }
});
Object.defineProperty(exports, "createApplyTransform", {
  enumerable: true,
  get: function get() {
    return _apply2.createApplyTransform;
  }
});
Object.defineProperty(exports, "createFilterTransform", {
  enumerable: true,
  get: function get() {
    return _filter2.createFilterTransform;
  }
});
Object.defineProperty(exports, "createForEachTransform", {
  enumerable: true,
  get: function get() {
    return _forEach2.createForEachTransform;
  }
});
Object.defineProperty(exports, "createMapTransform", {
  enumerable: true,
  get: function get() {
    return _map2.createMapTransform;
  }
});
Object.defineProperty(exports, "createMaxTransform", {
  enumerable: true,
  get: function get() {
    return _max2.createMaxTransform;
  }
});
Object.defineProperty(exports, "createMeanTransform", {
  enumerable: true,
  get: function get() {
    return _mean2.createMeanTransform;
  }
});
Object.defineProperty(exports, "createMinTransform", {
  enumerable: true,
  get: function get() {
    return _min2.createMinTransform;
  }
});
Object.defineProperty(exports, "createRangeTransform", {
  enumerable: true,
  get: function get() {
    return _range2.createRangeTransform;
  }
});
Object.defineProperty(exports, "createSubsetTransform", {
  enumerable: true,
  get: function get() {
    return _subset.createSubsetTransform;
  }
});
Object.defineProperty(exports, "createStdTransform", {
  enumerable: true,
  get: function get() {
    return _std2.createStdTransform;
  }
});
Object.defineProperty(exports, "createSumTransform", {
  enumerable: true,
  get: function get() {
    return _sum2.createSumTransform;
  }
});
Object.defineProperty(exports, "createVarianceTransform", {
  enumerable: true,
  get: function get() {
    return _variance2.createVarianceTransform;
  }
});
Object.defineProperty(exports, "createClone", {
  enumerable: true,
  get: function get() {
    return _clone.createClone;
  }
});
Object.defineProperty(exports, "createIsNumeric", {
  enumerable: true,
  get: function get() {
    return _isNumeric.createIsNumeric;
  }
});
Object.defineProperty(exports, "createHasNumericValue", {
  enumerable: true,
  get: function get() {
    return _hasNumericValue.createHasNumericValue;
  }
});
Object.defineProperty(exports, "createTypeOf", {
  enumerable: true,
  get: function get() {
    return _typeOf.createTypeOf;
  }
});
Object.defineProperty(exports, "createIsPrime", {
  enumerable: true,
  get: function get() {
    return _isPrime.createIsPrime;
  }
});
Object.defineProperty(exports, "createNumeric", {
  enumerable: true,
  get: function get() {
    return _numeric.createNumeric;
  }
});
Object.defineProperty(exports, "createReviver", {
  enumerable: true,
  get: function get() {
    return _reviver.createReviver;
  }
});
exports.createIsNaN = exports.createIsZero = exports.createIsPositive = exports.createIsNegative = exports.createIsInteger = exports.createTanh = exports.createTan = exports.createSinh = exports.createSin = exports.createSech = exports.createSec = exports.createCsch = exports.createCsc = exports.createCoth = exports.createCot = exports.createCosh = exports.createCos = exports.createAtanh = exports.createAtan2 = exports.createAtan = exports.createAsinh = exports.createAsin = exports.createAsech = exports.createAsec = exports.createAcsch = exports.createAcsc = exports.createAcoth = exports.createAcot = exports.createAcosh = exports.createAcos = exports.createGamma = exports.createCombinations = exports.createSubset = exports.createMatrix = exports.createIndexClass = exports.createXor = exports.createOr = exports.createNot = exports.createAnd = exports.createRightLogShift = exports.createRightArithShift = exports.createLeftShift = exports.createBitXor = exports.createBitOr = exports.createBitNot = exports.createBitAnd = exports.createDivide = exports.createNorm = exports.createAdd = exports.createLog1p = exports.createLog = exports.createPow = exports.createDivideScalar = exports.createXgcd = exports.createSubtract = exports.createSquare = exports.createSqrt = exports.createSign = exports.createMultiply = exports.createMultiplyScalar = exports.createMod = exports.createLog2 = exports.createLog10 = exports.createLcm = exports.createGcd = exports.createFloor = exports.createFix = exports.createExpm1 = exports.createExp = exports.createCube = exports.createCeil = exports.createCbrt = exports.createAddScalar = exports.createAbs = exports.createUnaryPlus = exports.createUnaryMinus = void 0;

var _number = require("./plain/number");

var _factory = require("./utils/factory");

var _noop = require("./utils/noop");

var _typed = require("./core/function/typed");

var _ResultSet = require("./type/resultset/ResultSet");

var _Range = require("./type/matrix/Range");

var _Help = require("./expression/Help");

var _Chain = require("./type/chain/Chain");

var _help = require("./expression/function/help");

var _chain = require("./type/chain/function/chain");

var _simplify = require("./function/algebra/simplify");

var _derivative = require("./function/algebra/derivative");

var _rationalize = require("./function/algebra/rationalize");

var _nthRoot = require("./function/arithmetic/nthRoot");

var _round = require("./function/arithmetic/round");

var _hypot = require("./function/arithmetic/hypot");

var _stirlingS = require("./function/combinatorics/stirlingS2");

var _bellNumbers = require("./function/combinatorics/bellNumbers");

var _catalan = require("./function/combinatorics/catalan");

var _composition = require("./function/combinatorics/composition");

var _constants = require("./constants");

var _number2 = require("./type/number");

var _string = require("./type/string");

var _boolean = require("./type/boolean");

var _parser = require("./expression/function/parser");

var _Node = require("./expression/node/Node");

var _AccessorNode = require("./expression/node/AccessorNode");

var _ArrayNode = require("./expression/node/ArrayNode");

var _AssignmentNode = require("./expression/node/AssignmentNode");

var _BlockNode = require("./expression/node/BlockNode");

var _ConditionalNode = require("./expression/node/ConditionalNode");

var _ConstantNode = require("./expression/node/ConstantNode");

var _FunctionAssignmentNode = require("./expression/node/FunctionAssignmentNode");

var _IndexNode = require("./expression/node/IndexNode");

var _ObjectNode = require("./expression/node/ObjectNode");

var _OperatorNode = require("./expression/node/OperatorNode");

var _ParenthesisNode = require("./expression/node/ParenthesisNode");

var _RangeNode = require("./expression/node/RangeNode");

var _RelationalNode = require("./expression/node/RelationalNode");

var _SymbolNode = require("./expression/node/SymbolNode");

var _FunctionNode = require("./expression/node/FunctionNode");

var _parse = require("./expression/parse");

var _compile = require("./expression/function/compile");

var _evaluate = require("./expression/function/evaluate");

var _Parser = require("./expression/Parser");

var _apply = require("./function/matrix/apply");

var _filter = require("./function/matrix/filter");

var _forEach = require("./function/matrix/forEach");

var _map = require("./function/matrix/map");

var _range = require("./function/matrix/range");

var _size = require("./function/matrix/size");

var _partitionSelect = require("./function/matrix/partitionSelect");

var _factorial = require("./function/probability/factorial");

var _multinomial = require("./function/probability/multinomial");

var _permutations = require("./function/probability/permutations");

var _pickRandom = require("./function/probability/pickRandom");

var _random = require("./function/probability/random");

var _randomInt = require("./function/probability/randomInt");

var _equalScalar = require("./function/relational/equalScalar");

var _compare = require("./function/relational/compare");

var _compareNatural = require("./function/relational/compareNatural");

var _compareText = require("./function/relational/compareText");

var _equal = require("./function/relational/equal");

var _equalText = require("./function/relational/equalText");

var _smaller = require("./function/relational/smaller");

var _smallerEq = require("./function/relational/smallerEq");

var _larger = require("./function/relational/larger");

var _largerEq = require("./function/relational/largerEq");

var _deepEqual = require("./function/relational/deepEqual");

var _unequal = require("./function/relational/unequal");

var _erf = require("./function/special/erf");

var _mode = require("./function/statistics/mode");

var _prod = require("./function/statistics/prod");

var _max = require("./function/statistics/max");

var _min = require("./function/statistics/min");

var _sum = require("./function/statistics/sum");

var _mean = require("./function/statistics/mean");

var _median = require("./function/statistics/median");

var _mad = require("./function/statistics/mad");

var _variance = require("./function/statistics/variance");

var _quantileSeq = require("./function/statistics/quantileSeq");

var _std = require("./function/statistics/std");

var _format = require("./function/string/format");

var _print = require("./function/string/print");

var _apply2 = require("./expression/transform/apply.transform");

var _filter2 = require("./expression/transform/filter.transform");

var _forEach2 = require("./expression/transform/forEach.transform");

var _map2 = require("./expression/transform/map.transform");

var _max2 = require("./expression/transform/max.transform");

var _mean2 = require("./expression/transform/mean.transform");

var _min2 = require("./expression/transform/min.transform");

var _range2 = require("./expression/transform/range.transform");

var _subset = require("./expression/transform/subset.transform");

var _std2 = require("./expression/transform/std.transform");

var _sum2 = require("./expression/transform/sum.transform");

var _variance2 = require("./expression/transform/variance.transform");

var _clone = require("./function/utils/clone");

var _isNumeric = require("./function/utils/isNumeric");

var _hasNumericValue = require("./function/utils/hasNumericValue");

var _typeOf = require("./function/utils/typeOf");

var _isPrime = require("./function/utils/isPrime");

var _numeric = require("./function/utils/numeric");

var _reviver = require("./json/reviver");

// ----------------------------------------------------------------------------
// classes and functions
// core
// classes
// algebra
// arithmetic
var createUnaryMinus =
/* #__PURE__ */
createNumberFactory('unaryMinus', _number.unaryMinusNumber);
exports.createUnaryMinus = createUnaryMinus;
var createUnaryPlus =
/* #__PURE__ */
createNumberFactory('unaryPlus', _number.unaryPlusNumber);
exports.createUnaryPlus = createUnaryPlus;
var createAbs =
/* #__PURE__ */
createNumberFactory('abs', _number.absNumber);
exports.createAbs = createAbs;
var createAddScalar =
/* #__PURE__ */
createNumberFactory('addScalar', _number.addNumber);
exports.createAddScalar = createAddScalar;
var createCbrt =
/* #__PURE__ */
createNumberFactory('cbrt', _number.cbrtNumber);
exports.createCbrt = createCbrt;
var createCeil =
/* #__PURE__ */
createNumberFactory('ceil', _number.ceilNumber);
exports.createCeil = createCeil;
var createCube =
/* #__PURE__ */
createNumberFactory('cube', _number.cubeNumber);
exports.createCube = createCube;
var createExp =
/* #__PURE__ */
createNumberFactory('exp', _number.expNumber);
exports.createExp = createExp;
var createExpm1 =
/* #__PURE__ */
createNumberFactory('expm1', _number.expm1Number);
exports.createExpm1 = createExpm1;
var createFix =
/* #__PURE__ */
createNumberFactory('fix', _number.fixNumber);
exports.createFix = createFix;
var createFloor =
/* #__PURE__ */
createNumberFactory('floor', _number.floorNumber);
exports.createFloor = createFloor;
var createGcd =
/* #__PURE__ */
createNumberFactory('gcd', _number.gcdNumber);
exports.createGcd = createGcd;
var createLcm =
/* #__PURE__ */
createNumberFactory('lcm', _number.lcmNumber);
exports.createLcm = createLcm;
var createLog10 =
/* #__PURE__ */
createNumberFactory('log10', _number.log10Number);
exports.createLog10 = createLog10;
var createLog2 =
/* #__PURE__ */
createNumberFactory('log2', _number.log2Number);
exports.createLog2 = createLog2;
var createMod =
/* #__PURE__ */
createNumberFactory('mod', _number.modNumber);
exports.createMod = createMod;
var createMultiplyScalar =
/* #__PURE__ */
createNumberFactory('multiplyScalar', _number.multiplyNumber);
exports.createMultiplyScalar = createMultiplyScalar;
var createMultiply =
/* #__PURE__ */
createNumberFactory('multiply', _number.multiplyNumber);
exports.createMultiply = createMultiply;
var createSign =
/* #__PURE__ */
createNumberFactory('sign', _number.signNumber);
exports.createSign = createSign;
var createSqrt =
/* #__PURE__ */
createNumberFactory('sqrt', _number.sqrtNumber);
exports.createSqrt = createSqrt;
var createSquare =
/* #__PURE__ */
createNumberFactory('square', _number.squareNumber);
exports.createSquare = createSquare;
var createSubtract =
/* #__PURE__ */
createNumberFactory('subtract', _number.subtractNumber);
exports.createSubtract = createSubtract;
var createXgcd =
/* #__PURE__ */
createNumberFactory('xgcd', _number.xgcdNumber);
exports.createXgcd = createXgcd;
var createDivideScalar =
/* #__PURE__ */
createNumberFactory('divideScalar', _number.divideNumber);
exports.createDivideScalar = createDivideScalar;
var createPow =
/* #__PURE__ */
createNumberFactory('pow', _number.powNumber);
exports.createPow = createPow;
var createLog =
/* #__PURE__ */
createNumberFactory('log', _number.logNumber);
exports.createLog = createLog;
var createLog1p =
/* #__PURE__ */
createNumberFactory('log1p', _number.log1pNumber);
exports.createLog1p = createLog1p;
var createAdd =
/* #__PURE__ */
createNumberFactory('add', _number.addNumber);
exports.createAdd = createAdd;
var createNorm =
/* #__PURE__ */
createNumberFactory('norm', _number.normNumber);
exports.createNorm = createNorm;
var createDivide =
/* #__PURE__ */
createNumberFactory('divide', _number.divideNumber); // bitwise

exports.createDivide = createDivide;
var createBitAnd =
/* #__PURE__ */
createNumberFactory('bitAnd', _number.bitAndNumber);
exports.createBitAnd = createBitAnd;
var createBitNot =
/* #__PURE__ */
createNumberFactory('bitNot', _number.bitNotNumber);
exports.createBitNot = createBitNot;
var createBitOr =
/* #__PURE__ */
createNumberFactory('bitOr', _number.bitOrNumber);
exports.createBitOr = createBitOr;
var createBitXor =
/* #__PURE__ */
createNumberFactory('bitXor', _number.bitXorNumber);
exports.createBitXor = createBitXor;
var createLeftShift =
/* #__PURE__ */
createNumberFactory('leftShift', _number.leftShiftNumber);
exports.createLeftShift = createLeftShift;
var createRightArithShift =
/* #__PURE__ */
createNumberFactory('rightArithShift', _number.rightArithShiftNumber);
exports.createRightArithShift = createRightArithShift;
var createRightLogShift =
/* #__PURE__ */
createNumberFactory('rightLogShift', _number.rightLogShiftNumber); // combinatorics

exports.createRightLogShift = createRightLogShift;
// logical
var createAnd =
/* #__PURE__ */
createNumberFactory('and', _number.andNumber);
exports.createAnd = createAnd;
var createNot =
/* #__PURE__ */
createNumberFactory('not', _number.notNumber);
exports.createNot = createNot;
var createOr =
/* #__PURE__ */
createNumberFactory('or', _number.orNumber);
exports.createOr = createOr;
var createXor =
/* #__PURE__ */
createNumberFactory('xor', _number.xorNumber); // matrix

exports.createXor = createXor;
// FIXME: create a lightweight "number" implementation of subset only supporting plain objects/arrays
var createIndexClass =
/* #__PURE__ */
(0, _factory.factory)('Index', [], function () {
  return _noop.noIndexClass;
}, {
  isClass: true
});
exports.createIndexClass = createIndexClass;
var createMatrix =
/* #__PURE__ */
(0, _factory.factory)('matrix', [], function () {
  return _noop.noMatrix;
}); // FIXME: needed now because subset transform needs it. Remove the need for it in subset

exports.createMatrix = createMatrix;
var createSubset =
/* #__PURE__ */
(0, _factory.factory)('subset', [], function () {
  return _noop.noSubset;
}); // TODO: provide number+array implementations for map, filter, forEach, zeros, ...?
// TODO: create range implementation for range?

exports.createSubset = createSubset;
// probability
var createCombinations = createNumberFactory('combinations', _number.combinationsNumber);
exports.createCombinations = createCombinations;
var createGamma = createNumberFactory('gamma', _number.gammaNumber);
exports.createGamma = createGamma;
// trigonometry
var createAcos =
/* #__PURE__ */
createNumberFactory('acos', _number.acosNumber);
exports.createAcos = createAcos;
var createAcosh =
/* #__PURE__ */
createNumberFactory('acosh', _number.acoshNumber);
exports.createAcosh = createAcosh;
var createAcot =
/* #__PURE__ */
createNumberFactory('acot', _number.acotNumber);
exports.createAcot = createAcot;
var createAcoth =
/* #__PURE__ */
createNumberFactory('acoth', _number.acothNumber);
exports.createAcoth = createAcoth;
var createAcsc =
/* #__PURE__ */
createNumberFactory('acsc', _number.acscNumber);
exports.createAcsc = createAcsc;
var createAcsch =
/* #__PURE__ */
createNumberFactory('acsch', _number.acschNumber);
exports.createAcsch = createAcsch;
var createAsec =
/* #__PURE__ */
createNumberFactory('asec', _number.asecNumber);
exports.createAsec = createAsec;
var createAsech =
/* #__PURE__ */
createNumberFactory('asech', _number.asechNumber);
exports.createAsech = createAsech;
var createAsin =
/* #__PURE__ */
createNumberFactory('asin', _number.asinNumber);
exports.createAsin = createAsin;
var createAsinh =
/* #__PURE__ */
createNumberFactory('asinh', _number.asinhNumber);
exports.createAsinh = createAsinh;
var createAtan =
/* #__PURE__ */
createNumberFactory('atan', _number.atanNumber);
exports.createAtan = createAtan;
var createAtan2 =
/* #__PURE__ */
createNumberFactory('atan2', _number.atan2Number);
exports.createAtan2 = createAtan2;
var createAtanh =
/* #__PURE__ */
createNumberFactory('atanh', _number.atanhNumber);
exports.createAtanh = createAtanh;
var createCos =
/* #__PURE__ */
createNumberFactory('cos', _number.cosNumber);
exports.createCos = createCos;
var createCosh =
/* #__PURE__ */
createNumberFactory('cosh', _number.coshNumber);
exports.createCosh = createCosh;
var createCot =
/* #__PURE__ */
createNumberFactory('cot', _number.cotNumber);
exports.createCot = createCot;
var createCoth =
/* #__PURE__ */
createNumberFactory('coth', _number.cothNumber);
exports.createCoth = createCoth;
var createCsc =
/* #__PURE__ */
createNumberFactory('csc', _number.cscNumber);
exports.createCsc = createCsc;
var createCsch =
/* #__PURE__ */
createNumberFactory('csch', _number.cschNumber);
exports.createCsch = createCsch;
var createSec =
/* #__PURE__ */
createNumberFactory('sec', _number.secNumber);
exports.createSec = createSec;
var createSech =
/* #__PURE__ */
createNumberFactory('sech', _number.sechNumber);
exports.createSech = createSech;
var createSin =
/* #__PURE__ */
createNumberFactory('sin', _number.sinNumber);
exports.createSin = createSin;
var createSinh =
/* #__PURE__ */
createNumberFactory('sinh', _number.sinhNumber);
exports.createSinh = createSinh;
var createTan =
/* #__PURE__ */
createNumberFactory('tan', _number.tanNumber);
exports.createTan = createTan;
var createTanh =
/* #__PURE__ */
createNumberFactory('tanh', _number.tanhNumber); // transforms

exports.createTanh = createTanh;
var createIsInteger =
/* #__PURE__ */
createNumberFactory('isInteger', _number.isIntegerNumber);
exports.createIsInteger = createIsInteger;
var createIsNegative =
/* #__PURE__ */
createNumberFactory('isNegative', _number.isNegativeNumber);
exports.createIsNegative = createIsNegative;
var createIsPositive =
/* #__PURE__ */
createNumberFactory('isPositive', _number.isPositiveNumber);
exports.createIsPositive = createIsPositive;
var createIsZero =
/* #__PURE__ */
createNumberFactory('isZero', _number.isZeroNumber);
exports.createIsZero = createIsZero;
var createIsNaN =
/* #__PURE__ */
createNumberFactory('isNaN', _number.isNaNNumber);
exports.createIsNaN = createIsNaN;

// helper function to create a factory function for a function which only needs typed-function
function createNumberFactory(name, fn) {
  return (0, _factory.factory)(name, ['typed'], function (_ref) {
    var typed = _ref.typed;
    return typed(fn);
  });
}