<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function min

Compute the minimum value of a matrix or a  list of values.
In case of a multi dimensional array, the minimum of the flattened array
will be calculated. When `dim` is provided, the minimum over the selected
dimension will be calculated. Parameter `dim` is zero-based.


## Syntax

```js
math.min(a, b, c, ...)
math.min(A)
math.min(A, dim)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`args` | ... * | A single matrix or or multiple scalar values

### Returns

Type | Description
---- | -----------
* | The minimum value


## Examples

```js
math.min(2, 1, 4, 3)                  // returns 1
math.min([2, 1, 4, 3])                // returns 1

// minimum over a specified dimension (zero-based)
math.min([[2, 5], [4, 3], [1, 7]], 0) // returns [1, 3]
math.min([[2, 5], [4, 3], [1, 7]], 1) // returns [2, 3, 1]

math.max(2.7, 7.1, -4.5, 2.0, 4.1)    // returns 7.1
math.min(2.7, 7.1, -4.5, 2.0, 4.1)    // returns -4.5
```


## See also

[mean](mean.md),
[median](median.md),
[max](max.md),
[prod](prod.md),
[std](std.md),
[sum](sum.md),
[variance](variance.md)
