# Contributing Guide

We value your and our time, we created this Guideline to avoid unnecessary difficulties with pull requests and the contribution process.

Please read the text below **before starting your improvements** in order to help us make the cooperation and reviewing experience as pleasant and effective as possible.

Not following these rules and procedures may entail closing issues or rejection of your work even if it's theoretically adequate.

## Issues and Support

1. **Use Support Forum** - don't use GitHub Issues for personal questions and support requests. We're maintaining a [dedicated Support Forum](https://mdbootstrap.com/support/) for this purpose. This is also a go-to place for every suggestion, opinion, bug, and issue report if you'd like to receive help as soon as possible. Reports posted on Support Forum are **prior to GitHub issues**.

2. **Check available resources** - always check [current issues](https://github.com/mdbootstrap/bootstrap-material-design/issues) before opening your own. Also check [Support Forum](https://mdbootstrap.com/support/) and [Documentation](https://mdbootstrap.com/md-bootstrap-sitemap/) - most likely you'll find your answer there. Unchecked issues and duplicates will be closed immediately.

3. **Examine issue source** - MDB code is depending on other projects, mainly [Bootstrap](https://github.com/twbs/bootstrap). Don't open issues concerning sources we cannot influence. For example - lack of flexbox support for older IE versions is determined by Bootstrap not MDB.

4. **Check updates** - We resolve most of the reported bugs and issues with every new release. Check if your MDB version is the latest. You can take a look at our [changelog](https://mdbootstrap.com/changelog) to find if your problem wasn't already taken care of. If you want to keep track of updates and bug fixes, the best way is joining our newsletter [here](https://mdbootstrap.com/newsletter/).

5. **Be specific** - describe your case **in English**, clearly and with details. Attach code examples, screenshots, links and any other relevant resources.

## Contributing Standards
All improvements, fixes and new elements are welcome and we're deeply grateful for every help attempt, although we recommend thinking twice before starting. We don't want to waste your time and some changes may be rejected not because of their quality but simply as a result of different style, organization or predefined procedures we maintain.
That's why we came up with the standards below; following them will maximize the chance of your contribution being included in this project.

1. Make sure that your idea doesn't contradict the concepts of [Bootstrap](https://getbootstrap.com/), [Material Design](https://material.io/guidelines/) and [jQuery](https://jquery.com/)
2. Verify if it fits the rest of the MDB environment and style
3. Write and form your code according to [these rules](http://codeguide.co/)
4. Use Gulp to minify your code after finishing
5. Create clear titles and detailed descriptions for your Pull Requests

## Questions
If you're not sure about your ideas or you'd like to talk about them with our team before starting, write to: contact@mdbootstrap.com, and for every query regarding technical consultance open your case on [Support Forum](https://mdbootstrap.com/support/)
