'use strict';

// See: http://robertpenner.com/easing/

Object.defineProperty(exports, "__esModule", {
  value: true
});
var easeInOutQuad = function easeInOutQuad(t, b, c, d) {
  t /= d / 2;
  if (t < 1) return c / 2 * t * t + b;
  t--;
  return -c / 2 * (t * (t - 2) - 1) + b;
};

var inOutQuintic = function inOutQuintic(t, b, c, d) {
  var ts = (t /= d) * t;
  var tc = ts * t;
  return b + c * (6 * tc * ts + -15 * ts * ts + 10 * tc);
};

exports.easeInOutQuad = easeInOutQuad;
exports.inOutQuintic = inOutQuintic;