'use strict';

/**
 * Converts a JSON string to object
 * @param jsonString
 * @param source
 */

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.jsonStringToObject = undefined;

var _assign = require('babel-runtime/core-js/object/assign');

var _assign2 = _interopRequireDefault(_assign);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var jsonStringToObject = function jsonStringToObject(jsonString) {
  var source = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

  var s = jsonString.replace(/'/g, '"');
  try {
    return (0, _assign2.default)(source, JSON.parse(s));
  } catch (e) {
    throw new Error('Failed to parse json string: ' + s + '. Error: ' + e.message);
  }
};

exports.jsonStringToObject = jsonStringToObject;