# Resources

* [Styling player](#styles)
* [Encoding tips/tools](#tools)
* [Code snippets](#gists)

The following resources talk about a variety of topics that users of `MediaElementJS` deal with.

<a id="styles"></a>
## Styling player

* [How to Create an Audio Player in jQuery, HTML5 & CSS3](https://designmodo.com/audio-player/)
* [Simple Trick - Adding a Play Indicator to the Browser Tab](https://www.raymondcamden.com/2014/02/04/Simple-Trick-Adding-a-Play-Indicator-to-the-Browser-Tab)

<a id="tools"></a>
## Encoding tips/tools

* [Encode h.264 and WebM videos for MediaElement.js using FFMPEG](http://blogs.visigo.com/chriscoulson/encode-h-264-and-webm-videos-for-mediaelement-js-using-ffmpeg/)
* [QTIndexSwapper](http://renaun.com/blog/code/qtindexswapper/)
* [Handbrake](https://handbrake.fr/docs/en/1.0.0/)

<a id="gists"></a>
## Code snippets

* [CSS Tricks: Video Source by Screen Size](https://css-tricks.com/video-source-by-screen-size/)
* [Mute tab audio on tab unfocus in JavaScript/html](https://stackoverflow.com/questions/34506133/mute-tab-audio-on-tab-unfocus-in-javascript-html)
* [MediaElementPlayer.js: use `AudioContext.decodeAudioData()`](https://gist.github.com/rafa8626/e6afe41dd00742a75c4d25cc387a7d61)
* [Use of DRM with MediaElement](https://jsfiddle.net/f431r2zq/12/)
* [MediaElementPlayer.js using Chromecast and dynamic sources](https://jsfiddle.net/Luuwnjfm/18/)
* [MediaElementPlayer.js Video Snapshot Plugin](https://github.com/Codecsocean/mediaelement-snapshot)
