/*global describe, it, expect, afterEach,
    beforeEach, jasmine, setupTestHelpers */

describe('Exploits', function () {
    'use strict';

    beforeEach(function () {
        setupTestHelpers.call(this);
        this.el = this.createElement('div', 'editor', 'hhh');
        this.el.id = 'paste-editor';
    });

    afterEach(function () {
        this.cleanupTest();
    });

    it('Should not execute javascript with disableReturn false', function () {
        var evt, range,
            editorEl = this.el,
            sel = window.getSelection(),
            editor = this.newMediumEditor('.editor', {
                delay: 200,
                disableReturn: false
            }),
            pasteHandler = editor.getExtensionByName('paste'),
            test = {
                source: 'img onerror handler',
                paste: '><img src="x" onerror="alert(\'xss\')">',
                output: '<span id="editor-inner">&gt;&lt;img src="x" onerror="alert(\'xss\')"&gt;</span>'
            };

        // mock event with clipboardData API
        // test requires creating a function, so can't loop or jslint balks
        evt = {
            preventDefault: function () {
                return;
            },
            clipboardData: {
                getData: function () {
                    // do we need to return different results for the different types? text/plain, text/html
                    return test.paste;
                }
            }
        };

        editorEl.innerHTML = '<span id="editor-inner">&nbsp</span>';

        range = document.createRange();
        range.selectNodeContents(editorEl.firstChild);
        sel.removeAllRanges();
        sel.addRange(range);

        pasteHandler.handlePaste(evt, editorEl);
        jasmine.clock().tick(100);
        expect(editorEl.innerHTML).toEqual(test.output);
    });

    it('Should not execute javascript with disableReturn true', function () {
        var evt, range,
            editorEl = this.el,
            sel = window.getSelection(),
            editor = this.newMediumEditor('.editor', {
                delay: 200,
                disableReturn: true
            }),
            pasteHandler = editor.getExtensionByName('paste'),
            test = {
                source: 'img onerror handler',
                paste: '><img src="x" onerror="alert(\'xss\')">',
                output: '<span id="editor-inner">&gt;&lt;img src="x" onerror="alert(\'xss\')"&gt;</span>'
            };

        // mock event with clipboardData API
        // test requires creating a function, so can't loop or jslint balks
        evt = {
            preventDefault: function () {
                return;
            },
            clipboardData: {
                getData: function () {
                    // do we need to return different results for the different types? text/plain, text/html
                    return test.paste;
                }
            }
        };

        editorEl.innerHTML = '<span id="editor-inner">&nbsp</span>';

        range = document.createRange();
        range.selectNodeContents(document.getElementById('editor-inner'));
        sel.removeAllRanges();
        sel.addRange(range);

        pasteHandler.handlePaste(evt, editorEl);
        jasmine.clock().tick(100);
        expect(editorEl.innerHTML).toEqual(test.output);
    });
});
