(function(global2, factory) {
  typeof exports === "object" && typeof module !== "undefined" ? module.exports = factory() : typeof define === "function" && define.amd ? define(factory) : (global2 = typeof globalThis !== "undefined" ? globalThis : global2 || self, global2.mermaid = factory());
})(this, function() {
  "use strict";
  function dedent(templ) {
    var values2 = [];
    for (var _i = 1; _i < arguments.length; _i++) {
      values2[_i - 1] = arguments[_i];
    }
    var strings = Array.from(typeof templ === "string" ? [templ] : templ);
    strings[strings.length - 1] = strings[strings.length - 1].replace(/\r?\n([\t ]*)$/, "");
    var indentLengths = strings.reduce(function(arr, str2) {
      var matches = str2.match(/\n([\t ]+|(?!\s).)/g);
      if (matches) {
        return arr.concat(matches.map(function(match) {
          var _a, _b;
          return (_b = (_a = match.match(/[\t ]/g)) === null || _a === void 0 ? void 0 : _a.length) !== null && _b !== void 0 ? _b : 0;
        }));
      }
      return arr;
    }, []);
    if (indentLengths.length) {
      var pattern_1 = new RegExp("\n[	 ]{" + Math.min.apply(Math, indentLengths) + "}", "g");
      strings = strings.map(function(str2) {
        return str2.replace(pattern_1, "\n");
      });
    }
    strings[0] = strings[0].replace(/^\r?\n/, "");
    var string2 = strings[0];
    values2.forEach(function(value, i2) {
      var endentations = string2.match(/(?:^|\n)( *)$/);
      var endentation = endentations ? endentations[1] : "";
      var indentedValue = value;
      if (typeof value === "string" && value.includes("\n")) {
        indentedValue = String(value).split("\n").map(function(str2, i3) {
          return i3 === 0 ? str2 : "" + endentation + str2;
        }).join("\n");
      }
      string2 += indentedValue + strings[i2 + 1];
    });
    return string2;
  }
  var commonjsGlobal = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
  function getDefaultExportFromCjs(x2) {
    return x2 && x2.__esModule && Object.prototype.hasOwnProperty.call(x2, "default") ? x2["default"] : x2;
  }
  var dayjs_minExports = {};
  var dayjs_min = {
    get exports() {
      return dayjs_minExports;
    },
    set exports(v) {
      dayjs_minExports = v;
    }
  };
  (function(module2, exports2) {
    !function(t, e) {
      module2.exports = e();
    }(commonjsGlobal, function() {
      var t = 1e3, e = 6e4, n = 36e5, r = "millisecond", i2 = "second", s = "minute", u = "hour", a = "day", o = "week", f2 = "month", h = "quarter", c2 = "year", d = "date", l = "Invalid Date", $ = /^(\d{4})[-/]?(\d{1,2})?[-/]?(\d{0,2})[Tt\s]*(\d{1,2})?:?(\d{1,2})?:?(\d{1,2})?[.:]?(\d+)?$/, y2 = /\[([^\]]+)]|Y{1,4}|M{1,4}|D{1,2}|d{1,4}|H{1,2}|h{1,2}|a|A|m{1,2}|s{1,2}|Z{1,2}|SSS/g, M = { name: "en", weekdays: "Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"), months: "January_February_March_April_May_June_July_August_September_October_November_December".split("_"), ordinal: function(t4) {
        var e3 = ["th", "st", "nd", "rd"], n2 = t4 % 100;
        return "[" + t4 + (e3[(n2 - 20) % 10] || e3[n2] || e3[0]) + "]";
      } }, m = function(t4, e3, n2) {
        var r2 = String(t4);
        return !r2 || r2.length >= e3 ? t4 : "" + Array(e3 + 1 - r2.length).join(n2) + t4;
      }, v = { s: m, z: function(t4) {
        var e3 = -t4.utcOffset(), n2 = Math.abs(e3), r2 = Math.floor(n2 / 60), i3 = n2 % 60;
        return (e3 <= 0 ? "+" : "-") + m(r2, 2, "0") + ":" + m(i3, 2, "0");
      }, m: function t4(e3, n2) {
        if (e3.date() < n2.date())
          return -t4(n2, e3);
        var r2 = 12 * (n2.year() - e3.year()) + (n2.month() - e3.month()), i3 = e3.clone().add(r2, f2), s2 = n2 - i3 < 0, u2 = e3.clone().add(r2 + (s2 ? -1 : 1), f2);
        return +(-(r2 + (n2 - i3) / (s2 ? i3 - u2 : u2 - i3)) || 0);
      }, a: function(t4) {
        return t4 < 0 ? Math.ceil(t4) || 0 : Math.floor(t4);
      }, p: function(t4) {
        return { M: f2, y: c2, w: o, d: a, D: d, h: u, m: s, s: i2, ms: r, Q: h }[t4] || String(t4 || "").toLowerCase().replace(/s$/, "");
      }, u: function(t4) {
        return void 0 === t4;
      } }, g = "en", D = {};
      D[g] = M;
      var p = function(t4) {
        return t4 instanceof _2;
      }, S = function t4(e3, n2, r2) {
        var i3;
        if (!e3)
          return g;
        if ("string" == typeof e3) {
          var s2 = e3.toLowerCase();
          D[s2] && (i3 = s2), n2 && (D[s2] = n2, i3 = s2);
          var u2 = e3.split("-");
          if (!i3 && u2.length > 1)
            return t4(u2[0]);
        } else {
          var a2 = e3.name;
          D[a2] = e3, i3 = a2;
        }
        return !r2 && i3 && (g = i3), i3 || !r2 && g;
      }, w2 = function(t4, e3) {
        if (p(t4))
          return t4.clone();
        var n2 = "object" == typeof e3 ? e3 : {};
        return n2.date = t4, n2.args = arguments, new _2(n2);
      }, O = v;
      O.l = S, O.i = p, O.w = function(t4, e3) {
        return w2(t4, { locale: e3.$L, utc: e3.$u, x: e3.$x, $offset: e3.$offset });
      };
      var _2 = function() {
        function M2(t4) {
          this.$L = S(t4.locale, null, true), this.parse(t4);
        }
        var m2 = M2.prototype;
        return m2.parse = function(t4) {
          this.$d = function(t5) {
            var e3 = t5.date, n2 = t5.utc;
            if (null === e3)
              return /* @__PURE__ */ new Date(NaN);
            if (O.u(e3))
              return /* @__PURE__ */ new Date();
            if (e3 instanceof Date)
              return new Date(e3);
            if ("string" == typeof e3 && !/Z$/i.test(e3)) {
              var r2 = e3.match($);
              if (r2) {
                var i3 = r2[2] - 1 || 0, s2 = (r2[7] || "0").substring(0, 3);
                return n2 ? new Date(Date.UTC(r2[1], i3, r2[3] || 1, r2[4] || 0, r2[5] || 0, r2[6] || 0, s2)) : new Date(r2[1], i3, r2[3] || 1, r2[4] || 0, r2[5] || 0, r2[6] || 0, s2);
              }
            }
            return new Date(e3);
          }(t4), this.$x = t4.x || {}, this.init();
        }, m2.init = function() {
          var t4 = this.$d;
          this.$y = t4.getFullYear(), this.$M = t4.getMonth(), this.$D = t4.getDate(), this.$W = t4.getDay(), this.$H = t4.getHours(), this.$m = t4.getMinutes(), this.$s = t4.getSeconds(), this.$ms = t4.getMilliseconds();
        }, m2.$utils = function() {
          return O;
        }, m2.isValid = function() {
          return !(this.$d.toString() === l);
        }, m2.isSame = function(t4, e3) {
          var n2 = w2(t4);
          return this.startOf(e3) <= n2 && n2 <= this.endOf(e3);
        }, m2.isAfter = function(t4, e3) {
          return w2(t4) < this.startOf(e3);
        }, m2.isBefore = function(t4, e3) {
          return this.endOf(e3) < w2(t4);
        }, m2.$g = function(t4, e3, n2) {
          return O.u(t4) ? this[e3] : this.set(n2, t4);
        }, m2.unix = function() {
          return Math.floor(this.valueOf() / 1e3);
        }, m2.valueOf = function() {
          return this.$d.getTime();
        }, m2.startOf = function(t4, e3) {
          var n2 = this, r2 = !!O.u(e3) || e3, h2 = O.p(t4), l2 = function(t5, e4) {
            var i3 = O.w(n2.$u ? Date.UTC(n2.$y, e4, t5) : new Date(n2.$y, e4, t5), n2);
            return r2 ? i3 : i3.endOf(a);
          }, $2 = function(t5, e4) {
            return O.w(n2.toDate()[t5].apply(n2.toDate("s"), (r2 ? [0, 0, 0, 0] : [23, 59, 59, 999]).slice(e4)), n2);
          }, y3 = this.$W, M3 = this.$M, m3 = this.$D, v2 = "set" + (this.$u ? "UTC" : "");
          switch (h2) {
            case c2:
              return r2 ? l2(1, 0) : l2(31, 11);
            case f2:
              return r2 ? l2(1, M3) : l2(0, M3 + 1);
            case o:
              var g2 = this.$locale().weekStart || 0, D2 = (y3 < g2 ? y3 + 7 : y3) - g2;
              return l2(r2 ? m3 - D2 : m3 + (6 - D2), M3);
            case a:
            case d:
              return $2(v2 + "Hours", 0);
            case u:
              return $2(v2 + "Minutes", 1);
            case s:
              return $2(v2 + "Seconds", 2);
            case i2:
              return $2(v2 + "Milliseconds", 3);
            default:
              return this.clone();
          }
        }, m2.endOf = function(t4) {
          return this.startOf(t4, false);
        }, m2.$set = function(t4, e3) {
          var n2, o2 = O.p(t4), h2 = "set" + (this.$u ? "UTC" : ""), l2 = (n2 = {}, n2[a] = h2 + "Date", n2[d] = h2 + "Date", n2[f2] = h2 + "Month", n2[c2] = h2 + "FullYear", n2[u] = h2 + "Hours", n2[s] = h2 + "Minutes", n2[i2] = h2 + "Seconds", n2[r] = h2 + "Milliseconds", n2)[o2], $2 = o2 === a ? this.$D + (e3 - this.$W) : e3;
          if (o2 === f2 || o2 === c2) {
            var y3 = this.clone().set(d, 1);
            y3.$d[l2]($2), y3.init(), this.$d = y3.set(d, Math.min(this.$D, y3.daysInMonth())).$d;
          } else
            l2 && this.$d[l2]($2);
          return this.init(), this;
        }, m2.set = function(t4, e3) {
          return this.clone().$set(t4, e3);
        }, m2.get = function(t4) {
          return this[O.p(t4)]();
        }, m2.add = function(r2, h2) {
          var d2, l2 = this;
          r2 = Number(r2);
          var $2 = O.p(h2), y3 = function(t4) {
            var e3 = w2(l2);
            return O.w(e3.date(e3.date() + Math.round(t4 * r2)), l2);
          };
          if ($2 === f2)
            return this.set(f2, this.$M + r2);
          if ($2 === c2)
            return this.set(c2, this.$y + r2);
          if ($2 === a)
            return y3(1);
          if ($2 === o)
            return y3(7);
          var M3 = (d2 = {}, d2[s] = e, d2[u] = n, d2[i2] = t, d2)[$2] || 1, m3 = this.$d.getTime() + r2 * M3;
          return O.w(m3, this);
        }, m2.subtract = function(t4, e3) {
          return this.add(-1 * t4, e3);
        }, m2.format = function(t4) {
          var e3 = this, n2 = this.$locale();
          if (!this.isValid())
            return n2.invalidDate || l;
          var r2 = t4 || "YYYY-MM-DDTHH:mm:ssZ", i3 = O.z(this), s2 = this.$H, u2 = this.$m, a2 = this.$M, o2 = n2.weekdays, f3 = n2.months, h2 = function(t5, n3, i4, s3) {
            return t5 && (t5[n3] || t5(e3, r2)) || i4[n3].slice(0, s3);
          }, c3 = function(t5) {
            return O.s(s2 % 12 || 12, t5, "0");
          }, d2 = n2.meridiem || function(t5, e4, n3) {
            var r3 = t5 < 12 ? "AM" : "PM";
            return n3 ? r3.toLowerCase() : r3;
          }, $2 = { YY: String(this.$y).slice(-2), YYYY: this.$y, M: a2 + 1, MM: O.s(a2 + 1, 2, "0"), MMM: h2(n2.monthsShort, a2, f3, 3), MMMM: h2(f3, a2), D: this.$D, DD: O.s(this.$D, 2, "0"), d: String(this.$W), dd: h2(n2.weekdaysMin, this.$W, o2, 2), ddd: h2(n2.weekdaysShort, this.$W, o2, 3), dddd: o2[this.$W], H: String(s2), HH: O.s(s2, 2, "0"), h: c3(1), hh: c3(2), a: d2(s2, u2, true), A: d2(s2, u2, false), m: String(u2), mm: O.s(u2, 2, "0"), s: String(this.$s), ss: O.s(this.$s, 2, "0"), SSS: O.s(this.$ms, 3, "0"), Z: i3 };
          return r2.replace(y2, function(t5, e4) {
            return e4 || $2[t5] || i3.replace(":", "");
          });
        }, m2.utcOffset = function() {
          return 15 * -Math.round(this.$d.getTimezoneOffset() / 15);
        }, m2.diff = function(r2, d2, l2) {
          var $2, y3 = O.p(d2), M3 = w2(r2), m3 = (M3.utcOffset() - this.utcOffset()) * e, v2 = this - M3, g2 = O.m(this, M3);
          return g2 = ($2 = {}, $2[c2] = g2 / 12, $2[f2] = g2, $2[h] = g2 / 3, $2[o] = (v2 - m3) / 6048e5, $2[a] = (v2 - m3) / 864e5, $2[u] = v2 / n, $2[s] = v2 / e, $2[i2] = v2 / t, $2)[y3] || v2, l2 ? g2 : O.a(g2);
        }, m2.daysInMonth = function() {
          return this.endOf(f2).$D;
        }, m2.$locale = function() {
          return D[this.$L];
        }, m2.locale = function(t4, e3) {
          if (!t4)
            return this.$L;
          var n2 = this.clone(), r2 = S(t4, e3, true);
          return r2 && (n2.$L = r2), n2;
        }, m2.clone = function() {
          return O.w(this.$d, this);
        }, m2.toDate = function() {
          return new Date(this.valueOf());
        }, m2.toJSON = function() {
          return this.isValid() ? this.toISOString() : null;
        }, m2.toISOString = function() {
          return this.$d.toISOString();
        }, m2.toString = function() {
          return this.$d.toUTCString();
        }, M2;
      }(), T = _2.prototype;
      return w2.prototype = T, [["$ms", r], ["$s", i2], ["$m", s], ["$H", u], ["$W", a], ["$M", f2], ["$y", c2], ["$D", d]].forEach(function(t4) {
        T[t4[1]] = function(e3) {
          return this.$g(e3, t4[0], t4[1]);
        };
      }), w2.extend = function(t4, e3) {
        return t4.$i || (t4(e3, _2, w2), t4.$i = true), w2;
      }, w2.locale = S, w2.isDayjs = p, w2.unix = function(t4) {
        return w2(1e3 * t4);
      }, w2.en = D[g], w2.Ls = D, w2.p = {}, w2;
    });
  })(dayjs_min);
  const dayjs = dayjs_minExports;
  const LEVELS = {
    trace: 0,
    debug: 1,
    info: 2,
    warn: 3,
    error: 4,
    fatal: 5
  };
  const log$1 = {
    trace: (..._args) => {
    },
    debug: (..._args) => {
    },
    info: (..._args) => {
    },
    warn: (..._args) => {
    },
    error: (..._args) => {
    },
    fatal: (..._args) => {
    }
  };
  const setLogLevel$1 = function(level = "fatal") {
    let numericLevel = LEVELS.fatal;
    if (typeof level === "string") {
      level = level.toLowerCase();
      if (level in LEVELS) {
        numericLevel = LEVELS[level];
      }
    } else if (typeof level === "number") {
      numericLevel = level;
    }
    log$1.trace = () => {
    };
    log$1.debug = () => {
    };
    log$1.info = () => {
    };
    log$1.warn = () => {
    };
    log$1.error = () => {
    };
    log$1.fatal = () => {
    };
    if (numericLevel <= LEVELS.fatal) {
      log$1.fatal = console.error ? console.error.bind(console, format$1("FATAL"), "color: orange") : console.log.bind(console, "\x1B[35m", format$1("FATAL"));
    }
    if (numericLevel <= LEVELS.error) {
      log$1.error = console.error ? console.error.bind(console, format$1("ERROR"), "color: orange") : console.log.bind(console, "\x1B[31m", format$1("ERROR"));
    }
    if (numericLevel <= LEVELS.warn) {
      log$1.warn = console.warn ? console.warn.bind(console, format$1("WARN"), "color: orange") : console.log.bind(console, `\x1B[33m`, format$1("WARN"));
    }
    if (numericLevel <= LEVELS.info) {
      log$1.info = console.info ? console.info.bind(console, format$1("INFO"), "color: lightblue") : console.log.bind(console, "\x1B[34m", format$1("INFO"));
    }
    if (numericLevel <= LEVELS.debug) {
      log$1.debug = console.debug ? console.debug.bind(console, format$1("DEBUG"), "color: lightgreen") : console.log.bind(console, "\x1B[32m", format$1("DEBUG"));
    }
    if (numericLevel <= LEVELS.trace) {
      log$1.trace = console.debug ? console.debug.bind(console, format$1("TRACE"), "color: lightgreen") : console.log.bind(console, "\x1B[32m", format$1("TRACE"));
    }
  };
  const format$1 = (level) => {
    const time2 = dayjs().format("ss.SSS");
    return `%c${time2} : ${level} : `;
  };
  var dist = {};
  Object.defineProperty(dist, "__esModule", { value: true });
  var sanitizeUrl_1 = dist.sanitizeUrl = void 0;
  var invalidProtocolRegex = /^([^\w]*)(javascript|data|vbscript)/im;
  var htmlEntitiesRegex = /&#(\w+)(^\w|;)?/g;
  var htmlCtrlEntityRegex = /&(newline|tab);/gi;
  var ctrlCharactersRegex = /[\u0000-\u001F\u007F-\u009F\u2000-\u200D\uFEFF]/gim;
  var urlSchemeRegex = /^.+(:|&colon;)/gim;
  var relativeFirstCharacters = [".", "/"];
  function isRelativeUrlWithoutProtocol(url) {
    return relativeFirstCharacters.indexOf(url[0]) > -1;
  }
  function decodeHtmlCharacters(str2) {
    return str2.replace(htmlEntitiesRegex, function(match, dec) {
      return String.fromCharCode(dec);
    });
  }
  function sanitizeUrl(url) {
    var sanitizedUrl = decodeHtmlCharacters(url || "").replace(htmlCtrlEntityRegex, "").replace(ctrlCharactersRegex, "").trim();
    if (!sanitizedUrl) {
      return "about:blank";
    }
    if (isRelativeUrlWithoutProtocol(sanitizedUrl)) {
      return sanitizedUrl;
    }
    var urlSchemeParseResults = sanitizedUrl.match(urlSchemeRegex);
    if (!urlSchemeParseResults) {
      return sanitizedUrl;
    }
    var urlScheme = urlSchemeParseResults[0];
    if (invalidProtocolRegex.test(urlScheme)) {
      return "about:blank";
    }
    return sanitizedUrl;
  }
  sanitizeUrl_1 = dist.sanitizeUrl = sanitizeUrl;
  function ascending$1(a, b) {
    return a == null || b == null ? NaN : a < b ? -1 : a > b ? 1 : a >= b ? 0 : NaN;
  }
  function descending$1(a, b) {
    return a == null || b == null ? NaN : b < a ? -1 : b > a ? 1 : b >= a ? 0 : NaN;
  }
  function bisector(f2) {
    let compare1, compare2, delta;
    if (f2.length !== 2) {
      compare1 = ascending$1;
      compare2 = (d, x2) => ascending$1(f2(d), x2);
      delta = (d, x2) => f2(d) - x2;
    } else {
      compare1 = f2 === ascending$1 || f2 === descending$1 ? f2 : zero$1;
      compare2 = f2;
      delta = f2;
    }
    function left2(a, x2, lo = 0, hi = a.length) {
      if (lo < hi) {
        if (compare1(x2, x2) !== 0)
          return hi;
        do {
          const mid = lo + hi >>> 1;
          if (compare2(a[mid], x2) < 0)
            lo = mid + 1;
          else
            hi = mid;
        } while (lo < hi);
      }
      return lo;
    }
    function right2(a, x2, lo = 0, hi = a.length) {
      if (lo < hi) {
        if (compare1(x2, x2) !== 0)
          return hi;
        do {
          const mid = lo + hi >>> 1;
          if (compare2(a[mid], x2) <= 0)
            lo = mid + 1;
          else
            hi = mid;
        } while (lo < hi);
      }
      return lo;
    }
    function center2(a, x2, lo = 0, hi = a.length) {
      const i2 = left2(a, x2, lo, hi - 1);
      return i2 > lo && delta(a[i2 - 1], x2) > -delta(a[i2], x2) ? i2 - 1 : i2;
    }
    return { left: left2, center: center2, right: right2 };
  }
  function zero$1() {
    return 0;
  }
  function number$3(x2) {
    return x2 === null ? NaN : +x2;
  }
  const ascendingBisect = bisector(ascending$1);
  const bisectRight = ascendingBisect.right;
  bisector(number$3).center;
  const bisect = bisectRight;
  class InternMap extends Map {
    constructor(entries2, key = keyof) {
      super();
      Object.defineProperties(this, { _intern: { value: /* @__PURE__ */ new Map() }, _key: { value: key } });
      if (entries2 != null)
        for (const [key2, value] of entries2)
          this.set(key2, value);
    }
    get(key) {
      return super.get(intern_get(this, key));
    }
    has(key) {
      return super.has(intern_get(this, key));
    }
    set(key, value) {
      return super.set(intern_set(this, key), value);
    }
    delete(key) {
      return super.delete(intern_delete(this, key));
    }
  }
  function intern_get({ _intern, _key }, value) {
    const key = _key(value);
    return _intern.has(key) ? _intern.get(key) : value;
  }
  function intern_set({ _intern, _key }, value) {
    const key = _key(value);
    if (_intern.has(key))
      return _intern.get(key);
    _intern.set(key, value);
    return value;
  }
  function intern_delete({ _intern, _key }, value) {
    const key = _key(value);
    if (_intern.has(key)) {
      value = _intern.get(key);
      _intern.delete(key);
    }
    return value;
  }
  function keyof(value) {
    return value !== null && typeof value === "object" ? value.valueOf() : value;
  }
  var e10 = Math.sqrt(50), e5 = Math.sqrt(10), e2 = Math.sqrt(2);
  function ticks(start2, stop, count) {
    var reverse, i2 = -1, n, ticks2, step;
    stop = +stop, start2 = +start2, count = +count;
    if (start2 === stop && count > 0)
      return [start2];
    if (reverse = stop < start2)
      n = start2, start2 = stop, stop = n;
    if ((step = tickIncrement(start2, stop, count)) === 0 || !isFinite(step))
      return [];
    if (step > 0) {
      let r0 = Math.round(start2 / step), r1 = Math.round(stop / step);
      if (r0 * step < start2)
        ++r0;
      if (r1 * step > stop)
        --r1;
      ticks2 = new Array(n = r1 - r0 + 1);
      while (++i2 < n)
        ticks2[i2] = (r0 + i2) * step;
    } else {
      step = -step;
      let r0 = Math.round(start2 * step), r1 = Math.round(stop * step);
      if (r0 / step < start2)
        ++r0;
      if (r1 / step > stop)
        --r1;
      ticks2 = new Array(n = r1 - r0 + 1);
      while (++i2 < n)
        ticks2[i2] = (r0 + i2) / step;
    }
    if (reverse)
      ticks2.reverse();
    return ticks2;
  }
  function tickIncrement(start2, stop, count) {
    var step = (stop - start2) / Math.max(0, count), power = Math.floor(Math.log(step) / Math.LN10), error = step / Math.pow(10, power);
    return power >= 0 ? (error >= e10 ? 10 : error >= e5 ? 5 : error >= e2 ? 2 : 1) * Math.pow(10, power) : -Math.pow(10, -power) / (error >= e10 ? 10 : error >= e5 ? 5 : error >= e2 ? 2 : 1);
  }
  function tickStep(start2, stop, count) {
    var step0 = Math.abs(stop - start2) / Math.max(0, count), step1 = Math.pow(10, Math.floor(Math.log(step0) / Math.LN10)), error = step0 / step1;
    if (error >= e10)
      step1 *= 10;
    else if (error >= e5)
      step1 *= 5;
    else if (error >= e2)
      step1 *= 2;
    return stop < start2 ? -step1 : step1;
  }
  function max$2(values2, valueof) {
    let max2;
    if (valueof === void 0) {
      for (const value of values2) {
        if (value != null && (max2 < value || max2 === void 0 && value >= value)) {
          max2 = value;
        }
      }
    } else {
      let index2 = -1;
      for (let value of values2) {
        if ((value = valueof(value, ++index2, values2)) != null && (max2 < value || max2 === void 0 && value >= value)) {
          max2 = value;
        }
      }
    }
    return max2;
  }
  function min$2(values2, valueof) {
    let min2;
    if (valueof === void 0) {
      for (const value of values2) {
        if (value != null && (min2 > value || min2 === void 0 && value >= value)) {
          min2 = value;
        }
      }
    } else {
      let index2 = -1;
      for (let value of values2) {
        if ((value = valueof(value, ++index2, values2)) != null && (min2 > value || min2 === void 0 && value >= value)) {
          min2 = value;
        }
      }
    }
    return min2;
  }
  function identity$5(x2) {
    return x2;
  }
  var top = 1, right = 2, bottom = 3, left = 4, epsilon$2 = 1e-6;
  function translateX(x2) {
    return "translate(" + x2 + ",0)";
  }
  function translateY(y2) {
    return "translate(0," + y2 + ")";
  }
  function number$2(scale) {
    return (d) => +scale(d);
  }
  function center(scale, offset) {
    offset = Math.max(0, scale.bandwidth() - offset * 2) / 2;
    if (scale.round())
      offset = Math.round(offset);
    return (d) => +scale(d) + offset;
  }
  function entering() {
    return !this.__axis;
  }
  function axis(orient, scale) {
    var tickArguments = [], tickValues = null, tickFormat2 = null, tickSizeInner = 6, tickSizeOuter = 6, tickPadding = 3, offset = typeof window !== "undefined" && window.devicePixelRatio > 1 ? 0 : 0.5, k = orient === top || orient === left ? -1 : 1, x2 = orient === left || orient === right ? "x" : "y", transform = orient === top || orient === bottom ? translateX : translateY;
    function axis2(context) {
      var values2 = tickValues == null ? scale.ticks ? scale.ticks.apply(scale, tickArguments) : scale.domain() : tickValues, format2 = tickFormat2 == null ? scale.tickFormat ? scale.tickFormat.apply(scale, tickArguments) : identity$5 : tickFormat2, spacing = Math.max(tickSizeInner, 0) + tickPadding, range2 = scale.range(), range0 = +range2[0] + offset, range1 = +range2[range2.length - 1] + offset, position2 = (scale.bandwidth ? center : number$2)(scale.copy(), offset), selection2 = context.selection ? context.selection() : context, path2 = selection2.selectAll(".domain").data([null]), tick = selection2.selectAll(".tick").data(values2, scale).order(), tickExit = tick.exit(), tickEnter = tick.enter().append("g").attr("class", "tick"), line2 = tick.select("line"), text2 = tick.select("text");
      path2 = path2.merge(path2.enter().insert("path", ".tick").attr("class", "domain").attr("stroke", "currentColor"));
      tick = tick.merge(tickEnter);
      line2 = line2.merge(tickEnter.append("line").attr("stroke", "currentColor").attr(x2 + "2", k * tickSizeInner));
      text2 = text2.merge(tickEnter.append("text").attr("fill", "currentColor").attr(x2, k * spacing).attr("dy", orient === top ? "0em" : orient === bottom ? "0.71em" : "0.32em"));
      if (context !== selection2) {
        path2 = path2.transition(context);
        tick = tick.transition(context);
        line2 = line2.transition(context);
        text2 = text2.transition(context);
        tickExit = tickExit.transition(context).attr("opacity", epsilon$2).attr("transform", function(d) {
          return isFinite(d = position2(d)) ? transform(d + offset) : this.getAttribute("transform");
        });
        tickEnter.attr("opacity", epsilon$2).attr("transform", function(d) {
          var p = this.parentNode.__axis;
          return transform((p && isFinite(p = p(d)) ? p : position2(d)) + offset);
        });
      }
      tickExit.remove();
      path2.attr("d", orient === left || orient === right ? tickSizeOuter ? "M" + k * tickSizeOuter + "," + range0 + "H" + offset + "V" + range1 + "H" + k * tickSizeOuter : "M" + offset + "," + range0 + "V" + range1 : tickSizeOuter ? "M" + range0 + "," + k * tickSizeOuter + "V" + offset + "H" + range1 + "V" + k * tickSizeOuter : "M" + range0 + "," + offset + "H" + range1);
      tick.attr("opacity", 1).attr("transform", function(d) {
        return transform(position2(d) + offset);
      });
      line2.attr(x2 + "2", k * tickSizeInner);
      text2.attr(x2, k * spacing).text(format2);
      selection2.filter(entering).attr("fill", "none").attr("font-size", 10).attr("font-family", "sans-serif").attr("text-anchor", orient === right ? "start" : orient === left ? "end" : "middle");
      selection2.each(function() {
        this.__axis = position2;
      });
    }
    axis2.scale = function(_2) {
      return arguments.length ? (scale = _2, axis2) : scale;
    };
    axis2.ticks = function() {
      return tickArguments = Array.from(arguments), axis2;
    };
    axis2.tickArguments = function(_2) {
      return arguments.length ? (tickArguments = _2 == null ? [] : Array.from(_2), axis2) : tickArguments.slice();
    };
    axis2.tickValues = function(_2) {
      return arguments.length ? (tickValues = _2 == null ? null : Array.from(_2), axis2) : tickValues && tickValues.slice();
    };
    axis2.tickFormat = function(_2) {
      return arguments.length ? (tickFormat2 = _2, axis2) : tickFormat2;
    };
    axis2.tickSize = function(_2) {
      return arguments.length ? (tickSizeInner = tickSizeOuter = +_2, axis2) : tickSizeInner;
    };
    axis2.tickSizeInner = function(_2) {
      return arguments.length ? (tickSizeInner = +_2, axis2) : tickSizeInner;
    };
    axis2.tickSizeOuter = function(_2) {
      return arguments.length ? (tickSizeOuter = +_2, axis2) : tickSizeOuter;
    };
    axis2.tickPadding = function(_2) {
      return arguments.length ? (tickPadding = +_2, axis2) : tickPadding;
    };
    axis2.offset = function(_2) {
      return arguments.length ? (offset = +_2, axis2) : offset;
    };
    return axis2;
  }
  function axisTop(scale) {
    return axis(top, scale);
  }
  function axisBottom(scale) {
    return axis(bottom, scale);
  }
  var noop$2 = { value: () => {
  } };
  function dispatch() {
    for (var i2 = 0, n = arguments.length, _2 = {}, t; i2 < n; ++i2) {
      if (!(t = arguments[i2] + "") || t in _2 || /[\s.]/.test(t))
        throw new Error("illegal type: " + t);
      _2[t] = [];
    }
    return new Dispatch(_2);
  }
  function Dispatch(_2) {
    this._ = _2;
  }
  function parseTypenames$1(typenames, types) {
    return typenames.trim().split(/^|\s+/).map(function(t) {
      var name2 = "", i2 = t.indexOf(".");
      if (i2 >= 0)
        name2 = t.slice(i2 + 1), t = t.slice(0, i2);
      if (t && !types.hasOwnProperty(t))
        throw new Error("unknown type: " + t);
      return { type: t, name: name2 };
    });
  }
  Dispatch.prototype = dispatch.prototype = {
    constructor: Dispatch,
    on: function(typename, callback) {
      var _2 = this._, T = parseTypenames$1(typename + "", _2), t, i2 = -1, n = T.length;
      if (arguments.length < 2) {
        while (++i2 < n)
          if ((t = (typename = T[i2]).type) && (t = get$3(_2[t], typename.name)))
            return t;
        return;
      }
      if (callback != null && typeof callback !== "function")
        throw new Error("invalid callback: " + callback);
      while (++i2 < n) {
        if (t = (typename = T[i2]).type)
          _2[t] = set$3(_2[t], typename.name, callback);
        else if (callback == null)
          for (t in _2)
            _2[t] = set$3(_2[t], typename.name, null);
      }
      return this;
    },
    copy: function() {
      var copy2 = {}, _2 = this._;
      for (var t in _2)
        copy2[t] = _2[t].slice();
      return new Dispatch(copy2);
    },
    call: function(type2, that) {
      if ((n = arguments.length - 2) > 0)
        for (var args = new Array(n), i2 = 0, n, t; i2 < n; ++i2)
          args[i2] = arguments[i2 + 2];
      if (!this._.hasOwnProperty(type2))
        throw new Error("unknown type: " + type2);
      for (t = this._[type2], i2 = 0, n = t.length; i2 < n; ++i2)
        t[i2].value.apply(that, args);
    },
    apply: function(type2, that, args) {
      if (!this._.hasOwnProperty(type2))
        throw new Error("unknown type: " + type2);
      for (var t = this._[type2], i2 = 0, n = t.length; i2 < n; ++i2)
        t[i2].value.apply(that, args);
    }
  };
  function get$3(type2, name2) {
    for (var i2 = 0, n = type2.length, c2; i2 < n; ++i2) {
      if ((c2 = type2[i2]).name === name2) {
        return c2.value;
      }
    }
  }
  function set$3(type2, name2, callback) {
    for (var i2 = 0, n = type2.length; i2 < n; ++i2) {
      if (type2[i2].name === name2) {
        type2[i2] = noop$2, type2 = type2.slice(0, i2).concat(type2.slice(i2 + 1));
        break;
      }
    }
    if (callback != null)
      type2.push({ name: name2, value: callback });
    return type2;
  }
  var xhtml = "http://www.w3.org/1999/xhtml";
  const namespaces$1 = {
    svg: "http://www.w3.org/2000/svg",
    xhtml,
    xlink: "http://www.w3.org/1999/xlink",
    xml: "http://www.w3.org/XML/1998/namespace",
    xmlns: "http://www.w3.org/2000/xmlns/"
  };
  function namespace(name2) {
    var prefix = name2 += "", i2 = prefix.indexOf(":");
    if (i2 >= 0 && (prefix = name2.slice(0, i2)) !== "xmlns")
      name2 = name2.slice(i2 + 1);
    return namespaces$1.hasOwnProperty(prefix) ? { space: namespaces$1[prefix], local: name2 } : name2;
  }
  function creatorInherit(name2) {
    return function() {
      var document2 = this.ownerDocument, uri = this.namespaceURI;
      return uri === xhtml && document2.documentElement.namespaceURI === xhtml ? document2.createElement(name2) : document2.createElementNS(uri, name2);
    };
  }
  function creatorFixed(fullname) {
    return function() {
      return this.ownerDocument.createElementNS(fullname.space, fullname.local);
    };
  }
  function creator(name2) {
    var fullname = namespace(name2);
    return (fullname.local ? creatorFixed : creatorInherit)(fullname);
  }
  function none() {
  }
  function selector(selector2) {
    return selector2 == null ? none : function() {
      return this.querySelector(selector2);
    };
  }
  function selection_select(select2) {
    if (typeof select2 !== "function")
      select2 = selector(select2);
    for (var groups = this._groups, m = groups.length, subgroups = new Array(m), j = 0; j < m; ++j) {
      for (var group = groups[j], n = group.length, subgroup = subgroups[j] = new Array(n), node2, subnode, i2 = 0; i2 < n; ++i2) {
        if ((node2 = group[i2]) && (subnode = select2.call(node2, node2.__data__, i2, group))) {
          if ("__data__" in node2)
            subnode.__data__ = node2.__data__;
          subgroup[i2] = subnode;
        }
      }
    }
    return new Selection$1(subgroups, this._parents);
  }
  function array$1(x2) {
    return x2 == null ? [] : Array.isArray(x2) ? x2 : Array.from(x2);
  }
  function empty() {
    return [];
  }
  function selectorAll(selector2) {
    return selector2 == null ? empty : function() {
      return this.querySelectorAll(selector2);
    };
  }
  function arrayAll(select2) {
    return function() {
      return array$1(select2.apply(this, arguments));
    };
  }
  function selection_selectAll(select2) {
    if (typeof select2 === "function")
      select2 = arrayAll(select2);
    else
      select2 = selectorAll(select2);
    for (var groups = this._groups, m = groups.length, subgroups = [], parents2 = [], j = 0; j < m; ++j) {
      for (var group = groups[j], n = group.length, node2, i2 = 0; i2 < n; ++i2) {
        if (node2 = group[i2]) {
          subgroups.push(select2.call(node2, node2.__data__, i2, group));
          parents2.push(node2);
        }
      }
    }
    return new Selection$1(subgroups, parents2);
  }
  function matcher(selector2) {
    return function() {
      return this.matches(selector2);
    };
  }
  function childMatcher(selector2) {
    return function(node2) {
      return node2.matches(selector2);
    };
  }
  var find$2 = Array.prototype.find;
  function childFind(match) {
    return function() {
      return find$2.call(this.children, match);
    };
  }
  function childFirst() {
    return this.firstElementChild;
  }
  function selection_selectChild(match) {
    return this.select(match == null ? childFirst : childFind(typeof match === "function" ? match : childMatcher(match)));
  }
  var filter$1 = Array.prototype.filter;
  function children() {
    return Array.from(this.children);
  }
  function childrenFilter(match) {
    return function() {
      return filter$1.call(this.children, match);
    };
  }
  function selection_selectChildren(match) {
    return this.selectAll(match == null ? children : childrenFilter(typeof match === "function" ? match : childMatcher(match)));
  }
  function selection_filter(match) {
    if (typeof match !== "function")
      match = matcher(match);
    for (var groups = this._groups, m = groups.length, subgroups = new Array(m), j = 0; j < m; ++j) {
      for (var group = groups[j], n = group.length, subgroup = subgroups[j] = [], node2, i2 = 0; i2 < n; ++i2) {
        if ((node2 = group[i2]) && match.call(node2, node2.__data__, i2, group)) {
          subgroup.push(node2);
        }
      }
    }
    return new Selection$1(subgroups, this._parents);
  }
  function sparse(update2) {
    return new Array(update2.length);
  }
  function selection_enter() {
    return new Selection$1(this._enter || this._groups.map(sparse), this._parents);
  }
  function EnterNode(parent, datum2) {
    this.ownerDocument = parent.ownerDocument;
    this.namespaceURI = parent.namespaceURI;
    this._next = null;
    this._parent = parent;
    this.__data__ = datum2;
  }
  EnterNode.prototype = {
    constructor: EnterNode,
    appendChild: function(child) {
      return this._parent.insertBefore(child, this._next);
    },
    insertBefore: function(child, next2) {
      return this._parent.insertBefore(child, next2);
    },
    querySelector: function(selector2) {
      return this._parent.querySelector(selector2);
    },
    querySelectorAll: function(selector2) {
      return this._parent.querySelectorAll(selector2);
    }
  };
  function constant$3(x2) {
    return function() {
      return x2;
    };
  }
  function bindIndex(parent, group, enter2, update2, exit2, data) {
    var i2 = 0, node2, groupLength = group.length, dataLength = data.length;
    for (; i2 < dataLength; ++i2) {
      if (node2 = group[i2]) {
        node2.__data__ = data[i2];
        update2[i2] = node2;
      } else {
        enter2[i2] = new EnterNode(parent, data[i2]);
      }
    }
    for (; i2 < groupLength; ++i2) {
      if (node2 = group[i2]) {
        exit2[i2] = node2;
      }
    }
  }
  function bindKey(parent, group, enter2, update2, exit2, data, key) {
    var i2, node2, nodeByKeyValue = /* @__PURE__ */ new Map(), groupLength = group.length, dataLength = data.length, keyValues = new Array(groupLength), keyValue;
    for (i2 = 0; i2 < groupLength; ++i2) {
      if (node2 = group[i2]) {
        keyValues[i2] = keyValue = key.call(node2, node2.__data__, i2, group) + "";
        if (nodeByKeyValue.has(keyValue)) {
          exit2[i2] = node2;
        } else {
          nodeByKeyValue.set(keyValue, node2);
        }
      }
    }
    for (i2 = 0; i2 < dataLength; ++i2) {
      keyValue = key.call(parent, data[i2], i2, data) + "";
      if (node2 = nodeByKeyValue.get(keyValue)) {
        update2[i2] = node2;
        node2.__data__ = data[i2];
        nodeByKeyValue.delete(keyValue);
      } else {
        enter2[i2] = new EnterNode(parent, data[i2]);
      }
    }
    for (i2 = 0; i2 < groupLength; ++i2) {
      if ((node2 = group[i2]) && nodeByKeyValue.get(keyValues[i2]) === node2) {
        exit2[i2] = node2;
      }
    }
  }
  function datum(node2) {
    return node2.__data__;
  }
  function selection_data(value, key) {
    if (!arguments.length)
      return Array.from(this, datum);
    var bind = key ? bindKey : bindIndex, parents2 = this._parents, groups = this._groups;
    if (typeof value !== "function")
      value = constant$3(value);
    for (var m = groups.length, update2 = new Array(m), enter2 = new Array(m), exit2 = new Array(m), j = 0; j < m; ++j) {
      var parent = parents2[j], group = groups[j], groupLength = group.length, data = arraylike(value.call(parent, parent && parent.__data__, j, parents2)), dataLength = data.length, enterGroup = enter2[j] = new Array(dataLength), updateGroup = update2[j] = new Array(dataLength), exitGroup = exit2[j] = new Array(groupLength);
      bind(parent, group, enterGroup, updateGroup, exitGroup, data, key);
      for (var i0 = 0, i1 = 0, previous2, next2; i0 < dataLength; ++i0) {
        if (previous2 = enterGroup[i0]) {
          if (i0 >= i1)
            i1 = i0 + 1;
          while (!(next2 = updateGroup[i1]) && ++i1 < dataLength)
            ;
          previous2._next = next2 || null;
        }
      }
    }
    update2 = new Selection$1(update2, parents2);
    update2._enter = enter2;
    update2._exit = exit2;
    return update2;
  }
  function arraylike(data) {
    return typeof data === "object" && "length" in data ? data : Array.from(data);
  }
  function selection_exit() {
    return new Selection$1(this._exit || this._groups.map(sparse), this._parents);
  }
  function selection_join(onenter, onupdate, onexit) {
    var enter2 = this.enter(), update2 = this, exit2 = this.exit();
    if (typeof onenter === "function") {
      enter2 = onenter(enter2);
      if (enter2)
        enter2 = enter2.selection();
    } else {
      enter2 = enter2.append(onenter + "");
    }
    if (onupdate != null) {
      update2 = onupdate(update2);
      if (update2)
        update2 = update2.selection();
    }
    if (onexit == null)
      exit2.remove();
    else
      onexit(exit2);
    return enter2 && update2 ? enter2.merge(update2).order() : update2;
  }
  function selection_merge(context) {
    var selection2 = context.selection ? context.selection() : context;
    for (var groups0 = this._groups, groups1 = selection2._groups, m0 = groups0.length, m1 = groups1.length, m = Math.min(m0, m1), merges = new Array(m0), j = 0; j < m; ++j) {
      for (var group0 = groups0[j], group1 = groups1[j], n = group0.length, merge2 = merges[j] = new Array(n), node2, i2 = 0; i2 < n; ++i2) {
        if (node2 = group0[i2] || group1[i2]) {
          merge2[i2] = node2;
        }
      }
    }
    for (; j < m0; ++j) {
      merges[j] = groups0[j];
    }
    return new Selection$1(merges, this._parents);
  }
  function selection_order() {
    for (var groups = this._groups, j = -1, m = groups.length; ++j < m; ) {
      for (var group = groups[j], i2 = group.length - 1, next2 = group[i2], node2; --i2 >= 0; ) {
        if (node2 = group[i2]) {
          if (next2 && node2.compareDocumentPosition(next2) ^ 4)
            next2.parentNode.insertBefore(node2, next2);
          next2 = node2;
        }
      }
    }
    return this;
  }
  function selection_sort(compare) {
    if (!compare)
      compare = ascending;
    function compareNode(a, b) {
      return a && b ? compare(a.__data__, b.__data__) : !a - !b;
    }
    for (var groups = this._groups, m = groups.length, sortgroups = new Array(m), j = 0; j < m; ++j) {
      for (var group = groups[j], n = group.length, sortgroup = sortgroups[j] = new Array(n), node2, i2 = 0; i2 < n; ++i2) {
        if (node2 = group[i2]) {
          sortgroup[i2] = node2;
        }
      }
      sortgroup.sort(compareNode);
    }
    return new Selection$1(sortgroups, this._parents).order();
  }
  function ascending(a, b) {
    return a < b ? -1 : a > b ? 1 : a >= b ? 0 : NaN;
  }
  function selection_call() {
    var callback = arguments[0];
    arguments[0] = this;
    callback.apply(null, arguments);
    return this;
  }
  function selection_nodes() {
    return Array.from(this);
  }
  function selection_node() {
    for (var groups = this._groups, j = 0, m = groups.length; j < m; ++j) {
      for (var group = groups[j], i2 = 0, n = group.length; i2 < n; ++i2) {
        var node2 = group[i2];
        if (node2)
          return node2;
      }
    }
    return null;
  }
  function selection_size() {
    let size2 = 0;
    for (const node2 of this)
      ++size2;
    return size2;
  }
  function selection_empty() {
    return !this.node();
  }
  function selection_each(callback) {
    for (var groups = this._groups, j = 0, m = groups.length; j < m; ++j) {
      for (var group = groups[j], i2 = 0, n = group.length, node2; i2 < n; ++i2) {
        if (node2 = group[i2])
          callback.call(node2, node2.__data__, i2, group);
      }
    }
    return this;
  }
  function attrRemove$1(name2) {
    return function() {
      this.removeAttribute(name2);
    };
  }
  function attrRemoveNS$1(fullname) {
    return function() {
      this.removeAttributeNS(fullname.space, fullname.local);
    };
  }
  function attrConstant$1(name2, value) {
    return function() {
      this.setAttribute(name2, value);
    };
  }
  function attrConstantNS$1(fullname, value) {
    return function() {
      this.setAttributeNS(fullname.space, fullname.local, value);
    };
  }
  function attrFunction$1(name2, value) {
    return function() {
      var v = value.apply(this, arguments);
      if (v == null)
        this.removeAttribute(name2);
      else
        this.setAttribute(name2, v);
    };
  }
  function attrFunctionNS$1(fullname, value) {
    return function() {
      var v = value.apply(this, arguments);
      if (v == null)
        this.removeAttributeNS(fullname.space, fullname.local);
      else
        this.setAttributeNS(fullname.space, fullname.local, v);
    };
  }
  function selection_attr(name2, value) {
    var fullname = namespace(name2);
    if (arguments.length < 2) {
      var node2 = this.node();
      return fullname.local ? node2.getAttributeNS(fullname.space, fullname.local) : node2.getAttribute(fullname);
    }
    return this.each((value == null ? fullname.local ? attrRemoveNS$1 : attrRemove$1 : typeof value === "function" ? fullname.local ? attrFunctionNS$1 : attrFunction$1 : fullname.local ? attrConstantNS$1 : attrConstant$1)(fullname, value));
  }
  function defaultView(node2) {
    return node2.ownerDocument && node2.ownerDocument.defaultView || node2.document && node2 || node2.defaultView;
  }
  function styleRemove$1(name2) {
    return function() {
      this.style.removeProperty(name2);
    };
  }
  function styleConstant$1(name2, value, priority) {
    return function() {
      this.style.setProperty(name2, value, priority);
    };
  }
  function styleFunction$1(name2, value, priority) {
    return function() {
      var v = value.apply(this, arguments);
      if (v == null)
        this.style.removeProperty(name2);
      else
        this.style.setProperty(name2, v, priority);
    };
  }
  function selection_style(name2, value, priority) {
    return arguments.length > 1 ? this.each((value == null ? styleRemove$1 : typeof value === "function" ? styleFunction$1 : styleConstant$1)(name2, value, priority == null ? "" : priority)) : styleValue(this.node(), name2);
  }
  function styleValue(node2, name2) {
    return node2.style.getPropertyValue(name2) || defaultView(node2).getComputedStyle(node2, null).getPropertyValue(name2);
  }
  function propertyRemove(name2) {
    return function() {
      delete this[name2];
    };
  }
  function propertyConstant(name2, value) {
    return function() {
      this[name2] = value;
    };
  }
  function propertyFunction(name2, value) {
    return function() {
      var v = value.apply(this, arguments);
      if (v == null)
        delete this[name2];
      else
        this[name2] = v;
    };
  }
  function selection_property(name2, value) {
    return arguments.length > 1 ? this.each((value == null ? propertyRemove : typeof value === "function" ? propertyFunction : propertyConstant)(name2, value)) : this.node()[name2];
  }
  function classArray(string2) {
    return string2.trim().split(/^|\s+/);
  }
  function classList(node2) {
    return node2.classList || new ClassList(node2);
  }
  function ClassList(node2) {
    this._node = node2;
    this._names = classArray(node2.getAttribute("class") || "");
  }
  ClassList.prototype = {
    add: function(name2) {
      var i2 = this._names.indexOf(name2);
      if (i2 < 0) {
        this._names.push(name2);
        this._node.setAttribute("class", this._names.join(" "));
      }
    },
    remove: function(name2) {
      var i2 = this._names.indexOf(name2);
      if (i2 >= 0) {
        this._names.splice(i2, 1);
        this._node.setAttribute("class", this._names.join(" "));
      }
    },
    contains: function(name2) {
      return this._names.indexOf(name2) >= 0;
    }
  };
  function classedAdd(node2, names) {
    var list2 = classList(node2), i2 = -1, n = names.length;
    while (++i2 < n)
      list2.add(names[i2]);
  }
  function classedRemove(node2, names) {
    var list2 = classList(node2), i2 = -1, n = names.length;
    while (++i2 < n)
      list2.remove(names[i2]);
  }
  function classedTrue(names) {
    return function() {
      classedAdd(this, names);
    };
  }
  function classedFalse(names) {
    return function() {
      classedRemove(this, names);
    };
  }
  function classedFunction(names, value) {
    return function() {
      (value.apply(this, arguments) ? classedAdd : classedRemove)(this, names);
    };
  }
  function selection_classed(name2, value) {
    var names = classArray(name2 + "");
    if (arguments.length < 2) {
      var list2 = classList(this.node()), i2 = -1, n = names.length;
      while (++i2 < n)
        if (!list2.contains(names[i2]))
          return false;
      return true;
    }
    return this.each((typeof value === "function" ? classedFunction : value ? classedTrue : classedFalse)(names, value));
  }
  function textRemove() {
    this.textContent = "";
  }
  function textConstant$1(value) {
    return function() {
      this.textContent = value;
    };
  }
  function textFunction$1(value) {
    return function() {
      var v = value.apply(this, arguments);
      this.textContent = v == null ? "" : v;
    };
  }
  function selection_text(value) {
    return arguments.length ? this.each(value == null ? textRemove : (typeof value === "function" ? textFunction$1 : textConstant$1)(value)) : this.node().textContent;
  }
  function htmlRemove() {
    this.innerHTML = "";
  }
  function htmlConstant(value) {
    return function() {
      this.innerHTML = value;
    };
  }
  function htmlFunction(value) {
    return function() {
      var v = value.apply(this, arguments);
      this.innerHTML = v == null ? "" : v;
    };
  }
  function selection_html(value) {
    return arguments.length ? this.each(value == null ? htmlRemove : (typeof value === "function" ? htmlFunction : htmlConstant)(value)) : this.node().innerHTML;
  }
  function raise() {
    if (this.nextSibling)
      this.parentNode.appendChild(this);
  }
  function selection_raise() {
    return this.each(raise);
  }
  function lower() {
    if (this.previousSibling)
      this.parentNode.insertBefore(this, this.parentNode.firstChild);
  }
  function selection_lower() {
    return this.each(lower);
  }
  function selection_append(name2) {
    var create2 = typeof name2 === "function" ? name2 : creator(name2);
    return this.select(function() {
      return this.appendChild(create2.apply(this, arguments));
    });
  }
  function constantNull() {
    return null;
  }
  function selection_insert(name2, before) {
    var create2 = typeof name2 === "function" ? name2 : creator(name2), select2 = before == null ? constantNull : typeof before === "function" ? before : selector(before);
    return this.select(function() {
      return this.insertBefore(create2.apply(this, arguments), select2.apply(this, arguments) || null);
    });
  }
  function remove() {
    var parent = this.parentNode;
    if (parent)
      parent.removeChild(this);
  }
  function selection_remove() {
    return this.each(remove);
  }
  function selection_cloneShallow() {
    var clone2 = this.cloneNode(false), parent = this.parentNode;
    return parent ? parent.insertBefore(clone2, this.nextSibling) : clone2;
  }
  function selection_cloneDeep() {
    var clone2 = this.cloneNode(true), parent = this.parentNode;
    return parent ? parent.insertBefore(clone2, this.nextSibling) : clone2;
  }
  function selection_clone(deep) {
    return this.select(deep ? selection_cloneDeep : selection_cloneShallow);
  }
  function selection_datum(value) {
    return arguments.length ? this.property("__data__", value) : this.node().__data__;
  }
  function contextListener(listener) {
    return function(event) {
      listener.call(this, event, this.__data__);
    };
  }
  function parseTypenames(typenames) {
    return typenames.trim().split(/^|\s+/).map(function(t) {
      var name2 = "", i2 = t.indexOf(".");
      if (i2 >= 0)
        name2 = t.slice(i2 + 1), t = t.slice(0, i2);
      return { type: t, name: name2 };
    });
  }
  function onRemove(typename) {
    return function() {
      var on = this.__on;
      if (!on)
        return;
      for (var j = 0, i2 = -1, m = on.length, o; j < m; ++j) {
        if (o = on[j], (!typename.type || o.type === typename.type) && o.name === typename.name) {
          this.removeEventListener(o.type, o.listener, o.options);
        } else {
          on[++i2] = o;
        }
      }
      if (++i2)
        on.length = i2;
      else
        delete this.__on;
    };
  }
  function onAdd(typename, value, options2) {
    return function() {
      var on = this.__on, o, listener = contextListener(value);
      if (on)
        for (var j = 0, m = on.length; j < m; ++j) {
          if ((o = on[j]).type === typename.type && o.name === typename.name) {
            this.removeEventListener(o.type, o.listener, o.options);
            this.addEventListener(o.type, o.listener = listener, o.options = options2);
            o.value = value;
            return;
          }
        }
      this.addEventListener(typename.type, listener, options2);
      o = { type: typename.type, name: typename.name, value, listener, options: options2 };
      if (!on)
        this.__on = [o];
      else
        on.push(o);
    };
  }
  function selection_on(typename, value, options2) {
    var typenames = parseTypenames(typename + ""), i2, n = typenames.length, t;
    if (arguments.length < 2) {
      var on = this.node().__on;
      if (on)
        for (var j = 0, m = on.length, o; j < m; ++j) {
          for (i2 = 0, o = on[j]; i2 < n; ++i2) {
            if ((t = typenames[i2]).type === o.type && t.name === o.name) {
              return o.value;
            }
          }
        }
      return;
    }
    on = value ? onAdd : onRemove;
    for (i2 = 0; i2 < n; ++i2)
      this.each(on(typenames[i2], value, options2));
    return this;
  }
  function dispatchEvent(node2, type2, params) {
    var window2 = defaultView(node2), event = window2.CustomEvent;
    if (typeof event === "function") {
      event = new event(type2, params);
    } else {
      event = window2.document.createEvent("Event");
      if (params)
        event.initEvent(type2, params.bubbles, params.cancelable), event.detail = params.detail;
      else
        event.initEvent(type2, false, false);
    }
    node2.dispatchEvent(event);
  }
  function dispatchConstant(type2, params) {
    return function() {
      return dispatchEvent(this, type2, params);
    };
  }
  function dispatchFunction(type2, params) {
    return function() {
      return dispatchEvent(this, type2, params.apply(this, arguments));
    };
  }
  function selection_dispatch(type2, params) {
    return this.each((typeof params === "function" ? dispatchFunction : dispatchConstant)(type2, params));
  }
  function* selection_iterator() {
    for (var groups = this._groups, j = 0, m = groups.length; j < m; ++j) {
      for (var group = groups[j], i2 = 0, n = group.length, node2; i2 < n; ++i2) {
        if (node2 = group[i2])
          yield node2;
      }
    }
  }
  var root$2 = [null];
  function Selection$1(groups, parents2) {
    this._groups = groups;
    this._parents = parents2;
  }
  function selection() {
    return new Selection$1([[document.documentElement]], root$2);
  }
  function selection_selection() {
    return this;
  }
  Selection$1.prototype = selection.prototype = {
    constructor: Selection$1,
    select: selection_select,
    selectAll: selection_selectAll,
    selectChild: selection_selectChild,
    selectChildren: selection_selectChildren,
    filter: selection_filter,
    data: selection_data,
    enter: selection_enter,
    exit: selection_exit,
    join: selection_join,
    merge: selection_merge,
    selection: selection_selection,
    order: selection_order,
    sort: selection_sort,
    call: selection_call,
    nodes: selection_nodes,
    node: selection_node,
    size: selection_size,
    empty: selection_empty,
    each: selection_each,
    attr: selection_attr,
    style: selection_style,
    property: selection_property,
    classed: selection_classed,
    text: selection_text,
    html: selection_html,
    raise: selection_raise,
    lower: selection_lower,
    append: selection_append,
    insert: selection_insert,
    remove: selection_remove,
    clone: selection_clone,
    datum: selection_datum,
    on: selection_on,
    dispatch: selection_dispatch,
    [Symbol.iterator]: selection_iterator
  };
  function select(selector2) {
    return typeof selector2 === "string" ? new Selection$1([[document.querySelector(selector2)]], [document.documentElement]) : new Selection$1([[selector2]], root$2);
  }
  function selectAll(selector2) {
    return typeof selector2 === "string" ? new Selection$1([document.querySelectorAll(selector2)], [document.documentElement]) : new Selection$1([array$1(selector2)], root$2);
  }
  function define2(constructor, factory, prototype) {
    constructor.prototype = factory.prototype = prototype;
    prototype.constructor = constructor;
  }
  function extend$1(parent, definition2) {
    var prototype = Object.create(parent.prototype);
    for (var key in definition2)
      prototype[key] = definition2[key];
    return prototype;
  }
  function Color$2() {
  }
  var darker = 0.7;
  var brighter = 1 / darker;
  var reI = "\\s*([+-]?\\d+)\\s*", reN = "\\s*([+-]?(?:\\d*\\.)?\\d+(?:[eE][+-]?\\d+)?)\\s*", reP = "\\s*([+-]?(?:\\d*\\.)?\\d+(?:[eE][+-]?\\d+)?)%\\s*", reHex = /^#([0-9a-f]{3,8})$/, reRgbInteger = new RegExp(`^rgb\\(${reI},${reI},${reI}\\)$`), reRgbPercent = new RegExp(`^rgb\\(${reP},${reP},${reP}\\)$`), reRgbaInteger = new RegExp(`^rgba\\(${reI},${reI},${reI},${reN}\\)$`), reRgbaPercent = new RegExp(`^rgba\\(${reP},${reP},${reP},${reN}\\)$`), reHslPercent = new RegExp(`^hsl\\(${reN},${reP},${reP}\\)$`), reHslaPercent = new RegExp(`^hsla\\(${reN},${reP},${reP},${reN}\\)$`);
  var named = {
    aliceblue: 15792383,
    antiquewhite: 16444375,
    aqua: 65535,
    aquamarine: 8388564,
    azure: 15794175,
    beige: 16119260,
    bisque: 16770244,
    black: 0,
    blanchedalmond: 16772045,
    blue: 255,
    blueviolet: 9055202,
    brown: 10824234,
    burlywood: 14596231,
    cadetblue: 6266528,
    chartreuse: 8388352,
    chocolate: 13789470,
    coral: 16744272,
    cornflowerblue: 6591981,
    cornsilk: 16775388,
    crimson: 14423100,
    cyan: 65535,
    darkblue: 139,
    darkcyan: 35723,
    darkgoldenrod: 12092939,
    darkgray: 11119017,
    darkgreen: 25600,
    darkgrey: 11119017,
    darkkhaki: 12433259,
    darkmagenta: 9109643,
    darkolivegreen: 5597999,
    darkorange: 16747520,
    darkorchid: 10040012,
    darkred: 9109504,
    darksalmon: 15308410,
    darkseagreen: 9419919,
    darkslateblue: 4734347,
    darkslategray: 3100495,
    darkslategrey: 3100495,
    darkturquoise: 52945,
    darkviolet: 9699539,
    deeppink: 16716947,
    deepskyblue: 49151,
    dimgray: 6908265,
    dimgrey: 6908265,
    dodgerblue: 2003199,
    firebrick: 11674146,
    floralwhite: 16775920,
    forestgreen: 2263842,
    fuchsia: 16711935,
    gainsboro: 14474460,
    ghostwhite: 16316671,
    gold: 16766720,
    goldenrod: 14329120,
    gray: 8421504,
    green: 32768,
    greenyellow: 11403055,
    grey: 8421504,
    honeydew: 15794160,
    hotpink: 16738740,
    indianred: 13458524,
    indigo: 4915330,
    ivory: 16777200,
    khaki: 15787660,
    lavender: 15132410,
    lavenderblush: 16773365,
    lawngreen: 8190976,
    lemonchiffon: 16775885,
    lightblue: 11393254,
    lightcoral: 15761536,
    lightcyan: 14745599,
    lightgoldenrodyellow: 16448210,
    lightgray: 13882323,
    lightgreen: 9498256,
    lightgrey: 13882323,
    lightpink: 16758465,
    lightsalmon: 16752762,
    lightseagreen: 2142890,
    lightskyblue: 8900346,
    lightslategray: 7833753,
    lightslategrey: 7833753,
    lightsteelblue: 11584734,
    lightyellow: 16777184,
    lime: 65280,
    limegreen: 3329330,
    linen: 16445670,
    magenta: 16711935,
    maroon: 8388608,
    mediumaquamarine: 6737322,
    mediumblue: 205,
    mediumorchid: 12211667,
    mediumpurple: 9662683,
    mediumseagreen: 3978097,
    mediumslateblue: 8087790,
    mediumspringgreen: 64154,
    mediumturquoise: 4772300,
    mediumvioletred: 13047173,
    midnightblue: 1644912,
    mintcream: 16121850,
    mistyrose: 16770273,
    moccasin: 16770229,
    navajowhite: 16768685,
    navy: 128,
    oldlace: 16643558,
    olive: 8421376,
    olivedrab: 7048739,
    orange: 16753920,
    orangered: 16729344,
    orchid: 14315734,
    palegoldenrod: 15657130,
    palegreen: 10025880,
    paleturquoise: 11529966,
    palevioletred: 14381203,
    papayawhip: 16773077,
    peachpuff: 16767673,
    peru: 13468991,
    pink: 16761035,
    plum: 14524637,
    powderblue: 11591910,
    purple: 8388736,
    rebeccapurple: 6697881,
    red: 16711680,
    rosybrown: 12357519,
    royalblue: 4286945,
    saddlebrown: 9127187,
    salmon: 16416882,
    sandybrown: 16032864,
    seagreen: 3050327,
    seashell: 16774638,
    sienna: 10506797,
    silver: 12632256,
    skyblue: 8900331,
    slateblue: 6970061,
    slategray: 7372944,
    slategrey: 7372944,
    snow: 16775930,
    springgreen: 65407,
    steelblue: 4620980,
    tan: 13808780,
    teal: 32896,
    thistle: 14204888,
    tomato: 16737095,
    turquoise: 4251856,
    violet: 15631086,
    wheat: 16113331,
    white: 16777215,
    whitesmoke: 16119285,
    yellow: 16776960,
    yellowgreen: 10145074
  };
  define2(Color$2, color, {
    copy(channels2) {
      return Object.assign(new this.constructor(), this, channels2);
    },
    displayable() {
      return this.rgb().displayable();
    },
    hex: color_formatHex,
    // Deprecated! Use color.formatHex.
    formatHex: color_formatHex,
    formatHex8: color_formatHex8,
    formatHsl: color_formatHsl,
    formatRgb: color_formatRgb,
    toString: color_formatRgb
  });
  function color_formatHex() {
    return this.rgb().formatHex();
  }
  function color_formatHex8() {
    return this.rgb().formatHex8();
  }
  function color_formatHsl() {
    return hslConvert(this).formatHsl();
  }
  function color_formatRgb() {
    return this.rgb().formatRgb();
  }
  function color(format2) {
    var m, l;
    format2 = (format2 + "").trim().toLowerCase();
    return (m = reHex.exec(format2)) ? (l = m[1].length, m = parseInt(m[1], 16), l === 6 ? rgbn(m) : l === 3 ? new Rgb(m >> 8 & 15 | m >> 4 & 240, m >> 4 & 15 | m & 240, (m & 15) << 4 | m & 15, 1) : l === 8 ? rgba$2(m >> 24 & 255, m >> 16 & 255, m >> 8 & 255, (m & 255) / 255) : l === 4 ? rgba$2(m >> 12 & 15 | m >> 8 & 240, m >> 8 & 15 | m >> 4 & 240, m >> 4 & 15 | m & 240, ((m & 15) << 4 | m & 15) / 255) : null) : (m = reRgbInteger.exec(format2)) ? new Rgb(m[1], m[2], m[3], 1) : (m = reRgbPercent.exec(format2)) ? new Rgb(m[1] * 255 / 100, m[2] * 255 / 100, m[3] * 255 / 100, 1) : (m = reRgbaInteger.exec(format2)) ? rgba$2(m[1], m[2], m[3], m[4]) : (m = reRgbaPercent.exec(format2)) ? rgba$2(m[1] * 255 / 100, m[2] * 255 / 100, m[3] * 255 / 100, m[4]) : (m = reHslPercent.exec(format2)) ? hsla(m[1], m[2] / 100, m[3] / 100, 1) : (m = reHslaPercent.exec(format2)) ? hsla(m[1], m[2] / 100, m[3] / 100, m[4]) : named.hasOwnProperty(format2) ? rgbn(named[format2]) : format2 === "transparent" ? new Rgb(NaN, NaN, NaN, 0) : null;
  }
  function rgbn(n) {
    return new Rgb(n >> 16 & 255, n >> 8 & 255, n & 255, 1);
  }
  function rgba$2(r, g, b, a) {
    if (a <= 0)
      r = g = b = NaN;
    return new Rgb(r, g, b, a);
  }
  function rgbConvert(o) {
    if (!(o instanceof Color$2))
      o = color(o);
    if (!o)
      return new Rgb();
    o = o.rgb();
    return new Rgb(o.r, o.g, o.b, o.opacity);
  }
  function rgb(r, g, b, opacity) {
    return arguments.length === 1 ? rgbConvert(r) : new Rgb(r, g, b, opacity == null ? 1 : opacity);
  }
  function Rgb(r, g, b, opacity) {
    this.r = +r;
    this.g = +g;
    this.b = +b;
    this.opacity = +opacity;
  }
  define2(Rgb, rgb, extend$1(Color$2, {
    brighter(k) {
      k = k == null ? brighter : Math.pow(brighter, k);
      return new Rgb(this.r * k, this.g * k, this.b * k, this.opacity);
    },
    darker(k) {
      k = k == null ? darker : Math.pow(darker, k);
      return new Rgb(this.r * k, this.g * k, this.b * k, this.opacity);
    },
    rgb() {
      return this;
    },
    clamp() {
      return new Rgb(clampi(this.r), clampi(this.g), clampi(this.b), clampa(this.opacity));
    },
    displayable() {
      return -0.5 <= this.r && this.r < 255.5 && (-0.5 <= this.g && this.g < 255.5) && (-0.5 <= this.b && this.b < 255.5) && (0 <= this.opacity && this.opacity <= 1);
    },
    hex: rgb_formatHex,
    // Deprecated! Use color.formatHex.
    formatHex: rgb_formatHex,
    formatHex8: rgb_formatHex8,
    formatRgb: rgb_formatRgb,
    toString: rgb_formatRgb
  }));
  function rgb_formatHex() {
    return `#${hex(this.r)}${hex(this.g)}${hex(this.b)}`;
  }
  function rgb_formatHex8() {
    return `#${hex(this.r)}${hex(this.g)}${hex(this.b)}${hex((isNaN(this.opacity) ? 1 : this.opacity) * 255)}`;
  }
  function rgb_formatRgb() {
    const a = clampa(this.opacity);
    return `${a === 1 ? "rgb(" : "rgba("}${clampi(this.r)}, ${clampi(this.g)}, ${clampi(this.b)}${a === 1 ? ")" : `, ${a})`}`;
  }
  function clampa(opacity) {
    return isNaN(opacity) ? 1 : Math.max(0, Math.min(1, opacity));
  }
  function clampi(value) {
    return Math.max(0, Math.min(255, Math.round(value) || 0));
  }
  function hex(value) {
    value = clampi(value);
    return (value < 16 ? "0" : "") + value.toString(16);
  }
  function hsla(h, s, l, a) {
    if (a <= 0)
      h = s = l = NaN;
    else if (l <= 0 || l >= 1)
      h = s = NaN;
    else if (s <= 0)
      h = NaN;
    return new Hsl(h, s, l, a);
  }
  function hslConvert(o) {
    if (o instanceof Hsl)
      return new Hsl(o.h, o.s, o.l, o.opacity);
    if (!(o instanceof Color$2))
      o = color(o);
    if (!o)
      return new Hsl();
    if (o instanceof Hsl)
      return o;
    o = o.rgb();
    var r = o.r / 255, g = o.g / 255, b = o.b / 255, min2 = Math.min(r, g, b), max2 = Math.max(r, g, b), h = NaN, s = max2 - min2, l = (max2 + min2) / 2;
    if (s) {
      if (r === max2)
        h = (g - b) / s + (g < b) * 6;
      else if (g === max2)
        h = (b - r) / s + 2;
      else
        h = (r - g) / s + 4;
      s /= l < 0.5 ? max2 + min2 : 2 - max2 - min2;
      h *= 60;
    } else {
      s = l > 0 && l < 1 ? 0 : h;
    }
    return new Hsl(h, s, l, o.opacity);
  }
  function hsl(h, s, l, opacity) {
    return arguments.length === 1 ? hslConvert(h) : new Hsl(h, s, l, opacity == null ? 1 : opacity);
  }
  function Hsl(h, s, l, opacity) {
    this.h = +h;
    this.s = +s;
    this.l = +l;
    this.opacity = +opacity;
  }
  define2(Hsl, hsl, extend$1(Color$2, {
    brighter(k) {
      k = k == null ? brighter : Math.pow(brighter, k);
      return new Hsl(this.h, this.s, this.l * k, this.opacity);
    },
    darker(k) {
      k = k == null ? darker : Math.pow(darker, k);
      return new Hsl(this.h, this.s, this.l * k, this.opacity);
    },
    rgb() {
      var h = this.h % 360 + (this.h < 0) * 360, s = isNaN(h) || isNaN(this.s) ? 0 : this.s, l = this.l, m2 = l + (l < 0.5 ? l : 1 - l) * s, m1 = 2 * l - m2;
      return new Rgb(
        hsl2rgb(h >= 240 ? h - 240 : h + 120, m1, m2),
        hsl2rgb(h, m1, m2),
        hsl2rgb(h < 120 ? h + 240 : h - 120, m1, m2),
        this.opacity
      );
    },
    clamp() {
      return new Hsl(clamph(this.h), clampt(this.s), clampt(this.l), clampa(this.opacity));
    },
    displayable() {
      return (0 <= this.s && this.s <= 1 || isNaN(this.s)) && (0 <= this.l && this.l <= 1) && (0 <= this.opacity && this.opacity <= 1);
    },
    formatHsl() {
      const a = clampa(this.opacity);
      return `${a === 1 ? "hsl(" : "hsla("}${clamph(this.h)}, ${clampt(this.s) * 100}%, ${clampt(this.l) * 100}%${a === 1 ? ")" : `, ${a})`}`;
    }
  }));
  function clamph(value) {
    value = (value || 0) % 360;
    return value < 0 ? value + 360 : value;
  }
  function clampt(value) {
    return Math.max(0, Math.min(1, value || 0));
  }
  function hsl2rgb(h, m1, m2) {
    return (h < 60 ? m1 + (m2 - m1) * h / 60 : h < 180 ? m2 : h < 240 ? m1 + (m2 - m1) * (240 - h) / 60 : m1) * 255;
  }
  const radians = Math.PI / 180;
  const degrees$1 = 180 / Math.PI;
  const K = 18, Xn = 0.96422, Yn = 1, Zn = 0.82521, t0$1 = 4 / 29, t1$1 = 6 / 29, t2 = 3 * t1$1 * t1$1, t3 = t1$1 * t1$1 * t1$1;
  function labConvert(o) {
    if (o instanceof Lab)
      return new Lab(o.l, o.a, o.b, o.opacity);
    if (o instanceof Hcl)
      return hcl2lab(o);
    if (!(o instanceof Rgb))
      o = rgbConvert(o);
    var r = rgb2lrgb(o.r), g = rgb2lrgb(o.g), b = rgb2lrgb(o.b), y2 = xyz2lab((0.2225045 * r + 0.7168786 * g + 0.0606169 * b) / Yn), x2, z;
    if (r === g && g === b)
      x2 = z = y2;
    else {
      x2 = xyz2lab((0.4360747 * r + 0.3850649 * g + 0.1430804 * b) / Xn);
      z = xyz2lab((0.0139322 * r + 0.0971045 * g + 0.7141733 * b) / Zn);
    }
    return new Lab(116 * y2 - 16, 500 * (x2 - y2), 200 * (y2 - z), o.opacity);
  }
  function lab(l, a, b, opacity) {
    return arguments.length === 1 ? labConvert(l) : new Lab(l, a, b, opacity == null ? 1 : opacity);
  }
  function Lab(l, a, b, opacity) {
    this.l = +l;
    this.a = +a;
    this.b = +b;
    this.opacity = +opacity;
  }
  define2(Lab, lab, extend$1(Color$2, {
    brighter(k) {
      return new Lab(this.l + K * (k == null ? 1 : k), this.a, this.b, this.opacity);
    },
    darker(k) {
      return new Lab(this.l - K * (k == null ? 1 : k), this.a, this.b, this.opacity);
    },
    rgb() {
      var y2 = (this.l + 16) / 116, x2 = isNaN(this.a) ? y2 : y2 + this.a / 500, z = isNaN(this.b) ? y2 : y2 - this.b / 200;
      x2 = Xn * lab2xyz(x2);
      y2 = Yn * lab2xyz(y2);
      z = Zn * lab2xyz(z);
      return new Rgb(
        lrgb2rgb(3.1338561 * x2 - 1.6168667 * y2 - 0.4906146 * z),
        lrgb2rgb(-0.9787684 * x2 + 1.9161415 * y2 + 0.033454 * z),
        lrgb2rgb(0.0719453 * x2 - 0.2289914 * y2 + 1.4052427 * z),
        this.opacity
      );
    }
  }));
  function xyz2lab(t) {
    return t > t3 ? Math.pow(t, 1 / 3) : t / t2 + t0$1;
  }
  function lab2xyz(t) {
    return t > t1$1 ? t * t * t : t2 * (t - t0$1);
  }
  function lrgb2rgb(x2) {
    return 255 * (x2 <= 31308e-7 ? 12.92 * x2 : 1.055 * Math.pow(x2, 1 / 2.4) - 0.055);
  }
  function rgb2lrgb(x2) {
    return (x2 /= 255) <= 0.04045 ? x2 / 12.92 : Math.pow((x2 + 0.055) / 1.055, 2.4);
  }
  function hclConvert(o) {
    if (o instanceof Hcl)
      return new Hcl(o.h, o.c, o.l, o.opacity);
    if (!(o instanceof Lab))
      o = labConvert(o);
    if (o.a === 0 && o.b === 0)
      return new Hcl(NaN, 0 < o.l && o.l < 100 ? 0 : NaN, o.l, o.opacity);
    var h = Math.atan2(o.b, o.a) * degrees$1;
    return new Hcl(h < 0 ? h + 360 : h, Math.sqrt(o.a * o.a + o.b * o.b), o.l, o.opacity);
  }
  function hcl$1(h, c2, l, opacity) {
    return arguments.length === 1 ? hclConvert(h) : new Hcl(h, c2, l, opacity == null ? 1 : opacity);
  }
  function Hcl(h, c2, l, opacity) {
    this.h = +h;
    this.c = +c2;
    this.l = +l;
    this.opacity = +opacity;
  }
  function hcl2lab(o) {
    if (isNaN(o.h))
      return new Lab(o.l, 0, 0, o.opacity);
    var h = o.h * radians;
    return new Lab(o.l, Math.cos(h) * o.c, Math.sin(h) * o.c, o.opacity);
  }
  define2(Hcl, hcl$1, extend$1(Color$2, {
    brighter(k) {
      return new Hcl(this.h, this.c, this.l + K * (k == null ? 1 : k), this.opacity);
    },
    darker(k) {
      return new Hcl(this.h, this.c, this.l - K * (k == null ? 1 : k), this.opacity);
    },
    rgb() {
      return hcl2lab(this).rgb();
    }
  }));
  const constant$2 = (x2) => () => x2;
  function linear$1(a, d) {
    return function(t) {
      return a + t * d;
    };
  }
  function exponential(a, b, y2) {
    return a = Math.pow(a, y2), b = Math.pow(b, y2) - a, y2 = 1 / y2, function(t) {
      return Math.pow(a + t * b, y2);
    };
  }
  function hue(a, b) {
    var d = b - a;
    return d ? linear$1(a, d > 180 || d < -180 ? d - 360 * Math.round(d / 360) : d) : constant$2(isNaN(a) ? b : a);
  }
  function gamma(y2) {
    return (y2 = +y2) === 1 ? nogamma : function(a, b) {
      return b - a ? exponential(a, b, y2) : constant$2(isNaN(a) ? b : a);
    };
  }
  function nogamma(a, b) {
    var d = b - a;
    return d ? linear$1(a, d) : constant$2(isNaN(a) ? b : a);
  }
  const interpolateRgb = function rgbGamma(y2) {
    var color2 = gamma(y2);
    function rgb$1(start2, end2) {
      var r = color2((start2 = rgb(start2)).r, (end2 = rgb(end2)).r), g = color2(start2.g, end2.g), b = color2(start2.b, end2.b), opacity = nogamma(start2.opacity, end2.opacity);
      return function(t) {
        start2.r = r(t);
        start2.g = g(t);
        start2.b = b(t);
        start2.opacity = opacity(t);
        return start2 + "";
      };
    }
    rgb$1.gamma = rgbGamma;
    return rgb$1;
  }(1);
  function numberArray(a, b) {
    if (!b)
      b = [];
    var n = a ? Math.min(b.length, a.length) : 0, c2 = b.slice(), i2;
    return function(t) {
      for (i2 = 0; i2 < n; ++i2)
        c2[i2] = a[i2] * (1 - t) + b[i2] * t;
      return c2;
    };
  }
  function isNumberArray(x2) {
    return ArrayBuffer.isView(x2) && !(x2 instanceof DataView);
  }
  function genericArray(a, b) {
    var nb = b ? b.length : 0, na = a ? Math.min(nb, a.length) : 0, x2 = new Array(na), c2 = new Array(nb), i2;
    for (i2 = 0; i2 < na; ++i2)
      x2[i2] = interpolate$1(a[i2], b[i2]);
    for (; i2 < nb; ++i2)
      c2[i2] = b[i2];
    return function(t) {
      for (i2 = 0; i2 < na; ++i2)
        c2[i2] = x2[i2](t);
      return c2;
    };
  }
  function date$1(a, b) {
    var d = /* @__PURE__ */ new Date();
    return a = +a, b = +b, function(t) {
      return d.setTime(a * (1 - t) + b * t), d;
    };
  }
  function interpolateNumber(a, b) {
    return a = +a, b = +b, function(t) {
      return a * (1 - t) + b * t;
    };
  }
  function object(a, b) {
    var i2 = {}, c2 = {}, k;
    if (a === null || typeof a !== "object")
      a = {};
    if (b === null || typeof b !== "object")
      b = {};
    for (k in b) {
      if (k in a) {
        i2[k] = interpolate$1(a[k], b[k]);
      } else {
        c2[k] = b[k];
      }
    }
    return function(t) {
      for (k in i2)
        c2[k] = i2[k](t);
      return c2;
    };
  }
  var reA = /[-+]?(?:\d+\.?\d*|\.?\d+)(?:[eE][-+]?\d+)?/g, reB = new RegExp(reA.source, "g");
  function zero(b) {
    return function() {
      return b;
    };
  }
  function one$1(b) {
    return function(t) {
      return b(t) + "";
    };
  }
  function interpolateString(a, b) {
    var bi = reA.lastIndex = reB.lastIndex = 0, am, bm, bs, i2 = -1, s = [], q = [];
    a = a + "", b = b + "";
    while ((am = reA.exec(a)) && (bm = reB.exec(b))) {
      if ((bs = bm.index) > bi) {
        bs = b.slice(bi, bs);
        if (s[i2])
          s[i2] += bs;
        else
          s[++i2] = bs;
      }
      if ((am = am[0]) === (bm = bm[0])) {
        if (s[i2])
          s[i2] += bm;
        else
          s[++i2] = bm;
      } else {
        s[++i2] = null;
        q.push({ i: i2, x: interpolateNumber(am, bm) });
      }
      bi = reB.lastIndex;
    }
    if (bi < b.length) {
      bs = b.slice(bi);
      if (s[i2])
        s[i2] += bs;
      else
        s[++i2] = bs;
    }
    return s.length < 2 ? q[0] ? one$1(q[0].x) : zero(b) : (b = q.length, function(t) {
      for (var i3 = 0, o; i3 < b; ++i3)
        s[(o = q[i3]).i] = o.x(t);
      return s.join("");
    });
  }
  function interpolate$1(a, b) {
    var t = typeof b, c2;
    return b == null || t === "boolean" ? constant$2(b) : (t === "number" ? interpolateNumber : t === "string" ? (c2 = color(b)) ? (b = c2, interpolateRgb) : interpolateString : b instanceof color ? interpolateRgb : b instanceof Date ? date$1 : isNumberArray(b) ? numberArray : Array.isArray(b) ? genericArray : typeof b.valueOf !== "function" && typeof b.toString !== "function" || isNaN(b) ? object : interpolateNumber)(a, b);
  }
  function interpolateRound(a, b) {
    return a = +a, b = +b, function(t) {
      return Math.round(a * (1 - t) + b * t);
    };
  }
  var degrees = 180 / Math.PI;
  var identity$4 = {
    translateX: 0,
    translateY: 0,
    rotate: 0,
    skewX: 0,
    scaleX: 1,
    scaleY: 1
  };
  function decompose(a, b, c2, d, e, f2) {
    var scaleX, scaleY, skewX;
    if (scaleX = Math.sqrt(a * a + b * b))
      a /= scaleX, b /= scaleX;
    if (skewX = a * c2 + b * d)
      c2 -= a * skewX, d -= b * skewX;
    if (scaleY = Math.sqrt(c2 * c2 + d * d))
      c2 /= scaleY, d /= scaleY, skewX /= scaleY;
    if (a * d < b * c2)
      a = -a, b = -b, skewX = -skewX, scaleX = -scaleX;
    return {
      translateX: e,
      translateY: f2,
      rotate: Math.atan2(b, a) * degrees,
      skewX: Math.atan(skewX) * degrees,
      scaleX,
      scaleY
    };
  }
  var svgNode;
  function parseCss(value) {
    const m = new (typeof DOMMatrix === "function" ? DOMMatrix : WebKitCSSMatrix)(value + "");
    return m.isIdentity ? identity$4 : decompose(m.a, m.b, m.c, m.d, m.e, m.f);
  }
  function parseSvg(value) {
    if (value == null)
      return identity$4;
    if (!svgNode)
      svgNode = document.createElementNS("http://www.w3.org/2000/svg", "g");
    svgNode.setAttribute("transform", value);
    if (!(value = svgNode.transform.baseVal.consolidate()))
      return identity$4;
    value = value.matrix;
    return decompose(value.a, value.b, value.c, value.d, value.e, value.f);
  }
  function interpolateTransform(parse2, pxComma, pxParen, degParen) {
    function pop(s) {
      return s.length ? s.pop() + " " : "";
    }
    function translate(xa, ya, xb, yb, s, q) {
      if (xa !== xb || ya !== yb) {
        var i2 = s.push("translate(", null, pxComma, null, pxParen);
        q.push({ i: i2 - 4, x: interpolateNumber(xa, xb) }, { i: i2 - 2, x: interpolateNumber(ya, yb) });
      } else if (xb || yb) {
        s.push("translate(" + xb + pxComma + yb + pxParen);
      }
    }
    function rotate(a, b, s, q) {
      if (a !== b) {
        if (a - b > 180)
          b += 360;
        else if (b - a > 180)
          a += 360;
        q.push({ i: s.push(pop(s) + "rotate(", null, degParen) - 2, x: interpolateNumber(a, b) });
      } else if (b) {
        s.push(pop(s) + "rotate(" + b + degParen);
      }
    }
    function skewX(a, b, s, q) {
      if (a !== b) {
        q.push({ i: s.push(pop(s) + "skewX(", null, degParen) - 2, x: interpolateNumber(a, b) });
      } else if (b) {
        s.push(pop(s) + "skewX(" + b + degParen);
      }
    }
    function scale(xa, ya, xb, yb, s, q) {
      if (xa !== xb || ya !== yb) {
        var i2 = s.push(pop(s) + "scale(", null, ",", null, ")");
        q.push({ i: i2 - 4, x: interpolateNumber(xa, xb) }, { i: i2 - 2, x: interpolateNumber(ya, yb) });
      } else if (xb !== 1 || yb !== 1) {
        s.push(pop(s) + "scale(" + xb + "," + yb + ")");
      }
    }
    return function(a, b) {
      var s = [], q = [];
      a = parse2(a), b = parse2(b);
      translate(a.translateX, a.translateY, b.translateX, b.translateY, s, q);
      rotate(a.rotate, b.rotate, s, q);
      skewX(a.skewX, b.skewX, s, q);
      scale(a.scaleX, a.scaleY, b.scaleX, b.scaleY, s, q);
      a = b = null;
      return function(t) {
        var i2 = -1, n = q.length, o;
        while (++i2 < n)
          s[(o = q[i2]).i] = o.x(t);
        return s.join("");
      };
    };
  }
  var interpolateTransformCss = interpolateTransform(parseCss, "px, ", "px)", "deg)");
  var interpolateTransformSvg = interpolateTransform(parseSvg, ", ", ")", ")");
  function hcl(hue2) {
    return function(start2, end2) {
      var h = hue2((start2 = hcl$1(start2)).h, (end2 = hcl$1(end2)).h), c2 = nogamma(start2.c, end2.c), l = nogamma(start2.l, end2.l), opacity = nogamma(start2.opacity, end2.opacity);
      return function(t) {
        start2.h = h(t);
        start2.c = c2(t);
        start2.l = l(t);
        start2.opacity = opacity(t);
        return start2 + "";
      };
    };
  }
  const interpolateHcl = hcl(hue);
  var frame = 0, timeout$1 = 0, interval = 0, pokeDelay = 1e3, taskHead, taskTail, clockLast = 0, clockNow = 0, clockSkew = 0, clock = typeof performance === "object" && performance.now ? performance : Date, setFrame = typeof window === "object" && window.requestAnimationFrame ? window.requestAnimationFrame.bind(window) : function(f2) {
    setTimeout(f2, 17);
  };
  function now$2() {
    return clockNow || (setFrame(clearNow), clockNow = clock.now() + clockSkew);
  }
  function clearNow() {
    clockNow = 0;
  }
  function Timer() {
    this._call = this._time = this._next = null;
  }
  Timer.prototype = timer.prototype = {
    constructor: Timer,
    restart: function(callback, delay, time2) {
      if (typeof callback !== "function")
        throw new TypeError("callback is not a function");
      time2 = (time2 == null ? now$2() : +time2) + (delay == null ? 0 : +delay);
      if (!this._next && taskTail !== this) {
        if (taskTail)
          taskTail._next = this;
        else
          taskHead = this;
        taskTail = this;
      }
      this._call = callback;
      this._time = time2;
      sleep();
    },
    stop: function() {
      if (this._call) {
        this._call = null;
        this._time = Infinity;
        sleep();
      }
    }
  };
  function timer(callback, delay, time2) {
    var t = new Timer();
    t.restart(callback, delay, time2);
    return t;
  }
  function timerFlush() {
    now$2();
    ++frame;
    var t = taskHead, e;
    while (t) {
      if ((e = clockNow - t._time) >= 0)
        t._call.call(void 0, e);
      t = t._next;
    }
    --frame;
  }
  function wake() {
    clockNow = (clockLast = clock.now()) + clockSkew;
    frame = timeout$1 = 0;
    try {
      timerFlush();
    } finally {
      frame = 0;
      nap();
      clockNow = 0;
    }
  }
  function poke() {
    var now2 = clock.now(), delay = now2 - clockLast;
    if (delay > pokeDelay)
      clockSkew -= delay, clockLast = now2;
  }
  function nap() {
    var t02, t12 = taskHead, t22, time2 = Infinity;
    while (t12) {
      if (t12._call) {
        if (time2 > t12._time)
          time2 = t12._time;
        t02 = t12, t12 = t12._next;
      } else {
        t22 = t12._next, t12._next = null;
        t12 = t02 ? t02._next = t22 : taskHead = t22;
      }
    }
    taskTail = t02;
    sleep(time2);
  }
  function sleep(time2) {
    if (frame)
      return;
    if (timeout$1)
      timeout$1 = clearTimeout(timeout$1);
    var delay = time2 - clockNow;
    if (delay > 24) {
      if (time2 < Infinity)
        timeout$1 = setTimeout(wake, time2 - clock.now() - clockSkew);
      if (interval)
        interval = clearInterval(interval);
    } else {
      if (!interval)
        clockLast = clock.now(), interval = setInterval(poke, pokeDelay);
      frame = 1, setFrame(wake);
    }
  }
  function timeout(callback, delay, time2) {
    var t = new Timer();
    delay = delay == null ? 0 : +delay;
    t.restart((elapsed) => {
      t.stop();
      callback(elapsed + delay);
    }, delay, time2);
    return t;
  }
  var emptyOn = dispatch("start", "end", "cancel", "interrupt");
  var emptyTween = [];
  var CREATED = 0;
  var SCHEDULED = 1;
  var STARTING = 2;
  var STARTED = 3;
  var RUNNING = 4;
  var ENDING = 5;
  var ENDED = 6;
  function schedule(node2, name2, id2, index2, group, timing) {
    var schedules = node2.__transition;
    if (!schedules)
      node2.__transition = {};
    else if (id2 in schedules)
      return;
    create$1(node2, id2, {
      name: name2,
      index: index2,
      // For context during callback.
      group,
      // For context during callback.
      on: emptyOn,
      tween: emptyTween,
      time: timing.time,
      delay: timing.delay,
      duration: timing.duration,
      ease: timing.ease,
      timer: null,
      state: CREATED
    });
  }
  function init$1(node2, id2) {
    var schedule2 = get$2(node2, id2);
    if (schedule2.state > CREATED)
      throw new Error("too late; already scheduled");
    return schedule2;
  }
  function set$2(node2, id2) {
    var schedule2 = get$2(node2, id2);
    if (schedule2.state > STARTED)
      throw new Error("too late; already running");
    return schedule2;
  }
  function get$2(node2, id2) {
    var schedule2 = node2.__transition;
    if (!schedule2 || !(schedule2 = schedule2[id2]))
      throw new Error("transition not found");
    return schedule2;
  }
  function create$1(node2, id2, self2) {
    var schedules = node2.__transition, tween;
    schedules[id2] = self2;
    self2.timer = timer(schedule2, 0, self2.time);
    function schedule2(elapsed) {
      self2.state = SCHEDULED;
      self2.timer.restart(start2, self2.delay, self2.time);
      if (self2.delay <= elapsed)
        start2(elapsed - self2.delay);
    }
    function start2(elapsed) {
      var i2, j, n, o;
      if (self2.state !== SCHEDULED)
        return stop();
      for (i2 in schedules) {
        o = schedules[i2];
        if (o.name !== self2.name)
          continue;
        if (o.state === STARTED)
          return timeout(start2);
        if (o.state === RUNNING) {
          o.state = ENDED;
          o.timer.stop();
          o.on.call("interrupt", node2, node2.__data__, o.index, o.group);
          delete schedules[i2];
        } else if (+i2 < id2) {
          o.state = ENDED;
          o.timer.stop();
          o.on.call("cancel", node2, node2.__data__, o.index, o.group);
          delete schedules[i2];
        }
      }
      timeout(function() {
        if (self2.state === STARTED) {
          self2.state = RUNNING;
          self2.timer.restart(tick, self2.delay, self2.time);
          tick(elapsed);
        }
      });
      self2.state = STARTING;
      self2.on.call("start", node2, node2.__data__, self2.index, self2.group);
      if (self2.state !== STARTING)
        return;
      self2.state = STARTED;
      tween = new Array(n = self2.tween.length);
      for (i2 = 0, j = -1; i2 < n; ++i2) {
        if (o = self2.tween[i2].value.call(node2, node2.__data__, self2.index, self2.group)) {
          tween[++j] = o;
        }
      }
      tween.length = j + 1;
    }
    function tick(elapsed) {
      var t = elapsed < self2.duration ? self2.ease.call(null, elapsed / self2.duration) : (self2.timer.restart(stop), self2.state = ENDING, 1), i2 = -1, n = tween.length;
      while (++i2 < n) {
        tween[i2].call(node2, t);
      }
      if (self2.state === ENDING) {
        self2.on.call("end", node2, node2.__data__, self2.index, self2.group);
        stop();
      }
    }
    function stop() {
      self2.state = ENDED;
      self2.timer.stop();
      delete schedules[id2];
      for (var i2 in schedules)
        return;
      delete node2.__transition;
    }
  }
  function interrupt(node2, name2) {
    var schedules = node2.__transition, schedule2, active, empty2 = true, i2;
    if (!schedules)
      return;
    name2 = name2 == null ? null : name2 + "";
    for (i2 in schedules) {
      if ((schedule2 = schedules[i2]).name !== name2) {
        empty2 = false;
        continue;
      }
      active = schedule2.state > STARTING && schedule2.state < ENDING;
      schedule2.state = ENDED;
      schedule2.timer.stop();
      schedule2.on.call(active ? "interrupt" : "cancel", node2, node2.__data__, schedule2.index, schedule2.group);
      delete schedules[i2];
    }
    if (empty2)
      delete node2.__transition;
  }
  function selection_interrupt(name2) {
    return this.each(function() {
      interrupt(this, name2);
    });
  }
  function tweenRemove(id2, name2) {
    var tween0, tween1;
    return function() {
      var schedule2 = set$2(this, id2), tween = schedule2.tween;
      if (tween !== tween0) {
        tween1 = tween0 = tween;
        for (var i2 = 0, n = tween1.length; i2 < n; ++i2) {
          if (tween1[i2].name === name2) {
            tween1 = tween1.slice();
            tween1.splice(i2, 1);
            break;
          }
        }
      }
      schedule2.tween = tween1;
    };
  }
  function tweenFunction(id2, name2, value) {
    var tween0, tween1;
    if (typeof value !== "function")
      throw new Error();
    return function() {
      var schedule2 = set$2(this, id2), tween = schedule2.tween;
      if (tween !== tween0) {
        tween1 = (tween0 = tween).slice();
        for (var t = { name: name2, value }, i2 = 0, n = tween1.length; i2 < n; ++i2) {
          if (tween1[i2].name === name2) {
            tween1[i2] = t;
            break;
          }
        }
        if (i2 === n)
          tween1.push(t);
      }
      schedule2.tween = tween1;
    };
  }
  function transition_tween(name2, value) {
    var id2 = this._id;
    name2 += "";
    if (arguments.length < 2) {
      var tween = get$2(this.node(), id2).tween;
      for (var i2 = 0, n = tween.length, t; i2 < n; ++i2) {
        if ((t = tween[i2]).name === name2) {
          return t.value;
        }
      }
      return null;
    }
    return this.each((value == null ? tweenRemove : tweenFunction)(id2, name2, value));
  }
  function tweenValue(transition, name2, value) {
    var id2 = transition._id;
    transition.each(function() {
      var schedule2 = set$2(this, id2);
      (schedule2.value || (schedule2.value = {}))[name2] = value.apply(this, arguments);
    });
    return function(node2) {
      return get$2(node2, id2).value[name2];
    };
  }
  function interpolate(a, b) {
    var c2;
    return (typeof b === "number" ? interpolateNumber : b instanceof color ? interpolateRgb : (c2 = color(b)) ? (b = c2, interpolateRgb) : interpolateString)(a, b);
  }
  function attrRemove(name2) {
    return function() {
      this.removeAttribute(name2);
    };
  }
  function attrRemoveNS(fullname) {
    return function() {
      this.removeAttributeNS(fullname.space, fullname.local);
    };
  }
  function attrConstant(name2, interpolate2, value1) {
    var string00, string1 = value1 + "", interpolate0;
    return function() {
      var string0 = this.getAttribute(name2);
      return string0 === string1 ? null : string0 === string00 ? interpolate0 : interpolate0 = interpolate2(string00 = string0, value1);
    };
  }
  function attrConstantNS(fullname, interpolate2, value1) {
    var string00, string1 = value1 + "", interpolate0;
    return function() {
      var string0 = this.getAttributeNS(fullname.space, fullname.local);
      return string0 === string1 ? null : string0 === string00 ? interpolate0 : interpolate0 = interpolate2(string00 = string0, value1);
    };
  }
  function attrFunction(name2, interpolate2, value) {
    var string00, string10, interpolate0;
    return function() {
      var string0, value1 = value(this), string1;
      if (value1 == null)
        return void this.removeAttribute(name2);
      string0 = this.getAttribute(name2);
      string1 = value1 + "";
      return string0 === string1 ? null : string0 === string00 && string1 === string10 ? interpolate0 : (string10 = string1, interpolate0 = interpolate2(string00 = string0, value1));
    };
  }
  function attrFunctionNS(fullname, interpolate2, value) {
    var string00, string10, interpolate0;
    return function() {
      var string0, value1 = value(this), string1;
      if (value1 == null)
        return void this.removeAttributeNS(fullname.space, fullname.local);
      string0 = this.getAttributeNS(fullname.space, fullname.local);
      string1 = value1 + "";
      return string0 === string1 ? null : string0 === string00 && string1 === string10 ? interpolate0 : (string10 = string1, interpolate0 = interpolate2(string00 = string0, value1));
    };
  }
  function transition_attr(name2, value) {
    var fullname = namespace(name2), i2 = fullname === "transform" ? interpolateTransformSvg : interpolate;
    return this.attrTween(name2, typeof value === "function" ? (fullname.local ? attrFunctionNS : attrFunction)(fullname, i2, tweenValue(this, "attr." + name2, value)) : value == null ? (fullname.local ? attrRemoveNS : attrRemove)(fullname) : (fullname.local ? attrConstantNS : attrConstant)(fullname, i2, value));
  }
  function attrInterpolate(name2, i2) {
    return function(t) {
      this.setAttribute(name2, i2.call(this, t));
    };
  }
  function attrInterpolateNS(fullname, i2) {
    return function(t) {
      this.setAttributeNS(fullname.space, fullname.local, i2.call(this, t));
    };
  }
  function attrTweenNS(fullname, value) {
    var t02, i0;
    function tween() {
      var i2 = value.apply(this, arguments);
      if (i2 !== i0)
        t02 = (i0 = i2) && attrInterpolateNS(fullname, i2);
      return t02;
    }
    tween._value = value;
    return tween;
  }
  function attrTween(name2, value) {
    var t02, i0;
    function tween() {
      var i2 = value.apply(this, arguments);
      if (i2 !== i0)
        t02 = (i0 = i2) && attrInterpolate(name2, i2);
      return t02;
    }
    tween._value = value;
    return tween;
  }
  function transition_attrTween(name2, value) {
    var key = "attr." + name2;
    if (arguments.length < 2)
      return (key = this.tween(key)) && key._value;
    if (value == null)
      return this.tween(key, null);
    if (typeof value !== "function")
      throw new Error();
    var fullname = namespace(name2);
    return this.tween(key, (fullname.local ? attrTweenNS : attrTween)(fullname, value));
  }
  function delayFunction(id2, value) {
    return function() {
      init$1(this, id2).delay = +value.apply(this, arguments);
    };
  }
  function delayConstant(id2, value) {
    return value = +value, function() {
      init$1(this, id2).delay = value;
    };
  }
  function transition_delay(value) {
    var id2 = this._id;
    return arguments.length ? this.each((typeof value === "function" ? delayFunction : delayConstant)(id2, value)) : get$2(this.node(), id2).delay;
  }
  function durationFunction(id2, value) {
    return function() {
      set$2(this, id2).duration = +value.apply(this, arguments);
    };
  }
  function durationConstant(id2, value) {
    return value = +value, function() {
      set$2(this, id2).duration = value;
    };
  }
  function transition_duration(value) {
    var id2 = this._id;
    return arguments.length ? this.each((typeof value === "function" ? durationFunction : durationConstant)(id2, value)) : get$2(this.node(), id2).duration;
  }
  function easeConstant(id2, value) {
    if (typeof value !== "function")
      throw new Error();
    return function() {
      set$2(this, id2).ease = value;
    };
  }
  function transition_ease(value) {
    var id2 = this._id;
    return arguments.length ? this.each(easeConstant(id2, value)) : get$2(this.node(), id2).ease;
  }
  function easeVarying(id2, value) {
    return function() {
      var v = value.apply(this, arguments);
      if (typeof v !== "function")
        throw new Error();
      set$2(this, id2).ease = v;
    };
  }
  function transition_easeVarying(value) {
    if (typeof value !== "function")
      throw new Error();
    return this.each(easeVarying(this._id, value));
  }
  function transition_filter(match) {
    if (typeof match !== "function")
      match = matcher(match);
    for (var groups = this._groups, m = groups.length, subgroups = new Array(m), j = 0; j < m; ++j) {
      for (var group = groups[j], n = group.length, subgroup = subgroups[j] = [], node2, i2 = 0; i2 < n; ++i2) {
        if ((node2 = group[i2]) && match.call(node2, node2.__data__, i2, group)) {
          subgroup.push(node2);
        }
      }
    }
    return new Transition(subgroups, this._parents, this._name, this._id);
  }
  function transition_merge(transition) {
    if (transition._id !== this._id)
      throw new Error();
    for (var groups0 = this._groups, groups1 = transition._groups, m0 = groups0.length, m1 = groups1.length, m = Math.min(m0, m1), merges = new Array(m0), j = 0; j < m; ++j) {
      for (var group0 = groups0[j], group1 = groups1[j], n = group0.length, merge2 = merges[j] = new Array(n), node2, i2 = 0; i2 < n; ++i2) {
        if (node2 = group0[i2] || group1[i2]) {
          merge2[i2] = node2;
        }
      }
    }
    for (; j < m0; ++j) {
      merges[j] = groups0[j];
    }
    return new Transition(merges, this._parents, this._name, this._id);
  }
  function start$1(name2) {
    return (name2 + "").trim().split(/^|\s+/).every(function(t) {
      var i2 = t.indexOf(".");
      if (i2 >= 0)
        t = t.slice(0, i2);
      return !t || t === "start";
    });
  }
  function onFunction(id2, name2, listener) {
    var on0, on1, sit = start$1(name2) ? init$1 : set$2;
    return function() {
      var schedule2 = sit(this, id2), on = schedule2.on;
      if (on !== on0)
        (on1 = (on0 = on).copy()).on(name2, listener);
      schedule2.on = on1;
    };
  }
  function transition_on(name2, listener) {
    var id2 = this._id;
    return arguments.length < 2 ? get$2(this.node(), id2).on.on(name2) : this.each(onFunction(id2, name2, listener));
  }
  function removeFunction(id2) {
    return function() {
      var parent = this.parentNode;
      for (var i2 in this.__transition)
        if (+i2 !== id2)
          return;
      if (parent)
        parent.removeChild(this);
    };
  }
  function transition_remove() {
    return this.on("end.remove", removeFunction(this._id));
  }
  function transition_select(select2) {
    var name2 = this._name, id2 = this._id;
    if (typeof select2 !== "function")
      select2 = selector(select2);
    for (var groups = this._groups, m = groups.length, subgroups = new Array(m), j = 0; j < m; ++j) {
      for (var group = groups[j], n = group.length, subgroup = subgroups[j] = new Array(n), node2, subnode, i2 = 0; i2 < n; ++i2) {
        if ((node2 = group[i2]) && (subnode = select2.call(node2, node2.__data__, i2, group))) {
          if ("__data__" in node2)
            subnode.__data__ = node2.__data__;
          subgroup[i2] = subnode;
          schedule(subgroup[i2], name2, id2, i2, subgroup, get$2(node2, id2));
        }
      }
    }
    return new Transition(subgroups, this._parents, name2, id2);
  }
  function transition_selectAll(select2) {
    var name2 = this._name, id2 = this._id;
    if (typeof select2 !== "function")
      select2 = selectorAll(select2);
    for (var groups = this._groups, m = groups.length, subgroups = [], parents2 = [], j = 0; j < m; ++j) {
      for (var group = groups[j], n = group.length, node2, i2 = 0; i2 < n; ++i2) {
        if (node2 = group[i2]) {
          for (var children2 = select2.call(node2, node2.__data__, i2, group), child, inherit2 = get$2(node2, id2), k = 0, l = children2.length; k < l; ++k) {
            if (child = children2[k]) {
              schedule(child, name2, id2, k, children2, inherit2);
            }
          }
          subgroups.push(children2);
          parents2.push(node2);
        }
      }
    }
    return new Transition(subgroups, parents2, name2, id2);
  }
  var Selection = selection.prototype.constructor;
  function transition_selection() {
    return new Selection(this._groups, this._parents);
  }
  function styleNull(name2, interpolate2) {
    var string00, string10, interpolate0;
    return function() {
      var string0 = styleValue(this, name2), string1 = (this.style.removeProperty(name2), styleValue(this, name2));
      return string0 === string1 ? null : string0 === string00 && string1 === string10 ? interpolate0 : interpolate0 = interpolate2(string00 = string0, string10 = string1);
    };
  }
  function styleRemove(name2) {
    return function() {
      this.style.removeProperty(name2);
    };
  }
  function styleConstant(name2, interpolate2, value1) {
    var string00, string1 = value1 + "", interpolate0;
    return function() {
      var string0 = styleValue(this, name2);
      return string0 === string1 ? null : string0 === string00 ? interpolate0 : interpolate0 = interpolate2(string00 = string0, value1);
    };
  }
  function styleFunction(name2, interpolate2, value) {
    var string00, string10, interpolate0;
    return function() {
      var string0 = styleValue(this, name2), value1 = value(this), string1 = value1 + "";
      if (value1 == null)
        string1 = value1 = (this.style.removeProperty(name2), styleValue(this, name2));
      return string0 === string1 ? null : string0 === string00 && string1 === string10 ? interpolate0 : (string10 = string1, interpolate0 = interpolate2(string00 = string0, value1));
    };
  }
  function styleMaybeRemove(id2, name2) {
    var on0, on1, listener0, key = "style." + name2, event = "end." + key, remove2;
    return function() {
      var schedule2 = set$2(this, id2), on = schedule2.on, listener = schedule2.value[key] == null ? remove2 || (remove2 = styleRemove(name2)) : void 0;
      if (on !== on0 || listener0 !== listener)
        (on1 = (on0 = on).copy()).on(event, listener0 = listener);
      schedule2.on = on1;
    };
  }
  function transition_style(name2, value, priority) {
    var i2 = (name2 += "") === "transform" ? interpolateTransformCss : interpolate;
    return value == null ? this.styleTween(name2, styleNull(name2, i2)).on("end.style." + name2, styleRemove(name2)) : typeof value === "function" ? this.styleTween(name2, styleFunction(name2, i2, tweenValue(this, "style." + name2, value))).each(styleMaybeRemove(this._id, name2)) : this.styleTween(name2, styleConstant(name2, i2, value), priority).on("end.style." + name2, null);
  }
  function styleInterpolate(name2, i2, priority) {
    return function(t) {
      this.style.setProperty(name2, i2.call(this, t), priority);
    };
  }
  function styleTween(name2, value, priority) {
    var t, i0;
    function tween() {
      var i2 = value.apply(this, arguments);
      if (i2 !== i0)
        t = (i0 = i2) && styleInterpolate(name2, i2, priority);
      return t;
    }
    tween._value = value;
    return tween;
  }
  function transition_styleTween(name2, value, priority) {
    var key = "style." + (name2 += "");
    if (arguments.length < 2)
      return (key = this.tween(key)) && key._value;
    if (value == null)
      return this.tween(key, null);
    if (typeof value !== "function")
      throw new Error();
    return this.tween(key, styleTween(name2, value, priority == null ? "" : priority));
  }
  function textConstant(value) {
    return function() {
      this.textContent = value;
    };
  }
  function textFunction(value) {
    return function() {
      var value1 = value(this);
      this.textContent = value1 == null ? "" : value1;
    };
  }
  function transition_text(value) {
    return this.tween("text", typeof value === "function" ? textFunction(tweenValue(this, "text", value)) : textConstant(value == null ? "" : value + ""));
  }
  function textInterpolate(i2) {
    return function(t) {
      this.textContent = i2.call(this, t);
    };
  }
  function textTween(value) {
    var t02, i0;
    function tween() {
      var i2 = value.apply(this, arguments);
      if (i2 !== i0)
        t02 = (i0 = i2) && textInterpolate(i2);
      return t02;
    }
    tween._value = value;
    return tween;
  }
  function transition_textTween(value) {
    var key = "text";
    if (arguments.length < 1)
      return (key = this.tween(key)) && key._value;
    if (value == null)
      return this.tween(key, null);
    if (typeof value !== "function")
      throw new Error();
    return this.tween(key, textTween(value));
  }
  function transition_transition() {
    var name2 = this._name, id0 = this._id, id1 = newId();
    for (var groups = this._groups, m = groups.length, j = 0; j < m; ++j) {
      for (var group = groups[j], n = group.length, node2, i2 = 0; i2 < n; ++i2) {
        if (node2 = group[i2]) {
          var inherit2 = get$2(node2, id0);
          schedule(node2, name2, id1, i2, group, {
            time: inherit2.time + inherit2.delay + inherit2.duration,
            delay: 0,
            duration: inherit2.duration,
            ease: inherit2.ease
          });
        }
      }
    }
    return new Transition(groups, this._parents, name2, id1);
  }
  function transition_end() {
    var on0, on1, that = this, id2 = that._id, size2 = that.size();
    return new Promise(function(resolve, reject) {
      var cancel = { value: reject }, end2 = { value: function() {
        if (--size2 === 0)
          resolve();
      } };
      that.each(function() {
        var schedule2 = set$2(this, id2), on = schedule2.on;
        if (on !== on0) {
          on1 = (on0 = on).copy();
          on1._.cancel.push(cancel);
          on1._.interrupt.push(cancel);
          on1._.end.push(end2);
        }
        schedule2.on = on1;
      });
      if (size2 === 0)
        resolve();
    });
  }
  var id$j = 0;
  function Transition(groups, parents2, name2, id2) {
    this._groups = groups;
    this._parents = parents2;
    this._name = name2;
    this._id = id2;
  }
  function newId() {
    return ++id$j;
  }
  var selection_prototype = selection.prototype;
  Transition.prototype = {
    constructor: Transition,
    select: transition_select,
    selectAll: transition_selectAll,
    selectChild: selection_prototype.selectChild,
    selectChildren: selection_prototype.selectChildren,
    filter: transition_filter,
    merge: transition_merge,
    selection: transition_selection,
    transition: transition_transition,
    call: selection_prototype.call,
    nodes: selection_prototype.nodes,
    node: selection_prototype.node,
    size: selection_prototype.size,
    empty: selection_prototype.empty,
    each: selection_prototype.each,
    on: transition_on,
    attr: transition_attr,
    attrTween: transition_attrTween,
    style: transition_style,
    styleTween: transition_styleTween,
    text: transition_text,
    textTween: transition_textTween,
    remove: transition_remove,
    tween: transition_tween,
    delay: transition_delay,
    duration: transition_duration,
    ease: transition_ease,
    easeVarying: transition_easeVarying,
    end: transition_end,
    [Symbol.iterator]: selection_prototype[Symbol.iterator]
  };
  function cubicInOut(t) {
    return ((t *= 2) <= 1 ? t * t * t : (t -= 2) * t * t + 2) / 2;
  }
  var defaultTiming = {
    time: null,
    // Set on use.
    delay: 0,
    duration: 250,
    ease: cubicInOut
  };
  function inherit(node2, id2) {
    var timing;
    while (!(timing = node2.__transition) || !(timing = timing[id2])) {
      if (!(node2 = node2.parentNode)) {
        throw new Error(`transition ${id2} not found`);
      }
    }
    return timing;
  }
  function selection_transition(name2) {
    var id2, timing;
    if (name2 instanceof Transition) {
      id2 = name2._id, name2 = name2._name;
    } else {
      id2 = newId(), (timing = defaultTiming).time = now$2(), name2 = name2 == null ? null : name2 + "";
    }
    for (var groups = this._groups, m = groups.length, j = 0; j < m; ++j) {
      for (var group = groups[j], n = group.length, node2, i2 = 0; i2 < n; ++i2) {
        if (node2 = group[i2]) {
          schedule(node2, name2, id2, i2, group, timing || inherit(node2, id2));
        }
      }
    }
    return new Transition(groups, this._parents, name2, id2);
  }
  selection.prototype.interrupt = selection_interrupt;
  selection.prototype.transition = selection_transition;
  const pi$1 = Math.PI, tau$1 = 2 * pi$1, epsilon$1 = 1e-6, tauEpsilon = tau$1 - epsilon$1;
  function Path() {
    this._x0 = this._y0 = // start of current subpath
    this._x1 = this._y1 = null;
    this._ = "";
  }
  function path() {
    return new Path();
  }
  Path.prototype = path.prototype = {
    constructor: Path,
    moveTo: function(x2, y2) {
      this._ += "M" + (this._x0 = this._x1 = +x2) + "," + (this._y0 = this._y1 = +y2);
    },
    closePath: function() {
      if (this._x1 !== null) {
        this._x1 = this._x0, this._y1 = this._y0;
        this._ += "Z";
      }
    },
    lineTo: function(x2, y2) {
      this._ += "L" + (this._x1 = +x2) + "," + (this._y1 = +y2);
    },
    quadraticCurveTo: function(x1, y1, x2, y2) {
      this._ += "Q" + +x1 + "," + +y1 + "," + (this._x1 = +x2) + "," + (this._y1 = +y2);
    },
    bezierCurveTo: function(x1, y1, x2, y2, x3, y3) {
      this._ += "C" + +x1 + "," + +y1 + "," + +x2 + "," + +y2 + "," + (this._x1 = +x3) + "," + (this._y1 = +y3);
    },
    arcTo: function(x1, y1, x2, y2, r) {
      x1 = +x1, y1 = +y1, x2 = +x2, y2 = +y2, r = +r;
      var x0 = this._x1, y0 = this._y1, x21 = x2 - x1, y21 = y2 - y1, x01 = x0 - x1, y01 = y0 - y1, l01_2 = x01 * x01 + y01 * y01;
      if (r < 0)
        throw new Error("negative radius: " + r);
      if (this._x1 === null) {
        this._ += "M" + (this._x1 = x1) + "," + (this._y1 = y1);
      } else if (!(l01_2 > epsilon$1))
        ;
      else if (!(Math.abs(y01 * x21 - y21 * x01) > epsilon$1) || !r) {
        this._ += "L" + (this._x1 = x1) + "," + (this._y1 = y1);
      } else {
        var x20 = x2 - x0, y20 = y2 - y0, l21_2 = x21 * x21 + y21 * y21, l20_2 = x20 * x20 + y20 * y20, l21 = Math.sqrt(l21_2), l01 = Math.sqrt(l01_2), l = r * Math.tan((pi$1 - Math.acos((l21_2 + l01_2 - l20_2) / (2 * l21 * l01))) / 2), t01 = l / l01, t21 = l / l21;
        if (Math.abs(t01 - 1) > epsilon$1) {
          this._ += "L" + (x1 + t01 * x01) + "," + (y1 + t01 * y01);
        }
        this._ += "A" + r + "," + r + ",0,0," + +(y01 * x20 > x01 * y20) + "," + (this._x1 = x1 + t21 * x21) + "," + (this._y1 = y1 + t21 * y21);
      }
    },
    arc: function(x2, y2, r, a0, a1, ccw) {
      x2 = +x2, y2 = +y2, r = +r, ccw = !!ccw;
      var dx = r * Math.cos(a0), dy = r * Math.sin(a0), x0 = x2 + dx, y0 = y2 + dy, cw = 1 ^ ccw, da = ccw ? a0 - a1 : a1 - a0;
      if (r < 0)
        throw new Error("negative radius: " + r);
      if (this._x1 === null) {
        this._ += "M" + x0 + "," + y0;
      } else if (Math.abs(this._x1 - x0) > epsilon$1 || Math.abs(this._y1 - y0) > epsilon$1) {
        this._ += "L" + x0 + "," + y0;
      }
      if (!r)
        return;
      if (da < 0)
        da = da % tau$1 + tau$1;
      if (da > tauEpsilon) {
        this._ += "A" + r + "," + r + ",0,1," + cw + "," + (x2 - dx) + "," + (y2 - dy) + "A" + r + "," + r + ",0,1," + cw + "," + (this._x1 = x0) + "," + (this._y1 = y0);
      } else if (da > epsilon$1) {
        this._ += "A" + r + "," + r + ",0," + +(da >= pi$1) + "," + cw + "," + (this._x1 = x2 + r * Math.cos(a1)) + "," + (this._y1 = y2 + r * Math.sin(a1));
      }
    },
    rect: function(x2, y2, w2, h) {
      this._ += "M" + (this._x0 = this._x1 = +x2) + "," + (this._y0 = this._y1 = +y2) + "h" + +w2 + "v" + +h + "h" + -w2 + "Z";
    },
    toString: function() {
      return this._;
    }
  };
  function responseText(response) {
    if (!response.ok)
      throw new Error(response.status + " " + response.statusText);
    return response.text();
  }
  function text$3(input, init2) {
    return fetch(input, init2).then(responseText);
  }
  function parser$p(type2) {
    return (input, init2) => text$3(input, init2).then((text2) => new DOMParser().parseFromString(text2, type2));
  }
  var svg$2 = parser$p("image/svg+xml");
  function formatDecimal(x2) {
    return Math.abs(x2 = Math.round(x2)) >= 1e21 ? x2.toLocaleString("en").replace(/,/g, "") : x2.toString(10);
  }
  function formatDecimalParts(x2, p) {
    if ((i2 = (x2 = p ? x2.toExponential(p - 1) : x2.toExponential()).indexOf("e")) < 0)
      return null;
    var i2, coefficient = x2.slice(0, i2);
    return [
      coefficient.length > 1 ? coefficient[0] + coefficient.slice(2) : coefficient,
      +x2.slice(i2 + 1)
    ];
  }
  function exponent(x2) {
    return x2 = formatDecimalParts(Math.abs(x2)), x2 ? x2[1] : NaN;
  }
  function formatGroup(grouping, thousands) {
    return function(value, width2) {
      var i2 = value.length, t = [], j = 0, g = grouping[0], length2 = 0;
      while (i2 > 0 && g > 0) {
        if (length2 + g + 1 > width2)
          g = Math.max(1, width2 - length2);
        t.push(value.substring(i2 -= g, i2 + g));
        if ((length2 += g + 1) > width2)
          break;
        g = grouping[j = (j + 1) % grouping.length];
      }
      return t.reverse().join(thousands);
    };
  }
  function formatNumerals(numerals) {
    return function(value) {
      return value.replace(/[0-9]/g, function(i2) {
        return numerals[+i2];
      });
    };
  }
  var re = /^(?:(.)?([<>=^]))?([+\-( ])?([$#])?(0)?(\d+)?(,)?(\.\d+)?(~)?([a-z%])?$/i;
  function formatSpecifier(specifier) {
    if (!(match = re.exec(specifier)))
      throw new Error("invalid format: " + specifier);
    var match;
    return new FormatSpecifier({
      fill: match[1],
      align: match[2],
      sign: match[3],
      symbol: match[4],
      zero: match[5],
      width: match[6],
      comma: match[7],
      precision: match[8] && match[8].slice(1),
      trim: match[9],
      type: match[10]
    });
  }
  formatSpecifier.prototype = FormatSpecifier.prototype;
  function FormatSpecifier(specifier) {
    this.fill = specifier.fill === void 0 ? " " : specifier.fill + "";
    this.align = specifier.align === void 0 ? ">" : specifier.align + "";
    this.sign = specifier.sign === void 0 ? "-" : specifier.sign + "";
    this.symbol = specifier.symbol === void 0 ? "" : specifier.symbol + "";
    this.zero = !!specifier.zero;
    this.width = specifier.width === void 0 ? void 0 : +specifier.width;
    this.comma = !!specifier.comma;
    this.precision = specifier.precision === void 0 ? void 0 : +specifier.precision;
    this.trim = !!specifier.trim;
    this.type = specifier.type === void 0 ? "" : specifier.type + "";
  }
  FormatSpecifier.prototype.toString = function() {
    return this.fill + this.align + this.sign + this.symbol + (this.zero ? "0" : "") + (this.width === void 0 ? "" : Math.max(1, this.width | 0)) + (this.comma ? "," : "") + (this.precision === void 0 ? "" : "." + Math.max(0, this.precision | 0)) + (this.trim ? "~" : "") + this.type;
  };
  function formatTrim(s) {
    out:
      for (var n = s.length, i2 = 1, i0 = -1, i1; i2 < n; ++i2) {
        switch (s[i2]) {
          case ".":
            i0 = i1 = i2;
            break;
          case "0":
            if (i0 === 0)
              i0 = i2;
            i1 = i2;
            break;
          default:
            if (!+s[i2])
              break out;
            if (i0 > 0)
              i0 = 0;
            break;
        }
      }
    return i0 > 0 ? s.slice(0, i0) + s.slice(i1 + 1) : s;
  }
  var prefixExponent;
  function formatPrefixAuto(x2, p) {
    var d = formatDecimalParts(x2, p);
    if (!d)
      return x2 + "";
    var coefficient = d[0], exponent2 = d[1], i2 = exponent2 - (prefixExponent = Math.max(-8, Math.min(8, Math.floor(exponent2 / 3))) * 3) + 1, n = coefficient.length;
    return i2 === n ? coefficient : i2 > n ? coefficient + new Array(i2 - n + 1).join("0") : i2 > 0 ? coefficient.slice(0, i2) + "." + coefficient.slice(i2) : "0." + new Array(1 - i2).join("0") + formatDecimalParts(x2, Math.max(0, p + i2 - 1))[0];
  }
  function formatRounded(x2, p) {
    var d = formatDecimalParts(x2, p);
    if (!d)
      return x2 + "";
    var coefficient = d[0], exponent2 = d[1];
    return exponent2 < 0 ? "0." + new Array(-exponent2).join("0") + coefficient : coefficient.length > exponent2 + 1 ? coefficient.slice(0, exponent2 + 1) + "." + coefficient.slice(exponent2 + 1) : coefficient + new Array(exponent2 - coefficient.length + 2).join("0");
  }
  const formatTypes = {
    "%": (x2, p) => (x2 * 100).toFixed(p),
    "b": (x2) => Math.round(x2).toString(2),
    "c": (x2) => x2 + "",
    "d": formatDecimal,
    "e": (x2, p) => x2.toExponential(p),
    "f": (x2, p) => x2.toFixed(p),
    "g": (x2, p) => x2.toPrecision(p),
    "o": (x2) => Math.round(x2).toString(8),
    "p": (x2, p) => formatRounded(x2 * 100, p),
    "r": formatRounded,
    "s": formatPrefixAuto,
    "X": (x2) => Math.round(x2).toString(16).toUpperCase(),
    "x": (x2) => Math.round(x2).toString(16)
  };
  function identity$3(x2) {
    return x2;
  }
  var map$2 = Array.prototype.map, prefixes = ["y", "z", "a", "f", "p", "n", "µ", "m", "", "k", "M", "G", "T", "P", "E", "Z", "Y"];
  function formatLocale$1(locale2) {
    var group = locale2.grouping === void 0 || locale2.thousands === void 0 ? identity$3 : formatGroup(map$2.call(locale2.grouping, Number), locale2.thousands + ""), currencyPrefix = locale2.currency === void 0 ? "" : locale2.currency[0] + "", currencySuffix = locale2.currency === void 0 ? "" : locale2.currency[1] + "", decimal = locale2.decimal === void 0 ? "." : locale2.decimal + "", numerals = locale2.numerals === void 0 ? identity$3 : formatNumerals(map$2.call(locale2.numerals, String)), percent = locale2.percent === void 0 ? "%" : locale2.percent + "", minus = locale2.minus === void 0 ? "−" : locale2.minus + "", nan = locale2.nan === void 0 ? "NaN" : locale2.nan + "";
    function newFormat(specifier) {
      specifier = formatSpecifier(specifier);
      var fill = specifier.fill, align = specifier.align, sign2 = specifier.sign, symbol = specifier.symbol, zero2 = specifier.zero, width2 = specifier.width, comma = specifier.comma, precision = specifier.precision, trim2 = specifier.trim, type2 = specifier.type;
      if (type2 === "n")
        comma = true, type2 = "g";
      else if (!formatTypes[type2])
        precision === void 0 && (precision = 12), trim2 = true, type2 = "g";
      if (zero2 || fill === "0" && align === "=")
        zero2 = true, fill = "0", align = "=";
      var prefix = symbol === "$" ? currencyPrefix : symbol === "#" && /[boxX]/.test(type2) ? "0" + type2.toLowerCase() : "", suffix = symbol === "$" ? currencySuffix : /[%p]/.test(type2) ? percent : "";
      var formatType = formatTypes[type2], maybeSuffix = /[defgprs%]/.test(type2);
      precision = precision === void 0 ? 6 : /[gprs]/.test(type2) ? Math.max(1, Math.min(21, precision)) : Math.max(0, Math.min(20, precision));
      function format2(value) {
        var valuePrefix = prefix, valueSuffix = suffix, i2, n, c2;
        if (type2 === "c") {
          valueSuffix = formatType(value) + valueSuffix;
          value = "";
        } else {
          value = +value;
          var valueNegative = value < 0 || 1 / value < 0;
          value = isNaN(value) ? nan : formatType(Math.abs(value), precision);
          if (trim2)
            value = formatTrim(value);
          if (valueNegative && +value === 0 && sign2 !== "+")
            valueNegative = false;
          valuePrefix = (valueNegative ? sign2 === "(" ? sign2 : minus : sign2 === "-" || sign2 === "(" ? "" : sign2) + valuePrefix;
          valueSuffix = (type2 === "s" ? prefixes[8 + prefixExponent / 3] : "") + valueSuffix + (valueNegative && sign2 === "(" ? ")" : "");
          if (maybeSuffix) {
            i2 = -1, n = value.length;
            while (++i2 < n) {
              if (c2 = value.charCodeAt(i2), 48 > c2 || c2 > 57) {
                valueSuffix = (c2 === 46 ? decimal + value.slice(i2 + 1) : value.slice(i2)) + valueSuffix;
                value = value.slice(0, i2);
                break;
              }
            }
          }
        }
        if (comma && !zero2)
          value = group(value, Infinity);
        var length2 = valuePrefix.length + value.length + valueSuffix.length, padding2 = length2 < width2 ? new Array(width2 - length2 + 1).join(fill) : "";
        if (comma && zero2)
          value = group(padding2 + value, padding2.length ? width2 - valueSuffix.length : Infinity), padding2 = "";
        switch (align) {
          case "<":
            value = valuePrefix + value + valueSuffix + padding2;
            break;
          case "=":
            value = valuePrefix + padding2 + value + valueSuffix;
            break;
          case "^":
            value = padding2.slice(0, length2 = padding2.length >> 1) + valuePrefix + value + valueSuffix + padding2.slice(length2);
            break;
          default:
            value = padding2 + valuePrefix + value + valueSuffix;
            break;
        }
        return numerals(value);
      }
      format2.toString = function() {
        return specifier + "";
      };
      return format2;
    }
    function formatPrefix2(specifier, value) {
      var f2 = newFormat((specifier = formatSpecifier(specifier), specifier.type = "f", specifier)), e = Math.max(-8, Math.min(8, Math.floor(exponent(value) / 3))) * 3, k = Math.pow(10, -e), prefix = prefixes[8 + e / 3];
      return function(value2) {
        return f2(k * value2) + prefix;
      };
    }
    return {
      format: newFormat,
      formatPrefix: formatPrefix2
    };
  }
  var locale$1;
  var format;
  var formatPrefix;
  defaultLocale$1({
    thousands: ",",
    grouping: [3],
    currency: ["$", ""]
  });
  function defaultLocale$1(definition2) {
    locale$1 = formatLocale$1(definition2);
    format = locale$1.format;
    formatPrefix = locale$1.formatPrefix;
    return locale$1;
  }
  function precisionFixed(step) {
    return Math.max(0, -exponent(Math.abs(step)));
  }
  function precisionPrefix(step, value) {
    return Math.max(0, Math.max(-8, Math.min(8, Math.floor(exponent(value) / 3))) * 3 - exponent(Math.abs(step)));
  }
  function precisionRound(step, max2) {
    step = Math.abs(step), max2 = Math.abs(max2) - step;
    return Math.max(0, exponent(max2) - exponent(step)) + 1;
  }
  function initRange(domain, range2) {
    switch (arguments.length) {
      case 0:
        break;
      case 1:
        this.range(domain);
        break;
      default:
        this.range(range2).domain(domain);
        break;
    }
    return this;
  }
  const implicit = Symbol("implicit");
  function ordinal() {
    var index2 = new InternMap(), domain = [], range2 = [], unknown = implicit;
    function scale(d) {
      let i2 = index2.get(d);
      if (i2 === void 0) {
        if (unknown !== implicit)
          return unknown;
        index2.set(d, i2 = domain.push(d) - 1);
      }
      return range2[i2 % range2.length];
    }
    scale.domain = function(_2) {
      if (!arguments.length)
        return domain.slice();
      domain = [], index2 = new InternMap();
      for (const value of _2) {
        if (index2.has(value))
          continue;
        index2.set(value, domain.push(value) - 1);
      }
      return scale;
    };
    scale.range = function(_2) {
      return arguments.length ? (range2 = Array.from(_2), scale) : range2.slice();
    };
    scale.unknown = function(_2) {
      return arguments.length ? (unknown = _2, scale) : unknown;
    };
    scale.copy = function() {
      return ordinal(domain, range2).unknown(unknown);
    };
    initRange.apply(scale, arguments);
    return scale;
  }
  function constants(x2) {
    return function() {
      return x2;
    };
  }
  function number$1(x2) {
    return +x2;
  }
  var unit$1 = [0, 1];
  function identity$2(x2) {
    return x2;
  }
  function normalize(a, b) {
    return (b -= a = +a) ? function(x2) {
      return (x2 - a) / b;
    } : constants(isNaN(b) ? NaN : 0.5);
  }
  function clamper(a, b) {
    var t;
    if (a > b)
      t = a, a = b, b = t;
    return function(x2) {
      return Math.max(a, Math.min(b, x2));
    };
  }
  function bimap(domain, range2, interpolate2) {
    var d0 = domain[0], d1 = domain[1], r0 = range2[0], r1 = range2[1];
    if (d1 < d0)
      d0 = normalize(d1, d0), r0 = interpolate2(r1, r0);
    else
      d0 = normalize(d0, d1), r0 = interpolate2(r0, r1);
    return function(x2) {
      return r0(d0(x2));
    };
  }
  function polymap(domain, range2, interpolate2) {
    var j = Math.min(domain.length, range2.length) - 1, d = new Array(j), r = new Array(j), i2 = -1;
    if (domain[j] < domain[0]) {
      domain = domain.slice().reverse();
      range2 = range2.slice().reverse();
    }
    while (++i2 < j) {
      d[i2] = normalize(domain[i2], domain[i2 + 1]);
      r[i2] = interpolate2(range2[i2], range2[i2 + 1]);
    }
    return function(x2) {
      var i3 = bisect(domain, x2, 1, j) - 1;
      return r[i3](d[i3](x2));
    };
  }
  function copy$1(source, target) {
    return target.domain(source.domain()).range(source.range()).interpolate(source.interpolate()).clamp(source.clamp()).unknown(source.unknown());
  }
  function transformer() {
    var domain = unit$1, range2 = unit$1, interpolate2 = interpolate$1, transform, untransform, unknown, clamp = identity$2, piecewise, output, input;
    function rescale() {
      var n = Math.min(domain.length, range2.length);
      if (clamp !== identity$2)
        clamp = clamper(domain[0], domain[n - 1]);
      piecewise = n > 2 ? polymap : bimap;
      output = input = null;
      return scale;
    }
    function scale(x2) {
      return x2 == null || isNaN(x2 = +x2) ? unknown : (output || (output = piecewise(domain.map(transform), range2, interpolate2)))(transform(clamp(x2)));
    }
    scale.invert = function(y2) {
      return clamp(untransform((input || (input = piecewise(range2, domain.map(transform), interpolateNumber)))(y2)));
    };
    scale.domain = function(_2) {
      return arguments.length ? (domain = Array.from(_2, number$1), rescale()) : domain.slice();
    };
    scale.range = function(_2) {
      return arguments.length ? (range2 = Array.from(_2), rescale()) : range2.slice();
    };
    scale.rangeRound = function(_2) {
      return range2 = Array.from(_2), interpolate2 = interpolateRound, rescale();
    };
    scale.clamp = function(_2) {
      return arguments.length ? (clamp = _2 ? true : identity$2, rescale()) : clamp !== identity$2;
    };
    scale.interpolate = function(_2) {
      return arguments.length ? (interpolate2 = _2, rescale()) : interpolate2;
    };
    scale.unknown = function(_2) {
      return arguments.length ? (unknown = _2, scale) : unknown;
    };
    return function(t, u) {
      transform = t, untransform = u;
      return rescale();
    };
  }
  function continuous() {
    return transformer()(identity$2, identity$2);
  }
  function tickFormat(start2, stop, count, specifier) {
    var step = tickStep(start2, stop, count), precision;
    specifier = formatSpecifier(specifier == null ? ",f" : specifier);
    switch (specifier.type) {
      case "s": {
        var value = Math.max(Math.abs(start2), Math.abs(stop));
        if (specifier.precision == null && !isNaN(precision = precisionPrefix(step, value)))
          specifier.precision = precision;
        return formatPrefix(specifier, value);
      }
      case "":
      case "e":
      case "g":
      case "p":
      case "r": {
        if (specifier.precision == null && !isNaN(precision = precisionRound(step, Math.max(Math.abs(start2), Math.abs(stop)))))
          specifier.precision = precision - (specifier.type === "e");
        break;
      }
      case "f":
      case "%": {
        if (specifier.precision == null && !isNaN(precision = precisionFixed(step)))
          specifier.precision = precision - (specifier.type === "%") * 2;
        break;
      }
    }
    return format(specifier);
  }
  function linearish(scale) {
    var domain = scale.domain;
    scale.ticks = function(count) {
      var d = domain();
      return ticks(d[0], d[d.length - 1], count == null ? 10 : count);
    };
    scale.tickFormat = function(count, specifier) {
      var d = domain();
      return tickFormat(d[0], d[d.length - 1], count == null ? 10 : count, specifier);
    };
    scale.nice = function(count) {
      if (count == null)
        count = 10;
      var d = domain();
      var i0 = 0;
      var i1 = d.length - 1;
      var start2 = d[i0];
      var stop = d[i1];
      var prestep;
      var step;
      var maxIter = 10;
      if (stop < start2) {
        step = start2, start2 = stop, stop = step;
        step = i0, i0 = i1, i1 = step;
      }
      while (maxIter-- > 0) {
        step = tickIncrement(start2, stop, count);
        if (step === prestep) {
          d[i0] = start2;
          d[i1] = stop;
          return domain(d);
        } else if (step > 0) {
          start2 = Math.floor(start2 / step) * step;
          stop = Math.ceil(stop / step) * step;
        } else if (step < 0) {
          start2 = Math.ceil(start2 * step) / step;
          stop = Math.floor(stop * step) / step;
        } else {
          break;
        }
        prestep = step;
      }
      return scale;
    };
    return scale;
  }
  function linear() {
    var scale = continuous();
    scale.copy = function() {
      return copy$1(scale, linear());
    };
    initRange.apply(scale, arguments);
    return linearish(scale);
  }
  function nice(domain, interval2) {
    domain = domain.slice();
    var i0 = 0, i1 = domain.length - 1, x0 = domain[i0], x1 = domain[i1], t;
    if (x1 < x0) {
      t = i0, i0 = i1, i1 = t;
      t = x0, x0 = x1, x1 = t;
    }
    domain[i0] = interval2.floor(x0);
    domain[i1] = interval2.ceil(x1);
    return domain;
  }
  var t0 = /* @__PURE__ */ new Date(), t1 = /* @__PURE__ */ new Date();
  function newInterval(floori, offseti, count, field) {
    function interval2(date2) {
      return floori(date2 = arguments.length === 0 ? /* @__PURE__ */ new Date() : /* @__PURE__ */ new Date(+date2)), date2;
    }
    interval2.floor = function(date2) {
      return floori(date2 = /* @__PURE__ */ new Date(+date2)), date2;
    };
    interval2.ceil = function(date2) {
      return floori(date2 = new Date(date2 - 1)), offseti(date2, 1), floori(date2), date2;
    };
    interval2.round = function(date2) {
      var d0 = interval2(date2), d1 = interval2.ceil(date2);
      return date2 - d0 < d1 - date2 ? d0 : d1;
    };
    interval2.offset = function(date2, step) {
      return offseti(date2 = /* @__PURE__ */ new Date(+date2), step == null ? 1 : Math.floor(step)), date2;
    };
    interval2.range = function(start2, stop, step) {
      var range2 = [], previous2;
      start2 = interval2.ceil(start2);
      step = step == null ? 1 : Math.floor(step);
      if (!(start2 < stop) || !(step > 0))
        return range2;
      do
        range2.push(previous2 = /* @__PURE__ */ new Date(+start2)), offseti(start2, step), floori(start2);
      while (previous2 < start2 && start2 < stop);
      return range2;
    };
    interval2.filter = function(test) {
      return newInterval(function(date2) {
        if (date2 >= date2)
          while (floori(date2), !test(date2))
            date2.setTime(date2 - 1);
      }, function(date2, step) {
        if (date2 >= date2) {
          if (step < 0)
            while (++step <= 0) {
              while (offseti(date2, -1), !test(date2)) {
              }
            }
          else
            while (--step >= 0) {
              while (offseti(date2, 1), !test(date2)) {
              }
            }
        }
      });
    };
    if (count) {
      interval2.count = function(start2, end2) {
        t0.setTime(+start2), t1.setTime(+end2);
        floori(t0), floori(t1);
        return Math.floor(count(t0, t1));
      };
      interval2.every = function(step) {
        step = Math.floor(step);
        return !isFinite(step) || !(step > 0) ? null : !(step > 1) ? interval2 : interval2.filter(field ? function(d) {
          return field(d) % step === 0;
        } : function(d) {
          return interval2.count(0, d) % step === 0;
        });
      };
    }
    return interval2;
  }
  var millisecond = newInterval(function() {
  }, function(date2, step) {
    date2.setTime(+date2 + step);
  }, function(start2, end2) {
    return end2 - start2;
  });
  millisecond.every = function(k) {
    k = Math.floor(k);
    if (!isFinite(k) || !(k > 0))
      return null;
    if (!(k > 1))
      return millisecond;
    return newInterval(function(date2) {
      date2.setTime(Math.floor(date2 / k) * k);
    }, function(date2, step) {
      date2.setTime(+date2 + step * k);
    }, function(start2, end2) {
      return (end2 - start2) / k;
    });
  };
  const millisecond$1 = millisecond;
  millisecond.range;
  const durationSecond = 1e3;
  const durationMinute = durationSecond * 60;
  const durationHour = durationMinute * 60;
  const durationDay = durationHour * 24;
  const durationWeek = durationDay * 7;
  const durationMonth = durationDay * 30;
  const durationYear = durationDay * 365;
  var second = newInterval(function(date2) {
    date2.setTime(date2 - date2.getMilliseconds());
  }, function(date2, step) {
    date2.setTime(+date2 + step * durationSecond);
  }, function(start2, end2) {
    return (end2 - start2) / durationSecond;
  }, function(date2) {
    return date2.getUTCSeconds();
  });
  const utcSecond = second;
  second.range;
  var minute = newInterval(function(date2) {
    date2.setTime(date2 - date2.getMilliseconds() - date2.getSeconds() * durationSecond);
  }, function(date2, step) {
    date2.setTime(+date2 + step * durationMinute);
  }, function(start2, end2) {
    return (end2 - start2) / durationMinute;
  }, function(date2) {
    return date2.getMinutes();
  });
  const timeMinute = minute;
  minute.range;
  var hour = newInterval(function(date2) {
    date2.setTime(date2 - date2.getMilliseconds() - date2.getSeconds() * durationSecond - date2.getMinutes() * durationMinute);
  }, function(date2, step) {
    date2.setTime(+date2 + step * durationHour);
  }, function(start2, end2) {
    return (end2 - start2) / durationHour;
  }, function(date2) {
    return date2.getHours();
  });
  const timeHour = hour;
  hour.range;
  var day = newInterval(
    (date2) => date2.setHours(0, 0, 0, 0),
    (date2, step) => date2.setDate(date2.getDate() + step),
    (start2, end2) => (end2 - start2 - (end2.getTimezoneOffset() - start2.getTimezoneOffset()) * durationMinute) / durationDay,
    (date2) => date2.getDate() - 1
  );
  const timeDay = day;
  day.range;
  function weekday(i2) {
    return newInterval(function(date2) {
      date2.setDate(date2.getDate() - (date2.getDay() + 7 - i2) % 7);
      date2.setHours(0, 0, 0, 0);
    }, function(date2, step) {
      date2.setDate(date2.getDate() + step * 7);
    }, function(start2, end2) {
      return (end2 - start2 - (end2.getTimezoneOffset() - start2.getTimezoneOffset()) * durationMinute) / durationWeek;
    });
  }
  var sunday = weekday(0);
  var monday = weekday(1);
  var tuesday = weekday(2);
  var wednesday = weekday(3);
  var thursday = weekday(4);
  var friday = weekday(5);
  var saturday = weekday(6);
  sunday.range;
  monday.range;
  tuesday.range;
  wednesday.range;
  thursday.range;
  friday.range;
  saturday.range;
  var month = newInterval(function(date2) {
    date2.setDate(1);
    date2.setHours(0, 0, 0, 0);
  }, function(date2, step) {
    date2.setMonth(date2.getMonth() + step);
  }, function(start2, end2) {
    return end2.getMonth() - start2.getMonth() + (end2.getFullYear() - start2.getFullYear()) * 12;
  }, function(date2) {
    return date2.getMonth();
  });
  const timeMonth = month;
  month.range;
  var year = newInterval(function(date2) {
    date2.setMonth(0, 1);
    date2.setHours(0, 0, 0, 0);
  }, function(date2, step) {
    date2.setFullYear(date2.getFullYear() + step);
  }, function(start2, end2) {
    return end2.getFullYear() - start2.getFullYear();
  }, function(date2) {
    return date2.getFullYear();
  });
  year.every = function(k) {
    return !isFinite(k = Math.floor(k)) || !(k > 0) ? null : newInterval(function(date2) {
      date2.setFullYear(Math.floor(date2.getFullYear() / k) * k);
      date2.setMonth(0, 1);
      date2.setHours(0, 0, 0, 0);
    }, function(date2, step) {
      date2.setFullYear(date2.getFullYear() + step * k);
    });
  };
  const timeYear = year;
  year.range;
  var utcDay = newInterval(function(date2) {
    date2.setUTCHours(0, 0, 0, 0);
  }, function(date2, step) {
    date2.setUTCDate(date2.getUTCDate() + step);
  }, function(start2, end2) {
    return (end2 - start2) / durationDay;
  }, function(date2) {
    return date2.getUTCDate() - 1;
  });
  const utcDay$1 = utcDay;
  utcDay.range;
  function utcWeekday(i2) {
    return newInterval(function(date2) {
      date2.setUTCDate(date2.getUTCDate() - (date2.getUTCDay() + 7 - i2) % 7);
      date2.setUTCHours(0, 0, 0, 0);
    }, function(date2, step) {
      date2.setUTCDate(date2.getUTCDate() + step * 7);
    }, function(start2, end2) {
      return (end2 - start2) / durationWeek;
    });
  }
  var utcSunday = utcWeekday(0);
  var utcMonday = utcWeekday(1);
  var utcTuesday = utcWeekday(2);
  var utcWednesday = utcWeekday(3);
  var utcThursday = utcWeekday(4);
  var utcFriday = utcWeekday(5);
  var utcSaturday = utcWeekday(6);
  utcSunday.range;
  utcMonday.range;
  utcTuesday.range;
  utcWednesday.range;
  utcThursday.range;
  utcFriday.range;
  utcSaturday.range;
  var utcYear = newInterval(function(date2) {
    date2.setUTCMonth(0, 1);
    date2.setUTCHours(0, 0, 0, 0);
  }, function(date2, step) {
    date2.setUTCFullYear(date2.getUTCFullYear() + step);
  }, function(start2, end2) {
    return end2.getUTCFullYear() - start2.getUTCFullYear();
  }, function(date2) {
    return date2.getUTCFullYear();
  });
  utcYear.every = function(k) {
    return !isFinite(k = Math.floor(k)) || !(k > 0) ? null : newInterval(function(date2) {
      date2.setUTCFullYear(Math.floor(date2.getUTCFullYear() / k) * k);
      date2.setUTCMonth(0, 1);
      date2.setUTCHours(0, 0, 0, 0);
    }, function(date2, step) {
      date2.setUTCFullYear(date2.getUTCFullYear() + step * k);
    });
  };
  const utcYear$1 = utcYear;
  utcYear.range;
  function ticker(year2, month2, week, day2, hour2, minute2) {
    const tickIntervals = [
      [utcSecond, 1, durationSecond],
      [utcSecond, 5, 5 * durationSecond],
      [utcSecond, 15, 15 * durationSecond],
      [utcSecond, 30, 30 * durationSecond],
      [minute2, 1, durationMinute],
      [minute2, 5, 5 * durationMinute],
      [minute2, 15, 15 * durationMinute],
      [minute2, 30, 30 * durationMinute],
      [hour2, 1, durationHour],
      [hour2, 3, 3 * durationHour],
      [hour2, 6, 6 * durationHour],
      [hour2, 12, 12 * durationHour],
      [day2, 1, durationDay],
      [day2, 2, 2 * durationDay],
      [week, 1, durationWeek],
      [month2, 1, durationMonth],
      [month2, 3, 3 * durationMonth],
      [year2, 1, durationYear]
    ];
    function ticks2(start2, stop, count) {
      const reverse = stop < start2;
      if (reverse)
        [start2, stop] = [stop, start2];
      const interval2 = count && typeof count.range === "function" ? count : tickInterval2(start2, stop, count);
      const ticks3 = interval2 ? interval2.range(start2, +stop + 1) : [];
      return reverse ? ticks3.reverse() : ticks3;
    }
    function tickInterval2(start2, stop, count) {
      const target = Math.abs(stop - start2) / count;
      const i2 = bisector(([, , step2]) => step2).right(tickIntervals, target);
      if (i2 === tickIntervals.length)
        return year2.every(tickStep(start2 / durationYear, stop / durationYear, count));
      if (i2 === 0)
        return millisecond$1.every(Math.max(tickStep(start2, stop, count), 1));
      const [t, step] = tickIntervals[target / tickIntervals[i2 - 1][2] < tickIntervals[i2][2] / target ? i2 - 1 : i2];
      return t.every(step);
    }
    return [ticks2, tickInterval2];
  }
  const [timeTicks, timeTickInterval] = ticker(timeYear, timeMonth, sunday, timeDay, timeHour, timeMinute);
  function localDate(d) {
    if (0 <= d.y && d.y < 100) {
      var date2 = new Date(-1, d.m, d.d, d.H, d.M, d.S, d.L);
      date2.setFullYear(d.y);
      return date2;
    }
    return new Date(d.y, d.m, d.d, d.H, d.M, d.S, d.L);
  }
  function utcDate(d) {
    if (0 <= d.y && d.y < 100) {
      var date2 = new Date(Date.UTC(-1, d.m, d.d, d.H, d.M, d.S, d.L));
      date2.setUTCFullYear(d.y);
      return date2;
    }
    return new Date(Date.UTC(d.y, d.m, d.d, d.H, d.M, d.S, d.L));
  }
  function newDate(y2, m, d) {
    return { y: y2, m, d, H: 0, M: 0, S: 0, L: 0 };
  }
  function formatLocale(locale2) {
    var locale_dateTime = locale2.dateTime, locale_date = locale2.date, locale_time = locale2.time, locale_periods = locale2.periods, locale_weekdays = locale2.days, locale_shortWeekdays = locale2.shortDays, locale_months = locale2.months, locale_shortMonths = locale2.shortMonths;
    var periodRe = formatRe(locale_periods), periodLookup = formatLookup(locale_periods), weekdayRe = formatRe(locale_weekdays), weekdayLookup = formatLookup(locale_weekdays), shortWeekdayRe = formatRe(locale_shortWeekdays), shortWeekdayLookup = formatLookup(locale_shortWeekdays), monthRe = formatRe(locale_months), monthLookup = formatLookup(locale_months), shortMonthRe = formatRe(locale_shortMonths), shortMonthLookup = formatLookup(locale_shortMonths);
    var formats = {
      "a": formatShortWeekday,
      "A": formatWeekday,
      "b": formatShortMonth,
      "B": formatMonth,
      "c": null,
      "d": formatDayOfMonth,
      "e": formatDayOfMonth,
      "f": formatMicroseconds,
      "g": formatYearISO,
      "G": formatFullYearISO,
      "H": formatHour24,
      "I": formatHour12,
      "j": formatDayOfYear,
      "L": formatMilliseconds,
      "m": formatMonthNumber,
      "M": formatMinutes,
      "p": formatPeriod,
      "q": formatQuarter,
      "Q": formatUnixTimestamp,
      "s": formatUnixTimestampSeconds,
      "S": formatSeconds,
      "u": formatWeekdayNumberMonday,
      "U": formatWeekNumberSunday,
      "V": formatWeekNumberISO,
      "w": formatWeekdayNumberSunday,
      "W": formatWeekNumberMonday,
      "x": null,
      "X": null,
      "y": formatYear,
      "Y": formatFullYear,
      "Z": formatZone,
      "%": formatLiteralPercent
    };
    var utcFormats = {
      "a": formatUTCShortWeekday,
      "A": formatUTCWeekday,
      "b": formatUTCShortMonth,
      "B": formatUTCMonth,
      "c": null,
      "d": formatUTCDayOfMonth,
      "e": formatUTCDayOfMonth,
      "f": formatUTCMicroseconds,
      "g": formatUTCYearISO,
      "G": formatUTCFullYearISO,
      "H": formatUTCHour24,
      "I": formatUTCHour12,
      "j": formatUTCDayOfYear,
      "L": formatUTCMilliseconds,
      "m": formatUTCMonthNumber,
      "M": formatUTCMinutes,
      "p": formatUTCPeriod,
      "q": formatUTCQuarter,
      "Q": formatUnixTimestamp,
      "s": formatUnixTimestampSeconds,
      "S": formatUTCSeconds,
      "u": formatUTCWeekdayNumberMonday,
      "U": formatUTCWeekNumberSunday,
      "V": formatUTCWeekNumberISO,
      "w": formatUTCWeekdayNumberSunday,
      "W": formatUTCWeekNumberMonday,
      "x": null,
      "X": null,
      "y": formatUTCYear,
      "Y": formatUTCFullYear,
      "Z": formatUTCZone,
      "%": formatLiteralPercent
    };
    var parses = {
      "a": parseShortWeekday,
      "A": parseWeekday,
      "b": parseShortMonth,
      "B": parseMonth,
      "c": parseLocaleDateTime,
      "d": parseDayOfMonth,
      "e": parseDayOfMonth,
      "f": parseMicroseconds,
      "g": parseYear,
      "G": parseFullYear,
      "H": parseHour24,
      "I": parseHour24,
      "j": parseDayOfYear,
      "L": parseMilliseconds,
      "m": parseMonthNumber,
      "M": parseMinutes,
      "p": parsePeriod,
      "q": parseQuarter,
      "Q": parseUnixTimestamp,
      "s": parseUnixTimestampSeconds,
      "S": parseSeconds,
      "u": parseWeekdayNumberMonday,
      "U": parseWeekNumberSunday,
      "V": parseWeekNumberISO,
      "w": parseWeekdayNumberSunday,
      "W": parseWeekNumberMonday,
      "x": parseLocaleDate,
      "X": parseLocaleTime,
      "y": parseYear,
      "Y": parseFullYear,
      "Z": parseZone,
      "%": parseLiteralPercent
    };
    formats.x = newFormat(locale_date, formats);
    formats.X = newFormat(locale_time, formats);
    formats.c = newFormat(locale_dateTime, formats);
    utcFormats.x = newFormat(locale_date, utcFormats);
    utcFormats.X = newFormat(locale_time, utcFormats);
    utcFormats.c = newFormat(locale_dateTime, utcFormats);
    function newFormat(specifier, formats2) {
      return function(date2) {
        var string2 = [], i2 = -1, j = 0, n = specifier.length, c2, pad2, format2;
        if (!(date2 instanceof Date))
          date2 = /* @__PURE__ */ new Date(+date2);
        while (++i2 < n) {
          if (specifier.charCodeAt(i2) === 37) {
            string2.push(specifier.slice(j, i2));
            if ((pad2 = pads[c2 = specifier.charAt(++i2)]) != null)
              c2 = specifier.charAt(++i2);
            else
              pad2 = c2 === "e" ? " " : "0";
            if (format2 = formats2[c2])
              c2 = format2(date2, pad2);
            string2.push(c2);
            j = i2 + 1;
          }
        }
        string2.push(specifier.slice(j, i2));
        return string2.join("");
      };
    }
    function newParse(specifier, Z) {
      return function(string2) {
        var d = newDate(1900, void 0, 1), i2 = parseSpecifier(d, specifier, string2 += "", 0), week, day2;
        if (i2 != string2.length)
          return null;
        if ("Q" in d)
          return new Date(d.Q);
        if ("s" in d)
          return new Date(d.s * 1e3 + ("L" in d ? d.L : 0));
        if (Z && !("Z" in d))
          d.Z = 0;
        if ("p" in d)
          d.H = d.H % 12 + d.p * 12;
        if (d.m === void 0)
          d.m = "q" in d ? d.q : 0;
        if ("V" in d) {
          if (d.V < 1 || d.V > 53)
            return null;
          if (!("w" in d))
            d.w = 1;
          if ("Z" in d) {
            week = utcDate(newDate(d.y, 0, 1)), day2 = week.getUTCDay();
            week = day2 > 4 || day2 === 0 ? utcMonday.ceil(week) : utcMonday(week);
            week = utcDay$1.offset(week, (d.V - 1) * 7);
            d.y = week.getUTCFullYear();
            d.m = week.getUTCMonth();
            d.d = week.getUTCDate() + (d.w + 6) % 7;
          } else {
            week = localDate(newDate(d.y, 0, 1)), day2 = week.getDay();
            week = day2 > 4 || day2 === 0 ? monday.ceil(week) : monday(week);
            week = timeDay.offset(week, (d.V - 1) * 7);
            d.y = week.getFullYear();
            d.m = week.getMonth();
            d.d = week.getDate() + (d.w + 6) % 7;
          }
        } else if ("W" in d || "U" in d) {
          if (!("w" in d))
            d.w = "u" in d ? d.u % 7 : "W" in d ? 1 : 0;
          day2 = "Z" in d ? utcDate(newDate(d.y, 0, 1)).getUTCDay() : localDate(newDate(d.y, 0, 1)).getDay();
          d.m = 0;
          d.d = "W" in d ? (d.w + 6) % 7 + d.W * 7 - (day2 + 5) % 7 : d.w + d.U * 7 - (day2 + 6) % 7;
        }
        if ("Z" in d) {
          d.H += d.Z / 100 | 0;
          d.M += d.Z % 100;
          return utcDate(d);
        }
        return localDate(d);
      };
    }
    function parseSpecifier(d, specifier, string2, j) {
      var i2 = 0, n = specifier.length, m = string2.length, c2, parse2;
      while (i2 < n) {
        if (j >= m)
          return -1;
        c2 = specifier.charCodeAt(i2++);
        if (c2 === 37) {
          c2 = specifier.charAt(i2++);
          parse2 = parses[c2 in pads ? specifier.charAt(i2++) : c2];
          if (!parse2 || (j = parse2(d, string2, j)) < 0)
            return -1;
        } else if (c2 != string2.charCodeAt(j++)) {
          return -1;
        }
      }
      return j;
    }
    function parsePeriod(d, string2, i2) {
      var n = periodRe.exec(string2.slice(i2));
      return n ? (d.p = periodLookup.get(n[0].toLowerCase()), i2 + n[0].length) : -1;
    }
    function parseShortWeekday(d, string2, i2) {
      var n = shortWeekdayRe.exec(string2.slice(i2));
      return n ? (d.w = shortWeekdayLookup.get(n[0].toLowerCase()), i2 + n[0].length) : -1;
    }
    function parseWeekday(d, string2, i2) {
      var n = weekdayRe.exec(string2.slice(i2));
      return n ? (d.w = weekdayLookup.get(n[0].toLowerCase()), i2 + n[0].length) : -1;
    }
    function parseShortMonth(d, string2, i2) {
      var n = shortMonthRe.exec(string2.slice(i2));
      return n ? (d.m = shortMonthLookup.get(n[0].toLowerCase()), i2 + n[0].length) : -1;
    }
    function parseMonth(d, string2, i2) {
      var n = monthRe.exec(string2.slice(i2));
      return n ? (d.m = monthLookup.get(n[0].toLowerCase()), i2 + n[0].length) : -1;
    }
    function parseLocaleDateTime(d, string2, i2) {
      return parseSpecifier(d, locale_dateTime, string2, i2);
    }
    function parseLocaleDate(d, string2, i2) {
      return parseSpecifier(d, locale_date, string2, i2);
    }
    function parseLocaleTime(d, string2, i2) {
      return parseSpecifier(d, locale_time, string2, i2);
    }
    function formatShortWeekday(d) {
      return locale_shortWeekdays[d.getDay()];
    }
    function formatWeekday(d) {
      return locale_weekdays[d.getDay()];
    }
    function formatShortMonth(d) {
      return locale_shortMonths[d.getMonth()];
    }
    function formatMonth(d) {
      return locale_months[d.getMonth()];
    }
    function formatPeriod(d) {
      return locale_periods[+(d.getHours() >= 12)];
    }
    function formatQuarter(d) {
      return 1 + ~~(d.getMonth() / 3);
    }
    function formatUTCShortWeekday(d) {
      return locale_shortWeekdays[d.getUTCDay()];
    }
    function formatUTCWeekday(d) {
      return locale_weekdays[d.getUTCDay()];
    }
    function formatUTCShortMonth(d) {
      return locale_shortMonths[d.getUTCMonth()];
    }
    function formatUTCMonth(d) {
      return locale_months[d.getUTCMonth()];
    }
    function formatUTCPeriod(d) {
      return locale_periods[+(d.getUTCHours() >= 12)];
    }
    function formatUTCQuarter(d) {
      return 1 + ~~(d.getUTCMonth() / 3);
    }
    return {
      format: function(specifier) {
        var f2 = newFormat(specifier += "", formats);
        f2.toString = function() {
          return specifier;
        };
        return f2;
      },
      parse: function(specifier) {
        var p = newParse(specifier += "", false);
        p.toString = function() {
          return specifier;
        };
        return p;
      },
      utcFormat: function(specifier) {
        var f2 = newFormat(specifier += "", utcFormats);
        f2.toString = function() {
          return specifier;
        };
        return f2;
      },
      utcParse: function(specifier) {
        var p = newParse(specifier += "", true);
        p.toString = function() {
          return specifier;
        };
        return p;
      }
    };
  }
  var pads = { "-": "", "_": " ", "0": "0" }, numberRe = /^\s*\d+/, percentRe = /^%/, requoteRe = /[\\^$*+?|[\]().{}]/g;
  function pad(value, fill, width2) {
    var sign2 = value < 0 ? "-" : "", string2 = (sign2 ? -value : value) + "", length2 = string2.length;
    return sign2 + (length2 < width2 ? new Array(width2 - length2 + 1).join(fill) + string2 : string2);
  }
  function requote(s) {
    return s.replace(requoteRe, "\\$&");
  }
  function formatRe(names) {
    return new RegExp("^(?:" + names.map(requote).join("|") + ")", "i");
  }
  function formatLookup(names) {
    return new Map(names.map((name2, i2) => [name2.toLowerCase(), i2]));
  }
  function parseWeekdayNumberSunday(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 1));
    return n ? (d.w = +n[0], i2 + n[0].length) : -1;
  }
  function parseWeekdayNumberMonday(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 1));
    return n ? (d.u = +n[0], i2 + n[0].length) : -1;
  }
  function parseWeekNumberSunday(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 2));
    return n ? (d.U = +n[0], i2 + n[0].length) : -1;
  }
  function parseWeekNumberISO(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 2));
    return n ? (d.V = +n[0], i2 + n[0].length) : -1;
  }
  function parseWeekNumberMonday(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 2));
    return n ? (d.W = +n[0], i2 + n[0].length) : -1;
  }
  function parseFullYear(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 4));
    return n ? (d.y = +n[0], i2 + n[0].length) : -1;
  }
  function parseYear(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 2));
    return n ? (d.y = +n[0] + (+n[0] > 68 ? 1900 : 2e3), i2 + n[0].length) : -1;
  }
  function parseZone(d, string2, i2) {
    var n = /^(Z)|([+-]\d\d)(?::?(\d\d))?/.exec(string2.slice(i2, i2 + 6));
    return n ? (d.Z = n[1] ? 0 : -(n[2] + (n[3] || "00")), i2 + n[0].length) : -1;
  }
  function parseQuarter(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 1));
    return n ? (d.q = n[0] * 3 - 3, i2 + n[0].length) : -1;
  }
  function parseMonthNumber(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 2));
    return n ? (d.m = n[0] - 1, i2 + n[0].length) : -1;
  }
  function parseDayOfMonth(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 2));
    return n ? (d.d = +n[0], i2 + n[0].length) : -1;
  }
  function parseDayOfYear(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 3));
    return n ? (d.m = 0, d.d = +n[0], i2 + n[0].length) : -1;
  }
  function parseHour24(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 2));
    return n ? (d.H = +n[0], i2 + n[0].length) : -1;
  }
  function parseMinutes(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 2));
    return n ? (d.M = +n[0], i2 + n[0].length) : -1;
  }
  function parseSeconds(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 2));
    return n ? (d.S = +n[0], i2 + n[0].length) : -1;
  }
  function parseMilliseconds(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 3));
    return n ? (d.L = +n[0], i2 + n[0].length) : -1;
  }
  function parseMicroseconds(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 6));
    return n ? (d.L = Math.floor(n[0] / 1e3), i2 + n[0].length) : -1;
  }
  function parseLiteralPercent(d, string2, i2) {
    var n = percentRe.exec(string2.slice(i2, i2 + 1));
    return n ? i2 + n[0].length : -1;
  }
  function parseUnixTimestamp(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2));
    return n ? (d.Q = +n[0], i2 + n[0].length) : -1;
  }
  function parseUnixTimestampSeconds(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2));
    return n ? (d.s = +n[0], i2 + n[0].length) : -1;
  }
  function formatDayOfMonth(d, p) {
    return pad(d.getDate(), p, 2);
  }
  function formatHour24(d, p) {
    return pad(d.getHours(), p, 2);
  }
  function formatHour12(d, p) {
    return pad(d.getHours() % 12 || 12, p, 2);
  }
  function formatDayOfYear(d, p) {
    return pad(1 + timeDay.count(timeYear(d), d), p, 3);
  }
  function formatMilliseconds(d, p) {
    return pad(d.getMilliseconds(), p, 3);
  }
  function formatMicroseconds(d, p) {
    return formatMilliseconds(d, p) + "000";
  }
  function formatMonthNumber(d, p) {
    return pad(d.getMonth() + 1, p, 2);
  }
  function formatMinutes(d, p) {
    return pad(d.getMinutes(), p, 2);
  }
  function formatSeconds(d, p) {
    return pad(d.getSeconds(), p, 2);
  }
  function formatWeekdayNumberMonday(d) {
    var day2 = d.getDay();
    return day2 === 0 ? 7 : day2;
  }
  function formatWeekNumberSunday(d, p) {
    return pad(sunday.count(timeYear(d) - 1, d), p, 2);
  }
  function dISO(d) {
    var day2 = d.getDay();
    return day2 >= 4 || day2 === 0 ? thursday(d) : thursday.ceil(d);
  }
  function formatWeekNumberISO(d, p) {
    d = dISO(d);
    return pad(thursday.count(timeYear(d), d) + (timeYear(d).getDay() === 4), p, 2);
  }
  function formatWeekdayNumberSunday(d) {
    return d.getDay();
  }
  function formatWeekNumberMonday(d, p) {
    return pad(monday.count(timeYear(d) - 1, d), p, 2);
  }
  function formatYear(d, p) {
    return pad(d.getFullYear() % 100, p, 2);
  }
  function formatYearISO(d, p) {
    d = dISO(d);
    return pad(d.getFullYear() % 100, p, 2);
  }
  function formatFullYear(d, p) {
    return pad(d.getFullYear() % 1e4, p, 4);
  }
  function formatFullYearISO(d, p) {
    var day2 = d.getDay();
    d = day2 >= 4 || day2 === 0 ? thursday(d) : thursday.ceil(d);
    return pad(d.getFullYear() % 1e4, p, 4);
  }
  function formatZone(d) {
    var z = d.getTimezoneOffset();
    return (z > 0 ? "-" : (z *= -1, "+")) + pad(z / 60 | 0, "0", 2) + pad(z % 60, "0", 2);
  }
  function formatUTCDayOfMonth(d, p) {
    return pad(d.getUTCDate(), p, 2);
  }
  function formatUTCHour24(d, p) {
    return pad(d.getUTCHours(), p, 2);
  }
  function formatUTCHour12(d, p) {
    return pad(d.getUTCHours() % 12 || 12, p, 2);
  }
  function formatUTCDayOfYear(d, p) {
    return pad(1 + utcDay$1.count(utcYear$1(d), d), p, 3);
  }
  function formatUTCMilliseconds(d, p) {
    return pad(d.getUTCMilliseconds(), p, 3);
  }
  function formatUTCMicroseconds(d, p) {
    return formatUTCMilliseconds(d, p) + "000";
  }
  function formatUTCMonthNumber(d, p) {
    return pad(d.getUTCMonth() + 1, p, 2);
  }
  function formatUTCMinutes(d, p) {
    return pad(d.getUTCMinutes(), p, 2);
  }
  function formatUTCSeconds(d, p) {
    return pad(d.getUTCSeconds(), p, 2);
  }
  function formatUTCWeekdayNumberMonday(d) {
    var dow = d.getUTCDay();
    return dow === 0 ? 7 : dow;
  }
  function formatUTCWeekNumberSunday(d, p) {
    return pad(utcSunday.count(utcYear$1(d) - 1, d), p, 2);
  }
  function UTCdISO(d) {
    var day2 = d.getUTCDay();
    return day2 >= 4 || day2 === 0 ? utcThursday(d) : utcThursday.ceil(d);
  }
  function formatUTCWeekNumberISO(d, p) {
    d = UTCdISO(d);
    return pad(utcThursday.count(utcYear$1(d), d) + (utcYear$1(d).getUTCDay() === 4), p, 2);
  }
  function formatUTCWeekdayNumberSunday(d) {
    return d.getUTCDay();
  }
  function formatUTCWeekNumberMonday(d, p) {
    return pad(utcMonday.count(utcYear$1(d) - 1, d), p, 2);
  }
  function formatUTCYear(d, p) {
    return pad(d.getUTCFullYear() % 100, p, 2);
  }
  function formatUTCYearISO(d, p) {
    d = UTCdISO(d);
    return pad(d.getUTCFullYear() % 100, p, 2);
  }
  function formatUTCFullYear(d, p) {
    return pad(d.getUTCFullYear() % 1e4, p, 4);
  }
  function formatUTCFullYearISO(d, p) {
    var day2 = d.getUTCDay();
    d = day2 >= 4 || day2 === 0 ? utcThursday(d) : utcThursday.ceil(d);
    return pad(d.getUTCFullYear() % 1e4, p, 4);
  }
  function formatUTCZone() {
    return "+0000";
  }
  function formatLiteralPercent() {
    return "%";
  }
  function formatUnixTimestamp(d) {
    return +d;
  }
  function formatUnixTimestampSeconds(d) {
    return Math.floor(+d / 1e3);
  }
  var locale;
  var timeFormat;
  defaultLocale({
    dateTime: "%x, %X",
    date: "%-m/%-d/%Y",
    time: "%-I:%M:%S %p",
    periods: ["AM", "PM"],
    days: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
    shortDays: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
    months: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
    shortMonths: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
  });
  function defaultLocale(definition2) {
    locale = formatLocale(definition2);
    timeFormat = locale.format;
    locale.parse;
    locale.utcFormat;
    locale.utcParse;
    return locale;
  }
  function date(t) {
    return new Date(t);
  }
  function number(t) {
    return t instanceof Date ? +t : +/* @__PURE__ */ new Date(+t);
  }
  function calendar(ticks2, tickInterval2, year2, month2, week, day2, hour2, minute2, second2, format2) {
    var scale = continuous(), invert2 = scale.invert, domain = scale.domain;
    var formatMillisecond = format2(".%L"), formatSecond = format2(":%S"), formatMinute = format2("%I:%M"), formatHour = format2("%I %p"), formatDay = format2("%a %d"), formatWeek = format2("%b %d"), formatMonth = format2("%B"), formatYear2 = format2("%Y");
    function tickFormat2(date2) {
      return (second2(date2) < date2 ? formatMillisecond : minute2(date2) < date2 ? formatSecond : hour2(date2) < date2 ? formatMinute : day2(date2) < date2 ? formatHour : month2(date2) < date2 ? week(date2) < date2 ? formatDay : formatWeek : year2(date2) < date2 ? formatMonth : formatYear2)(date2);
    }
    scale.invert = function(y2) {
      return new Date(invert2(y2));
    };
    scale.domain = function(_2) {
      return arguments.length ? domain(Array.from(_2, number)) : domain().map(date);
    };
    scale.ticks = function(interval2) {
      var d = domain();
      return ticks2(d[0], d[d.length - 1], interval2 == null ? 10 : interval2);
    };
    scale.tickFormat = function(count, specifier) {
      return specifier == null ? tickFormat2 : format2(specifier);
    };
    scale.nice = function(interval2) {
      var d = domain();
      if (!interval2 || typeof interval2.range !== "function")
        interval2 = tickInterval2(d[0], d[d.length - 1], interval2 == null ? 10 : interval2);
      return interval2 ? domain(nice(d, interval2)) : scale;
    };
    scale.copy = function() {
      return copy$1(scale, calendar(ticks2, tickInterval2, year2, month2, week, day2, hour2, minute2, second2, format2));
    };
    return scale;
  }
  function time$1() {
    return initRange.apply(calendar(timeTicks, timeTickInterval, timeYear, timeMonth, sunday, timeDay, timeHour, timeMinute, utcSecond, timeFormat).domain([new Date(2e3, 0, 1), new Date(2e3, 0, 2)]), arguments);
  }
  function constant$1(x2) {
    return function constant2() {
      return x2;
    };
  }
  const abs$1 = Math.abs;
  const atan2 = Math.atan2;
  const cos = Math.cos;
  const max$1 = Math.max;
  const min$1 = Math.min;
  const sin = Math.sin;
  const sqrt = Math.sqrt;
  const epsilon = 1e-12;
  const pi = Math.PI;
  const halfPi = pi / 2;
  const tau = 2 * pi;
  function acos(x2) {
    return x2 > 1 ? 0 : x2 < -1 ? pi : Math.acos(x2);
  }
  function asin(x2) {
    return x2 >= 1 ? halfPi : x2 <= -1 ? -halfPi : Math.asin(x2);
  }
  function arcInnerRadius(d) {
    return d.innerRadius;
  }
  function arcOuterRadius(d) {
    return d.outerRadius;
  }
  function arcStartAngle(d) {
    return d.startAngle;
  }
  function arcEndAngle(d) {
    return d.endAngle;
  }
  function arcPadAngle(d) {
    return d && d.padAngle;
  }
  function intersect$1(x0, y0, x1, y1, x2, y2, x3, y3) {
    var x10 = x1 - x0, y10 = y1 - y0, x32 = x3 - x2, y32 = y3 - y2, t = y32 * x10 - x32 * y10;
    if (t * t < epsilon)
      return;
    t = (x32 * (y0 - y2) - y32 * (x0 - x2)) / t;
    return [x0 + t * x10, y0 + t * y10];
  }
  function cornerTangents(x0, y0, x1, y1, r1, rc, cw) {
    var x01 = x0 - x1, y01 = y0 - y1, lo = (cw ? rc : -rc) / sqrt(x01 * x01 + y01 * y01), ox = lo * y01, oy = -lo * x01, x11 = x0 + ox, y11 = y0 + oy, x10 = x1 + ox, y10 = y1 + oy, x00 = (x11 + x10) / 2, y00 = (y11 + y10) / 2, dx = x10 - x11, dy = y10 - y11, d2 = dx * dx + dy * dy, r = r1 - rc, D = x11 * y10 - x10 * y11, d = (dy < 0 ? -1 : 1) * sqrt(max$1(0, r * r * d2 - D * D)), cx0 = (D * dy - dx * d) / d2, cy0 = (-D * dx - dy * d) / d2, cx1 = (D * dy + dx * d) / d2, cy1 = (-D * dx + dy * d) / d2, dx0 = cx0 - x00, dy0 = cy0 - y00, dx1 = cx1 - x00, dy1 = cy1 - y00;
    if (dx0 * dx0 + dy0 * dy0 > dx1 * dx1 + dy1 * dy1)
      cx0 = cx1, cy0 = cy1;
    return {
      cx: cx0,
      cy: cy0,
      x01: -ox,
      y01: -oy,
      x11: cx0 * (r1 / r - 1),
      y11: cy0 * (r1 / r - 1)
    };
  }
  function d3arc() {
    var innerRadius = arcInnerRadius, outerRadius = arcOuterRadius, cornerRadius = constant$1(0), padRadius = null, startAngle = arcStartAngle, endAngle = arcEndAngle, padAngle = arcPadAngle, context = null;
    function arc() {
      var buffer, r, r0 = +innerRadius.apply(this, arguments), r1 = +outerRadius.apply(this, arguments), a0 = startAngle.apply(this, arguments) - halfPi, a1 = endAngle.apply(this, arguments) - halfPi, da = abs$1(a1 - a0), cw = a1 > a0;
      if (!context)
        context = buffer = path();
      if (r1 < r0)
        r = r1, r1 = r0, r0 = r;
      if (!(r1 > epsilon))
        context.moveTo(0, 0);
      else if (da > tau - epsilon) {
        context.moveTo(r1 * cos(a0), r1 * sin(a0));
        context.arc(0, 0, r1, a0, a1, !cw);
        if (r0 > epsilon) {
          context.moveTo(r0 * cos(a1), r0 * sin(a1));
          context.arc(0, 0, r0, a1, a0, cw);
        }
      } else {
        var a01 = a0, a11 = a1, a00 = a0, a10 = a1, da0 = da, da1 = da, ap = padAngle.apply(this, arguments) / 2, rp = ap > epsilon && (padRadius ? +padRadius.apply(this, arguments) : sqrt(r0 * r0 + r1 * r1)), rc = min$1(abs$1(r1 - r0) / 2, +cornerRadius.apply(this, arguments)), rc0 = rc, rc1 = rc, t02, t12;
        if (rp > epsilon) {
          var p0 = asin(rp / r0 * sin(ap)), p1 = asin(rp / r1 * sin(ap));
          if ((da0 -= p0 * 2) > epsilon)
            p0 *= cw ? 1 : -1, a00 += p0, a10 -= p0;
          else
            da0 = 0, a00 = a10 = (a0 + a1) / 2;
          if ((da1 -= p1 * 2) > epsilon)
            p1 *= cw ? 1 : -1, a01 += p1, a11 -= p1;
          else
            da1 = 0, a01 = a11 = (a0 + a1) / 2;
        }
        var x01 = r1 * cos(a01), y01 = r1 * sin(a01), x10 = r0 * cos(a10), y10 = r0 * sin(a10);
        if (rc > epsilon) {
          var x11 = r1 * cos(a11), y11 = r1 * sin(a11), x00 = r0 * cos(a00), y00 = r0 * sin(a00), oc;
          if (da < pi && (oc = intersect$1(x01, y01, x00, y00, x11, y11, x10, y10))) {
            var ax = x01 - oc[0], ay = y01 - oc[1], bx = x11 - oc[0], by = y11 - oc[1], kc = 1 / sin(acos((ax * bx + ay * by) / (sqrt(ax * ax + ay * ay) * sqrt(bx * bx + by * by))) / 2), lc = sqrt(oc[0] * oc[0] + oc[1] * oc[1]);
            rc0 = min$1(rc, (r0 - lc) / (kc - 1));
            rc1 = min$1(rc, (r1 - lc) / (kc + 1));
          }
        }
        if (!(da1 > epsilon))
          context.moveTo(x01, y01);
        else if (rc1 > epsilon) {
          t02 = cornerTangents(x00, y00, x01, y01, r1, rc1, cw);
          t12 = cornerTangents(x11, y11, x10, y10, r1, rc1, cw);
          context.moveTo(t02.cx + t02.x01, t02.cy + t02.y01);
          if (rc1 < rc)
            context.arc(t02.cx, t02.cy, rc1, atan2(t02.y01, t02.x01), atan2(t12.y01, t12.x01), !cw);
          else {
            context.arc(t02.cx, t02.cy, rc1, atan2(t02.y01, t02.x01), atan2(t02.y11, t02.x11), !cw);
            context.arc(0, 0, r1, atan2(t02.cy + t02.y11, t02.cx + t02.x11), atan2(t12.cy + t12.y11, t12.cx + t12.x11), !cw);
            context.arc(t12.cx, t12.cy, rc1, atan2(t12.y11, t12.x11), atan2(t12.y01, t12.x01), !cw);
          }
        } else
          context.moveTo(x01, y01), context.arc(0, 0, r1, a01, a11, !cw);
        if (!(r0 > epsilon) || !(da0 > epsilon))
          context.lineTo(x10, y10);
        else if (rc0 > epsilon) {
          t02 = cornerTangents(x10, y10, x11, y11, r0, -rc0, cw);
          t12 = cornerTangents(x01, y01, x00, y00, r0, -rc0, cw);
          context.lineTo(t02.cx + t02.x01, t02.cy + t02.y01);
          if (rc0 < rc)
            context.arc(t02.cx, t02.cy, rc0, atan2(t02.y01, t02.x01), atan2(t12.y01, t12.x01), !cw);
          else {
            context.arc(t02.cx, t02.cy, rc0, atan2(t02.y01, t02.x01), atan2(t02.y11, t02.x11), !cw);
            context.arc(0, 0, r0, atan2(t02.cy + t02.y11, t02.cx + t02.x11), atan2(t12.cy + t12.y11, t12.cx + t12.x11), cw);
            context.arc(t12.cx, t12.cy, rc0, atan2(t12.y11, t12.x11), atan2(t12.y01, t12.x01), !cw);
          }
        } else
          context.arc(0, 0, r0, a10, a00, cw);
      }
      context.closePath();
      if (buffer)
        return context = null, buffer + "" || null;
    }
    arc.centroid = function() {
      var r = (+innerRadius.apply(this, arguments) + +outerRadius.apply(this, arguments)) / 2, a = (+startAngle.apply(this, arguments) + +endAngle.apply(this, arguments)) / 2 - pi / 2;
      return [cos(a) * r, sin(a) * r];
    };
    arc.innerRadius = function(_2) {
      return arguments.length ? (innerRadius = typeof _2 === "function" ? _2 : constant$1(+_2), arc) : innerRadius;
    };
    arc.outerRadius = function(_2) {
      return arguments.length ? (outerRadius = typeof _2 === "function" ? _2 : constant$1(+_2), arc) : outerRadius;
    };
    arc.cornerRadius = function(_2) {
      return arguments.length ? (cornerRadius = typeof _2 === "function" ? _2 : constant$1(+_2), arc) : cornerRadius;
    };
    arc.padRadius = function(_2) {
      return arguments.length ? (padRadius = _2 == null ? null : typeof _2 === "function" ? _2 : constant$1(+_2), arc) : padRadius;
    };
    arc.startAngle = function(_2) {
      return arguments.length ? (startAngle = typeof _2 === "function" ? _2 : constant$1(+_2), arc) : startAngle;
    };
    arc.endAngle = function(_2) {
      return arguments.length ? (endAngle = typeof _2 === "function" ? _2 : constant$1(+_2), arc) : endAngle;
    };
    arc.padAngle = function(_2) {
      return arguments.length ? (padAngle = typeof _2 === "function" ? _2 : constant$1(+_2), arc) : padAngle;
    };
    arc.context = function(_2) {
      return arguments.length ? (context = _2 == null ? null : _2, arc) : context;
    };
    return arc;
  }
  function array(x2) {
    return typeof x2 === "object" && "length" in x2 ? x2 : Array.from(x2);
  }
  function Linear(context) {
    this._context = context;
  }
  Linear.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._point = 0;
    },
    lineEnd: function() {
      if (this._line || this._line !== 0 && this._point === 1)
        this._context.closePath();
      this._line = 1 - this._line;
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      switch (this._point) {
        case 0:
          this._point = 1;
          this._line ? this._context.lineTo(x2, y2) : this._context.moveTo(x2, y2);
          break;
        case 1:
          this._point = 2;
        default:
          this._context.lineTo(x2, y2);
          break;
      }
    }
  };
  function curveLinear(context) {
    return new Linear(context);
  }
  function x(p) {
    return p[0];
  }
  function y(p) {
    return p[1];
  }
  function line$1(x$1, y$1) {
    var defined = constant$1(true), context = null, curve = curveLinear, output = null;
    x$1 = typeof x$1 === "function" ? x$1 : x$1 === void 0 ? x : constant$1(x$1);
    y$1 = typeof y$1 === "function" ? y$1 : y$1 === void 0 ? y : constant$1(y$1);
    function line2(data) {
      var i2, n = (data = array(data)).length, d, defined0 = false, buffer;
      if (context == null)
        output = curve(buffer = path());
      for (i2 = 0; i2 <= n; ++i2) {
        if (!(i2 < n && defined(d = data[i2], i2, data)) === defined0) {
          if (defined0 = !defined0)
            output.lineStart();
          else
            output.lineEnd();
        }
        if (defined0)
          output.point(+x$1(d, i2, data), +y$1(d, i2, data));
      }
      if (buffer)
        return output = null, buffer + "" || null;
    }
    line2.x = function(_2) {
      return arguments.length ? (x$1 = typeof _2 === "function" ? _2 : constant$1(+_2), line2) : x$1;
    };
    line2.y = function(_2) {
      return arguments.length ? (y$1 = typeof _2 === "function" ? _2 : constant$1(+_2), line2) : y$1;
    };
    line2.defined = function(_2) {
      return arguments.length ? (defined = typeof _2 === "function" ? _2 : constant$1(!!_2), line2) : defined;
    };
    line2.curve = function(_2) {
      return arguments.length ? (curve = _2, context != null && (output = curve(context)), line2) : curve;
    };
    line2.context = function(_2) {
      return arguments.length ? (_2 == null ? context = output = null : output = curve(context = _2), line2) : context;
    };
    return line2;
  }
  function descending(a, b) {
    return b < a ? -1 : b > a ? 1 : b >= a ? 0 : NaN;
  }
  function identity$1(d) {
    return d;
  }
  function d3pie() {
    var value = identity$1, sortValues = descending, sort2 = null, startAngle = constant$1(0), endAngle = constant$1(tau), padAngle = constant$1(0);
    function pie2(data) {
      var i2, n = (data = array(data)).length, j, k, sum = 0, index2 = new Array(n), arcs = new Array(n), a0 = +startAngle.apply(this, arguments), da = Math.min(tau, Math.max(-tau, endAngle.apply(this, arguments) - a0)), a1, p = Math.min(Math.abs(da) / n, padAngle.apply(this, arguments)), pa = p * (da < 0 ? -1 : 1), v;
      for (i2 = 0; i2 < n; ++i2) {
        if ((v = arcs[index2[i2] = i2] = +value(data[i2], i2, data)) > 0) {
          sum += v;
        }
      }
      if (sortValues != null)
        index2.sort(function(i3, j2) {
          return sortValues(arcs[i3], arcs[j2]);
        });
      else if (sort2 != null)
        index2.sort(function(i3, j2) {
          return sort2(data[i3], data[j2]);
        });
      for (i2 = 0, k = sum ? (da - n * pa) / sum : 0; i2 < n; ++i2, a0 = a1) {
        j = index2[i2], v = arcs[j], a1 = a0 + (v > 0 ? v * k : 0) + pa, arcs[j] = {
          data: data[j],
          index: i2,
          value: v,
          startAngle: a0,
          endAngle: a1,
          padAngle: p
        };
      }
      return arcs;
    }
    pie2.value = function(_2) {
      return arguments.length ? (value = typeof _2 === "function" ? _2 : constant$1(+_2), pie2) : value;
    };
    pie2.sortValues = function(_2) {
      return arguments.length ? (sortValues = _2, sort2 = null, pie2) : sortValues;
    };
    pie2.sort = function(_2) {
      return arguments.length ? (sort2 = _2, sortValues = null, pie2) : sort2;
    };
    pie2.startAngle = function(_2) {
      return arguments.length ? (startAngle = typeof _2 === "function" ? _2 : constant$1(+_2), pie2) : startAngle;
    };
    pie2.endAngle = function(_2) {
      return arguments.length ? (endAngle = typeof _2 === "function" ? _2 : constant$1(+_2), pie2) : endAngle;
    };
    pie2.padAngle = function(_2) {
      return arguments.length ? (padAngle = typeof _2 === "function" ? _2 : constant$1(+_2), pie2) : padAngle;
    };
    return pie2;
  }
  class Bump {
    constructor(context, x2) {
      this._context = context;
      this._x = x2;
    }
    areaStart() {
      this._line = 0;
    }
    areaEnd() {
      this._line = NaN;
    }
    lineStart() {
      this._point = 0;
    }
    lineEnd() {
      if (this._line || this._line !== 0 && this._point === 1)
        this._context.closePath();
      this._line = 1 - this._line;
    }
    point(x2, y2) {
      x2 = +x2, y2 = +y2;
      switch (this._point) {
        case 0: {
          this._point = 1;
          if (this._line)
            this._context.lineTo(x2, y2);
          else
            this._context.moveTo(x2, y2);
          break;
        }
        case 1:
          this._point = 2;
        default: {
          if (this._x)
            this._context.bezierCurveTo(this._x0 = (this._x0 + x2) / 2, this._y0, this._x0, y2, x2, y2);
          else
            this._context.bezierCurveTo(this._x0, this._y0 = (this._y0 + y2) / 2, x2, this._y0, x2, y2);
          break;
        }
      }
      this._x0 = x2, this._y0 = y2;
    }
  }
  function bumpX(context) {
    return new Bump(context, true);
  }
  function bumpY(context) {
    return new Bump(context, false);
  }
  function noop$1() {
  }
  function point$6(that, x2, y2) {
    that._context.bezierCurveTo(
      (2 * that._x0 + that._x1) / 3,
      (2 * that._y0 + that._y1) / 3,
      (that._x0 + 2 * that._x1) / 3,
      (that._y0 + 2 * that._y1) / 3,
      (that._x0 + 4 * that._x1 + x2) / 6,
      (that._y0 + 4 * that._y1 + y2) / 6
    );
  }
  function Basis(context) {
    this._context = context;
  }
  Basis.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._x0 = this._x1 = this._y0 = this._y1 = NaN;
      this._point = 0;
    },
    lineEnd: function() {
      switch (this._point) {
        case 3:
          point$6(this, this._x1, this._y1);
        case 2:
          this._context.lineTo(this._x1, this._y1);
          break;
      }
      if (this._line || this._line !== 0 && this._point === 1)
        this._context.closePath();
      this._line = 1 - this._line;
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      switch (this._point) {
        case 0:
          this._point = 1;
          this._line ? this._context.lineTo(x2, y2) : this._context.moveTo(x2, y2);
          break;
        case 1:
          this._point = 2;
          break;
        case 2:
          this._point = 3;
          this._context.lineTo((5 * this._x0 + this._x1) / 6, (5 * this._y0 + this._y1) / 6);
        default:
          point$6(this, x2, y2);
          break;
      }
      this._x0 = this._x1, this._x1 = x2;
      this._y0 = this._y1, this._y1 = y2;
    }
  };
  function curveBasis(context) {
    return new Basis(context);
  }
  function BasisClosed(context) {
    this._context = context;
  }
  BasisClosed.prototype = {
    areaStart: noop$1,
    areaEnd: noop$1,
    lineStart: function() {
      this._x0 = this._x1 = this._x2 = this._x3 = this._x4 = this._y0 = this._y1 = this._y2 = this._y3 = this._y4 = NaN;
      this._point = 0;
    },
    lineEnd: function() {
      switch (this._point) {
        case 1: {
          this._context.moveTo(this._x2, this._y2);
          this._context.closePath();
          break;
        }
        case 2: {
          this._context.moveTo((this._x2 + 2 * this._x3) / 3, (this._y2 + 2 * this._y3) / 3);
          this._context.lineTo((this._x3 + 2 * this._x2) / 3, (this._y3 + 2 * this._y2) / 3);
          this._context.closePath();
          break;
        }
        case 3: {
          this.point(this._x2, this._y2);
          this.point(this._x3, this._y3);
          this.point(this._x4, this._y4);
          break;
        }
      }
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      switch (this._point) {
        case 0:
          this._point = 1;
          this._x2 = x2, this._y2 = y2;
          break;
        case 1:
          this._point = 2;
          this._x3 = x2, this._y3 = y2;
          break;
        case 2:
          this._point = 3;
          this._x4 = x2, this._y4 = y2;
          this._context.moveTo((this._x0 + 4 * this._x1 + x2) / 6, (this._y0 + 4 * this._y1 + y2) / 6);
          break;
        default:
          point$6(this, x2, y2);
          break;
      }
      this._x0 = this._x1, this._x1 = x2;
      this._y0 = this._y1, this._y1 = y2;
    }
  };
  function curveBasisClosed(context) {
    return new BasisClosed(context);
  }
  function BasisOpen(context) {
    this._context = context;
  }
  BasisOpen.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._x0 = this._x1 = this._y0 = this._y1 = NaN;
      this._point = 0;
    },
    lineEnd: function() {
      if (this._line || this._line !== 0 && this._point === 3)
        this._context.closePath();
      this._line = 1 - this._line;
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      switch (this._point) {
        case 0:
          this._point = 1;
          break;
        case 1:
          this._point = 2;
          break;
        case 2:
          this._point = 3;
          var x0 = (this._x0 + 4 * this._x1 + x2) / 6, y0 = (this._y0 + 4 * this._y1 + y2) / 6;
          this._line ? this._context.lineTo(x0, y0) : this._context.moveTo(x0, y0);
          break;
        case 3:
          this._point = 4;
        default:
          point$6(this, x2, y2);
          break;
      }
      this._x0 = this._x1, this._x1 = x2;
      this._y0 = this._y1, this._y1 = y2;
    }
  };
  function curveBasisOpen(context) {
    return new BasisOpen(context);
  }
  function Bundle(context, beta) {
    this._basis = new Basis(context);
    this._beta = beta;
  }
  Bundle.prototype = {
    lineStart: function() {
      this._x = [];
      this._y = [];
      this._basis.lineStart();
    },
    lineEnd: function() {
      var x2 = this._x, y2 = this._y, j = x2.length - 1;
      if (j > 0) {
        var x0 = x2[0], y0 = y2[0], dx = x2[j] - x0, dy = y2[j] - y0, i2 = -1, t;
        while (++i2 <= j) {
          t = i2 / j;
          this._basis.point(
            this._beta * x2[i2] + (1 - this._beta) * (x0 + t * dx),
            this._beta * y2[i2] + (1 - this._beta) * (y0 + t * dy)
          );
        }
      }
      this._x = this._y = null;
      this._basis.lineEnd();
    },
    point: function(x2, y2) {
      this._x.push(+x2);
      this._y.push(+y2);
    }
  };
  const curveBundle = function custom(beta) {
    function bundle(context) {
      return beta === 1 ? new Basis(context) : new Bundle(context, beta);
    }
    bundle.beta = function(beta2) {
      return custom(+beta2);
    };
    return bundle;
  }(0.85);
  function point$5(that, x2, y2) {
    that._context.bezierCurveTo(
      that._x1 + that._k * (that._x2 - that._x0),
      that._y1 + that._k * (that._y2 - that._y0),
      that._x2 + that._k * (that._x1 - x2),
      that._y2 + that._k * (that._y1 - y2),
      that._x2,
      that._y2
    );
  }
  function Cardinal(context, tension) {
    this._context = context;
    this._k = (1 - tension) / 6;
  }
  Cardinal.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._x0 = this._x1 = this._x2 = this._y0 = this._y1 = this._y2 = NaN;
      this._point = 0;
    },
    lineEnd: function() {
      switch (this._point) {
        case 2:
          this._context.lineTo(this._x2, this._y2);
          break;
        case 3:
          point$5(this, this._x1, this._y1);
          break;
      }
      if (this._line || this._line !== 0 && this._point === 1)
        this._context.closePath();
      this._line = 1 - this._line;
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      switch (this._point) {
        case 0:
          this._point = 1;
          this._line ? this._context.lineTo(x2, y2) : this._context.moveTo(x2, y2);
          break;
        case 1:
          this._point = 2;
          this._x1 = x2, this._y1 = y2;
          break;
        case 2:
          this._point = 3;
        default:
          point$5(this, x2, y2);
          break;
      }
      this._x0 = this._x1, this._x1 = this._x2, this._x2 = x2;
      this._y0 = this._y1, this._y1 = this._y2, this._y2 = y2;
    }
  };
  const curveCardinal = function custom(tension) {
    function cardinal(context) {
      return new Cardinal(context, tension);
    }
    cardinal.tension = function(tension2) {
      return custom(+tension2);
    };
    return cardinal;
  }(0);
  function CardinalClosed(context, tension) {
    this._context = context;
    this._k = (1 - tension) / 6;
  }
  CardinalClosed.prototype = {
    areaStart: noop$1,
    areaEnd: noop$1,
    lineStart: function() {
      this._x0 = this._x1 = this._x2 = this._x3 = this._x4 = this._x5 = this._y0 = this._y1 = this._y2 = this._y3 = this._y4 = this._y5 = NaN;
      this._point = 0;
    },
    lineEnd: function() {
      switch (this._point) {
        case 1: {
          this._context.moveTo(this._x3, this._y3);
          this._context.closePath();
          break;
        }
        case 2: {
          this._context.lineTo(this._x3, this._y3);
          this._context.closePath();
          break;
        }
        case 3: {
          this.point(this._x3, this._y3);
          this.point(this._x4, this._y4);
          this.point(this._x5, this._y5);
          break;
        }
      }
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      switch (this._point) {
        case 0:
          this._point = 1;
          this._x3 = x2, this._y3 = y2;
          break;
        case 1:
          this._point = 2;
          this._context.moveTo(this._x4 = x2, this._y4 = y2);
          break;
        case 2:
          this._point = 3;
          this._x5 = x2, this._y5 = y2;
          break;
        default:
          point$5(this, x2, y2);
          break;
      }
      this._x0 = this._x1, this._x1 = this._x2, this._x2 = x2;
      this._y0 = this._y1, this._y1 = this._y2, this._y2 = y2;
    }
  };
  const curveCardinalClosed = function custom(tension) {
    function cardinal(context) {
      return new CardinalClosed(context, tension);
    }
    cardinal.tension = function(tension2) {
      return custom(+tension2);
    };
    return cardinal;
  }(0);
  function CardinalOpen(context, tension) {
    this._context = context;
    this._k = (1 - tension) / 6;
  }
  CardinalOpen.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._x0 = this._x1 = this._x2 = this._y0 = this._y1 = this._y2 = NaN;
      this._point = 0;
    },
    lineEnd: function() {
      if (this._line || this._line !== 0 && this._point === 3)
        this._context.closePath();
      this._line = 1 - this._line;
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      switch (this._point) {
        case 0:
          this._point = 1;
          break;
        case 1:
          this._point = 2;
          break;
        case 2:
          this._point = 3;
          this._line ? this._context.lineTo(this._x2, this._y2) : this._context.moveTo(this._x2, this._y2);
          break;
        case 3:
          this._point = 4;
        default:
          point$5(this, x2, y2);
          break;
      }
      this._x0 = this._x1, this._x1 = this._x2, this._x2 = x2;
      this._y0 = this._y1, this._y1 = this._y2, this._y2 = y2;
    }
  };
  const curveCardinalOpen = function custom(tension) {
    function cardinal(context) {
      return new CardinalOpen(context, tension);
    }
    cardinal.tension = function(tension2) {
      return custom(+tension2);
    };
    return cardinal;
  }(0);
  function point$4(that, x2, y2) {
    var x1 = that._x1, y1 = that._y1, x22 = that._x2, y22 = that._y2;
    if (that._l01_a > epsilon) {
      var a = 2 * that._l01_2a + 3 * that._l01_a * that._l12_a + that._l12_2a, n = 3 * that._l01_a * (that._l01_a + that._l12_a);
      x1 = (x1 * a - that._x0 * that._l12_2a + that._x2 * that._l01_2a) / n;
      y1 = (y1 * a - that._y0 * that._l12_2a + that._y2 * that._l01_2a) / n;
    }
    if (that._l23_a > epsilon) {
      var b = 2 * that._l23_2a + 3 * that._l23_a * that._l12_a + that._l12_2a, m = 3 * that._l23_a * (that._l23_a + that._l12_a);
      x22 = (x22 * b + that._x1 * that._l23_2a - x2 * that._l12_2a) / m;
      y22 = (y22 * b + that._y1 * that._l23_2a - y2 * that._l12_2a) / m;
    }
    that._context.bezierCurveTo(x1, y1, x22, y22, that._x2, that._y2);
  }
  function CatmullRom(context, alpha) {
    this._context = context;
    this._alpha = alpha;
  }
  CatmullRom.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._x0 = this._x1 = this._x2 = this._y0 = this._y1 = this._y2 = NaN;
      this._l01_a = this._l12_a = this._l23_a = this._l01_2a = this._l12_2a = this._l23_2a = this._point = 0;
    },
    lineEnd: function() {
      switch (this._point) {
        case 2:
          this._context.lineTo(this._x2, this._y2);
          break;
        case 3:
          this.point(this._x2, this._y2);
          break;
      }
      if (this._line || this._line !== 0 && this._point === 1)
        this._context.closePath();
      this._line = 1 - this._line;
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      if (this._point) {
        var x23 = this._x2 - x2, y23 = this._y2 - y2;
        this._l23_a = Math.sqrt(this._l23_2a = Math.pow(x23 * x23 + y23 * y23, this._alpha));
      }
      switch (this._point) {
        case 0:
          this._point = 1;
          this._line ? this._context.lineTo(x2, y2) : this._context.moveTo(x2, y2);
          break;
        case 1:
          this._point = 2;
          break;
        case 2:
          this._point = 3;
        default:
          point$4(this, x2, y2);
          break;
      }
      this._l01_a = this._l12_a, this._l12_a = this._l23_a;
      this._l01_2a = this._l12_2a, this._l12_2a = this._l23_2a;
      this._x0 = this._x1, this._x1 = this._x2, this._x2 = x2;
      this._y0 = this._y1, this._y1 = this._y2, this._y2 = y2;
    }
  };
  const curveCatmullRom = function custom(alpha) {
    function catmullRom(context) {
      return alpha ? new CatmullRom(context, alpha) : new Cardinal(context, 0);
    }
    catmullRom.alpha = function(alpha2) {
      return custom(+alpha2);
    };
    return catmullRom;
  }(0.5);
  function CatmullRomClosed(context, alpha) {
    this._context = context;
    this._alpha = alpha;
  }
  CatmullRomClosed.prototype = {
    areaStart: noop$1,
    areaEnd: noop$1,
    lineStart: function() {
      this._x0 = this._x1 = this._x2 = this._x3 = this._x4 = this._x5 = this._y0 = this._y1 = this._y2 = this._y3 = this._y4 = this._y5 = NaN;
      this._l01_a = this._l12_a = this._l23_a = this._l01_2a = this._l12_2a = this._l23_2a = this._point = 0;
    },
    lineEnd: function() {
      switch (this._point) {
        case 1: {
          this._context.moveTo(this._x3, this._y3);
          this._context.closePath();
          break;
        }
        case 2: {
          this._context.lineTo(this._x3, this._y3);
          this._context.closePath();
          break;
        }
        case 3: {
          this.point(this._x3, this._y3);
          this.point(this._x4, this._y4);
          this.point(this._x5, this._y5);
          break;
        }
      }
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      if (this._point) {
        var x23 = this._x2 - x2, y23 = this._y2 - y2;
        this._l23_a = Math.sqrt(this._l23_2a = Math.pow(x23 * x23 + y23 * y23, this._alpha));
      }
      switch (this._point) {
        case 0:
          this._point = 1;
          this._x3 = x2, this._y3 = y2;
          break;
        case 1:
          this._point = 2;
          this._context.moveTo(this._x4 = x2, this._y4 = y2);
          break;
        case 2:
          this._point = 3;
          this._x5 = x2, this._y5 = y2;
          break;
        default:
          point$4(this, x2, y2);
          break;
      }
      this._l01_a = this._l12_a, this._l12_a = this._l23_a;
      this._l01_2a = this._l12_2a, this._l12_2a = this._l23_2a;
      this._x0 = this._x1, this._x1 = this._x2, this._x2 = x2;
      this._y0 = this._y1, this._y1 = this._y2, this._y2 = y2;
    }
  };
  const curveCatmullRomClosed = function custom(alpha) {
    function catmullRom(context) {
      return alpha ? new CatmullRomClosed(context, alpha) : new CardinalClosed(context, 0);
    }
    catmullRom.alpha = function(alpha2) {
      return custom(+alpha2);
    };
    return catmullRom;
  }(0.5);
  function CatmullRomOpen(context, alpha) {
    this._context = context;
    this._alpha = alpha;
  }
  CatmullRomOpen.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._x0 = this._x1 = this._x2 = this._y0 = this._y1 = this._y2 = NaN;
      this._l01_a = this._l12_a = this._l23_a = this._l01_2a = this._l12_2a = this._l23_2a = this._point = 0;
    },
    lineEnd: function() {
      if (this._line || this._line !== 0 && this._point === 3)
        this._context.closePath();
      this._line = 1 - this._line;
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      if (this._point) {
        var x23 = this._x2 - x2, y23 = this._y2 - y2;
        this._l23_a = Math.sqrt(this._l23_2a = Math.pow(x23 * x23 + y23 * y23, this._alpha));
      }
      switch (this._point) {
        case 0:
          this._point = 1;
          break;
        case 1:
          this._point = 2;
          break;
        case 2:
          this._point = 3;
          this._line ? this._context.lineTo(this._x2, this._y2) : this._context.moveTo(this._x2, this._y2);
          break;
        case 3:
          this._point = 4;
        default:
          point$4(this, x2, y2);
          break;
      }
      this._l01_a = this._l12_a, this._l12_a = this._l23_a;
      this._l01_2a = this._l12_2a, this._l12_2a = this._l23_2a;
      this._x0 = this._x1, this._x1 = this._x2, this._x2 = x2;
      this._y0 = this._y1, this._y1 = this._y2, this._y2 = y2;
    }
  };
  const curveCatmullRomOpen = function custom(alpha) {
    function catmullRom(context) {
      return alpha ? new CatmullRomOpen(context, alpha) : new CardinalOpen(context, 0);
    }
    catmullRom.alpha = function(alpha2) {
      return custom(+alpha2);
    };
    return catmullRom;
  }(0.5);
  function LinearClosed(context) {
    this._context = context;
  }
  LinearClosed.prototype = {
    areaStart: noop$1,
    areaEnd: noop$1,
    lineStart: function() {
      this._point = 0;
    },
    lineEnd: function() {
      if (this._point)
        this._context.closePath();
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      if (this._point)
        this._context.lineTo(x2, y2);
      else
        this._point = 1, this._context.moveTo(x2, y2);
    }
  };
  function curveLinearClosed(context) {
    return new LinearClosed(context);
  }
  function sign(x2) {
    return x2 < 0 ? -1 : 1;
  }
  function slope3(that, x2, y2) {
    var h0 = that._x1 - that._x0, h1 = x2 - that._x1, s0 = (that._y1 - that._y0) / (h0 || h1 < 0 && -0), s1 = (y2 - that._y1) / (h1 || h0 < 0 && -0), p = (s0 * h1 + s1 * h0) / (h0 + h1);
    return (sign(s0) + sign(s1)) * Math.min(Math.abs(s0), Math.abs(s1), 0.5 * Math.abs(p)) || 0;
  }
  function slope2(that, t) {
    var h = that._x1 - that._x0;
    return h ? (3 * (that._y1 - that._y0) / h - t) / 2 : t;
  }
  function point$3(that, t02, t12) {
    var x0 = that._x0, y0 = that._y0, x1 = that._x1, y1 = that._y1, dx = (x1 - x0) / 3;
    that._context.bezierCurveTo(x0 + dx, y0 + dx * t02, x1 - dx, y1 - dx * t12, x1, y1);
  }
  function MonotoneX(context) {
    this._context = context;
  }
  MonotoneX.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._x0 = this._x1 = this._y0 = this._y1 = this._t0 = NaN;
      this._point = 0;
    },
    lineEnd: function() {
      switch (this._point) {
        case 2:
          this._context.lineTo(this._x1, this._y1);
          break;
        case 3:
          point$3(this, this._t0, slope2(this, this._t0));
          break;
      }
      if (this._line || this._line !== 0 && this._point === 1)
        this._context.closePath();
      this._line = 1 - this._line;
    },
    point: function(x2, y2) {
      var t12 = NaN;
      x2 = +x2, y2 = +y2;
      if (x2 === this._x1 && y2 === this._y1)
        return;
      switch (this._point) {
        case 0:
          this._point = 1;
          this._line ? this._context.lineTo(x2, y2) : this._context.moveTo(x2, y2);
          break;
        case 1:
          this._point = 2;
          break;
        case 2:
          this._point = 3;
          point$3(this, slope2(this, t12 = slope3(this, x2, y2)), t12);
          break;
        default:
          point$3(this, this._t0, t12 = slope3(this, x2, y2));
          break;
      }
      this._x0 = this._x1, this._x1 = x2;
      this._y0 = this._y1, this._y1 = y2;
      this._t0 = t12;
    }
  };
  function MonotoneY(context) {
    this._context = new ReflectContext(context);
  }
  (MonotoneY.prototype = Object.create(MonotoneX.prototype)).point = function(x2, y2) {
    MonotoneX.prototype.point.call(this, y2, x2);
  };
  function ReflectContext(context) {
    this._context = context;
  }
  ReflectContext.prototype = {
    moveTo: function(x2, y2) {
      this._context.moveTo(y2, x2);
    },
    closePath: function() {
      this._context.closePath();
    },
    lineTo: function(x2, y2) {
      this._context.lineTo(y2, x2);
    },
    bezierCurveTo: function(x1, y1, x2, y2, x3, y3) {
      this._context.bezierCurveTo(y1, x1, y2, x2, y3, x3);
    }
  };
  function monotoneX(context) {
    return new MonotoneX(context);
  }
  function monotoneY(context) {
    return new MonotoneY(context);
  }
  function Natural(context) {
    this._context = context;
  }
  Natural.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._x = [];
      this._y = [];
    },
    lineEnd: function() {
      var x2 = this._x, y2 = this._y, n = x2.length;
      if (n) {
        this._line ? this._context.lineTo(x2[0], y2[0]) : this._context.moveTo(x2[0], y2[0]);
        if (n === 2) {
          this._context.lineTo(x2[1], y2[1]);
        } else {
          var px = controlPoints(x2), py = controlPoints(y2);
          for (var i0 = 0, i1 = 1; i1 < n; ++i0, ++i1) {
            this._context.bezierCurveTo(px[0][i0], py[0][i0], px[1][i0], py[1][i0], x2[i1], y2[i1]);
          }
        }
      }
      if (this._line || this._line !== 0 && n === 1)
        this._context.closePath();
      this._line = 1 - this._line;
      this._x = this._y = null;
    },
    point: function(x2, y2) {
      this._x.push(+x2);
      this._y.push(+y2);
    }
  };
  function controlPoints(x2) {
    var i2, n = x2.length - 1, m, a = new Array(n), b = new Array(n), r = new Array(n);
    a[0] = 0, b[0] = 2, r[0] = x2[0] + 2 * x2[1];
    for (i2 = 1; i2 < n - 1; ++i2)
      a[i2] = 1, b[i2] = 4, r[i2] = 4 * x2[i2] + 2 * x2[i2 + 1];
    a[n - 1] = 2, b[n - 1] = 7, r[n - 1] = 8 * x2[n - 1] + x2[n];
    for (i2 = 1; i2 < n; ++i2)
      m = a[i2] / b[i2 - 1], b[i2] -= m, r[i2] -= m * r[i2 - 1];
    a[n - 1] = r[n - 1] / b[n - 1];
    for (i2 = n - 2; i2 >= 0; --i2)
      a[i2] = (r[i2] - a[i2 + 1]) / b[i2];
    b[n - 1] = (x2[n] + a[n - 1]) / 2;
    for (i2 = 0; i2 < n - 1; ++i2)
      b[i2] = 2 * x2[i2 + 1] - a[i2 + 1];
    return [a, b];
  }
  function curveNatural(context) {
    return new Natural(context);
  }
  function Step(context, t) {
    this._context = context;
    this._t = t;
  }
  Step.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._x = this._y = NaN;
      this._point = 0;
    },
    lineEnd: function() {
      if (0 < this._t && this._t < 1 && this._point === 2)
        this._context.lineTo(this._x, this._y);
      if (this._line || this._line !== 0 && this._point === 1)
        this._context.closePath();
      if (this._line >= 0)
        this._t = 1 - this._t, this._line = 1 - this._line;
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      switch (this._point) {
        case 0:
          this._point = 1;
          this._line ? this._context.lineTo(x2, y2) : this._context.moveTo(x2, y2);
          break;
        case 1:
          this._point = 2;
        default: {
          if (this._t <= 0) {
            this._context.lineTo(this._x, y2);
            this._context.lineTo(x2, y2);
          } else {
            var x1 = this._x * (1 - this._t) + x2 * this._t;
            this._context.lineTo(x1, this._y);
            this._context.lineTo(x1, y2);
          }
          break;
        }
      }
      this._x = x2, this._y = y2;
    }
  };
  function curveStep(context) {
    return new Step(context, 0.5);
  }
  function stepBefore(context) {
    return new Step(context, 0);
  }
  function stepAfter(context) {
    return new Step(context, 1);
  }
  function Transform(k, x2, y2) {
    this.k = k;
    this.x = x2;
    this.y = y2;
  }
  Transform.prototype = {
    constructor: Transform,
    scale: function(k) {
      return k === 1 ? this : new Transform(this.k * k, this.x, this.y);
    },
    translate: function(x2, y2) {
      return x2 === 0 & y2 === 0 ? this : new Transform(this.k, this.x + this.k * x2, this.y + this.k * y2);
    },
    apply: function(point2) {
      return [point2[0] * this.k + this.x, point2[1] * this.k + this.y];
    },
    applyX: function(x2) {
      return x2 * this.k + this.x;
    },
    applyY: function(y2) {
      return y2 * this.k + this.y;
    },
    invert: function(location2) {
      return [(location2[0] - this.x) / this.k, (location2[1] - this.y) / this.k];
    },
    invertX: function(x2) {
      return (x2 - this.x) / this.k;
    },
    invertY: function(y2) {
      return (y2 - this.y) / this.k;
    },
    rescaleX: function(x2) {
      return x2.copy().domain(x2.range().map(this.invertX, this).map(x2.invert, x2));
    },
    rescaleY: function(y2) {
      return y2.copy().domain(y2.range().map(this.invertY, this).map(y2.invert, y2));
    },
    toString: function() {
      return "translate(" + this.x + "," + this.y + ") scale(" + this.k + ")";
    }
  };
  Transform.prototype;
  /*! @license DOMPurify 3.0.3 | (c) Cure53 and other contributors | Released under the Apache license 2.0 and Mozilla Public License 2.0 | github.com/cure53/DOMPurify/blob/3.0.3/LICENSE */
  const {
    entries,
    setPrototypeOf,
    isFrozen,
    getPrototypeOf,
    getOwnPropertyDescriptor
  } = Object;
  let {
    freeze,
    seal,
    create
  } = Object;
  let {
    apply: apply$2,
    construct
  } = typeof Reflect !== "undefined" && Reflect;
  if (!apply$2) {
    apply$2 = function apply2(fun, thisValue, args) {
      return fun.apply(thisValue, args);
    };
  }
  if (!freeze) {
    freeze = function freeze2(x2) {
      return x2;
    };
  }
  if (!seal) {
    seal = function seal2(x2) {
      return x2;
    };
  }
  if (!construct) {
    construct = function construct2(Func, args) {
      return new Func(...args);
    };
  }
  const arrayForEach = unapply(Array.prototype.forEach);
  const arrayPop = unapply(Array.prototype.pop);
  const arrayPush$1 = unapply(Array.prototype.push);
  const stringToLowerCase = unapply(String.prototype.toLowerCase);
  const stringToString = unapply(String.prototype.toString);
  const stringMatch = unapply(String.prototype.match);
  const stringReplace = unapply(String.prototype.replace);
  const stringIndexOf = unapply(String.prototype.indexOf);
  const stringTrim = unapply(String.prototype.trim);
  const regExpTest = unapply(RegExp.prototype.test);
  const typeErrorCreate = unconstruct(TypeError);
  function unapply(func) {
    return function(thisArg) {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }
      return apply$2(func, thisArg, args);
    };
  }
  function unconstruct(func) {
    return function() {
      for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }
      return construct(func, args);
    };
  }
  function addToSet(set2, array2, transformCaseFunc) {
    var _transformCaseFunc;
    transformCaseFunc = (_transformCaseFunc = transformCaseFunc) !== null && _transformCaseFunc !== void 0 ? _transformCaseFunc : stringToLowerCase;
    if (setPrototypeOf) {
      setPrototypeOf(set2, null);
    }
    let l = array2.length;
    while (l--) {
      let element2 = array2[l];
      if (typeof element2 === "string") {
        const lcElement = transformCaseFunc(element2);
        if (lcElement !== element2) {
          if (!isFrozen(array2)) {
            array2[l] = lcElement;
          }
          element2 = lcElement;
        }
      }
      set2[element2] = true;
    }
    return set2;
  }
  function clone$2(object2) {
    const newObject = create(null);
    for (const [property2, value] of entries(object2)) {
      newObject[property2] = value;
    }
    return newObject;
  }
  function lookupGetter(object2, prop) {
    while (object2 !== null) {
      const desc = getOwnPropertyDescriptor(object2, prop);
      if (desc) {
        if (desc.get) {
          return unapply(desc.get);
        }
        if (typeof desc.value === "function") {
          return unapply(desc.value);
        }
      }
      object2 = getPrototypeOf(object2);
    }
    function fallbackValue(element2) {
      console.warn("fallback value for", element2);
      return null;
    }
    return fallbackValue;
  }
  const html$1 = freeze(["a", "abbr", "acronym", "address", "area", "article", "aside", "audio", "b", "bdi", "bdo", "big", "blink", "blockquote", "body", "br", "button", "canvas", "caption", "center", "cite", "code", "col", "colgroup", "content", "data", "datalist", "dd", "decorator", "del", "details", "dfn", "dialog", "dir", "div", "dl", "dt", "element", "em", "fieldset", "figcaption", "figure", "font", "footer", "form", "h1", "h2", "h3", "h4", "h5", "h6", "head", "header", "hgroup", "hr", "html", "i", "img", "input", "ins", "kbd", "label", "legend", "li", "main", "map", "mark", "marquee", "menu", "menuitem", "meter", "nav", "nobr", "ol", "optgroup", "option", "output", "p", "picture", "pre", "progress", "q", "rp", "rt", "ruby", "s", "samp", "section", "select", "shadow", "small", "source", "spacer", "span", "strike", "strong", "style", "sub", "summary", "sup", "table", "tbody", "td", "template", "textarea", "tfoot", "th", "thead", "time", "tr", "track", "tt", "u", "ul", "var", "video", "wbr"]);
  const svg$1 = freeze(["svg", "a", "altglyph", "altglyphdef", "altglyphitem", "animatecolor", "animatemotion", "animatetransform", "circle", "clippath", "defs", "desc", "ellipse", "filter", "font", "g", "glyph", "glyphref", "hkern", "image", "line", "lineargradient", "marker", "mask", "metadata", "mpath", "path", "pattern", "polygon", "polyline", "radialgradient", "rect", "stop", "style", "switch", "symbol", "text", "textpath", "title", "tref", "tspan", "view", "vkern"]);
  const svgFilters = freeze(["feBlend", "feColorMatrix", "feComponentTransfer", "feComposite", "feConvolveMatrix", "feDiffuseLighting", "feDisplacementMap", "feDistantLight", "feDropShadow", "feFlood", "feFuncA", "feFuncB", "feFuncG", "feFuncR", "feGaussianBlur", "feImage", "feMerge", "feMergeNode", "feMorphology", "feOffset", "fePointLight", "feSpecularLighting", "feSpotLight", "feTile", "feTurbulence"]);
  const svgDisallowed = freeze(["animate", "color-profile", "cursor", "discard", "font-face", "font-face-format", "font-face-name", "font-face-src", "font-face-uri", "foreignobject", "hatch", "hatchpath", "mesh", "meshgradient", "meshpatch", "meshrow", "missing-glyph", "script", "set", "solidcolor", "unknown", "use"]);
  const mathMl$1 = freeze(["math", "menclose", "merror", "mfenced", "mfrac", "mglyph", "mi", "mlabeledtr", "mmultiscripts", "mn", "mo", "mover", "mpadded", "mphantom", "mroot", "mrow", "ms", "mspace", "msqrt", "mstyle", "msub", "msup", "msubsup", "mtable", "mtd", "mtext", "mtr", "munder", "munderover", "mprescripts"]);
  const mathMlDisallowed = freeze(["maction", "maligngroup", "malignmark", "mlongdiv", "mscarries", "mscarry", "msgroup", "mstack", "msline", "msrow", "semantics", "annotation", "annotation-xml", "mprescripts", "none"]);
  const text$2 = freeze(["#text"]);
  const html = freeze(["accept", "action", "align", "alt", "autocapitalize", "autocomplete", "autopictureinpicture", "autoplay", "background", "bgcolor", "border", "capture", "cellpadding", "cellspacing", "checked", "cite", "class", "clear", "color", "cols", "colspan", "controls", "controlslist", "coords", "crossorigin", "datetime", "decoding", "default", "dir", "disabled", "disablepictureinpicture", "disableremoteplayback", "download", "draggable", "enctype", "enterkeyhint", "face", "for", "headers", "height", "hidden", "high", "href", "hreflang", "id", "inputmode", "integrity", "ismap", "kind", "label", "lang", "list", "loading", "loop", "low", "max", "maxlength", "media", "method", "min", "minlength", "multiple", "muted", "name", "nonce", "noshade", "novalidate", "nowrap", "open", "optimum", "pattern", "placeholder", "playsinline", "poster", "preload", "pubdate", "radiogroup", "readonly", "rel", "required", "rev", "reversed", "role", "rows", "rowspan", "spellcheck", "scope", "selected", "shape", "size", "sizes", "span", "srclang", "start", "src", "srcset", "step", "style", "summary", "tabindex", "title", "translate", "type", "usemap", "valign", "value", "width", "xmlns", "slot"]);
  const svg = freeze(["accent-height", "accumulate", "additive", "alignment-baseline", "ascent", "attributename", "attributetype", "azimuth", "basefrequency", "baseline-shift", "begin", "bias", "by", "class", "clip", "clippathunits", "clip-path", "clip-rule", "color", "color-interpolation", "color-interpolation-filters", "color-profile", "color-rendering", "cx", "cy", "d", "dx", "dy", "diffuseconstant", "direction", "display", "divisor", "dur", "edgemode", "elevation", "end", "fill", "fill-opacity", "fill-rule", "filter", "filterunits", "flood-color", "flood-opacity", "font-family", "font-size", "font-size-adjust", "font-stretch", "font-style", "font-variant", "font-weight", "fx", "fy", "g1", "g2", "glyph-name", "glyphref", "gradientunits", "gradienttransform", "height", "href", "id", "image-rendering", "in", "in2", "k", "k1", "k2", "k3", "k4", "kerning", "keypoints", "keysplines", "keytimes", "lang", "lengthadjust", "letter-spacing", "kernelmatrix", "kernelunitlength", "lighting-color", "local", "marker-end", "marker-mid", "marker-start", "markerheight", "markerunits", "markerwidth", "maskcontentunits", "maskunits", "max", "mask", "media", "method", "mode", "min", "name", "numoctaves", "offset", "operator", "opacity", "order", "orient", "orientation", "origin", "overflow", "paint-order", "path", "pathlength", "patterncontentunits", "patterntransform", "patternunits", "points", "preservealpha", "preserveaspectratio", "primitiveunits", "r", "rx", "ry", "radius", "refx", "refy", "repeatcount", "repeatdur", "restart", "result", "rotate", "scale", "seed", "shape-rendering", "specularconstant", "specularexponent", "spreadmethod", "startoffset", "stddeviation", "stitchtiles", "stop-color", "stop-opacity", "stroke-dasharray", "stroke-dashoffset", "stroke-linecap", "stroke-linejoin", "stroke-miterlimit", "stroke-opacity", "stroke", "stroke-width", "style", "surfacescale", "systemlanguage", "tabindex", "targetx", "targety", "transform", "transform-origin", "text-anchor", "text-decoration", "text-rendering", "textlength", "type", "u1", "u2", "unicode", "values", "viewbox", "visibility", "version", "vert-adv-y", "vert-origin-x", "vert-origin-y", "width", "word-spacing", "wrap", "writing-mode", "xchannelselector", "ychannelselector", "x", "x1", "x2", "xmlns", "y", "y1", "y2", "z", "zoomandpan"]);
  const mathMl = freeze(["accent", "accentunder", "align", "bevelled", "close", "columnsalign", "columnlines", "columnspan", "denomalign", "depth", "dir", "display", "displaystyle", "encoding", "fence", "frame", "height", "href", "id", "largeop", "length", "linethickness", "lspace", "lquote", "mathbackground", "mathcolor", "mathsize", "mathvariant", "maxsize", "minsize", "movablelimits", "notation", "numalign", "open", "rowalign", "rowlines", "rowspacing", "rowspan", "rspace", "rquote", "scriptlevel", "scriptminsize", "scriptsizemultiplier", "selection", "separator", "separators", "stretchy", "subscriptshift", "supscriptshift", "symmetric", "voffset", "width", "xmlns"]);
  const xml = freeze(["xlink:href", "xml:id", "xlink:title", "xml:space", "xmlns:xlink"]);
  const MUSTACHE_EXPR = seal(/\{\{[\w\W]*|[\w\W]*\}\}/gm);
  const ERB_EXPR = seal(/<%[\w\W]*|[\w\W]*%>/gm);
  const TMPLIT_EXPR = seal(/\${[\w\W]*}/gm);
  const DATA_ATTR = seal(/^data-[\-\w.\u00B7-\uFFFF]/);
  const ARIA_ATTR = seal(/^aria-[\-\w]+$/);
  const IS_ALLOWED_URI = seal(
    /^(?:(?:(?:f|ht)tps?|mailto|tel|callto|sms|cid|xmpp):|[^a-z]|[a-z+.\-]+(?:[^a-z+.\-:]|$))/i
    // eslint-disable-line no-useless-escape
  );
  const IS_SCRIPT_OR_DATA = seal(/^(?:\w+script|data):/i);
  const ATTR_WHITESPACE = seal(
    /[\u0000-\u0020\u00A0\u1680\u180E\u2000-\u2029\u205F\u3000]/g
    // eslint-disable-line no-control-regex
  );
  const DOCTYPE_NAME = seal(/^html$/i);
  var EXPRESSIONS = /* @__PURE__ */ Object.freeze({
    __proto__: null,
    MUSTACHE_EXPR,
    ERB_EXPR,
    TMPLIT_EXPR,
    DATA_ATTR,
    ARIA_ATTR,
    IS_ALLOWED_URI,
    IS_SCRIPT_OR_DATA,
    ATTR_WHITESPACE,
    DOCTYPE_NAME
  });
  const getGlobal = () => typeof window === "undefined" ? null : window;
  const _createTrustedTypesPolicy = function _createTrustedTypesPolicy2(trustedTypes, purifyHostElement) {
    if (typeof trustedTypes !== "object" || typeof trustedTypes.createPolicy !== "function") {
      return null;
    }
    let suffix = null;
    const ATTR_NAME = "data-tt-policy-suffix";
    if (purifyHostElement && purifyHostElement.hasAttribute(ATTR_NAME)) {
      suffix = purifyHostElement.getAttribute(ATTR_NAME);
    }
    const policyName = "dompurify" + (suffix ? "#" + suffix : "");
    try {
      return trustedTypes.createPolicy(policyName, {
        createHTML(html2) {
          return html2;
        },
        createScriptURL(scriptUrl) {
          return scriptUrl;
        }
      });
    } catch (_2) {
      console.warn("TrustedTypes policy " + policyName + " could not be created.");
      return null;
    }
  };
  function createDOMPurify() {
    let window2 = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : getGlobal();
    const DOMPurify = (root2) => createDOMPurify(root2);
    DOMPurify.version = "3.0.3";
    DOMPurify.removed = [];
    if (!window2 || !window2.document || window2.document.nodeType !== 9) {
      DOMPurify.isSupported = false;
      return DOMPurify;
    }
    const originalDocument = window2.document;
    const currentScript = originalDocument.currentScript;
    let {
      document: document2
    } = window2;
    const {
      DocumentFragment,
      HTMLTemplateElement,
      Node,
      Element,
      NodeFilter,
      NamedNodeMap = window2.NamedNodeMap || window2.MozNamedAttrMap,
      HTMLFormElement,
      DOMParser: DOMParser2,
      trustedTypes
    } = window2;
    const ElementPrototype = Element.prototype;
    const cloneNode = lookupGetter(ElementPrototype, "cloneNode");
    const getNextSibling = lookupGetter(ElementPrototype, "nextSibling");
    const getChildNodes = lookupGetter(ElementPrototype, "childNodes");
    const getParentNode = lookupGetter(ElementPrototype, "parentNode");
    if (typeof HTMLTemplateElement === "function") {
      const template = document2.createElement("template");
      if (template.content && template.content.ownerDocument) {
        document2 = template.content.ownerDocument;
      }
    }
    let trustedTypesPolicy;
    let emptyHTML = "";
    const {
      implementation,
      createNodeIterator,
      createDocumentFragment,
      getElementsByTagName
    } = document2;
    const {
      importNode
    } = originalDocument;
    let hooks = {};
    DOMPurify.isSupported = typeof entries === "function" && typeof getParentNode === "function" && implementation && implementation.createHTMLDocument !== void 0;
    const {
      MUSTACHE_EXPR: MUSTACHE_EXPR2,
      ERB_EXPR: ERB_EXPR2,
      TMPLIT_EXPR: TMPLIT_EXPR2,
      DATA_ATTR: DATA_ATTR2,
      ARIA_ATTR: ARIA_ATTR2,
      IS_SCRIPT_OR_DATA: IS_SCRIPT_OR_DATA2,
      ATTR_WHITESPACE: ATTR_WHITESPACE2
    } = EXPRESSIONS;
    let {
      IS_ALLOWED_URI: IS_ALLOWED_URI$1
    } = EXPRESSIONS;
    let ALLOWED_TAGS = null;
    const DEFAULT_ALLOWED_TAGS = addToSet({}, [...html$1, ...svg$1, ...svgFilters, ...mathMl$1, ...text$2]);
    let ALLOWED_ATTR = null;
    const DEFAULT_ALLOWED_ATTR = addToSet({}, [...html, ...svg, ...mathMl, ...xml]);
    let CUSTOM_ELEMENT_HANDLING = Object.seal(Object.create(null, {
      tagNameCheck: {
        writable: true,
        configurable: false,
        enumerable: true,
        value: null
      },
      attributeNameCheck: {
        writable: true,
        configurable: false,
        enumerable: true,
        value: null
      },
      allowCustomizedBuiltInElements: {
        writable: true,
        configurable: false,
        enumerable: true,
        value: false
      }
    }));
    let FORBID_TAGS = null;
    let FORBID_ATTR = null;
    let ALLOW_ARIA_ATTR = true;
    let ALLOW_DATA_ATTR = true;
    let ALLOW_UNKNOWN_PROTOCOLS = false;
    let ALLOW_SELF_CLOSE_IN_ATTR = true;
    let SAFE_FOR_TEMPLATES = false;
    let WHOLE_DOCUMENT = false;
    let SET_CONFIG = false;
    let FORCE_BODY = false;
    let RETURN_DOM = false;
    let RETURN_DOM_FRAGMENT = false;
    let RETURN_TRUSTED_TYPE = false;
    let SANITIZE_DOM = true;
    let SANITIZE_NAMED_PROPS = false;
    const SANITIZE_NAMED_PROPS_PREFIX = "user-content-";
    let KEEP_CONTENT = true;
    let IN_PLACE = false;
    let USE_PROFILES = {};
    let FORBID_CONTENTS = null;
    const DEFAULT_FORBID_CONTENTS = addToSet({}, ["annotation-xml", "audio", "colgroup", "desc", "foreignobject", "head", "iframe", "math", "mi", "mn", "mo", "ms", "mtext", "noembed", "noframes", "noscript", "plaintext", "script", "style", "svg", "template", "thead", "title", "video", "xmp"]);
    let DATA_URI_TAGS = null;
    const DEFAULT_DATA_URI_TAGS = addToSet({}, ["audio", "video", "img", "source", "image", "track"]);
    let URI_SAFE_ATTRIBUTES = null;
    const DEFAULT_URI_SAFE_ATTRIBUTES = addToSet({}, ["alt", "class", "for", "id", "label", "name", "pattern", "placeholder", "role", "summary", "title", "value", "style", "xmlns"]);
    const MATHML_NAMESPACE = "http://www.w3.org/1998/Math/MathML";
    const SVG_NAMESPACE = "http://www.w3.org/2000/svg";
    const HTML_NAMESPACE = "http://www.w3.org/1999/xhtml";
    let NAMESPACE = HTML_NAMESPACE;
    let IS_EMPTY_INPUT = false;
    let ALLOWED_NAMESPACES = null;
    const DEFAULT_ALLOWED_NAMESPACES = addToSet({}, [MATHML_NAMESPACE, SVG_NAMESPACE, HTML_NAMESPACE], stringToString);
    let PARSER_MEDIA_TYPE;
    const SUPPORTED_PARSER_MEDIA_TYPES = ["application/xhtml+xml", "text/html"];
    const DEFAULT_PARSER_MEDIA_TYPE = "text/html";
    let transformCaseFunc;
    let CONFIG = null;
    const formElement = document2.createElement("form");
    const isRegexOrFunction = function isRegexOrFunction2(testValue) {
      return testValue instanceof RegExp || testValue instanceof Function;
    };
    const _parseConfig = function _parseConfig2(cfg) {
      if (CONFIG && CONFIG === cfg) {
        return;
      }
      if (!cfg || typeof cfg !== "object") {
        cfg = {};
      }
      cfg = clone$2(cfg);
      PARSER_MEDIA_TYPE = // eslint-disable-next-line unicorn/prefer-includes
      SUPPORTED_PARSER_MEDIA_TYPES.indexOf(cfg.PARSER_MEDIA_TYPE) === -1 ? PARSER_MEDIA_TYPE = DEFAULT_PARSER_MEDIA_TYPE : PARSER_MEDIA_TYPE = cfg.PARSER_MEDIA_TYPE;
      transformCaseFunc = PARSER_MEDIA_TYPE === "application/xhtml+xml" ? stringToString : stringToLowerCase;
      ALLOWED_TAGS = "ALLOWED_TAGS" in cfg ? addToSet({}, cfg.ALLOWED_TAGS, transformCaseFunc) : DEFAULT_ALLOWED_TAGS;
      ALLOWED_ATTR = "ALLOWED_ATTR" in cfg ? addToSet({}, cfg.ALLOWED_ATTR, transformCaseFunc) : DEFAULT_ALLOWED_ATTR;
      ALLOWED_NAMESPACES = "ALLOWED_NAMESPACES" in cfg ? addToSet({}, cfg.ALLOWED_NAMESPACES, stringToString) : DEFAULT_ALLOWED_NAMESPACES;
      URI_SAFE_ATTRIBUTES = "ADD_URI_SAFE_ATTR" in cfg ? addToSet(
        clone$2(DEFAULT_URI_SAFE_ATTRIBUTES),
        // eslint-disable-line indent
        cfg.ADD_URI_SAFE_ATTR,
        // eslint-disable-line indent
        transformCaseFunc
        // eslint-disable-line indent
      ) : DEFAULT_URI_SAFE_ATTRIBUTES;
      DATA_URI_TAGS = "ADD_DATA_URI_TAGS" in cfg ? addToSet(
        clone$2(DEFAULT_DATA_URI_TAGS),
        // eslint-disable-line indent
        cfg.ADD_DATA_URI_TAGS,
        // eslint-disable-line indent
        transformCaseFunc
        // eslint-disable-line indent
      ) : DEFAULT_DATA_URI_TAGS;
      FORBID_CONTENTS = "FORBID_CONTENTS" in cfg ? addToSet({}, cfg.FORBID_CONTENTS, transformCaseFunc) : DEFAULT_FORBID_CONTENTS;
      FORBID_TAGS = "FORBID_TAGS" in cfg ? addToSet({}, cfg.FORBID_TAGS, transformCaseFunc) : {};
      FORBID_ATTR = "FORBID_ATTR" in cfg ? addToSet({}, cfg.FORBID_ATTR, transformCaseFunc) : {};
      USE_PROFILES = "USE_PROFILES" in cfg ? cfg.USE_PROFILES : false;
      ALLOW_ARIA_ATTR = cfg.ALLOW_ARIA_ATTR !== false;
      ALLOW_DATA_ATTR = cfg.ALLOW_DATA_ATTR !== false;
      ALLOW_UNKNOWN_PROTOCOLS = cfg.ALLOW_UNKNOWN_PROTOCOLS || false;
      ALLOW_SELF_CLOSE_IN_ATTR = cfg.ALLOW_SELF_CLOSE_IN_ATTR !== false;
      SAFE_FOR_TEMPLATES = cfg.SAFE_FOR_TEMPLATES || false;
      WHOLE_DOCUMENT = cfg.WHOLE_DOCUMENT || false;
      RETURN_DOM = cfg.RETURN_DOM || false;
      RETURN_DOM_FRAGMENT = cfg.RETURN_DOM_FRAGMENT || false;
      RETURN_TRUSTED_TYPE = cfg.RETURN_TRUSTED_TYPE || false;
      FORCE_BODY = cfg.FORCE_BODY || false;
      SANITIZE_DOM = cfg.SANITIZE_DOM !== false;
      SANITIZE_NAMED_PROPS = cfg.SANITIZE_NAMED_PROPS || false;
      KEEP_CONTENT = cfg.KEEP_CONTENT !== false;
      IN_PLACE = cfg.IN_PLACE || false;
      IS_ALLOWED_URI$1 = cfg.ALLOWED_URI_REGEXP || IS_ALLOWED_URI;
      NAMESPACE = cfg.NAMESPACE || HTML_NAMESPACE;
      CUSTOM_ELEMENT_HANDLING = cfg.CUSTOM_ELEMENT_HANDLING || {};
      if (cfg.CUSTOM_ELEMENT_HANDLING && isRegexOrFunction(cfg.CUSTOM_ELEMENT_HANDLING.tagNameCheck)) {
        CUSTOM_ELEMENT_HANDLING.tagNameCheck = cfg.CUSTOM_ELEMENT_HANDLING.tagNameCheck;
      }
      if (cfg.CUSTOM_ELEMENT_HANDLING && isRegexOrFunction(cfg.CUSTOM_ELEMENT_HANDLING.attributeNameCheck)) {
        CUSTOM_ELEMENT_HANDLING.attributeNameCheck = cfg.CUSTOM_ELEMENT_HANDLING.attributeNameCheck;
      }
      if (cfg.CUSTOM_ELEMENT_HANDLING && typeof cfg.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements === "boolean") {
        CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements = cfg.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements;
      }
      if (SAFE_FOR_TEMPLATES) {
        ALLOW_DATA_ATTR = false;
      }
      if (RETURN_DOM_FRAGMENT) {
        RETURN_DOM = true;
      }
      if (USE_PROFILES) {
        ALLOWED_TAGS = addToSet({}, [...text$2]);
        ALLOWED_ATTR = [];
        if (USE_PROFILES.html === true) {
          addToSet(ALLOWED_TAGS, html$1);
          addToSet(ALLOWED_ATTR, html);
        }
        if (USE_PROFILES.svg === true) {
          addToSet(ALLOWED_TAGS, svg$1);
          addToSet(ALLOWED_ATTR, svg);
          addToSet(ALLOWED_ATTR, xml);
        }
        if (USE_PROFILES.svgFilters === true) {
          addToSet(ALLOWED_TAGS, svgFilters);
          addToSet(ALLOWED_ATTR, svg);
          addToSet(ALLOWED_ATTR, xml);
        }
        if (USE_PROFILES.mathMl === true) {
          addToSet(ALLOWED_TAGS, mathMl$1);
          addToSet(ALLOWED_ATTR, mathMl);
          addToSet(ALLOWED_ATTR, xml);
        }
      }
      if (cfg.ADD_TAGS) {
        if (ALLOWED_TAGS === DEFAULT_ALLOWED_TAGS) {
          ALLOWED_TAGS = clone$2(ALLOWED_TAGS);
        }
        addToSet(ALLOWED_TAGS, cfg.ADD_TAGS, transformCaseFunc);
      }
      if (cfg.ADD_ATTR) {
        if (ALLOWED_ATTR === DEFAULT_ALLOWED_ATTR) {
          ALLOWED_ATTR = clone$2(ALLOWED_ATTR);
        }
        addToSet(ALLOWED_ATTR, cfg.ADD_ATTR, transformCaseFunc);
      }
      if (cfg.ADD_URI_SAFE_ATTR) {
        addToSet(URI_SAFE_ATTRIBUTES, cfg.ADD_URI_SAFE_ATTR, transformCaseFunc);
      }
      if (cfg.FORBID_CONTENTS) {
        if (FORBID_CONTENTS === DEFAULT_FORBID_CONTENTS) {
          FORBID_CONTENTS = clone$2(FORBID_CONTENTS);
        }
        addToSet(FORBID_CONTENTS, cfg.FORBID_CONTENTS, transformCaseFunc);
      }
      if (KEEP_CONTENT) {
        ALLOWED_TAGS["#text"] = true;
      }
      if (WHOLE_DOCUMENT) {
        addToSet(ALLOWED_TAGS, ["html", "head", "body"]);
      }
      if (ALLOWED_TAGS.table) {
        addToSet(ALLOWED_TAGS, ["tbody"]);
        delete FORBID_TAGS.tbody;
      }
      if (cfg.TRUSTED_TYPES_POLICY) {
        if (typeof cfg.TRUSTED_TYPES_POLICY.createHTML !== "function") {
          throw typeErrorCreate('TRUSTED_TYPES_POLICY configuration option must provide a "createHTML" hook.');
        }
        if (typeof cfg.TRUSTED_TYPES_POLICY.createScriptURL !== "function") {
          throw typeErrorCreate('TRUSTED_TYPES_POLICY configuration option must provide a "createScriptURL" hook.');
        }
        trustedTypesPolicy = cfg.TRUSTED_TYPES_POLICY;
        emptyHTML = trustedTypesPolicy.createHTML("");
      } else {
        if (trustedTypesPolicy === void 0) {
          trustedTypesPolicy = _createTrustedTypesPolicy(trustedTypes, currentScript);
        }
        if (trustedTypesPolicy !== null && typeof emptyHTML === "string") {
          emptyHTML = trustedTypesPolicy.createHTML("");
        }
      }
      if (freeze) {
        freeze(cfg);
      }
      CONFIG = cfg;
    };
    const MATHML_TEXT_INTEGRATION_POINTS = addToSet({}, ["mi", "mo", "mn", "ms", "mtext"]);
    const HTML_INTEGRATION_POINTS = addToSet({}, ["foreignobject", "desc", "title", "annotation-xml"]);
    const COMMON_SVG_AND_HTML_ELEMENTS = addToSet({}, ["title", "style", "font", "a", "script"]);
    const ALL_SVG_TAGS = addToSet({}, svg$1);
    addToSet(ALL_SVG_TAGS, svgFilters);
    addToSet(ALL_SVG_TAGS, svgDisallowed);
    const ALL_MATHML_TAGS = addToSet({}, mathMl$1);
    addToSet(ALL_MATHML_TAGS, mathMlDisallowed);
    const _checkValidNamespace = function _checkValidNamespace2(element2) {
      let parent = getParentNode(element2);
      if (!parent || !parent.tagName) {
        parent = {
          namespaceURI: NAMESPACE,
          tagName: "template"
        };
      }
      const tagName = stringToLowerCase(element2.tagName);
      const parentTagName = stringToLowerCase(parent.tagName);
      if (!ALLOWED_NAMESPACES[element2.namespaceURI]) {
        return false;
      }
      if (element2.namespaceURI === SVG_NAMESPACE) {
        if (parent.namespaceURI === HTML_NAMESPACE) {
          return tagName === "svg";
        }
        if (parent.namespaceURI === MATHML_NAMESPACE) {
          return tagName === "svg" && (parentTagName === "annotation-xml" || MATHML_TEXT_INTEGRATION_POINTS[parentTagName]);
        }
        return Boolean(ALL_SVG_TAGS[tagName]);
      }
      if (element2.namespaceURI === MATHML_NAMESPACE) {
        if (parent.namespaceURI === HTML_NAMESPACE) {
          return tagName === "math";
        }
        if (parent.namespaceURI === SVG_NAMESPACE) {
          return tagName === "math" && HTML_INTEGRATION_POINTS[parentTagName];
        }
        return Boolean(ALL_MATHML_TAGS[tagName]);
      }
      if (element2.namespaceURI === HTML_NAMESPACE) {
        if (parent.namespaceURI === SVG_NAMESPACE && !HTML_INTEGRATION_POINTS[parentTagName]) {
          return false;
        }
        if (parent.namespaceURI === MATHML_NAMESPACE && !MATHML_TEXT_INTEGRATION_POINTS[parentTagName]) {
          return false;
        }
        return !ALL_MATHML_TAGS[tagName] && (COMMON_SVG_AND_HTML_ELEMENTS[tagName] || !ALL_SVG_TAGS[tagName]);
      }
      if (PARSER_MEDIA_TYPE === "application/xhtml+xml" && ALLOWED_NAMESPACES[element2.namespaceURI]) {
        return true;
      }
      return false;
    };
    const _forceRemove = function _forceRemove2(node2) {
      arrayPush$1(DOMPurify.removed, {
        element: node2
      });
      try {
        node2.parentNode.removeChild(node2);
      } catch (_2) {
        node2.remove();
      }
    };
    const _removeAttribute = function _removeAttribute2(name2, node2) {
      try {
        arrayPush$1(DOMPurify.removed, {
          attribute: node2.getAttributeNode(name2),
          from: node2
        });
      } catch (_2) {
        arrayPush$1(DOMPurify.removed, {
          attribute: null,
          from: node2
        });
      }
      node2.removeAttribute(name2);
      if (name2 === "is" && !ALLOWED_ATTR[name2]) {
        if (RETURN_DOM || RETURN_DOM_FRAGMENT) {
          try {
            _forceRemove(node2);
          } catch (_2) {
          }
        } else {
          try {
            node2.setAttribute(name2, "");
          } catch (_2) {
          }
        }
      }
    };
    const _initDocument = function _initDocument2(dirty) {
      let doc;
      let leadingWhitespace;
      if (FORCE_BODY) {
        dirty = "<remove></remove>" + dirty;
      } else {
        const matches = stringMatch(dirty, /^[\r\n\t ]+/);
        leadingWhitespace = matches && matches[0];
      }
      if (PARSER_MEDIA_TYPE === "application/xhtml+xml" && NAMESPACE === HTML_NAMESPACE) {
        dirty = '<html xmlns="http://www.w3.org/1999/xhtml"><head></head><body>' + dirty + "</body></html>";
      }
      const dirtyPayload = trustedTypesPolicy ? trustedTypesPolicy.createHTML(dirty) : dirty;
      if (NAMESPACE === HTML_NAMESPACE) {
        try {
          doc = new DOMParser2().parseFromString(dirtyPayload, PARSER_MEDIA_TYPE);
        } catch (_2) {
        }
      }
      if (!doc || !doc.documentElement) {
        doc = implementation.createDocument(NAMESPACE, "template", null);
        try {
          doc.documentElement.innerHTML = IS_EMPTY_INPUT ? emptyHTML : dirtyPayload;
        } catch (_2) {
        }
      }
      const body = doc.body || doc.documentElement;
      if (dirty && leadingWhitespace) {
        body.insertBefore(document2.createTextNode(leadingWhitespace), body.childNodes[0] || null);
      }
      if (NAMESPACE === HTML_NAMESPACE) {
        return getElementsByTagName.call(doc, WHOLE_DOCUMENT ? "html" : "body")[0];
      }
      return WHOLE_DOCUMENT ? doc.documentElement : body;
    };
    const _createIterator = function _createIterator2(root2) {
      return createNodeIterator.call(
        root2.ownerDocument || root2,
        root2,
        // eslint-disable-next-line no-bitwise
        NodeFilter.SHOW_ELEMENT | NodeFilter.SHOW_COMMENT | NodeFilter.SHOW_TEXT,
        null,
        false
      );
    };
    const _isClobbered = function _isClobbered2(elm) {
      return elm instanceof HTMLFormElement && (typeof elm.nodeName !== "string" || typeof elm.textContent !== "string" || typeof elm.removeChild !== "function" || !(elm.attributes instanceof NamedNodeMap) || typeof elm.removeAttribute !== "function" || typeof elm.setAttribute !== "function" || typeof elm.namespaceURI !== "string" || typeof elm.insertBefore !== "function" || typeof elm.hasChildNodes !== "function");
    };
    const _isNode = function _isNode2(object2) {
      return typeof Node === "object" ? object2 instanceof Node : object2 && typeof object2 === "object" && typeof object2.nodeType === "number" && typeof object2.nodeName === "string";
    };
    const _executeHook = function _executeHook2(entryPoint, currentNode, data) {
      if (!hooks[entryPoint]) {
        return;
      }
      arrayForEach(hooks[entryPoint], (hook) => {
        hook.call(DOMPurify, currentNode, data, CONFIG);
      });
    };
    const _sanitizeElements = function _sanitizeElements2(currentNode) {
      let content2;
      _executeHook("beforeSanitizeElements", currentNode, null);
      if (_isClobbered(currentNode)) {
        _forceRemove(currentNode);
        return true;
      }
      const tagName = transformCaseFunc(currentNode.nodeName);
      _executeHook("uponSanitizeElement", currentNode, {
        tagName,
        allowedTags: ALLOWED_TAGS
      });
      if (currentNode.hasChildNodes() && !_isNode(currentNode.firstElementChild) && (!_isNode(currentNode.content) || !_isNode(currentNode.content.firstElementChild)) && regExpTest(/<[/\w]/g, currentNode.innerHTML) && regExpTest(/<[/\w]/g, currentNode.textContent)) {
        _forceRemove(currentNode);
        return true;
      }
      if (!ALLOWED_TAGS[tagName] || FORBID_TAGS[tagName]) {
        if (!FORBID_TAGS[tagName] && _basicCustomElementTest(tagName)) {
          if (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, tagName))
            return false;
          if (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(tagName))
            return false;
        }
        if (KEEP_CONTENT && !FORBID_CONTENTS[tagName]) {
          const parentNode = getParentNode(currentNode) || currentNode.parentNode;
          const childNodes = getChildNodes(currentNode) || currentNode.childNodes;
          if (childNodes && parentNode) {
            const childCount = childNodes.length;
            for (let i2 = childCount - 1; i2 >= 0; --i2) {
              parentNode.insertBefore(cloneNode(childNodes[i2], true), getNextSibling(currentNode));
            }
          }
        }
        _forceRemove(currentNode);
        return true;
      }
      if (currentNode instanceof Element && !_checkValidNamespace(currentNode)) {
        _forceRemove(currentNode);
        return true;
      }
      if ((tagName === "noscript" || tagName === "noembed") && regExpTest(/<\/no(script|embed)/i, currentNode.innerHTML)) {
        _forceRemove(currentNode);
        return true;
      }
      if (SAFE_FOR_TEMPLATES && currentNode.nodeType === 3) {
        content2 = currentNode.textContent;
        content2 = stringReplace(content2, MUSTACHE_EXPR2, " ");
        content2 = stringReplace(content2, ERB_EXPR2, " ");
        content2 = stringReplace(content2, TMPLIT_EXPR2, " ");
        if (currentNode.textContent !== content2) {
          arrayPush$1(DOMPurify.removed, {
            element: currentNode.cloneNode()
          });
          currentNode.textContent = content2;
        }
      }
      _executeHook("afterSanitizeElements", currentNode, null);
      return false;
    };
    const _isValidAttribute = function _isValidAttribute2(lcTag, lcName, value) {
      if (SANITIZE_DOM && (lcName === "id" || lcName === "name") && (value in document2 || value in formElement)) {
        return false;
      }
      if (ALLOW_DATA_ATTR && !FORBID_ATTR[lcName] && regExpTest(DATA_ATTR2, lcName))
        ;
      else if (ALLOW_ARIA_ATTR && regExpTest(ARIA_ATTR2, lcName))
        ;
      else if (!ALLOWED_ATTR[lcName] || FORBID_ATTR[lcName]) {
        if (
          // First condition does a very basic check if a) it's basically a valid custom element tagname AND
          // b) if the tagName passes whatever the user has configured for CUSTOM_ELEMENT_HANDLING.tagNameCheck
          // and c) if the attribute name passes whatever the user has configured for CUSTOM_ELEMENT_HANDLING.attributeNameCheck
          _basicCustomElementTest(lcTag) && (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, lcTag) || CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(lcTag)) && (CUSTOM_ELEMENT_HANDLING.attributeNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.attributeNameCheck, lcName) || CUSTOM_ELEMENT_HANDLING.attributeNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.attributeNameCheck(lcName)) || // Alternative, second condition checks if it's an `is`-attribute, AND
          // the value passes whatever the user has configured for CUSTOM_ELEMENT_HANDLING.tagNameCheck
          lcName === "is" && CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements && (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, value) || CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(value))
        )
          ;
        else {
          return false;
        }
      } else if (URI_SAFE_ATTRIBUTES[lcName])
        ;
      else if (regExpTest(IS_ALLOWED_URI$1, stringReplace(value, ATTR_WHITESPACE2, "")))
        ;
      else if ((lcName === "src" || lcName === "xlink:href" || lcName === "href") && lcTag !== "script" && stringIndexOf(value, "data:") === 0 && DATA_URI_TAGS[lcTag])
        ;
      else if (ALLOW_UNKNOWN_PROTOCOLS && !regExpTest(IS_SCRIPT_OR_DATA2, stringReplace(value, ATTR_WHITESPACE2, "")))
        ;
      else if (value) {
        return false;
      } else
        ;
      return true;
    };
    const _basicCustomElementTest = function _basicCustomElementTest2(tagName) {
      return tagName.indexOf("-") > 0;
    };
    const _sanitizeAttributes = function _sanitizeAttributes2(currentNode) {
      let attr;
      let value;
      let lcName;
      let l;
      _executeHook("beforeSanitizeAttributes", currentNode, null);
      const {
        attributes
      } = currentNode;
      if (!attributes) {
        return;
      }
      const hookEvent = {
        attrName: "",
        attrValue: "",
        keepAttr: true,
        allowedAttributes: ALLOWED_ATTR
      };
      l = attributes.length;
      while (l--) {
        attr = attributes[l];
        const {
          name: name2,
          namespaceURI
        } = attr;
        value = name2 === "value" ? attr.value : stringTrim(attr.value);
        lcName = transformCaseFunc(name2);
        hookEvent.attrName = lcName;
        hookEvent.attrValue = value;
        hookEvent.keepAttr = true;
        hookEvent.forceKeepAttr = void 0;
        _executeHook("uponSanitizeAttribute", currentNode, hookEvent);
        value = hookEvent.attrValue;
        if (hookEvent.forceKeepAttr) {
          continue;
        }
        _removeAttribute(name2, currentNode);
        if (!hookEvent.keepAttr) {
          continue;
        }
        if (!ALLOW_SELF_CLOSE_IN_ATTR && regExpTest(/\/>/i, value)) {
          _removeAttribute(name2, currentNode);
          continue;
        }
        if (SAFE_FOR_TEMPLATES) {
          value = stringReplace(value, MUSTACHE_EXPR2, " ");
          value = stringReplace(value, ERB_EXPR2, " ");
          value = stringReplace(value, TMPLIT_EXPR2, " ");
        }
        const lcTag = transformCaseFunc(currentNode.nodeName);
        if (!_isValidAttribute(lcTag, lcName, value)) {
          continue;
        }
        if (SANITIZE_NAMED_PROPS && (lcName === "id" || lcName === "name")) {
          _removeAttribute(name2, currentNode);
          value = SANITIZE_NAMED_PROPS_PREFIX + value;
        }
        if (trustedTypesPolicy && typeof trustedTypes === "object" && typeof trustedTypes.getAttributeType === "function") {
          if (namespaceURI)
            ;
          else {
            switch (trustedTypes.getAttributeType(lcTag, lcName)) {
              case "TrustedHTML": {
                value = trustedTypesPolicy.createHTML(value);
                break;
              }
              case "TrustedScriptURL": {
                value = trustedTypesPolicy.createScriptURL(value);
                break;
              }
            }
          }
        }
        try {
          if (namespaceURI) {
            currentNode.setAttributeNS(namespaceURI, name2, value);
          } else {
            currentNode.setAttribute(name2, value);
          }
          arrayPop(DOMPurify.removed);
        } catch (_2) {
        }
      }
      _executeHook("afterSanitizeAttributes", currentNode, null);
    };
    const _sanitizeShadowDOM = function _sanitizeShadowDOM2(fragment) {
      let shadowNode;
      const shadowIterator = _createIterator(fragment);
      _executeHook("beforeSanitizeShadowDOM", fragment, null);
      while (shadowNode = shadowIterator.nextNode()) {
        _executeHook("uponSanitizeShadowNode", shadowNode, null);
        if (_sanitizeElements(shadowNode)) {
          continue;
        }
        if (shadowNode.content instanceof DocumentFragment) {
          _sanitizeShadowDOM2(shadowNode.content);
        }
        _sanitizeAttributes(shadowNode);
      }
      _executeHook("afterSanitizeShadowDOM", fragment, null);
    };
    DOMPurify.sanitize = function(dirty) {
      let cfg = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
      let body;
      let importedNode;
      let currentNode;
      let returnNode;
      IS_EMPTY_INPUT = !dirty;
      if (IS_EMPTY_INPUT) {
        dirty = "<!-->";
      }
      if (typeof dirty !== "string" && !_isNode(dirty)) {
        if (typeof dirty.toString === "function") {
          dirty = dirty.toString();
          if (typeof dirty !== "string") {
            throw typeErrorCreate("dirty is not a string, aborting");
          }
        } else {
          throw typeErrorCreate("toString is not a function");
        }
      }
      if (!DOMPurify.isSupported) {
        return dirty;
      }
      if (!SET_CONFIG) {
        _parseConfig(cfg);
      }
      DOMPurify.removed = [];
      if (typeof dirty === "string") {
        IN_PLACE = false;
      }
      if (IN_PLACE) {
        if (dirty.nodeName) {
          const tagName = transformCaseFunc(dirty.nodeName);
          if (!ALLOWED_TAGS[tagName] || FORBID_TAGS[tagName]) {
            throw typeErrorCreate("root node is forbidden and cannot be sanitized in-place");
          }
        }
      } else if (dirty instanceof Node) {
        body = _initDocument("<!---->");
        importedNode = body.ownerDocument.importNode(dirty, true);
        if (importedNode.nodeType === 1 && importedNode.nodeName === "BODY") {
          body = importedNode;
        } else if (importedNode.nodeName === "HTML") {
          body = importedNode;
        } else {
          body.appendChild(importedNode);
        }
      } else {
        if (!RETURN_DOM && !SAFE_FOR_TEMPLATES && !WHOLE_DOCUMENT && // eslint-disable-next-line unicorn/prefer-includes
        dirty.indexOf("<") === -1) {
          return trustedTypesPolicy && RETURN_TRUSTED_TYPE ? trustedTypesPolicy.createHTML(dirty) : dirty;
        }
        body = _initDocument(dirty);
        if (!body) {
          return RETURN_DOM ? null : RETURN_TRUSTED_TYPE ? emptyHTML : "";
        }
      }
      if (body && FORCE_BODY) {
        _forceRemove(body.firstChild);
      }
      const nodeIterator = _createIterator(IN_PLACE ? dirty : body);
      while (currentNode = nodeIterator.nextNode()) {
        if (_sanitizeElements(currentNode)) {
          continue;
        }
        if (currentNode.content instanceof DocumentFragment) {
          _sanitizeShadowDOM(currentNode.content);
        }
        _sanitizeAttributes(currentNode);
      }
      if (IN_PLACE) {
        return dirty;
      }
      if (RETURN_DOM) {
        if (RETURN_DOM_FRAGMENT) {
          returnNode = createDocumentFragment.call(body.ownerDocument);
          while (body.firstChild) {
            returnNode.appendChild(body.firstChild);
          }
        } else {
          returnNode = body;
        }
        if (ALLOWED_ATTR.shadowroot || ALLOWED_ATTR.shadowrootmod) {
          returnNode = importNode.call(originalDocument, returnNode, true);
        }
        return returnNode;
      }
      let serializedHTML = WHOLE_DOCUMENT ? body.outerHTML : body.innerHTML;
      if (WHOLE_DOCUMENT && ALLOWED_TAGS["!doctype"] && body.ownerDocument && body.ownerDocument.doctype && body.ownerDocument.doctype.name && regExpTest(DOCTYPE_NAME, body.ownerDocument.doctype.name)) {
        serializedHTML = "<!DOCTYPE " + body.ownerDocument.doctype.name + ">\n" + serializedHTML;
      }
      if (SAFE_FOR_TEMPLATES) {
        serializedHTML = stringReplace(serializedHTML, MUSTACHE_EXPR2, " ");
        serializedHTML = stringReplace(serializedHTML, ERB_EXPR2, " ");
        serializedHTML = stringReplace(serializedHTML, TMPLIT_EXPR2, " ");
      }
      return trustedTypesPolicy && RETURN_TRUSTED_TYPE ? trustedTypesPolicy.createHTML(serializedHTML) : serializedHTML;
    };
    DOMPurify.setConfig = function(cfg) {
      _parseConfig(cfg);
      SET_CONFIG = true;
    };
    DOMPurify.clearConfig = function() {
      CONFIG = null;
      SET_CONFIG = false;
    };
    DOMPurify.isValidAttribute = function(tag, attr, value) {
      if (!CONFIG) {
        _parseConfig({});
      }
      const lcTag = transformCaseFunc(tag);
      const lcName = transformCaseFunc(attr);
      return _isValidAttribute(lcTag, lcName, value);
    };
    DOMPurify.addHook = function(entryPoint, hookFunction) {
      if (typeof hookFunction !== "function") {
        return;
      }
      hooks[entryPoint] = hooks[entryPoint] || [];
      arrayPush$1(hooks[entryPoint], hookFunction);
    };
    DOMPurify.removeHook = function(entryPoint) {
      if (hooks[entryPoint]) {
        return arrayPop(hooks[entryPoint]);
      }
    };
    DOMPurify.removeHooks = function(entryPoint) {
      if (hooks[entryPoint]) {
        hooks[entryPoint] = [];
      }
    };
    DOMPurify.removeAllHooks = function() {
      hooks = {};
    };
    return DOMPurify;
  }
  var purify = createDOMPurify();
  const lineBreakRegex = /<br\s*\/?>/gi;
  const getRows = (s) => {
    if (!s) {
      return [""];
    }
    const str2 = breakToPlaceholder(s).replace(/\\n/g, "#br#");
    return str2.split("#br#");
  };
  const removeScript = (txt) => {
    return purify.sanitize(txt);
  };
  const sanitizeMore = (text2, config2) => {
    var _a;
    if (((_a = config2.flowchart) == null ? void 0 : _a.htmlLabels) !== false) {
      const level = config2.securityLevel;
      if (level === "antiscript" || level === "strict") {
        text2 = removeScript(text2);
      } else if (level !== "loose") {
        text2 = breakToPlaceholder(text2);
        text2 = text2.replace(/</g, "&lt;").replace(/>/g, "&gt;");
        text2 = text2.replace(/=/g, "&equals;");
        text2 = placeholderToBreak(text2);
      }
    }
    return text2;
  };
  const sanitizeText$6 = (text2, config2) => {
    if (!text2) {
      return text2;
    }
    if (config2.dompurifyConfig) {
      text2 = purify.sanitize(sanitizeMore(text2, config2), config2.dompurifyConfig).toString();
    } else {
      text2 = purify.sanitize(sanitizeMore(text2, config2), {
        FORBID_TAGS: ["style"]
      }).toString();
    }
    return text2;
  };
  const sanitizeTextOrArray = (a, config2) => {
    if (typeof a === "string") {
      return sanitizeText$6(a, config2);
    }
    return a.flat().map((x2) => sanitizeText$6(x2, config2));
  };
  const hasBreaks = (text2) => {
    return lineBreakRegex.test(text2);
  };
  const splitBreaks = (text2) => {
    return text2.split(lineBreakRegex);
  };
  const placeholderToBreak = (s) => {
    return s.replace(/#br#/g, "<br/>");
  };
  const breakToPlaceholder = (s) => {
    return s.replace(lineBreakRegex, "#br#");
  };
  const getUrl = (useAbsolute) => {
    let url = "";
    if (useAbsolute) {
      url = window.location.protocol + "//" + window.location.host + window.location.pathname + window.location.search;
      url = url.replaceAll(/\(/g, "\\(");
      url = url.replaceAll(/\)/g, "\\)");
    }
    return url;
  };
  const evaluate = (val) => val === false || ["false", "null", "0"].includes(String(val).trim().toLowerCase()) ? false : true;
  const getMax = function(...values2) {
    const newValues = values2.filter((value) => {
      return !isNaN(value);
    });
    return Math.max(...newValues);
  };
  const getMin = function(...values2) {
    const newValues = values2.filter((value) => {
      return !isNaN(value);
    });
    return Math.min(...newValues);
  };
  const parseGenericTypes = function(text2) {
    let cleanedText = text2;
    if (text2.split("~").length - 1 >= 2) {
      let newCleanedText = cleanedText;
      do {
        cleanedText = newCleanedText;
        newCleanedText = cleanedText.replace(/~([^\s,:;]+)~/, "<$1>");
      } while (newCleanedText != cleanedText);
      return parseGenericTypes(newCleanedText);
    } else {
      return cleanedText;
    }
  };
  const common$1 = {
    getRows,
    sanitizeText: sanitizeText$6,
    sanitizeTextOrArray,
    hasBreaks,
    splitBreaks,
    lineBreakRegex,
    removeScript,
    getUrl,
    evaluate,
    getMax,
    getMin
  };
  const Channel = {
    /* CLAMP */
    min: {
      r: 0,
      g: 0,
      b: 0,
      s: 0,
      l: 0,
      a: 0
    },
    max: {
      r: 255,
      g: 255,
      b: 255,
      h: 360,
      s: 100,
      l: 100,
      a: 1
    },
    clamp: {
      r: (r) => r >= 255 ? 255 : r < 0 ? 0 : r,
      g: (g) => g >= 255 ? 255 : g < 0 ? 0 : g,
      b: (b) => b >= 255 ? 255 : b < 0 ? 0 : b,
      h: (h) => h % 360,
      s: (s) => s >= 100 ? 100 : s < 0 ? 0 : s,
      l: (l) => l >= 100 ? 100 : l < 0 ? 0 : l,
      a: (a) => a >= 1 ? 1 : a < 0 ? 0 : a
    },
    /* CONVERSION */
    //SOURCE: https://planetcalc.com/7779
    toLinear: (c2) => {
      const n = c2 / 255;
      return c2 > 0.03928 ? Math.pow((n + 0.055) / 1.055, 2.4) : n / 12.92;
    },
    //SOURCE: https://gist.github.com/mjackson/5311256
    hue2rgb: (p, q, t) => {
      if (t < 0)
        t += 1;
      if (t > 1)
        t -= 1;
      if (t < 1 / 6)
        return p + (q - p) * 6 * t;
      if (t < 1 / 2)
        return q;
      if (t < 2 / 3)
        return p + (q - p) * (2 / 3 - t) * 6;
      return p;
    },
    hsl2rgb: ({ h, s, l }, channel2) => {
      if (!s)
        return l * 2.55;
      h /= 360;
      s /= 100;
      l /= 100;
      const q = l < 0.5 ? l * (1 + s) : l + s - l * s;
      const p = 2 * l - q;
      switch (channel2) {
        case "r":
          return Channel.hue2rgb(p, q, h + 1 / 3) * 255;
        case "g":
          return Channel.hue2rgb(p, q, h) * 255;
        case "b":
          return Channel.hue2rgb(p, q, h - 1 / 3) * 255;
      }
    },
    rgb2hsl: ({ r, g, b }, channel2) => {
      r /= 255;
      g /= 255;
      b /= 255;
      const max2 = Math.max(r, g, b);
      const min2 = Math.min(r, g, b);
      const l = (max2 + min2) / 2;
      if (channel2 === "l")
        return l * 100;
      if (max2 === min2)
        return 0;
      const d = max2 - min2;
      const s = l > 0.5 ? d / (2 - max2 - min2) : d / (max2 + min2);
      if (channel2 === "s")
        return s * 100;
      switch (max2) {
        case r:
          return ((g - b) / d + (g < b ? 6 : 0)) * 60;
        case g:
          return ((b - r) / d + 2) * 60;
        case b:
          return ((r - g) / d + 4) * 60;
        default:
          return -1;
      }
    }
  };
  const channel$2 = Channel;
  const Lang = {
    /* API */
    clamp: (number2, lower2, upper) => {
      if (lower2 > upper)
        return Math.min(lower2, Math.max(upper, number2));
      return Math.min(upper, Math.max(lower2, number2));
    },
    round: (number2) => {
      return Math.round(number2 * 1e10) / 1e10;
    }
  };
  const lang = Lang;
  const Unit = {
    /* API */
    dec2hex: (dec) => {
      const hex2 = Math.round(dec).toString(16);
      return hex2.length > 1 ? hex2 : `0${hex2}`;
    }
  };
  const unit = Unit;
  const Utils = {
    channel: channel$2,
    lang,
    unit
  };
  const _ = Utils;
  const DEC2HEX = {};
  for (let i2 = 0; i2 <= 255; i2++)
    DEC2HEX[i2] = _.unit.dec2hex(i2);
  const TYPE = {
    ALL: 0,
    RGB: 1,
    HSL: 2
  };
  class Type {
    constructor() {
      this.type = TYPE.ALL;
    }
    /* API */
    get() {
      return this.type;
    }
    set(type2) {
      if (this.type && this.type !== type2)
        throw new Error("Cannot change both RGB and HSL channels at the same time");
      this.type = type2;
    }
    reset() {
      this.type = TYPE.ALL;
    }
    is(type2) {
      return this.type === type2;
    }
  }
  const Type$2 = Type;
  class Channels {
    /* CONSTRUCTOR */
    constructor(data, color2) {
      this.color = color2;
      this.changed = false;
      this.data = data;
      this.type = new Type$2();
    }
    /* API */
    set(data, color2) {
      this.color = color2;
      this.changed = false;
      this.data = data;
      this.type.type = TYPE.ALL;
      return this;
    }
    /* HELPERS */
    _ensureHSL() {
      const data = this.data;
      const { h, s, l } = data;
      if (h === void 0)
        data.h = _.channel.rgb2hsl(data, "h");
      if (s === void 0)
        data.s = _.channel.rgb2hsl(data, "s");
      if (l === void 0)
        data.l = _.channel.rgb2hsl(data, "l");
    }
    _ensureRGB() {
      const data = this.data;
      const { r, g, b } = data;
      if (r === void 0)
        data.r = _.channel.hsl2rgb(data, "r");
      if (g === void 0)
        data.g = _.channel.hsl2rgb(data, "g");
      if (b === void 0)
        data.b = _.channel.hsl2rgb(data, "b");
    }
    /* GETTERS */
    get r() {
      const data = this.data;
      const r = data.r;
      if (!this.type.is(TYPE.HSL) && r !== void 0)
        return r;
      this._ensureHSL();
      return _.channel.hsl2rgb(data, "r");
    }
    get g() {
      const data = this.data;
      const g = data.g;
      if (!this.type.is(TYPE.HSL) && g !== void 0)
        return g;
      this._ensureHSL();
      return _.channel.hsl2rgb(data, "g");
    }
    get b() {
      const data = this.data;
      const b = data.b;
      if (!this.type.is(TYPE.HSL) && b !== void 0)
        return b;
      this._ensureHSL();
      return _.channel.hsl2rgb(data, "b");
    }
    get h() {
      const data = this.data;
      const h = data.h;
      if (!this.type.is(TYPE.RGB) && h !== void 0)
        return h;
      this._ensureRGB();
      return _.channel.rgb2hsl(data, "h");
    }
    get s() {
      const data = this.data;
      const s = data.s;
      if (!this.type.is(TYPE.RGB) && s !== void 0)
        return s;
      this._ensureRGB();
      return _.channel.rgb2hsl(data, "s");
    }
    get l() {
      const data = this.data;
      const l = data.l;
      if (!this.type.is(TYPE.RGB) && l !== void 0)
        return l;
      this._ensureRGB();
      return _.channel.rgb2hsl(data, "l");
    }
    get a() {
      return this.data.a;
    }
    /* SETTERS */
    set r(r) {
      this.type.set(TYPE.RGB);
      this.changed = true;
      this.data.r = r;
    }
    set g(g) {
      this.type.set(TYPE.RGB);
      this.changed = true;
      this.data.g = g;
    }
    set b(b) {
      this.type.set(TYPE.RGB);
      this.changed = true;
      this.data.b = b;
    }
    set h(h) {
      this.type.set(TYPE.HSL);
      this.changed = true;
      this.data.h = h;
    }
    set s(s) {
      this.type.set(TYPE.HSL);
      this.changed = true;
      this.data.s = s;
    }
    set l(l) {
      this.type.set(TYPE.HSL);
      this.changed = true;
      this.data.l = l;
    }
    set a(a) {
      this.changed = true;
      this.data.a = a;
    }
  }
  const Channels$1 = Channels;
  const channels = new Channels$1({ r: 0, g: 0, b: 0, a: 0 }, "transparent");
  const ChannelsReusable = channels;
  const Hex = {
    /* VARIABLES */
    re: /^#((?:[a-f0-9]{2}){2,4}|[a-f0-9]{3})$/i,
    /* API */
    parse: (color2) => {
      if (color2.charCodeAt(0) !== 35)
        return;
      const match = color2.match(Hex.re);
      if (!match)
        return;
      const hex2 = match[1];
      const dec = parseInt(hex2, 16);
      const length2 = hex2.length;
      const hasAlpha = length2 % 4 === 0;
      const isFullLength = length2 > 4;
      const multiplier = isFullLength ? 1 : 17;
      const bits = isFullLength ? 8 : 4;
      const bitsOffset = hasAlpha ? 0 : -1;
      const mask = isFullLength ? 255 : 15;
      return ChannelsReusable.set({
        r: (dec >> bits * (bitsOffset + 3) & mask) * multiplier,
        g: (dec >> bits * (bitsOffset + 2) & mask) * multiplier,
        b: (dec >> bits * (bitsOffset + 1) & mask) * multiplier,
        a: hasAlpha ? (dec & mask) * multiplier / 255 : 1
      }, color2);
    },
    stringify: (channels2) => {
      const { r, g, b, a } = channels2;
      if (a < 1) {
        return `#${DEC2HEX[Math.round(r)]}${DEC2HEX[Math.round(g)]}${DEC2HEX[Math.round(b)]}${DEC2HEX[Math.round(a * 255)]}`;
      } else {
        return `#${DEC2HEX[Math.round(r)]}${DEC2HEX[Math.round(g)]}${DEC2HEX[Math.round(b)]}`;
      }
    }
  };
  const Hex$1 = Hex;
  const HSL = {
    /* VARIABLES */
    re: /^hsla?\(\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e-?\d+)?(?:deg|grad|rad|turn)?)\s*?(?:,|\s)\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e-?\d+)?%)\s*?(?:,|\s)\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e-?\d+)?%)(?:\s*?(?:,|\/)\s*?\+?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e-?\d+)?(%)?))?\s*?\)$/i,
    hueRe: /^(.+?)(deg|grad|rad|turn)$/i,
    /* HELPERS */
    _hue2deg: (hue2) => {
      const match = hue2.match(HSL.hueRe);
      if (match) {
        const [, number2, unit2] = match;
        switch (unit2) {
          case "grad":
            return _.channel.clamp.h(parseFloat(number2) * 0.9);
          case "rad":
            return _.channel.clamp.h(parseFloat(number2) * 180 / Math.PI);
          case "turn":
            return _.channel.clamp.h(parseFloat(number2) * 360);
        }
      }
      return _.channel.clamp.h(parseFloat(hue2));
    },
    /* API */
    parse: (color2) => {
      const charCode = color2.charCodeAt(0);
      if (charCode !== 104 && charCode !== 72)
        return;
      const match = color2.match(HSL.re);
      if (!match)
        return;
      const [, h, s, l, a, isAlphaPercentage] = match;
      return ChannelsReusable.set({
        h: HSL._hue2deg(h),
        s: _.channel.clamp.s(parseFloat(s)),
        l: _.channel.clamp.l(parseFloat(l)),
        a: a ? _.channel.clamp.a(isAlphaPercentage ? parseFloat(a) / 100 : parseFloat(a)) : 1
      }, color2);
    },
    stringify: (channels2) => {
      const { h, s, l, a } = channels2;
      if (a < 1) {
        return `hsla(${_.lang.round(h)}, ${_.lang.round(s)}%, ${_.lang.round(l)}%, ${a})`;
      } else {
        return `hsl(${_.lang.round(h)}, ${_.lang.round(s)}%, ${_.lang.round(l)}%)`;
      }
    }
  };
  const HSL$1 = HSL;
  const Keyword = {
    /* VARIABLES */
    colors: {
      aliceblue: "#f0f8ff",
      antiquewhite: "#faebd7",
      aqua: "#00ffff",
      aquamarine: "#7fffd4",
      azure: "#f0ffff",
      beige: "#f5f5dc",
      bisque: "#ffe4c4",
      black: "#000000",
      blanchedalmond: "#ffebcd",
      blue: "#0000ff",
      blueviolet: "#8a2be2",
      brown: "#a52a2a",
      burlywood: "#deb887",
      cadetblue: "#5f9ea0",
      chartreuse: "#7fff00",
      chocolate: "#d2691e",
      coral: "#ff7f50",
      cornflowerblue: "#6495ed",
      cornsilk: "#fff8dc",
      crimson: "#dc143c",
      cyanaqua: "#00ffff",
      darkblue: "#00008b",
      darkcyan: "#008b8b",
      darkgoldenrod: "#b8860b",
      darkgray: "#a9a9a9",
      darkgreen: "#006400",
      darkgrey: "#a9a9a9",
      darkkhaki: "#bdb76b",
      darkmagenta: "#8b008b",
      darkolivegreen: "#556b2f",
      darkorange: "#ff8c00",
      darkorchid: "#9932cc",
      darkred: "#8b0000",
      darksalmon: "#e9967a",
      darkseagreen: "#8fbc8f",
      darkslateblue: "#483d8b",
      darkslategray: "#2f4f4f",
      darkslategrey: "#2f4f4f",
      darkturquoise: "#00ced1",
      darkviolet: "#9400d3",
      deeppink: "#ff1493",
      deepskyblue: "#00bfff",
      dimgray: "#696969",
      dimgrey: "#696969",
      dodgerblue: "#1e90ff",
      firebrick: "#b22222",
      floralwhite: "#fffaf0",
      forestgreen: "#228b22",
      fuchsia: "#ff00ff",
      gainsboro: "#dcdcdc",
      ghostwhite: "#f8f8ff",
      gold: "#ffd700",
      goldenrod: "#daa520",
      gray: "#808080",
      green: "#008000",
      greenyellow: "#adff2f",
      grey: "#808080",
      honeydew: "#f0fff0",
      hotpink: "#ff69b4",
      indianred: "#cd5c5c",
      indigo: "#4b0082",
      ivory: "#fffff0",
      khaki: "#f0e68c",
      lavender: "#e6e6fa",
      lavenderblush: "#fff0f5",
      lawngreen: "#7cfc00",
      lemonchiffon: "#fffacd",
      lightblue: "#add8e6",
      lightcoral: "#f08080",
      lightcyan: "#e0ffff",
      lightgoldenrodyellow: "#fafad2",
      lightgray: "#d3d3d3",
      lightgreen: "#90ee90",
      lightgrey: "#d3d3d3",
      lightpink: "#ffb6c1",
      lightsalmon: "#ffa07a",
      lightseagreen: "#20b2aa",
      lightskyblue: "#87cefa",
      lightslategray: "#778899",
      lightslategrey: "#778899",
      lightsteelblue: "#b0c4de",
      lightyellow: "#ffffe0",
      lime: "#00ff00",
      limegreen: "#32cd32",
      linen: "#faf0e6",
      magenta: "#ff00ff",
      maroon: "#800000",
      mediumaquamarine: "#66cdaa",
      mediumblue: "#0000cd",
      mediumorchid: "#ba55d3",
      mediumpurple: "#9370db",
      mediumseagreen: "#3cb371",
      mediumslateblue: "#7b68ee",
      mediumspringgreen: "#00fa9a",
      mediumturquoise: "#48d1cc",
      mediumvioletred: "#c71585",
      midnightblue: "#191970",
      mintcream: "#f5fffa",
      mistyrose: "#ffe4e1",
      moccasin: "#ffe4b5",
      navajowhite: "#ffdead",
      navy: "#000080",
      oldlace: "#fdf5e6",
      olive: "#808000",
      olivedrab: "#6b8e23",
      orange: "#ffa500",
      orangered: "#ff4500",
      orchid: "#da70d6",
      palegoldenrod: "#eee8aa",
      palegreen: "#98fb98",
      paleturquoise: "#afeeee",
      palevioletred: "#db7093",
      papayawhip: "#ffefd5",
      peachpuff: "#ffdab9",
      peru: "#cd853f",
      pink: "#ffc0cb",
      plum: "#dda0dd",
      powderblue: "#b0e0e6",
      purple: "#800080",
      rebeccapurple: "#663399",
      red: "#ff0000",
      rosybrown: "#bc8f8f",
      royalblue: "#4169e1",
      saddlebrown: "#8b4513",
      salmon: "#fa8072",
      sandybrown: "#f4a460",
      seagreen: "#2e8b57",
      seashell: "#fff5ee",
      sienna: "#a0522d",
      silver: "#c0c0c0",
      skyblue: "#87ceeb",
      slateblue: "#6a5acd",
      slategray: "#708090",
      slategrey: "#708090",
      snow: "#fffafa",
      springgreen: "#00ff7f",
      tan: "#d2b48c",
      teal: "#008080",
      thistle: "#d8bfd8",
      transparent: "#00000000",
      turquoise: "#40e0d0",
      violet: "#ee82ee",
      wheat: "#f5deb3",
      white: "#ffffff",
      whitesmoke: "#f5f5f5",
      yellow: "#ffff00",
      yellowgreen: "#9acd32"
    },
    /* API */
    parse: (color2) => {
      color2 = color2.toLowerCase();
      const hex2 = Keyword.colors[color2];
      if (!hex2)
        return;
      return Hex$1.parse(hex2);
    },
    stringify: (channels2) => {
      const hex2 = Hex$1.stringify(channels2);
      for (const name2 in Keyword.colors) {
        if (Keyword.colors[name2] === hex2)
          return name2;
      }
      return;
    }
  };
  const Keyword$1 = Keyword;
  const RGB = {
    /* VARIABLES */
    re: /^rgba?\(\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e\d+)?(%?))\s*?(?:,|\s)\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e\d+)?(%?))\s*?(?:,|\s)\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e\d+)?(%?))(?:\s*?(?:,|\/)\s*?\+?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e\d+)?(%?)))?\s*?\)$/i,
    /* API */
    parse: (color2) => {
      const charCode = color2.charCodeAt(0);
      if (charCode !== 114 && charCode !== 82)
        return;
      const match = color2.match(RGB.re);
      if (!match)
        return;
      const [, r, isRedPercentage, g, isGreenPercentage, b, isBluePercentage, a, isAlphaPercentage] = match;
      return ChannelsReusable.set({
        r: _.channel.clamp.r(isRedPercentage ? parseFloat(r) * 2.55 : parseFloat(r)),
        g: _.channel.clamp.g(isGreenPercentage ? parseFloat(g) * 2.55 : parseFloat(g)),
        b: _.channel.clamp.b(isBluePercentage ? parseFloat(b) * 2.55 : parseFloat(b)),
        a: a ? _.channel.clamp.a(isAlphaPercentage ? parseFloat(a) / 100 : parseFloat(a)) : 1
      }, color2);
    },
    stringify: (channels2) => {
      const { r, g, b, a } = channels2;
      if (a < 1) {
        return `rgba(${_.lang.round(r)}, ${_.lang.round(g)}, ${_.lang.round(b)}, ${_.lang.round(a)})`;
      } else {
        return `rgb(${_.lang.round(r)}, ${_.lang.round(g)}, ${_.lang.round(b)})`;
      }
    }
  };
  const RGB$1 = RGB;
  const Color = {
    /* VARIABLES */
    format: {
      keyword: Keyword$1,
      hex: Hex$1,
      rgb: RGB$1,
      rgba: RGB$1,
      hsl: HSL$1,
      hsla: HSL$1
    },
    /* API */
    parse: (color2) => {
      if (typeof color2 !== "string")
        return color2;
      const channels2 = Hex$1.parse(color2) || RGB$1.parse(color2) || HSL$1.parse(color2) || Keyword$1.parse(color2);
      if (channels2)
        return channels2;
      throw new Error(`Unsupported color format: "${color2}"`);
    },
    stringify: (channels2) => {
      if (!channels2.changed && channels2.color)
        return channels2.color;
      if (channels2.type.is(TYPE.HSL) || channels2.data.r === void 0) {
        return HSL$1.stringify(channels2);
      } else if (channels2.a < 1 || !Number.isInteger(channels2.r) || !Number.isInteger(channels2.g) || !Number.isInteger(channels2.b)) {
        return RGB$1.stringify(channels2);
      } else {
        return Hex$1.stringify(channels2);
      }
    }
  };
  const Color$1 = Color;
  const change = (color2, channels2) => {
    const ch = Color$1.parse(color2);
    for (const c2 in channels2) {
      ch[c2] = _.channel.clamp[c2](channels2[c2]);
    }
    return Color$1.stringify(ch);
  };
  const change$1 = change;
  const rgba = (r, g, b = 0, a = 1) => {
    if (typeof r !== "number")
      return change$1(r, { a: g });
    const channels2 = ChannelsReusable.set({
      r: _.channel.clamp.r(r),
      g: _.channel.clamp.g(g),
      b: _.channel.clamp.b(b),
      a: _.channel.clamp.a(a)
    });
    return Color$1.stringify(channels2);
  };
  const rgba$1 = rgba;
  const channel = (color2, channel2) => {
    return _.lang.round(Color$1.parse(color2)[channel2]);
  };
  const channel$1 = channel;
  const luminance = (color2) => {
    const { r, g, b } = Color$1.parse(color2);
    const luminance2 = 0.2126 * _.channel.toLinear(r) + 0.7152 * _.channel.toLinear(g) + 0.0722 * _.channel.toLinear(b);
    return _.lang.round(luminance2);
  };
  const luminance$1 = luminance;
  const isLight = (color2) => {
    return luminance$1(color2) >= 0.5;
  };
  const isLight$1 = isLight;
  const isDark = (color2) => {
    return !isLight$1(color2);
  };
  const isDark$1 = isDark;
  const adjustChannel = (color2, channel2, amount) => {
    const channels2 = Color$1.parse(color2);
    const amountCurrent = channels2[channel2];
    const amountNext = _.channel.clamp[channel2](amountCurrent + amount);
    if (amountCurrent !== amountNext)
      channels2[channel2] = amountNext;
    return Color$1.stringify(channels2);
  };
  const adjustChannel$1 = adjustChannel;
  const lighten = (color2, amount) => {
    return adjustChannel$1(color2, "l", amount);
  };
  const lighten$1 = lighten;
  const darken = (color2, amount) => {
    return adjustChannel$1(color2, "l", -amount);
  };
  const darken$1 = darken;
  const adjust$1 = (color2, channels2) => {
    const ch = Color$1.parse(color2);
    const changes = {};
    for (const c2 in channels2) {
      if (!channels2[c2])
        continue;
      changes[c2] = ch[c2] + channels2[c2];
    }
    return change$1(color2, changes);
  };
  const adjust$2 = adjust$1;
  const mix = (color1, color2, weight = 50) => {
    const { r: r1, g: g1, b: b1, a: a1 } = Color$1.parse(color1);
    const { r: r2, g: g2, b: b2, a: a2 } = Color$1.parse(color2);
    const weightScale = weight / 100;
    const weightNormalized = weightScale * 2 - 1;
    const alphaDelta = a1 - a2;
    const weight1combined = weightNormalized * alphaDelta === -1 ? weightNormalized : (weightNormalized + alphaDelta) / (1 + weightNormalized * alphaDelta);
    const weight1 = (weight1combined + 1) / 2;
    const weight2 = 1 - weight1;
    const r = r1 * weight1 + r2 * weight2;
    const g = g1 * weight1 + g2 * weight2;
    const b = b1 * weight1 + b2 * weight2;
    const a = a1 * weightScale + a2 * (1 - weightScale);
    return rgba$1(r, g, b, a);
  };
  const mix$1 = mix;
  const invert = (color2, weight = 100) => {
    const inverse = Color$1.parse(color2);
    inverse.r = 255 - inverse.r;
    inverse.g = 255 - inverse.g;
    inverse.b = 255 - inverse.b;
    return mix$1(inverse, color2, weight);
  };
  const invert$1 = invert;
  const mkBorder = (col, darkMode) => darkMode ? adjust$2(col, { s: -40, l: 10 }) : adjust$2(col, { s: -40, l: -10 });
  const oldAttributeBackgroundColorOdd = "#ffffff";
  const oldAttributeBackgroundColorEven = "#f2f2f2";
  let Theme$4 = class Theme {
    constructor() {
      this.background = "#f4f4f4";
      this.primaryColor = "#fff4dd";
      this.noteBkgColor = "#fff5ad";
      this.noteTextColor = "#333";
      this.THEME_COLOR_LIMIT = 12;
      this.fontFamily = '"trebuchet ms", verdana, arial, sans-serif';
      this.fontSize = "16px";
    }
    updateColors() {
      this.primaryTextColor = this.primaryTextColor || (this.darkMode ? "#eee" : "#333");
      this.secondaryColor = this.secondaryColor || adjust$2(this.primaryColor, { h: -120 });
      this.tertiaryColor = this.tertiaryColor || adjust$2(this.primaryColor, { h: 180, l: 5 });
      this.primaryBorderColor = this.primaryBorderColor || mkBorder(this.primaryColor, this.darkMode);
      this.secondaryBorderColor = this.secondaryBorderColor || mkBorder(this.secondaryColor, this.darkMode);
      this.tertiaryBorderColor = this.tertiaryBorderColor || mkBorder(this.tertiaryColor, this.darkMode);
      this.noteBorderColor = this.noteBorderColor || mkBorder(this.noteBkgColor, this.darkMode);
      this.noteBkgColor = this.noteBkgColor || "#fff5ad";
      this.noteTextColor = this.noteTextColor || "#333";
      this.secondaryTextColor = this.secondaryTextColor || invert$1(this.secondaryColor);
      this.tertiaryTextColor = this.tertiaryTextColor || invert$1(this.tertiaryColor);
      this.lineColor = this.lineColor || invert$1(this.background);
      this.arrowheadColor = this.arrowheadColor || invert$1(this.background);
      this.textColor = this.textColor || this.primaryTextColor;
      this.border2 = this.border2 || this.tertiaryBorderColor;
      this.nodeBkg = this.nodeBkg || this.primaryColor;
      this.mainBkg = this.mainBkg || this.primaryColor;
      this.nodeBorder = this.nodeBorder || this.primaryBorderColor;
      this.clusterBkg = this.clusterBkg || this.tertiaryColor;
      this.clusterBorder = this.clusterBorder || this.tertiaryBorderColor;
      this.defaultLinkColor = this.defaultLinkColor || this.lineColor;
      this.titleColor = this.titleColor || this.tertiaryTextColor;
      this.edgeLabelBackground = this.edgeLabelBackground || (this.darkMode ? darken$1(this.secondaryColor, 30) : this.secondaryColor);
      this.nodeTextColor = this.nodeTextColor || this.primaryTextColor;
      this.actorBorder = this.actorBorder || this.primaryBorderColor;
      this.actorBkg = this.actorBkg || this.mainBkg;
      this.actorTextColor = this.actorTextColor || this.primaryTextColor;
      this.actorLineColor = this.actorLineColor || "grey";
      this.labelBoxBkgColor = this.labelBoxBkgColor || this.actorBkg;
      this.signalColor = this.signalColor || this.textColor;
      this.signalTextColor = this.signalTextColor || this.textColor;
      this.labelBoxBorderColor = this.labelBoxBorderColor || this.actorBorder;
      this.labelTextColor = this.labelTextColor || this.actorTextColor;
      this.loopTextColor = this.loopTextColor || this.actorTextColor;
      this.activationBorderColor = this.activationBorderColor || darken$1(this.secondaryColor, 10);
      this.activationBkgColor = this.activationBkgColor || this.secondaryColor;
      this.sequenceNumberColor = this.sequenceNumberColor || invert$1(this.lineColor);
      this.sectionBkgColor = this.sectionBkgColor || this.tertiaryColor;
      this.altSectionBkgColor = this.altSectionBkgColor || "white";
      this.sectionBkgColor = this.sectionBkgColor || this.secondaryColor;
      this.sectionBkgColor2 = this.sectionBkgColor2 || this.primaryColor;
      this.excludeBkgColor = this.excludeBkgColor || "#eeeeee";
      this.taskBorderColor = this.taskBorderColor || this.primaryBorderColor;
      this.taskBkgColor = this.taskBkgColor || this.primaryColor;
      this.activeTaskBorderColor = this.activeTaskBorderColor || this.primaryColor;
      this.activeTaskBkgColor = this.activeTaskBkgColor || lighten$1(this.primaryColor, 23);
      this.gridColor = this.gridColor || "lightgrey";
      this.doneTaskBkgColor = this.doneTaskBkgColor || "lightgrey";
      this.doneTaskBorderColor = this.doneTaskBorderColor || "grey";
      this.critBorderColor = this.critBorderColor || "#ff8888";
      this.critBkgColor = this.critBkgColor || "red";
      this.todayLineColor = this.todayLineColor || "red";
      this.taskTextColor = this.taskTextColor || this.textColor;
      this.taskTextOutsideColor = this.taskTextOutsideColor || this.textColor;
      this.taskTextLightColor = this.taskTextLightColor || this.textColor;
      this.taskTextColor = this.taskTextColor || this.primaryTextColor;
      this.taskTextDarkColor = this.taskTextDarkColor || this.textColor;
      this.taskTextClickableColor = this.taskTextClickableColor || "#003163";
      this.personBorder = this.personBorder || this.primaryBorderColor;
      this.personBkg = this.personBkg || this.mainBkg;
      this.transitionColor = this.transitionColor || this.lineColor;
      this.transitionLabelColor = this.transitionLabelColor || this.textColor;
      this.stateLabelColor = this.stateLabelColor || this.stateBkg || this.primaryTextColor;
      this.stateBkg = this.stateBkg || this.mainBkg;
      this.labelBackgroundColor = this.labelBackgroundColor || this.stateBkg;
      this.compositeBackground = this.compositeBackground || this.background || this.tertiaryColor;
      this.altBackground = this.altBackground || this.tertiaryColor;
      this.compositeTitleBackground = this.compositeTitleBackground || this.mainBkg;
      this.compositeBorder = this.compositeBorder || this.nodeBorder;
      this.innerEndBackground = this.nodeBorder;
      this.errorBkgColor = this.errorBkgColor || this.tertiaryColor;
      this.errorTextColor = this.errorTextColor || this.tertiaryTextColor;
      this.transitionColor = this.transitionColor || this.lineColor;
      this.specialStateColor = this.lineColor;
      this.cScale0 = this.cScale0 || this.primaryColor;
      this.cScale1 = this.cScale1 || this.secondaryColor;
      this.cScale2 = this.cScale2 || this.tertiaryColor;
      this.cScale3 = this.cScale3 || adjust$2(this.primaryColor, { h: 30 });
      this.cScale4 = this.cScale4 || adjust$2(this.primaryColor, { h: 60 });
      this.cScale5 = this.cScale5 || adjust$2(this.primaryColor, { h: 90 });
      this.cScale6 = this.cScale6 || adjust$2(this.primaryColor, { h: 120 });
      this.cScale7 = this.cScale7 || adjust$2(this.primaryColor, { h: 150 });
      this.cScale8 = this.cScale8 || adjust$2(this.primaryColor, { h: 210, l: 150 });
      this.cScale9 = this.cScale9 || adjust$2(this.primaryColor, { h: 270 });
      this.cScale10 = this.cScale10 || adjust$2(this.primaryColor, { h: 300 });
      this.cScale11 = this.cScale11 || adjust$2(this.primaryColor, { h: 330 });
      if (this.darkMode) {
        for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
          this["cScale" + i2] = darken$1(this["cScale" + i2], 75);
        }
      } else {
        for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
          this["cScale" + i2] = darken$1(this["cScale" + i2], 25);
        }
      }
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScaleInv" + i2] = this["cScaleInv" + i2] || invert$1(this["cScale" + i2]);
      }
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        if (this.darkMode) {
          this["cScalePeer" + i2] = this["cScalePeer" + i2] || lighten$1(this["cScale" + i2], 10);
        } else {
          this["cScalePeer" + i2] = this["cScalePeer" + i2] || darken$1(this["cScale" + i2], 10);
        }
      }
      this.scaleLabelColor = this.scaleLabelColor || this.labelTextColor;
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScaleLabel" + i2] = this["cScaleLabel" + i2] || this.scaleLabelColor;
      }
      const multiplier = this.darkMode ? -4 : -1;
      for (let i2 = 0; i2 < 5; i2++) {
        this["surface" + i2] = this["surface" + i2] || adjust$2(this.mainBkg, { h: 180, s: -15, l: multiplier * (5 + i2 * 3) });
        this["surfacePeer" + i2] = this["surfacePeer" + i2] || adjust$2(this.mainBkg, { h: 180, s: -15, l: multiplier * (8 + i2 * 3) });
      }
      this.classText = this.classText || this.textColor;
      this.fillType0 = this.fillType0 || this.primaryColor;
      this.fillType1 = this.fillType1 || this.secondaryColor;
      this.fillType2 = this.fillType2 || adjust$2(this.primaryColor, { h: 64 });
      this.fillType3 = this.fillType3 || adjust$2(this.secondaryColor, { h: 64 });
      this.fillType4 = this.fillType4 || adjust$2(this.primaryColor, { h: -64 });
      this.fillType5 = this.fillType5 || adjust$2(this.secondaryColor, { h: -64 });
      this.fillType6 = this.fillType6 || adjust$2(this.primaryColor, { h: 128 });
      this.fillType7 = this.fillType7 || adjust$2(this.secondaryColor, { h: 128 });
      this.pie1 = this.pie1 || this.primaryColor;
      this.pie2 = this.pie2 || this.secondaryColor;
      this.pie3 = this.pie3 || this.tertiaryColor;
      this.pie4 = this.pie4 || adjust$2(this.primaryColor, { l: -10 });
      this.pie5 = this.pie5 || adjust$2(this.secondaryColor, { l: -10 });
      this.pie6 = this.pie6 || adjust$2(this.tertiaryColor, { l: -10 });
      this.pie7 = this.pie7 || adjust$2(this.primaryColor, { h: 60, l: -10 });
      this.pie8 = this.pie8 || adjust$2(this.primaryColor, { h: -60, l: -10 });
      this.pie9 = this.pie9 || adjust$2(this.primaryColor, { h: 120, l: 0 });
      this.pie10 = this.pie10 || adjust$2(this.primaryColor, { h: 60, l: -20 });
      this.pie11 = this.pie11 || adjust$2(this.primaryColor, { h: -60, l: -20 });
      this.pie12 = this.pie12 || adjust$2(this.primaryColor, { h: 120, l: -10 });
      this.pieTitleTextSize = this.pieTitleTextSize || "25px";
      this.pieTitleTextColor = this.pieTitleTextColor || this.taskTextDarkColor;
      this.pieSectionTextSize = this.pieSectionTextSize || "17px";
      this.pieSectionTextColor = this.pieSectionTextColor || this.textColor;
      this.pieLegendTextSize = this.pieLegendTextSize || "17px";
      this.pieLegendTextColor = this.pieLegendTextColor || this.taskTextDarkColor;
      this.pieStrokeColor = this.pieStrokeColor || "black";
      this.pieStrokeWidth = this.pieStrokeWidth || "2px";
      this.pieOuterStrokeWidth = this.pieOuterStrokeWidth || "2px";
      this.pieOuterStrokeColor = this.pieOuterStrokeColor || "black";
      this.pieOpacity = this.pieOpacity || "0.7";
      this.quadrant1Fill = this.quadrant1Fill || this.primaryColor;
      this.quadrant2Fill = this.quadrant2Fill || adjust$2(this.primaryColor, { r: 5, g: 5, b: 5 });
      this.quadrant3Fill = this.quadrant3Fill || adjust$2(this.primaryColor, { r: 10, g: 10, b: 10 });
      this.quadrant4Fill = this.quadrant4Fill || adjust$2(this.primaryColor, { r: 15, g: 15, b: 15 });
      this.quadrant1TextFill = this.quadrant1TextFill || this.primaryTextColor;
      this.quadrant2TextFill = this.quadrant2TextFill || adjust$2(this.primaryTextColor, { r: -5, g: -5, b: -5 });
      this.quadrant3TextFill = this.quadrant3TextFill || adjust$2(this.primaryTextColor, { r: -10, g: -10, b: -10 });
      this.quadrant4TextFill = this.quadrant4TextFill || adjust$2(this.primaryTextColor, { r: -15, g: -15, b: -15 });
      this.quadrantPointFill = this.quadrantPointFill || isDark$1(this.quadrant1Fill) ? lighten$1(this.quadrant1Fill) : darken$1(this.quadrant1Fill);
      this.quadrantPointTextFill = this.quadrantPointTextFill || this.primaryTextColor;
      this.quadrantXAxisTextFill = this.quadrantXAxisTextFill || this.primaryTextColor;
      this.quadrantYAxisTextFill = this.quadrantYAxisTextFill || this.primaryTextColor;
      this.quadrantInternalBorderStrokeFill = this.quadrantInternalBorderStrokeFill || this.primaryBorderColor;
      this.quadrantExternalBorderStrokeFill = this.quadrantExternalBorderStrokeFill || this.primaryBorderColor;
      this.quadrantTitleFill = this.quadrantTitleFill || this.primaryTextColor;
      this.requirementBackground = this.requirementBackground || this.primaryColor;
      this.requirementBorderColor = this.requirementBorderColor || this.primaryBorderColor;
      this.requirementBorderSize = this.requirementBorderSize || "1";
      this.requirementTextColor = this.requirementTextColor || this.primaryTextColor;
      this.relationColor = this.relationColor || this.lineColor;
      this.relationLabelBackground = this.relationLabelBackground || (this.darkMode ? darken$1(this.secondaryColor, 30) : this.secondaryColor);
      this.relationLabelColor = this.relationLabelColor || this.actorTextColor;
      this.git0 = this.git0 || this.primaryColor;
      this.git1 = this.git1 || this.secondaryColor;
      this.git2 = this.git2 || this.tertiaryColor;
      this.git3 = this.git3 || adjust$2(this.primaryColor, { h: -30 });
      this.git4 = this.git4 || adjust$2(this.primaryColor, { h: -60 });
      this.git5 = this.git5 || adjust$2(this.primaryColor, { h: -90 });
      this.git6 = this.git6 || adjust$2(this.primaryColor, { h: 60 });
      this.git7 = this.git7 || adjust$2(this.primaryColor, { h: 120 });
      if (this.darkMode) {
        this.git0 = lighten$1(this.git0, 25);
        this.git1 = lighten$1(this.git1, 25);
        this.git2 = lighten$1(this.git2, 25);
        this.git3 = lighten$1(this.git3, 25);
        this.git4 = lighten$1(this.git4, 25);
        this.git5 = lighten$1(this.git5, 25);
        this.git6 = lighten$1(this.git6, 25);
        this.git7 = lighten$1(this.git7, 25);
      } else {
        this.git0 = darken$1(this.git0, 25);
        this.git1 = darken$1(this.git1, 25);
        this.git2 = darken$1(this.git2, 25);
        this.git3 = darken$1(this.git3, 25);
        this.git4 = darken$1(this.git4, 25);
        this.git5 = darken$1(this.git5, 25);
        this.git6 = darken$1(this.git6, 25);
        this.git7 = darken$1(this.git7, 25);
      }
      this.gitInv0 = this.gitInv0 || invert$1(this.git0);
      this.gitInv1 = this.gitInv1 || invert$1(this.git1);
      this.gitInv2 = this.gitInv2 || invert$1(this.git2);
      this.gitInv3 = this.gitInv3 || invert$1(this.git3);
      this.gitInv4 = this.gitInv4 || invert$1(this.git4);
      this.gitInv5 = this.gitInv5 || invert$1(this.git5);
      this.gitInv6 = this.gitInv6 || invert$1(this.git6);
      this.gitInv7 = this.gitInv7 || invert$1(this.git7);
      this.branchLabelColor = this.branchLabelColor || (this.darkMode ? "black" : this.labelTextColor);
      this.gitBranchLabel0 = this.gitBranchLabel0 || this.branchLabelColor;
      this.gitBranchLabel1 = this.gitBranchLabel1 || this.branchLabelColor;
      this.gitBranchLabel2 = this.gitBranchLabel2 || this.branchLabelColor;
      this.gitBranchLabel3 = this.gitBranchLabel3 || this.branchLabelColor;
      this.gitBranchLabel4 = this.gitBranchLabel4 || this.branchLabelColor;
      this.gitBranchLabel5 = this.gitBranchLabel5 || this.branchLabelColor;
      this.gitBranchLabel6 = this.gitBranchLabel6 || this.branchLabelColor;
      this.gitBranchLabel7 = this.gitBranchLabel7 || this.branchLabelColor;
      this.tagLabelColor = this.tagLabelColor || this.primaryTextColor;
      this.tagLabelBackground = this.tagLabelBackground || this.primaryColor;
      this.tagLabelBorder = this.tagBorder || this.primaryBorderColor;
      this.tagLabelFontSize = this.tagLabelFontSize || "10px";
      this.commitLabelColor = this.commitLabelColor || this.secondaryTextColor;
      this.commitLabelBackground = this.commitLabelBackground || this.secondaryColor;
      this.commitLabelFontSize = this.commitLabelFontSize || "10px";
      this.attributeBackgroundColorOdd = this.attributeBackgroundColorOdd || oldAttributeBackgroundColorOdd;
      this.attributeBackgroundColorEven = this.attributeBackgroundColorEven || oldAttributeBackgroundColorEven;
    }
    calculate(overrides) {
      if (typeof overrides !== "object") {
        this.updateColors();
        return;
      }
      const keys2 = Object.keys(overrides);
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
      this.updateColors();
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
    }
  };
  const getThemeVariables$4 = (userOverrides) => {
    const theme2 = new Theme$4();
    theme2.calculate(userOverrides);
    return theme2;
  };
  let Theme$3 = class Theme {
    constructor() {
      this.background = "#333";
      this.primaryColor = "#1f2020";
      this.secondaryColor = lighten$1(this.primaryColor, 16);
      this.tertiaryColor = adjust$2(this.primaryColor, { h: -160 });
      this.primaryBorderColor = invert$1(this.background);
      this.secondaryBorderColor = mkBorder(this.secondaryColor, this.darkMode);
      this.tertiaryBorderColor = mkBorder(this.tertiaryColor, this.darkMode);
      this.primaryTextColor = invert$1(this.primaryColor);
      this.secondaryTextColor = invert$1(this.secondaryColor);
      this.tertiaryTextColor = invert$1(this.tertiaryColor);
      this.lineColor = invert$1(this.background);
      this.textColor = invert$1(this.background);
      this.mainBkg = "#1f2020";
      this.secondBkg = "calculated";
      this.mainContrastColor = "lightgrey";
      this.darkTextColor = lighten$1(invert$1("#323D47"), 10);
      this.lineColor = "calculated";
      this.border1 = "#81B1DB";
      this.border2 = rgba$1(255, 255, 255, 0.25);
      this.arrowheadColor = "calculated";
      this.fontFamily = '"trebuchet ms", verdana, arial, sans-serif';
      this.fontSize = "16px";
      this.labelBackground = "#181818";
      this.textColor = "#ccc";
      this.THEME_COLOR_LIMIT = 12;
      this.nodeBkg = "calculated";
      this.nodeBorder = "calculated";
      this.clusterBkg = "calculated";
      this.clusterBorder = "calculated";
      this.defaultLinkColor = "calculated";
      this.titleColor = "#F9FFFE";
      this.edgeLabelBackground = "calculated";
      this.actorBorder = "calculated";
      this.actorBkg = "calculated";
      this.actorTextColor = "calculated";
      this.actorLineColor = "calculated";
      this.signalColor = "calculated";
      this.signalTextColor = "calculated";
      this.labelBoxBkgColor = "calculated";
      this.labelBoxBorderColor = "calculated";
      this.labelTextColor = "calculated";
      this.loopTextColor = "calculated";
      this.noteBorderColor = "calculated";
      this.noteBkgColor = "#fff5ad";
      this.noteTextColor = "calculated";
      this.activationBorderColor = "calculated";
      this.activationBkgColor = "calculated";
      this.sequenceNumberColor = "black";
      this.sectionBkgColor = darken$1("#EAE8D9", 30);
      this.altSectionBkgColor = "calculated";
      this.sectionBkgColor2 = "#EAE8D9";
      this.excludeBkgColor = darken$1(this.sectionBkgColor, 10);
      this.taskBorderColor = rgba$1(255, 255, 255, 70);
      this.taskBkgColor = "calculated";
      this.taskTextColor = "calculated";
      this.taskTextLightColor = "calculated";
      this.taskTextOutsideColor = "calculated";
      this.taskTextClickableColor = "#003163";
      this.activeTaskBorderColor = rgba$1(255, 255, 255, 50);
      this.activeTaskBkgColor = "#81B1DB";
      this.gridColor = "calculated";
      this.doneTaskBkgColor = "calculated";
      this.doneTaskBorderColor = "grey";
      this.critBorderColor = "#E83737";
      this.critBkgColor = "#E83737";
      this.taskTextDarkColor = "calculated";
      this.todayLineColor = "#DB5757";
      this.personBorder = this.primaryBorderColor;
      this.personBkg = this.mainBkg;
      this.labelColor = "calculated";
      this.errorBkgColor = "#a44141";
      this.errorTextColor = "#ddd";
    }
    updateColors() {
      this.secondBkg = lighten$1(this.mainBkg, 16);
      this.lineColor = this.mainContrastColor;
      this.arrowheadColor = this.mainContrastColor;
      this.nodeBkg = this.mainBkg;
      this.nodeBorder = this.border1;
      this.clusterBkg = this.secondBkg;
      this.clusterBorder = this.border2;
      this.defaultLinkColor = this.lineColor;
      this.edgeLabelBackground = lighten$1(this.labelBackground, 25);
      this.actorBorder = this.border1;
      this.actorBkg = this.mainBkg;
      this.actorTextColor = this.mainContrastColor;
      this.actorLineColor = this.mainContrastColor;
      this.signalColor = this.mainContrastColor;
      this.signalTextColor = this.mainContrastColor;
      this.labelBoxBkgColor = this.actorBkg;
      this.labelBoxBorderColor = this.actorBorder;
      this.labelTextColor = this.mainContrastColor;
      this.loopTextColor = this.mainContrastColor;
      this.noteBorderColor = this.secondaryBorderColor;
      this.noteBkgColor = this.secondBkg;
      this.noteTextColor = this.secondaryTextColor;
      this.activationBorderColor = this.border1;
      this.activationBkgColor = this.secondBkg;
      this.altSectionBkgColor = this.background;
      this.taskBkgColor = lighten$1(this.mainBkg, 23);
      this.taskTextColor = this.darkTextColor;
      this.taskTextLightColor = this.mainContrastColor;
      this.taskTextOutsideColor = this.taskTextLightColor;
      this.gridColor = this.mainContrastColor;
      this.doneTaskBkgColor = this.mainContrastColor;
      this.taskTextDarkColor = this.darkTextColor;
      this.transitionColor = this.transitionColor || this.lineColor;
      this.transitionLabelColor = this.transitionLabelColor || this.textColor;
      this.stateLabelColor = this.stateLabelColor || this.stateBkg || this.primaryTextColor;
      this.stateBkg = this.stateBkg || this.mainBkg;
      this.labelBackgroundColor = this.labelBackgroundColor || this.stateBkg;
      this.compositeBackground = this.compositeBackground || this.background || this.tertiaryColor;
      this.altBackground = this.altBackground || "#555";
      this.compositeTitleBackground = this.compositeTitleBackground || this.mainBkg;
      this.compositeBorder = this.compositeBorder || this.nodeBorder;
      this.innerEndBackground = this.primaryBorderColor;
      this.specialStateColor = "#f4f4f4";
      this.errorBkgColor = this.errorBkgColor || this.tertiaryColor;
      this.errorTextColor = this.errorTextColor || this.tertiaryTextColor;
      this.fillType0 = this.primaryColor;
      this.fillType1 = this.secondaryColor;
      this.fillType2 = adjust$2(this.primaryColor, { h: 64 });
      this.fillType3 = adjust$2(this.secondaryColor, { h: 64 });
      this.fillType4 = adjust$2(this.primaryColor, { h: -64 });
      this.fillType5 = adjust$2(this.secondaryColor, { h: -64 });
      this.fillType6 = adjust$2(this.primaryColor, { h: 128 });
      this.fillType7 = adjust$2(this.secondaryColor, { h: 128 });
      this.cScale1 = this.cScale1 || "#0b0000";
      this.cScale2 = this.cScale2 || "#4d1037";
      this.cScale3 = this.cScale3 || "#3f5258";
      this.cScale4 = this.cScale4 || "#4f2f1b";
      this.cScale5 = this.cScale5 || "#6e0a0a";
      this.cScale6 = this.cScale6 || "#3b0048";
      this.cScale7 = this.cScale7 || "#995a01";
      this.cScale8 = this.cScale8 || "#154706";
      this.cScale9 = this.cScale9 || "#161722";
      this.cScale10 = this.cScale10 || "#00296f";
      this.cScale11 = this.cScale11 || "#01629c";
      this.cScale12 = this.cScale12 || "#010029";
      this.cScale0 = this.cScale0 || this.primaryColor;
      this.cScale1 = this.cScale1 || this.secondaryColor;
      this.cScale2 = this.cScale2 || this.tertiaryColor;
      this.cScale3 = this.cScale3 || adjust$2(this.primaryColor, { h: 30 });
      this.cScale4 = this.cScale4 || adjust$2(this.primaryColor, { h: 60 });
      this.cScale5 = this.cScale5 || adjust$2(this.primaryColor, { h: 90 });
      this.cScale6 = this.cScale6 || adjust$2(this.primaryColor, { h: 120 });
      this.cScale7 = this.cScale7 || adjust$2(this.primaryColor, { h: 150 });
      this.cScale8 = this.cScale8 || adjust$2(this.primaryColor, { h: 210 });
      this.cScale9 = this.cScale9 || adjust$2(this.primaryColor, { h: 270 });
      this.cScale10 = this.cScale10 || adjust$2(this.primaryColor, { h: 300 });
      this.cScale11 = this.cScale11 || adjust$2(this.primaryColor, { h: 330 });
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScaleInv" + i2] = this["cScaleInv" + i2] || invert$1(this["cScale" + i2]);
      }
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScalePeer" + i2] = this["cScalePeer" + i2] || lighten$1(this["cScale" + i2], 10);
      }
      for (let i2 = 0; i2 < 5; i2++) {
        this["surface" + i2] = this["surface" + i2] || adjust$2(this.mainBkg, { h: 30, s: -30, l: -(-10 + i2 * 4) });
        this["surfacePeer" + i2] = this["surfacePeer" + i2] || adjust$2(this.mainBkg, { h: 30, s: -30, l: -(-7 + i2 * 4) });
      }
      this.scaleLabelColor = this.scaleLabelColor || (this.darkMode ? "black" : this.labelTextColor);
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScaleLabel" + i2] = this["cScaleLabel" + i2] || this.scaleLabelColor;
      }
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["pie" + i2] = this["cScale" + i2];
      }
      this.pieTitleTextSize = this.pieTitleTextSize || "25px";
      this.pieTitleTextColor = this.pieTitleTextColor || this.taskTextDarkColor;
      this.pieSectionTextSize = this.pieSectionTextSize || "17px";
      this.pieSectionTextColor = this.pieSectionTextColor || this.textColor;
      this.pieLegendTextSize = this.pieLegendTextSize || "17px";
      this.pieLegendTextColor = this.pieLegendTextColor || this.taskTextDarkColor;
      this.pieStrokeColor = this.pieStrokeColor || "black";
      this.pieStrokeWidth = this.pieStrokeWidth || "2px";
      this.pieOuterStrokeWidth = this.pieOuterStrokeWidth || "2px";
      this.pieOuterStrokeColor = this.pieOuterStrokeColor || "black";
      this.pieOpacity = this.pieOpacity || "0.7";
      this.quadrant1Fill = this.quadrant1Fill || this.primaryColor;
      this.quadrant2Fill = this.quadrant2Fill || adjust$2(this.primaryColor, { r: 5, g: 5, b: 5 });
      this.quadrant3Fill = this.quadrant3Fill || adjust$2(this.primaryColor, { r: 10, g: 10, b: 10 });
      this.quadrant4Fill = this.quadrant4Fill || adjust$2(this.primaryColor, { r: 15, g: 15, b: 15 });
      this.quadrant1TextFill = this.quadrant1TextFill || this.primaryTextColor;
      this.quadrant2TextFill = this.quadrant2TextFill || adjust$2(this.primaryTextColor, { r: -5, g: -5, b: -5 });
      this.quadrant3TextFill = this.quadrant3TextFill || adjust$2(this.primaryTextColor, { r: -10, g: -10, b: -10 });
      this.quadrant4TextFill = this.quadrant4TextFill || adjust$2(this.primaryTextColor, { r: -15, g: -15, b: -15 });
      this.quadrantPointFill = this.quadrantPointFill || isDark$1(this.quadrant1Fill) ? lighten$1(this.quadrant1Fill) : darken$1(this.quadrant1Fill);
      this.quadrantPointTextFill = this.quadrantPointTextFill || this.primaryTextColor;
      this.quadrantXAxisTextFill = this.quadrantXAxisTextFill || this.primaryTextColor;
      this.quadrantYAxisTextFill = this.quadrantYAxisTextFill || this.primaryTextColor;
      this.quadrantInternalBorderStrokeFill = this.quadrantInternalBorderStrokeFill || this.primaryBorderColor;
      this.quadrantExternalBorderStrokeFill = this.quadrantExternalBorderStrokeFill || this.primaryBorderColor;
      this.quadrantTitleFill = this.quadrantTitleFill || this.primaryTextColor;
      this.classText = this.primaryTextColor;
      this.requirementBackground = this.requirementBackground || this.primaryColor;
      this.requirementBorderColor = this.requirementBorderColor || this.primaryBorderColor;
      this.requirementBorderSize = this.requirementBorderSize || "1";
      this.requirementTextColor = this.requirementTextColor || this.primaryTextColor;
      this.relationColor = this.relationColor || this.lineColor;
      this.relationLabelBackground = this.relationLabelBackground || (this.darkMode ? darken$1(this.secondaryColor, 30) : this.secondaryColor);
      this.relationLabelColor = this.relationLabelColor || this.actorTextColor;
      this.git0 = lighten$1(this.secondaryColor, 20);
      this.git1 = lighten$1(this.pie2 || this.secondaryColor, 20);
      this.git2 = lighten$1(this.pie3 || this.tertiaryColor, 20);
      this.git3 = lighten$1(this.pie4 || adjust$2(this.primaryColor, { h: -30 }), 20);
      this.git4 = lighten$1(this.pie5 || adjust$2(this.primaryColor, { h: -60 }), 20);
      this.git5 = lighten$1(this.pie6 || adjust$2(this.primaryColor, { h: -90 }), 10);
      this.git6 = lighten$1(this.pie7 || adjust$2(this.primaryColor, { h: 60 }), 10);
      this.git7 = lighten$1(this.pie8 || adjust$2(this.primaryColor, { h: 120 }), 20);
      this.gitInv0 = this.gitInv0 || invert$1(this.git0);
      this.gitInv1 = this.gitInv1 || invert$1(this.git1);
      this.gitInv2 = this.gitInv2 || invert$1(this.git2);
      this.gitInv3 = this.gitInv3 || invert$1(this.git3);
      this.gitInv4 = this.gitInv4 || invert$1(this.git4);
      this.gitInv5 = this.gitInv5 || invert$1(this.git5);
      this.gitInv6 = this.gitInv6 || invert$1(this.git6);
      this.gitInv7 = this.gitInv7 || invert$1(this.git7);
      this.gitBranchLabel0 = this.gitBranchLabel0 || invert$1(this.labelTextColor);
      this.gitBranchLabel1 = this.gitBranchLabel1 || this.labelTextColor;
      this.gitBranchLabel2 = this.gitBranchLabel2 || this.labelTextColor;
      this.gitBranchLabel3 = this.gitBranchLabel3 || invert$1(this.labelTextColor);
      this.gitBranchLabel4 = this.gitBranchLabel4 || this.labelTextColor;
      this.gitBranchLabel5 = this.gitBranchLabel5 || this.labelTextColor;
      this.gitBranchLabel6 = this.gitBranchLabel6 || this.labelTextColor;
      this.gitBranchLabel7 = this.gitBranchLabel7 || this.labelTextColor;
      this.tagLabelColor = this.tagLabelColor || this.primaryTextColor;
      this.tagLabelBackground = this.tagLabelBackground || this.primaryColor;
      this.tagLabelBorder = this.tagBorder || this.primaryBorderColor;
      this.tagLabelFontSize = this.tagLabelFontSize || "10px";
      this.commitLabelColor = this.commitLabelColor || this.secondaryTextColor;
      this.commitLabelBackground = this.commitLabelBackground || this.secondaryColor;
      this.commitLabelFontSize = this.commitLabelFontSize || "10px";
      this.attributeBackgroundColorOdd = this.attributeBackgroundColorOdd || lighten$1(this.background, 12);
      this.attributeBackgroundColorEven = this.attributeBackgroundColorEven || lighten$1(this.background, 2);
    }
    calculate(overrides) {
      if (typeof overrides !== "object") {
        this.updateColors();
        return;
      }
      const keys2 = Object.keys(overrides);
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
      this.updateColors();
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
    }
  };
  const getThemeVariables$3 = (userOverrides) => {
    const theme2 = new Theme$3();
    theme2.calculate(userOverrides);
    return theme2;
  };
  let Theme$2 = class Theme {
    constructor() {
      this.background = "#f4f4f4";
      this.primaryColor = "#ECECFF";
      this.secondaryColor = adjust$2(this.primaryColor, { h: 120 });
      this.secondaryColor = "#ffffde";
      this.tertiaryColor = adjust$2(this.primaryColor, { h: -160 });
      this.primaryBorderColor = mkBorder(this.primaryColor, this.darkMode);
      this.secondaryBorderColor = mkBorder(this.secondaryColor, this.darkMode);
      this.tertiaryBorderColor = mkBorder(this.tertiaryColor, this.darkMode);
      this.primaryTextColor = invert$1(this.primaryColor);
      this.secondaryTextColor = invert$1(this.secondaryColor);
      this.tertiaryTextColor = invert$1(this.tertiaryColor);
      this.lineColor = invert$1(this.background);
      this.textColor = invert$1(this.background);
      this.background = "white";
      this.mainBkg = "#ECECFF";
      this.secondBkg = "#ffffde";
      this.lineColor = "#333333";
      this.border1 = "#9370DB";
      this.border2 = "#aaaa33";
      this.arrowheadColor = "#333333";
      this.fontFamily = '"trebuchet ms", verdana, arial, sans-serif';
      this.fontSize = "16px";
      this.labelBackground = "#e8e8e8";
      this.textColor = "#333";
      this.THEME_COLOR_LIMIT = 12;
      this.nodeBkg = "calculated";
      this.nodeBorder = "calculated";
      this.clusterBkg = "calculated";
      this.clusterBorder = "calculated";
      this.defaultLinkColor = "calculated";
      this.titleColor = "calculated";
      this.edgeLabelBackground = "calculated";
      this.actorBorder = "calculated";
      this.actorBkg = "calculated";
      this.actorTextColor = "black";
      this.actorLineColor = "grey";
      this.signalColor = "calculated";
      this.signalTextColor = "calculated";
      this.labelBoxBkgColor = "calculated";
      this.labelBoxBorderColor = "calculated";
      this.labelTextColor = "calculated";
      this.loopTextColor = "calculated";
      this.noteBorderColor = "calculated";
      this.noteBkgColor = "#fff5ad";
      this.noteTextColor = "calculated";
      this.activationBorderColor = "#666";
      this.activationBkgColor = "#f4f4f4";
      this.sequenceNumberColor = "white";
      this.sectionBkgColor = "calculated";
      this.altSectionBkgColor = "calculated";
      this.sectionBkgColor2 = "calculated";
      this.excludeBkgColor = "#eeeeee";
      this.taskBorderColor = "calculated";
      this.taskBkgColor = "calculated";
      this.taskTextLightColor = "calculated";
      this.taskTextColor = this.taskTextLightColor;
      this.taskTextDarkColor = "calculated";
      this.taskTextOutsideColor = this.taskTextDarkColor;
      this.taskTextClickableColor = "calculated";
      this.activeTaskBorderColor = "calculated";
      this.activeTaskBkgColor = "calculated";
      this.gridColor = "calculated";
      this.doneTaskBkgColor = "calculated";
      this.doneTaskBorderColor = "calculated";
      this.critBorderColor = "calculated";
      this.critBkgColor = "calculated";
      this.todayLineColor = "calculated";
      this.sectionBkgColor = rgba$1(102, 102, 255, 0.49);
      this.altSectionBkgColor = "white";
      this.sectionBkgColor2 = "#fff400";
      this.taskBorderColor = "#534fbc";
      this.taskBkgColor = "#8a90dd";
      this.taskTextLightColor = "white";
      this.taskTextColor = "calculated";
      this.taskTextDarkColor = "black";
      this.taskTextOutsideColor = "calculated";
      this.taskTextClickableColor = "#003163";
      this.activeTaskBorderColor = "#534fbc";
      this.activeTaskBkgColor = "#bfc7ff";
      this.gridColor = "lightgrey";
      this.doneTaskBkgColor = "lightgrey";
      this.doneTaskBorderColor = "grey";
      this.critBorderColor = "#ff8888";
      this.critBkgColor = "red";
      this.todayLineColor = "red";
      this.personBorder = this.primaryBorderColor;
      this.personBkg = this.mainBkg;
      this.labelColor = "black";
      this.errorBkgColor = "#552222";
      this.errorTextColor = "#552222";
      this.updateColors();
    }
    updateColors() {
      this.cScale0 = this.cScale0 || this.primaryColor;
      this.cScale1 = this.cScale1 || this.secondaryColor;
      this.cScale2 = this.cScale2 || this.tertiaryColor;
      this.cScale3 = this.cScale3 || adjust$2(this.primaryColor, { h: 30 });
      this.cScale4 = this.cScale4 || adjust$2(this.primaryColor, { h: 60 });
      this.cScale5 = this.cScale5 || adjust$2(this.primaryColor, { h: 90 });
      this.cScale6 = this.cScale6 || adjust$2(this.primaryColor, { h: 120 });
      this.cScale7 = this.cScale7 || adjust$2(this.primaryColor, { h: 150 });
      this.cScale8 = this.cScale8 || adjust$2(this.primaryColor, { h: 210 });
      this.cScale9 = this.cScale9 || adjust$2(this.primaryColor, { h: 270 });
      this.cScale10 = this.cScale10 || adjust$2(this.primaryColor, { h: 300 });
      this.cScale11 = this.cScale11 || adjust$2(this.primaryColor, { h: 330 });
      this["cScalePeer1"] = this["cScalePeer1"] || darken$1(this.secondaryColor, 45);
      this["cScalePeer2"] = this["cScalePeer2"] || darken$1(this.tertiaryColor, 40);
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScale" + i2] = darken$1(this["cScale" + i2], 10);
        this["cScalePeer" + i2] = this["cScalePeer" + i2] || darken$1(this["cScale" + i2], 25);
      }
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScaleInv" + i2] = this["cScaleInv" + i2] || adjust$2(this["cScale" + i2], { h: 180 });
      }
      for (let i2 = 0; i2 < 5; i2++) {
        this["surface" + i2] = this["surface" + i2] || adjust$2(this.mainBkg, { h: 30, l: -(5 + i2 * 5) });
        this["surfacePeer" + i2] = this["surfacePeer" + i2] || adjust$2(this.mainBkg, { h: 30, l: -(7 + i2 * 5) });
      }
      this.scaleLabelColor = this.scaleLabelColor !== "calculated" && this.scaleLabelColor ? this.scaleLabelColor : this.labelTextColor;
      if (this.labelTextColor !== "calculated") {
        this.cScaleLabel0 = this.cScaleLabel0 || invert$1(this.labelTextColor);
        this.cScaleLabel3 = this.cScaleLabel3 || invert$1(this.labelTextColor);
        for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
          this["cScaleLabel" + i2] = this["cScaleLabel" + i2] || this.labelTextColor;
        }
      }
      this.nodeBkg = this.mainBkg;
      this.nodeBorder = this.border1;
      this.clusterBkg = this.secondBkg;
      this.clusterBorder = this.border2;
      this.defaultLinkColor = this.lineColor;
      this.titleColor = this.textColor;
      this.edgeLabelBackground = this.labelBackground;
      this.actorBorder = lighten$1(this.border1, 23);
      this.actorBkg = this.mainBkg;
      this.labelBoxBkgColor = this.actorBkg;
      this.signalColor = this.textColor;
      this.signalTextColor = this.textColor;
      this.labelBoxBorderColor = this.actorBorder;
      this.labelTextColor = this.actorTextColor;
      this.loopTextColor = this.actorTextColor;
      this.noteBorderColor = this.border2;
      this.noteTextColor = this.actorTextColor;
      this.taskTextColor = this.taskTextLightColor;
      this.taskTextOutsideColor = this.taskTextDarkColor;
      this.transitionColor = this.transitionColor || this.lineColor;
      this.transitionLabelColor = this.transitionLabelColor || this.textColor;
      this.stateLabelColor = this.stateLabelColor || this.stateBkg || this.primaryTextColor;
      this.stateBkg = this.stateBkg || this.mainBkg;
      this.labelBackgroundColor = this.labelBackgroundColor || this.stateBkg;
      this.compositeBackground = this.compositeBackground || this.background || this.tertiaryColor;
      this.altBackground = this.altBackground || "#f0f0f0";
      this.compositeTitleBackground = this.compositeTitleBackground || this.mainBkg;
      this.compositeBorder = this.compositeBorder || this.nodeBorder;
      this.innerEndBackground = this.nodeBorder;
      this.specialStateColor = this.lineColor;
      this.errorBkgColor = this.errorBkgColor || this.tertiaryColor;
      this.errorTextColor = this.errorTextColor || this.tertiaryTextColor;
      this.transitionColor = this.transitionColor || this.lineColor;
      this.classText = this.primaryTextColor;
      this.fillType0 = this.primaryColor;
      this.fillType1 = this.secondaryColor;
      this.fillType2 = adjust$2(this.primaryColor, { h: 64 });
      this.fillType3 = adjust$2(this.secondaryColor, { h: 64 });
      this.fillType4 = adjust$2(this.primaryColor, { h: -64 });
      this.fillType5 = adjust$2(this.secondaryColor, { h: -64 });
      this.fillType6 = adjust$2(this.primaryColor, { h: 128 });
      this.fillType7 = adjust$2(this.secondaryColor, { h: 128 });
      this.pie1 = this.pie1 || this.primaryColor;
      this.pie2 = this.pie2 || this.secondaryColor;
      this.pie3 = this.pie3 || adjust$2(this.tertiaryColor, { l: -40 });
      this.pie4 = this.pie4 || adjust$2(this.primaryColor, { l: -10 });
      this.pie5 = this.pie5 || adjust$2(this.secondaryColor, { l: -30 });
      this.pie6 = this.pie6 || adjust$2(this.tertiaryColor, { l: -20 });
      this.pie7 = this.pie7 || adjust$2(this.primaryColor, { h: 60, l: -20 });
      this.pie8 = this.pie8 || adjust$2(this.primaryColor, { h: -60, l: -40 });
      this.pie9 = this.pie9 || adjust$2(this.primaryColor, { h: 120, l: -40 });
      this.pie10 = this.pie10 || adjust$2(this.primaryColor, { h: 60, l: -40 });
      this.pie11 = this.pie11 || adjust$2(this.primaryColor, { h: -90, l: -40 });
      this.pie12 = this.pie12 || adjust$2(this.primaryColor, { h: 120, l: -30 });
      this.pieTitleTextSize = this.pieTitleTextSize || "25px";
      this.pieTitleTextColor = this.pieTitleTextColor || this.taskTextDarkColor;
      this.pieSectionTextSize = this.pieSectionTextSize || "17px";
      this.pieSectionTextColor = this.pieSectionTextColor || this.textColor;
      this.pieLegendTextSize = this.pieLegendTextSize || "17px";
      this.pieLegendTextColor = this.pieLegendTextColor || this.taskTextDarkColor;
      this.pieStrokeColor = this.pieStrokeColor || "black";
      this.pieStrokeWidth = this.pieStrokeWidth || "2px";
      this.pieOuterStrokeWidth = this.pieOuterStrokeWidth || "2px";
      this.pieOuterStrokeColor = this.pieOuterStrokeColor || "black";
      this.pieOpacity = this.pieOpacity || "0.7";
      this.quadrant1Fill = this.quadrant1Fill || this.primaryColor;
      this.quadrant2Fill = this.quadrant2Fill || adjust$2(this.primaryColor, { r: 5, g: 5, b: 5 });
      this.quadrant3Fill = this.quadrant3Fill || adjust$2(this.primaryColor, { r: 10, g: 10, b: 10 });
      this.quadrant4Fill = this.quadrant4Fill || adjust$2(this.primaryColor, { r: 15, g: 15, b: 15 });
      this.quadrant1TextFill = this.quadrant1TextFill || this.primaryTextColor;
      this.quadrant2TextFill = this.quadrant2TextFill || adjust$2(this.primaryTextColor, { r: -5, g: -5, b: -5 });
      this.quadrant3TextFill = this.quadrant3TextFill || adjust$2(this.primaryTextColor, { r: -10, g: -10, b: -10 });
      this.quadrant4TextFill = this.quadrant4TextFill || adjust$2(this.primaryTextColor, { r: -15, g: -15, b: -15 });
      this.quadrantPointFill = this.quadrantPointFill || isDark$1(this.quadrant1Fill) ? lighten$1(this.quadrant1Fill) : darken$1(this.quadrant1Fill);
      this.quadrantPointTextFill = this.quadrantPointTextFill || this.primaryTextColor;
      this.quadrantXAxisTextFill = this.quadrantXAxisTextFill || this.primaryTextColor;
      this.quadrantYAxisTextFill = this.quadrantYAxisTextFill || this.primaryTextColor;
      this.quadrantInternalBorderStrokeFill = this.quadrantInternalBorderStrokeFill || this.primaryBorderColor;
      this.quadrantExternalBorderStrokeFill = this.quadrantExternalBorderStrokeFill || this.primaryBorderColor;
      this.quadrantTitleFill = this.quadrantTitleFill || this.primaryTextColor;
      this.requirementBackground = this.requirementBackground || this.primaryColor;
      this.requirementBorderColor = this.requirementBorderColor || this.primaryBorderColor;
      this.requirementBorderSize = this.requirementBorderSize || "1";
      this.requirementTextColor = this.requirementTextColor || this.primaryTextColor;
      this.relationColor = this.relationColor || this.lineColor;
      this.relationLabelBackground = this.relationLabelBackground || this.labelBackground;
      this.relationLabelColor = this.relationLabelColor || this.actorTextColor;
      this.git0 = this.git0 || this.primaryColor;
      this.git1 = this.git1 || this.secondaryColor;
      this.git2 = this.git2 || this.tertiaryColor;
      this.git3 = this.git3 || adjust$2(this.primaryColor, { h: -30 });
      this.git4 = this.git4 || adjust$2(this.primaryColor, { h: -60 });
      this.git5 = this.git5 || adjust$2(this.primaryColor, { h: -90 });
      this.git6 = this.git6 || adjust$2(this.primaryColor, { h: 60 });
      this.git7 = this.git7 || adjust$2(this.primaryColor, { h: 120 });
      if (this.darkMode) {
        this.git0 = lighten$1(this.git0, 25);
        this.git1 = lighten$1(this.git1, 25);
        this.git2 = lighten$1(this.git2, 25);
        this.git3 = lighten$1(this.git3, 25);
        this.git4 = lighten$1(this.git4, 25);
        this.git5 = lighten$1(this.git5, 25);
        this.git6 = lighten$1(this.git6, 25);
        this.git7 = lighten$1(this.git7, 25);
      } else {
        this.git0 = darken$1(this.git0, 25);
        this.git1 = darken$1(this.git1, 25);
        this.git2 = darken$1(this.git2, 25);
        this.git3 = darken$1(this.git3, 25);
        this.git4 = darken$1(this.git4, 25);
        this.git5 = darken$1(this.git5, 25);
        this.git6 = darken$1(this.git6, 25);
        this.git7 = darken$1(this.git7, 25);
      }
      this.gitInv0 = this.gitInv0 || darken$1(invert$1(this.git0), 25);
      this.gitInv1 = this.gitInv1 || invert$1(this.git1);
      this.gitInv2 = this.gitInv2 || invert$1(this.git2);
      this.gitInv3 = this.gitInv3 || invert$1(this.git3);
      this.gitInv4 = this.gitInv4 || invert$1(this.git4);
      this.gitInv5 = this.gitInv5 || invert$1(this.git5);
      this.gitInv6 = this.gitInv6 || invert$1(this.git6);
      this.gitInv7 = this.gitInv7 || invert$1(this.git7);
      this.gitBranchLabel0 = this.gitBranchLabel0 || invert$1(this.labelTextColor);
      this.gitBranchLabel1 = this.gitBranchLabel1 || this.labelTextColor;
      this.gitBranchLabel2 = this.gitBranchLabel2 || this.labelTextColor;
      this.gitBranchLabel3 = this.gitBranchLabel3 || invert$1(this.labelTextColor);
      this.gitBranchLabel4 = this.gitBranchLabel4 || this.labelTextColor;
      this.gitBranchLabel5 = this.gitBranchLabel5 || this.labelTextColor;
      this.gitBranchLabel6 = this.gitBranchLabel6 || this.labelTextColor;
      this.gitBranchLabel7 = this.gitBranchLabel7 || this.labelTextColor;
      this.tagLabelColor = this.tagLabelColor || this.primaryTextColor;
      this.tagLabelBackground = this.tagLabelBackground || this.primaryColor;
      this.tagLabelBorder = this.tagBorder || this.primaryBorderColor;
      this.tagLabelFontSize = this.tagLabelFontSize || "10px";
      this.commitLabelColor = this.commitLabelColor || this.secondaryTextColor;
      this.commitLabelBackground = this.commitLabelBackground || this.secondaryColor;
      this.commitLabelFontSize = this.commitLabelFontSize || "10px";
      this.attributeBackgroundColorOdd = this.attributeBackgroundColorOdd || oldAttributeBackgroundColorOdd;
      this.attributeBackgroundColorEven = this.attributeBackgroundColorEven || oldAttributeBackgroundColorEven;
    }
    calculate(overrides) {
      if (typeof overrides !== "object") {
        this.updateColors();
        return;
      }
      const keys2 = Object.keys(overrides);
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
      this.updateColors();
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
    }
  };
  const getThemeVariables$2 = (userOverrides) => {
    const theme2 = new Theme$2();
    theme2.calculate(userOverrides);
    return theme2;
  };
  let Theme$1 = class Theme {
    constructor() {
      this.background = "#f4f4f4";
      this.primaryColor = "#cde498";
      this.secondaryColor = "#cdffb2";
      this.background = "white";
      this.mainBkg = "#cde498";
      this.secondBkg = "#cdffb2";
      this.lineColor = "green";
      this.border1 = "#13540c";
      this.border2 = "#6eaa49";
      this.arrowheadColor = "green";
      this.fontFamily = '"trebuchet ms", verdana, arial, sans-serif';
      this.fontSize = "16px";
      this.tertiaryColor = lighten$1("#cde498", 10);
      this.primaryBorderColor = mkBorder(this.primaryColor, this.darkMode);
      this.secondaryBorderColor = mkBorder(this.secondaryColor, this.darkMode);
      this.tertiaryBorderColor = mkBorder(this.tertiaryColor, this.darkMode);
      this.primaryTextColor = invert$1(this.primaryColor);
      this.secondaryTextColor = invert$1(this.secondaryColor);
      this.tertiaryTextColor = invert$1(this.primaryColor);
      this.lineColor = invert$1(this.background);
      this.textColor = invert$1(this.background);
      this.THEME_COLOR_LIMIT = 12;
      this.nodeBkg = "calculated";
      this.nodeBorder = "calculated";
      this.clusterBkg = "calculated";
      this.clusterBorder = "calculated";
      this.defaultLinkColor = "calculated";
      this.titleColor = "#333";
      this.edgeLabelBackground = "#e8e8e8";
      this.actorBorder = "calculated";
      this.actorBkg = "calculated";
      this.actorTextColor = "black";
      this.actorLineColor = "grey";
      this.signalColor = "#333";
      this.signalTextColor = "#333";
      this.labelBoxBkgColor = "calculated";
      this.labelBoxBorderColor = "#326932";
      this.labelTextColor = "calculated";
      this.loopTextColor = "calculated";
      this.noteBorderColor = "calculated";
      this.noteBkgColor = "#fff5ad";
      this.noteTextColor = "calculated";
      this.activationBorderColor = "#666";
      this.activationBkgColor = "#f4f4f4";
      this.sequenceNumberColor = "white";
      this.sectionBkgColor = "#6eaa49";
      this.altSectionBkgColor = "white";
      this.sectionBkgColor2 = "#6eaa49";
      this.excludeBkgColor = "#eeeeee";
      this.taskBorderColor = "calculated";
      this.taskBkgColor = "#487e3a";
      this.taskTextLightColor = "white";
      this.taskTextColor = "calculated";
      this.taskTextDarkColor = "black";
      this.taskTextOutsideColor = "calculated";
      this.taskTextClickableColor = "#003163";
      this.activeTaskBorderColor = "calculated";
      this.activeTaskBkgColor = "calculated";
      this.gridColor = "lightgrey";
      this.doneTaskBkgColor = "lightgrey";
      this.doneTaskBorderColor = "grey";
      this.critBorderColor = "#ff8888";
      this.critBkgColor = "red";
      this.todayLineColor = "red";
      this.personBorder = this.primaryBorderColor;
      this.personBkg = this.mainBkg;
      this.labelColor = "black";
      this.errorBkgColor = "#552222";
      this.errorTextColor = "#552222";
    }
    updateColors() {
      this.actorBorder = darken$1(this.mainBkg, 20);
      this.actorBkg = this.mainBkg;
      this.labelBoxBkgColor = this.actorBkg;
      this.labelTextColor = this.actorTextColor;
      this.loopTextColor = this.actorTextColor;
      this.noteBorderColor = this.border2;
      this.noteTextColor = this.actorTextColor;
      this.cScale0 = this.cScale0 || this.primaryColor;
      this.cScale1 = this.cScale1 || this.secondaryColor;
      this.cScale2 = this.cScale2 || this.tertiaryColor;
      this.cScale3 = this.cScale3 || adjust$2(this.primaryColor, { h: 30 });
      this.cScale4 = this.cScale4 || adjust$2(this.primaryColor, { h: 60 });
      this.cScale5 = this.cScale5 || adjust$2(this.primaryColor, { h: 90 });
      this.cScale6 = this.cScale6 || adjust$2(this.primaryColor, { h: 120 });
      this.cScale7 = this.cScale7 || adjust$2(this.primaryColor, { h: 150 });
      this.cScale8 = this.cScale8 || adjust$2(this.primaryColor, { h: 210 });
      this.cScale9 = this.cScale9 || adjust$2(this.primaryColor, { h: 270 });
      this.cScale10 = this.cScale10 || adjust$2(this.primaryColor, { h: 300 });
      this.cScale11 = this.cScale11 || adjust$2(this.primaryColor, { h: 330 });
      this["cScalePeer1"] = this["cScalePeer1"] || darken$1(this.secondaryColor, 45);
      this["cScalePeer2"] = this["cScalePeer2"] || darken$1(this.tertiaryColor, 40);
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScale" + i2] = darken$1(this["cScale" + i2], 10);
        this["cScalePeer" + i2] = this["cScalePeer" + i2] || darken$1(this["cScale" + i2], 25);
      }
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScaleInv" + i2] = this["cScaleInv" + i2] || adjust$2(this["cScale" + i2], { h: 180 });
      }
      this.scaleLabelColor = this.scaleLabelColor !== "calculated" && this.scaleLabelColor ? this.scaleLabelColor : this.labelTextColor;
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScaleLabel" + i2] = this["cScaleLabel" + i2] || this.scaleLabelColor;
      }
      for (let i2 = 0; i2 < 5; i2++) {
        this["surface" + i2] = this["surface" + i2] || adjust$2(this.mainBkg, { h: 30, s: -30, l: -(5 + i2 * 5) });
        this["surfacePeer" + i2] = this["surfacePeer" + i2] || adjust$2(this.mainBkg, { h: 30, s: -30, l: -(8 + i2 * 5) });
      }
      this.nodeBkg = this.mainBkg;
      this.nodeBorder = this.border1;
      this.clusterBkg = this.secondBkg;
      this.clusterBorder = this.border2;
      this.defaultLinkColor = this.lineColor;
      this.taskBorderColor = this.border1;
      this.taskTextColor = this.taskTextLightColor;
      this.taskTextOutsideColor = this.taskTextDarkColor;
      this.activeTaskBorderColor = this.taskBorderColor;
      this.activeTaskBkgColor = this.mainBkg;
      this.transitionColor = this.transitionColor || this.lineColor;
      this.transitionLabelColor = this.transitionLabelColor || this.textColor;
      this.stateLabelColor = this.stateLabelColor || this.stateBkg || this.primaryTextColor;
      this.stateBkg = this.stateBkg || this.mainBkg;
      this.labelBackgroundColor = this.labelBackgroundColor || this.stateBkg;
      this.compositeBackground = this.compositeBackground || this.background || this.tertiaryColor;
      this.altBackground = this.altBackground || "#f0f0f0";
      this.compositeTitleBackground = this.compositeTitleBackground || this.mainBkg;
      this.compositeBorder = this.compositeBorder || this.nodeBorder;
      this.innerEndBackground = this.primaryBorderColor;
      this.specialStateColor = this.lineColor;
      this.errorBkgColor = this.errorBkgColor || this.tertiaryColor;
      this.errorTextColor = this.errorTextColor || this.tertiaryTextColor;
      this.transitionColor = this.transitionColor || this.lineColor;
      this.classText = this.primaryTextColor;
      this.fillType0 = this.primaryColor;
      this.fillType1 = this.secondaryColor;
      this.fillType2 = adjust$2(this.primaryColor, { h: 64 });
      this.fillType3 = adjust$2(this.secondaryColor, { h: 64 });
      this.fillType4 = adjust$2(this.primaryColor, { h: -64 });
      this.fillType5 = adjust$2(this.secondaryColor, { h: -64 });
      this.fillType6 = adjust$2(this.primaryColor, { h: 128 });
      this.fillType7 = adjust$2(this.secondaryColor, { h: 128 });
      this.pie1 = this.pie1 || this.primaryColor;
      this.pie2 = this.pie2 || this.secondaryColor;
      this.pie3 = this.pie3 || this.tertiaryColor;
      this.pie4 = this.pie4 || adjust$2(this.primaryColor, { l: -30 });
      this.pie5 = this.pie5 || adjust$2(this.secondaryColor, { l: -30 });
      this.pie6 = this.pie6 || adjust$2(this.tertiaryColor, { h: 40, l: -40 });
      this.pie7 = this.pie7 || adjust$2(this.primaryColor, { h: 60, l: -10 });
      this.pie8 = this.pie8 || adjust$2(this.primaryColor, { h: -60, l: -10 });
      this.pie9 = this.pie9 || adjust$2(this.primaryColor, { h: 120, l: 0 });
      this.pie10 = this.pie10 || adjust$2(this.primaryColor, { h: 60, l: -50 });
      this.pie11 = this.pie11 || adjust$2(this.primaryColor, { h: -60, l: -50 });
      this.pie12 = this.pie12 || adjust$2(this.primaryColor, { h: 120, l: -50 });
      this.pieTitleTextSize = this.pieTitleTextSize || "25px";
      this.pieTitleTextColor = this.pieTitleTextColor || this.taskTextDarkColor;
      this.pieSectionTextSize = this.pieSectionTextSize || "17px";
      this.pieSectionTextColor = this.pieSectionTextColor || this.textColor;
      this.pieLegendTextSize = this.pieLegendTextSize || "17px";
      this.pieLegendTextColor = this.pieLegendTextColor || this.taskTextDarkColor;
      this.pieStrokeColor = this.pieStrokeColor || "black";
      this.pieStrokeWidth = this.pieStrokeWidth || "2px";
      this.pieOuterStrokeWidth = this.pieOuterStrokeWidth || "2px";
      this.pieOuterStrokeColor = this.pieOuterStrokeColor || "black";
      this.pieOpacity = this.pieOpacity || "0.7";
      this.quadrant1Fill = this.quadrant1Fill || this.primaryColor;
      this.quadrant2Fill = this.quadrant2Fill || adjust$2(this.primaryColor, { r: 5, g: 5, b: 5 });
      this.quadrant3Fill = this.quadrant3Fill || adjust$2(this.primaryColor, { r: 10, g: 10, b: 10 });
      this.quadrant4Fill = this.quadrant4Fill || adjust$2(this.primaryColor, { r: 15, g: 15, b: 15 });
      this.quadrant1TextFill = this.quadrant1TextFill || this.primaryTextColor;
      this.quadrant2TextFill = this.quadrant2TextFill || adjust$2(this.primaryTextColor, { r: -5, g: -5, b: -5 });
      this.quadrant3TextFill = this.quadrant3TextFill || adjust$2(this.primaryTextColor, { r: -10, g: -10, b: -10 });
      this.quadrant4TextFill = this.quadrant4TextFill || adjust$2(this.primaryTextColor, { r: -15, g: -15, b: -15 });
      this.quadrantPointFill = this.quadrantPointFill || isDark$1(this.quadrant1Fill) ? lighten$1(this.quadrant1Fill) : darken$1(this.quadrant1Fill);
      this.quadrantPointTextFill = this.quadrantPointTextFill || this.primaryTextColor;
      this.quadrantXAxisTextFill = this.quadrantXAxisTextFill || this.primaryTextColor;
      this.quadrantYAxisTextFill = this.quadrantYAxisTextFill || this.primaryTextColor;
      this.quadrantInternalBorderStrokeFill = this.quadrantInternalBorderStrokeFill || this.primaryBorderColor;
      this.quadrantExternalBorderStrokeFill = this.quadrantExternalBorderStrokeFill || this.primaryBorderColor;
      this.quadrantTitleFill = this.quadrantTitleFill || this.primaryTextColor;
      this.requirementBackground = this.requirementBackground || this.primaryColor;
      this.requirementBorderColor = this.requirementBorderColor || this.primaryBorderColor;
      this.requirementBorderSize = this.requirementBorderSize || "1";
      this.requirementTextColor = this.requirementTextColor || this.primaryTextColor;
      this.relationColor = this.relationColor || this.lineColor;
      this.relationLabelBackground = this.relationLabelBackground || this.edgeLabelBackground;
      this.relationLabelColor = this.relationLabelColor || this.actorTextColor;
      this.git0 = this.git0 || this.primaryColor;
      this.git1 = this.git1 || this.secondaryColor;
      this.git2 = this.git2 || this.tertiaryColor;
      this.git3 = this.git3 || adjust$2(this.primaryColor, { h: -30 });
      this.git4 = this.git4 || adjust$2(this.primaryColor, { h: -60 });
      this.git5 = this.git5 || adjust$2(this.primaryColor, { h: -90 });
      this.git6 = this.git6 || adjust$2(this.primaryColor, { h: 60 });
      this.git7 = this.git7 || adjust$2(this.primaryColor, { h: 120 });
      if (this.darkMode) {
        this.git0 = lighten$1(this.git0, 25);
        this.git1 = lighten$1(this.git1, 25);
        this.git2 = lighten$1(this.git2, 25);
        this.git3 = lighten$1(this.git3, 25);
        this.git4 = lighten$1(this.git4, 25);
        this.git5 = lighten$1(this.git5, 25);
        this.git6 = lighten$1(this.git6, 25);
        this.git7 = lighten$1(this.git7, 25);
      } else {
        this.git0 = darken$1(this.git0, 25);
        this.git1 = darken$1(this.git1, 25);
        this.git2 = darken$1(this.git2, 25);
        this.git3 = darken$1(this.git3, 25);
        this.git4 = darken$1(this.git4, 25);
        this.git5 = darken$1(this.git5, 25);
        this.git6 = darken$1(this.git6, 25);
        this.git7 = darken$1(this.git7, 25);
      }
      this.gitInv0 = this.gitInv0 || invert$1(this.git0);
      this.gitInv1 = this.gitInv1 || invert$1(this.git1);
      this.gitInv2 = this.gitInv2 || invert$1(this.git2);
      this.gitInv3 = this.gitInv3 || invert$1(this.git3);
      this.gitInv4 = this.gitInv4 || invert$1(this.git4);
      this.gitInv5 = this.gitInv5 || invert$1(this.git5);
      this.gitInv6 = this.gitInv6 || invert$1(this.git6);
      this.gitInv7 = this.gitInv7 || invert$1(this.git7);
      this.gitBranchLabel0 = this.gitBranchLabel0 || invert$1(this.labelTextColor);
      this.gitBranchLabel1 = this.gitBranchLabel1 || this.labelTextColor;
      this.gitBranchLabel2 = this.gitBranchLabel2 || this.labelTextColor;
      this.gitBranchLabel3 = this.gitBranchLabel3 || invert$1(this.labelTextColor);
      this.gitBranchLabel4 = this.gitBranchLabel4 || this.labelTextColor;
      this.gitBranchLabel5 = this.gitBranchLabel5 || this.labelTextColor;
      this.gitBranchLabel6 = this.gitBranchLabel6 || this.labelTextColor;
      this.gitBranchLabel7 = this.gitBranchLabel7 || this.labelTextColor;
      this.tagLabelColor = this.tagLabelColor || this.primaryTextColor;
      this.tagLabelBackground = this.tagLabelBackground || this.primaryColor;
      this.tagLabelBorder = this.tagBorder || this.primaryBorderColor;
      this.tagLabelFontSize = this.tagLabelFontSize || "10px";
      this.commitLabelColor = this.commitLabelColor || this.secondaryTextColor;
      this.commitLabelBackground = this.commitLabelBackground || this.secondaryColor;
      this.commitLabelFontSize = this.commitLabelFontSize || "10px";
      this.attributeBackgroundColorOdd = this.attributeBackgroundColorOdd || oldAttributeBackgroundColorOdd;
      this.attributeBackgroundColorEven = this.attributeBackgroundColorEven || oldAttributeBackgroundColorEven;
    }
    calculate(overrides) {
      if (typeof overrides !== "object") {
        this.updateColors();
        return;
      }
      const keys2 = Object.keys(overrides);
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
      this.updateColors();
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
    }
  };
  const getThemeVariables$1 = (userOverrides) => {
    const theme2 = new Theme$1();
    theme2.calculate(userOverrides);
    return theme2;
  };
  class Theme {
    constructor() {
      this.primaryColor = "#eee";
      this.contrast = "#707070";
      this.secondaryColor = lighten$1(this.contrast, 55);
      this.background = "#ffffff";
      this.tertiaryColor = adjust$2(this.primaryColor, { h: -160 });
      this.primaryBorderColor = mkBorder(this.primaryColor, this.darkMode);
      this.secondaryBorderColor = mkBorder(this.secondaryColor, this.darkMode);
      this.tertiaryBorderColor = mkBorder(this.tertiaryColor, this.darkMode);
      this.primaryTextColor = invert$1(this.primaryColor);
      this.secondaryTextColor = invert$1(this.secondaryColor);
      this.tertiaryTextColor = invert$1(this.tertiaryColor);
      this.lineColor = invert$1(this.background);
      this.textColor = invert$1(this.background);
      this.mainBkg = "#eee";
      this.secondBkg = "calculated";
      this.lineColor = "#666";
      this.border1 = "#999";
      this.border2 = "calculated";
      this.note = "#ffa";
      this.text = "#333";
      this.critical = "#d42";
      this.done = "#bbb";
      this.arrowheadColor = "#333333";
      this.fontFamily = '"trebuchet ms", verdana, arial, sans-serif';
      this.fontSize = "16px";
      this.THEME_COLOR_LIMIT = 12;
      this.nodeBkg = "calculated";
      this.nodeBorder = "calculated";
      this.clusterBkg = "calculated";
      this.clusterBorder = "calculated";
      this.defaultLinkColor = "calculated";
      this.titleColor = "calculated";
      this.edgeLabelBackground = "white";
      this.actorBorder = "calculated";
      this.actorBkg = "calculated";
      this.actorTextColor = "calculated";
      this.actorLineColor = "calculated";
      this.signalColor = "calculated";
      this.signalTextColor = "calculated";
      this.labelBoxBkgColor = "calculated";
      this.labelBoxBorderColor = "calculated";
      this.labelTextColor = "calculated";
      this.loopTextColor = "calculated";
      this.noteBorderColor = "calculated";
      this.noteBkgColor = "calculated";
      this.noteTextColor = "calculated";
      this.activationBorderColor = "#666";
      this.activationBkgColor = "#f4f4f4";
      this.sequenceNumberColor = "white";
      this.sectionBkgColor = "calculated";
      this.altSectionBkgColor = "white";
      this.sectionBkgColor2 = "calculated";
      this.excludeBkgColor = "#eeeeee";
      this.taskBorderColor = "calculated";
      this.taskBkgColor = "calculated";
      this.taskTextLightColor = "white";
      this.taskTextColor = "calculated";
      this.taskTextDarkColor = "calculated";
      this.taskTextOutsideColor = "calculated";
      this.taskTextClickableColor = "#003163";
      this.activeTaskBorderColor = "calculated";
      this.activeTaskBkgColor = "calculated";
      this.gridColor = "calculated";
      this.doneTaskBkgColor = "calculated";
      this.doneTaskBorderColor = "calculated";
      this.critBkgColor = "calculated";
      this.critBorderColor = "calculated";
      this.todayLineColor = "calculated";
      this.personBorder = this.primaryBorderColor;
      this.personBkg = this.mainBkg;
      this.labelColor = "black";
      this.errorBkgColor = "#552222";
      this.errorTextColor = "#552222";
    }
    updateColors() {
      this.secondBkg = lighten$1(this.contrast, 55);
      this.border2 = this.contrast;
      this.actorBorder = lighten$1(this.border1, 23);
      this.actorBkg = this.mainBkg;
      this.actorTextColor = this.text;
      this.actorLineColor = this.lineColor;
      this.signalColor = this.text;
      this.signalTextColor = this.text;
      this.labelBoxBkgColor = this.actorBkg;
      this.labelBoxBorderColor = this.actorBorder;
      this.labelTextColor = this.text;
      this.loopTextColor = this.text;
      this.noteBorderColor = "#999";
      this.noteBkgColor = "#666";
      this.noteTextColor = "#fff";
      this.cScale0 = this.cScale0 || "#555";
      this.cScale1 = this.cScale1 || "#F4F4F4";
      this.cScale2 = this.cScale2 || "#555";
      this.cScale3 = this.cScale3 || "#BBB";
      this.cScale4 = this.cScale4 || "#777";
      this.cScale5 = this.cScale5 || "#999";
      this.cScale6 = this.cScale6 || "#DDD";
      this.cScale7 = this.cScale7 || "#FFF";
      this.cScale8 = this.cScale8 || "#DDD";
      this.cScale9 = this.cScale9 || "#BBB";
      this.cScale10 = this.cScale10 || "#999";
      this.cScale11 = this.cScale11 || "#777";
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScaleInv" + i2] = this["cScaleInv" + i2] || invert$1(this["cScale" + i2]);
      }
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        if (this.darkMode) {
          this["cScalePeer" + i2] = this["cScalePeer" + i2] || lighten$1(this["cScale" + i2], 10);
        } else {
          this["cScalePeer" + i2] = this["cScalePeer" + i2] || darken$1(this["cScale" + i2], 10);
        }
      }
      this.scaleLabelColor = this.scaleLabelColor || (this.darkMode ? "black" : this.labelTextColor);
      this["cScaleLabel0"] = this["cScaleLabel0"] || this.cScale1;
      this["cScaleLabel2"] = this["cScaleLabel2"] || this.cScale1;
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScaleLabel" + i2] = this["cScaleLabel" + i2] || this.scaleLabelColor;
      }
      for (let i2 = 0; i2 < 5; i2++) {
        this["surface" + i2] = this["surface" + i2] || adjust$2(this.mainBkg, { l: -(5 + i2 * 5) });
        this["surfacePeer" + i2] = this["surfacePeer" + i2] || adjust$2(this.mainBkg, { l: -(8 + i2 * 5) });
      }
      this.nodeBkg = this.mainBkg;
      this.nodeBorder = this.border1;
      this.clusterBkg = this.secondBkg;
      this.clusterBorder = this.border2;
      this.defaultLinkColor = this.lineColor;
      this.titleColor = this.text;
      this.sectionBkgColor = lighten$1(this.contrast, 30);
      this.sectionBkgColor2 = lighten$1(this.contrast, 30);
      this.taskBorderColor = darken$1(this.contrast, 10);
      this.taskBkgColor = this.contrast;
      this.taskTextColor = this.taskTextLightColor;
      this.taskTextDarkColor = this.text;
      this.taskTextOutsideColor = this.taskTextDarkColor;
      this.activeTaskBorderColor = this.taskBorderColor;
      this.activeTaskBkgColor = this.mainBkg;
      this.gridColor = lighten$1(this.border1, 30);
      this.doneTaskBkgColor = this.done;
      this.doneTaskBorderColor = this.lineColor;
      this.critBkgColor = this.critical;
      this.critBorderColor = darken$1(this.critBkgColor, 10);
      this.todayLineColor = this.critBkgColor;
      this.transitionColor = this.transitionColor || "#000";
      this.transitionLabelColor = this.transitionLabelColor || this.textColor;
      this.stateLabelColor = this.stateLabelColor || this.stateBkg || this.primaryTextColor;
      this.stateBkg = this.stateBkg || this.mainBkg;
      this.labelBackgroundColor = this.labelBackgroundColor || this.stateBkg;
      this.compositeBackground = this.compositeBackground || this.background || this.tertiaryColor;
      this.altBackground = this.altBackground || "#f4f4f4";
      this.compositeTitleBackground = this.compositeTitleBackground || this.mainBkg;
      this.stateBorder = this.stateBorder || "#000";
      this.innerEndBackground = this.primaryBorderColor;
      this.specialStateColor = "#222";
      this.errorBkgColor = this.errorBkgColor || this.tertiaryColor;
      this.errorTextColor = this.errorTextColor || this.tertiaryTextColor;
      this.classText = this.primaryTextColor;
      this.fillType0 = this.primaryColor;
      this.fillType1 = this.secondaryColor;
      this.fillType2 = adjust$2(this.primaryColor, { h: 64 });
      this.fillType3 = adjust$2(this.secondaryColor, { h: 64 });
      this.fillType4 = adjust$2(this.primaryColor, { h: -64 });
      this.fillType5 = adjust$2(this.secondaryColor, { h: -64 });
      this.fillType6 = adjust$2(this.primaryColor, { h: 128 });
      this.fillType7 = adjust$2(this.secondaryColor, { h: 128 });
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["pie" + i2] = this["cScale" + i2];
      }
      this.pie12 = this.pie0;
      this.pieTitleTextSize = this.pieTitleTextSize || "25px";
      this.pieTitleTextColor = this.pieTitleTextColor || this.taskTextDarkColor;
      this.pieSectionTextSize = this.pieSectionTextSize || "17px";
      this.pieSectionTextColor = this.pieSectionTextColor || this.textColor;
      this.pieLegendTextSize = this.pieLegendTextSize || "17px";
      this.pieLegendTextColor = this.pieLegendTextColor || this.taskTextDarkColor;
      this.pieStrokeColor = this.pieStrokeColor || "black";
      this.pieStrokeWidth = this.pieStrokeWidth || "2px";
      this.pieOuterStrokeWidth = this.pieOuterStrokeWidth || "2px";
      this.pieOuterStrokeColor = this.pieOuterStrokeColor || "black";
      this.pieOpacity = this.pieOpacity || "0.7";
      this.quadrant1Fill = this.quadrant1Fill || this.primaryColor;
      this.quadrant2Fill = this.quadrant2Fill || adjust$2(this.primaryColor, { r: 5, g: 5, b: 5 });
      this.quadrant3Fill = this.quadrant3Fill || adjust$2(this.primaryColor, { r: 10, g: 10, b: 10 });
      this.quadrant4Fill = this.quadrant4Fill || adjust$2(this.primaryColor, { r: 15, g: 15, b: 15 });
      this.quadrant1TextFill = this.quadrant1TextFill || this.primaryTextColor;
      this.quadrant2TextFill = this.quadrant2TextFill || adjust$2(this.primaryTextColor, { r: -5, g: -5, b: -5 });
      this.quadrant3TextFill = this.quadrant3TextFill || adjust$2(this.primaryTextColor, { r: -10, g: -10, b: -10 });
      this.quadrant4TextFill = this.quadrant4TextFill || adjust$2(this.primaryTextColor, { r: -15, g: -15, b: -15 });
      this.quadrantPointFill = this.quadrantPointFill || isDark$1(this.quadrant1Fill) ? lighten$1(this.quadrant1Fill) : darken$1(this.quadrant1Fill);
      this.quadrantPointTextFill = this.quadrantPointTextFill || this.primaryTextColor;
      this.quadrantXAxisTextFill = this.quadrantXAxisTextFill || this.primaryTextColor;
      this.quadrantYAxisTextFill = this.quadrantYAxisTextFill || this.primaryTextColor;
      this.quadrantInternalBorderStrokeFill = this.quadrantInternalBorderStrokeFill || this.primaryBorderColor;
      this.quadrantExternalBorderStrokeFill = this.quadrantExternalBorderStrokeFill || this.primaryBorderColor;
      this.quadrantTitleFill = this.quadrantTitleFill || this.primaryTextColor;
      this.requirementBackground = this.requirementBackground || this.primaryColor;
      this.requirementBorderColor = this.requirementBorderColor || this.primaryBorderColor;
      this.requirementBorderSize = this.requirementBorderSize || "1";
      this.requirementTextColor = this.requirementTextColor || this.primaryTextColor;
      this.relationColor = this.relationColor || this.lineColor;
      this.relationLabelBackground = this.relationLabelBackground || this.edgeLabelBackground;
      this.relationLabelColor = this.relationLabelColor || this.actorTextColor;
      this.git0 = darken$1(this.pie1, 25) || this.primaryColor;
      this.git1 = this.pie2 || this.secondaryColor;
      this.git2 = this.pie3 || this.tertiaryColor;
      this.git3 = this.pie4 || adjust$2(this.primaryColor, { h: -30 });
      this.git4 = this.pie5 || adjust$2(this.primaryColor, { h: -60 });
      this.git5 = this.pie6 || adjust$2(this.primaryColor, { h: -90 });
      this.git6 = this.pie7 || adjust$2(this.primaryColor, { h: 60 });
      this.git7 = this.pie8 || adjust$2(this.primaryColor, { h: 120 });
      this.gitInv0 = this.gitInv0 || invert$1(this.git0);
      this.gitInv1 = this.gitInv1 || invert$1(this.git1);
      this.gitInv2 = this.gitInv2 || invert$1(this.git2);
      this.gitInv3 = this.gitInv3 || invert$1(this.git3);
      this.gitInv4 = this.gitInv4 || invert$1(this.git4);
      this.gitInv5 = this.gitInv5 || invert$1(this.git5);
      this.gitInv6 = this.gitInv6 || invert$1(this.git6);
      this.gitInv7 = this.gitInv7 || invert$1(this.git7);
      this.branchLabelColor = this.branchLabelColor || this.labelTextColor;
      this.gitBranchLabel0 = this.branchLabelColor;
      this.gitBranchLabel1 = "white";
      this.gitBranchLabel2 = this.branchLabelColor;
      this.gitBranchLabel3 = "white";
      this.gitBranchLabel4 = this.branchLabelColor;
      this.gitBranchLabel5 = this.branchLabelColor;
      this.gitBranchLabel6 = this.branchLabelColor;
      this.gitBranchLabel7 = this.branchLabelColor;
      this.tagLabelColor = this.tagLabelColor || this.primaryTextColor;
      this.tagLabelBackground = this.tagLabelBackground || this.primaryColor;
      this.tagLabelBorder = this.tagBorder || this.primaryBorderColor;
      this.tagLabelFontSize = this.tagLabelFontSize || "10px";
      this.commitLabelColor = this.commitLabelColor || this.secondaryTextColor;
      this.commitLabelBackground = this.commitLabelBackground || this.secondaryColor;
      this.commitLabelFontSize = this.commitLabelFontSize || "10px";
      this.attributeBackgroundColorOdd = this.attributeBackgroundColorOdd || oldAttributeBackgroundColorOdd;
      this.attributeBackgroundColorEven = this.attributeBackgroundColorEven || oldAttributeBackgroundColorEven;
    }
    calculate(overrides) {
      if (typeof overrides !== "object") {
        this.updateColors();
        return;
      }
      const keys2 = Object.keys(overrides);
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
      this.updateColors();
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
    }
  }
  const getThemeVariables = (userOverrides) => {
    const theme2 = new Theme();
    theme2.calculate(userOverrides);
    return theme2;
  };
  const theme = {
    base: {
      getThemeVariables: getThemeVariables$4
    },
    dark: {
      getThemeVariables: getThemeVariables$3
    },
    default: {
      getThemeVariables: getThemeVariables$2
    },
    forest: {
      getThemeVariables: getThemeVariables$1
    },
    neutral: {
      getThemeVariables
    }
  };
  const config$2 = {
    /**
     * Theme , the CSS style sheet
     *
     * | Parameter | Description     | Type   | Required | Values                                         |
     * | --------- | --------------- | ------ | -------- | ---------------------------------------------- |
     * | theme     | Built in Themes | string | Optional | 'default', 'forest', 'dark', 'neutral', 'null' |
     *
     * **Notes:** To disable any pre-defined mermaid theme, use "null".
     *
     * @example
     *
     * ```js
     * {
     *   "theme": "forest",
     *   "themeCSS": ".node rect { fill: red; }"
     * }
     * ```
     */
    theme: "default",
    themeVariables: theme["default"].getThemeVariables(),
    themeCSS: void 0,
    /* **maxTextSize** - The maximum allowed size of the users text diagram */
    maxTextSize: 5e4,
    darkMode: false,
    /**
     * | Parameter  | Description                                            | Type   | Required | Values                      |
     * | ---------- | ------------------------------------------------------ | ------ | -------- | --------------------------- |
     * | fontFamily | specifies the font to be used in the rendered diagrams | string | Required | Any Possible CSS FontFamily |
     *
     * **Notes:** Default value: '"trebuchet ms", verdana, arial, sans-serif;'.
     */
    fontFamily: '"trebuchet ms", verdana, arial, sans-serif;',
    /**
     * | Parameter | Description                                           | Type             | Required | Values                                        |
     * | --------- | ----------------------------------------------------- | ---------------- | -------- | --------------------------------------------- |
     * | logLevel  | This option decides the amount of logging to be used. | string \| number | Required | 'trace','debug','info','warn','error','fatal' |
     *
     * **Notes:**
     *
     * - Trace: 0
     * - Debug: 1
     * - Info: 2
     * - Warn: 3
     * - Error: 4
     * - Fatal: 5 (default)
     */
    logLevel: 5,
    /**
     * | Parameter     | Description                       | Type   | Required | Values                                     |
     * | ------------- | --------------------------------- | ------ | -------- | ------------------------------------------ |
     * | securityLevel | Level of trust for parsed diagram | string | Required | 'sandbox', 'strict', 'loose', 'antiscript' |
     *
     * **Notes**:
     *
     * - **strict**: (**default**) HTML tags in the text are encoded and click functionality is disabled.
     * - **antiscript**: HTML tags in text are allowed (only script elements are removed), and click
     *   functionality is enabled.
     * - **loose**: HTML tags in text are allowed and click functionality is enabled.
     * - **sandbox**: With this security level, all rendering takes place in a sandboxed iframe. This
     *   prevent any JavaScript from running in the context. This may hinder interactive functionality
     *   of the diagram, like scripts, popups in the sequence diagram, links to other tabs or targets, etc.
     */
    securityLevel: "strict",
    /**
     * | Parameter   | Description                                  | Type    | Required | Values      |
     * | ----------- | -------------------------------------------- | ------- | -------- | ----------- |
     * | startOnLoad | Dictates whether mermaid starts on Page load | boolean | Required | true, false |
     *
     * **Notes:** Default value: true
     */
    startOnLoad: true,
    /**
     * | Parameter           | Description                                                                  | Type    | Required | Values      |
     * | ------------------- | ---------------------------------------------------------------------------- | ------- | -------- | ----------- |
     * | arrowMarkerAbsolute | Controls whether or arrow markers in html code are absolute paths or anchors | boolean | Required | true, false |
     *
     * **Notes**:
     *
     * This matters if you are using base tag settings.
     *
     * Default value: false
     */
    arrowMarkerAbsolute: false,
    /**
     * This option controls which currentConfig keys are considered _secure_ and can only be changed
     * via call to mermaidAPI.initialize. Calls to mermaidAPI.reinitialize cannot make changes to the
     * `secure` keys in the current currentConfig. This prevents malicious graph directives from
     * overriding a site's default security.
     *
     * **Notes**:
     *
     * Default value: ['secure', 'securityLevel', 'startOnLoad', 'maxTextSize']
     */
    secure: ["secure", "securityLevel", "startOnLoad", "maxTextSize"],
    /**
     * This option controls if the generated ids of nodes in the SVG are generated randomly or based
     * on a seed. If set to false, the IDs are generated based on the current date and thus are not
     * deterministic. This is the default behavior.
     *
     * **Notes**:
     *
     * This matters if your files are checked into source control e.g. git and should not change unless
     * content is changed.
     *
     * Default value: false
     */
    deterministicIds: false,
    /**
     * This option is the optional seed for deterministic ids. if set to undefined but
     * deterministicIds is true, a simple number iterator is used. You can set this attribute to base
     * the seed on a static string.
     */
    deterministicIDSeed: void 0,
    /** The object containing configurations specific for flowcharts */
    flowchart: {
      /**
       * ### titleTopMargin
       *
       * | Parameter      | Description                                    | Type    | Required | Values             |
       * | -------------- | ---------------------------------------------- | ------- | -------- | ------------------ |
       * | titleTopMargin | Margin top for the text over the flowchart     | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 25
       */
      titleTopMargin: 25,
      /**
       * | Parameter      | Description                                     | Type    | Required | Values             |
       * | -------------- | ----------------------------------------------- | ------- | -------- | ------------------ |
       * | diagramPadding | Amount of padding around the diagram as a whole | Integer | Required | Any Positive Value |
       *
       * **Notes:**
       *
       * The amount of padding around the diagram as a whole so that embedded diagrams have margins,
       * expressed in pixels
       *
       * Default value: 8
       */
      diagramPadding: 8,
      /**
       * | Parameter  | Description                                                                                  | Type    | Required | Values      |
       * | ---------- | -------------------------------------------------------------------------------------------- | ------- | -------- | ----------- |
       * | htmlLabels | Flag for setting whether or not a html tag should be used for rendering labels on the edges. | boolean | Required | true, false |
       *
       * **Notes:** Default value: true.
       */
      htmlLabels: true,
      /**
       * | Parameter   | Description                                         | Type    | Required | Values              |
       * | ----------- | --------------------------------------------------- | ------- | -------- | ------------------- |
       * | nodeSpacing | Defines the spacing between nodes on the same level | Integer | Required | Any positive Number |
       *
       * **Notes:**
       *
       * Pertains to horizontal spacing for TB (top to bottom) or BT (bottom to top) graphs, and the
       * vertical spacing for LR as well as RL graphs.**
       *
       * Default value: 50
       */
      nodeSpacing: 50,
      /**
       * | Parameter   | Description                                           | Type    | Required | Values              |
       * | ----------- | ----------------------------------------------------- | ------- | -------- | ------------------- |
       * | rankSpacing | Defines the spacing between nodes on different levels | Integer | Required | Any Positive Number |
       *
       * **Notes**:
       *
       * Pertains to vertical spacing for TB (top to bottom) or BT (bottom to top), and the horizontal
       * spacing for LR as well as RL graphs.
       *
       * Default value 50
       */
      rankSpacing: 50,
      /**
       * | Parameter | Description                                        | Type   | Required | Values                        |
       * | --------- | -------------------------------------------------- | ------ | -------- | ----------------------------- |
       * | curve     | Defines how mermaid renders curves for flowcharts. | string | Required | 'basis', 'linear', 'cardinal' |
       *
       * **Notes:**
       *
       * Default Value: 'basis'
       */
      curve: "basis",
      // Only used in new experimental rendering
      // represents the padding between the labels and the shape
      padding: 15,
      /**
       * | Parameter   | Description | Type    | Required | Values      |
       * | ----------- | ----------- | ------- | -------- | ----------- |
       * | useMaxWidth | See notes   | boolean | 4        | true, false |
       *
       * **Notes:**
       *
       * When this flag is set the height and width is set to 100% and is then scaling with the
       * available space if not the absolute space required is used.
       *
       * Default value: true
       */
      useMaxWidth: true,
      /**
       * | Parameter       | Description | Type    | Required | Values                  |
       * | --------------- | ----------- | ------- | -------- | ----------------------- |
       * | defaultRenderer | See notes   | boolean | 4        | dagre-d3, dagre-wrapper, elk |
       *
       * **Notes:**
       *
       * Decides which rendering engine that is to be used for the rendering. Legal values are:
       * dagre-d3 dagre-wrapper - wrapper for dagre implemented in mermaid, elk for layout using
       * elkjs
       *
       * Default value: 'dagre-wrapper'
       */
      defaultRenderer: "dagre-wrapper",
      /**
       * | Parameter       | Description | Type    | Required | Values                  |
       * | --------------- | ----------- | ------- | -------- | ----------------------- |
       * | wrappingWidth   | See notes   | number  | 4        | width of nodes where text is wrapped |
       *
       * **Notes:**
       *
       * When using markdown strings the text ius wrapped automatically, this
       * value sets the max width of a text before it continues on a new line.
       * Default value: 'dagre-wrapper'
       */
      wrappingWidth: 200
    },
    /** The object containing configurations specific for sequence diagrams */
    sequence: {
      hideUnusedParticipants: false,
      /**
       * | Parameter       | Description                  | Type    | Required | Values             |
       * | --------------- | ---------------------------- | ------- | -------- | ------------------ |
       * | activationWidth | Width of the activation rect | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value :10
       */
      activationWidth: 10,
      /**
       * | Parameter      | Description                                          | Type    | Required | Values             |
       * | -------------- | ---------------------------------------------------- | ------- | -------- | ------------------ |
       * | diagramMarginX | Margin to the right and left of the sequence diagram | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 50
       */
      diagramMarginX: 50,
      /**
       * | Parameter      | Description                                       | Type    | Required | Values             |
       * | -------------- | ------------------------------------------------- | ------- | -------- | ------------------ |
       * | diagramMarginY | Margin to the over and under the sequence diagram | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 10
       */
      diagramMarginY: 10,
      /**
       * | Parameter   | Description           | Type    | Required | Values             |
       * | ----------- | --------------------- | ------- | -------- | ------------------ |
       * | actorMargin | Margin between actors | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 50
       */
      actorMargin: 50,
      /**
       * | Parameter | Description          | Type    | Required | Values             |
       * | --------- | -------------------- | ------- | -------- | ------------------ |
       * | width     | Width of actor boxes | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 150
       */
      width: 150,
      /**
       * | Parameter | Description           | Type    | Required | Values             |
       * | --------- | --------------------- | ------- | -------- | ------------------ |
       * | height    | Height of actor boxes | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 65
       */
      height: 65,
      /**
       * | Parameter | Description              | Type    | Required | Values             |
       * | --------- | ------------------------ | ------- | -------- | ------------------ |
       * | boxMargin | Margin around loop boxes | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 10
       */
      boxMargin: 10,
      /**
       * | Parameter     | Description                                  | Type    | Required | Values             |
       * | ------------- | -------------------------------------------- | ------- | -------- | ------------------ |
       * | boxTextMargin | Margin around the text in loop/alt/opt boxes | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 5
       */
      boxTextMargin: 5,
      /**
       * | Parameter  | Description         | Type    | Required | Values             |
       * | ---------- | ------------------- | ------- | -------- | ------------------ |
       * | noteMargin | margin around notes | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 10
       */
      noteMargin: 10,
      /**
       * | Parameter     | Description            | Type    | Required | Values             |
       * | ------------- | ---------------------- | ------- | -------- | ------------------ |
       * | messageMargin | Space between messages | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 35
       */
      messageMargin: 35,
      /**
       * | Parameter    | Description                 | Type   | Required | Values                    |
       * | ------------ | --------------------------- | ------ | -------- | ------------------------- |
       * | messageAlign | Multiline message alignment | string | Required | 'left', 'center', 'right' |
       *
       * **Notes:** Default value: 'center'
       */
      messageAlign: "center",
      /**
       * | Parameter    | Description                 | Type    | Required | Values      |
       * | ------------ | --------------------------- | ------- | -------- | ----------- |
       * | mirrorActors | Mirror actors under diagram | boolean | Required | true, false |
       *
       * **Notes:** Default value: true
       */
      mirrorActors: true,
      /**
       * | Parameter  | Description                                                             | Type    | Required | Values      |
       * | ---------- | ----------------------------------------------------------------------- | ------- | -------- | ----------- |
       * | forceMenus | forces actor popup menus to always be visible (to support E2E testing). | Boolean | Required | True, False |
       *
       * **Notes:**
       *
       * Default value: false.
       */
      forceMenus: false,
      /**
       * | Parameter       | Description                                | Type    | Required | Values             |
       * | --------------- | ------------------------------------------ | ------- | -------- | ------------------ |
       * | bottomMarginAdj | Prolongs the edge of the diagram downwards | Integer | Required | Any Positive Value |
       *
       * **Notes:**
       *
       * Depending on css styling this might need adjustment.
       *
       * Default value: 1
       */
      bottomMarginAdj: 1,
      /**
       * | Parameter   | Description | Type    | Required | Values      |
       * | ----------- | ----------- | ------- | -------- | ----------- |
       * | useMaxWidth | See Notes   | boolean | Required | true, false |
       *
       * **Notes:** When this flag is set to true, the height and width is set to 100% and is then
       * scaling with the available space. If set to false, the absolute space required is used.
       *
       * Default value: true
       */
      useMaxWidth: true,
      /**
       * | Parameter   | Description                          | Type    | Required | Values      |
       * | ----------- | ------------------------------------ | ------- | -------- | ----------- |
       * | rightAngles | display curve arrows as right angles | boolean | Required | true, false |
       *
       * **Notes:**
       *
       * This will display arrows that start and begin at the same node as right angles, rather than a
       * curve
       *
       * Default value: false
       */
      rightAngles: false,
      /**
       * | Parameter           | Description                     | Type    | Required | Values      |
       * | ------------------- | ------------------------------- | ------- | -------- | ----------- |
       * | showSequenceNumbers | This will show the node numbers | boolean | Required | true, false |
       *
       * **Notes:** Default value: false
       */
      showSequenceNumbers: false,
      /**
       * | Parameter     | Description                                        | Type    | Required | Values             |
       * | ------------- | -------------------------------------------------- | ------- | -------- | ------------------ |
       * | actorFontSize | This sets the font size of the actor's description | Integer | Require  | Any Positive Value |
       *
       * **Notes:** **Default value 14**..
       */
      actorFontSize: 14,
      /**
       * | Parameter       | Description                                          | Type   | Required | Values                      |
       * | --------------- | ---------------------------------------------------- | ------ | -------- | --------------------------- |
       * | actorFontFamily | This sets the font family of the actor's description | string | Required | Any Possible CSS FontFamily |
       *
       * **Notes:** Default value: "'Open Sans", sans-serif'
       */
      actorFontFamily: '"Open Sans", sans-serif',
      /**
       * This sets the font weight of the actor's description
       *
       * **Notes:** Default value: 400.
       */
      actorFontWeight: 400,
      /**
       * | Parameter    | Description                                     | Type    | Required | Values             |
       * | ------------ | ----------------------------------------------- | ------- | -------- | ------------------ |
       * | noteFontSize | This sets the font size of actor-attached notes | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 14
       */
      noteFontSize: 14,
      /**
       * | Parameter      | Description                                        | Type   | Required | Values                      |
       * | -------------- | -------------------------------------------------- | ------ | -------- | --------------------------- |
       * | noteFontFamily | This sets the font family of actor-attached notes. | string | Required | Any Possible CSS FontFamily |
       *
       * **Notes:** Default value: ''"trebuchet ms", verdana, arial, sans-serif'
       */
      noteFontFamily: '"trebuchet ms", verdana, arial, sans-serif',
      /**
       * This sets the font weight of the note's description
       *
       * **Notes:** Default value: 400
       */
      noteFontWeight: 400,
      /**
       * | Parameter | Description                                          | Type   | Required | Values                    |
       * | --------- | ---------------------------------------------------- | ------ | -------- | ------------------------- |
       * | noteAlign | This sets the text alignment of actor-attached notes | string | required | 'left', 'center', 'right' |
       *
       * **Notes:** Default value: 'center'
       */
      noteAlign: "center",
      /**
       * | Parameter       | Description                               | Type    | Required | Values              |
       * | --------------- | ----------------------------------------- | ------- | -------- | ------------------- |
       * | messageFontSize | This sets the font size of actor messages | Integer | Required | Any Positive Number |
       *
       * **Notes:** Default value: 16
       */
      messageFontSize: 16,
      /**
       * | Parameter         | Description                                 | Type   | Required | Values                      |
       * | ----------------- | ------------------------------------------- | ------ | -------- | --------------------------- |
       * | messageFontFamily | This sets the font family of actor messages | string | Required | Any Possible CSS FontFamily |
       *
       * **Notes:** Default value: '"trebuchet ms", verdana, arial, sans-serif'
       */
      messageFontFamily: '"trebuchet ms", verdana, arial, sans-serif',
      /**
       * This sets the font weight of the message's description
       *
       * **Notes:** Default value: 400.
       */
      messageFontWeight: 400,
      /**
       * This sets the auto-wrap state for the diagram
       *
       * **Notes:** Default value: false.
       */
      wrap: false,
      /**
       * This sets the auto-wrap padding for the diagram (sides only)
       *
       * **Notes:** Default value: 0.
       */
      wrapPadding: 10,
      /**
       * This sets the width of the loop-box (loop, alt, opt, par)
       *
       * **Notes:** Default value: 50.
       */
      labelBoxWidth: 50,
      /**
       * This sets the height of the loop-box (loop, alt, opt, par)
       *
       * **Notes:** Default value: 20.
       */
      labelBoxHeight: 20,
      messageFont: function() {
        return {
          fontFamily: this.messageFontFamily,
          fontSize: this.messageFontSize,
          fontWeight: this.messageFontWeight
        };
      },
      noteFont: function() {
        return {
          fontFamily: this.noteFontFamily,
          fontSize: this.noteFontSize,
          fontWeight: this.noteFontWeight
        };
      },
      actorFont: function() {
        return {
          fontFamily: this.actorFontFamily,
          fontSize: this.actorFontSize,
          fontWeight: this.actorFontWeight
        };
      }
    },
    /** The object containing configurations specific for gantt diagrams */
    gantt: {
      /**
       * ### titleTopMargin
       *
       * | Parameter      | Description                                    | Type    | Required | Values             |
       * | -------------- | ---------------------------------------------- | ------- | -------- | ------------------ |
       * | titleTopMargin | Margin top for the text over the gantt diagram | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 25
       */
      titleTopMargin: 25,
      /**
       * | Parameter | Description                         | Type    | Required | Values             |
       * | --------- | ----------------------------------- | ------- | -------- | ------------------ |
       * | barHeight | The height of the bars in the graph | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 20
       */
      barHeight: 20,
      /**
       * | Parameter | Description                                                      | Type    | Required | Values             |
       * | --------- | ---------------------------------------------------------------- | ------- | -------- | ------------------ |
       * | barGap    | The margin between the different activities in the gantt diagram | Integer | Optional | Any Positive Value |
       *
       * **Notes:** Default value: 4
       */
      barGap: 4,
      /**
       * | Parameter  | Description                                                                | Type    | Required | Values             |
       * | ---------- | -------------------------------------------------------------------------- | ------- | -------- | ------------------ |
       * | topPadding | Margin between title and gantt diagram and between axis and gantt diagram. | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 50
       */
      topPadding: 50,
      /**
       * | Parameter    | Description                                                             | Type    | Required | Values             |
       * | ------------ | ----------------------------------------------------------------------- | ------- | -------- | ------------------ |
       * | rightPadding | The space allocated for the section name to the right of the activities | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 75
       */
      rightPadding: 75,
      /**
       * | Parameter   | Description                                                            | Type    | Required | Values             |
       * | ----------- | ---------------------------------------------------------------------- | ------- | -------- | ------------------ |
       * | leftPadding | The space allocated for the section name to the left of the activities | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 75
       */
      leftPadding: 75,
      /**
       * | Parameter            | Description                                  | Type    | Required | Values             |
       * | -------------------- | -------------------------------------------- | ------- | -------- | ------------------ |
       * | gridLineStartPadding | Vertical starting position of the grid lines | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 35
       */
      gridLineStartPadding: 35,
      /**
       * | Parameter | Description | Type    | Required | Values             |
       * | --------- | ----------- | ------- | -------- | ------------------ |
       * | fontSize  | Font size   | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 11
       */
      fontSize: 11,
      /**
       * | Parameter       | Description            | Type    | Required | Values             |
       * | --------------- | ---------------------- | ------- | -------- | ------------------ |
       * | sectionFontSize | Font size for sections | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 11
       */
      sectionFontSize: 11,
      /**
       * | Parameter           | Description                              | Type    | Required | Values             |
       * | ------------------- | ---------------------------------------- | ------- | -------- | ------------------ |
       * | numberSectionStyles | The number of alternating section styles | Integer | 4        | Any Positive Value |
       *
       * **Notes:** Default value: 4
       */
      numberSectionStyles: 4,
      /**
       * | Parameter   | Description               | Type   | Required | Values    |
       * | ----------- | ------------------------- | ------ | -------- | --------- |
       * | displayMode | Controls the display mode | string | 4        | 'compact' |
       *
       * **Notes**:
       *
       * - **compact**: Enables displaying multiple tasks on the same row.
       */
      displayMode: "",
      /**
       * | Parameter  | Description                  | Type | Required | Values           |
       * | ---------- | ---------------------------- | ---- | -------- | ---------------- |
       * | axisFormat | Date/time format of the axis | 3    | Required | Date in yy-mm-dd |
       *
       * **Notes:**
       *
       * This might need adjustment to match your locale and preferences
       *
       * Default value: '%Y-%m-%d'.
       */
      axisFormat: "%Y-%m-%d",
      /**
       * | Parameter    | Description | Type   | Required | Values  |
       * | ------------ | ------------| ------ | -------- | ------- |
       * | tickInterval | axis ticks  | string | Optional | string  |
       *
       * **Notes:**
       *
       * Pattern is /^([1-9][0-9]*)(minute|hour|day|week|month)$/
       *
       * Default value: undefined
       */
      tickInterval: void 0,
      /**
       * | Parameter   | Description | Type    | Required | Values      |
       * | ----------- | ----------- | ------- | -------- | ----------- |
       * | useMaxWidth | See notes   | boolean | 4        | true, false |
       *
       * **Notes:**
       *
       * When this flag is set the height and width is set to 100% and is then scaling with the
       * available space if not the absolute space required is used.
       *
       * Default value: true
       */
      useMaxWidth: true,
      /**
       * | Parameter | Description | Type    | Required | Values      |
       * | --------- | ----------- | ------- | -------- | ----------- |
       * | topAxis   | See notes   | Boolean | 4        | True, False |
       *
       * **Notes:** when this flag is set date labels will be added to the top of the chart
       *
       * **Default value false**.
       */
      topAxis: false,
      useWidth: void 0
    },
    /** The object containing configurations specific for journey diagrams */
    journey: {
      /**
       * | Parameter      | Description                                          | Type    | Required | Values             |
       * | -------------- | ---------------------------------------------------- | ------- | -------- | ------------------ |
       * | diagramMarginX | Margin to the right and left of the sequence diagram | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 50
       */
      diagramMarginX: 50,
      /**
       * | Parameter      | Description                                        | Type    | Required | Values             |
       * | -------------- | -------------------------------------------------- | ------- | -------- | ------------------ |
       * | diagramMarginY | Margin to the over and under the sequence diagram. | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 10
       */
      diagramMarginY: 10,
      /**
       * | Parameter   | Description           | Type    | Required | Values             |
       * | ----------- | --------------------- | ------- | -------- | ------------------ |
       * | actorMargin | Margin between actors | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 50
       */
      leftMargin: 150,
      /**
       * | Parameter | Description          | Type    | Required | Values             |
       * | --------- | -------------------- | ------- | -------- | ------------------ |
       * | width     | Width of actor boxes | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 150
       */
      width: 150,
      /**
       * | Parameter | Description           | Type    | Required | Values             |
       * | --------- | --------------------- | ------- | -------- | ------------------ |
       * | height    | Height of actor boxes | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 65
       */
      height: 50,
      /**
       * | Parameter | Description              | Type    | Required | Values             |
       * | --------- | ------------------------ | ------- | -------- | ------------------ |
       * | boxMargin | Margin around loop boxes | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 10
       */
      boxMargin: 10,
      /**
       * | Parameter     | Description                                  | Type    | Required | Values             |
       * | ------------- | -------------------------------------------- | ------- | -------- | ------------------ |
       * | boxTextMargin | Margin around the text in loop/alt/opt boxes | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 5
       */
      boxTextMargin: 5,
      /**
       * | Parameter  | Description         | Type    | Required | Values             |
       * | ---------- | ------------------- | ------- | -------- | ------------------ |
       * | noteMargin | Margin around notes | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 10
       */
      noteMargin: 10,
      /**
       * | Parameter     | Description             | Type    | Required | Values             |
       * | ------------- | ----------------------- | ------- | -------- | ------------------ |
       * | messageMargin | Space between messages. | Integer | Required | Any Positive Value |
       *
       * **Notes:**
       *
       * Space between messages.
       *
       * Default value: 35
       */
      messageMargin: 35,
      /**
       * | Parameter    | Description                 | Type | Required | Values                    |
       * | ------------ | --------------------------- | ---- | -------- | ------------------------- |
       * | messageAlign | Multiline message alignment | 3    | 4        | 'left', 'center', 'right' |
       *
       * **Notes:** Default value: 'center'
       */
      messageAlign: "center",
      /**
       * | Parameter       | Description                                | Type    | Required | Values             |
       * | --------------- | ------------------------------------------ | ------- | -------- | ------------------ |
       * | bottomMarginAdj | Prolongs the edge of the diagram downwards | Integer | 4        | Any Positive Value |
       *
       * **Notes:**
       *
       * Depending on css styling this might need adjustment.
       *
       * Default value: 1
       */
      bottomMarginAdj: 1,
      /**
       * | Parameter   | Description | Type    | Required | Values      |
       * | ----------- | ----------- | ------- | -------- | ----------- |
       * | useMaxWidth | See notes   | boolean | 4        | true, false |
       *
       * **Notes:**
       *
       * When this flag is set the height and width is set to 100% and is then scaling with the
       * available space if not the absolute space required is used.
       *
       * Default value: true
       */
      useMaxWidth: true,
      /**
       * | Parameter   | Description                       | Type | Required | Values      |
       * | ----------- | --------------------------------- | ---- | -------- | ----------- |
       * | rightAngles | Curved Arrows become Right Angles | 3    | 4        | true, false |
       *
       * **Notes:**
       *
       * This will display arrows that start and begin at the same node as right angles, rather than a
       * curves
       *
       * Default value: false
       */
      rightAngles: false,
      taskFontSize: 14,
      taskFontFamily: '"Open Sans", sans-serif',
      taskMargin: 50,
      // width of activation box
      activationWidth: 10,
      // text placement as: tspan | fo | old only text as before
      textPlacement: "fo",
      actorColours: ["#8FBC8F", "#7CFC00", "#00FFFF", "#20B2AA", "#B0E0E6", "#FFFFE0"],
      sectionFills: ["#191970", "#8B008B", "#4B0082", "#2F4F4F", "#800000", "#8B4513", "#00008B"],
      sectionColours: ["#fff"]
    },
    /** The object containing configurations specific for timeline diagrams */
    timeline: {
      /**
       * | Parameter      | Description                                          | Type    | Required | Values             |
       * | -------------- | ---------------------------------------------------- | ------- | -------- | ------------------ |
       * | diagramMarginX | Margin to the right and left of the sequence diagram | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 50
       */
      diagramMarginX: 50,
      /**
       * | Parameter      | Description                                        | Type    | Required | Values             |
       * | -------------- | -------------------------------------------------- | ------- | -------- | ------------------ |
       * | diagramMarginY | Margin to the over and under the sequence diagram. | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 10
       */
      diagramMarginY: 10,
      /**
       * | Parameter   | Description           | Type    | Required | Values             |
       * | ----------- | --------------------- | ------- | -------- | ------------------ |
       * | actorMargin | Margin between actors | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 50
       */
      leftMargin: 150,
      /**
       * | Parameter | Description          | Type    | Required | Values             |
       * | --------- | -------------------- | ------- | -------- | ------------------ |
       * | width     | Width of actor boxes | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 150
       */
      width: 150,
      /**
       * | Parameter | Description           | Type    | Required | Values             |
       * | --------- | --------------------- | ------- | -------- | ------------------ |
       * | height    | Height of actor boxes | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 65
       */
      height: 50,
      /**
       * | Parameter | Description              | Type    | Required | Values             |
       * | --------- | ------------------------ | ------- | -------- | ------------------ |
       * | boxMargin | Margin around loop boxes | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 10
       */
      boxMargin: 10,
      /**
       * | Parameter     | Description                                  | Type    | Required | Values             |
       * | ------------- | -------------------------------------------- | ------- | -------- | ------------------ |
       * | boxTextMargin | Margin around the text in loop/alt/opt boxes | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 5
       */
      boxTextMargin: 5,
      /**
       * | Parameter  | Description         | Type    | Required | Values             |
       * | ---------- | ------------------- | ------- | -------- | ------------------ |
       * | noteMargin | Margin around notes | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 10
       */
      noteMargin: 10,
      /**
       * | Parameter     | Description             | Type    | Required | Values             |
       * | ------------- | ----------------------- | ------- | -------- | ------------------ |
       * | messageMargin | Space between messages. | Integer | Required | Any Positive Value |
       *
       * **Notes:**
       *
       * Space between messages.
       *
       * Default value: 35
       */
      messageMargin: 35,
      /**
       * | Parameter    | Description                 | Type | Required | Values                    |
       * | ------------ | --------------------------- | ---- | -------- | ------------------------- |
       * | messageAlign | Multiline message alignment | 3    | 4        | 'left', 'center', 'right' |
       *
       * **Notes:** Default value: 'center'
       */
      messageAlign: "center",
      /**
       * | Parameter       | Description                                | Type    | Required | Values             |
       * | --------------- | ------------------------------------------ | ------- | -------- | ------------------ |
       * | bottomMarginAdj | Prolongs the edge of the diagram downwards | Integer | 4        | Any Positive Value |
       *
       * **Notes:**
       *
       * Depending on css styling this might need adjustment.
       *
       * Default value: 1
       */
      bottomMarginAdj: 1,
      /**
       * | Parameter   | Description | Type    | Required | Values      |
       * | ----------- | ----------- | ------- | -------- | ----------- |
       * | useMaxWidth | See notes   | boolean | 4        | true, false |
       *
       * **Notes:**
       *
       * When this flag is set the height and width is set to 100% and is then scaling with the
       * available space if not the absolute space required is used.
       *
       * Default value: true
       */
      useMaxWidth: true,
      /**
       * | Parameter   | Description                       | Type | Required | Values      |
       * | ----------- | --------------------------------- | ---- | -------- | ----------- |
       * | rightAngles | Curved Arrows become Right Angles | 3    | 4        | true, false |
       *
       * **Notes:**
       *
       * This will display arrows that start and begin at the same node as right angles, rather than a
       * curves
       *
       * Default value: false
       */
      rightAngles: false,
      taskFontSize: 14,
      taskFontFamily: '"Open Sans", sans-serif',
      taskMargin: 50,
      // width of activation box
      activationWidth: 10,
      // text placement as: tspan | fo | old only text as before
      textPlacement: "fo",
      actorColours: ["#8FBC8F", "#7CFC00", "#00FFFF", "#20B2AA", "#B0E0E6", "#FFFFE0"],
      sectionFills: ["#191970", "#8B008B", "#4B0082", "#2F4F4F", "#800000", "#8B4513", "#00008B"],
      sectionColours: ["#fff"],
      disableMulticolor: false
    },
    class: {
      /**
       * ### titleTopMargin
       *
       * | Parameter      | Description                                    | Type    | Required | Values             |
       * | -------------- | ---------------------------------------------- | ------- | -------- | ------------------ |
       * | titleTopMargin | Margin top for the text over the class diagram | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 25
       */
      titleTopMargin: 25,
      arrowMarkerAbsolute: false,
      dividerMargin: 10,
      padding: 5,
      textHeight: 10,
      /**
       * | Parameter   | Description | Type    | Required | Values      |
       * | ----------- | ----------- | ------- | -------- | ----------- |
       * | useMaxWidth | See notes   | boolean | 4        | true, false |
       *
       * **Notes:**
       *
       * When this flag is set the height and width is set to 100% and is then scaling with the
       * available space if not the absolute space required is used.
       *
       * Default value: true
       */
      useMaxWidth: true,
      /**
       * | Parameter       | Description | Type    | Required | Values                  |
       * | --------------- | ----------- | ------- | -------- | ----------------------- |
       * | defaultRenderer | See notes   | boolean | 4        | dagre-d3, dagre-wrapper |
       *
       * **Notes**:
       *
       * Decides which rendering engine that is to be used for the rendering. Legal values are:
       * dagre-d3 dagre-wrapper - wrapper for dagre implemented in mermaid
       *
       * Default value: 'dagre-d3'
       */
      defaultRenderer: "dagre-wrapper"
    },
    state: {
      /**
       * ### titleTopMargin
       *
       * | Parameter      | Description                                    | Type    | Required | Values             |
       * | -------------- | ---------------------------------------------- | ------- | -------- | ------------------ |
       * | titleTopMargin | Margin top for the text over the state diagram | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 25
       */
      titleTopMargin: 25,
      dividerMargin: 10,
      sizeUnit: 5,
      padding: 8,
      textHeight: 10,
      titleShift: -15,
      noteMargin: 10,
      forkWidth: 70,
      forkHeight: 7,
      // Used
      miniPadding: 2,
      // Font size factor, this is used to guess the width of the edges labels before rendering by dagre
      // layout. This might need updating if/when switching font
      fontSizeFactor: 5.02,
      fontSize: 24,
      labelHeight: 16,
      edgeLengthFactor: "20",
      compositTitleSize: 35,
      radius: 5,
      /**
       * | Parameter   | Description | Type    | Required | Values      |
       * | ----------- | ----------- | ------- | -------- | ----------- |
       * | useMaxWidth | See notes   | boolean | 4        | true, false |
       *
       * **Notes:**
       *
       * When this flag is set the height and width is set to 100% and is then scaling with the
       * available space if not the absolute space required is used.
       *
       * Default value: true
       */
      useMaxWidth: true,
      /**
       * | Parameter       | Description | Type    | Required | Values                  |
       * | --------------- | ----------- | ------- | -------- | ----------------------- |
       * | defaultRenderer | See notes   | boolean | 4        | dagre-d3, dagre-wrapper |
       *
       * **Notes:**
       *
       * Decides which rendering engine that is to be used for the rendering. Legal values are:
       * dagre-d3 dagre-wrapper - wrapper for dagre implemented in mermaid
       *
       * Default value: 'dagre-d3'
       */
      defaultRenderer: "dagre-wrapper"
    },
    /** The object containing configurations specific for entity relationship diagrams */
    er: {
      /**
       * ### titleTopMargin
       *
       * | Parameter      | Description                                    | Type    | Required | Values             |
       * | -------------- | ---------------------------------------------- | ------- | -------- | ------------------ |
       * | titleTopMargin | Margin top for the text over the diagram       | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 25
       */
      titleTopMargin: 25,
      /**
       * | Parameter      | Description                                     | Type    | Required | Values             |
       * | -------------- | ----------------------------------------------- | ------- | -------- | ------------------ |
       * | diagramPadding | Amount of padding around the diagram as a whole | Integer | Required | Any Positive Value |
       *
       * **Notes:**
       *
       * The amount of padding around the diagram as a whole so that embedded diagrams have margins,
       * expressed in pixels
       *
       * Default value: 20
       */
      diagramPadding: 20,
      /**
       * | Parameter       | Description                              | Type   | Required | Values                 |
       * | --------------- | ---------------------------------------- | ------ | -------- | ---------------------- |
       * | layoutDirection | Directional bias for layout of entities. | string | Required | "TB", "BT", "LR", "RL" |
       *
       * **Notes:**
       *
       * 'TB' for Top-Bottom, 'BT'for Bottom-Top, 'LR' for Left-Right, or 'RL' for Right to Left.
       *
       * T = top, B = bottom, L = left, and R = right.
       *
       * Default value: 'TB'
       */
      layoutDirection: "TB",
      /**
       * | Parameter      | Description                        | Type    | Required | Values             |
       * | -------------- | ---------------------------------- | ------- | -------- | ------------------ |
       * | minEntityWidth | The minimum width of an entity box | Integer | Required | Any Positive Value |
       *
       * **Notes:** Expressed in pixels. Default value: 100
       */
      minEntityWidth: 100,
      /**
       * | Parameter       | Description                         | Type    | Required | Values             |
       * | --------------- | ----------------------------------- | ------- | -------- | ------------------ |
       * | minEntityHeight | The minimum height of an entity box | Integer | 4        | Any Positive Value |
       *
       * **Notes:** Expressed in pixels Default value: 75
       */
      minEntityHeight: 75,
      /**
       * | Parameter     | Description                                                  | Type    | Required | Values             |
       * | ------------- | ------------------------------------------------------------ | ------- | -------- | ------------------ |
       * | entityPadding | Minimum internal padding between text in box and box borders | Integer | 4        | Any Positive Value |
       *
       * **Notes:**
       *
       * The minimum internal padding between text in an entity box and the enclosing box borders,
       * expressed in pixels.
       *
       * Default value: 15
       */
      entityPadding: 15,
      /**
       * | Parameter | Description                         | Type   | Required | Values               |
       * | --------- | ----------------------------------- | ------ | -------- | -------------------- |
       * | stroke    | Stroke color of box edges and lines | string | 4        | Any recognized color |
       *
       * **Notes:** Default value: 'gray'
       */
      stroke: "gray",
      /**
       * | Parameter | Description                | Type   | Required | Values               |
       * | --------- | -------------------------- | ------ | -------- | -------------------- |
       * | fill      | Fill color of entity boxes | string | 4        | Any recognized color |
       *
       * **Notes:** Default value: 'honeydew'
       */
      fill: "honeydew",
      /**
       * | Parameter | Description         | Type    | Required | Values             |
       * | --------- | ------------------- | ------- | -------- | ------------------ |
       * | fontSize  | Font Size in pixels | Integer |          | Any Positive Value |
       *
       * **Notes:**
       *
       * Font size (expressed as an integer representing a number of pixels) Default value: 12
       */
      fontSize: 12,
      /**
       * | Parameter   | Description | Type    | Required | Values      |
       * | ----------- | ----------- | ------- | -------- | ----------- |
       * | useMaxWidth | See Notes   | boolean | Required | true, false |
       *
       * **Notes:**
       *
       * When this flag is set to true, the diagram width is locked to 100% and scaled based on
       * available space. If set to false, the diagram reserves its absolute width.
       *
       * Default value: true
       */
      useMaxWidth: true
    },
    /** The object containing configurations specific for pie diagrams */
    pie: {
      useWidth: void 0,
      /**
       * | Parameter   | Description | Type    | Required | Values      |
       * | ----------- | ----------- | ------- | -------- | ----------- |
       * | useMaxWidth | See Notes   | boolean | Required | true, false |
       *
       * **Notes:**
       *
       * When this flag is set to true, the diagram width is locked to 100% and scaled based on
       * available space. If set to false, the diagram reserves its absolute width.
       *
       * Default value: true
       */
      useMaxWidth: true,
      /**
       * | Parameter    | Description                                                                      | Type    | Required | Values              |
       * | ------------ | -------------------------------------------------------------------------------- | ------- | -------- | ------------------- |
       * | textPosition | Axial position of slice's label from zero at the center to 1 at the outside edge | Number  | Optional | Decimal from 0 to 1 |
       *
       * **Notes:** Default value: 0.75
       */
      textPosition: 0.75
    },
    quadrantChart: {
      /**
       * | Parameter       | Description                        | Type    | Required | Values              |
       * | --------------- | ---------------------------------- | ------- | -------- | ------------------- |
       * | chartWidth      | Width of the chart                 | number  | Optional | Any positive number |
       *
       * **Notes:**
       * Default value: 500
       */
      chartWidth: 500,
      /**
       * | Parameter       | Description                        | Type    | Required | Values              |
       * | --------------- | ---------------------------------- | ------- | -------- | ------------------- |
       * | chartHeight     | Height of the chart                | number  | Optional | Any positive number |
       *
       * **Notes:**
       * Default value: 500
       */
      chartHeight: 500,
      /**
       * | Parameter          | Description                        | Type    | Required | Values              |
       * | ------------------ | ---------------------------------- | ------- | -------- | ------------------- |
       * | titlePadding       | Chart title top and bottom padding | number  | Optional | Any positive number |
       *
       * **Notes:**
       * Default value: 10
       */
      titlePadding: 10,
      /**
       * | Parameter          | Description                        | Type    | Required | Values              |
       * | ------------------ | ---------------------------------- | ------- | -------- | ------------------- |
       * | titleFontSize      | Chart title font size              | number  | Optional | Any positive number |
       *
       * **Notes:**
       * Default value: 20
       */
      titleFontSize: 20,
      /**
       * | Parameter       | Description                        | Type    | Required | Values              |
       * | --------------- | ---------------------------------- | ------- | -------- | ------------------- |
       * | quadrantPadding | Padding around the quadrant square | number  | Optional | Any positive number |
       *
       * **Notes:**
       * Default value: 5
       */
      quadrantPadding: 5,
      /**
       * | Parameter              | Description                                                                | Type    | Required | Values              |
       * | ---------------------- | -------------------------------------------------------------------------- | ------- | -------- | ------------------- |
       * | quadrantTextTopPadding | quadrant title padding from top if the quadrant is rendered on top         | number  | Optional | Any positive number |
       *
       * **Notes:**
       * Default value: 5
       */
      quadrantTextTopPadding: 5,
      /**
       * | Parameter             | Description                        | Type    | Required | Values              |
       * | ------------------    | ---------------------------------- | ------- | -------- | ------------------- |
       * | quadrantLabelFontSize | quadrant title font size           | number  | Optional | Any positive number |
       *
       * **Notes:**
       * Default value: 16
       */
      quadrantLabelFontSize: 16,
      /**
       * | Parameter                         | Description                                                   | Type    | Required | Values              |
       * | --------------------------------- | ------------------------------------------------------------- | ------- | -------- | ------------------- |
       * | quadrantInternalBorderStrokeWidth | stroke width of edges of the box that are inside the quadrant | number  | Optional | Any positive number |
       *
       * **Notes:**
       * Default value: 1
       */
      quadrantInternalBorderStrokeWidth: 1,
      /**
       * | Parameter                         | Description                                                    | Type    | Required | Values              |
       * | --------------------------------- | -------------------------------------------------------------- | ------- | -------- | ------------------- |
       * | quadrantExternalBorderStrokeWidth | stroke width of edges of the box that are outside the quadrant | number  | Optional | Any positive number |
       *
       * **Notes:**
       * Default value: 2
       */
      quadrantExternalBorderStrokeWidth: 2,
      /**
       * | Parameter         | Description                        | Type    | Required | Values              |
       * | ---------------   | ---------------------------------- | ------- | -------- | ------------------- |
       * | xAxisLabelPadding | Padding around x-axis labels       | number  | Optional | Any positive number |
       *
       * **Notes:**
       * Default value: 5
       */
      xAxisLabelPadding: 5,
      /**
       * | Parameter          | Description                        | Type    | Required | Values              |
       * | ------------------ | ---------------------------------- | ------- | -------- | ------------------- |
       * | xAxisLabelFontSize | x-axis label font size             | number  | Optional | Any positive number |
       *
       * **Notes:**
       * Default value: 16
       */
      xAxisLabelFontSize: 16,
      /**
       * | Parameter     | Description                     | Type    | Required | Values              |
       * | ------------- | ------------------------------- | ------- | -------- | ------------------- |
       * | xAxisPosition | position of x-axis labels       | string  | Optional | 'top' or 'bottom'   |
       *
       * **Notes:**
       * Default value: top
       */
      xAxisPosition: "top",
      /**
       * | Parameter         | Description                        | Type    | Required | Values              |
       * | ---------------   | ---------------------------------- | ------- | -------- | ------------------- |
       * | yAxisLabelPadding | Padding around y-axis labels       | number  | Optional | Any positive number |
       *
       * **Notes:**
       * Default value: 5
       */
      yAxisLabelPadding: 5,
      /**
       * | Parameter          | Description                        | Type    | Required | Values              |
       * | ------------------ | ---------------------------------- | ------- | -------- | ------------------- |
       * | yAxisLabelFontSize | y-axis label font size             | number  | Optional | Any positive number |
       *
       * **Notes:**
       * Default value: 16
       */
      yAxisLabelFontSize: 16,
      /**
       * | Parameter     | Description                     | Type    | Required | Values              |
       * | ------------- | ------------------------------- | ------- | -------- | ------------------- |
       * | yAxisPosition | position of y-axis labels       | string  | Optional | 'left' or 'right'   |
       *
       * **Notes:**
       * Default value: left
       */
      yAxisPosition: "left",
      /**
       * | Parameter              | Description                            | Type    | Required | Values              |
       * | ---------------------- | -------------------------------------- | ------- | -------- | ------------------- |
       * | pointTextPadding       | padding between point and point label  | number  | Optional | Any positive number |
       *
       * **Notes:**
       * Default value: 5
       */
      pointTextPadding: 5,
      /**
       * | Parameter              | Description            | Type    | Required | Values              |
       * | ---------------------- | ---------------------- | ------- | -------- | ------------------- |
       * | pointTextPadding       | point title font size  | number  | Optional | Any positive number |
       *
       * **Notes:**
       * Default value: 12
       */
      pointLabelFontSize: 12,
      /**
       * | Parameter     | Description                     | Type    | Required | Values              |
       * | ------------- | ------------------------------- | ------- | -------- | ------------------- |
       * | pointRadius   | radius of the point to be drawn | number  | Optional | Any positive number |
       *
       * **Notes:**
       * Default value: 5
       */
      pointRadius: 5,
      /**
       * | Parameter   | Description | Type    | Required | Values      |
       * | ----------- | ----------- | ------- | -------- | ----------- |
       * | useMaxWidth | See Notes   | boolean | Required | true, false |
       *
       * **Notes:**
       *
       * When this flag is set to true, the diagram width is locked to 100% and scaled based on
       * available space. If set to false, the diagram reserves its absolute width.
       *
       * Default value: true
       */
      useMaxWidth: true
    },
    /** The object containing configurations specific for req diagrams */
    requirement: {
      useWidth: void 0,
      /**
       * | Parameter   | Description | Type    | Required | Values      |
       * | ----------- | ----------- | ------- | -------- | ----------- |
       * | useMaxWidth | See Notes   | boolean | Required | true, false |
       *
       * **Notes:**
       *
       * When this flag is set to true, the diagram width is locked to 100% and scaled based on
       * available space. If set to false, the diagram reserves its absolute width.
       *
       * Default value: true
       */
      useMaxWidth: true,
      rect_fill: "#f9f9f9",
      text_color: "#333",
      rect_border_size: "0.5px",
      rect_border_color: "#bbb",
      rect_min_width: 200,
      rect_min_height: 200,
      fontSize: 14,
      rect_padding: 10,
      line_height: 20
    },
    gitGraph: {
      /**
       * ### titleTopMargin
       *
       * | Parameter      | Description                                    | Type    | Required | Values             |
       * | -------------- | ---------------------------------------------- | ------- | -------- | ------------------ |
       * | titleTopMargin | Margin top for the text over the Git diagram   | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 25
       */
      titleTopMargin: 25,
      diagramPadding: 8,
      nodeLabel: {
        width: 75,
        height: 100,
        x: -25,
        y: 0
      },
      mainBranchName: "main",
      mainBranchOrder: 0,
      showCommitLabel: true,
      showBranches: true,
      rotateCommitLabel: true
    },
    /** The object containing configurations specific for c4 diagrams */
    c4: {
      useWidth: void 0,
      /**
       * | Parameter      | Description                                    | Type    | Required | Values             |
       * | -------------- | ---------------------------------------------- | ------- | -------- | ------------------ |
       * | diagramMarginX | Margin to the right and left of the c4 diagram | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 50
       */
      diagramMarginX: 50,
      /**
       * | Parameter      | Description                                 | Type    | Required | Values             |
       * | -------------- | ------------------------------------------- | ------- | -------- | ------------------ |
       * | diagramMarginY | Margin to the over and under the c4 diagram | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 10
       */
      diagramMarginY: 10,
      /**
       * | Parameter     | Description           | Type    | Required | Values             |
       * | ------------- | --------------------- | ------- | -------- | ------------------ |
       * | c4ShapeMargin | Margin between shapes | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 50
       */
      c4ShapeMargin: 50,
      /**
       * | Parameter      | Description            | Type    | Required | Values             |
       * | -------------- | ---------------------- | ------- | -------- | ------------------ |
       * | c4ShapePadding | Padding between shapes | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 20
       */
      c4ShapePadding: 20,
      /**
       * | Parameter | Description           | Type    | Required | Values             |
       * | --------- | --------------------- | ------- | -------- | ------------------ |
       * | width     | Width of person boxes | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 216
       */
      width: 216,
      /**
       * | Parameter | Description            | Type    | Required | Values             |
       * | --------- | ---------------------- | ------- | -------- | ------------------ |
       * | height    | Height of person boxes | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 60
       */
      height: 60,
      /**
       * | Parameter | Description         | Type    | Required | Values             |
       * | --------- | ------------------- | ------- | -------- | ------------------ |
       * | boxMargin | Margin around boxes | Integer | Required | Any Positive Value |
       *
       * **Notes:** Default value: 10
       */
      boxMargin: 10,
      /**
       * | Parameter   | Description | Type    | Required | Values      |
       * | ----------- | ----------- | ------- | -------- | ----------- |
       * | useMaxWidth | See Notes   | boolean | Required | true, false |
       *
       * **Notes:** When this flag is set to true, the height and width is set to 100% and is then
       * scaling with the available space. If set to false, the absolute space required is used.
       *
       * Default value: true
       */
      useMaxWidth: true,
      /**
       * | Parameter    | Description | Type    | Required | Values             |
       * | ------------ | ----------- | ------- | -------- | ------------------ |
       * | c4ShapeInRow | See Notes   | Integer | Required | Any Positive Value |
       *
       * **Notes:** How many shapes to place in each row.
       *
       * Default value: 4
       */
      c4ShapeInRow: 4,
      nextLinePaddingX: 0,
      /**
       * | Parameter       | Description | Type    | Required | Values             |
       * | --------------- | ----------- | ------- | -------- | ------------------ |
       * | c4BoundaryInRow | See Notes   | Integer | Required | Any Positive Value |
       *
       * **Notes:** How many boundaries to place in each row.
       *
       * Default value: 2
       */
      c4BoundaryInRow: 2,
      /**
       * This sets the font size of Person shape for the diagram
       *
       * **Notes:** Default value: 14.
       */
      personFontSize: 14,
      /**
       * This sets the font family of Person shape for the diagram
       *
       * **Notes:** Default value: "Open Sans", sans-serif.
       */
      personFontFamily: '"Open Sans", sans-serif',
      /**
       * This sets the font weight of Person shape for the diagram
       *
       * **Notes:** Default value: normal.
       */
      personFontWeight: "normal",
      /**
       * This sets the font size of External Person shape for the diagram
       *
       * **Notes:** Default value: 14.
       */
      external_personFontSize: 14,
      /**
       * This sets the font family of External Person shape for the diagram
       *
       * **Notes:** Default value: "Open Sans", sans-serif.
       */
      external_personFontFamily: '"Open Sans", sans-serif',
      /**
       * This sets the font weight of External Person shape for the diagram
       *
       * **Notes:** Default value: normal.
       */
      external_personFontWeight: "normal",
      /**
       * This sets the font size of System shape for the diagram
       *
       * **Notes:** Default value: 14.
       */
      systemFontSize: 14,
      /**
       * This sets the font family of System shape for the diagram
       *
       * **Notes:** Default value: "Open Sans", sans-serif.
       */
      systemFontFamily: '"Open Sans", sans-serif',
      /**
       * This sets the font weight of System shape for the diagram
       *
       * **Notes:** Default value: normal.
       */
      systemFontWeight: "normal",
      /**
       * This sets the font size of External System shape for the diagram
       *
       * **Notes:** Default value: 14.
       */
      external_systemFontSize: 14,
      /**
       * This sets the font family of External System shape for the diagram
       *
       * **Notes:** Default value: "Open Sans", sans-serif.
       */
      external_systemFontFamily: '"Open Sans", sans-serif',
      /**
       * This sets the font weight of External System shape for the diagram
       *
       * **Notes:** Default value: normal.
       */
      external_systemFontWeight: "normal",
      /**
       * This sets the font size of System DB shape for the diagram
       *
       * **Notes:** Default value: 14.
       */
      system_dbFontSize: 14,
      /**
       * This sets the font family of System DB shape for the diagram
       *
       * **Notes:** Default value: "Open Sans", sans-serif.
       */
      system_dbFontFamily: '"Open Sans", sans-serif',
      /**
       * This sets the font weight of System DB shape for the diagram
       *
       * **Notes:** Default value: normal.
       */
      system_dbFontWeight: "normal",
      /**
       * This sets the font size of External System DB shape for the diagram
       *
       * **Notes:** Default value: 14.
       */
      external_system_dbFontSize: 14,
      /**
       * This sets the font family of External System DB shape for the diagram
       *
       * **Notes:** Default value: "Open Sans", sans-serif.
       */
      external_system_dbFontFamily: '"Open Sans", sans-serif',
      /**
       * This sets the font weight of External System DB shape for the diagram
       *
       * **Notes:** Default value: normal.
       */
      external_system_dbFontWeight: "normal",
      /**
       * This sets the font size of System Queue shape for the diagram
       *
       * **Notes:** Default value: 14.
       */
      system_queueFontSize: 14,
      /**
       * This sets the font family of System Queue shape for the diagram
       *
       * **Notes:** Default value: "Open Sans", sans-serif.
       */
      system_queueFontFamily: '"Open Sans", sans-serif',
      /**
       * This sets the font weight of System Queue shape for the diagram
       *
       * **Notes:** Default value: normal.
       */
      system_queueFontWeight: "normal",
      /**
       * This sets the font size of External System Queue shape for the diagram
       *
       * **Notes:** Default value: 14.
       */
      external_system_queueFontSize: 14,
      /**
       * This sets the font family of External System Queue shape for the diagram
       *
       * **Notes:** Default value: "Open Sans", sans-serif.
       */
      external_system_queueFontFamily: '"Open Sans", sans-serif',
      /**
       * This sets the font weight of External System Queue shape for the diagram
       *
       * **Notes:** Default value: normal.
       */
      external_system_queueFontWeight: "normal",
      /**
       * This sets the font size of Boundary shape for the diagram
       *
       * **Notes:** Default value: 14.
       */
      boundaryFontSize: 14,
      /**
       * This sets the font family of Boundary shape for the diagram
       *
       * **Notes:** Default value: "Open Sans", sans-serif.
       */
      boundaryFontFamily: '"Open Sans", sans-serif',
      /**
       * This sets the font weight of Boundary shape for the diagram
       *
       * **Notes:** Default value: normal.
       */
      boundaryFontWeight: "normal",
      /**
       * This sets the font size of Message shape for the diagram
       *
       * **Notes:** Default value: 12.
       */
      messageFontSize: 12,
      /**
       * This sets the font family of Message shape for the diagram
       *
       * **Notes:** Default value: "Open Sans", sans-serif.
       */
      messageFontFamily: '"Open Sans", sans-serif',
      /**
       * This sets the font weight of Message shape for the diagram
       *
       * **Notes:** Default value: normal.
       */
      messageFontWeight: "normal",
      /**
       * This sets the font size of Container shape for the diagram
       *
       * **Notes:** Default value: 14.
       */
      containerFontSize: 14,
      /**
       * This sets the font family of Container shape for the diagram
       *
       * **Notes:** Default value: "Open Sans", sans-serif.
       */
      containerFontFamily: '"Open Sans", sans-serif',
      /**
       * This sets the font weight of Container shape for the diagram
       *
       * **Notes:** Default value: normal.
       */
      containerFontWeight: "normal",
      /**
       * This sets the font size of External Container shape for the diagram
       *
       * **Notes:** Default value: 14.
       */
      external_containerFontSize: 14,
      /**
       * This sets the font family of External Container shape for the diagram
       *
       * **Notes:** Default value: "Open Sans", sans-serif.
       */
      external_containerFontFamily: '"Open Sans", sans-serif',
      /**
       * This sets the font weight of External Container shape for the diagram
       *
       * **Notes:** Default value: normal.
       */
      external_containerFontWeight: "normal",
      /**
       * This sets the font size of Container DB shape for the diagram
       *
       * **Notes:** Default value: 14.
       */
      container_dbFontSize: 14,
      /**
       * This sets the font family of Container DB shape for the diagram
       *
       * **Notes:** Default value: "Open Sans", sans-serif.
       */
      container_dbFontFamily: '"Open Sans", sans-serif',
      /**
       * This sets the font weight of Container DB shape for the diagram
       *
       * **Notes:** Default value: normal.
       */
      container_dbFontWeight: "normal",
      /**
       * This sets the font size of External Container DB shape for the diagram
       *
       * **Notes:** Default value: 14.
       */
      external_container_dbFontSize: 14,
      /**
       * This sets the font family of External Container DB shape for the diagram
       *
       * **Notes:** Default value: "Open Sans", sans-serif.
       */
      external_container_dbFontFamily: '"Open Sans", sans-serif',
      /**
       * This sets the font weight of External Container DB shape for the diagram
       *
       * **Notes:** Default value: normal.
       */
      external_container_dbFontWeight: "normal",
      /**
       * This sets the font size of Container Queue shape for the diagram
       *
       * **Notes:** Default value: 14.
       */
      container_queueFontSize: 14,
      /**
       * This sets the font family of Container Queue shape for the diagram
       *
       * **Notes:** Default value: "Open Sans", sans-serif.
       */
      container_queueFontFamily: '"Open Sans", sans-serif',
      /**
       * This sets the font weight of Container Queue shape for the diagram
       *
       * **Notes:** Default value: normal.
       */
      container_queueFontWeight: "normal",
      /**
       * This sets the font size of External Container Queue shape for the diagram
       *
       * **Notes:** Default value: 14.
       */
      external_container_queueFontSize: 14,
      /**
       * This sets the font family of External Container Queue shape for the diagram
       *
       * **Notes:** Default value: "Open Sans", sans-serif.
       */
      external_container_queueFontFamily: '"Open Sans", sans-serif',
      /**
       * This sets the font weight of External Container Queue shape for the diagram
       *
       * **Notes:** Default value: normal.
       */
      external_container_queueFontWeight: "normal",
      /**
       * This sets the font size of Component shape for the diagram
       *
       * **Notes:** Default value: 14.
       */
      componentFontSize: 14,
      /**
       * This sets the font family of Component shape for the diagram
       *
       * **Notes:** Default value: "Open Sans", sans-serif.
       */
      componentFontFamily: '"Open Sans", sans-serif',
      /**
       * This sets the font weight of Component shape for the diagram
       *
       * **Notes:** Default value: normal.
       */
      componentFontWeight: "normal",
      /**
       * This sets the font size of External Component shape for the diagram
       *
       * **Notes:** Default value: 14.
       */
      external_componentFontSize: 14,
      /**
       * This sets the font family of External Component shape for the diagram
       *
       * **Notes:** Default value: "Open Sans", sans-serif.
       */
      external_componentFontFamily: '"Open Sans", sans-serif',
      /**
       * This sets the font weight of External Component shape for the diagram
       *
       * **Notes:** Default value: normal.
       */
      external_componentFontWeight: "normal",
      /**
       * This sets the font size of Component DB shape for the diagram
       *
       * **Notes:** Default value: 14.
       */
      component_dbFontSize: 14,
      /**
       * This sets the font family of Component DB shape for the diagram
       *
       * **Notes:** Default value: "Open Sans", sans-serif.
       */
      component_dbFontFamily: '"Open Sans", sans-serif',
      /**
       * This sets the font weight of Component DB shape for the diagram
       *
       * **Notes:** Default value: normal.
       */
      component_dbFontWeight: "normal",
      /**
       * This sets the font size of External Component DB shape for the diagram
       *
       * **Notes:** Default value: 14.
       */
      external_component_dbFontSize: 14,
      /**
       * This sets the font family of External Component DB shape for the diagram
       *
       * **Notes:** Default value: "Open Sans", sans-serif.
       */
      external_component_dbFontFamily: '"Open Sans", sans-serif',
      /**
       * This sets the font weight of External Component DB shape for the diagram
       *
       * **Notes:** Default value: normal.
       */
      external_component_dbFontWeight: "normal",
      /**
       * This sets the font size of Component Queue shape for the diagram
       *
       * **Notes:** Default value: 14.
       */
      component_queueFontSize: 14,
      /**
       * This sets the font family of Component Queue shape for the diagram
       *
       * **Notes:** Default value: "Open Sans", sans-serif.
       */
      component_queueFontFamily: '"Open Sans", sans-serif',
      /**
       * This sets the font weight of Component Queue shape for the diagram
       *
       * **Notes:** Default value: normal.
       */
      component_queueFontWeight: "normal",
      /**
       * This sets the font size of External Component Queue shape for the diagram
       *
       * **Notes:** Default value: 14.
       */
      external_component_queueFontSize: 14,
      /**
       * This sets the font family of External Component Queue shape for the diagram
       *
       * **Notes:** Default value: "Open Sans", sans-serif.
       */
      external_component_queueFontFamily: '"Open Sans", sans-serif',
      /**
       * This sets the font weight of External Component Queue shape for the diagram
       *
       * **Notes:** Default value: normal.
       */
      external_component_queueFontWeight: "normal",
      /**
       * This sets the auto-wrap state for the diagram
       *
       * **Notes:** Default value: true.
       */
      wrap: true,
      /**
       * This sets the auto-wrap padding for the diagram (sides only)
       *
       * **Notes:** Default value: 0.
       */
      wrapPadding: 10,
      personFont: function() {
        return {
          fontFamily: this.personFontFamily,
          fontSize: this.personFontSize,
          fontWeight: this.personFontWeight
        };
      },
      external_personFont: function() {
        return {
          fontFamily: this.external_personFontFamily,
          fontSize: this.external_personFontSize,
          fontWeight: this.external_personFontWeight
        };
      },
      systemFont: function() {
        return {
          fontFamily: this.systemFontFamily,
          fontSize: this.systemFontSize,
          fontWeight: this.systemFontWeight
        };
      },
      external_systemFont: function() {
        return {
          fontFamily: this.external_systemFontFamily,
          fontSize: this.external_systemFontSize,
          fontWeight: this.external_systemFontWeight
        };
      },
      system_dbFont: function() {
        return {
          fontFamily: this.system_dbFontFamily,
          fontSize: this.system_dbFontSize,
          fontWeight: this.system_dbFontWeight
        };
      },
      external_system_dbFont: function() {
        return {
          fontFamily: this.external_system_dbFontFamily,
          fontSize: this.external_system_dbFontSize,
          fontWeight: this.external_system_dbFontWeight
        };
      },
      system_queueFont: function() {
        return {
          fontFamily: this.system_queueFontFamily,
          fontSize: this.system_queueFontSize,
          fontWeight: this.system_queueFontWeight
        };
      },
      external_system_queueFont: function() {
        return {
          fontFamily: this.external_system_queueFontFamily,
          fontSize: this.external_system_queueFontSize,
          fontWeight: this.external_system_queueFontWeight
        };
      },
      containerFont: function() {
        return {
          fontFamily: this.containerFontFamily,
          fontSize: this.containerFontSize,
          fontWeight: this.containerFontWeight
        };
      },
      external_containerFont: function() {
        return {
          fontFamily: this.external_containerFontFamily,
          fontSize: this.external_containerFontSize,
          fontWeight: this.external_containerFontWeight
        };
      },
      container_dbFont: function() {
        return {
          fontFamily: this.container_dbFontFamily,
          fontSize: this.container_dbFontSize,
          fontWeight: this.container_dbFontWeight
        };
      },
      external_container_dbFont: function() {
        return {
          fontFamily: this.external_container_dbFontFamily,
          fontSize: this.external_container_dbFontSize,
          fontWeight: this.external_container_dbFontWeight
        };
      },
      container_queueFont: function() {
        return {
          fontFamily: this.container_queueFontFamily,
          fontSize: this.container_queueFontSize,
          fontWeight: this.container_queueFontWeight
        };
      },
      external_container_queueFont: function() {
        return {
          fontFamily: this.external_container_queueFontFamily,
          fontSize: this.external_container_queueFontSize,
          fontWeight: this.external_container_queueFontWeight
        };
      },
      componentFont: function() {
        return {
          fontFamily: this.componentFontFamily,
          fontSize: this.componentFontSize,
          fontWeight: this.componentFontWeight
        };
      },
      external_componentFont: function() {
        return {
          fontFamily: this.external_componentFontFamily,
          fontSize: this.external_componentFontSize,
          fontWeight: this.external_componentFontWeight
        };
      },
      component_dbFont: function() {
        return {
          fontFamily: this.component_dbFontFamily,
          fontSize: this.component_dbFontSize,
          fontWeight: this.component_dbFontWeight
        };
      },
      external_component_dbFont: function() {
        return {
          fontFamily: this.external_component_dbFontFamily,
          fontSize: this.external_component_dbFontSize,
          fontWeight: this.external_component_dbFontWeight
        };
      },
      component_queueFont: function() {
        return {
          fontFamily: this.component_queueFontFamily,
          fontSize: this.component_queueFontSize,
          fontWeight: this.component_queueFontWeight
        };
      },
      external_component_queueFont: function() {
        return {
          fontFamily: this.external_component_queueFontFamily,
          fontSize: this.external_component_queueFontSize,
          fontWeight: this.external_component_queueFontWeight
        };
      },
      boundaryFont: function() {
        return {
          fontFamily: this.boundaryFontFamily,
          fontSize: this.boundaryFontSize,
          fontWeight: this.boundaryFontWeight
        };
      },
      messageFont: function() {
        return {
          fontFamily: this.messageFontFamily,
          fontSize: this.messageFontSize,
          fontWeight: this.messageFontWeight
        };
      },
      // ' Colors
      // ' ##################################
      person_bg_color: "#08427B",
      person_border_color: "#073B6F",
      external_person_bg_color: "#686868",
      external_person_border_color: "#8A8A8A",
      system_bg_color: "#1168BD",
      system_border_color: "#3C7FC0",
      system_db_bg_color: "#1168BD",
      system_db_border_color: "#3C7FC0",
      system_queue_bg_color: "#1168BD",
      system_queue_border_color: "#3C7FC0",
      external_system_bg_color: "#999999",
      external_system_border_color: "#8A8A8A",
      external_system_db_bg_color: "#999999",
      external_system_db_border_color: "#8A8A8A",
      external_system_queue_bg_color: "#999999",
      external_system_queue_border_color: "#8A8A8A",
      container_bg_color: "#438DD5",
      container_border_color: "#3C7FC0",
      container_db_bg_color: "#438DD5",
      container_db_border_color: "#3C7FC0",
      container_queue_bg_color: "#438DD5",
      container_queue_border_color: "#3C7FC0",
      external_container_bg_color: "#B3B3B3",
      external_container_border_color: "#A6A6A6",
      external_container_db_bg_color: "#B3B3B3",
      external_container_db_border_color: "#A6A6A6",
      external_container_queue_bg_color: "#B3B3B3",
      external_container_queue_border_color: "#A6A6A6",
      component_bg_color: "#85BBF0",
      component_border_color: "#78A8D8",
      component_db_bg_color: "#85BBF0",
      component_db_border_color: "#78A8D8",
      component_queue_bg_color: "#85BBF0",
      component_queue_border_color: "#78A8D8",
      external_component_bg_color: "#CCCCCC",
      external_component_border_color: "#BFBFBF",
      external_component_db_bg_color: "#CCCCCC",
      external_component_db_border_color: "#BFBFBF",
      external_component_queue_bg_color: "#CCCCCC",
      external_component_queue_border_color: "#BFBFBF"
    },
    mindmap: {
      useMaxWidth: true,
      padding: 10,
      maxNodeWidth: 200
    },
    fontSize: 16
  };
  if (config$2.class) {
    config$2.class.arrowMarkerAbsolute = config$2.arrowMarkerAbsolute;
  }
  if (config$2.gitGraph) {
    config$2.gitGraph.arrowMarkerAbsolute = config$2.arrowMarkerAbsolute;
  }
  const keyify = (obj, prefix = "") => Object.keys(obj).reduce((res, el) => {
    if (Array.isArray(obj[el])) {
      return res;
    } else if (typeof obj[el] === "object" && obj[el] !== null) {
      return [...res, prefix + el, ...keyify(obj[el], "")];
    }
    return [...res, prefix + el];
  }, []);
  const configKeys = keyify(config$2, "");
  const defaultConfig$1 = config$2;
  /*! js-yaml 4.1.0 https://github.com/nodeca/js-yaml @license MIT */
  function isNothing(subject) {
    return typeof subject === "undefined" || subject === null;
  }
  function isObject$1(subject) {
    return typeof subject === "object" && subject !== null;
  }
  function toArray(sequence2) {
    if (Array.isArray(sequence2))
      return sequence2;
    else if (isNothing(sequence2))
      return [];
    return [sequence2];
  }
  function extend(target, source) {
    var index2, length2, key, sourceKeys;
    if (source) {
      sourceKeys = Object.keys(source);
      for (index2 = 0, length2 = sourceKeys.length; index2 < length2; index2 += 1) {
        key = sourceKeys[index2];
        target[key] = source[key];
      }
    }
    return target;
  }
  function repeat(string2, count) {
    var result = "", cycle;
    for (cycle = 0; cycle < count; cycle += 1) {
      result += string2;
    }
    return result;
  }
  function isNegativeZero(number2) {
    return number2 === 0 && Number.NEGATIVE_INFINITY === 1 / number2;
  }
  var isNothing_1 = isNothing;
  var isObject_1 = isObject$1;
  var toArray_1 = toArray;
  var repeat_1 = repeat;
  var isNegativeZero_1 = isNegativeZero;
  var extend_1 = extend;
  var common = {
    isNothing: isNothing_1,
    isObject: isObject_1,
    toArray: toArray_1,
    repeat: repeat_1,
    isNegativeZero: isNegativeZero_1,
    extend: extend_1
  };
  function formatError(exception2, compact) {
    var where = "", message2 = exception2.reason || "(unknown reason)";
    if (!exception2.mark)
      return message2;
    if (exception2.mark.name) {
      where += 'in "' + exception2.mark.name + '" ';
    }
    where += "(" + (exception2.mark.line + 1) + ":" + (exception2.mark.column + 1) + ")";
    if (!compact && exception2.mark.snippet) {
      where += "\n\n" + exception2.mark.snippet;
    }
    return message2 + " " + where;
  }
  function YAMLException$1(reason, mark) {
    Error.call(this);
    this.name = "YAMLException";
    this.reason = reason;
    this.mark = mark;
    this.message = formatError(this, false);
    if (Error.captureStackTrace) {
      Error.captureStackTrace(this, this.constructor);
    } else {
      this.stack = new Error().stack || "";
    }
  }
  YAMLException$1.prototype = Object.create(Error.prototype);
  YAMLException$1.prototype.constructor = YAMLException$1;
  YAMLException$1.prototype.toString = function toString2(compact) {
    return this.name + ": " + formatError(this, compact);
  };
  var exception = YAMLException$1;
  function getLine(buffer, lineStart, lineEnd, position2, maxLineLength) {
    var head2 = "";
    var tail = "";
    var maxHalfLength = Math.floor(maxLineLength / 2) - 1;
    if (position2 - lineStart > maxHalfLength) {
      head2 = " ... ";
      lineStart = position2 - maxHalfLength + head2.length;
    }
    if (lineEnd - position2 > maxHalfLength) {
      tail = " ...";
      lineEnd = position2 + maxHalfLength - tail.length;
    }
    return {
      str: head2 + buffer.slice(lineStart, lineEnd).replace(/\t/g, "→") + tail,
      pos: position2 - lineStart + head2.length
      // relative position
    };
  }
  function padStart(string2, max2) {
    return common.repeat(" ", max2 - string2.length) + string2;
  }
  function makeSnippet(mark, options2) {
    options2 = Object.create(options2 || null);
    if (!mark.buffer)
      return null;
    if (!options2.maxLength)
      options2.maxLength = 79;
    if (typeof options2.indent !== "number")
      options2.indent = 1;
    if (typeof options2.linesBefore !== "number")
      options2.linesBefore = 3;
    if (typeof options2.linesAfter !== "number")
      options2.linesAfter = 2;
    var re2 = /\r?\n|\r|\0/g;
    var lineStarts = [0];
    var lineEnds = [];
    var match;
    var foundLineNo = -1;
    while (match = re2.exec(mark.buffer)) {
      lineEnds.push(match.index);
      lineStarts.push(match.index + match[0].length);
      if (mark.position <= match.index && foundLineNo < 0) {
        foundLineNo = lineStarts.length - 2;
      }
    }
    if (foundLineNo < 0)
      foundLineNo = lineStarts.length - 1;
    var result = "", i2, line2;
    var lineNoLength = Math.min(mark.line + options2.linesAfter, lineEnds.length).toString().length;
    var maxLineLength = options2.maxLength - (options2.indent + lineNoLength + 3);
    for (i2 = 1; i2 <= options2.linesBefore; i2++) {
      if (foundLineNo - i2 < 0)
        break;
      line2 = getLine(
        mark.buffer,
        lineStarts[foundLineNo - i2],
        lineEnds[foundLineNo - i2],
        mark.position - (lineStarts[foundLineNo] - lineStarts[foundLineNo - i2]),
        maxLineLength
      );
      result = common.repeat(" ", options2.indent) + padStart((mark.line - i2 + 1).toString(), lineNoLength) + " | " + line2.str + "\n" + result;
    }
    line2 = getLine(mark.buffer, lineStarts[foundLineNo], lineEnds[foundLineNo], mark.position, maxLineLength);
    result += common.repeat(" ", options2.indent) + padStart((mark.line + 1).toString(), lineNoLength) + " | " + line2.str + "\n";
    result += common.repeat("-", options2.indent + lineNoLength + 3 + line2.pos) + "^\n";
    for (i2 = 1; i2 <= options2.linesAfter; i2++) {
      if (foundLineNo + i2 >= lineEnds.length)
        break;
      line2 = getLine(
        mark.buffer,
        lineStarts[foundLineNo + i2],
        lineEnds[foundLineNo + i2],
        mark.position - (lineStarts[foundLineNo] - lineStarts[foundLineNo + i2]),
        maxLineLength
      );
      result += common.repeat(" ", options2.indent) + padStart((mark.line + i2 + 1).toString(), lineNoLength) + " | " + line2.str + "\n";
    }
    return result.replace(/\n$/, "");
  }
  var snippet = makeSnippet;
  var TYPE_CONSTRUCTOR_OPTIONS = [
    "kind",
    "multi",
    "resolve",
    "construct",
    "instanceOf",
    "predicate",
    "represent",
    "representName",
    "defaultStyle",
    "styleAliases"
  ];
  var YAML_NODE_KINDS = [
    "scalar",
    "sequence",
    "mapping"
  ];
  function compileStyleAliases(map2) {
    var result = {};
    if (map2 !== null) {
      Object.keys(map2).forEach(function(style) {
        map2[style].forEach(function(alias) {
          result[String(alias)] = style;
        });
      });
    }
    return result;
  }
  function Type$1(tag, options2) {
    options2 = options2 || {};
    Object.keys(options2).forEach(function(name2) {
      if (TYPE_CONSTRUCTOR_OPTIONS.indexOf(name2) === -1) {
        throw new exception('Unknown option "' + name2 + '" is met in definition of "' + tag + '" YAML type.');
      }
    });
    this.options = options2;
    this.tag = tag;
    this.kind = options2["kind"] || null;
    this.resolve = options2["resolve"] || function() {
      return true;
    };
    this.construct = options2["construct"] || function(data) {
      return data;
    };
    this.instanceOf = options2["instanceOf"] || null;
    this.predicate = options2["predicate"] || null;
    this.represent = options2["represent"] || null;
    this.representName = options2["representName"] || null;
    this.defaultStyle = options2["defaultStyle"] || null;
    this.multi = options2["multi"] || false;
    this.styleAliases = compileStyleAliases(options2["styleAliases"] || null);
    if (YAML_NODE_KINDS.indexOf(this.kind) === -1) {
      throw new exception('Unknown kind "' + this.kind + '" is specified for "' + tag + '" YAML type.');
    }
  }
  var type = Type$1;
  function compileList(schema2, name2) {
    var result = [];
    schema2[name2].forEach(function(currentType) {
      var newIndex = result.length;
      result.forEach(function(previousType, previousIndex) {
        if (previousType.tag === currentType.tag && previousType.kind === currentType.kind && previousType.multi === currentType.multi) {
          newIndex = previousIndex;
        }
      });
      result[newIndex] = currentType;
    });
    return result;
  }
  function compileMap() {
    var result = {
      scalar: {},
      sequence: {},
      mapping: {},
      fallback: {},
      multi: {
        scalar: [],
        sequence: [],
        mapping: [],
        fallback: []
      }
    }, index2, length2;
    function collectType(type2) {
      if (type2.multi) {
        result.multi[type2.kind].push(type2);
        result.multi["fallback"].push(type2);
      } else {
        result[type2.kind][type2.tag] = result["fallback"][type2.tag] = type2;
      }
    }
    for (index2 = 0, length2 = arguments.length; index2 < length2; index2 += 1) {
      arguments[index2].forEach(collectType);
    }
    return result;
  }
  function Schema$1(definition2) {
    return this.extend(definition2);
  }
  Schema$1.prototype.extend = function extend2(definition2) {
    var implicit2 = [];
    var explicit = [];
    if (definition2 instanceof type) {
      explicit.push(definition2);
    } else if (Array.isArray(definition2)) {
      explicit = explicit.concat(definition2);
    } else if (definition2 && (Array.isArray(definition2.implicit) || Array.isArray(definition2.explicit))) {
      if (definition2.implicit)
        implicit2 = implicit2.concat(definition2.implicit);
      if (definition2.explicit)
        explicit = explicit.concat(definition2.explicit);
    } else {
      throw new exception("Schema.extend argument should be a Type, [ Type ], or a schema definition ({ implicit: [...], explicit: [...] })");
    }
    implicit2.forEach(function(type$1) {
      if (!(type$1 instanceof type)) {
        throw new exception("Specified list of YAML types (or a single Type object) contains a non-Type object.");
      }
      if (type$1.loadKind && type$1.loadKind !== "scalar") {
        throw new exception("There is a non-scalar type in the implicit list of a schema. Implicit resolving of such types is not supported.");
      }
      if (type$1.multi) {
        throw new exception("There is a multi type in the implicit list of a schema. Multi tags can only be listed as explicit.");
      }
    });
    explicit.forEach(function(type$1) {
      if (!(type$1 instanceof type)) {
        throw new exception("Specified list of YAML types (or a single Type object) contains a non-Type object.");
      }
    });
    var result = Object.create(Schema$1.prototype);
    result.implicit = (this.implicit || []).concat(implicit2);
    result.explicit = (this.explicit || []).concat(explicit);
    result.compiledImplicit = compileList(result, "implicit");
    result.compiledExplicit = compileList(result, "explicit");
    result.compiledTypeMap = compileMap(result.compiledImplicit, result.compiledExplicit);
    return result;
  };
  var schema = Schema$1;
  var str = new type("tag:yaml.org,2002:str", {
    kind: "scalar",
    construct: function(data) {
      return data !== null ? data : "";
    }
  });
  var seq$1 = new type("tag:yaml.org,2002:seq", {
    kind: "sequence",
    construct: function(data) {
      return data !== null ? data : [];
    }
  });
  var map$1 = new type("tag:yaml.org,2002:map", {
    kind: "mapping",
    construct: function(data) {
      return data !== null ? data : {};
    }
  });
  var failsafe = new schema({
    explicit: [
      str,
      seq$1,
      map$1
    ]
  });
  function resolveYamlNull(data) {
    if (data === null)
      return true;
    var max2 = data.length;
    return max2 === 1 && data === "~" || max2 === 4 && (data === "null" || data === "Null" || data === "NULL");
  }
  function constructYamlNull() {
    return null;
  }
  function isNull(object2) {
    return object2 === null;
  }
  var _null = new type("tag:yaml.org,2002:null", {
    kind: "scalar",
    resolve: resolveYamlNull,
    construct: constructYamlNull,
    predicate: isNull,
    represent: {
      canonical: function() {
        return "~";
      },
      lowercase: function() {
        return "null";
      },
      uppercase: function() {
        return "NULL";
      },
      camelcase: function() {
        return "Null";
      },
      empty: function() {
        return "";
      }
    },
    defaultStyle: "lowercase"
  });
  function resolveYamlBoolean(data) {
    if (data === null)
      return false;
    var max2 = data.length;
    return max2 === 4 && (data === "true" || data === "True" || data === "TRUE") || max2 === 5 && (data === "false" || data === "False" || data === "FALSE");
  }
  function constructYamlBoolean(data) {
    return data === "true" || data === "True" || data === "TRUE";
  }
  function isBoolean(object2) {
    return Object.prototype.toString.call(object2) === "[object Boolean]";
  }
  var bool = new type("tag:yaml.org,2002:bool", {
    kind: "scalar",
    resolve: resolveYamlBoolean,
    construct: constructYamlBoolean,
    predicate: isBoolean,
    represent: {
      lowercase: function(object2) {
        return object2 ? "true" : "false";
      },
      uppercase: function(object2) {
        return object2 ? "TRUE" : "FALSE";
      },
      camelcase: function(object2) {
        return object2 ? "True" : "False";
      }
    },
    defaultStyle: "lowercase"
  });
  function isHexCode(c2) {
    return 48 <= c2 && c2 <= 57 || 65 <= c2 && c2 <= 70 || 97 <= c2 && c2 <= 102;
  }
  function isOctCode(c2) {
    return 48 <= c2 && c2 <= 55;
  }
  function isDecCode(c2) {
    return 48 <= c2 && c2 <= 57;
  }
  function resolveYamlInteger(data) {
    if (data === null)
      return false;
    var max2 = data.length, index2 = 0, hasDigits = false, ch;
    if (!max2)
      return false;
    ch = data[index2];
    if (ch === "-" || ch === "+") {
      ch = data[++index2];
    }
    if (ch === "0") {
      if (index2 + 1 === max2)
        return true;
      ch = data[++index2];
      if (ch === "b") {
        index2++;
        for (; index2 < max2; index2++) {
          ch = data[index2];
          if (ch === "_")
            continue;
          if (ch !== "0" && ch !== "1")
            return false;
          hasDigits = true;
        }
        return hasDigits && ch !== "_";
      }
      if (ch === "x") {
        index2++;
        for (; index2 < max2; index2++) {
          ch = data[index2];
          if (ch === "_")
            continue;
          if (!isHexCode(data.charCodeAt(index2)))
            return false;
          hasDigits = true;
        }
        return hasDigits && ch !== "_";
      }
      if (ch === "o") {
        index2++;
        for (; index2 < max2; index2++) {
          ch = data[index2];
          if (ch === "_")
            continue;
          if (!isOctCode(data.charCodeAt(index2)))
            return false;
          hasDigits = true;
        }
        return hasDigits && ch !== "_";
      }
    }
    if (ch === "_")
      return false;
    for (; index2 < max2; index2++) {
      ch = data[index2];
      if (ch === "_")
        continue;
      if (!isDecCode(data.charCodeAt(index2))) {
        return false;
      }
      hasDigits = true;
    }
    if (!hasDigits || ch === "_")
      return false;
    return true;
  }
  function constructYamlInteger(data) {
    var value = data, sign2 = 1, ch;
    if (value.indexOf("_") !== -1) {
      value = value.replace(/_/g, "");
    }
    ch = value[0];
    if (ch === "-" || ch === "+") {
      if (ch === "-")
        sign2 = -1;
      value = value.slice(1);
      ch = value[0];
    }
    if (value === "0")
      return 0;
    if (ch === "0") {
      if (value[1] === "b")
        return sign2 * parseInt(value.slice(2), 2);
      if (value[1] === "x")
        return sign2 * parseInt(value.slice(2), 16);
      if (value[1] === "o")
        return sign2 * parseInt(value.slice(2), 8);
    }
    return sign2 * parseInt(value, 10);
  }
  function isInteger(object2) {
    return Object.prototype.toString.call(object2) === "[object Number]" && (object2 % 1 === 0 && !common.isNegativeZero(object2));
  }
  var int = new type("tag:yaml.org,2002:int", {
    kind: "scalar",
    resolve: resolveYamlInteger,
    construct: constructYamlInteger,
    predicate: isInteger,
    represent: {
      binary: function(obj) {
        return obj >= 0 ? "0b" + obj.toString(2) : "-0b" + obj.toString(2).slice(1);
      },
      octal: function(obj) {
        return obj >= 0 ? "0o" + obj.toString(8) : "-0o" + obj.toString(8).slice(1);
      },
      decimal: function(obj) {
        return obj.toString(10);
      },
      /* eslint-disable max-len */
      hexadecimal: function(obj) {
        return obj >= 0 ? "0x" + obj.toString(16).toUpperCase() : "-0x" + obj.toString(16).toUpperCase().slice(1);
      }
    },
    defaultStyle: "decimal",
    styleAliases: {
      binary: [2, "bin"],
      octal: [8, "oct"],
      decimal: [10, "dec"],
      hexadecimal: [16, "hex"]
    }
  });
  var YAML_FLOAT_PATTERN = new RegExp(
    // 2.5e4, 2.5 and integers
    "^(?:[-+]?(?:[0-9][0-9_]*)(?:\\.[0-9_]*)?(?:[eE][-+]?[0-9]+)?|\\.[0-9_]+(?:[eE][-+]?[0-9]+)?|[-+]?\\.(?:inf|Inf|INF)|\\.(?:nan|NaN|NAN))$"
  );
  function resolveYamlFloat(data) {
    if (data === null)
      return false;
    if (!YAML_FLOAT_PATTERN.test(data) || // Quick hack to not allow integers end with `_`
    // Probably should update regexp & check speed
    data[data.length - 1] === "_") {
      return false;
    }
    return true;
  }
  function constructYamlFloat(data) {
    var value, sign2;
    value = data.replace(/_/g, "").toLowerCase();
    sign2 = value[0] === "-" ? -1 : 1;
    if ("+-".indexOf(value[0]) >= 0) {
      value = value.slice(1);
    }
    if (value === ".inf") {
      return sign2 === 1 ? Number.POSITIVE_INFINITY : Number.NEGATIVE_INFINITY;
    } else if (value === ".nan") {
      return NaN;
    }
    return sign2 * parseFloat(value, 10);
  }
  var SCIENTIFIC_WITHOUT_DOT = /^[-+]?[0-9]+e/;
  function representYamlFloat(object2, style) {
    var res;
    if (isNaN(object2)) {
      switch (style) {
        case "lowercase":
          return ".nan";
        case "uppercase":
          return ".NAN";
        case "camelcase":
          return ".NaN";
      }
    } else if (Number.POSITIVE_INFINITY === object2) {
      switch (style) {
        case "lowercase":
          return ".inf";
        case "uppercase":
          return ".INF";
        case "camelcase":
          return ".Inf";
      }
    } else if (Number.NEGATIVE_INFINITY === object2) {
      switch (style) {
        case "lowercase":
          return "-.inf";
        case "uppercase":
          return "-.INF";
        case "camelcase":
          return "-.Inf";
      }
    } else if (common.isNegativeZero(object2)) {
      return "-0.0";
    }
    res = object2.toString(10);
    return SCIENTIFIC_WITHOUT_DOT.test(res) ? res.replace("e", ".e") : res;
  }
  function isFloat(object2) {
    return Object.prototype.toString.call(object2) === "[object Number]" && (object2 % 1 !== 0 || common.isNegativeZero(object2));
  }
  var float = new type("tag:yaml.org,2002:float", {
    kind: "scalar",
    resolve: resolveYamlFloat,
    construct: constructYamlFloat,
    predicate: isFloat,
    represent: representYamlFloat,
    defaultStyle: "lowercase"
  });
  var json = failsafe.extend({
    implicit: [
      _null,
      bool,
      int,
      float
    ]
  });
  var core = json;
  var YAML_DATE_REGEXP = new RegExp(
    "^([0-9][0-9][0-9][0-9])-([0-9][0-9])-([0-9][0-9])$"
  );
  var YAML_TIMESTAMP_REGEXP = new RegExp(
    "^([0-9][0-9][0-9][0-9])-([0-9][0-9]?)-([0-9][0-9]?)(?:[Tt]|[ \\t]+)([0-9][0-9]?):([0-9][0-9]):([0-9][0-9])(?:\\.([0-9]*))?(?:[ \\t]*(Z|([-+])([0-9][0-9]?)(?::([0-9][0-9]))?))?$"
  );
  function resolveYamlTimestamp(data) {
    if (data === null)
      return false;
    if (YAML_DATE_REGEXP.exec(data) !== null)
      return true;
    if (YAML_TIMESTAMP_REGEXP.exec(data) !== null)
      return true;
    return false;
  }
  function constructYamlTimestamp(data) {
    var match, year2, month2, day2, hour2, minute2, second2, fraction = 0, delta = null, tz_hour, tz_minute, date2;
    match = YAML_DATE_REGEXP.exec(data);
    if (match === null)
      match = YAML_TIMESTAMP_REGEXP.exec(data);
    if (match === null)
      throw new Error("Date resolve error");
    year2 = +match[1];
    month2 = +match[2] - 1;
    day2 = +match[3];
    if (!match[4]) {
      return new Date(Date.UTC(year2, month2, day2));
    }
    hour2 = +match[4];
    minute2 = +match[5];
    second2 = +match[6];
    if (match[7]) {
      fraction = match[7].slice(0, 3);
      while (fraction.length < 3) {
        fraction += "0";
      }
      fraction = +fraction;
    }
    if (match[9]) {
      tz_hour = +match[10];
      tz_minute = +(match[11] || 0);
      delta = (tz_hour * 60 + tz_minute) * 6e4;
      if (match[9] === "-")
        delta = -delta;
    }
    date2 = new Date(Date.UTC(year2, month2, day2, hour2, minute2, second2, fraction));
    if (delta)
      date2.setTime(date2.getTime() - delta);
    return date2;
  }
  function representYamlTimestamp(object2) {
    return object2.toISOString();
  }
  var timestamp = new type("tag:yaml.org,2002:timestamp", {
    kind: "scalar",
    resolve: resolveYamlTimestamp,
    construct: constructYamlTimestamp,
    instanceOf: Date,
    represent: representYamlTimestamp
  });
  function resolveYamlMerge(data) {
    return data === "<<" || data === null;
  }
  var merge$3 = new type("tag:yaml.org,2002:merge", {
    kind: "scalar",
    resolve: resolveYamlMerge
  });
  var BASE64_MAP = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=\n\r";
  function resolveYamlBinary(data) {
    if (data === null)
      return false;
    var code, idx, bitlen = 0, max2 = data.length, map2 = BASE64_MAP;
    for (idx = 0; idx < max2; idx++) {
      code = map2.indexOf(data.charAt(idx));
      if (code > 64)
        continue;
      if (code < 0)
        return false;
      bitlen += 6;
    }
    return bitlen % 8 === 0;
  }
  function constructYamlBinary(data) {
    var idx, tailbits, input = data.replace(/[\r\n=]/g, ""), max2 = input.length, map2 = BASE64_MAP, bits = 0, result = [];
    for (idx = 0; idx < max2; idx++) {
      if (idx % 4 === 0 && idx) {
        result.push(bits >> 16 & 255);
        result.push(bits >> 8 & 255);
        result.push(bits & 255);
      }
      bits = bits << 6 | map2.indexOf(input.charAt(idx));
    }
    tailbits = max2 % 4 * 6;
    if (tailbits === 0) {
      result.push(bits >> 16 & 255);
      result.push(bits >> 8 & 255);
      result.push(bits & 255);
    } else if (tailbits === 18) {
      result.push(bits >> 10 & 255);
      result.push(bits >> 2 & 255);
    } else if (tailbits === 12) {
      result.push(bits >> 4 & 255);
    }
    return new Uint8Array(result);
  }
  function representYamlBinary(object2) {
    var result = "", bits = 0, idx, tail, max2 = object2.length, map2 = BASE64_MAP;
    for (idx = 0; idx < max2; idx++) {
      if (idx % 3 === 0 && idx) {
        result += map2[bits >> 18 & 63];
        result += map2[bits >> 12 & 63];
        result += map2[bits >> 6 & 63];
        result += map2[bits & 63];
      }
      bits = (bits << 8) + object2[idx];
    }
    tail = max2 % 3;
    if (tail === 0) {
      result += map2[bits >> 18 & 63];
      result += map2[bits >> 12 & 63];
      result += map2[bits >> 6 & 63];
      result += map2[bits & 63];
    } else if (tail === 2) {
      result += map2[bits >> 10 & 63];
      result += map2[bits >> 4 & 63];
      result += map2[bits << 2 & 63];
      result += map2[64];
    } else if (tail === 1) {
      result += map2[bits >> 2 & 63];
      result += map2[bits << 4 & 63];
      result += map2[64];
      result += map2[64];
    }
    return result;
  }
  function isBinary(obj) {
    return Object.prototype.toString.call(obj) === "[object Uint8Array]";
  }
  var binary = new type("tag:yaml.org,2002:binary", {
    kind: "scalar",
    resolve: resolveYamlBinary,
    construct: constructYamlBinary,
    predicate: isBinary,
    represent: representYamlBinary
  });
  var _hasOwnProperty$3 = Object.prototype.hasOwnProperty;
  var _toString$2 = Object.prototype.toString;
  function resolveYamlOmap(data) {
    if (data === null)
      return true;
    var objectKeys = [], index2, length2, pair, pairKey, pairHasKey, object2 = data;
    for (index2 = 0, length2 = object2.length; index2 < length2; index2 += 1) {
      pair = object2[index2];
      pairHasKey = false;
      if (_toString$2.call(pair) !== "[object Object]")
        return false;
      for (pairKey in pair) {
        if (_hasOwnProperty$3.call(pair, pairKey)) {
          if (!pairHasKey)
            pairHasKey = true;
          else
            return false;
        }
      }
      if (!pairHasKey)
        return false;
      if (objectKeys.indexOf(pairKey) === -1)
        objectKeys.push(pairKey);
      else
        return false;
    }
    return true;
  }
  function constructYamlOmap(data) {
    return data !== null ? data : [];
  }
  var omap = new type("tag:yaml.org,2002:omap", {
    kind: "sequence",
    resolve: resolveYamlOmap,
    construct: constructYamlOmap
  });
  var _toString$1 = Object.prototype.toString;
  function resolveYamlPairs(data) {
    if (data === null)
      return true;
    var index2, length2, pair, keys2, result, object2 = data;
    result = new Array(object2.length);
    for (index2 = 0, length2 = object2.length; index2 < length2; index2 += 1) {
      pair = object2[index2];
      if (_toString$1.call(pair) !== "[object Object]")
        return false;
      keys2 = Object.keys(pair);
      if (keys2.length !== 1)
        return false;
      result[index2] = [keys2[0], pair[keys2[0]]];
    }
    return true;
  }
  function constructYamlPairs(data) {
    if (data === null)
      return [];
    var index2, length2, pair, keys2, result, object2 = data;
    result = new Array(object2.length);
    for (index2 = 0, length2 = object2.length; index2 < length2; index2 += 1) {
      pair = object2[index2];
      keys2 = Object.keys(pair);
      result[index2] = [keys2[0], pair[keys2[0]]];
    }
    return result;
  }
  var pairs = new type("tag:yaml.org,2002:pairs", {
    kind: "sequence",
    resolve: resolveYamlPairs,
    construct: constructYamlPairs
  });
  var _hasOwnProperty$2 = Object.prototype.hasOwnProperty;
  function resolveYamlSet(data) {
    if (data === null)
      return true;
    var key, object2 = data;
    for (key in object2) {
      if (_hasOwnProperty$2.call(object2, key)) {
        if (object2[key] !== null)
          return false;
      }
    }
    return true;
  }
  function constructYamlSet(data) {
    return data !== null ? data : {};
  }
  var set$1 = new type("tag:yaml.org,2002:set", {
    kind: "mapping",
    resolve: resolveYamlSet,
    construct: constructYamlSet
  });
  var _default = core.extend({
    implicit: [
      timestamp,
      merge$3
    ],
    explicit: [
      binary,
      omap,
      pairs,
      set$1
    ]
  });
  var _hasOwnProperty$1 = Object.prototype.hasOwnProperty;
  var CONTEXT_FLOW_IN = 1;
  var CONTEXT_FLOW_OUT = 2;
  var CONTEXT_BLOCK_IN = 3;
  var CONTEXT_BLOCK_OUT = 4;
  var CHOMPING_CLIP = 1;
  var CHOMPING_STRIP = 2;
  var CHOMPING_KEEP = 3;
  var PATTERN_NON_PRINTABLE = /[\x00-\x08\x0B\x0C\x0E-\x1F\x7F-\x84\x86-\x9F\uFFFE\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]/;
  var PATTERN_NON_ASCII_LINE_BREAKS = /[\x85\u2028\u2029]/;
  var PATTERN_FLOW_INDICATORS = /[,\[\]\{\}]/;
  var PATTERN_TAG_HANDLE = /^(?:!|!!|![a-z\-]+!)$/i;
  var PATTERN_TAG_URI = /^(?:!|[^,\[\]\{\}])(?:%[0-9a-f]{2}|[0-9a-z\-#;\/\?:@&=\+\$,_\.!~\*'\(\)\[\]])*$/i;
  function _class(obj) {
    return Object.prototype.toString.call(obj);
  }
  function is_EOL(c2) {
    return c2 === 10 || c2 === 13;
  }
  function is_WHITE_SPACE(c2) {
    return c2 === 9 || c2 === 32;
  }
  function is_WS_OR_EOL(c2) {
    return c2 === 9 || c2 === 32 || c2 === 10 || c2 === 13;
  }
  function is_FLOW_INDICATOR(c2) {
    return c2 === 44 || c2 === 91 || c2 === 93 || c2 === 123 || c2 === 125;
  }
  function fromHexCode(c2) {
    var lc;
    if (48 <= c2 && c2 <= 57) {
      return c2 - 48;
    }
    lc = c2 | 32;
    if (97 <= lc && lc <= 102) {
      return lc - 97 + 10;
    }
    return -1;
  }
  function escapedHexLen(c2) {
    if (c2 === 120) {
      return 2;
    }
    if (c2 === 117) {
      return 4;
    }
    if (c2 === 85) {
      return 8;
    }
    return 0;
  }
  function fromDecimalCode(c2) {
    if (48 <= c2 && c2 <= 57) {
      return c2 - 48;
    }
    return -1;
  }
  function simpleEscapeSequence(c2) {
    return c2 === 48 ? "\0" : c2 === 97 ? "\x07" : c2 === 98 ? "\b" : c2 === 116 ? "	" : c2 === 9 ? "	" : c2 === 110 ? "\n" : c2 === 118 ? "\v" : c2 === 102 ? "\f" : c2 === 114 ? "\r" : c2 === 101 ? "\x1B" : c2 === 32 ? " " : c2 === 34 ? '"' : c2 === 47 ? "/" : c2 === 92 ? "\\" : c2 === 78 ? "" : c2 === 95 ? " " : c2 === 76 ? "\u2028" : c2 === 80 ? "\u2029" : "";
  }
  function charFromCodepoint(c2) {
    if (c2 <= 65535) {
      return String.fromCharCode(c2);
    }
    return String.fromCharCode(
      (c2 - 65536 >> 10) + 55296,
      (c2 - 65536 & 1023) + 56320
    );
  }
  var simpleEscapeCheck = new Array(256);
  var simpleEscapeMap = new Array(256);
  for (var i = 0; i < 256; i++) {
    simpleEscapeCheck[i] = simpleEscapeSequence(i) ? 1 : 0;
    simpleEscapeMap[i] = simpleEscapeSequence(i);
  }
  function State$1(input, options2) {
    this.input = input;
    this.filename = options2["filename"] || null;
    this.schema = options2["schema"] || _default;
    this.onWarning = options2["onWarning"] || null;
    this.legacy = options2["legacy"] || false;
    this.json = options2["json"] || false;
    this.listener = options2["listener"] || null;
    this.implicitTypes = this.schema.compiledImplicit;
    this.typeMap = this.schema.compiledTypeMap;
    this.length = input.length;
    this.position = 0;
    this.line = 0;
    this.lineStart = 0;
    this.lineIndent = 0;
    this.firstTabInLine = -1;
    this.documents = [];
  }
  function generateError(state2, message2) {
    var mark = {
      name: state2.filename,
      buffer: state2.input.slice(0, -1),
      // omit trailing \0
      position: state2.position,
      line: state2.line,
      column: state2.position - state2.lineStart
    };
    mark.snippet = snippet(mark);
    return new exception(message2, mark);
  }
  function throwError(state2, message2) {
    throw generateError(state2, message2);
  }
  function throwWarning(state2, message2) {
    if (state2.onWarning) {
      state2.onWarning.call(null, generateError(state2, message2));
    }
  }
  var directiveHandlers = {
    YAML: function handleYamlDirective(state2, name2, args) {
      var match, major, minor;
      if (state2.version !== null) {
        throwError(state2, "duplication of %YAML directive");
      }
      if (args.length !== 1) {
        throwError(state2, "YAML directive accepts exactly one argument");
      }
      match = /^([0-9]+)\.([0-9]+)$/.exec(args[0]);
      if (match === null) {
        throwError(state2, "ill-formed argument of the YAML directive");
      }
      major = parseInt(match[1], 10);
      minor = parseInt(match[2], 10);
      if (major !== 1) {
        throwError(state2, "unacceptable YAML version of the document");
      }
      state2.version = args[0];
      state2.checkLineBreaks = minor < 2;
      if (minor !== 1 && minor !== 2) {
        throwWarning(state2, "unsupported YAML version of the document");
      }
    },
    TAG: function handleTagDirective(state2, name2, args) {
      var handle, prefix;
      if (args.length !== 2) {
        throwError(state2, "TAG directive accepts exactly two arguments");
      }
      handle = args[0];
      prefix = args[1];
      if (!PATTERN_TAG_HANDLE.test(handle)) {
        throwError(state2, "ill-formed tag handle (first argument) of the TAG directive");
      }
      if (_hasOwnProperty$1.call(state2.tagMap, handle)) {
        throwError(state2, 'there is a previously declared suffix for "' + handle + '" tag handle');
      }
      if (!PATTERN_TAG_URI.test(prefix)) {
        throwError(state2, "ill-formed tag prefix (second argument) of the TAG directive");
      }
      try {
        prefix = decodeURIComponent(prefix);
      } catch (err) {
        throwError(state2, "tag prefix is malformed: " + prefix);
      }
      state2.tagMap[handle] = prefix;
    }
  };
  function captureSegment(state2, start2, end2, checkJson) {
    var _position, _length, _character, _result;
    if (start2 < end2) {
      _result = state2.input.slice(start2, end2);
      if (checkJson) {
        for (_position = 0, _length = _result.length; _position < _length; _position += 1) {
          _character = _result.charCodeAt(_position);
          if (!(_character === 9 || 32 <= _character && _character <= 1114111)) {
            throwError(state2, "expected valid JSON character");
          }
        }
      } else if (PATTERN_NON_PRINTABLE.test(_result)) {
        throwError(state2, "the stream contains non-printable characters");
      }
      state2.result += _result;
    }
  }
  function mergeMappings(state2, destination, source, overridableKeys) {
    var sourceKeys, key, index2, quantity;
    if (!common.isObject(source)) {
      throwError(state2, "cannot merge mappings; the provided source object is unacceptable");
    }
    sourceKeys = Object.keys(source);
    for (index2 = 0, quantity = sourceKeys.length; index2 < quantity; index2 += 1) {
      key = sourceKeys[index2];
      if (!_hasOwnProperty$1.call(destination, key)) {
        destination[key] = source[key];
        overridableKeys[key] = true;
      }
    }
  }
  function storeMappingPair(state2, _result, overridableKeys, keyTag, keyNode, valueNode, startLine, startLineStart, startPos) {
    var index2, quantity;
    if (Array.isArray(keyNode)) {
      keyNode = Array.prototype.slice.call(keyNode);
      for (index2 = 0, quantity = keyNode.length; index2 < quantity; index2 += 1) {
        if (Array.isArray(keyNode[index2])) {
          throwError(state2, "nested arrays are not supported inside keys");
        }
        if (typeof keyNode === "object" && _class(keyNode[index2]) === "[object Object]") {
          keyNode[index2] = "[object Object]";
        }
      }
    }
    if (typeof keyNode === "object" && _class(keyNode) === "[object Object]") {
      keyNode = "[object Object]";
    }
    keyNode = String(keyNode);
    if (_result === null) {
      _result = {};
    }
    if (keyTag === "tag:yaml.org,2002:merge") {
      if (Array.isArray(valueNode)) {
        for (index2 = 0, quantity = valueNode.length; index2 < quantity; index2 += 1) {
          mergeMappings(state2, _result, valueNode[index2], overridableKeys);
        }
      } else {
        mergeMappings(state2, _result, valueNode, overridableKeys);
      }
    } else {
      if (!state2.json && !_hasOwnProperty$1.call(overridableKeys, keyNode) && _hasOwnProperty$1.call(_result, keyNode)) {
        state2.line = startLine || state2.line;
        state2.lineStart = startLineStart || state2.lineStart;
        state2.position = startPos || state2.position;
        throwError(state2, "duplicated mapping key");
      }
      if (keyNode === "__proto__") {
        Object.defineProperty(_result, keyNode, {
          configurable: true,
          enumerable: true,
          writable: true,
          value: valueNode
        });
      } else {
        _result[keyNode] = valueNode;
      }
      delete overridableKeys[keyNode];
    }
    return _result;
  }
  function readLineBreak(state2) {
    var ch;
    ch = state2.input.charCodeAt(state2.position);
    if (ch === 10) {
      state2.position++;
    } else if (ch === 13) {
      state2.position++;
      if (state2.input.charCodeAt(state2.position) === 10) {
        state2.position++;
      }
    } else {
      throwError(state2, "a line break is expected");
    }
    state2.line += 1;
    state2.lineStart = state2.position;
    state2.firstTabInLine = -1;
  }
  function skipSeparationSpace(state2, allowComments, checkIndent) {
    var lineBreaks = 0, ch = state2.input.charCodeAt(state2.position);
    while (ch !== 0) {
      while (is_WHITE_SPACE(ch)) {
        if (ch === 9 && state2.firstTabInLine === -1) {
          state2.firstTabInLine = state2.position;
        }
        ch = state2.input.charCodeAt(++state2.position);
      }
      if (allowComments && ch === 35) {
        do {
          ch = state2.input.charCodeAt(++state2.position);
        } while (ch !== 10 && ch !== 13 && ch !== 0);
      }
      if (is_EOL(ch)) {
        readLineBreak(state2);
        ch = state2.input.charCodeAt(state2.position);
        lineBreaks++;
        state2.lineIndent = 0;
        while (ch === 32) {
          state2.lineIndent++;
          ch = state2.input.charCodeAt(++state2.position);
        }
      } else {
        break;
      }
    }
    if (checkIndent !== -1 && lineBreaks !== 0 && state2.lineIndent < checkIndent) {
      throwWarning(state2, "deficient indentation");
    }
    return lineBreaks;
  }
  function testDocumentSeparator(state2) {
    var _position = state2.position, ch;
    ch = state2.input.charCodeAt(_position);
    if ((ch === 45 || ch === 46) && ch === state2.input.charCodeAt(_position + 1) && ch === state2.input.charCodeAt(_position + 2)) {
      _position += 3;
      ch = state2.input.charCodeAt(_position);
      if (ch === 0 || is_WS_OR_EOL(ch)) {
        return true;
      }
    }
    return false;
  }
  function writeFoldedLines(state2, count) {
    if (count === 1) {
      state2.result += " ";
    } else if (count > 1) {
      state2.result += common.repeat("\n", count - 1);
    }
  }
  function readPlainScalar(state2, nodeIndent, withinFlowCollection) {
    var preceding, following, captureStart, captureEnd, hasPendingContent, _line, _lineStart, _lineIndent, _kind = state2.kind, _result = state2.result, ch;
    ch = state2.input.charCodeAt(state2.position);
    if (is_WS_OR_EOL(ch) || is_FLOW_INDICATOR(ch) || ch === 35 || ch === 38 || ch === 42 || ch === 33 || ch === 124 || ch === 62 || ch === 39 || ch === 34 || ch === 37 || ch === 64 || ch === 96) {
      return false;
    }
    if (ch === 63 || ch === 45) {
      following = state2.input.charCodeAt(state2.position + 1);
      if (is_WS_OR_EOL(following) || withinFlowCollection && is_FLOW_INDICATOR(following)) {
        return false;
      }
    }
    state2.kind = "scalar";
    state2.result = "";
    captureStart = captureEnd = state2.position;
    hasPendingContent = false;
    while (ch !== 0) {
      if (ch === 58) {
        following = state2.input.charCodeAt(state2.position + 1);
        if (is_WS_OR_EOL(following) || withinFlowCollection && is_FLOW_INDICATOR(following)) {
          break;
        }
      } else if (ch === 35) {
        preceding = state2.input.charCodeAt(state2.position - 1);
        if (is_WS_OR_EOL(preceding)) {
          break;
        }
      } else if (state2.position === state2.lineStart && testDocumentSeparator(state2) || withinFlowCollection && is_FLOW_INDICATOR(ch)) {
        break;
      } else if (is_EOL(ch)) {
        _line = state2.line;
        _lineStart = state2.lineStart;
        _lineIndent = state2.lineIndent;
        skipSeparationSpace(state2, false, -1);
        if (state2.lineIndent >= nodeIndent) {
          hasPendingContent = true;
          ch = state2.input.charCodeAt(state2.position);
          continue;
        } else {
          state2.position = captureEnd;
          state2.line = _line;
          state2.lineStart = _lineStart;
          state2.lineIndent = _lineIndent;
          break;
        }
      }
      if (hasPendingContent) {
        captureSegment(state2, captureStart, captureEnd, false);
        writeFoldedLines(state2, state2.line - _line);
        captureStart = captureEnd = state2.position;
        hasPendingContent = false;
      }
      if (!is_WHITE_SPACE(ch)) {
        captureEnd = state2.position + 1;
      }
      ch = state2.input.charCodeAt(++state2.position);
    }
    captureSegment(state2, captureStart, captureEnd, false);
    if (state2.result) {
      return true;
    }
    state2.kind = _kind;
    state2.result = _result;
    return false;
  }
  function readSingleQuotedScalar(state2, nodeIndent) {
    var ch, captureStart, captureEnd;
    ch = state2.input.charCodeAt(state2.position);
    if (ch !== 39) {
      return false;
    }
    state2.kind = "scalar";
    state2.result = "";
    state2.position++;
    captureStart = captureEnd = state2.position;
    while ((ch = state2.input.charCodeAt(state2.position)) !== 0) {
      if (ch === 39) {
        captureSegment(state2, captureStart, state2.position, true);
        ch = state2.input.charCodeAt(++state2.position);
        if (ch === 39) {
          captureStart = state2.position;
          state2.position++;
          captureEnd = state2.position;
        } else {
          return true;
        }
      } else if (is_EOL(ch)) {
        captureSegment(state2, captureStart, captureEnd, true);
        writeFoldedLines(state2, skipSeparationSpace(state2, false, nodeIndent));
        captureStart = captureEnd = state2.position;
      } else if (state2.position === state2.lineStart && testDocumentSeparator(state2)) {
        throwError(state2, "unexpected end of the document within a single quoted scalar");
      } else {
        state2.position++;
        captureEnd = state2.position;
      }
    }
    throwError(state2, "unexpected end of the stream within a single quoted scalar");
  }
  function readDoubleQuotedScalar(state2, nodeIndent) {
    var captureStart, captureEnd, hexLength, hexResult, tmp, ch;
    ch = state2.input.charCodeAt(state2.position);
    if (ch !== 34) {
      return false;
    }
    state2.kind = "scalar";
    state2.result = "";
    state2.position++;
    captureStart = captureEnd = state2.position;
    while ((ch = state2.input.charCodeAt(state2.position)) !== 0) {
      if (ch === 34) {
        captureSegment(state2, captureStart, state2.position, true);
        state2.position++;
        return true;
      } else if (ch === 92) {
        captureSegment(state2, captureStart, state2.position, true);
        ch = state2.input.charCodeAt(++state2.position);
        if (is_EOL(ch)) {
          skipSeparationSpace(state2, false, nodeIndent);
        } else if (ch < 256 && simpleEscapeCheck[ch]) {
          state2.result += simpleEscapeMap[ch];
          state2.position++;
        } else if ((tmp = escapedHexLen(ch)) > 0) {
          hexLength = tmp;
          hexResult = 0;
          for (; hexLength > 0; hexLength--) {
            ch = state2.input.charCodeAt(++state2.position);
            if ((tmp = fromHexCode(ch)) >= 0) {
              hexResult = (hexResult << 4) + tmp;
            } else {
              throwError(state2, "expected hexadecimal character");
            }
          }
          state2.result += charFromCodepoint(hexResult);
          state2.position++;
        } else {
          throwError(state2, "unknown escape sequence");
        }
        captureStart = captureEnd = state2.position;
      } else if (is_EOL(ch)) {
        captureSegment(state2, captureStart, captureEnd, true);
        writeFoldedLines(state2, skipSeparationSpace(state2, false, nodeIndent));
        captureStart = captureEnd = state2.position;
      } else if (state2.position === state2.lineStart && testDocumentSeparator(state2)) {
        throwError(state2, "unexpected end of the document within a double quoted scalar");
      } else {
        state2.position++;
        captureEnd = state2.position;
      }
    }
    throwError(state2, "unexpected end of the stream within a double quoted scalar");
  }
  function readFlowCollection(state2, nodeIndent) {
    var readNext = true, _line, _lineStart, _pos, _tag = state2.tag, _result, _anchor = state2.anchor, following, terminator, isPair, isExplicitPair, isMapping, overridableKeys = /* @__PURE__ */ Object.create(null), keyNode, keyTag, valueNode, ch;
    ch = state2.input.charCodeAt(state2.position);
    if (ch === 91) {
      terminator = 93;
      isMapping = false;
      _result = [];
    } else if (ch === 123) {
      terminator = 125;
      isMapping = true;
      _result = {};
    } else {
      return false;
    }
    if (state2.anchor !== null) {
      state2.anchorMap[state2.anchor] = _result;
    }
    ch = state2.input.charCodeAt(++state2.position);
    while (ch !== 0) {
      skipSeparationSpace(state2, true, nodeIndent);
      ch = state2.input.charCodeAt(state2.position);
      if (ch === terminator) {
        state2.position++;
        state2.tag = _tag;
        state2.anchor = _anchor;
        state2.kind = isMapping ? "mapping" : "sequence";
        state2.result = _result;
        return true;
      } else if (!readNext) {
        throwError(state2, "missed comma between flow collection entries");
      } else if (ch === 44) {
        throwError(state2, "expected the node content, but found ','");
      }
      keyTag = keyNode = valueNode = null;
      isPair = isExplicitPair = false;
      if (ch === 63) {
        following = state2.input.charCodeAt(state2.position + 1);
        if (is_WS_OR_EOL(following)) {
          isPair = isExplicitPair = true;
          state2.position++;
          skipSeparationSpace(state2, true, nodeIndent);
        }
      }
      _line = state2.line;
      _lineStart = state2.lineStart;
      _pos = state2.position;
      composeNode(state2, nodeIndent, CONTEXT_FLOW_IN, false, true);
      keyTag = state2.tag;
      keyNode = state2.result;
      skipSeparationSpace(state2, true, nodeIndent);
      ch = state2.input.charCodeAt(state2.position);
      if ((isExplicitPair || state2.line === _line) && ch === 58) {
        isPair = true;
        ch = state2.input.charCodeAt(++state2.position);
        skipSeparationSpace(state2, true, nodeIndent);
        composeNode(state2, nodeIndent, CONTEXT_FLOW_IN, false, true);
        valueNode = state2.result;
      }
      if (isMapping) {
        storeMappingPair(state2, _result, overridableKeys, keyTag, keyNode, valueNode, _line, _lineStart, _pos);
      } else if (isPair) {
        _result.push(storeMappingPair(state2, null, overridableKeys, keyTag, keyNode, valueNode, _line, _lineStart, _pos));
      } else {
        _result.push(keyNode);
      }
      skipSeparationSpace(state2, true, nodeIndent);
      ch = state2.input.charCodeAt(state2.position);
      if (ch === 44) {
        readNext = true;
        ch = state2.input.charCodeAt(++state2.position);
      } else {
        readNext = false;
      }
    }
    throwError(state2, "unexpected end of the stream within a flow collection");
  }
  function readBlockScalar(state2, nodeIndent) {
    var captureStart, folding, chomping = CHOMPING_CLIP, didReadContent = false, detectedIndent = false, textIndent = nodeIndent, emptyLines = 0, atMoreIndented = false, tmp, ch;
    ch = state2.input.charCodeAt(state2.position);
    if (ch === 124) {
      folding = false;
    } else if (ch === 62) {
      folding = true;
    } else {
      return false;
    }
    state2.kind = "scalar";
    state2.result = "";
    while (ch !== 0) {
      ch = state2.input.charCodeAt(++state2.position);
      if (ch === 43 || ch === 45) {
        if (CHOMPING_CLIP === chomping) {
          chomping = ch === 43 ? CHOMPING_KEEP : CHOMPING_STRIP;
        } else {
          throwError(state2, "repeat of a chomping mode identifier");
        }
      } else if ((tmp = fromDecimalCode(ch)) >= 0) {
        if (tmp === 0) {
          throwError(state2, "bad explicit indentation width of a block scalar; it cannot be less than one");
        } else if (!detectedIndent) {
          textIndent = nodeIndent + tmp - 1;
          detectedIndent = true;
        } else {
          throwError(state2, "repeat of an indentation width identifier");
        }
      } else {
        break;
      }
    }
    if (is_WHITE_SPACE(ch)) {
      do {
        ch = state2.input.charCodeAt(++state2.position);
      } while (is_WHITE_SPACE(ch));
      if (ch === 35) {
        do {
          ch = state2.input.charCodeAt(++state2.position);
        } while (!is_EOL(ch) && ch !== 0);
      }
    }
    while (ch !== 0) {
      readLineBreak(state2);
      state2.lineIndent = 0;
      ch = state2.input.charCodeAt(state2.position);
      while ((!detectedIndent || state2.lineIndent < textIndent) && ch === 32) {
        state2.lineIndent++;
        ch = state2.input.charCodeAt(++state2.position);
      }
      if (!detectedIndent && state2.lineIndent > textIndent) {
        textIndent = state2.lineIndent;
      }
      if (is_EOL(ch)) {
        emptyLines++;
        continue;
      }
      if (state2.lineIndent < textIndent) {
        if (chomping === CHOMPING_KEEP) {
          state2.result += common.repeat("\n", didReadContent ? 1 + emptyLines : emptyLines);
        } else if (chomping === CHOMPING_CLIP) {
          if (didReadContent) {
            state2.result += "\n";
          }
        }
        break;
      }
      if (folding) {
        if (is_WHITE_SPACE(ch)) {
          atMoreIndented = true;
          state2.result += common.repeat("\n", didReadContent ? 1 + emptyLines : emptyLines);
        } else if (atMoreIndented) {
          atMoreIndented = false;
          state2.result += common.repeat("\n", emptyLines + 1);
        } else if (emptyLines === 0) {
          if (didReadContent) {
            state2.result += " ";
          }
        } else {
          state2.result += common.repeat("\n", emptyLines);
        }
      } else {
        state2.result += common.repeat("\n", didReadContent ? 1 + emptyLines : emptyLines);
      }
      didReadContent = true;
      detectedIndent = true;
      emptyLines = 0;
      captureStart = state2.position;
      while (!is_EOL(ch) && ch !== 0) {
        ch = state2.input.charCodeAt(++state2.position);
      }
      captureSegment(state2, captureStart, state2.position, false);
    }
    return true;
  }
  function readBlockSequence(state2, nodeIndent) {
    var _line, _tag = state2.tag, _anchor = state2.anchor, _result = [], following, detected = false, ch;
    if (state2.firstTabInLine !== -1)
      return false;
    if (state2.anchor !== null) {
      state2.anchorMap[state2.anchor] = _result;
    }
    ch = state2.input.charCodeAt(state2.position);
    while (ch !== 0) {
      if (state2.firstTabInLine !== -1) {
        state2.position = state2.firstTabInLine;
        throwError(state2, "tab characters must not be used in indentation");
      }
      if (ch !== 45) {
        break;
      }
      following = state2.input.charCodeAt(state2.position + 1);
      if (!is_WS_OR_EOL(following)) {
        break;
      }
      detected = true;
      state2.position++;
      if (skipSeparationSpace(state2, true, -1)) {
        if (state2.lineIndent <= nodeIndent) {
          _result.push(null);
          ch = state2.input.charCodeAt(state2.position);
          continue;
        }
      }
      _line = state2.line;
      composeNode(state2, nodeIndent, CONTEXT_BLOCK_IN, false, true);
      _result.push(state2.result);
      skipSeparationSpace(state2, true, -1);
      ch = state2.input.charCodeAt(state2.position);
      if ((state2.line === _line || state2.lineIndent > nodeIndent) && ch !== 0) {
        throwError(state2, "bad indentation of a sequence entry");
      } else if (state2.lineIndent < nodeIndent) {
        break;
      }
    }
    if (detected) {
      state2.tag = _tag;
      state2.anchor = _anchor;
      state2.kind = "sequence";
      state2.result = _result;
      return true;
    }
    return false;
  }
  function readBlockMapping(state2, nodeIndent, flowIndent) {
    var following, allowCompact, _line, _keyLine, _keyLineStart, _keyPos, _tag = state2.tag, _anchor = state2.anchor, _result = {}, overridableKeys = /* @__PURE__ */ Object.create(null), keyTag = null, keyNode = null, valueNode = null, atExplicitKey = false, detected = false, ch;
    if (state2.firstTabInLine !== -1)
      return false;
    if (state2.anchor !== null) {
      state2.anchorMap[state2.anchor] = _result;
    }
    ch = state2.input.charCodeAt(state2.position);
    while (ch !== 0) {
      if (!atExplicitKey && state2.firstTabInLine !== -1) {
        state2.position = state2.firstTabInLine;
        throwError(state2, "tab characters must not be used in indentation");
      }
      following = state2.input.charCodeAt(state2.position + 1);
      _line = state2.line;
      if ((ch === 63 || ch === 58) && is_WS_OR_EOL(following)) {
        if (ch === 63) {
          if (atExplicitKey) {
            storeMappingPair(state2, _result, overridableKeys, keyTag, keyNode, null, _keyLine, _keyLineStart, _keyPos);
            keyTag = keyNode = valueNode = null;
          }
          detected = true;
          atExplicitKey = true;
          allowCompact = true;
        } else if (atExplicitKey) {
          atExplicitKey = false;
          allowCompact = true;
        } else {
          throwError(state2, "incomplete explicit mapping pair; a key node is missed; or followed by a non-tabulated empty line");
        }
        state2.position += 1;
        ch = following;
      } else {
        _keyLine = state2.line;
        _keyLineStart = state2.lineStart;
        _keyPos = state2.position;
        if (!composeNode(state2, flowIndent, CONTEXT_FLOW_OUT, false, true)) {
          break;
        }
        if (state2.line === _line) {
          ch = state2.input.charCodeAt(state2.position);
          while (is_WHITE_SPACE(ch)) {
            ch = state2.input.charCodeAt(++state2.position);
          }
          if (ch === 58) {
            ch = state2.input.charCodeAt(++state2.position);
            if (!is_WS_OR_EOL(ch)) {
              throwError(state2, "a whitespace character is expected after the key-value separator within a block mapping");
            }
            if (atExplicitKey) {
              storeMappingPair(state2, _result, overridableKeys, keyTag, keyNode, null, _keyLine, _keyLineStart, _keyPos);
              keyTag = keyNode = valueNode = null;
            }
            detected = true;
            atExplicitKey = false;
            allowCompact = false;
            keyTag = state2.tag;
            keyNode = state2.result;
          } else if (detected) {
            throwError(state2, "can not read an implicit mapping pair; a colon is missed");
          } else {
            state2.tag = _tag;
            state2.anchor = _anchor;
            return true;
          }
        } else if (detected) {
          throwError(state2, "can not read a block mapping entry; a multiline key may not be an implicit key");
        } else {
          state2.tag = _tag;
          state2.anchor = _anchor;
          return true;
        }
      }
      if (state2.line === _line || state2.lineIndent > nodeIndent) {
        if (atExplicitKey) {
          _keyLine = state2.line;
          _keyLineStart = state2.lineStart;
          _keyPos = state2.position;
        }
        if (composeNode(state2, nodeIndent, CONTEXT_BLOCK_OUT, true, allowCompact)) {
          if (atExplicitKey) {
            keyNode = state2.result;
          } else {
            valueNode = state2.result;
          }
        }
        if (!atExplicitKey) {
          storeMappingPair(state2, _result, overridableKeys, keyTag, keyNode, valueNode, _keyLine, _keyLineStart, _keyPos);
          keyTag = keyNode = valueNode = null;
        }
        skipSeparationSpace(state2, true, -1);
        ch = state2.input.charCodeAt(state2.position);
      }
      if ((state2.line === _line || state2.lineIndent > nodeIndent) && ch !== 0) {
        throwError(state2, "bad indentation of a mapping entry");
      } else if (state2.lineIndent < nodeIndent) {
        break;
      }
    }
    if (atExplicitKey) {
      storeMappingPair(state2, _result, overridableKeys, keyTag, keyNode, null, _keyLine, _keyLineStart, _keyPos);
    }
    if (detected) {
      state2.tag = _tag;
      state2.anchor = _anchor;
      state2.kind = "mapping";
      state2.result = _result;
    }
    return detected;
  }
  function readTagProperty(state2) {
    var _position, isVerbatim = false, isNamed = false, tagHandle, tagName, ch;
    ch = state2.input.charCodeAt(state2.position);
    if (ch !== 33)
      return false;
    if (state2.tag !== null) {
      throwError(state2, "duplication of a tag property");
    }
    ch = state2.input.charCodeAt(++state2.position);
    if (ch === 60) {
      isVerbatim = true;
      ch = state2.input.charCodeAt(++state2.position);
    } else if (ch === 33) {
      isNamed = true;
      tagHandle = "!!";
      ch = state2.input.charCodeAt(++state2.position);
    } else {
      tagHandle = "!";
    }
    _position = state2.position;
    if (isVerbatim) {
      do {
        ch = state2.input.charCodeAt(++state2.position);
      } while (ch !== 0 && ch !== 62);
      if (state2.position < state2.length) {
        tagName = state2.input.slice(_position, state2.position);
        ch = state2.input.charCodeAt(++state2.position);
      } else {
        throwError(state2, "unexpected end of the stream within a verbatim tag");
      }
    } else {
      while (ch !== 0 && !is_WS_OR_EOL(ch)) {
        if (ch === 33) {
          if (!isNamed) {
            tagHandle = state2.input.slice(_position - 1, state2.position + 1);
            if (!PATTERN_TAG_HANDLE.test(tagHandle)) {
              throwError(state2, "named tag handle cannot contain such characters");
            }
            isNamed = true;
            _position = state2.position + 1;
          } else {
            throwError(state2, "tag suffix cannot contain exclamation marks");
          }
        }
        ch = state2.input.charCodeAt(++state2.position);
      }
      tagName = state2.input.slice(_position, state2.position);
      if (PATTERN_FLOW_INDICATORS.test(tagName)) {
        throwError(state2, "tag suffix cannot contain flow indicator characters");
      }
    }
    if (tagName && !PATTERN_TAG_URI.test(tagName)) {
      throwError(state2, "tag name cannot contain such characters: " + tagName);
    }
    try {
      tagName = decodeURIComponent(tagName);
    } catch (err) {
      throwError(state2, "tag name is malformed: " + tagName);
    }
    if (isVerbatim) {
      state2.tag = tagName;
    } else if (_hasOwnProperty$1.call(state2.tagMap, tagHandle)) {
      state2.tag = state2.tagMap[tagHandle] + tagName;
    } else if (tagHandle === "!") {
      state2.tag = "!" + tagName;
    } else if (tagHandle === "!!") {
      state2.tag = "tag:yaml.org,2002:" + tagName;
    } else {
      throwError(state2, 'undeclared tag handle "' + tagHandle + '"');
    }
    return true;
  }
  function readAnchorProperty(state2) {
    var _position, ch;
    ch = state2.input.charCodeAt(state2.position);
    if (ch !== 38)
      return false;
    if (state2.anchor !== null) {
      throwError(state2, "duplication of an anchor property");
    }
    ch = state2.input.charCodeAt(++state2.position);
    _position = state2.position;
    while (ch !== 0 && !is_WS_OR_EOL(ch) && !is_FLOW_INDICATOR(ch)) {
      ch = state2.input.charCodeAt(++state2.position);
    }
    if (state2.position === _position) {
      throwError(state2, "name of an anchor node must contain at least one character");
    }
    state2.anchor = state2.input.slice(_position, state2.position);
    return true;
  }
  function readAlias(state2) {
    var _position, alias, ch;
    ch = state2.input.charCodeAt(state2.position);
    if (ch !== 42)
      return false;
    ch = state2.input.charCodeAt(++state2.position);
    _position = state2.position;
    while (ch !== 0 && !is_WS_OR_EOL(ch) && !is_FLOW_INDICATOR(ch)) {
      ch = state2.input.charCodeAt(++state2.position);
    }
    if (state2.position === _position) {
      throwError(state2, "name of an alias node must contain at least one character");
    }
    alias = state2.input.slice(_position, state2.position);
    if (!_hasOwnProperty$1.call(state2.anchorMap, alias)) {
      throwError(state2, 'unidentified alias "' + alias + '"');
    }
    state2.result = state2.anchorMap[alias];
    skipSeparationSpace(state2, true, -1);
    return true;
  }
  function composeNode(state2, parentIndent, nodeContext, allowToSeek, allowCompact) {
    var allowBlockStyles, allowBlockScalars, allowBlockCollections, indentStatus = 1, atNewLine = false, hasContent = false, typeIndex, typeQuantity, typeList, type2, flowIndent, blockIndent;
    if (state2.listener !== null) {
      state2.listener("open", state2);
    }
    state2.tag = null;
    state2.anchor = null;
    state2.kind = null;
    state2.result = null;
    allowBlockStyles = allowBlockScalars = allowBlockCollections = CONTEXT_BLOCK_OUT === nodeContext || CONTEXT_BLOCK_IN === nodeContext;
    if (allowToSeek) {
      if (skipSeparationSpace(state2, true, -1)) {
        atNewLine = true;
        if (state2.lineIndent > parentIndent) {
          indentStatus = 1;
        } else if (state2.lineIndent === parentIndent) {
          indentStatus = 0;
        } else if (state2.lineIndent < parentIndent) {
          indentStatus = -1;
        }
      }
    }
    if (indentStatus === 1) {
      while (readTagProperty(state2) || readAnchorProperty(state2)) {
        if (skipSeparationSpace(state2, true, -1)) {
          atNewLine = true;
          allowBlockCollections = allowBlockStyles;
          if (state2.lineIndent > parentIndent) {
            indentStatus = 1;
          } else if (state2.lineIndent === parentIndent) {
            indentStatus = 0;
          } else if (state2.lineIndent < parentIndent) {
            indentStatus = -1;
          }
        } else {
          allowBlockCollections = false;
        }
      }
    }
    if (allowBlockCollections) {
      allowBlockCollections = atNewLine || allowCompact;
    }
    if (indentStatus === 1 || CONTEXT_BLOCK_OUT === nodeContext) {
      if (CONTEXT_FLOW_IN === nodeContext || CONTEXT_FLOW_OUT === nodeContext) {
        flowIndent = parentIndent;
      } else {
        flowIndent = parentIndent + 1;
      }
      blockIndent = state2.position - state2.lineStart;
      if (indentStatus === 1) {
        if (allowBlockCollections && (readBlockSequence(state2, blockIndent) || readBlockMapping(state2, blockIndent, flowIndent)) || readFlowCollection(state2, flowIndent)) {
          hasContent = true;
        } else {
          if (allowBlockScalars && readBlockScalar(state2, flowIndent) || readSingleQuotedScalar(state2, flowIndent) || readDoubleQuotedScalar(state2, flowIndent)) {
            hasContent = true;
          } else if (readAlias(state2)) {
            hasContent = true;
            if (state2.tag !== null || state2.anchor !== null) {
              throwError(state2, "alias node should not have any properties");
            }
          } else if (readPlainScalar(state2, flowIndent, CONTEXT_FLOW_IN === nodeContext)) {
            hasContent = true;
            if (state2.tag === null) {
              state2.tag = "?";
            }
          }
          if (state2.anchor !== null) {
            state2.anchorMap[state2.anchor] = state2.result;
          }
        }
      } else if (indentStatus === 0) {
        hasContent = allowBlockCollections && readBlockSequence(state2, blockIndent);
      }
    }
    if (state2.tag === null) {
      if (state2.anchor !== null) {
        state2.anchorMap[state2.anchor] = state2.result;
      }
    } else if (state2.tag === "?") {
      if (state2.result !== null && state2.kind !== "scalar") {
        throwError(state2, 'unacceptable node kind for !<?> tag; it should be "scalar", not "' + state2.kind + '"');
      }
      for (typeIndex = 0, typeQuantity = state2.implicitTypes.length; typeIndex < typeQuantity; typeIndex += 1) {
        type2 = state2.implicitTypes[typeIndex];
        if (type2.resolve(state2.result)) {
          state2.result = type2.construct(state2.result);
          state2.tag = type2.tag;
          if (state2.anchor !== null) {
            state2.anchorMap[state2.anchor] = state2.result;
          }
          break;
        }
      }
    } else if (state2.tag !== "!") {
      if (_hasOwnProperty$1.call(state2.typeMap[state2.kind || "fallback"], state2.tag)) {
        type2 = state2.typeMap[state2.kind || "fallback"][state2.tag];
      } else {
        type2 = null;
        typeList = state2.typeMap.multi[state2.kind || "fallback"];
        for (typeIndex = 0, typeQuantity = typeList.length; typeIndex < typeQuantity; typeIndex += 1) {
          if (state2.tag.slice(0, typeList[typeIndex].tag.length) === typeList[typeIndex].tag) {
            type2 = typeList[typeIndex];
            break;
          }
        }
      }
      if (!type2) {
        throwError(state2, "unknown tag !<" + state2.tag + ">");
      }
      if (state2.result !== null && type2.kind !== state2.kind) {
        throwError(state2, "unacceptable node kind for !<" + state2.tag + '> tag; it should be "' + type2.kind + '", not "' + state2.kind + '"');
      }
      if (!type2.resolve(state2.result, state2.tag)) {
        throwError(state2, "cannot resolve a node with !<" + state2.tag + "> explicit tag");
      } else {
        state2.result = type2.construct(state2.result, state2.tag);
        if (state2.anchor !== null) {
          state2.anchorMap[state2.anchor] = state2.result;
        }
      }
    }
    if (state2.listener !== null) {
      state2.listener("close", state2);
    }
    return state2.tag !== null || state2.anchor !== null || hasContent;
  }
  function readDocument(state2) {
    var documentStart = state2.position, _position, directiveName, directiveArgs, hasDirectives = false, ch;
    state2.version = null;
    state2.checkLineBreaks = state2.legacy;
    state2.tagMap = /* @__PURE__ */ Object.create(null);
    state2.anchorMap = /* @__PURE__ */ Object.create(null);
    while ((ch = state2.input.charCodeAt(state2.position)) !== 0) {
      skipSeparationSpace(state2, true, -1);
      ch = state2.input.charCodeAt(state2.position);
      if (state2.lineIndent > 0 || ch !== 37) {
        break;
      }
      hasDirectives = true;
      ch = state2.input.charCodeAt(++state2.position);
      _position = state2.position;
      while (ch !== 0 && !is_WS_OR_EOL(ch)) {
        ch = state2.input.charCodeAt(++state2.position);
      }
      directiveName = state2.input.slice(_position, state2.position);
      directiveArgs = [];
      if (directiveName.length < 1) {
        throwError(state2, "directive name must not be less than one character in length");
      }
      while (ch !== 0) {
        while (is_WHITE_SPACE(ch)) {
          ch = state2.input.charCodeAt(++state2.position);
        }
        if (ch === 35) {
          do {
            ch = state2.input.charCodeAt(++state2.position);
          } while (ch !== 0 && !is_EOL(ch));
          break;
        }
        if (is_EOL(ch))
          break;
        _position = state2.position;
        while (ch !== 0 && !is_WS_OR_EOL(ch)) {
          ch = state2.input.charCodeAt(++state2.position);
        }
        directiveArgs.push(state2.input.slice(_position, state2.position));
      }
      if (ch !== 0)
        readLineBreak(state2);
      if (_hasOwnProperty$1.call(directiveHandlers, directiveName)) {
        directiveHandlers[directiveName](state2, directiveName, directiveArgs);
      } else {
        throwWarning(state2, 'unknown document directive "' + directiveName + '"');
      }
    }
    skipSeparationSpace(state2, true, -1);
    if (state2.lineIndent === 0 && state2.input.charCodeAt(state2.position) === 45 && state2.input.charCodeAt(state2.position + 1) === 45 && state2.input.charCodeAt(state2.position + 2) === 45) {
      state2.position += 3;
      skipSeparationSpace(state2, true, -1);
    } else if (hasDirectives) {
      throwError(state2, "directives end mark is expected");
    }
    composeNode(state2, state2.lineIndent - 1, CONTEXT_BLOCK_OUT, false, true);
    skipSeparationSpace(state2, true, -1);
    if (state2.checkLineBreaks && PATTERN_NON_ASCII_LINE_BREAKS.test(state2.input.slice(documentStart, state2.position))) {
      throwWarning(state2, "non-ASCII line breaks are interpreted as content");
    }
    state2.documents.push(state2.result);
    if (state2.position === state2.lineStart && testDocumentSeparator(state2)) {
      if (state2.input.charCodeAt(state2.position) === 46) {
        state2.position += 3;
        skipSeparationSpace(state2, true, -1);
      }
      return;
    }
    if (state2.position < state2.length - 1) {
      throwError(state2, "end of the stream or a document separator is expected");
    } else {
      return;
    }
  }
  function loadDocuments(input, options2) {
    input = String(input);
    options2 = options2 || {};
    if (input.length !== 0) {
      if (input.charCodeAt(input.length - 1) !== 10 && input.charCodeAt(input.length - 1) !== 13) {
        input += "\n";
      }
      if (input.charCodeAt(0) === 65279) {
        input = input.slice(1);
      }
    }
    var state2 = new State$1(input, options2);
    var nullpos = input.indexOf("\0");
    if (nullpos !== -1) {
      state2.position = nullpos;
      throwError(state2, "null byte is not allowed in input");
    }
    state2.input += "\0";
    while (state2.input.charCodeAt(state2.position) === 32) {
      state2.lineIndent += 1;
      state2.position += 1;
    }
    while (state2.position < state2.length - 1) {
      readDocument(state2);
    }
    return state2.documents;
  }
  function loadAll$1(input, iterator, options2) {
    if (iterator !== null && typeof iterator === "object" && typeof options2 === "undefined") {
      options2 = iterator;
      iterator = null;
    }
    var documents2 = loadDocuments(input, options2);
    if (typeof iterator !== "function") {
      return documents2;
    }
    for (var index2 = 0, length2 = documents2.length; index2 < length2; index2 += 1) {
      iterator(documents2[index2]);
    }
  }
  function load$1(input, options2) {
    var documents2 = loadDocuments(input, options2);
    if (documents2.length === 0) {
      return void 0;
    } else if (documents2.length === 1) {
      return documents2[0];
    }
    throw new exception("expected a single document in the stream, but found more");
  }
  var loadAll_1 = loadAll$1;
  var load_1 = load$1;
  var loader$j = {
    loadAll: loadAll_1,
    load: load_1
  };
  var FAILSAFE_SCHEMA = failsafe;
  var load = loader$j.load;
  const frontMatterRegex = /^-{3}\s*[\n\r](.*?)[\n\r]-{3}\s*[\n\r]+/s;
  function extractFrontMatter(text2, db2) {
    var _a, _b;
    const matches = text2.match(frontMatterRegex);
    if (matches) {
      const parsed = load(matches[1], {
        // To keep things simple, only allow strings, arrays, and plain objects.
        // https://www.yaml.org/spec/1.2/spec.html#id2802346
        schema: FAILSAFE_SCHEMA
      });
      if (parsed == null ? void 0 : parsed.title) {
        (_a = db2.setDiagramTitle) == null ? void 0 : _a.call(db2, parsed.title);
      }
      if (parsed == null ? void 0 : parsed.displayMode) {
        (_b = db2.setDisplayMode) == null ? void 0 : _b.call(db2, parsed.displayMode);
      }
      return text2.slice(matches[0].length);
    } else {
      return text2;
    }
  }
  const assignWithDepth = function(dst, src, config2) {
    const { depth, clobber } = Object.assign({ depth: 2, clobber: false }, config2);
    if (Array.isArray(src) && !Array.isArray(dst)) {
      src.forEach((s) => assignWithDepth(dst, s, config2));
      return dst;
    } else if (Array.isArray(src) && Array.isArray(dst)) {
      src.forEach((s) => {
        if (!dst.includes(s)) {
          dst.push(s);
        }
      });
      return dst;
    }
    if (dst === void 0 || depth <= 0) {
      if (dst !== void 0 && dst !== null && typeof dst === "object" && typeof src === "object") {
        return Object.assign(dst, src);
      } else {
        return src;
      }
    }
    if (src !== void 0 && typeof dst === "object" && typeof src === "object") {
      Object.keys(src).forEach((key) => {
        if (typeof src[key] === "object" && (dst[key] === void 0 || typeof dst[key] === "object")) {
          if (dst[key] === void 0) {
            dst[key] = Array.isArray(src[key]) ? [] : {};
          }
          dst[key] = assignWithDepth(dst[key], src[key], { depth: depth - 1, clobber });
        } else if (clobber || typeof dst[key] !== "object" && typeof src[key] !== "object") {
          dst[key] = src[key];
        }
      });
    }
    return dst;
  };
  const assignWithDepth$1 = assignWithDepth;
  const defaultConfig = Object.freeze(defaultConfig$1);
  let siteConfig = assignWithDepth$1({}, defaultConfig);
  let configFromInitialize;
  let directives = [];
  let currentConfig = assignWithDepth$1({}, defaultConfig);
  const updateCurrentConfig = (siteCfg, _directives) => {
    let cfg = assignWithDepth$1({}, siteCfg);
    let sumOfDirectives = {};
    for (const d of _directives) {
      sanitize(d);
      sumOfDirectives = assignWithDepth$1(sumOfDirectives, d);
    }
    cfg = assignWithDepth$1(cfg, sumOfDirectives);
    if (sumOfDirectives.theme && sumOfDirectives.theme in theme) {
      const tmpConfigFromInitialize = assignWithDepth$1({}, configFromInitialize);
      const themeVariables = assignWithDepth$1(
        tmpConfigFromInitialize.themeVariables || {},
        sumOfDirectives.themeVariables
      );
      if (cfg.theme && cfg.theme in theme) {
        cfg.themeVariables = theme[cfg.theme].getThemeVariables(themeVariables);
      }
    }
    currentConfig = cfg;
    checkConfig(currentConfig);
    return currentConfig;
  };
  const setSiteConfig = (conf2) => {
    siteConfig = assignWithDepth$1({}, defaultConfig);
    siteConfig = assignWithDepth$1(siteConfig, conf2);
    if (conf2.theme && theme[conf2.theme]) {
      siteConfig.themeVariables = theme[conf2.theme].getThemeVariables(conf2.themeVariables);
    }
    updateCurrentConfig(siteConfig, directives);
    return siteConfig;
  };
  const saveConfigFromInitialize = (conf2) => {
    configFromInitialize = assignWithDepth$1({}, conf2);
  };
  const updateSiteConfig = (conf2) => {
    siteConfig = assignWithDepth$1(siteConfig, conf2);
    updateCurrentConfig(siteConfig, directives);
    return siteConfig;
  };
  const getSiteConfig = () => {
    return assignWithDepth$1({}, siteConfig);
  };
  const setConfig = (conf2) => {
    checkConfig(conf2);
    assignWithDepth$1(currentConfig, conf2);
    return getConfig$1();
  };
  const getConfig$1 = () => {
    return assignWithDepth$1({}, currentConfig);
  };
  const sanitize = (options2) => {
    ["secure", ...siteConfig.secure ?? []].forEach((key) => {
      if (options2[key] !== void 0) {
        log$1.debug(`Denied attempt to modify a secure key ${key}`, options2[key]);
        delete options2[key];
      }
    });
    Object.keys(options2).forEach((key) => {
      if (key.indexOf("__") === 0) {
        delete options2[key];
      }
    });
    Object.keys(options2).forEach((key) => {
      if (typeof options2[key] === "string" && (options2[key].includes("<") || options2[key].includes(">") || options2[key].includes("url(data:"))) {
        delete options2[key];
      }
      if (typeof options2[key] === "object") {
        sanitize(options2[key]);
      }
    });
  };
  const addDirective = (directive2) => {
    if (directive2.fontFamily) {
      if (!directive2.themeVariables) {
        directive2.themeVariables = { fontFamily: directive2.fontFamily };
      } else {
        if (!directive2.themeVariables.fontFamily) {
          directive2.themeVariables = { fontFamily: directive2.fontFamily };
        }
      }
    }
    directives.push(directive2);
    updateCurrentConfig(siteConfig, directives);
  };
  const reset = (config2 = siteConfig) => {
    directives = [];
    updateCurrentConfig(config2, directives);
  };
  var ConfigWarning = /* @__PURE__ */ ((ConfigWarning2) => {
    ConfigWarning2["LAZY_LOAD_DEPRECATED"] = "The configuration options lazyLoadedDiagrams and loadExternalDiagramsAtStartup are deprecated. Please use registerExternalDiagrams instead.";
    return ConfigWarning2;
  })(ConfigWarning || {});
  const issuedWarnings = {};
  const issueWarning = (warning) => {
    if (issuedWarnings[warning]) {
      return;
    }
    log$1.warn(ConfigWarning[warning]);
    issuedWarnings[warning] = true;
  };
  const checkConfig = (config2) => {
    if (!config2) {
      return;
    }
    if (config2.lazyLoadedDiagrams || config2.loadExternalDiagramsAtStartup) {
      issueWarning("LAZY_LOAD_DEPRECATED");
    }
  };
  const d3Attrs = function(d3Elem, attrs) {
    for (let attr of attrs) {
      d3Elem.attr(attr[0], attr[1]);
    }
  };
  const calculateSvgSizeAttrs = function(height2, width2, useMaxWidth) {
    let attrs = /* @__PURE__ */ new Map();
    if (useMaxWidth) {
      attrs.set("width", "100%");
      attrs.set("style", `max-width: ${width2}px;`);
    } else {
      attrs.set("height", height2);
      attrs.set("width", width2);
    }
    return attrs;
  };
  const configureSvgSize = function(svgElem, height2, width2, useMaxWidth) {
    const attrs = calculateSvgSizeAttrs(height2, width2, useMaxWidth);
    d3Attrs(svgElem, attrs);
  };
  const setupGraphViewbox$1 = function(graph, svgElem, padding2, useMaxWidth) {
    const svgBounds = svgElem.node().getBBox();
    const sWidth = svgBounds.width;
    const sHeight = svgBounds.height;
    log$1.info(`SVG bounds: ${sWidth}x${sHeight}`, svgBounds);
    let width2 = 0;
    let height2 = 0;
    log$1.info(`Graph bounds: ${width2}x${height2}`, graph);
    width2 = sWidth + padding2 * 2;
    height2 = sHeight + padding2 * 2;
    log$1.info(`Calculated bounds: ${width2}x${height2}`);
    configureSvgSize(svgElem, height2, width2, useMaxWidth);
    const vBox = `${svgBounds.x - padding2} ${svgBounds.y - padding2} ${svgBounds.width + 2 * padding2} ${svgBounds.height + 2 * padding2}`;
    svgElem.attr("viewBox", vBox);
  };
  const themes = {};
  const getStyles$g = (type2, userStyles, options2) => {
    let diagramStyles = "";
    if (type2 in themes && themes[type2]) {
      diagramStyles = themes[type2](options2);
    } else {
      log$1.warn(`No theme found for ${type2}`);
    }
    return ` & {
    font-family: ${options2.fontFamily};
    font-size: ${options2.fontSize};
    fill: ${options2.textColor}
  }

  /* Classes common for multiple diagrams */

  & .error-icon {
    fill: ${options2.errorBkgColor};
  }
  & .error-text {
    fill: ${options2.errorTextColor};
    stroke: ${options2.errorTextColor};
  }

  & .edge-thickness-normal {
    stroke-width: 2px;
  }
  & .edge-thickness-thick {
    stroke-width: 3.5px
  }
  & .edge-pattern-solid {
    stroke-dasharray: 0;
  }

  & .edge-pattern-dashed{
    stroke-dasharray: 3;
  }
  .edge-pattern-dotted {
    stroke-dasharray: 2;
  }

  & .marker {
    fill: ${options2.lineColor};
    stroke: ${options2.lineColor};
  }
  & .marker.cross {
    stroke: ${options2.lineColor};
  }

  & svg {
    font-family: ${options2.fontFamily};
    font-size: ${options2.fontSize};
  }

  ${diagramStyles}

  ${userStyles}
`;
  };
  const addStylesForDiagram = (type2, diagramTheme) => {
    themes[type2] = diagramTheme;
  };
  const getStyles$h = getStyles$g;
  let title$1 = "";
  let diagramTitle = "";
  let description = "";
  const sanitizeText$5 = (txt) => sanitizeText$6(txt, getConfig$1());
  const clear$j = function() {
    title$1 = "";
    description = "";
    diagramTitle = "";
  };
  const setAccTitle = function(txt) {
    title$1 = sanitizeText$5(txt).replace(/^\s+/g, "");
  };
  const getAccTitle = function() {
    return title$1 || diagramTitle;
  };
  const setAccDescription = function(txt) {
    description = sanitizeText$5(txt).replace(/\n\s+/g, "\n");
  };
  const getAccDescription = function() {
    return description;
  };
  const setDiagramTitle = function(txt) {
    diagramTitle = sanitizeText$5(txt);
  };
  const getDiagramTitle = function() {
    return diagramTitle;
  };
  const commonDb = {
    getAccTitle,
    setAccTitle,
    getDiagramTitle,
    setDiagramTitle,
    getAccDescription,
    setAccDescription,
    clear: clear$j
  };
  const commonDb$1 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
    __proto__: null,
    clear: clear$j,
    default: commonDb,
    getAccDescription,
    getAccTitle,
    getDiagramTitle,
    setAccDescription,
    setAccTitle,
    setDiagramTitle
  }, Symbol.toStringTag, { value: "Module" }));
  let currentDirective = {};
  const parseDirective$e = function(p, statement, context, type2) {
    log$1.debug("parseDirective is being called", statement, context, type2);
    try {
      if (statement !== void 0) {
        statement = statement.trim();
        switch (context) {
          case "open_directive":
            currentDirective = {};
            break;
          case "type_directive":
            if (!currentDirective) {
              throw new Error("currentDirective is undefined");
            }
            currentDirective.type = statement.toLowerCase();
            break;
          case "arg_directive":
            if (!currentDirective) {
              throw new Error("currentDirective is undefined");
            }
            currentDirective.args = JSON.parse(statement);
            break;
          case "close_directive":
            handleDirective(p, currentDirective, type2);
            currentDirective = void 0;
            break;
        }
      }
    } catch (error) {
      log$1.error(
        `Error while rendering sequenceDiagram directive: ${statement} jison context: ${context}`
      );
      log$1.error(error.message);
    }
  };
  const handleDirective = function(p, directive2, type2) {
    log$1.info(`Directive type=${directive2.type} with args:`, directive2.args);
    switch (directive2.type) {
      case "init":
      case "initialize": {
        ["config"].forEach((prop) => {
          if (directive2.args[prop] !== void 0) {
            if (type2 === "flowchart-v2") {
              type2 = "flowchart";
            }
            directive2.args[type2] = directive2.args[prop];
            delete directive2.args[prop];
          }
        });
        log$1.info("sanitize in handleDirective", directive2.args);
        directiveSanitizer(directive2.args);
        log$1.info("sanitize in handleDirective (done)", directive2.args);
        addDirective(directive2.args);
        break;
      }
      case "wrap":
      case "nowrap":
        if (p && p["setWrap"]) {
          p.setWrap(directive2.type === "wrap");
        }
        break;
      case "themeCss":
        log$1.warn("themeCss encountered");
        break;
      default:
        log$1.warn(
          `Unhandled directive: source: '%%{${directive2.type}: ${JSON.stringify(
            directive2.args ? directive2.args : {}
          )}}%%`,
          directive2
        );
        break;
    }
  };
  const log = log$1;
  const setLogLevel = setLogLevel$1;
  const getConfig = getConfig$1;
  const sanitizeText$4 = (text2) => sanitizeText$6(text2, getConfig());
  const setupGraphViewbox = setupGraphViewbox$1;
  const getCommonDb$1 = () => {
    return commonDb$1;
  };
  const parseDirective$d = (p, statement, context, type2) => parseDirective$e(p, statement, context, type2);
  const diagrams = {};
  const registerDiagram = (id2, diagram2, detector2) => {
    if (diagrams[id2]) {
      throw new Error(`Diagram ${id2} already registered.`);
    }
    diagrams[id2] = diagram2;
    if (detector2) {
      addDetector(id2, detector2);
    }
    addStylesForDiagram(id2, diagram2.styles);
    if (diagram2.injectUtils) {
      diagram2.injectUtils(
        log,
        setLogLevel,
        getConfig,
        sanitizeText$4,
        setupGraphViewbox,
        getCommonDb$1(),
        parseDirective$d
      );
    }
  };
  const getDiagram = (name2) => {
    if (name2 in diagrams) {
      return diagrams[name2];
    }
    throw new Error(`Diagram ${name2} not found.`);
  };
  class UnknownDiagramError extends Error {
    constructor(message2) {
      super(message2);
      this.name = "UnknownDiagramError";
    }
  }
  const directive$1 = /%{2}{\s*(?:(\w+)\s*:|(\w+))\s*(?:(\w+)|((?:(?!}%{2}).|\r?\n)*))?\s*(?:}%{2})?/gi;
  const anyComment = /\s*%%.*\n/gm;
  const detectors = {};
  const detectType = function(text2, config2) {
    text2 = text2.replace(frontMatterRegex, "").replace(directive$1, "").replace(anyComment, "\n");
    for (const [key, { detector: detector2 }] of Object.entries(detectors)) {
      const diagram2 = detector2(text2, config2);
      if (diagram2) {
        return key;
      }
    }
    throw new UnknownDiagramError(
      `No diagram type detected matching given configuration for text: ${text2}`
    );
  };
  const registerLazyLoadedDiagrams = (...diagrams2) => {
    for (const { id: id2, detector: detector2, loader: loader2 } of diagrams2) {
      addDetector(id2, detector2, loader2);
    }
  };
  const loadRegisteredDiagrams = async () => {
    log$1.debug(`Loading registered diagrams`);
    const results = await Promise.allSettled(
      Object.entries(detectors).map(async ([key, { detector: detector2, loader: loader2 }]) => {
        if (loader2) {
          try {
            getDiagram(key);
          } catch (error) {
            try {
              const { diagram: diagram2, id: id2 } = await loader2();
              registerDiagram(id2, diagram2, detector2);
            } catch (err) {
              log$1.error(`Failed to load external diagram with key ${key}. Removing from detectors.`);
              delete detectors[key];
              throw err;
            }
          }
        }
      })
    );
    const failed = results.filter((result) => result.status === "rejected");
    if (failed.length > 0) {
      log$1.error(`Failed to load ${failed.length} external diagrams`);
      for (const res of failed) {
        log$1.error(res);
      }
      throw new Error(`Failed to load ${failed.length} external diagrams`);
    }
  };
  const addDetector = (key, detector2, loader2) => {
    if (detectors[key]) {
      log$1.error(`Detector with key ${key} already exists`);
    } else {
      detectors[key] = { detector: detector2, loader: loader2 };
    }
    log$1.debug(`Detector with key ${key} added${loader2 ? " with loader" : ""}`);
  };
  const getDiagramLoader = (key) => {
    return detectors[key].loader;
  };
  var freeGlobal = typeof global == "object" && global && global.Object === Object && global;
  const freeGlobal$1 = freeGlobal;
  var freeSelf = typeof self == "object" && self && self.Object === Object && self;
  var root = freeGlobal$1 || freeSelf || Function("return this")();
  const root$1 = root;
  var Symbol$1 = root$1.Symbol;
  const Symbol$2 = Symbol$1;
  var objectProto$i = Object.prototype;
  var hasOwnProperty$g = objectProto$i.hasOwnProperty;
  var nativeObjectToString$1 = objectProto$i.toString;
  var symToStringTag$1 = Symbol$2 ? Symbol$2.toStringTag : void 0;
  function getRawTag(value) {
    var isOwn = hasOwnProperty$g.call(value, symToStringTag$1), tag = value[symToStringTag$1];
    try {
      value[symToStringTag$1] = void 0;
      var unmasked = true;
    } catch (e) {
    }
    var result = nativeObjectToString$1.call(value);
    if (unmasked) {
      if (isOwn) {
        value[symToStringTag$1] = tag;
      } else {
        delete value[symToStringTag$1];
      }
    }
    return result;
  }
  var objectProto$h = Object.prototype;
  var nativeObjectToString = objectProto$h.toString;
  function objectToString(value) {
    return nativeObjectToString.call(value);
  }
  var nullTag = "[object Null]", undefinedTag = "[object Undefined]";
  var symToStringTag = Symbol$2 ? Symbol$2.toStringTag : void 0;
  function baseGetTag(value) {
    if (value == null) {
      return value === void 0 ? undefinedTag : nullTag;
    }
    return symToStringTag && symToStringTag in Object(value) ? getRawTag(value) : objectToString(value);
  }
  function isObject(value) {
    var type2 = typeof value;
    return value != null && (type2 == "object" || type2 == "function");
  }
  var asyncTag = "[object AsyncFunction]", funcTag$2 = "[object Function]", genTag$1 = "[object GeneratorFunction]", proxyTag = "[object Proxy]";
  function isFunction(value) {
    if (!isObject(value)) {
      return false;
    }
    var tag = baseGetTag(value);
    return tag == funcTag$2 || tag == genTag$1 || tag == asyncTag || tag == proxyTag;
  }
  var coreJsData = root$1["__core-js_shared__"];
  const coreJsData$1 = coreJsData;
  var maskSrcKey = function() {
    var uid = /[^.]+$/.exec(coreJsData$1 && coreJsData$1.keys && coreJsData$1.keys.IE_PROTO || "");
    return uid ? "Symbol(src)_1." + uid : "";
  }();
  function isMasked(func) {
    return !!maskSrcKey && maskSrcKey in func;
  }
  var funcProto$2 = Function.prototype;
  var funcToString$2 = funcProto$2.toString;
  function toSource(func) {
    if (func != null) {
      try {
        return funcToString$2.call(func);
      } catch (e) {
      }
      try {
        return func + "";
      } catch (e) {
      }
    }
    return "";
  }
  var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;
  var reIsHostCtor = /^\[object .+?Constructor\]$/;
  var funcProto$1 = Function.prototype, objectProto$g = Object.prototype;
  var funcToString$1 = funcProto$1.toString;
  var hasOwnProperty$f = objectProto$g.hasOwnProperty;
  var reIsNative = RegExp(
    "^" + funcToString$1.call(hasOwnProperty$f).replace(reRegExpChar, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$"
  );
  function baseIsNative(value) {
    if (!isObject(value) || isMasked(value)) {
      return false;
    }
    var pattern = isFunction(value) ? reIsNative : reIsHostCtor;
    return pattern.test(toSource(value));
  }
  function getValue(object2, key) {
    return object2 == null ? void 0 : object2[key];
  }
  function getNative(object2, key) {
    var value = getValue(object2, key);
    return baseIsNative(value) ? value : void 0;
  }
  var nativeCreate = getNative(Object, "create");
  const nativeCreate$1 = nativeCreate;
  function hashClear() {
    this.__data__ = nativeCreate$1 ? nativeCreate$1(null) : {};
    this.size = 0;
  }
  function hashDelete(key) {
    var result = this.has(key) && delete this.__data__[key];
    this.size -= result ? 1 : 0;
    return result;
  }
  var HASH_UNDEFINED$2 = "__lodash_hash_undefined__";
  var objectProto$f = Object.prototype;
  var hasOwnProperty$e = objectProto$f.hasOwnProperty;
  function hashGet(key) {
    var data = this.__data__;
    if (nativeCreate$1) {
      var result = data[key];
      return result === HASH_UNDEFINED$2 ? void 0 : result;
    }
    return hasOwnProperty$e.call(data, key) ? data[key] : void 0;
  }
  var objectProto$e = Object.prototype;
  var hasOwnProperty$d = objectProto$e.hasOwnProperty;
  function hashHas(key) {
    var data = this.__data__;
    return nativeCreate$1 ? data[key] !== void 0 : hasOwnProperty$d.call(data, key);
  }
  var HASH_UNDEFINED$1 = "__lodash_hash_undefined__";
  function hashSet(key, value) {
    var data = this.__data__;
    this.size += this.has(key) ? 0 : 1;
    data[key] = nativeCreate$1 && value === void 0 ? HASH_UNDEFINED$1 : value;
    return this;
  }
  function Hash(entries2) {
    var index2 = -1, length2 = entries2 == null ? 0 : entries2.length;
    this.clear();
    while (++index2 < length2) {
      var entry = entries2[index2];
      this.set(entry[0], entry[1]);
    }
  }
  Hash.prototype.clear = hashClear;
  Hash.prototype["delete"] = hashDelete;
  Hash.prototype.get = hashGet;
  Hash.prototype.has = hashHas;
  Hash.prototype.set = hashSet;
  function listCacheClear() {
    this.__data__ = [];
    this.size = 0;
  }
  function eq(value, other) {
    return value === other || value !== value && other !== other;
  }
  function assocIndexOf(array2, key) {
    var length2 = array2.length;
    while (length2--) {
      if (eq(array2[length2][0], key)) {
        return length2;
      }
    }
    return -1;
  }
  var arrayProto = Array.prototype;
  var splice$1 = arrayProto.splice;
  function listCacheDelete(key) {
    var data = this.__data__, index2 = assocIndexOf(data, key);
    if (index2 < 0) {
      return false;
    }
    var lastIndex = data.length - 1;
    if (index2 == lastIndex) {
      data.pop();
    } else {
      splice$1.call(data, index2, 1);
    }
    --this.size;
    return true;
  }
  function listCacheGet(key) {
    var data = this.__data__, index2 = assocIndexOf(data, key);
    return index2 < 0 ? void 0 : data[index2][1];
  }
  function listCacheHas(key) {
    return assocIndexOf(this.__data__, key) > -1;
  }
  function listCacheSet(key, value) {
    var data = this.__data__, index2 = assocIndexOf(data, key);
    if (index2 < 0) {
      ++this.size;
      data.push([key, value]);
    } else {
      data[index2][1] = value;
    }
    return this;
  }
  function ListCache(entries2) {
    var index2 = -1, length2 = entries2 == null ? 0 : entries2.length;
    this.clear();
    while (++index2 < length2) {
      var entry = entries2[index2];
      this.set(entry[0], entry[1]);
    }
  }
  ListCache.prototype.clear = listCacheClear;
  ListCache.prototype["delete"] = listCacheDelete;
  ListCache.prototype.get = listCacheGet;
  ListCache.prototype.has = listCacheHas;
  ListCache.prototype.set = listCacheSet;
  var Map$1 = getNative(root$1, "Map");
  const Map$2 = Map$1;
  function mapCacheClear() {
    this.size = 0;
    this.__data__ = {
      "hash": new Hash(),
      "map": new (Map$2 || ListCache)(),
      "string": new Hash()
    };
  }
  function isKeyable(value) {
    var type2 = typeof value;
    return type2 == "string" || type2 == "number" || type2 == "symbol" || type2 == "boolean" ? value !== "__proto__" : value === null;
  }
  function getMapData(map2, key) {
    var data = map2.__data__;
    return isKeyable(key) ? data[typeof key == "string" ? "string" : "hash"] : data.map;
  }
  function mapCacheDelete(key) {
    var result = getMapData(this, key)["delete"](key);
    this.size -= result ? 1 : 0;
    return result;
  }
  function mapCacheGet(key) {
    return getMapData(this, key).get(key);
  }
  function mapCacheHas(key) {
    return getMapData(this, key).has(key);
  }
  function mapCacheSet(key, value) {
    var data = getMapData(this, key), size2 = data.size;
    data.set(key, value);
    this.size += data.size == size2 ? 0 : 1;
    return this;
  }
  function MapCache(entries2) {
    var index2 = -1, length2 = entries2 == null ? 0 : entries2.length;
    this.clear();
    while (++index2 < length2) {
      var entry = entries2[index2];
      this.set(entry[0], entry[1]);
    }
  }
  MapCache.prototype.clear = mapCacheClear;
  MapCache.prototype["delete"] = mapCacheDelete;
  MapCache.prototype.get = mapCacheGet;
  MapCache.prototype.has = mapCacheHas;
  MapCache.prototype.set = mapCacheSet;
  var FUNC_ERROR_TEXT = "Expected a function";
  function memoize(func, resolver2) {
    if (typeof func != "function" || resolver2 != null && typeof resolver2 != "function") {
      throw new TypeError(FUNC_ERROR_TEXT);
    }
    var memoized = function() {
      var args = arguments, key = resolver2 ? resolver2.apply(this, args) : args[0], cache = memoized.cache;
      if (cache.has(key)) {
        return cache.get(key);
      }
      var result = func.apply(this, args);
      memoized.cache = cache.set(key, result) || cache;
      return result;
    };
    memoized.cache = new (memoize.Cache || MapCache)();
    return memoized;
  }
  memoize.Cache = MapCache;
  const ZERO_WIDTH_SPACE = "​";
  const d3CurveTypes = {
    curveBasis,
    curveBasisClosed,
    curveBasisOpen,
    curveBumpX: bumpX,
    curveBumpY: bumpY,
    curveBundle,
    curveCardinalClosed,
    curveCardinalOpen,
    curveCardinal,
    curveCatmullRomClosed,
    curveCatmullRomOpen,
    curveCatmullRom,
    curveLinear,
    curveLinearClosed,
    curveMonotoneX: monotoneX,
    curveMonotoneY: monotoneY,
    curveNatural,
    curveStep,
    curveStepAfter: stepAfter,
    curveStepBefore: stepBefore
  };
  const directive = /%{2}{\s*(?:(\w+)\s*:|(\w+))\s*(?:(\w+)|((?:(?!}%{2}).|\r?\n)*))?\s*(?:}%{2})?/gi;
  const directiveWithoutOpen = /\s*(?:(\w+)(?=:):|(\w+))\s*(?:(\w+)|((?:(?!}%{2}).|\r?\n)*))?\s*(?:}%{2})?/gi;
  const detectInit = function(text2, config2) {
    const inits = detectDirective(text2, /(?:init\b)|(?:initialize\b)/);
    let results = {};
    if (Array.isArray(inits)) {
      const args = inits.map((init2) => init2.args);
      directiveSanitizer(args);
      results = assignWithDepth$1(results, [...args]);
    } else {
      results = inits.args;
    }
    if (results) {
      let type2 = detectType(text2, config2);
      ["config"].forEach((prop) => {
        if (results[prop] !== void 0) {
          if (type2 === "flowchart-v2") {
            type2 = "flowchart";
          }
          results[type2] = results[prop];
          delete results[prop];
        }
      });
    }
    return results;
  };
  const detectDirective = function(text2, type2 = null) {
    try {
      const commentWithoutDirectives = new RegExp(
        `[%]{2}(?![{]${directiveWithoutOpen.source})(?=[}][%]{2}).*
`,
        "ig"
      );
      text2 = text2.trim().replace(commentWithoutDirectives, "").replace(/'/gm, '"');
      log$1.debug(
        `Detecting diagram directive${type2 !== null ? " type:" + type2 : ""} based on the text:${text2}`
      );
      let match;
      const result = [];
      while ((match = directive.exec(text2)) !== null) {
        if (match.index === directive.lastIndex) {
          directive.lastIndex++;
        }
        if (match && !type2 || type2 && match[1] && match[1].match(type2) || type2 && match[2] && match[2].match(type2)) {
          const type22 = match[1] ? match[1] : match[2];
          const args = match[3] ? match[3].trim() : match[4] ? JSON.parse(match[4].trim()) : null;
          result.push({ type: type22, args });
        }
      }
      if (result.length === 0) {
        result.push({ type: text2, args: null });
      }
      return result.length === 1 ? result[0] : result;
    } catch (error) {
      log$1.error(
        `ERROR: ${error.message} - Unable to parse directive
      ${type2 !== null ? " type:" + type2 : ""} based on the text:${text2}`
      );
      return { type: null, args: null };
    }
  };
  const isSubstringInArray = function(str2, arr) {
    for (const [i2, element2] of arr.entries()) {
      if (element2.match(str2)) {
        return i2;
      }
    }
    return -1;
  };
  function interpolateToCurve(interpolate2, defaultCurve) {
    if (!interpolate2) {
      return defaultCurve;
    }
    const curveName = `curve${interpolate2.charAt(0).toUpperCase() + interpolate2.slice(1)}`;
    return d3CurveTypes[curveName] || defaultCurve;
  }
  function formatUrl(linkStr, config2) {
    const url = linkStr.trim();
    if (url) {
      if (config2.securityLevel !== "loose") {
        return sanitizeUrl_1(url);
      }
      return url;
    }
  }
  const runFunc = (functionName, ...params) => {
    const arrPaths = functionName.split(".");
    const len = arrPaths.length - 1;
    const fnName = arrPaths[len];
    let obj = window;
    for (let i2 = 0; i2 < len; i2++) {
      obj = obj[arrPaths[i2]];
      if (!obj) {
        return;
      }
    }
    obj[fnName](...params);
  };
  function distance(p1, p2) {
    return p1 && p2 ? Math.sqrt(Math.pow(p2.x - p1.x, 2) + Math.pow(p2.y - p1.y, 2)) : 0;
  }
  function traverseEdge(points) {
    let prevPoint;
    let totalDistance = 0;
    points.forEach((point2) => {
      totalDistance += distance(point2, prevPoint);
      prevPoint = point2;
    });
    let remainingDistance = totalDistance / 2;
    let center2 = void 0;
    prevPoint = void 0;
    points.forEach((point2) => {
      if (prevPoint && !center2) {
        const vectorDistance = distance(point2, prevPoint);
        if (vectorDistance < remainingDistance) {
          remainingDistance -= vectorDistance;
        } else {
          const distanceRatio = remainingDistance / vectorDistance;
          if (distanceRatio <= 0) {
            center2 = prevPoint;
          }
          if (distanceRatio >= 1) {
            center2 = { x: point2.x, y: point2.y };
          }
          if (distanceRatio > 0 && distanceRatio < 1) {
            center2 = {
              x: (1 - distanceRatio) * prevPoint.x + distanceRatio * point2.x,
              y: (1 - distanceRatio) * prevPoint.y + distanceRatio * point2.y
            };
          }
        }
      }
      prevPoint = point2;
    });
    return center2;
  }
  function calcLabelPosition(points) {
    if (points.length === 1) {
      return points[0];
    }
    return traverseEdge(points);
  }
  const calcCardinalityPosition = (isRelationTypePresent, points, initialPosition) => {
    let prevPoint;
    log$1.info(`our points ${JSON.stringify(points)}`);
    if (points[0] !== initialPosition) {
      points = points.reverse();
    }
    const distanceToCardinalityPoint = 25;
    let remainingDistance = distanceToCardinalityPoint;
    let center2;
    prevPoint = void 0;
    points.forEach((point2) => {
      if (prevPoint && !center2) {
        const vectorDistance = distance(point2, prevPoint);
        if (vectorDistance < remainingDistance) {
          remainingDistance -= vectorDistance;
        } else {
          const distanceRatio = remainingDistance / vectorDistance;
          if (distanceRatio <= 0) {
            center2 = prevPoint;
          }
          if (distanceRatio >= 1) {
            center2 = { x: point2.x, y: point2.y };
          }
          if (distanceRatio > 0 && distanceRatio < 1) {
            center2 = {
              x: (1 - distanceRatio) * prevPoint.x + distanceRatio * point2.x,
              y: (1 - distanceRatio) * prevPoint.y + distanceRatio * point2.y
            };
          }
        }
      }
      prevPoint = point2;
    });
    const d = isRelationTypePresent ? 10 : 5;
    const angle = Math.atan2(points[0].y - center2.y, points[0].x - center2.x);
    const cardinalityPosition = { x: 0, y: 0 };
    cardinalityPosition.x = Math.sin(angle) * d + (points[0].x + center2.x) / 2;
    cardinalityPosition.y = -Math.cos(angle) * d + (points[0].y + center2.y) / 2;
    return cardinalityPosition;
  };
  function calcTerminalLabelPosition(terminalMarkerSize, position2, _points) {
    let points = JSON.parse(JSON.stringify(_points));
    let prevPoint;
    log$1.info("our points", points);
    if (position2 !== "start_left" && position2 !== "start_right") {
      points = points.reverse();
    }
    points.forEach((point2) => {
      prevPoint = point2;
    });
    const distanceToCardinalityPoint = 25 + terminalMarkerSize;
    let remainingDistance = distanceToCardinalityPoint;
    let center2;
    prevPoint = void 0;
    points.forEach((point2) => {
      if (prevPoint && !center2) {
        const vectorDistance = distance(point2, prevPoint);
        if (vectorDistance < remainingDistance) {
          remainingDistance -= vectorDistance;
        } else {
          const distanceRatio = remainingDistance / vectorDistance;
          if (distanceRatio <= 0) {
            center2 = prevPoint;
          }
          if (distanceRatio >= 1) {
            center2 = { x: point2.x, y: point2.y };
          }
          if (distanceRatio > 0 && distanceRatio < 1) {
            center2 = {
              x: (1 - distanceRatio) * prevPoint.x + distanceRatio * point2.x,
              y: (1 - distanceRatio) * prevPoint.y + distanceRatio * point2.y
            };
          }
        }
      }
      prevPoint = point2;
    });
    const d = 10 + terminalMarkerSize * 0.5;
    const angle = Math.atan2(points[0].y - center2.y, points[0].x - center2.x);
    const cardinalityPosition = { x: 0, y: 0 };
    cardinalityPosition.x = Math.sin(angle) * d + (points[0].x + center2.x) / 2;
    cardinalityPosition.y = -Math.cos(angle) * d + (points[0].y + center2.y) / 2;
    if (position2 === "start_left") {
      cardinalityPosition.x = Math.sin(angle + Math.PI) * d + (points[0].x + center2.x) / 2;
      cardinalityPosition.y = -Math.cos(angle + Math.PI) * d + (points[0].y + center2.y) / 2;
    }
    if (position2 === "end_right") {
      cardinalityPosition.x = Math.sin(angle - Math.PI) * d + (points[0].x + center2.x) / 2 - 5;
      cardinalityPosition.y = -Math.cos(angle - Math.PI) * d + (points[0].y + center2.y) / 2 - 5;
    }
    if (position2 === "end_left") {
      cardinalityPosition.x = Math.sin(angle) * d + (points[0].x + center2.x) / 2 - 5;
      cardinalityPosition.y = -Math.cos(angle) * d + (points[0].y + center2.y) / 2 - 5;
    }
    return cardinalityPosition;
  }
  function getStylesFromArray(arr) {
    let style = "";
    let labelStyle = "";
    for (const element2 of arr) {
      if (element2 !== void 0) {
        if (element2.startsWith("color:") || element2.startsWith("text-align:")) {
          labelStyle = labelStyle + element2 + ";";
        } else {
          style = style + element2 + ";";
        }
      }
    }
    return { style, labelStyle };
  }
  let cnt$1 = 0;
  const generateId$1 = () => {
    cnt$1++;
    return "id-" + Math.random().toString(36).substr(2, 12) + "-" + cnt$1;
  };
  function makeid(length2) {
    let result = "";
    const characters2 = "0123456789abcdef";
    const charactersLength = characters2.length;
    for (let i2 = 0; i2 < length2; i2++) {
      result += characters2.charAt(Math.floor(Math.random() * charactersLength));
    }
    return result;
  }
  const random = (options2) => {
    return makeid(options2.length);
  };
  const getTextObj$3 = function() {
    return {
      x: 0,
      y: 0,
      fill: void 0,
      anchor: "start",
      style: "#666",
      width: 100,
      height: 100,
      textMargin: 0,
      rx: 0,
      ry: 0,
      valign: void 0
    };
  };
  const drawSimpleText = function(elem, textData) {
    const nText = textData.text.replace(common$1.lineBreakRegex, " ");
    const [, _fontSizePx] = parseFontSize(textData.fontSize);
    const textElem = elem.append("text");
    textElem.attr("x", textData.x);
    textElem.attr("y", textData.y);
    textElem.style("text-anchor", textData.anchor);
    textElem.style("font-family", textData.fontFamily);
    textElem.style("font-size", _fontSizePx);
    textElem.style("font-weight", textData.fontWeight);
    textElem.attr("fill", textData.fill);
    if (textData.class !== void 0) {
      textElem.attr("class", textData.class);
    }
    const span = textElem.append("tspan");
    span.attr("x", textData.x + textData.textMargin * 2);
    span.attr("fill", textData.fill);
    span.text(nText);
    return textElem;
  };
  const wrapLabel = memoize(
    (label, maxWidth, config2) => {
      if (!label) {
        return label;
      }
      config2 = Object.assign(
        { fontSize: 12, fontWeight: 400, fontFamily: "Arial", joinWith: "<br/>" },
        config2
      );
      if (common$1.lineBreakRegex.test(label)) {
        return label;
      }
      const words = label.split(" ");
      const completedLines = [];
      let nextLine = "";
      words.forEach((word, index2) => {
        const wordLength = calculateTextWidth(`${word} `, config2);
        const nextLineLength = calculateTextWidth(nextLine, config2);
        if (wordLength > maxWidth) {
          const { hyphenatedStrings, remainingWord } = breakString(word, maxWidth, "-", config2);
          completedLines.push(nextLine, ...hyphenatedStrings);
          nextLine = remainingWord;
        } else if (nextLineLength + wordLength >= maxWidth) {
          completedLines.push(nextLine);
          nextLine = word;
        } else {
          nextLine = [nextLine, word].filter(Boolean).join(" ");
        }
        const currentWord = index2 + 1;
        const isLastWord = currentWord === words.length;
        if (isLastWord) {
          completedLines.push(nextLine);
        }
      });
      return completedLines.filter((line2) => line2 !== "").join(config2.joinWith);
    },
    (label, maxWidth, config2) => `${label}${maxWidth}${config2.fontSize}${config2.fontWeight}${config2.fontFamily}${config2.joinWith}`
  );
  const breakString = memoize(
    (word, maxWidth, hyphenCharacter = "-", config2) => {
      config2 = Object.assign(
        { fontSize: 12, fontWeight: 400, fontFamily: "Arial", margin: 0 },
        config2
      );
      const characters2 = [...word];
      const lines = [];
      let currentLine = "";
      characters2.forEach((character2, index2) => {
        const nextLine = `${currentLine}${character2}`;
        const lineWidth = calculateTextWidth(nextLine, config2);
        if (lineWidth >= maxWidth) {
          const currentCharacter = index2 + 1;
          const isLastLine = characters2.length === currentCharacter;
          const hyphenatedNextLine = `${nextLine}${hyphenCharacter}`;
          lines.push(isLastLine ? nextLine : hyphenatedNextLine);
          currentLine = "";
        } else {
          currentLine = nextLine;
        }
      });
      return { hyphenatedStrings: lines, remainingWord: currentLine };
    },
    (word, maxWidth, hyphenCharacter = "-", config2) => `${word}${maxWidth}${hyphenCharacter}${config2.fontSize}${config2.fontWeight}${config2.fontFamily}`
  );
  function calculateTextHeight(text2, config2) {
    config2 = Object.assign(
      { fontSize: 12, fontWeight: 400, fontFamily: "Arial", margin: 15 },
      config2
    );
    return calculateTextDimensions(text2, config2).height;
  }
  function calculateTextWidth(text2, config2) {
    config2 = Object.assign({ fontSize: 12, fontWeight: 400, fontFamily: "Arial" }, config2);
    return calculateTextDimensions(text2, config2).width;
  }
  const calculateTextDimensions = memoize(
    (text2, config2) => {
      config2 = Object.assign({ fontSize: 12, fontWeight: 400, fontFamily: "Arial" }, config2);
      const { fontSize, fontFamily, fontWeight } = config2;
      if (!text2) {
        return { width: 0, height: 0 };
      }
      const [, _fontSizePx] = parseFontSize(fontSize);
      const fontFamilies = ["sans-serif", fontFamily];
      const lines = text2.split(common$1.lineBreakRegex);
      const dims = [];
      const body = select("body");
      if (!body.remove) {
        return { width: 0, height: 0, lineHeight: 0 };
      }
      const g = body.append("svg");
      for (const fontFamily2 of fontFamilies) {
        let cheight = 0;
        const dim = { width: 0, height: 0, lineHeight: 0 };
        for (const line2 of lines) {
          const textObj = getTextObj$3();
          textObj.text = line2 || ZERO_WIDTH_SPACE;
          const textElem = drawSimpleText(g, textObj).style("font-size", _fontSizePx).style("font-weight", fontWeight).style("font-family", fontFamily2);
          const bBox = (textElem._groups || textElem)[0][0].getBBox();
          if (bBox.width === 0 && bBox.height === 0) {
            throw new Error("svg element not in render tree");
          }
          dim.width = Math.round(Math.max(dim.width, bBox.width));
          cheight = Math.round(bBox.height);
          dim.height += cheight;
          dim.lineHeight = Math.round(Math.max(dim.lineHeight, cheight));
        }
        dims.push(dim);
      }
      g.remove();
      const index2 = isNaN(dims[1].height) || isNaN(dims[1].width) || isNaN(dims[1].lineHeight) || dims[0].height > dims[1].height && dims[0].width > dims[1].width && dims[0].lineHeight > dims[1].lineHeight ? 0 : 1;
      return dims[index2];
    },
    (text2, config2) => `${text2}${config2.fontSize}${config2.fontWeight}${config2.fontFamily}`
  );
  const initIdGenerator = class iterator {
    constructor(deterministic, seed) {
      this.deterministic = deterministic;
      this.seed = seed;
      this.count = seed ? seed.length : 0;
    }
    next() {
      if (!this.deterministic) {
        return Date.now();
      }
      return this.count++;
    }
  };
  let decoder;
  const entityDecode = function(html2) {
    decoder = decoder || document.createElement("div");
    html2 = escape(html2).replace(/%26/g, "&").replace(/%23/g, "#").replace(/%3B/g, ";");
    decoder.innerHTML = html2;
    return unescape(decoder.textContent);
  };
  const directiveSanitizer = (args) => {
    log$1.debug("directiveSanitizer called with", args);
    if (typeof args === "object") {
      if (args.length) {
        args.forEach((arg) => directiveSanitizer(arg));
      } else {
        Object.keys(args).forEach((key) => {
          log$1.debug("Checking key", key);
          if (key.startsWith("__")) {
            log$1.debug("sanitize deleting __ option", key);
            delete args[key];
          }
          if (key.includes("proto")) {
            log$1.debug("sanitize deleting proto option", key);
            delete args[key];
          }
          if (key.includes("constr")) {
            log$1.debug("sanitize deleting constr option", key);
            delete args[key];
          }
          if (key.includes("themeCSS")) {
            log$1.debug("sanitizing themeCss option");
            args[key] = sanitizeCss(args[key]);
          }
          if (key.includes("fontFamily")) {
            log$1.debug("sanitizing fontFamily option");
            args[key] = sanitizeCss(args[key]);
          }
          if (key.includes("altFontFamily")) {
            log$1.debug("sanitizing altFontFamily option");
            args[key] = sanitizeCss(args[key]);
          }
          if (!configKeys.includes(key)) {
            log$1.debug("sanitize deleting option", key);
            delete args[key];
          } else {
            if (typeof args[key] === "object") {
              log$1.debug("sanitize deleting object", key);
              directiveSanitizer(args[key]);
            }
          }
        });
      }
    }
    if (args.themeVariables) {
      const kArr = Object.keys(args.themeVariables);
      for (const k of kArr) {
        const val = args.themeVariables[k];
        if (val && val.match && !val.match(/^[\d "#%(),.;A-Za-z]+$/)) {
          args.themeVariables[k] = "";
        }
      }
    }
    log$1.debug("After sanitization", args);
  };
  const sanitizeCss = (str2) => {
    let startCnt = 0;
    let endCnt = 0;
    for (const element2 of str2) {
      if (startCnt < endCnt) {
        return "{ /* ERROR: Unbalanced CSS */ }";
      }
      if (element2 === "{") {
        startCnt++;
      } else if (element2 === "}") {
        endCnt++;
      }
    }
    if (startCnt !== endCnt) {
      return "{ /* ERROR: Unbalanced CSS */ }";
    }
    return str2;
  };
  function isDetailedError(error) {
    return "str" in error;
  }
  function getErrorMessage(error) {
    if (error instanceof Error) {
      return error.message;
    }
    return String(error);
  }
  const insertTitle = (parent, cssClass, titleTopMargin, title2) => {
    if (!title2) {
      return;
    }
    const bounds2 = parent.node().getBBox();
    parent.append("text").text(title2).attr("x", bounds2.x + bounds2.width / 2).attr("y", -titleTopMargin).attr("class", cssClass);
  };
  const parseFontSize = (fontSize) => {
    if (typeof fontSize === "number") {
      return [fontSize, fontSize + "px"];
    }
    const fontSizeNumber = parseInt(fontSize, 10);
    if (Number.isNaN(fontSizeNumber)) {
      return [void 0, void 0];
    } else if (fontSize === String(fontSizeNumber)) {
      return [fontSizeNumber, fontSize + "px"];
    } else {
      return [fontSizeNumber, fontSize];
    }
  };
  const utils = {
    assignWithDepth: assignWithDepth$1,
    wrapLabel,
    calculateTextHeight,
    calculateTextWidth,
    calculateTextDimensions,
    detectInit,
    detectDirective,
    isSubstringInArray,
    interpolateToCurve,
    calcLabelPosition,
    calcCardinalityPosition,
    calcTerminalLabelPosition,
    formatUrl,
    getStylesFromArray,
    generateId: generateId$1,
    random,
    runFunc,
    entityDecode,
    initIdGenerator,
    directiveSanitizer,
    sanitizeCss,
    insertTitle,
    parseFontSize
  };
  var COMMENT = "comm";
  var RULESET = "rule";
  var DECLARATION = "decl";
  var IMPORT = "@import";
  var KEYFRAMES = "@keyframes";
  var abs = Math.abs;
  var from = String.fromCharCode;
  function trim(value) {
    return value.trim();
  }
  function replace(value, pattern, replacement) {
    return value.replace(pattern, replacement);
  }
  function indexof(value, search2) {
    return value.indexOf(search2);
  }
  function charat(value, index2) {
    return value.charCodeAt(index2) | 0;
  }
  function substr(value, begin, end2) {
    return value.slice(begin, end2);
  }
  function strlen(value) {
    return value.length;
  }
  function sizeof(value) {
    return value.length;
  }
  function append(value, array2) {
    return array2.push(value), value;
  }
  var line = 1;
  var column = 1;
  var length = 0;
  var position$2 = 0;
  var character = 0;
  var characters = "";
  function node(value, root2, parent, type2, props, children2, length2) {
    return { value, root: root2, parent, type: type2, props, children: children2, line, column, length: length2, return: "" };
  }
  function char() {
    return character;
  }
  function prev() {
    character = position$2 > 0 ? charat(characters, --position$2) : 0;
    if (column--, character === 10)
      column = 1, line--;
    return character;
  }
  function next$1() {
    character = position$2 < length ? charat(characters, position$2++) : 0;
    if (column++, character === 10)
      column = 1, line++;
    return character;
  }
  function peek() {
    return charat(characters, position$2);
  }
  function caret() {
    return position$2;
  }
  function slice(begin, end2) {
    return substr(characters, begin, end2);
  }
  function token(type2) {
    switch (type2) {
      case 0:
      case 9:
      case 10:
      case 13:
      case 32:
        return 5;
      case 33:
      case 43:
      case 44:
      case 47:
      case 62:
      case 64:
      case 126:
      case 59:
      case 123:
      case 125:
        return 4;
      case 58:
        return 3;
      case 34:
      case 39:
      case 40:
      case 91:
        return 2;
      case 41:
      case 93:
        return 1;
    }
    return 0;
  }
  function alloc(value) {
    return line = column = 1, length = strlen(characters = value), position$2 = 0, [];
  }
  function dealloc(value) {
    return characters = "", value;
  }
  function delimit(type2) {
    return trim(slice(position$2 - 1, delimiter(type2 === 91 ? type2 + 2 : type2 === 40 ? type2 + 1 : type2)));
  }
  function whitespace(type2) {
    while (character = peek())
      if (character < 33)
        next$1();
      else
        break;
    return token(type2) > 2 || token(character) > 3 ? "" : " ";
  }
  function escaping(index2, count) {
    while (--count && next$1())
      if (character < 48 || character > 102 || character > 57 && character < 65 || character > 70 && character < 97)
        break;
    return slice(index2, caret() + (count < 6 && peek() == 32 && next$1() == 32));
  }
  function delimiter(type2) {
    while (next$1())
      switch (character) {
        case type2:
          return position$2;
        case 34:
        case 39:
          if (type2 !== 34 && type2 !== 39)
            delimiter(character);
          break;
        case 40:
          if (type2 === 41)
            delimiter(type2);
          break;
        case 92:
          next$1();
          break;
      }
    return position$2;
  }
  function commenter(type2, index2) {
    while (next$1())
      if (type2 + character === 47 + 10)
        break;
      else if (type2 + character === 42 + 42 && peek() === 47)
        break;
    return "/*" + slice(index2, position$2 - 1) + "*" + from(type2 === 47 ? type2 : next$1());
  }
  function identifier(index2) {
    while (!token(peek()))
      next$1();
    return slice(index2, position$2);
  }
  function compile(value) {
    return dealloc(parse$4("", null, null, null, [""], value = alloc(value), 0, [0], value));
  }
  function parse$4(value, root2, parent, rule, rules, rulesets, pseudo, points, declarations) {
    var index2 = 0;
    var offset = 0;
    var length2 = pseudo;
    var atrule = 0;
    var property2 = 0;
    var previous2 = 0;
    var variable = 1;
    var scanning = 1;
    var ampersand = 1;
    var character2 = 0;
    var type2 = "";
    var props = rules;
    var children2 = rulesets;
    var reference = rule;
    var characters2 = type2;
    while (scanning)
      switch (previous2 = character2, character2 = next$1()) {
        case 40:
          if (previous2 != 108 && charat(characters2, length2 - 1) == 58) {
            if (indexof(characters2 += replace(delimit(character2), "&", "&\f"), "&\f") != -1)
              ampersand = -1;
            break;
          }
        case 34:
        case 39:
        case 91:
          characters2 += delimit(character2);
          break;
        case 9:
        case 10:
        case 13:
        case 32:
          characters2 += whitespace(previous2);
          break;
        case 92:
          characters2 += escaping(caret() - 1, 7);
          continue;
        case 47:
          switch (peek()) {
            case 42:
            case 47:
              append(comment(commenter(next$1(), caret()), root2, parent), declarations);
              break;
            default:
              characters2 += "/";
          }
          break;
        case 123 * variable:
          points[index2++] = strlen(characters2) * ampersand;
        case 125 * variable:
        case 59:
        case 0:
          switch (character2) {
            case 0:
            case 125:
              scanning = 0;
            case 59 + offset:
              if (property2 > 0 && strlen(characters2) - length2)
                append(property2 > 32 ? declaration(characters2 + ";", rule, parent, length2 - 1) : declaration(replace(characters2, " ", "") + ";", rule, parent, length2 - 2), declarations);
              break;
            case 59:
              characters2 += ";";
            default:
              append(reference = ruleset(characters2, root2, parent, index2, offset, rules, points, type2, props = [], children2 = [], length2), rulesets);
              if (character2 === 123)
                if (offset === 0)
                  parse$4(characters2, root2, reference, reference, props, rulesets, length2, points, children2);
                else
                  switch (atrule === 99 && charat(characters2, 3) === 110 ? 100 : atrule) {
                    case 100:
                    case 109:
                    case 115:
                      parse$4(value, reference, reference, rule && append(ruleset(value, reference, reference, 0, 0, rules, points, type2, rules, props = [], length2), children2), rules, children2, length2, points, rule ? props : children2);
                      break;
                    default:
                      parse$4(characters2, reference, reference, reference, [""], children2, 0, points, children2);
                  }
          }
          index2 = offset = property2 = 0, variable = ampersand = 1, type2 = characters2 = "", length2 = pseudo;
          break;
        case 58:
          length2 = 1 + strlen(characters2), property2 = previous2;
        default:
          if (variable < 1) {
            if (character2 == 123)
              --variable;
            else if (character2 == 125 && variable++ == 0 && prev() == 125)
              continue;
          }
          switch (characters2 += from(character2), character2 * variable) {
            case 38:
              ampersand = offset > 0 ? 1 : (characters2 += "\f", -1);
              break;
            case 44:
              points[index2++] = (strlen(characters2) - 1) * ampersand, ampersand = 1;
              break;
            case 64:
              if (peek() === 45)
                characters2 += delimit(next$1());
              atrule = peek(), offset = length2 = strlen(type2 = characters2 += identifier(caret())), character2++;
              break;
            case 45:
              if (previous2 === 45 && strlen(characters2) == 2)
                variable = 0;
          }
      }
    return rulesets;
  }
  function ruleset(value, root2, parent, index2, offset, rules, points, type2, props, children2, length2) {
    var post = offset - 1;
    var rule = offset === 0 ? rules : [""];
    var size2 = sizeof(rule);
    for (var i2 = 0, j = 0, k = 0; i2 < index2; ++i2)
      for (var x2 = 0, y2 = substr(value, post + 1, post = abs(j = points[i2])), z = value; x2 < size2; ++x2)
        if (z = trim(j > 0 ? rule[x2] + " " + y2 : replace(y2, /&\f/g, rule[x2])))
          props[k++] = z;
    return node(value, root2, parent, offset === 0 ? RULESET : type2, props, children2, length2);
  }
  function comment(value, root2, parent) {
    return node(value, root2, parent, COMMENT, from(char()), substr(value, 2, -2), 0);
  }
  function declaration(value, root2, parent, length2) {
    return node(value, root2, parent, DECLARATION, substr(value, 0, length2), substr(value, length2 + 1, -1), length2);
  }
  function serialize(children2, callback) {
    var output = "";
    var length2 = sizeof(children2);
    for (var i2 = 0; i2 < length2; i2++)
      output += callback(children2[i2], i2, children2, callback) || "";
    return output;
  }
  function stringify(element2, index2, children2, callback) {
    switch (element2.type) {
      case IMPORT:
      case DECLARATION:
        return element2.return = element2.return || element2.value;
      case COMMENT:
        return "";
      case KEYFRAMES:
        return element2.return = element2.value + "{" + serialize(element2.children, callback) + "}";
      case RULESET:
        element2.value = element2.props.join(",");
    }
    return strlen(children2 = serialize(element2.children, callback)) ? element2.return = element2.value + "{" + children2 + "}" : "";
  }
  const version$1 = "10.2.3";
  const id$i = "c4";
  const detector$i = (txt) => {
    return txt.match(/^\s*C4Context|C4Container|C4Component|C4Dynamic|C4Deployment/) !== null;
  };
  const loader$i = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => c4Diagram);
    return { id: id$i, diagram: diagram2 };
  };
  const plugin$i = {
    id: id$i,
    detector: detector$i,
    loader: loader$i
  };
  const c4 = plugin$i;
  const id$h = "flowchart";
  const detector$h = (txt, config2) => {
    var _a, _b;
    if (((_a = config2 == null ? void 0 : config2.flowchart) == null ? void 0 : _a.defaultRenderer) === "dagre-wrapper" || ((_b = config2 == null ? void 0 : config2.flowchart) == null ? void 0 : _b.defaultRenderer) === "elk") {
      return false;
    }
    return txt.match(/^\s*graph/) !== null;
  };
  const loader$h = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => flowDiagram);
    return { id: id$h, diagram: diagram2 };
  };
  const plugin$h = {
    id: id$h,
    detector: detector$h,
    loader: loader$h
  };
  const flowchart = plugin$h;
  const id$g = "flowchart-v2";
  const detector$g = (txt, config2) => {
    var _a, _b, _c;
    if (((_a = config2 == null ? void 0 : config2.flowchart) == null ? void 0 : _a.defaultRenderer) === "dagre-d3" || ((_b = config2 == null ? void 0 : config2.flowchart) == null ? void 0 : _b.defaultRenderer) === "elk") {
      return false;
    }
    if (txt.match(/^\s*graph/) !== null && ((_c = config2 == null ? void 0 : config2.flowchart) == null ? void 0 : _c.defaultRenderer) === "dagre-wrapper") {
      return true;
    }
    return txt.match(/^\s*flowchart/) !== null;
  };
  const loader$g = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => flowDiagramV2);
    return { id: id$g, diagram: diagram2 };
  };
  const plugin$g = {
    id: id$g,
    detector: detector$g,
    loader: loader$g
  };
  const flowchartV2 = plugin$g;
  const id$f = "er";
  const detector$f = (txt) => {
    return txt.match(/^\s*erDiagram/) !== null;
  };
  const loader$f = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => erDiagram);
    return { id: id$f, diagram: diagram2 };
  };
  const plugin$f = {
    id: id$f,
    detector: detector$f,
    loader: loader$f
  };
  const er = plugin$f;
  const id$e = "gitGraph";
  const detector$e = (txt) => {
    return txt.match(/^\s*gitGraph/) !== null;
  };
  const loader$e = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => gitGraphDiagram);
    return { id: id$e, diagram: diagram2 };
  };
  const plugin$e = {
    id: id$e,
    detector: detector$e,
    loader: loader$e
  };
  const git = plugin$e;
  const id$d = "gantt";
  const detector$d = (txt) => {
    return txt.match(/^\s*gantt/) !== null;
  };
  const loader$d = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => ganttDiagram);
    return { id: id$d, diagram: diagram2 };
  };
  const plugin$d = {
    id: id$d,
    detector: detector$d,
    loader: loader$d
  };
  const gantt = plugin$d;
  const id$c = "info";
  const detector$c = (txt) => {
    return txt.match(/^\s*info/) !== null;
  };
  const loader$c = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => infoDiagram);
    return { id: id$c, diagram: diagram2 };
  };
  const plugin$c = {
    id: id$c,
    detector: detector$c,
    loader: loader$c
  };
  const info$1 = plugin$c;
  const id$b = "pie";
  const detector$b = (txt) => {
    return txt.match(/^\s*pie/) !== null;
  };
  const loader$b = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => pieDiagram);
    return { id: id$b, diagram: diagram2 };
  };
  const plugin$b = {
    id: id$b,
    detector: detector$b,
    loader: loader$b
  };
  const pie = plugin$b;
  const id$a = "quadrantChart";
  const detector$a = (txt) => {
    return txt.match(/^\s*quadrantChart/) !== null;
  };
  const loader$a = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => quadrantDiagram);
    return { id: id$a, diagram: diagram2 };
  };
  const plugin$a = {
    id: id$a,
    detector: detector$a,
    loader: loader$a
  };
  const quadrantChart = plugin$a;
  const id$9 = "requirement";
  const detector$9 = (txt) => {
    return txt.match(/^\s*requirement(Diagram)?/) !== null;
  };
  const loader$9 = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => requirementDiagram);
    return { id: id$9, diagram: diagram2 };
  };
  const plugin$9 = {
    id: id$9,
    detector: detector$9,
    loader: loader$9
  };
  const requirement = plugin$9;
  const id$8 = "sequence";
  const detector$8 = (txt) => {
    return txt.match(/^\s*sequenceDiagram/) !== null;
  };
  const loader$8 = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => sequenceDiagram);
    return { id: id$8, diagram: diagram2 };
  };
  const plugin$8 = {
    id: id$8,
    detector: detector$8,
    loader: loader$8
  };
  const sequence = plugin$8;
  const id$7 = "class";
  const detector$7 = (txt, config2) => {
    var _a;
    if (((_a = config2 == null ? void 0 : config2.class) == null ? void 0 : _a.defaultRenderer) === "dagre-wrapper") {
      return false;
    }
    return txt.match(/^\s*classDiagram/) !== null;
  };
  const loader$7 = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => classDiagram);
    return { id: id$7, diagram: diagram2 };
  };
  const plugin$7 = {
    id: id$7,
    detector: detector$7,
    loader: loader$7
  };
  const classDiagram$1 = plugin$7;
  const id$6 = "classDiagram";
  const detector$6 = (txt, config2) => {
    var _a;
    if (txt.match(/^\s*classDiagram/) !== null && ((_a = config2 == null ? void 0 : config2.class) == null ? void 0 : _a.defaultRenderer) === "dagre-wrapper") {
      return true;
    }
    return txt.match(/^\s*classDiagram-v2/) !== null;
  };
  const loader$6 = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => classDiagramV2);
    return { id: id$6, diagram: diagram2 };
  };
  const plugin$6 = {
    id: id$6,
    detector: detector$6,
    loader: loader$6
  };
  const classDiagramV2$1 = plugin$6;
  const id$5 = "state";
  const detector$5 = (txt, config2) => {
    var _a;
    if (((_a = config2 == null ? void 0 : config2.state) == null ? void 0 : _a.defaultRenderer) === "dagre-wrapper") {
      return false;
    }
    return txt.match(/^\s*stateDiagram/) !== null;
  };
  const loader$5 = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => stateDiagram);
    return { id: id$5, diagram: diagram2 };
  };
  const plugin$5 = {
    id: id$5,
    detector: detector$5,
    loader: loader$5
  };
  const state = plugin$5;
  const id$4 = "stateDiagram";
  const detector$4 = (text2, config2) => {
    var _a, _b;
    if (text2.match(/^\s*stateDiagram-v2/) !== null) {
      return true;
    }
    if (text2.match(/^\s*stateDiagram/) && ((_a = config2 == null ? void 0 : config2.state) == null ? void 0 : _a.defaultRenderer) === "dagre-wrapper") {
      return true;
    }
    if (text2.match(/^\s*stateDiagram/) && ((_b = config2 == null ? void 0 : config2.state) == null ? void 0 : _b.defaultRenderer) === "dagre-wrapper") {
      return true;
    }
    return false;
  };
  const loader$4 = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => stateDiagramV2);
    return { id: id$4, diagram: diagram2 };
  };
  const plugin$4 = {
    id: id$4,
    detector: detector$4,
    loader: loader$4
  };
  const stateV2 = plugin$4;
  const id$3 = "journey";
  const detector$3 = (txt) => {
    return txt.match(/^\s*journey/) !== null;
  };
  const loader$3 = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => journeyDiagram);
    return { id: id$3, diagram: diagram2 };
  };
  const plugin$3 = {
    id: id$3,
    detector: detector$3,
    loader: loader$3
  };
  const journey = plugin$3;
  const getStyles$f = () => ``;
  const styles$9 = getStyles$f;
  const setConf$a = function() {
  };
  const draw$j = (_text, id2, mermaidVersion) => {
    try {
      log$1.debug("Renering svg for syntax error\n");
      const svg2 = select("#" + id2);
      const g = svg2.append("g");
      g.append("path").attr("class", "error-icon").attr(
        "d",
        "m411.313,123.313c6.25-6.25 6.25-16.375 0-22.625s-16.375-6.25-22.625,0l-32,32-9.375,9.375-20.688-20.688c-12.484-12.5-32.766-12.5-45.25,0l-16,16c-1.261,1.261-2.304,2.648-3.31,4.051-21.739-8.561-45.324-13.426-70.065-13.426-105.867,0-192,86.133-192,192s86.133,192 192,192 192-86.133 192-192c0-24.741-4.864-48.327-13.426-70.065 1.402-1.007 2.79-2.049 4.051-3.31l16-16c12.5-12.492 12.5-32.758 0-45.25l-20.688-20.688 9.375-9.375 32.001-31.999zm-219.313,100.687c-52.938,0-96,43.063-96,96 0,8.836-7.164,16-16,16s-16-7.164-16-16c0-70.578 57.422-128 128-128 8.836,0 16,7.164 16,16s-7.164,16-16,16z"
      );
      g.append("path").attr("class", "error-icon").attr(
        "d",
        "m459.02,148.98c-6.25-6.25-16.375-6.25-22.625,0s-6.25,16.375 0,22.625l16,16c3.125,3.125 7.219,4.688 11.313,4.688 4.094,0 8.188-1.563 11.313-4.688 6.25-6.25 6.25-16.375 0-22.625l-16.001-16z"
      );
      g.append("path").attr("class", "error-icon").attr(
        "d",
        "m340.395,75.605c3.125,3.125 7.219,4.688 11.313,4.688 4.094,0 8.188-1.563 11.313-4.688 6.25-6.25 6.25-16.375 0-22.625l-16-16c-6.25-6.25-16.375-6.25-22.625,0s-6.25,16.375 0,22.625l15.999,16z"
      );
      g.append("path").attr("class", "error-icon").attr(
        "d",
        "m400,64c8.844,0 16-7.164 16-16v-32c0-8.836-7.156-16-16-16-8.844,0-16,7.164-16,16v32c0,8.836 7.156,16 16,16z"
      );
      g.append("path").attr("class", "error-icon").attr(
        "d",
        "m496,96.586h-32c-8.844,0-16,7.164-16,16 0,8.836 7.156,16 16,16h32c8.844,0 16-7.164 16-16 0-8.836-7.156-16-16-16z"
      );
      g.append("path").attr("class", "error-icon").attr(
        "d",
        "m436.98,75.605c3.125,3.125 7.219,4.688 11.313,4.688 4.094,0 8.188-1.563 11.313-4.688l32-32c6.25-6.25 6.25-16.375 0-22.625s-16.375-6.25-22.625,0l-32,32c-6.251,6.25-6.251,16.375-0.001,22.625z"
      );
      g.append("text").attr("class", "error-text").attr("x", 1440).attr("y", 250).attr("font-size", "150px").style("text-anchor", "middle").text("Syntax error in text");
      g.append("text").attr("class", "error-text").attr("x", 1250).attr("y", 400).attr("font-size", "100px").style("text-anchor", "middle").text("mermaid version " + mermaidVersion);
      svg2.attr("height", 100);
      svg2.attr("width", 500);
      svg2.attr("viewBox", "768 0 912 512");
    } catch (e) {
      log$1.error("Error while rendering info diagram");
      log$1.error(getErrorMessage(e));
    }
  };
  const errorRenderer = {
    setConf: setConf$a,
    draw: draw$j
  };
  const diagram$j = {
    db: {
      clear: () => {
      }
    },
    styles: styles$9,
    renderer: errorRenderer,
    parser: {
      parser: { yy: {} },
      parse: () => {
      }
    },
    init: () => {
    }
  };
  const errorDiagram = diagram$j;
  const id$2 = "flowchart-elk";
  const detector$2 = (txt, config2) => {
    var _a;
    if (
      // If diagram explicitly states flowchart-elk
      txt.match(/^\s*flowchart-elk/) || // If a flowchart/graph diagram has their default renderer set to elk
      txt.match(/^\s*flowchart|graph/) && ((_a = config2 == null ? void 0 : config2.flowchart) == null ? void 0 : _a.defaultRenderer) === "elk"
    ) {
      return true;
    }
    return false;
  };
  const loader$2 = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => flowchartElkDefinition);
    return { id: id$2, diagram: diagram2 };
  };
  const plugin$2 = {
    id: id$2,
    detector: detector$2,
    loader: loader$2
  };
  const flowchartElk = plugin$2;
  const id$1 = "timeline";
  const detector$1 = (txt) => {
    return txt.match(/^\s*timeline/) !== null;
  };
  const loader$1 = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => timelineDefinition);
    return { id: id$1, diagram: diagram2 };
  };
  const plugin$1 = {
    id: id$1,
    detector: detector$1,
    loader: loader$1
  };
  const timeline = plugin$1;
  const id = "mindmap";
  const detector = (txt) => {
    return txt.match(/^\s*mindmap/) !== null;
  };
  const loader = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => mindmapDefinition);
    return { id, diagram: diagram2 };
  };
  const plugin = {
    id,
    detector,
    loader
  };
  const mindmap = plugin;
  let hasLoadedDiagrams = false;
  const addDiagrams = () => {
    if (hasLoadedDiagrams) {
      return;
    }
    hasLoadedDiagrams = true;
    registerDiagram("error", errorDiagram, (text2) => {
      return text2.toLowerCase().trim() === "error";
    });
    registerDiagram(
      "---",
      // --- diagram type may appear if YAML front-matter is not parsed correctly
      {
        db: {
          clear: () => {
          }
        },
        styles: {},
        // should never be used
        renderer: {},
        // should never be used
        parser: {
          parser: { yy: {} },
          parse: () => {
            throw new Error(
              "Diagrams beginning with --- are not valid. If you were trying to use a YAML front-matter, please ensure that you've correctly opened and closed the YAML front-matter with un-indented `---` blocks"
            );
          }
        },
        init: () => null
        // no op
      },
      (text2) => {
        return text2.toLowerCase().trimStart().startsWith("---");
      }
    );
    registerLazyLoadedDiagrams(
      c4,
      classDiagramV2$1,
      classDiagram$1,
      er,
      gantt,
      info$1,
      pie,
      requirement,
      sequence,
      flowchartElk,
      flowchartV2,
      flowchart,
      mindmap,
      timeline,
      git,
      stateV2,
      state,
      journey,
      quadrantChart
    );
  };
  const cleanupComments = (text2) => {
    return text2.trimStart().replace(/^\s*%%(?!{)[^\n]+\n?/gm, "");
  };
  class Diagram {
    constructor(text2) {
      var _a, _b;
      this.text = text2;
      this.type = "graph";
      this.text += "\n";
      const cnf = getConfig$1();
      try {
        this.type = detectType(text2, cnf);
      } catch (e) {
        this.type = "error";
        this.detectError = e;
      }
      const diagram2 = getDiagram(this.type);
      log$1.debug("Type " + this.type);
      this.db = diagram2.db;
      (_b = (_a = this.db).clear) == null ? void 0 : _b.call(_a);
      this.renderer = diagram2.renderer;
      this.parser = diagram2.parser;
      const originalParse = this.parser.parse.bind(this.parser);
      this.parser.parse = (text22) => originalParse(cleanupComments(extractFrontMatter(text22, this.db)));
      this.parser.parser.yy = this.db;
      if (diagram2.init) {
        diagram2.init(cnf);
        log$1.info("Initialized diagram " + this.type, cnf);
      }
      this.parse();
    }
    parse() {
      var _a, _b;
      if (this.detectError) {
        throw this.detectError;
      }
      (_b = (_a = this.db).clear) == null ? void 0 : _b.call(_a);
      this.parser.parse(this.text);
    }
    async render(id2, version2) {
      await this.renderer.draw(this.text, id2, version2, this);
    }
    getParser() {
      return this.parser;
    }
    getType() {
      return this.type;
    }
  }
  const getDiagramFromText = async (text2) => {
    const type2 = detectType(text2, getConfig$1());
    try {
      getDiagram(type2);
    } catch (error) {
      const loader2 = getDiagramLoader(type2);
      if (!loader2) {
        throw new UnknownDiagramError(`Diagram ${type2} not found.`);
      }
      const { id: id2, diagram: diagram2 } = await loader2();
      registerDiagram(id2, diagram2);
    }
    return new Diagram(text2);
  };
  let interactionFunctions = [];
  const addFunction = (func) => {
    interactionFunctions.push(func);
  };
  const attachFunctions = () => {
    interactionFunctions.forEach((f2) => {
      f2();
    });
    interactionFunctions = [];
  };
  var objectProto$d = Object.prototype;
  function isPrototype(value) {
    var Ctor = value && value.constructor, proto = typeof Ctor == "function" && Ctor.prototype || objectProto$d;
    return value === proto;
  }
  function overArg(func, transform) {
    return function(arg) {
      return func(transform(arg));
    };
  }
  var nativeKeys = overArg(Object.keys, Object);
  const nativeKeys$1 = nativeKeys;
  var objectProto$c = Object.prototype;
  var hasOwnProperty$c = objectProto$c.hasOwnProperty;
  function baseKeys(object2) {
    if (!isPrototype(object2)) {
      return nativeKeys$1(object2);
    }
    var result = [];
    for (var key in Object(object2)) {
      if (hasOwnProperty$c.call(object2, key) && key != "constructor") {
        result.push(key);
      }
    }
    return result;
  }
  var DataView$1 = getNative(root$1, "DataView");
  const DataView$2 = DataView$1;
  var Promise$1 = getNative(root$1, "Promise");
  const Promise$2 = Promise$1;
  var Set$1 = getNative(root$1, "Set");
  const Set$2 = Set$1;
  var WeakMap = getNative(root$1, "WeakMap");
  const WeakMap$1 = WeakMap;
  var mapTag$6 = "[object Map]", objectTag$4 = "[object Object]", promiseTag = "[object Promise]", setTag$6 = "[object Set]", weakMapTag$2 = "[object WeakMap]";
  var dataViewTag$4 = "[object DataView]";
  var dataViewCtorString = toSource(DataView$2), mapCtorString = toSource(Map$2), promiseCtorString = toSource(Promise$2), setCtorString = toSource(Set$2), weakMapCtorString = toSource(WeakMap$1);
  var getTag = baseGetTag;
  if (DataView$2 && getTag(new DataView$2(new ArrayBuffer(1))) != dataViewTag$4 || Map$2 && getTag(new Map$2()) != mapTag$6 || Promise$2 && getTag(Promise$2.resolve()) != promiseTag || Set$2 && getTag(new Set$2()) != setTag$6 || WeakMap$1 && getTag(new WeakMap$1()) != weakMapTag$2) {
    getTag = function(value) {
      var result = baseGetTag(value), Ctor = result == objectTag$4 ? value.constructor : void 0, ctorString = Ctor ? toSource(Ctor) : "";
      if (ctorString) {
        switch (ctorString) {
          case dataViewCtorString:
            return dataViewTag$4;
          case mapCtorString:
            return mapTag$6;
          case promiseCtorString:
            return promiseTag;
          case setCtorString:
            return setTag$6;
          case weakMapCtorString:
            return weakMapTag$2;
        }
      }
      return result;
    };
  }
  const getTag$1 = getTag;
  function isObjectLike(value) {
    return value != null && typeof value == "object";
  }
  var argsTag$3 = "[object Arguments]";
  function baseIsArguments(value) {
    return isObjectLike(value) && baseGetTag(value) == argsTag$3;
  }
  var objectProto$b = Object.prototype;
  var hasOwnProperty$b = objectProto$b.hasOwnProperty;
  var propertyIsEnumerable$1 = objectProto$b.propertyIsEnumerable;
  var isArguments = baseIsArguments(function() {
    return arguments;
  }()) ? baseIsArguments : function(value) {
    return isObjectLike(value) && hasOwnProperty$b.call(value, "callee") && !propertyIsEnumerable$1.call(value, "callee");
  };
  const isArguments$1 = isArguments;
  var isArray = Array.isArray;
  const isArray$1 = isArray;
  var MAX_SAFE_INTEGER$1 = 9007199254740991;
  function isLength(value) {
    return typeof value == "number" && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER$1;
  }
  function isArrayLike(value) {
    return value != null && isLength(value.length) && !isFunction(value);
  }
  function stubFalse() {
    return false;
  }
  var freeExports$2 = typeof exports == "object" && exports && !exports.nodeType && exports;
  var freeModule$2 = freeExports$2 && typeof module == "object" && module && !module.nodeType && module;
  var moduleExports$2 = freeModule$2 && freeModule$2.exports === freeExports$2;
  var Buffer$1 = moduleExports$2 ? root$1.Buffer : void 0;
  var nativeIsBuffer = Buffer$1 ? Buffer$1.isBuffer : void 0;
  var isBuffer = nativeIsBuffer || stubFalse;
  const isBuffer$1 = isBuffer;
  var argsTag$2 = "[object Arguments]", arrayTag$2 = "[object Array]", boolTag$3 = "[object Boolean]", dateTag$3 = "[object Date]", errorTag$2 = "[object Error]", funcTag$1 = "[object Function]", mapTag$5 = "[object Map]", numberTag$3 = "[object Number]", objectTag$3 = "[object Object]", regexpTag$3 = "[object RegExp]", setTag$5 = "[object Set]", stringTag$3 = "[object String]", weakMapTag$1 = "[object WeakMap]";
  var arrayBufferTag$3 = "[object ArrayBuffer]", dataViewTag$3 = "[object DataView]", float32Tag$2 = "[object Float32Array]", float64Tag$2 = "[object Float64Array]", int8Tag$2 = "[object Int8Array]", int16Tag$2 = "[object Int16Array]", int32Tag$2 = "[object Int32Array]", uint8Tag$2 = "[object Uint8Array]", uint8ClampedTag$2 = "[object Uint8ClampedArray]", uint16Tag$2 = "[object Uint16Array]", uint32Tag$2 = "[object Uint32Array]";
  var typedArrayTags = {};
  typedArrayTags[float32Tag$2] = typedArrayTags[float64Tag$2] = typedArrayTags[int8Tag$2] = typedArrayTags[int16Tag$2] = typedArrayTags[int32Tag$2] = typedArrayTags[uint8Tag$2] = typedArrayTags[uint8ClampedTag$2] = typedArrayTags[uint16Tag$2] = typedArrayTags[uint32Tag$2] = true;
  typedArrayTags[argsTag$2] = typedArrayTags[arrayTag$2] = typedArrayTags[arrayBufferTag$3] = typedArrayTags[boolTag$3] = typedArrayTags[dataViewTag$3] = typedArrayTags[dateTag$3] = typedArrayTags[errorTag$2] = typedArrayTags[funcTag$1] = typedArrayTags[mapTag$5] = typedArrayTags[numberTag$3] = typedArrayTags[objectTag$3] = typedArrayTags[regexpTag$3] = typedArrayTags[setTag$5] = typedArrayTags[stringTag$3] = typedArrayTags[weakMapTag$1] = false;
  function baseIsTypedArray(value) {
    return isObjectLike(value) && isLength(value.length) && !!typedArrayTags[baseGetTag(value)];
  }
  function baseUnary(func) {
    return function(value) {
      return func(value);
    };
  }
  var freeExports$1 = typeof exports == "object" && exports && !exports.nodeType && exports;
  var freeModule$1 = freeExports$1 && typeof module == "object" && module && !module.nodeType && module;
  var moduleExports$1 = freeModule$1 && freeModule$1.exports === freeExports$1;
  var freeProcess = moduleExports$1 && freeGlobal$1.process;
  var nodeUtil = function() {
    try {
      var types = freeModule$1 && freeModule$1.require && freeModule$1.require("util").types;
      if (types) {
        return types;
      }
      return freeProcess && freeProcess.binding && freeProcess.binding("util");
    } catch (e) {
    }
  }();
  const nodeUtil$1 = nodeUtil;
  var nodeIsTypedArray = nodeUtil$1 && nodeUtil$1.isTypedArray;
  var isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;
  const isTypedArray$1 = isTypedArray;
  var mapTag$4 = "[object Map]", setTag$4 = "[object Set]";
  var objectProto$a = Object.prototype;
  var hasOwnProperty$a = objectProto$a.hasOwnProperty;
  function isEmpty(value) {
    if (value == null) {
      return true;
    }
    if (isArrayLike(value) && (isArray$1(value) || typeof value == "string" || typeof value.splice == "function" || isBuffer$1(value) || isTypedArray$1(value) || isArguments$1(value))) {
      return !value.length;
    }
    var tag = getTag$1(value);
    if (tag == mapTag$4 || tag == setTag$4) {
      return !value.size;
    }
    if (isPrototype(value)) {
      return !baseKeys(value).length;
    }
    for (var key in value) {
      if (hasOwnProperty$a.call(value, key)) {
        return false;
      }
    }
    return true;
  }
  const SVG_ROLE = "graphics-document document";
  function setA11yDiagramInfo(svg2, diagramType) {
    svg2.attr("role", SVG_ROLE);
    if (!isEmpty(diagramType)) {
      svg2.attr("aria-roledescription", diagramType);
    }
  }
  function addSVGa11yTitleDescription(svg2, a11yTitle, a11yDesc, baseId) {
    if (svg2.insert === void 0) {
      return;
    }
    if (a11yTitle || a11yDesc) {
      if (a11yDesc) {
        const descId = "chart-desc-" + baseId;
        svg2.attr("aria-describedby", descId);
        svg2.insert("desc", ":first-child").attr("id", descId).text(a11yDesc);
      }
      if (a11yTitle) {
        const titleId = "chart-title-" + baseId;
        svg2.attr("aria-labelledby", titleId);
        svg2.insert("title", ":first-child").attr("id", titleId).text(a11yTitle);
      }
    } else {
      return;
    }
  }
  const CLASSDEF_DIAGRAMS = [
    "graph",
    "flowchart",
    "flowchart-v2",
    "flowchart-elk",
    "stateDiagram",
    "stateDiagram-v2"
  ];
  const MAX_TEXTLENGTH = 5e4;
  const MAX_TEXTLENGTH_EXCEEDED_MSG = "graph TB;a[Maximum text size in diagram exceeded];style a fill:#faa";
  const SECURITY_LVL_SANDBOX = "sandbox";
  const SECURITY_LVL_LOOSE = "loose";
  const XMLNS_SVG_STD = "http://www.w3.org/2000/svg";
  const XMLNS_XLINK_STD = "http://www.w3.org/1999/xlink";
  const XMLNS_XHTML_STD = "http://www.w3.org/1999/xhtml";
  const IFRAME_WIDTH = "100%";
  const IFRAME_HEIGHT = "100%";
  const IFRAME_STYLES = "border:0;margin:0;";
  const IFRAME_BODY_STYLE = "margin:0";
  const IFRAME_SANDBOX_OPTS = "allow-top-navigation-by-user-activation allow-popups";
  const IFRAME_NOT_SUPPORTED_MSG = 'The "iframe" tag is not supported by your browser.';
  const DOMPURIFY_TAGS = ["foreignobject"];
  const DOMPURIFY_ATTR = ["dominant-baseline"];
  async function parse$3(text2, parseOptions) {
    addDiagrams();
    try {
      const diagram2 = await getDiagramFromText(text2);
      diagram2.parse();
    } catch (error) {
      if (parseOptions == null ? void 0 : parseOptions.suppressErrors) {
        return false;
      }
      throw error;
    }
    return true;
  }
  const encodeEntities = function(text2) {
    let txt = text2;
    txt = txt.replace(/style.*:\S*#.*;/g, function(s) {
      return s.substring(0, s.length - 1);
    });
    txt = txt.replace(/classDef.*:\S*#.*;/g, function(s) {
      return s.substring(0, s.length - 1);
    });
    txt = txt.replace(/#\w+;/g, function(s) {
      const innerTxt = s.substring(1, s.length - 1);
      const isInt = /^\+?\d+$/.test(innerTxt);
      if (isInt) {
        return "ﬂ°°" + innerTxt + "¶ß";
      } else {
        return "ﬂ°" + innerTxt + "¶ß";
      }
    });
    return txt;
  };
  const decodeEntities = function(text2) {
    return text2.replace(/ﬂ°°/g, "&#").replace(/ﬂ°/g, "&").replace(/¶ß/g, ";");
  };
  const cssImportantStyles = (cssClass, element2, cssClasses = []) => {
    return `
.${cssClass} ${element2} { ${cssClasses.join(" !important; ")} !important; }`;
  };
  const createCssStyles = (config2, graphType, classDefs = {}) => {
    var _a;
    let cssStyles = "";
    if (config2.themeCSS !== void 0) {
      cssStyles += `
${config2.themeCSS}`;
    }
    if (config2.fontFamily !== void 0) {
      cssStyles += `
:root { --mermaid-font-family: ${config2.fontFamily}}`;
    }
    if (config2.altFontFamily !== void 0) {
      cssStyles += `
:root { --mermaid-alt-font-family: ${config2.altFontFamily}}`;
    }
    if (!isEmpty(classDefs) && CLASSDEF_DIAGRAMS.includes(graphType)) {
      const htmlLabels = config2.htmlLabels || ((_a = config2.flowchart) == null ? void 0 : _a.htmlLabels);
      const cssHtmlElements = ["> *", "span"];
      const cssShapeElements = ["rect", "polygon", "ellipse", "circle", "path"];
      const cssElements = htmlLabels ? cssHtmlElements : cssShapeElements;
      for (const classId in classDefs) {
        const styleClassDef = classDefs[classId];
        if (!isEmpty(styleClassDef.styles)) {
          cssElements.forEach((cssElement) => {
            cssStyles += cssImportantStyles(styleClassDef.id, cssElement, styleClassDef.styles);
          });
        }
        if (!isEmpty(styleClassDef.textStyles)) {
          cssStyles += cssImportantStyles(styleClassDef.id, "tspan", styleClassDef.textStyles);
        }
      }
    }
    return cssStyles;
  };
  const createUserStyles = (config2, graphType, classDefs, svgId) => {
    const userCSSstyles = createCssStyles(config2, graphType, classDefs);
    const allStyles = getStyles$h(graphType, userCSSstyles, config2.themeVariables);
    return serialize(compile(`${svgId}{${allStyles}}`), stringify);
  };
  const cleanUpSvgCode = (svgCode = "", inSandboxMode, useArrowMarkerUrls) => {
    let cleanedUpSvg = svgCode;
    if (!useArrowMarkerUrls && !inSandboxMode) {
      cleanedUpSvg = cleanedUpSvg.replace(
        /marker-end="url\([\d+./:=?A-Za-z-]*?#/g,
        'marker-end="url(#'
      );
    }
    cleanedUpSvg = decodeEntities(cleanedUpSvg);
    cleanedUpSvg = cleanedUpSvg.replace(/<br>/g, "<br/>");
    return cleanedUpSvg;
  };
  const putIntoIFrame = (svgCode = "", svgElement) => {
    const height2 = svgElement ? svgElement.viewBox.baseVal.height + "px" : IFRAME_HEIGHT;
    const base64encodedSrc = btoa('<body style="' + IFRAME_BODY_STYLE + '">' + svgCode + "</body>");
    return `<iframe style="width:${IFRAME_WIDTH};height:${height2};${IFRAME_STYLES}" src="data:text/html;base64,${base64encodedSrc}" sandbox="${IFRAME_SANDBOX_OPTS}">
  ${IFRAME_NOT_SUPPORTED_MSG}
</iframe>`;
  };
  const appendDivSvgG = (parentRoot, id2, enclosingDivId, divStyle, svgXlink) => {
    const enclosingDiv = parentRoot.append("div");
    enclosingDiv.attr("id", enclosingDivId);
    if (divStyle) {
      enclosingDiv.attr("style", divStyle);
    }
    const svgNode2 = enclosingDiv.append("svg").attr("id", id2).attr("width", "100%").attr("xmlns", XMLNS_SVG_STD);
    if (svgXlink) {
      svgNode2.attr("xmlns:xlink", svgXlink);
    }
    svgNode2.append("g");
    return parentRoot;
  };
  function sandboxedIframe(parentNode, iFrameId) {
    return parentNode.append("iframe").attr("id", iFrameId).attr("style", "width: 100%; height: 100%;").attr("sandbox", "");
  }
  const removeExistingElements = (doc, id2, divId, iFrameId) => {
    var _a, _b, _c;
    (_a = doc.getElementById(id2)) == null ? void 0 : _a.remove();
    (_b = doc.getElementById(divId)) == null ? void 0 : _b.remove();
    (_c = doc.getElementById(iFrameId)) == null ? void 0 : _c.remove();
  };
  const render$3 = async function(id2, text2, svgContainingElement) {
    var _a, _b, _c, _d;
    addDiagrams();
    reset();
    const graphInit = utils.detectInit(text2);
    if (graphInit) {
      directiveSanitizer(graphInit);
      addDirective(graphInit);
    }
    const config2 = getConfig$1();
    log$1.debug(config2);
    if (text2.length > ((config2 == null ? void 0 : config2.maxTextSize) ?? MAX_TEXTLENGTH)) {
      text2 = MAX_TEXTLENGTH_EXCEEDED_MSG;
    }
    text2 = text2.replace(/\r\n?/g, "\n");
    text2 = text2.replace(
      /<(\w+)([^>]*)>/g,
      (match, tag, attributes) => "<" + tag + attributes.replace(/="([^"]*)"/g, "='$1'") + ">"
    );
    const idSelector = "#" + id2;
    const iFrameID = "i" + id2;
    const iFrameID_selector = "#" + iFrameID;
    const enclosingDivID = "d" + id2;
    const enclosingDivID_selector = "#" + enclosingDivID;
    let root2 = select("body");
    const isSandboxed = config2.securityLevel === SECURITY_LVL_SANDBOX;
    const isLooseSecurityLevel = config2.securityLevel === SECURITY_LVL_LOOSE;
    const fontFamily = config2.fontFamily;
    if (svgContainingElement !== void 0) {
      if (svgContainingElement) {
        svgContainingElement.innerHTML = "";
      }
      if (isSandboxed) {
        const iframe = sandboxedIframe(select(svgContainingElement), iFrameID);
        root2 = select(iframe.nodes()[0].contentDocument.body);
        root2.node().style.margin = 0;
      } else {
        root2 = select(svgContainingElement);
      }
      appendDivSvgG(root2, id2, enclosingDivID, `font-family: ${fontFamily}`, XMLNS_XLINK_STD);
    } else {
      removeExistingElements(document, id2, enclosingDivID, iFrameID);
      if (isSandboxed) {
        const iframe = sandboxedIframe(select("body"), iFrameID);
        root2 = select(iframe.nodes()[0].contentDocument.body);
        root2.node().style.margin = 0;
      } else {
        root2 = select("body");
      }
      appendDivSvgG(root2, id2, enclosingDivID);
    }
    text2 = encodeEntities(text2);
    let diag;
    let parseEncounteredException;
    try {
      diag = await getDiagramFromText(text2);
    } catch (error) {
      diag = new Diagram("error");
      parseEncounteredException = error;
    }
    const element2 = root2.select(enclosingDivID_selector).node();
    const graphType = diag.type;
    const svg2 = element2.firstChild;
    const firstChild = svg2.firstChild;
    const diagramClassDefs = CLASSDEF_DIAGRAMS.includes(graphType) ? diag.renderer.getClasses(text2, diag) : {};
    const rules = createUserStyles(
      config2,
      graphType,
      // @ts-ignore convert renderer to TS.
      diagramClassDefs,
      idSelector
    );
    const style1 = document.createElement("style");
    style1.innerHTML = rules;
    svg2.insertBefore(style1, firstChild);
    try {
      await diag.renderer.draw(text2, id2, version$1, diag);
    } catch (e) {
      errorRenderer.draw(text2, id2, version$1);
      throw e;
    }
    const svgNode2 = root2.select(`${enclosingDivID_selector} svg`);
    const a11yTitle = (_b = (_a = diag.db).getAccTitle) == null ? void 0 : _b.call(_a);
    const a11yDescr = (_d = (_c = diag.db).getAccDescription) == null ? void 0 : _d.call(_c);
    addA11yInfo(graphType, svgNode2, a11yTitle, a11yDescr);
    root2.select(`[id="${id2}"]`).selectAll("foreignobject > *").attr("xmlns", XMLNS_XHTML_STD);
    let svgCode = root2.select(enclosingDivID_selector).node().innerHTML;
    log$1.debug("config.arrowMarkerAbsolute", config2.arrowMarkerAbsolute);
    svgCode = cleanUpSvgCode(svgCode, isSandboxed, evaluate(config2.arrowMarkerAbsolute));
    if (isSandboxed) {
      const svgEl = root2.select(enclosingDivID_selector + " svg").node();
      svgCode = putIntoIFrame(svgCode, svgEl);
    } else if (!isLooseSecurityLevel) {
      svgCode = purify.sanitize(svgCode, {
        ADD_TAGS: DOMPURIFY_TAGS,
        ADD_ATTR: DOMPURIFY_ATTR
      });
    }
    attachFunctions();
    if (parseEncounteredException) {
      throw parseEncounteredException;
    }
    const tmpElementSelector = isSandboxed ? iFrameID_selector : enclosingDivID_selector;
    const node2 = select(tmpElementSelector).node();
    if (node2 && "remove" in node2) {
      node2.remove();
    }
    return {
      svg: svgCode,
      bindFunctions: diag.db.bindFunctions
    };
  };
  function initialize$1(options2 = {}) {
    var _a;
    if ((options2 == null ? void 0 : options2.fontFamily) && !((_a = options2.themeVariables) == null ? void 0 : _a.fontFamily)) {
      if (!options2.themeVariables) {
        options2.themeVariables = {};
      }
      options2.themeVariables.fontFamily = options2.fontFamily;
    }
    saveConfigFromInitialize(options2);
    if ((options2 == null ? void 0 : options2.theme) && options2.theme in theme) {
      options2.themeVariables = theme[options2.theme].getThemeVariables(
        options2.themeVariables
      );
    } else if (options2) {
      options2.themeVariables = theme.default.getThemeVariables(options2.themeVariables);
    }
    const config2 = typeof options2 === "object" ? setSiteConfig(options2) : getSiteConfig();
    setLogLevel$1(config2.logLevel);
    addDiagrams();
  }
  function addA11yInfo(graphType, svgNode2, a11yTitle, a11yDescr) {
    setA11yDiagramInfo(svgNode2, graphType);
    addSVGa11yTitleDescription(svgNode2, a11yTitle, a11yDescr, svgNode2.attr("id"));
  }
  const mermaidAPI = Object.freeze({
    render: render$3,
    parse: parse$3,
    parseDirective: parseDirective$e,
    getDiagramFromText,
    initialize: initialize$1,
    getConfig: getConfig$1,
    setConfig,
    getSiteConfig,
    updateSiteConfig,
    reset: () => {
      reset();
    },
    globalReset: () => {
      reset(defaultConfig);
    },
    defaultConfig
  });
  setLogLevel$1(getConfig$1().logLevel);
  reset(getConfig$1());
  const handleError = (error, errors, parseError2) => {
    log$1.warn(error);
    if (isDetailedError(error)) {
      if (parseError2) {
        parseError2(error.str, error.hash);
      }
      errors.push({ ...error, message: error.str, error });
    } else {
      if (parseError2) {
        parseError2(error);
      }
      if (error instanceof Error) {
        errors.push({
          str: error.message,
          message: error.message,
          hash: error.name,
          error
        });
      }
    }
  };
  const run$3 = async function(options2 = {
    querySelector: ".mermaid"
  }) {
    try {
      await runThrowsErrors(options2);
    } catch (e) {
      if (isDetailedError(e)) {
        log$1.error(e.str);
      }
      if (mermaid.parseError) {
        mermaid.parseError(e);
      }
      if (!options2.suppressErrors) {
        log$1.error("Use the suppressErrors option to suppress these errors");
        throw e;
      }
    }
  };
  const runThrowsErrors = async function({ postRenderCallback, querySelector, nodes: nodes2 } = {
    querySelector: ".mermaid"
  }) {
    const conf2 = mermaidAPI.getConfig();
    log$1.debug(`${!postRenderCallback ? "No " : ""}Callback function found`);
    let nodesToProcess;
    if (nodes2) {
      nodesToProcess = nodes2;
    } else if (querySelector) {
      nodesToProcess = document.querySelectorAll(querySelector);
    } else {
      throw new Error("Nodes and querySelector are both undefined");
    }
    log$1.debug(`Found ${nodesToProcess.length} diagrams`);
    if ((conf2 == null ? void 0 : conf2.startOnLoad) !== void 0) {
      log$1.debug("Start On Load: " + (conf2 == null ? void 0 : conf2.startOnLoad));
      mermaidAPI.updateSiteConfig({ startOnLoad: conf2 == null ? void 0 : conf2.startOnLoad });
    }
    const idGenerator = new utils.initIdGenerator(conf2.deterministicIds, conf2.deterministicIDSeed);
    let txt;
    const errors = [];
    for (const element2 of Array.from(nodesToProcess)) {
      log$1.info("Rendering diagram: " + element2.id);
      /*! Check if previously processed */
      if (element2.getAttribute("data-processed")) {
        continue;
      }
      element2.setAttribute("data-processed", "true");
      const id2 = `mermaid-${idGenerator.next()}`;
      txt = element2.innerHTML;
      txt = dedent(utils.entityDecode(txt)).trim().replace(/<br\s*\/?>/gi, "<br/>");
      const init2 = utils.detectInit(txt);
      if (init2) {
        log$1.debug("Detected early reinit: ", init2);
      }
      try {
        const { svg: svg2, bindFunctions: bindFunctions2 } = await render$2(id2, txt, element2);
        element2.innerHTML = svg2;
        if (postRenderCallback) {
          await postRenderCallback(id2);
        }
        if (bindFunctions2) {
          bindFunctions2(element2);
        }
      } catch (error) {
        handleError(error, errors, mermaid.parseError);
      }
    }
    if (errors.length > 0) {
      throw errors[0];
    }
  };
  const initialize = function(config2) {
    mermaidAPI.initialize(config2);
  };
  const init = async function(config2, nodes2, callback) {
    log$1.warn("mermaid.init is deprecated. Please use run instead.");
    if (config2) {
      initialize(config2);
    }
    const runOptions = { postRenderCallback: callback, querySelector: ".mermaid" };
    if (typeof nodes2 === "string") {
      runOptions.querySelector = nodes2;
    } else if (nodes2) {
      if (nodes2 instanceof HTMLElement) {
        runOptions.nodes = [nodes2];
      } else {
        runOptions.nodes = nodes2;
      }
    }
    await run$3(runOptions);
  };
  const registerExternalDiagrams = async (diagrams2, {
    lazyLoad = true
  } = {}) => {
    registerLazyLoadedDiagrams(...diagrams2);
    if (lazyLoad === false) {
      await loadRegisteredDiagrams();
    }
  };
  const contentLoaded = function() {
    if (mermaid.startOnLoad) {
      const { startOnLoad } = mermaidAPI.getConfig();
      if (startOnLoad) {
        mermaid.run().catch((err) => log$1.error("Mermaid failed to initialize", err));
      }
    }
  };
  if (typeof document !== "undefined") {
    /*!
     * Wait for document loaded before starting the execution
     */
    window.addEventListener("load", contentLoaded, false);
  }
  const setParseErrorHandler = function(parseErrorHandler) {
    mermaid.parseError = parseErrorHandler;
  };
  const executionQueue = [];
  let executionQueueRunning = false;
  const executeQueue = async () => {
    if (executionQueueRunning) {
      return;
    }
    executionQueueRunning = true;
    while (executionQueue.length > 0) {
      const f2 = executionQueue.shift();
      if (f2) {
        try {
          await f2();
        } catch (e) {
          log$1.error("Error executing queue", e);
        }
      }
    }
    executionQueueRunning = false;
  };
  const parse$2 = async (text2, parseOptions) => {
    return new Promise((resolve, reject) => {
      const performCall = () => new Promise((res, rej) => {
        mermaidAPI.parse(text2, parseOptions).then(
          (r) => {
            res(r);
            resolve(r);
          },
          (e) => {
            var _a;
            log$1.error("Error parsing", e);
            (_a = mermaid.parseError) == null ? void 0 : _a.call(mermaid, e);
            rej(e);
            reject(e);
          }
        );
      });
      executionQueue.push(performCall);
      executeQueue().catch(reject);
    });
  };
  const render$2 = (id2, text2, container) => {
    return new Promise((resolve, reject) => {
      const performCall = () => new Promise((res, rej) => {
        mermaidAPI.render(id2, text2, container).then(
          (r) => {
            res(r);
            resolve(r);
          },
          (e) => {
            var _a;
            log$1.error("Error parsing", e);
            (_a = mermaid.parseError) == null ? void 0 : _a.call(mermaid, e);
            rej(e);
            reject(e);
          }
        );
      });
      executionQueue.push(performCall);
      executeQueue().catch(reject);
    });
  };
  const mermaid = {
    startOnLoad: true,
    mermaidAPI,
    parse: parse$2,
    render: render$2,
    init,
    run: run$3,
    registerExternalDiagrams,
    initialize,
    parseError: void 0,
    contentLoaded,
    setParseErrorHandler,
    detectType
  };
  var parser$o = function() {
    var o = function(k, v, o2, l) {
      for (o2 = o2 || {}, l = k.length; l--; o2[k[l]] = v)
        ;
      return o2;
    }, $V0 = [1, 6], $V1 = [1, 7], $V2 = [1, 8], $V3 = [1, 9], $V4 = [1, 16], $V5 = [1, 11], $V6 = [1, 12], $V7 = [1, 13], $V8 = [1, 14], $V9 = [1, 15], $Va = [1, 27], $Vb = [1, 33], $Vc = [1, 34], $Vd = [1, 35], $Ve = [1, 36], $Vf = [1, 37], $Vg = [1, 72], $Vh = [1, 73], $Vi = [1, 74], $Vj = [1, 75], $Vk = [1, 76], $Vl = [1, 77], $Vm = [1, 78], $Vn = [1, 38], $Vo = [1, 39], $Vp = [1, 40], $Vq = [1, 41], $Vr = [1, 42], $Vs = [1, 43], $Vt = [1, 44], $Vu = [1, 45], $Vv = [1, 46], $Vw = [1, 47], $Vx = [1, 48], $Vy = [1, 49], $Vz = [1, 50], $VA = [1, 51], $VB = [1, 52], $VC = [1, 53], $VD = [1, 54], $VE = [1, 55], $VF = [1, 56], $VG = [1, 57], $VH = [1, 59], $VI = [1, 60], $VJ = [1, 61], $VK = [1, 62], $VL = [1, 63], $VM = [1, 64], $VN = [1, 65], $VO = [1, 66], $VP = [1, 67], $VQ = [1, 68], $VR = [1, 69], $VS = [24, 52], $VT = [24, 44, 46, 47, 48, 49, 50, 51, 52, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84], $VU = [15, 24, 44, 46, 47, 48, 49, 50, 51, 52, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84], $VV = [1, 94], $VW = [1, 95], $VX = [1, 96], $VY = [1, 97], $VZ = [15, 24, 52], $V_ = [7, 8, 9, 10, 18, 22, 25, 26, 27, 28], $V$ = [15, 24, 43, 52], $V01 = [15, 24, 43, 52, 86, 87, 89, 90], $V11 = [15, 43], $V21 = [44, 46, 47, 48, 49, 50, 51, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84];
    var parser2 = {
      trace: function trace() {
      },
      yy: {},
      symbols_: { "error": 2, "start": 3, "mermaidDoc": 4, "direction": 5, "directive": 6, "direction_tb": 7, "direction_bt": 8, "direction_rl": 9, "direction_lr": 10, "graphConfig": 11, "openDirective": 12, "typeDirective": 13, "closeDirective": 14, "NEWLINE": 15, ":": 16, "argDirective": 17, "open_directive": 18, "type_directive": 19, "arg_directive": 20, "close_directive": 21, "C4_CONTEXT": 22, "statements": 23, "EOF": 24, "C4_CONTAINER": 25, "C4_COMPONENT": 26, "C4_DYNAMIC": 27, "C4_DEPLOYMENT": 28, "otherStatements": 29, "diagramStatements": 30, "otherStatement": 31, "title": 32, "accDescription": 33, "acc_title": 34, "acc_title_value": 35, "acc_descr": 36, "acc_descr_value": 37, "acc_descr_multiline_value": 38, "boundaryStatement": 39, "boundaryStartStatement": 40, "boundaryStopStatement": 41, "boundaryStart": 42, "LBRACE": 43, "ENTERPRISE_BOUNDARY": 44, "attributes": 45, "SYSTEM_BOUNDARY": 46, "BOUNDARY": 47, "CONTAINER_BOUNDARY": 48, "NODE": 49, "NODE_L": 50, "NODE_R": 51, "RBRACE": 52, "diagramStatement": 53, "PERSON": 54, "PERSON_EXT": 55, "SYSTEM": 56, "SYSTEM_DB": 57, "SYSTEM_QUEUE": 58, "SYSTEM_EXT": 59, "SYSTEM_EXT_DB": 60, "SYSTEM_EXT_QUEUE": 61, "CONTAINER": 62, "CONTAINER_DB": 63, "CONTAINER_QUEUE": 64, "CONTAINER_EXT": 65, "CONTAINER_EXT_DB": 66, "CONTAINER_EXT_QUEUE": 67, "COMPONENT": 68, "COMPONENT_DB": 69, "COMPONENT_QUEUE": 70, "COMPONENT_EXT": 71, "COMPONENT_EXT_DB": 72, "COMPONENT_EXT_QUEUE": 73, "REL": 74, "BIREL": 75, "REL_U": 76, "REL_D": 77, "REL_L": 78, "REL_R": 79, "REL_B": 80, "REL_INDEX": 81, "UPDATE_EL_STYLE": 82, "UPDATE_REL_STYLE": 83, "UPDATE_LAYOUT_CONFIG": 84, "attribute": 85, "STR": 86, "STR_KEY": 87, "STR_VALUE": 88, "ATTRIBUTE": 89, "ATTRIBUTE_EMPTY": 90, "$accept": 0, "$end": 1 },
      terminals_: { 2: "error", 7: "direction_tb", 8: "direction_bt", 9: "direction_rl", 10: "direction_lr", 15: "NEWLINE", 16: ":", 18: "open_directive", 19: "type_directive", 20: "arg_directive", 21: "close_directive", 22: "C4_CONTEXT", 24: "EOF", 25: "C4_CONTAINER", 26: "C4_COMPONENT", 27: "C4_DYNAMIC", 28: "C4_DEPLOYMENT", 32: "title", 33: "accDescription", 34: "acc_title", 35: "acc_title_value", 36: "acc_descr", 37: "acc_descr_value", 38: "acc_descr_multiline_value", 43: "LBRACE", 44: "ENTERPRISE_BOUNDARY", 46: "SYSTEM_BOUNDARY", 47: "BOUNDARY", 48: "CONTAINER_BOUNDARY", 49: "NODE", 50: "NODE_L", 51: "NODE_R", 52: "RBRACE", 54: "PERSON", 55: "PERSON_EXT", 56: "SYSTEM", 57: "SYSTEM_DB", 58: "SYSTEM_QUEUE", 59: "SYSTEM_EXT", 60: "SYSTEM_EXT_DB", 61: "SYSTEM_EXT_QUEUE", 62: "CONTAINER", 63: "CONTAINER_DB", 64: "CONTAINER_QUEUE", 65: "CONTAINER_EXT", 66: "CONTAINER_EXT_DB", 67: "CONTAINER_EXT_QUEUE", 68: "COMPONENT", 69: "COMPONENT_DB", 70: "COMPONENT_QUEUE", 71: "COMPONENT_EXT", 72: "COMPONENT_EXT_DB", 73: "COMPONENT_EXT_QUEUE", 74: "REL", 75: "BIREL", 76: "REL_U", 77: "REL_D", 78: "REL_L", 79: "REL_R", 80: "REL_B", 81: "REL_INDEX", 82: "UPDATE_EL_STYLE", 83: "UPDATE_REL_STYLE", 84: "UPDATE_LAYOUT_CONFIG", 86: "STR", 87: "STR_KEY", 88: "STR_VALUE", 89: "ATTRIBUTE", 90: "ATTRIBUTE_EMPTY" },
      productions_: [0, [3, 1], [3, 1], [3, 2], [5, 1], [5, 1], [5, 1], [5, 1], [4, 1], [6, 4], [6, 6], [12, 1], [13, 1], [17, 1], [14, 1], [11, 4], [11, 4], [11, 4], [11, 4], [11, 4], [23, 1], [23, 1], [23, 2], [29, 1], [29, 2], [29, 3], [31, 1], [31, 1], [31, 2], [31, 2], [31, 1], [39, 3], [40, 3], [40, 3], [40, 4], [42, 2], [42, 2], [42, 2], [42, 2], [42, 2], [42, 2], [42, 2], [41, 1], [30, 1], [30, 2], [30, 3], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 1], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [53, 2], [45, 1], [45, 2], [85, 1], [85, 2], [85, 1], [85, 1]],
      performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate, $$, _$) {
        var $0 = $$.length - 1;
        switch (yystate) {
          case 4:
            yy.setDirection("TB");
            break;
          case 5:
            yy.setDirection("BT");
            break;
          case 6:
            yy.setDirection("RL");
            break;
          case 7:
            yy.setDirection("LR");
            break;
          case 11:
            yy.parseDirective("%%{", "open_directive");
            break;
          case 12:
            break;
          case 13:
            $$[$0] = $$[$0].trim().replace(/'/g, '"');
            yy.parseDirective($$[$0], "arg_directive");
            break;
          case 14:
            yy.parseDirective("}%%", "close_directive", "c4Context");
            break;
          case 15:
          case 16:
          case 17:
          case 18:
          case 19:
            yy.setC4Type($$[$0 - 3]);
            break;
          case 26:
            yy.setTitle($$[$0].substring(6));
            this.$ = $$[$0].substring(6);
            break;
          case 27:
            yy.setAccDescription($$[$0].substring(15));
            this.$ = $$[$0].substring(15);
            break;
          case 28:
            this.$ = $$[$0].trim();
            yy.setTitle(this.$);
            break;
          case 29:
          case 30:
            this.$ = $$[$0].trim();
            yy.setAccDescription(this.$);
            break;
          case 35:
          case 36:
            $$[$0].splice(2, 0, "ENTERPRISE");
            yy.addPersonOrSystemBoundary(...$$[$0]);
            this.$ = $$[$0];
            break;
          case 37:
            yy.addPersonOrSystemBoundary(...$$[$0]);
            this.$ = $$[$0];
            break;
          case 38:
            $$[$0].splice(2, 0, "CONTAINER");
            yy.addContainerBoundary(...$$[$0]);
            this.$ = $$[$0];
            break;
          case 39:
            yy.addDeploymentNode("node", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 40:
            yy.addDeploymentNode("nodeL", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 41:
            yy.addDeploymentNode("nodeR", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 42:
            yy.popBoundaryParseStack();
            break;
          case 46:
            yy.addPersonOrSystem("person", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 47:
            yy.addPersonOrSystem("external_person", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 48:
            yy.addPersonOrSystem("system", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 49:
            yy.addPersonOrSystem("system_db", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 50:
            yy.addPersonOrSystem("system_queue", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 51:
            yy.addPersonOrSystem("external_system", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 52:
            yy.addPersonOrSystem("external_system_db", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 53:
            yy.addPersonOrSystem("external_system_queue", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 54:
            yy.addContainer("container", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 55:
            yy.addContainer("container_db", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 56:
            yy.addContainer("container_queue", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 57:
            yy.addContainer("external_container", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 58:
            yy.addContainer("external_container_db", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 59:
            yy.addContainer("external_container_queue", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 60:
            yy.addComponent("component", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 61:
            yy.addComponent("component_db", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 62:
            yy.addComponent("component_queue", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 63:
            yy.addComponent("external_component", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 64:
            yy.addComponent("external_component_db", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 65:
            yy.addComponent("external_component_queue", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 67:
            yy.addRel("rel", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 68:
            yy.addRel("birel", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 69:
            yy.addRel("rel_u", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 70:
            yy.addRel("rel_d", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 71:
            yy.addRel("rel_l", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 72:
            yy.addRel("rel_r", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 73:
            yy.addRel("rel_b", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 74:
            $$[$0].splice(0, 1);
            yy.addRel("rel", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 75:
            yy.updateElStyle("update_el_style", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 76:
            yy.updateRelStyle("update_rel_style", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 77:
            yy.updateLayoutConfig("update_layout_config", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 78:
            this.$ = [$$[$0]];
            break;
          case 79:
            $$[$0].unshift($$[$0 - 1]);
            this.$ = $$[$0];
            break;
          case 80:
          case 82:
            this.$ = $$[$0].trim();
            break;
          case 81:
            let kv = {};
            kv[$$[$0 - 1].trim()] = $$[$0].trim();
            this.$ = kv;
            break;
          case 83:
            this.$ = "";
            break;
        }
      },
      table: [{ 3: 1, 4: 2, 5: 3, 6: 4, 7: $V0, 8: $V1, 9: $V2, 10: $V3, 11: 5, 12: 10, 18: $V4, 22: $V5, 25: $V6, 26: $V7, 27: $V8, 28: $V9 }, { 1: [3] }, { 1: [2, 1] }, { 1: [2, 2] }, { 3: 17, 4: 2, 5: 3, 6: 4, 7: $V0, 8: $V1, 9: $V2, 10: $V3, 11: 5, 12: 10, 18: $V4, 22: $V5, 25: $V6, 26: $V7, 27: $V8, 28: $V9 }, { 1: [2, 8] }, { 1: [2, 4] }, { 1: [2, 5] }, { 1: [2, 6] }, { 1: [2, 7] }, { 13: 18, 19: [1, 19] }, { 15: [1, 20] }, { 15: [1, 21] }, { 15: [1, 22] }, { 15: [1, 23] }, { 15: [1, 24] }, { 19: [2, 11] }, { 1: [2, 3] }, { 14: 25, 16: [1, 26], 21: $Va }, o([16, 21], [2, 12]), { 23: 28, 29: 29, 30: 30, 31: 31, 32: $Vb, 33: $Vc, 34: $Vd, 36: $Ve, 38: $Vf, 39: 58, 40: 70, 42: 71, 44: $Vg, 46: $Vh, 47: $Vi, 48: $Vj, 49: $Vk, 50: $Vl, 51: $Vm, 53: 32, 54: $Vn, 55: $Vo, 56: $Vp, 57: $Vq, 58: $Vr, 59: $Vs, 60: $Vt, 61: $Vu, 62: $Vv, 63: $Vw, 64: $Vx, 65: $Vy, 66: $Vz, 67: $VA, 68: $VB, 69: $VC, 70: $VD, 71: $VE, 72: $VF, 73: $VG, 74: $VH, 75: $VI, 76: $VJ, 77: $VK, 78: $VL, 79: $VM, 80: $VN, 81: $VO, 82: $VP, 83: $VQ, 84: $VR }, { 23: 79, 29: 29, 30: 30, 31: 31, 32: $Vb, 33: $Vc, 34: $Vd, 36: $Ve, 38: $Vf, 39: 58, 40: 70, 42: 71, 44: $Vg, 46: $Vh, 47: $Vi, 48: $Vj, 49: $Vk, 50: $Vl, 51: $Vm, 53: 32, 54: $Vn, 55: $Vo, 56: $Vp, 57: $Vq, 58: $Vr, 59: $Vs, 60: $Vt, 61: $Vu, 62: $Vv, 63: $Vw, 64: $Vx, 65: $Vy, 66: $Vz, 67: $VA, 68: $VB, 69: $VC, 70: $VD, 71: $VE, 72: $VF, 73: $VG, 74: $VH, 75: $VI, 76: $VJ, 77: $VK, 78: $VL, 79: $VM, 80: $VN, 81: $VO, 82: $VP, 83: $VQ, 84: $VR }, { 23: 80, 29: 29, 30: 30, 31: 31, 32: $Vb, 33: $Vc, 34: $Vd, 36: $Ve, 38: $Vf, 39: 58, 40: 70, 42: 71, 44: $Vg, 46: $Vh, 47: $Vi, 48: $Vj, 49: $Vk, 50: $Vl, 51: $Vm, 53: 32, 54: $Vn, 55: $Vo, 56: $Vp, 57: $Vq, 58: $Vr, 59: $Vs, 60: $Vt, 61: $Vu, 62: $Vv, 63: $Vw, 64: $Vx, 65: $Vy, 66: $Vz, 67: $VA, 68: $VB, 69: $VC, 70: $VD, 71: $VE, 72: $VF, 73: $VG, 74: $VH, 75: $VI, 76: $VJ, 77: $VK, 78: $VL, 79: $VM, 80: $VN, 81: $VO, 82: $VP, 83: $VQ, 84: $VR }, { 23: 81, 29: 29, 30: 30, 31: 31, 32: $Vb, 33: $Vc, 34: $Vd, 36: $Ve, 38: $Vf, 39: 58, 40: 70, 42: 71, 44: $Vg, 46: $Vh, 47: $Vi, 48: $Vj, 49: $Vk, 50: $Vl, 51: $Vm, 53: 32, 54: $Vn, 55: $Vo, 56: $Vp, 57: $Vq, 58: $Vr, 59: $Vs, 60: $Vt, 61: $Vu, 62: $Vv, 63: $Vw, 64: $Vx, 65: $Vy, 66: $Vz, 67: $VA, 68: $VB, 69: $VC, 70: $VD, 71: $VE, 72: $VF, 73: $VG, 74: $VH, 75: $VI, 76: $VJ, 77: $VK, 78: $VL, 79: $VM, 80: $VN, 81: $VO, 82: $VP, 83: $VQ, 84: $VR }, { 23: 82, 29: 29, 30: 30, 31: 31, 32: $Vb, 33: $Vc, 34: $Vd, 36: $Ve, 38: $Vf, 39: 58, 40: 70, 42: 71, 44: $Vg, 46: $Vh, 47: $Vi, 48: $Vj, 49: $Vk, 50: $Vl, 51: $Vm, 53: 32, 54: $Vn, 55: $Vo, 56: $Vp, 57: $Vq, 58: $Vr, 59: $Vs, 60: $Vt, 61: $Vu, 62: $Vv, 63: $Vw, 64: $Vx, 65: $Vy, 66: $Vz, 67: $VA, 68: $VB, 69: $VC, 70: $VD, 71: $VE, 72: $VF, 73: $VG, 74: $VH, 75: $VI, 76: $VJ, 77: $VK, 78: $VL, 79: $VM, 80: $VN, 81: $VO, 82: $VP, 83: $VQ, 84: $VR }, { 15: [1, 83] }, { 17: 84, 20: [1, 85] }, { 15: [2, 14] }, { 24: [1, 86] }, o($VS, [2, 20], { 53: 32, 39: 58, 40: 70, 42: 71, 30: 87, 44: $Vg, 46: $Vh, 47: $Vi, 48: $Vj, 49: $Vk, 50: $Vl, 51: $Vm, 54: $Vn, 55: $Vo, 56: $Vp, 57: $Vq, 58: $Vr, 59: $Vs, 60: $Vt, 61: $Vu, 62: $Vv, 63: $Vw, 64: $Vx, 65: $Vy, 66: $Vz, 67: $VA, 68: $VB, 69: $VC, 70: $VD, 71: $VE, 72: $VF, 73: $VG, 74: $VH, 75: $VI, 76: $VJ, 77: $VK, 78: $VL, 79: $VM, 80: $VN, 81: $VO, 82: $VP, 83: $VQ, 84: $VR }), o($VS, [2, 21]), o($VT, [2, 23], { 15: [1, 88] }), o($VS, [2, 43], { 15: [1, 89] }), o($VU, [2, 26]), o($VU, [2, 27]), { 35: [1, 90] }, { 37: [1, 91] }, o($VU, [2, 30]), { 45: 92, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 98, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 99, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 100, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 101, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 102, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 103, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 104, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 105, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 106, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 107, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 108, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 109, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 110, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 111, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 112, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 113, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 114, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 115, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 116, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, o($VZ, [2, 66]), { 45: 117, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 118, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 119, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 120, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 121, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 122, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 123, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 124, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 125, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 126, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 127, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 30: 128, 39: 58, 40: 70, 42: 71, 44: $Vg, 46: $Vh, 47: $Vi, 48: $Vj, 49: $Vk, 50: $Vl, 51: $Vm, 53: 32, 54: $Vn, 55: $Vo, 56: $Vp, 57: $Vq, 58: $Vr, 59: $Vs, 60: $Vt, 61: $Vu, 62: $Vv, 63: $Vw, 64: $Vx, 65: $Vy, 66: $Vz, 67: $VA, 68: $VB, 69: $VC, 70: $VD, 71: $VE, 72: $VF, 73: $VG, 74: $VH, 75: $VI, 76: $VJ, 77: $VK, 78: $VL, 79: $VM, 80: $VN, 81: $VO, 82: $VP, 83: $VQ, 84: $VR }, { 15: [1, 130], 43: [1, 129] }, { 45: 131, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 132, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 133, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 134, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 135, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 136, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 45: 137, 85: 93, 86: $VV, 87: $VW, 89: $VX, 90: $VY }, { 24: [1, 138] }, { 24: [1, 139] }, { 24: [1, 140] }, { 24: [1, 141] }, o($V_, [2, 9]), { 14: 142, 21: $Va }, { 21: [2, 13] }, { 1: [2, 15] }, o($VS, [2, 22]), o($VT, [2, 24], { 31: 31, 29: 143, 32: $Vb, 33: $Vc, 34: $Vd, 36: $Ve, 38: $Vf }), o($VS, [2, 44], { 29: 29, 30: 30, 31: 31, 53: 32, 39: 58, 40: 70, 42: 71, 23: 144, 32: $Vb, 33: $Vc, 34: $Vd, 36: $Ve, 38: $Vf, 44: $Vg, 46: $Vh, 47: $Vi, 48: $Vj, 49: $Vk, 50: $Vl, 51: $Vm, 54: $Vn, 55: $Vo, 56: $Vp, 57: $Vq, 58: $Vr, 59: $Vs, 60: $Vt, 61: $Vu, 62: $Vv, 63: $Vw, 64: $Vx, 65: $Vy, 66: $Vz, 67: $VA, 68: $VB, 69: $VC, 70: $VD, 71: $VE, 72: $VF, 73: $VG, 74: $VH, 75: $VI, 76: $VJ, 77: $VK, 78: $VL, 79: $VM, 80: $VN, 81: $VO, 82: $VP, 83: $VQ, 84: $VR }), o($VU, [2, 28]), o($VU, [2, 29]), o($VZ, [2, 46]), o($V$, [2, 78], { 85: 93, 45: 145, 86: $VV, 87: $VW, 89: $VX, 90: $VY }), o($V01, [2, 80]), { 88: [1, 146] }, o($V01, [2, 82]), o($V01, [2, 83]), o($VZ, [2, 47]), o($VZ, [2, 48]), o($VZ, [2, 49]), o($VZ, [2, 50]), o($VZ, [2, 51]), o($VZ, [2, 52]), o($VZ, [2, 53]), o($VZ, [2, 54]), o($VZ, [2, 55]), o($VZ, [2, 56]), o($VZ, [2, 57]), o($VZ, [2, 58]), o($VZ, [2, 59]), o($VZ, [2, 60]), o($VZ, [2, 61]), o($VZ, [2, 62]), o($VZ, [2, 63]), o($VZ, [2, 64]), o($VZ, [2, 65]), o($VZ, [2, 67]), o($VZ, [2, 68]), o($VZ, [2, 69]), o($VZ, [2, 70]), o($VZ, [2, 71]), o($VZ, [2, 72]), o($VZ, [2, 73]), o($VZ, [2, 74]), o($VZ, [2, 75]), o($VZ, [2, 76]), o($VZ, [2, 77]), { 41: 147, 52: [1, 148] }, { 15: [1, 149] }, { 43: [1, 150] }, o($V11, [2, 35]), o($V11, [2, 36]), o($V11, [2, 37]), o($V11, [2, 38]), o($V11, [2, 39]), o($V11, [2, 40]), o($V11, [2, 41]), { 1: [2, 16] }, { 1: [2, 17] }, { 1: [2, 18] }, { 1: [2, 19] }, { 15: [1, 151] }, o($VT, [2, 25]), o($VS, [2, 45]), o($V$, [2, 79]), o($V01, [2, 81]), o($VZ, [2, 31]), o($VZ, [2, 42]), o($V21, [2, 32]), o($V21, [2, 33], { 15: [1, 152] }), o($V_, [2, 10]), o($V21, [2, 34])],
      defaultActions: { 2: [2, 1], 3: [2, 2], 5: [2, 8], 6: [2, 4], 7: [2, 5], 8: [2, 6], 9: [2, 7], 16: [2, 11], 17: [2, 3], 27: [2, 14], 85: [2, 13], 86: [2, 15], 138: [2, 16], 139: [2, 17], 140: [2, 18], 141: [2, 19] },
      parseError: function parseError2(str2, hash) {
        if (hash.recoverable) {
          this.trace(str2);
        } else {
          var error = new Error(str2);
          error.hash = hash;
          throw error;
        }
      },
      parse: function parse2(input) {
        var self2 = this, stack = [0], tstack = [], vstack = [null], lstack = [], table = this.table, yytext = "", yylineno = 0, yyleng = 0, TERROR = 2, EOF = 1;
        var args = lstack.slice.call(arguments, 1);
        var lexer2 = Object.create(this.lexer);
        var sharedState = { yy: {} };
        for (var k in this.yy) {
          if (Object.prototype.hasOwnProperty.call(this.yy, k)) {
            sharedState.yy[k] = this.yy[k];
          }
        }
        lexer2.setInput(input, sharedState.yy);
        sharedState.yy.lexer = lexer2;
        sharedState.yy.parser = this;
        if (typeof lexer2.yylloc == "undefined") {
          lexer2.yylloc = {};
        }
        var yyloc = lexer2.yylloc;
        lstack.push(yyloc);
        var ranges = lexer2.options && lexer2.options.ranges;
        if (typeof sharedState.yy.parseError === "function") {
          this.parseError = sharedState.yy.parseError;
        } else {
          this.parseError = Object.getPrototypeOf(this).parseError;
        }
        function lex2() {
          var token2;
          token2 = tstack.pop() || lexer2.lex() || EOF;
          if (typeof token2 !== "number") {
            if (token2 instanceof Array) {
              tstack = token2;
              token2 = tstack.pop();
            }
            token2 = self2.symbols_[token2] || token2;
          }
          return token2;
        }
        var symbol, state2, action, r, yyval = {}, p, len, newState, expected;
        while (true) {
          state2 = stack[stack.length - 1];
          if (this.defaultActions[state2]) {
            action = this.defaultActions[state2];
          } else {
            if (symbol === null || typeof symbol == "undefined") {
              symbol = lex2();
            }
            action = table[state2] && table[state2][symbol];
          }
          if (typeof action === "undefined" || !action.length || !action[0]) {
            var errStr = "";
            expected = [];
            for (p in table[state2]) {
              if (this.terminals_[p] && p > TERROR) {
                expected.push("'" + this.terminals_[p] + "'");
              }
            }
            if (lexer2.showPosition) {
              errStr = "Parse error on line " + (yylineno + 1) + ":\n" + lexer2.showPosition() + "\nExpecting " + expected.join(", ") + ", got '" + (this.terminals_[symbol] || symbol) + "'";
            } else {
              errStr = "Parse error on line " + (yylineno + 1) + ": Unexpected " + (symbol == EOF ? "end of input" : "'" + (this.terminals_[symbol] || symbol) + "'");
            }
            this.parseError(errStr, {
              text: lexer2.match,
              token: this.terminals_[symbol] || symbol,
              line: lexer2.yylineno,
              loc: yyloc,
              expected
            });
          }
          if (action[0] instanceof Array && action.length > 1) {
            throw new Error("Parse Error: multiple actions possible at state: " + state2 + ", token: " + symbol);
          }
          switch (action[0]) {
            case 1:
              stack.push(symbol);
              vstack.push(lexer2.yytext);
              lstack.push(lexer2.yylloc);
              stack.push(action[1]);
              symbol = null;
              {
                yyleng = lexer2.yyleng;
                yytext = lexer2.yytext;
                yylineno = lexer2.yylineno;
                yyloc = lexer2.yylloc;
              }
              break;
            case 2:
              len = this.productions_[action[1]][1];
              yyval.$ = vstack[vstack.length - len];
              yyval._$ = {
                first_line: lstack[lstack.length - (len || 1)].first_line,
                last_line: lstack[lstack.length - 1].last_line,
                first_column: lstack[lstack.length - (len || 1)].first_column,
                last_column: lstack[lstack.length - 1].last_column
              };
              if (ranges) {
                yyval._$.range = [
                  lstack[lstack.length - (len || 1)].range[0],
                  lstack[lstack.length - 1].range[1]
                ];
              }
              r = this.performAction.apply(yyval, [
                yytext,
                yyleng,
                yylineno,
                sharedState.yy,
                action[1],
                vstack,
                lstack
              ].concat(args));
              if (typeof r !== "undefined") {
                return r;
              }
              if (len) {
                stack = stack.slice(0, -1 * len * 2);
                vstack = vstack.slice(0, -1 * len);
                lstack = lstack.slice(0, -1 * len);
              }
              stack.push(this.productions_[action[1]][0]);
              vstack.push(yyval.$);
              lstack.push(yyval._$);
              newState = table[stack[stack.length - 2]][stack[stack.length - 1]];
              stack.push(newState);
              break;
            case 3:
              return true;
          }
        }
        return true;
      }
    };
    var lexer = function() {
      var lexer2 = {
        EOF: 1,
        parseError: function parseError2(str2, hash) {
          if (this.yy.parser) {
            this.yy.parser.parseError(str2, hash);
          } else {
            throw new Error(str2);
          }
        },
        // resets the lexer, sets new input
        setInput: function(input, yy) {
          this.yy = yy || this.yy || {};
          this._input = input;
          this._more = this._backtrack = this.done = false;
          this.yylineno = this.yyleng = 0;
          this.yytext = this.matched = this.match = "";
          this.conditionStack = ["INITIAL"];
          this.yylloc = {
            first_line: 1,
            first_column: 0,
            last_line: 1,
            last_column: 0
          };
          if (this.options.ranges) {
            this.yylloc.range = [0, 0];
          }
          this.offset = 0;
          return this;
        },
        // consumes and returns one char from the input
        input: function() {
          var ch = this._input[0];
          this.yytext += ch;
          this.yyleng++;
          this.offset++;
          this.match += ch;
          this.matched += ch;
          var lines = ch.match(/(?:\r\n?|\n).*/g);
          if (lines) {
            this.yylineno++;
            this.yylloc.last_line++;
          } else {
            this.yylloc.last_column++;
          }
          if (this.options.ranges) {
            this.yylloc.range[1]++;
          }
          this._input = this._input.slice(1);
          return ch;
        },
        // unshifts one char (or a string) into the input
        unput: function(ch) {
          var len = ch.length;
          var lines = ch.split(/(?:\r\n?|\n)/g);
          this._input = ch + this._input;
          this.yytext = this.yytext.substr(0, this.yytext.length - len);
          this.offset -= len;
          var oldLines = this.match.split(/(?:\r\n?|\n)/g);
          this.match = this.match.substr(0, this.match.length - 1);
          this.matched = this.matched.substr(0, this.matched.length - 1);
          if (lines.length - 1) {
            this.yylineno -= lines.length - 1;
          }
          var r = this.yylloc.range;
          this.yylloc = {
            first_line: this.yylloc.first_line,
            last_line: this.yylineno + 1,
            first_column: this.yylloc.first_column,
            last_column: lines ? (lines.length === oldLines.length ? this.yylloc.first_column : 0) + oldLines[oldLines.length - lines.length].length - lines[0].length : this.yylloc.first_column - len
          };
          if (this.options.ranges) {
            this.yylloc.range = [r[0], r[0] + this.yyleng - len];
          }
          this.yyleng = this.yytext.length;
          return this;
        },
        // When called from action, caches matched text and appends it on next action
        more: function() {
          this._more = true;
          return this;
        },
        // When called from action, signals the lexer that this rule fails to match the input, so the next matching rule (regex) should be tested instead.
        reject: function() {
          if (this.options.backtrack_lexer) {
            this._backtrack = true;
          } else {
            return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". You can only invoke reject() in the lexer when the lexer is of the backtracking persuasion (options.backtrack_lexer = true).\n" + this.showPosition(), {
              text: "",
              token: null,
              line: this.yylineno
            });
          }
          return this;
        },
        // retain first n characters of the match
        less: function(n) {
          this.unput(this.match.slice(n));
        },
        // displays already matched input, i.e. for error messages
        pastInput: function() {
          var past = this.matched.substr(0, this.matched.length - this.match.length);
          return (past.length > 20 ? "..." : "") + past.substr(-20).replace(/\n/g, "");
        },
        // displays upcoming input, i.e. for error messages
        upcomingInput: function() {
          var next2 = this.match;
          if (next2.length < 20) {
            next2 += this._input.substr(0, 20 - next2.length);
          }
          return (next2.substr(0, 20) + (next2.length > 20 ? "..." : "")).replace(/\n/g, "");
        },
        // displays the character position where the lexing error occurred, i.e. for error messages
        showPosition: function() {
          var pre = this.pastInput();
          var c2 = new Array(pre.length + 1).join("-");
          return pre + this.upcomingInput() + "\n" + c2 + "^";
        },
        // test the lexed token: return FALSE when not a match, otherwise return token
        test_match: function(match, indexed_rule) {
          var token2, lines, backup;
          if (this.options.backtrack_lexer) {
            backup = {
              yylineno: this.yylineno,
              yylloc: {
                first_line: this.yylloc.first_line,
                last_line: this.last_line,
                first_column: this.yylloc.first_column,
                last_column: this.yylloc.last_column
              },
              yytext: this.yytext,
              match: this.match,
              matches: this.matches,
              matched: this.matched,
              yyleng: this.yyleng,
              offset: this.offset,
              _more: this._more,
              _input: this._input,
              yy: this.yy,
              conditionStack: this.conditionStack.slice(0),
              done: this.done
            };
            if (this.options.ranges) {
              backup.yylloc.range = this.yylloc.range.slice(0);
            }
          }
          lines = match[0].match(/(?:\r\n?|\n).*/g);
          if (lines) {
            this.yylineno += lines.length;
          }
          this.yylloc = {
            first_line: this.yylloc.last_line,
            last_line: this.yylineno + 1,
            first_column: this.yylloc.last_column,
            last_column: lines ? lines[lines.length - 1].length - lines[lines.length - 1].match(/\r?\n?/)[0].length : this.yylloc.last_column + match[0].length
          };
          this.yytext += match[0];
          this.match += match[0];
          this.matches = match;
          this.yyleng = this.yytext.length;
          if (this.options.ranges) {
            this.yylloc.range = [this.offset, this.offset += this.yyleng];
          }
          this._more = false;
          this._backtrack = false;
          this._input = this._input.slice(match[0].length);
          this.matched += match[0];
          token2 = this.performAction.call(this, this.yy, this, indexed_rule, this.conditionStack[this.conditionStack.length - 1]);
          if (this.done && this._input) {
            this.done = false;
          }
          if (token2) {
            return token2;
          } else if (this._backtrack) {
            for (var k in backup) {
              this[k] = backup[k];
            }
            return false;
          }
          return false;
        },
        // return next match in input
        next: function() {
          if (this.done) {
            return this.EOF;
          }
          if (!this._input) {
            this.done = true;
          }
          var token2, match, tempMatch, index2;
          if (!this._more) {
            this.yytext = "";
            this.match = "";
          }
          var rules = this._currentRules();
          for (var i2 = 0; i2 < rules.length; i2++) {
            tempMatch = this._input.match(this.rules[rules[i2]]);
            if (tempMatch && (!match || tempMatch[0].length > match[0].length)) {
              match = tempMatch;
              index2 = i2;
              if (this.options.backtrack_lexer) {
                token2 = this.test_match(tempMatch, rules[i2]);
                if (token2 !== false) {
                  return token2;
                } else if (this._backtrack) {
                  match = false;
                  continue;
                } else {
                  return false;
                }
              } else if (!this.options.flex) {
                break;
              }
            }
          }
          if (match) {
            token2 = this.test_match(match, rules[index2]);
            if (token2 !== false) {
              return token2;
            }
            return false;
          }
          if (this._input === "") {
            return this.EOF;
          } else {
            return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". Unrecognized text.\n" + this.showPosition(), {
              text: "",
              token: null,
              line: this.yylineno
            });
          }
        },
        // return next match that has a token
        lex: function lex2() {
          var r = this.next();
          if (r) {
            return r;
          } else {
            return this.lex();
          }
        },
        // activates a new lexer condition state (pushes the new lexer condition state onto the condition stack)
        begin: function begin(condition) {
          this.conditionStack.push(condition);
        },
        // pop the previously active lexer condition state off the condition stack
        popState: function popState() {
          var n = this.conditionStack.length - 1;
          if (n > 0) {
            return this.conditionStack.pop();
          } else {
            return this.conditionStack[0];
          }
        },
        // produce the lexer rule set which is active for the currently active lexer condition state
        _currentRules: function _currentRules() {
          if (this.conditionStack.length && this.conditionStack[this.conditionStack.length - 1]) {
            return this.conditions[this.conditionStack[this.conditionStack.length - 1]].rules;
          } else {
            return this.conditions["INITIAL"].rules;
          }
        },
        // return the currently active lexer condition state; when an index argument is provided it produces the N-th previous condition state, if available
        topState: function topState(n) {
          n = this.conditionStack.length - 1 - Math.abs(n || 0);
          if (n >= 0) {
            return this.conditionStack[n];
          } else {
            return "INITIAL";
          }
        },
        // alias for begin(condition)
        pushState: function pushState(condition) {
          this.begin(condition);
        },
        // return the number of states currently on the stack
        stateStackSize: function stateStackSize() {
          return this.conditionStack.length;
        },
        options: {},
        performAction: function anonymous(yy, yy_, $avoiding_name_collisions, YY_START) {
          switch ($avoiding_name_collisions) {
            case 0:
              this.begin("open_directive");
              return 18;
            case 1:
              return 7;
            case 2:
              return 8;
            case 3:
              return 9;
            case 4:
              return 10;
            case 5:
              this.begin("type_directive");
              return 19;
            case 6:
              this.popState();
              this.begin("arg_directive");
              return 16;
            case 7:
              this.popState();
              this.popState();
              return 21;
            case 8:
              return 20;
            case 9:
              return 32;
            case 10:
              return 33;
            case 11:
              this.begin("acc_title");
              return 34;
            case 12:
              this.popState();
              return "acc_title_value";
            case 13:
              this.begin("acc_descr");
              return 36;
            case 14:
              this.popState();
              return "acc_descr_value";
            case 15:
              this.begin("acc_descr_multiline");
              break;
            case 16:
              this.popState();
              break;
            case 17:
              return "acc_descr_multiline_value";
            case 18:
              break;
            case 19:
              c;
              break;
            case 20:
              return 15;
            case 21:
              break;
            case 22:
              return 22;
            case 23:
              return 25;
            case 24:
              return 26;
            case 25:
              return 27;
            case 26:
              return 28;
            case 27:
              this.begin("person_ext");
              return 55;
            case 28:
              this.begin("person");
              return 54;
            case 29:
              this.begin("system_ext_queue");
              return 61;
            case 30:
              this.begin("system_ext_db");
              return 60;
            case 31:
              this.begin("system_ext");
              return 59;
            case 32:
              this.begin("system_queue");
              return 58;
            case 33:
              this.begin("system_db");
              return 57;
            case 34:
              this.begin("system");
              return 56;
            case 35:
              this.begin("boundary");
              return 47;
            case 36:
              this.begin("enterprise_boundary");
              return 44;
            case 37:
              this.begin("system_boundary");
              return 46;
            case 38:
              this.begin("container_ext_queue");
              return 67;
            case 39:
              this.begin("container_ext_db");
              return 66;
            case 40:
              this.begin("container_ext");
              return 65;
            case 41:
              this.begin("container_queue");
              return 64;
            case 42:
              this.begin("container_db");
              return 63;
            case 43:
              this.begin("container");
              return 62;
            case 44:
              this.begin("container_boundary");
              return 48;
            case 45:
              this.begin("component_ext_queue");
              return 73;
            case 46:
              this.begin("component_ext_db");
              return 72;
            case 47:
              this.begin("component_ext");
              return 71;
            case 48:
              this.begin("component_queue");
              return 70;
            case 49:
              this.begin("component_db");
              return 69;
            case 50:
              this.begin("component");
              return 68;
            case 51:
              this.begin("node");
              return 49;
            case 52:
              this.begin("node");
              return 49;
            case 53:
              this.begin("node_l");
              return 50;
            case 54:
              this.begin("node_r");
              return 51;
            case 55:
              this.begin("rel");
              return 74;
            case 56:
              this.begin("birel");
              return 75;
            case 57:
              this.begin("rel_u");
              return 76;
            case 58:
              this.begin("rel_u");
              return 76;
            case 59:
              this.begin("rel_d");
              return 77;
            case 60:
              this.begin("rel_d");
              return 77;
            case 61:
              this.begin("rel_l");
              return 78;
            case 62:
              this.begin("rel_l");
              return 78;
            case 63:
              this.begin("rel_r");
              return 79;
            case 64:
              this.begin("rel_r");
              return 79;
            case 65:
              this.begin("rel_b");
              return 80;
            case 66:
              this.begin("rel_index");
              return 81;
            case 67:
              this.begin("update_el_style");
              return 82;
            case 68:
              this.begin("update_rel_style");
              return 83;
            case 69:
              this.begin("update_layout_config");
              return 84;
            case 70:
              return "EOF_IN_STRUCT";
            case 71:
              this.begin("attribute");
              return "ATTRIBUTE_EMPTY";
            case 72:
              this.begin("attribute");
              break;
            case 73:
              this.popState();
              this.popState();
              break;
            case 74:
              return 90;
            case 75:
              break;
            case 76:
              return 90;
            case 77:
              this.begin("string");
              break;
            case 78:
              this.popState();
              break;
            case 79:
              return "STR";
            case 80:
              this.begin("string_kv");
              break;
            case 81:
              this.begin("string_kv_key");
              return "STR_KEY";
            case 82:
              this.popState();
              this.begin("string_kv_value");
              break;
            case 83:
              return "STR_VALUE";
            case 84:
              this.popState();
              this.popState();
              break;
            case 85:
              return "STR";
            case 86:
              return "LBRACE";
            case 87:
              return "RBRACE";
            case 88:
              return "SPACE";
            case 89:
              return "EOL";
            case 90:
              return 24;
          }
        },
        rules: [/^(?:%%\{)/, /^(?:.*direction\s+TB[^\n]*)/, /^(?:.*direction\s+BT[^\n]*)/, /^(?:.*direction\s+RL[^\n]*)/, /^(?:.*direction\s+LR[^\n]*)/, /^(?:((?:(?!\}%%)[^:.])*))/, /^(?::)/, /^(?:\}%%)/, /^(?:((?:(?!\}%%).|\n)*))/, /^(?:title\s[^#\n;]+)/, /^(?:accDescription\s[^#\n;]+)/, /^(?:accTitle\s*:\s*)/, /^(?:(?!\n||)*[^\n]*)/, /^(?:accDescr\s*:\s*)/, /^(?:(?!\n||)*[^\n]*)/, /^(?:accDescr\s*\{\s*)/, /^(?:[\}])/, /^(?:[^\}]*)/, /^(?:%%(?!\{)*[^\n]*(\r?\n?)+)/, /^(?:%%[^\n]*(\r?\n)*)/, /^(?:\s*(\r?\n)+)/, /^(?:\s+)/, /^(?:C4Context\b)/, /^(?:C4Container\b)/, /^(?:C4Component\b)/, /^(?:C4Dynamic\b)/, /^(?:C4Deployment\b)/, /^(?:Person_Ext\b)/, /^(?:Person\b)/, /^(?:SystemQueue_Ext\b)/, /^(?:SystemDb_Ext\b)/, /^(?:System_Ext\b)/, /^(?:SystemQueue\b)/, /^(?:SystemDb\b)/, /^(?:System\b)/, /^(?:Boundary\b)/, /^(?:Enterprise_Boundary\b)/, /^(?:System_Boundary\b)/, /^(?:ContainerQueue_Ext\b)/, /^(?:ContainerDb_Ext\b)/, /^(?:Container_Ext\b)/, /^(?:ContainerQueue\b)/, /^(?:ContainerDb\b)/, /^(?:Container\b)/, /^(?:Container_Boundary\b)/, /^(?:ComponentQueue_Ext\b)/, /^(?:ComponentDb_Ext\b)/, /^(?:Component_Ext\b)/, /^(?:ComponentQueue\b)/, /^(?:ComponentDb\b)/, /^(?:Component\b)/, /^(?:Deployment_Node\b)/, /^(?:Node\b)/, /^(?:Node_L\b)/, /^(?:Node_R\b)/, /^(?:Rel\b)/, /^(?:BiRel\b)/, /^(?:Rel_Up\b)/, /^(?:Rel_U\b)/, /^(?:Rel_Down\b)/, /^(?:Rel_D\b)/, /^(?:Rel_Left\b)/, /^(?:Rel_L\b)/, /^(?:Rel_Right\b)/, /^(?:Rel_R\b)/, /^(?:Rel_Back\b)/, /^(?:RelIndex\b)/, /^(?:UpdateElementStyle\b)/, /^(?:UpdateRelStyle\b)/, /^(?:UpdateLayoutConfig\b)/, /^(?:$)/, /^(?:[(][ ]*[,])/, /^(?:[(])/, /^(?:[)])/, /^(?:,,)/, /^(?:,)/, /^(?:[ ]*["]["])/, /^(?:[ ]*["])/, /^(?:["])/, /^(?:[^"]*)/, /^(?:[ ]*[\$])/, /^(?:[^=]*)/, /^(?:[=][ ]*["])/, /^(?:[^"]+)/, /^(?:["])/, /^(?:[^,]+)/, /^(?:\{)/, /^(?:\})/, /^(?:[\s]+)/, /^(?:[\n\r]+)/, /^(?:$)/],
        conditions: { "acc_descr_multiline": { "rules": [16, 17], "inclusive": false }, "acc_descr": { "rules": [14], "inclusive": false }, "acc_title": { "rules": [12], "inclusive": false }, "close_directive": { "rules": [], "inclusive": false }, "arg_directive": { "rules": [7, 8], "inclusive": false }, "type_directive": { "rules": [6, 7], "inclusive": false }, "open_directive": { "rules": [5], "inclusive": false }, "string_kv_value": { "rules": [83, 84], "inclusive": false }, "string_kv_key": { "rules": [82], "inclusive": false }, "string_kv": { "rules": [81], "inclusive": false }, "string": { "rules": [78, 79], "inclusive": false }, "attribute": { "rules": [73, 74, 75, 76, 77, 80, 85], "inclusive": false }, "update_layout_config": { "rules": [70, 71, 72, 73], "inclusive": false }, "update_rel_style": { "rules": [70, 71, 72, 73], "inclusive": false }, "update_el_style": { "rules": [70, 71, 72, 73], "inclusive": false }, "rel_b": { "rules": [70, 71, 72, 73], "inclusive": false }, "rel_r": { "rules": [70, 71, 72, 73], "inclusive": false }, "rel_l": { "rules": [70, 71, 72, 73], "inclusive": false }, "rel_d": { "rules": [70, 71, 72, 73], "inclusive": false }, "rel_u": { "rules": [70, 71, 72, 73], "inclusive": false }, "rel_bi": { "rules": [], "inclusive": false }, "rel": { "rules": [70, 71, 72, 73], "inclusive": false }, "node_r": { "rules": [70, 71, 72, 73], "inclusive": false }, "node_l": { "rules": [70, 71, 72, 73], "inclusive": false }, "node": { "rules": [70, 71, 72, 73], "inclusive": false }, "index": { "rules": [], "inclusive": false }, "rel_index": { "rules": [70, 71, 72, 73], "inclusive": false }, "component_ext_queue": { "rules": [], "inclusive": false }, "component_ext_db": { "rules": [70, 71, 72, 73], "inclusive": false }, "component_ext": { "rules": [70, 71, 72, 73], "inclusive": false }, "component_queue": { "rules": [70, 71, 72, 73], "inclusive": false }, "component_db": { "rules": [70, 71, 72, 73], "inclusive": false }, "component": { "rules": [70, 71, 72, 73], "inclusive": false }, "container_boundary": { "rules": [70, 71, 72, 73], "inclusive": false }, "container_ext_queue": { "rules": [], "inclusive": false }, "container_ext_db": { "rules": [70, 71, 72, 73], "inclusive": false }, "container_ext": { "rules": [70, 71, 72, 73], "inclusive": false }, "container_queue": { "rules": [70, 71, 72, 73], "inclusive": false }, "container_db": { "rules": [70, 71, 72, 73], "inclusive": false }, "container": { "rules": [70, 71, 72, 73], "inclusive": false }, "birel": { "rules": [70, 71, 72, 73], "inclusive": false }, "system_boundary": { "rules": [70, 71, 72, 73], "inclusive": false }, "enterprise_boundary": { "rules": [70, 71, 72, 73], "inclusive": false }, "boundary": { "rules": [70, 71, 72, 73], "inclusive": false }, "system_ext_queue": { "rules": [70, 71, 72, 73], "inclusive": false }, "system_ext_db": { "rules": [70, 71, 72, 73], "inclusive": false }, "system_ext": { "rules": [70, 71, 72, 73], "inclusive": false }, "system_queue": { "rules": [70, 71, 72, 73], "inclusive": false }, "system_db": { "rules": [70, 71, 72, 73], "inclusive": false }, "system": { "rules": [70, 71, 72, 73], "inclusive": false }, "person_ext": { "rules": [70, 71, 72, 73], "inclusive": false }, "person": { "rules": [70, 71, 72, 73], "inclusive": false }, "INITIAL": { "rules": [0, 1, 2, 3, 4, 9, 10, 11, 13, 15, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 86, 87, 88, 89, 90], "inclusive": true } }
      };
      return lexer2;
    }();
    parser2.lexer = lexer;
    function Parser() {
      this.yy = {};
    }
    Parser.prototype = parser2;
    parser2.Parser = Parser;
    return new Parser();
  }();
  parser$o.parser = parser$o;
  const c4Parser = parser$o;
  let c4ShapeArray = [];
  let boundaryParseStack = [""];
  let currentBoundaryParse = "global";
  let parentBoundaryParse = "";
  let boundarys = [
    {
      alias: "global",
      label: { text: "global" },
      type: { text: "global" },
      tags: null,
      link: null,
      parentBoundary: ""
    }
  ];
  let rels = [];
  let title = "";
  let wrapEnabled$1 = false;
  let c4ShapeInRow$1 = 4;
  let c4BoundaryInRow$1 = 2;
  var c4Type;
  const getC4Type = function() {
    return c4Type;
  };
  const setC4Type = function(c4TypeParam) {
    let sanitizedText = sanitizeText$6(c4TypeParam, getConfig$1());
    c4Type = sanitizedText;
  };
  const parseDirective$c = function(statement, context, type2) {
    mermaidAPI.parseDirective(this, statement, context, type2);
  };
  const addRel = function(type2, from2, to, label, techn, descr, sprite, tags2, link) {
    if (type2 === void 0 || type2 === null || from2 === void 0 || from2 === null || to === void 0 || to === null || label === void 0 || label === null) {
      return;
    }
    let rel = {};
    const old = rels.find((rel2) => rel2.from === from2 && rel2.to === to);
    if (old) {
      rel = old;
    } else {
      rels.push(rel);
    }
    rel.type = type2;
    rel.from = from2;
    rel.to = to;
    rel.label = { text: label };
    if (techn === void 0 || techn === null) {
      rel.techn = { text: "" };
    } else {
      if (typeof techn === "object") {
        let [key, value] = Object.entries(techn)[0];
        rel[key] = { text: value };
      } else {
        rel.techn = { text: techn };
      }
    }
    if (descr === void 0 || descr === null) {
      rel.descr = { text: "" };
    } else {
      if (typeof descr === "object") {
        let [key, value] = Object.entries(descr)[0];
        rel[key] = { text: value };
      } else {
        rel.descr = { text: descr };
      }
    }
    if (typeof sprite === "object") {
      let [key, value] = Object.entries(sprite)[0];
      rel[key] = value;
    } else {
      rel.sprite = sprite;
    }
    if (typeof tags2 === "object") {
      let [key, value] = Object.entries(tags2)[0];
      rel[key] = value;
    } else {
      rel.tags = tags2;
    }
    if (typeof link === "object") {
      let [key, value] = Object.entries(link)[0];
      rel[key] = value;
    } else {
      rel.link = link;
    }
    rel.wrap = autoWrap$1();
  };
  const addPersonOrSystem = function(typeC4Shape, alias, label, descr, sprite, tags2, link) {
    if (alias === null || label === null) {
      return;
    }
    let personOrSystem = {};
    const old = c4ShapeArray.find((personOrSystem2) => personOrSystem2.alias === alias);
    if (old && alias === old.alias) {
      personOrSystem = old;
    } else {
      personOrSystem.alias = alias;
      c4ShapeArray.push(personOrSystem);
    }
    if (label === void 0 || label === null) {
      personOrSystem.label = { text: "" };
    } else {
      personOrSystem.label = { text: label };
    }
    if (descr === void 0 || descr === null) {
      personOrSystem.descr = { text: "" };
    } else {
      if (typeof descr === "object") {
        let [key, value] = Object.entries(descr)[0];
        personOrSystem[key] = { text: value };
      } else {
        personOrSystem.descr = { text: descr };
      }
    }
    if (typeof sprite === "object") {
      let [key, value] = Object.entries(sprite)[0];
      personOrSystem[key] = value;
    } else {
      personOrSystem.sprite = sprite;
    }
    if (typeof tags2 === "object") {
      let [key, value] = Object.entries(tags2)[0];
      personOrSystem[key] = value;
    } else {
      personOrSystem.tags = tags2;
    }
    if (typeof link === "object") {
      let [key, value] = Object.entries(link)[0];
      personOrSystem[key] = value;
    } else {
      personOrSystem.link = link;
    }
    personOrSystem.typeC4Shape = { text: typeC4Shape };
    personOrSystem.parentBoundary = currentBoundaryParse;
    personOrSystem.wrap = autoWrap$1();
  };
  const addContainer = function(typeC4Shape, alias, label, techn, descr, sprite, tags2, link) {
    if (alias === null || label === null) {
      return;
    }
    let container = {};
    const old = c4ShapeArray.find((container2) => container2.alias === alias);
    if (old && alias === old.alias) {
      container = old;
    } else {
      container.alias = alias;
      c4ShapeArray.push(container);
    }
    if (label === void 0 || label === null) {
      container.label = { text: "" };
    } else {
      container.label = { text: label };
    }
    if (techn === void 0 || techn === null) {
      container.techn = { text: "" };
    } else {
      if (typeof techn === "object") {
        let [key, value] = Object.entries(techn)[0];
        container[key] = { text: value };
      } else {
        container.techn = { text: techn };
      }
    }
    if (descr === void 0 || descr === null) {
      container.descr = { text: "" };
    } else {
      if (typeof descr === "object") {
        let [key, value] = Object.entries(descr)[0];
        container[key] = { text: value };
      } else {
        container.descr = { text: descr };
      }
    }
    if (typeof sprite === "object") {
      let [key, value] = Object.entries(sprite)[0];
      container[key] = value;
    } else {
      container.sprite = sprite;
    }
    if (typeof tags2 === "object") {
      let [key, value] = Object.entries(tags2)[0];
      container[key] = value;
    } else {
      container.tags = tags2;
    }
    if (typeof link === "object") {
      let [key, value] = Object.entries(link)[0];
      container[key] = value;
    } else {
      container.link = link;
    }
    container.wrap = autoWrap$1();
    container.typeC4Shape = { text: typeC4Shape };
    container.parentBoundary = currentBoundaryParse;
  };
  const addComponent = function(typeC4Shape, alias, label, techn, descr, sprite, tags2, link) {
    if (alias === null || label === null) {
      return;
    }
    let component = {};
    const old = c4ShapeArray.find((component2) => component2.alias === alias);
    if (old && alias === old.alias) {
      component = old;
    } else {
      component.alias = alias;
      c4ShapeArray.push(component);
    }
    if (label === void 0 || label === null) {
      component.label = { text: "" };
    } else {
      component.label = { text: label };
    }
    if (techn === void 0 || techn === null) {
      component.techn = { text: "" };
    } else {
      if (typeof techn === "object") {
        let [key, value] = Object.entries(techn)[0];
        component[key] = { text: value };
      } else {
        component.techn = { text: techn };
      }
    }
    if (descr === void 0 || descr === null) {
      component.descr = { text: "" };
    } else {
      if (typeof descr === "object") {
        let [key, value] = Object.entries(descr)[0];
        component[key] = { text: value };
      } else {
        component.descr = { text: descr };
      }
    }
    if (typeof sprite === "object") {
      let [key, value] = Object.entries(sprite)[0];
      component[key] = value;
    } else {
      component.sprite = sprite;
    }
    if (typeof tags2 === "object") {
      let [key, value] = Object.entries(tags2)[0];
      component[key] = value;
    } else {
      component.tags = tags2;
    }
    if (typeof link === "object") {
      let [key, value] = Object.entries(link)[0];
      component[key] = value;
    } else {
      component.link = link;
    }
    component.wrap = autoWrap$1();
    component.typeC4Shape = { text: typeC4Shape };
    component.parentBoundary = currentBoundaryParse;
  };
  const addPersonOrSystemBoundary = function(alias, label, type2, tags2, link) {
    if (alias === null || label === null) {
      return;
    }
    let boundary = {};
    const old = boundarys.find((boundary2) => boundary2.alias === alias);
    if (old && alias === old.alias) {
      boundary = old;
    } else {
      boundary.alias = alias;
      boundarys.push(boundary);
    }
    if (label === void 0 || label === null) {
      boundary.label = { text: "" };
    } else {
      boundary.label = { text: label };
    }
    if (type2 === void 0 || type2 === null) {
      boundary.type = { text: "system" };
    } else {
      if (typeof type2 === "object") {
        let [key, value] = Object.entries(type2)[0];
        boundary[key] = { text: value };
      } else {
        boundary.type = { text: type2 };
      }
    }
    if (typeof tags2 === "object") {
      let [key, value] = Object.entries(tags2)[0];
      boundary[key] = value;
    } else {
      boundary.tags = tags2;
    }
    if (typeof link === "object") {
      let [key, value] = Object.entries(link)[0];
      boundary[key] = value;
    } else {
      boundary.link = link;
    }
    boundary.parentBoundary = currentBoundaryParse;
    boundary.wrap = autoWrap$1();
    parentBoundaryParse = currentBoundaryParse;
    currentBoundaryParse = alias;
    boundaryParseStack.push(parentBoundaryParse);
  };
  const addContainerBoundary = function(alias, label, type2, tags2, link) {
    if (alias === null || label === null) {
      return;
    }
    let boundary = {};
    const old = boundarys.find((boundary2) => boundary2.alias === alias);
    if (old && alias === old.alias) {
      boundary = old;
    } else {
      boundary.alias = alias;
      boundarys.push(boundary);
    }
    if (label === void 0 || label === null) {
      boundary.label = { text: "" };
    } else {
      boundary.label = { text: label };
    }
    if (type2 === void 0 || type2 === null) {
      boundary.type = { text: "container" };
    } else {
      if (typeof type2 === "object") {
        let [key, value] = Object.entries(type2)[0];
        boundary[key] = { text: value };
      } else {
        boundary.type = { text: type2 };
      }
    }
    if (typeof tags2 === "object") {
      let [key, value] = Object.entries(tags2)[0];
      boundary[key] = value;
    } else {
      boundary.tags = tags2;
    }
    if (typeof link === "object") {
      let [key, value] = Object.entries(link)[0];
      boundary[key] = value;
    } else {
      boundary.link = link;
    }
    boundary.parentBoundary = currentBoundaryParse;
    boundary.wrap = autoWrap$1();
    parentBoundaryParse = currentBoundaryParse;
    currentBoundaryParse = alias;
    boundaryParseStack.push(parentBoundaryParse);
  };
  const addDeploymentNode = function(nodeType2, alias, label, type2, descr, sprite, tags2, link) {
    if (alias === null || label === null) {
      return;
    }
    let boundary = {};
    const old = boundarys.find((boundary2) => boundary2.alias === alias);
    if (old && alias === old.alias) {
      boundary = old;
    } else {
      boundary.alias = alias;
      boundarys.push(boundary);
    }
    if (label === void 0 || label === null) {
      boundary.label = { text: "" };
    } else {
      boundary.label = { text: label };
    }
    if (type2 === void 0 || type2 === null) {
      boundary.type = { text: "node" };
    } else {
      if (typeof type2 === "object") {
        let [key, value] = Object.entries(type2)[0];
        boundary[key] = { text: value };
      } else {
        boundary.type = { text: type2 };
      }
    }
    if (descr === void 0 || descr === null) {
      boundary.descr = { text: "" };
    } else {
      if (typeof descr === "object") {
        let [key, value] = Object.entries(descr)[0];
        boundary[key] = { text: value };
      } else {
        boundary.descr = { text: descr };
      }
    }
    if (typeof tags2 === "object") {
      let [key, value] = Object.entries(tags2)[0];
      boundary[key] = value;
    } else {
      boundary.tags = tags2;
    }
    if (typeof link === "object") {
      let [key, value] = Object.entries(link)[0];
      boundary[key] = value;
    } else {
      boundary.link = link;
    }
    boundary.nodeType = nodeType2;
    boundary.parentBoundary = currentBoundaryParse;
    boundary.wrap = autoWrap$1();
    parentBoundaryParse = currentBoundaryParse;
    currentBoundaryParse = alias;
    boundaryParseStack.push(parentBoundaryParse);
  };
  const popBoundaryParseStack = function() {
    currentBoundaryParse = parentBoundaryParse;
    boundaryParseStack.pop();
    parentBoundaryParse = boundaryParseStack.pop();
    boundaryParseStack.push(parentBoundaryParse);
  };
  const updateElStyle = function(typeC4Shape, elementName, bgColor, fontColor, borderColor, shadowing, shape, sprite, techn, legendText, legendSprite) {
    let old = c4ShapeArray.find((element2) => element2.alias === elementName);
    if (old === void 0) {
      old = boundarys.find((element2) => element2.alias === elementName);
      if (old === void 0) {
        return;
      }
    }
    if (bgColor !== void 0 && bgColor !== null) {
      if (typeof bgColor === "object") {
        let [key, value] = Object.entries(bgColor)[0];
        old[key] = value;
      } else {
        old.bgColor = bgColor;
      }
    }
    if (fontColor !== void 0 && fontColor !== null) {
      if (typeof fontColor === "object") {
        let [key, value] = Object.entries(fontColor)[0];
        old[key] = value;
      } else {
        old.fontColor = fontColor;
      }
    }
    if (borderColor !== void 0 && borderColor !== null) {
      if (typeof borderColor === "object") {
        let [key, value] = Object.entries(borderColor)[0];
        old[key] = value;
      } else {
        old.borderColor = borderColor;
      }
    }
    if (shadowing !== void 0 && shadowing !== null) {
      if (typeof shadowing === "object") {
        let [key, value] = Object.entries(shadowing)[0];
        old[key] = value;
      } else {
        old.shadowing = shadowing;
      }
    }
    if (shape !== void 0 && shape !== null) {
      if (typeof shape === "object") {
        let [key, value] = Object.entries(shape)[0];
        old[key] = value;
      } else {
        old.shape = shape;
      }
    }
    if (sprite !== void 0 && sprite !== null) {
      if (typeof sprite === "object") {
        let [key, value] = Object.entries(sprite)[0];
        old[key] = value;
      } else {
        old.sprite = sprite;
      }
    }
    if (techn !== void 0 && techn !== null) {
      if (typeof techn === "object") {
        let [key, value] = Object.entries(techn)[0];
        old[key] = value;
      } else {
        old.techn = techn;
      }
    }
    if (legendText !== void 0 && legendText !== null) {
      if (typeof legendText === "object") {
        let [key, value] = Object.entries(legendText)[0];
        old[key] = value;
      } else {
        old.legendText = legendText;
      }
    }
    if (legendSprite !== void 0 && legendSprite !== null) {
      if (typeof legendSprite === "object") {
        let [key, value] = Object.entries(legendSprite)[0];
        old[key] = value;
      } else {
        old.legendSprite = legendSprite;
      }
    }
  };
  const updateRelStyle = function(typeC4Shape, from2, to, textColor, lineColor, offsetX, offsetY) {
    const old = rels.find((rel) => rel.from === from2 && rel.to === to);
    if (old === void 0) {
      return;
    }
    if (textColor !== void 0 && textColor !== null) {
      if (typeof textColor === "object") {
        let [key, value] = Object.entries(textColor)[0];
        old[key] = value;
      } else {
        old.textColor = textColor;
      }
    }
    if (lineColor !== void 0 && lineColor !== null) {
      if (typeof lineColor === "object") {
        let [key, value] = Object.entries(lineColor)[0];
        old[key] = value;
      } else {
        old.lineColor = lineColor;
      }
    }
    if (offsetX !== void 0 && offsetX !== null) {
      if (typeof offsetX === "object") {
        let [key, value] = Object.entries(offsetX)[0];
        old[key] = parseInt(value);
      } else {
        old.offsetX = parseInt(offsetX);
      }
    }
    if (offsetY !== void 0 && offsetY !== null) {
      if (typeof offsetY === "object") {
        let [key, value] = Object.entries(offsetY)[0];
        old[key] = parseInt(value);
      } else {
        old.offsetY = parseInt(offsetY);
      }
    }
  };
  const updateLayoutConfig = function(typeC4Shape, c4ShapeInRowParam, c4BoundaryInRowParam) {
    let c4ShapeInRowValue = c4ShapeInRow$1;
    let c4BoundaryInRowValue = c4BoundaryInRow$1;
    if (typeof c4ShapeInRowParam === "object") {
      const value = Object.values(c4ShapeInRowParam)[0];
      c4ShapeInRowValue = parseInt(value);
    } else {
      c4ShapeInRowValue = parseInt(c4ShapeInRowParam);
    }
    if (typeof c4BoundaryInRowParam === "object") {
      const value = Object.values(c4BoundaryInRowParam)[0];
      c4BoundaryInRowValue = parseInt(value);
    } else {
      c4BoundaryInRowValue = parseInt(c4BoundaryInRowParam);
    }
    if (c4ShapeInRowValue >= 1) {
      c4ShapeInRow$1 = c4ShapeInRowValue;
    }
    if (c4BoundaryInRowValue >= 1) {
      c4BoundaryInRow$1 = c4BoundaryInRowValue;
    }
  };
  const getC4ShapeInRow = function() {
    return c4ShapeInRow$1;
  };
  const getC4BoundaryInRow = function() {
    return c4BoundaryInRow$1;
  };
  const getCurrentBoundaryParse = function() {
    return currentBoundaryParse;
  };
  const getParentBoundaryParse = function() {
    return parentBoundaryParse;
  };
  const getC4ShapeArray = function(parentBoundary) {
    if (parentBoundary === void 0 || parentBoundary === null) {
      return c4ShapeArray;
    } else {
      return c4ShapeArray.filter((personOrSystem) => {
        return personOrSystem.parentBoundary === parentBoundary;
      });
    }
  };
  const getC4Shape = function(alias) {
    return c4ShapeArray.find((personOrSystem) => personOrSystem.alias === alias);
  };
  const getC4ShapeKeys = function(parentBoundary) {
    return Object.keys(getC4ShapeArray(parentBoundary));
  };
  const getBoundarys = function(parentBoundary) {
    if (parentBoundary === void 0 || parentBoundary === null) {
      return boundarys;
    } else {
      return boundarys.filter((boundary) => boundary.parentBoundary === parentBoundary);
    }
  };
  const getRels = function() {
    return rels;
  };
  const getTitle = function() {
    return title;
  };
  const setWrap$1 = function(wrapSetting) {
    wrapEnabled$1 = wrapSetting;
  };
  const autoWrap$1 = function() {
    return wrapEnabled$1;
  };
  const clear$i = function() {
    c4ShapeArray = [];
    boundarys = [
      {
        alias: "global",
        label: { text: "global" },
        type: { text: "global" },
        tags: null,
        link: null,
        parentBoundary: ""
      }
    ];
    parentBoundaryParse = "";
    currentBoundaryParse = "global";
    boundaryParseStack = [""];
    rels = [];
    boundaryParseStack = [""];
    title = "";
    wrapEnabled$1 = false;
    c4ShapeInRow$1 = 4;
    c4BoundaryInRow$1 = 2;
  };
  const LINETYPE$1 = {
    SOLID: 0,
    DOTTED: 1,
    NOTE: 2,
    SOLID_CROSS: 3,
    DOTTED_CROSS: 4,
    SOLID_OPEN: 5,
    DOTTED_OPEN: 6,
    LOOP_START: 10,
    LOOP_END: 11,
    ALT_START: 12,
    ALT_ELSE: 13,
    ALT_END: 14,
    OPT_START: 15,
    OPT_END: 16,
    ACTIVE_START: 17,
    ACTIVE_END: 18,
    PAR_START: 19,
    PAR_AND: 20,
    PAR_END: 21,
    RECT_START: 22,
    RECT_END: 23,
    SOLID_POINT: 24,
    DOTTED_POINT: 25
  };
  const ARROWTYPE$1 = {
    FILLED: 0,
    OPEN: 1
  };
  const PLACEMENT$1 = {
    LEFTOF: 0,
    RIGHTOF: 1,
    OVER: 2
  };
  const setTitle = function(txt) {
    let sanitizedText = sanitizeText$6(txt, getConfig$1());
    title = sanitizedText;
  };
  const c4Db = {
    addPersonOrSystem,
    addPersonOrSystemBoundary,
    addContainer,
    addContainerBoundary,
    addComponent,
    addDeploymentNode,
    popBoundaryParseStack,
    addRel,
    updateElStyle,
    updateRelStyle,
    updateLayoutConfig,
    autoWrap: autoWrap$1,
    setWrap: setWrap$1,
    getC4ShapeArray,
    getC4Shape,
    getC4ShapeKeys,
    getBoundarys,
    getCurrentBoundaryParse,
    getParentBoundaryParse,
    getRels,
    getTitle,
    getC4Type,
    getC4ShapeInRow,
    getC4BoundaryInRow,
    setAccTitle,
    getAccTitle,
    getAccDescription,
    setAccDescription,
    parseDirective: parseDirective$c,
    getConfig: () => getConfig$1().c4,
    clear: clear$i,
    LINETYPE: LINETYPE$1,
    ARROWTYPE: ARROWTYPE$1,
    PLACEMENT: PLACEMENT$1,
    setTitle,
    setC4Type
    // apply,
  };
  const drawRect$4 = function(elem, rectData) {
    const rectElem = elem.append("rect");
    rectElem.attr("x", rectData.x);
    rectElem.attr("y", rectData.y);
    rectElem.attr("fill", rectData.fill);
    rectElem.attr("stroke", rectData.stroke);
    rectElem.attr("width", rectData.width);
    rectElem.attr("height", rectData.height);
    rectElem.attr("rx", rectData.rx);
    rectElem.attr("ry", rectData.ry);
    if (rectData.attrs !== "undefined" && rectData.attrs !== null) {
      for (let attrKey in rectData.attrs) {
        rectElem.attr(attrKey, rectData.attrs[attrKey]);
      }
    }
    if (rectData.class !== "undefined") {
      rectElem.attr("class", rectData.class);
    }
    return rectElem;
  };
  const drawBackgroundRect$3 = function(elem, bounds2) {
    const rectElem = drawRect$4(elem, {
      x: bounds2.startx,
      y: bounds2.starty,
      width: bounds2.stopx - bounds2.startx,
      height: bounds2.stopy - bounds2.starty,
      fill: bounds2.fill,
      stroke: bounds2.stroke,
      class: "rect"
    });
    rectElem.lower();
  };
  const drawText$4 = function(elem, textData) {
    const nText = textData.text.replace(/<br\s*\/?>/gi, " ");
    const textElem = elem.append("text");
    textElem.attr("x", textData.x);
    textElem.attr("y", textData.y);
    textElem.attr("class", "legend");
    textElem.style("text-anchor", textData.anchor);
    if (textData.class !== void 0) {
      textElem.attr("class", textData.class);
    }
    const span = textElem.append("tspan");
    span.attr("x", textData.x + textData.textMargin * 2);
    span.text(nText);
    return textElem;
  };
  const drawImage$1 = function(elem, x2, y2, link) {
    const imageElem = elem.append("image");
    imageElem.attr("x", x2);
    imageElem.attr("y", y2);
    var sanitizedLink = sanitizeUrl_1(link);
    imageElem.attr("xlink:href", sanitizedLink);
  };
  const drawEmbeddedImage = function(elem, x2, y2, link) {
    const imageElem = elem.append("use");
    imageElem.attr("x", x2);
    imageElem.attr("y", y2);
    const sanitizedLink = sanitizeUrl_1(link);
    imageElem.attr("xlink:href", "#" + sanitizedLink);
  };
  const getNoteRect$2 = function() {
    return {
      x: 0,
      y: 0,
      width: 100,
      height: 100,
      fill: "#EDF2AE",
      stroke: "#666",
      anchor: "start",
      rx: 0,
      ry: 0
    };
  };
  const getTextObj$2 = function() {
    return {
      x: 0,
      y: 0,
      width: 100,
      height: 100,
      fill: void 0,
      anchor: void 0,
      "text-anchor": "start",
      style: "#666",
      textMargin: 0,
      rx: 0,
      ry: 0,
      tspan: true,
      valign: void 0
    };
  };
  const drawRect$3 = function(elem, rectData) {
    return drawRect$4(elem, rectData);
  };
  const drawImage = function(elem, width2, height2, x2, y2, link) {
    const imageElem = elem.append("image");
    imageElem.attr("width", width2);
    imageElem.attr("height", height2);
    imageElem.attr("x", x2);
    imageElem.attr("y", y2);
    let sanitizedLink = link.startsWith("data:image/png;base64") ? link : sanitizeUrl_1(link);
    imageElem.attr("xlink:href", sanitizedLink);
  };
  const drawRels$1 = (elem, rels2, conf2) => {
    const relsElem = elem.append("g");
    let i2 = 0;
    for (let rel of rels2) {
      let textColor = rel.textColor ? rel.textColor : "#444444";
      let strokeColor = rel.lineColor ? rel.lineColor : "#444444";
      let offsetX = rel.offsetX ? parseInt(rel.offsetX) : 0;
      let offsetY = rel.offsetY ? parseInt(rel.offsetY) : 0;
      let url = "";
      if (i2 === 0) {
        let line2 = relsElem.append("line");
        line2.attr("x1", rel.startPoint.x);
        line2.attr("y1", rel.startPoint.y);
        line2.attr("x2", rel.endPoint.x);
        line2.attr("y2", rel.endPoint.y);
        line2.attr("stroke-width", "1");
        line2.attr("stroke", strokeColor);
        line2.style("fill", "none");
        if (rel.type !== "rel_b") {
          line2.attr("marker-end", "url(" + url + "#arrowhead)");
        }
        if (rel.type === "birel" || rel.type === "rel_b") {
          line2.attr("marker-start", "url(" + url + "#arrowend)");
        }
        i2 = -1;
      } else {
        let line2 = relsElem.append("path");
        line2.attr("fill", "none").attr("stroke-width", "1").attr("stroke", strokeColor).attr(
          "d",
          "Mstartx,starty Qcontrolx,controly stopx,stopy ".replaceAll("startx", rel.startPoint.x).replaceAll("starty", rel.startPoint.y).replaceAll(
            "controlx",
            rel.startPoint.x + (rel.endPoint.x - rel.startPoint.x) / 2 - (rel.endPoint.x - rel.startPoint.x) / 4
          ).replaceAll("controly", rel.startPoint.y + (rel.endPoint.y - rel.startPoint.y) / 2).replaceAll("stopx", rel.endPoint.x).replaceAll("stopy", rel.endPoint.y)
        );
        if (rel.type !== "rel_b") {
          line2.attr("marker-end", "url(" + url + "#arrowhead)");
        }
        if (rel.type === "birel" || rel.type === "rel_b") {
          line2.attr("marker-start", "url(" + url + "#arrowend)");
        }
      }
      let messageConf = conf2.messageFont();
      _drawTextCandidateFunc$3(conf2)(
        rel.label.text,
        relsElem,
        Math.min(rel.startPoint.x, rel.endPoint.x) + Math.abs(rel.endPoint.x - rel.startPoint.x) / 2 + offsetX,
        Math.min(rel.startPoint.y, rel.endPoint.y) + Math.abs(rel.endPoint.y - rel.startPoint.y) / 2 + offsetY,
        rel.label.width,
        rel.label.height,
        { fill: textColor },
        messageConf
      );
      if (rel.techn && rel.techn.text !== "") {
        messageConf = conf2.messageFont();
        _drawTextCandidateFunc$3(conf2)(
          "[" + rel.techn.text + "]",
          relsElem,
          Math.min(rel.startPoint.x, rel.endPoint.x) + Math.abs(rel.endPoint.x - rel.startPoint.x) / 2 + offsetX,
          Math.min(rel.startPoint.y, rel.endPoint.y) + Math.abs(rel.endPoint.y - rel.startPoint.y) / 2 + conf2.messageFontSize + 5 + offsetY,
          Math.max(rel.label.width, rel.techn.width),
          rel.techn.height,
          { fill: textColor, "font-style": "italic" },
          messageConf
        );
      }
    }
  };
  const drawBoundary$1 = function(elem, boundary, conf2) {
    const boundaryElem = elem.append("g");
    let fillColor = boundary.bgColor ? boundary.bgColor : "none";
    let strokeColor = boundary.borderColor ? boundary.borderColor : "#444444";
    let fontColor = boundary.fontColor ? boundary.fontColor : "black";
    let attrsValue = { "stroke-width": 1, "stroke-dasharray": "7.0,7.0" };
    if (boundary.nodeType) {
      attrsValue = { "stroke-width": 1 };
    }
    let rectData = {
      x: boundary.x,
      y: boundary.y,
      fill: fillColor,
      stroke: strokeColor,
      width: boundary.width,
      height: boundary.height,
      rx: 2.5,
      ry: 2.5,
      attrs: attrsValue
    };
    drawRect$3(boundaryElem, rectData);
    let boundaryConf = conf2.boundaryFont();
    boundaryConf.fontWeight = "bold";
    boundaryConf.fontSize = boundaryConf.fontSize + 2;
    boundaryConf.fontColor = fontColor;
    _drawTextCandidateFunc$3(conf2)(
      boundary.label.text,
      boundaryElem,
      boundary.x,
      boundary.y + boundary.label.Y,
      boundary.width,
      boundary.height,
      { fill: "#444444" },
      boundaryConf
    );
    if (boundary.type && boundary.type.text !== "") {
      boundaryConf = conf2.boundaryFont();
      boundaryConf.fontColor = fontColor;
      _drawTextCandidateFunc$3(conf2)(
        boundary.type.text,
        boundaryElem,
        boundary.x,
        boundary.y + boundary.type.Y,
        boundary.width,
        boundary.height,
        { fill: "#444444" },
        boundaryConf
      );
    }
    if (boundary.descr && boundary.descr.text !== "") {
      boundaryConf = conf2.boundaryFont();
      boundaryConf.fontSize = boundaryConf.fontSize - 2;
      boundaryConf.fontColor = fontColor;
      _drawTextCandidateFunc$3(conf2)(
        boundary.descr.text,
        boundaryElem,
        boundary.x,
        boundary.y + boundary.descr.Y,
        boundary.width,
        boundary.height,
        { fill: "#444444" },
        boundaryConf
      );
    }
  };
  const drawC4Shape = function(elem, c4Shape, conf2) {
    var _a;
    let fillColor = c4Shape.bgColor ? c4Shape.bgColor : conf2[c4Shape.typeC4Shape.text + "_bg_color"];
    let strokeColor = c4Shape.borderColor ? c4Shape.borderColor : conf2[c4Shape.typeC4Shape.text + "_border_color"];
    let fontColor = c4Shape.fontColor ? c4Shape.fontColor : "#FFFFFF";
    let personImg = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAIAAADYYG7QAAACD0lEQVR4Xu2YoU4EMRCGT+4j8Ai8AhaH4QHgAUjQuFMECUgMIUgwJAgMhgQsAYUiJCiQIBBY+EITsjfTdme6V24v4c8vyGbb+ZjOtN0bNcvjQXmkH83WvYBWto6PLm6v7p7uH1/w2fXD+PBycX1Pv2l3IdDm/vn7x+dXQiAubRzoURa7gRZWd0iGRIiJbOnhnfYBQZNJjNbuyY2eJG8fkDE3bbG4ep6MHUAsgYxmE3nVs6VsBWJSGccsOlFPmLIViMzLOB7pCVO2AtHJMohH7Fh6zqitQK7m0rJvAVYgGcEpe//PLdDz65sM4pF9N7ICcXDKIB5Nv6j7tD0NoSdM2QrU9Gg0ewE1LqBhHR3BBdvj2vapnidjHxD/q6vd7Pvhr31AwcY8eXMTXAKECZZJFXuEq27aLgQK5uLMohCenGGuGewOxSjBvYBqeG6B+Nqiblggdjnc+ZXDy+FNFpFzw76O3UBAROuXh6FoiAcf5g9eTvUgzy0nWg6I8cXHRUpg5bOVBCo+KDpFajOf23GgPme7RSQ+lacIENUgJ6gg1k6HjgOlqnLqip4tEuhv0hNEMXUD0clyXE3p6pZA0S2nnvTlXwLJEZWlb7cTQH1+USgTN4VhAenm/wea1OCAOmqo6fE1WCb9WSKBah+rbUWPWAmE2Rvk0ApiB45eOyNAzU8xcTvj8KvkKEoOaIYeHNA3ZuygAvFMUO0AAAAASUVORK5CYII=";
    switch (c4Shape.typeC4Shape.text) {
      case "person":
        personImg = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAIAAADYYG7QAAACD0lEQVR4Xu2YoU4EMRCGT+4j8Ai8AhaH4QHgAUjQuFMECUgMIUgwJAgMhgQsAYUiJCiQIBBY+EITsjfTdme6V24v4c8vyGbb+ZjOtN0bNcvjQXmkH83WvYBWto6PLm6v7p7uH1/w2fXD+PBycX1Pv2l3IdDm/vn7x+dXQiAubRzoURa7gRZWd0iGRIiJbOnhnfYBQZNJjNbuyY2eJG8fkDE3bbG4ep6MHUAsgYxmE3nVs6VsBWJSGccsOlFPmLIViMzLOB7pCVO2AtHJMohH7Fh6zqitQK7m0rJvAVYgGcEpe//PLdDz65sM4pF9N7ICcXDKIB5Nv6j7tD0NoSdM2QrU9Gg0ewE1LqBhHR3BBdvj2vapnidjHxD/q6vd7Pvhr31AwcY8eXMTXAKECZZJFXuEq27aLgQK5uLMohCenGGuGewOxSjBvYBqeG6B+Nqiblggdjnc+ZXDy+FNFpFzw76O3UBAROuXh6FoiAcf5g9eTvUgzy0nWg6I8cXHRUpg5bOVBCo+KDpFajOf23GgPme7RSQ+lacIENUgJ6gg1k6HjgOlqnLqip4tEuhv0hNEMXUD0clyXE3p6pZA0S2nnvTlXwLJEZWlb7cTQH1+USgTN4VhAenm/wea1OCAOmqo6fE1WCb9WSKBah+rbUWPWAmE2Rvk0ApiB45eOyNAzU8xcTvj8KvkKEoOaIYeHNA3ZuygAvFMUO0AAAAASUVORK5CYII=";
        break;
      case "external_person":
        personImg = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAIAAADYYG7QAAAB6ElEQVR4Xu2YLY+EMBCG9+dWr0aj0Wg0Go1Go0+j8Xdv2uTCvv1gpt0ebHKPuhDaeW4605Z9mJvx4AdXUyTUdd08z+u6flmWZRnHsWkafk9DptAwDPu+f0eAYtu2PEaGWuj5fCIZrBAC2eLBAnRCsEkkxmeaJp7iDJ2QMDdHsLg8SxKFEJaAo8lAXnmuOFIhTMpxxKATebo4UiFknuNo4OniSIXQyRxEA3YsnjGCVEjVXD7yLUAqxBGUyPv/Y4W2beMgGuS7kVQIBycH0fD+oi5pezQETxdHKmQKGk1eQEYldK+jw5GxPfZ9z7Mk0Qnhf1W1m3w//EUn5BDmSZsbR44QQLBEqrBHqOrmSKaQAxdnLArCrxZcM7A7ZKs4ioRq8LFC+NpC3WCBJsvpVw5edm9iEXFuyNfxXAgSwfrFQ1c0iNda8AdejvUgnktOtJQQxmcfFzGglc5WVCj7oDgFqU18boeFSs52CUh8LE8BIVQDT1ABrB0HtgSEYlX5doJnCwv9TXocKCaKbnwhdDKPq4lf3SwU3HLq4V/+WYhHVMa/3b4IlfyikAduCkcBc7mQ3/z/Qq/cTuikhkzB12Ae/mcJC9U+Vo8Ej1gWAtgbeGgFsAMHr50BIWOLCbezvhpBFUdY6EJuJ/QDW0XoMX60zZ0AAAAASUVORK5CYII=";
        break;
    }
    const c4ShapeElem = elem.append("g");
    c4ShapeElem.attr("class", "person-man");
    const rect2 = getNoteRect$2();
    switch (c4Shape.typeC4Shape.text) {
      case "person":
      case "external_person":
      case "system":
      case "external_system":
      case "container":
      case "external_container":
      case "component":
      case "external_component":
        rect2.x = c4Shape.x;
        rect2.y = c4Shape.y;
        rect2.fill = fillColor;
        rect2.width = c4Shape.width;
        rect2.height = c4Shape.height;
        rect2.stroke = strokeColor;
        rect2.rx = 2.5;
        rect2.ry = 2.5;
        rect2.attrs = { "stroke-width": 0.5 };
        drawRect$3(c4ShapeElem, rect2);
        break;
      case "system_db":
      case "external_system_db":
      case "container_db":
      case "external_container_db":
      case "component_db":
      case "external_component_db":
        c4ShapeElem.append("path").attr("fill", fillColor).attr("stroke-width", "0.5").attr("stroke", strokeColor).attr(
          "d",
          "Mstartx,startyc0,-10 half,-10 half,-10c0,0 half,0 half,10l0,heightc0,10 -half,10 -half,10c0,0 -half,0 -half,-10l0,-height".replaceAll("startx", c4Shape.x).replaceAll("starty", c4Shape.y).replaceAll("half", c4Shape.width / 2).replaceAll("height", c4Shape.height)
        );
        c4ShapeElem.append("path").attr("fill", "none").attr("stroke-width", "0.5").attr("stroke", strokeColor).attr(
          "d",
          "Mstartx,startyc0,10 half,10 half,10c0,0 half,0 half,-10".replaceAll("startx", c4Shape.x).replaceAll("starty", c4Shape.y).replaceAll("half", c4Shape.width / 2)
        );
        break;
      case "system_queue":
      case "external_system_queue":
      case "container_queue":
      case "external_container_queue":
      case "component_queue":
      case "external_component_queue":
        c4ShapeElem.append("path").attr("fill", fillColor).attr("stroke-width", "0.5").attr("stroke", strokeColor).attr(
          "d",
          "Mstartx,startylwidth,0c5,0 5,half 5,halfc0,0 0,half -5,halfl-width,0c-5,0 -5,-half -5,-halfc0,0 0,-half 5,-half".replaceAll("startx", c4Shape.x).replaceAll("starty", c4Shape.y).replaceAll("width", c4Shape.width).replaceAll("half", c4Shape.height / 2)
        );
        c4ShapeElem.append("path").attr("fill", "none").attr("stroke-width", "0.5").attr("stroke", strokeColor).attr(
          "d",
          "Mstartx,startyc-5,0 -5,half -5,halfc0,half 5,half 5,half".replaceAll("startx", c4Shape.x + c4Shape.width).replaceAll("starty", c4Shape.y).replaceAll("half", c4Shape.height / 2)
        );
        break;
    }
    let c4ShapeFontConf = getC4ShapeFont(conf2, c4Shape.typeC4Shape.text);
    c4ShapeElem.append("text").attr("fill", fontColor).attr("font-family", c4ShapeFontConf.fontFamily).attr("font-size", c4ShapeFontConf.fontSize - 2).attr("font-style", "italic").attr("lengthAdjust", "spacing").attr("textLength", c4Shape.typeC4Shape.width).attr("x", c4Shape.x + c4Shape.width / 2 - c4Shape.typeC4Shape.width / 2).attr("y", c4Shape.y + c4Shape.typeC4Shape.Y).text("<<" + c4Shape.typeC4Shape.text + ">>");
    switch (c4Shape.typeC4Shape.text) {
      case "person":
      case "external_person":
        drawImage(
          c4ShapeElem,
          48,
          48,
          c4Shape.x + c4Shape.width / 2 - 24,
          c4Shape.y + c4Shape.image.Y,
          personImg
        );
        break;
    }
    let textFontConf = conf2[c4Shape.typeC4Shape.text + "Font"]();
    textFontConf.fontWeight = "bold";
    textFontConf.fontSize = textFontConf.fontSize + 2;
    textFontConf.fontColor = fontColor;
    _drawTextCandidateFunc$3(conf2)(
      c4Shape.label.text,
      c4ShapeElem,
      c4Shape.x,
      c4Shape.y + c4Shape.label.Y,
      c4Shape.width,
      c4Shape.height,
      { fill: fontColor },
      textFontConf
    );
    textFontConf = conf2[c4Shape.typeC4Shape.text + "Font"]();
    textFontConf.fontColor = fontColor;
    if (c4Shape.techn && ((_a = c4Shape.techn) == null ? void 0 : _a.text) !== "") {
      _drawTextCandidateFunc$3(conf2)(
        c4Shape.techn.text,
        c4ShapeElem,
        c4Shape.x,
        c4Shape.y + c4Shape.techn.Y,
        c4Shape.width,
        c4Shape.height,
        { fill: fontColor, "font-style": "italic" },
        textFontConf
      );
    } else if (c4Shape.type && c4Shape.type.text !== "") {
      _drawTextCandidateFunc$3(conf2)(
        c4Shape.type.text,
        c4ShapeElem,
        c4Shape.x,
        c4Shape.y + c4Shape.type.Y,
        c4Shape.width,
        c4Shape.height,
        { fill: fontColor, "font-style": "italic" },
        textFontConf
      );
    }
    if (c4Shape.descr && c4Shape.descr.text !== "") {
      textFontConf = conf2.personFont();
      textFontConf.fontColor = fontColor;
      _drawTextCandidateFunc$3(conf2)(
        c4Shape.descr.text,
        c4ShapeElem,
        c4Shape.x,
        c4Shape.y + c4Shape.descr.Y,
        c4Shape.width,
        c4Shape.height,
        { fill: fontColor },
        textFontConf
      );
    }
    return c4Shape.height;
  };
  const insertDatabaseIcon$1 = function(elem) {
    elem.append("defs").append("symbol").attr("id", "database").attr("fill-rule", "evenodd").attr("clip-rule", "evenodd").append("path").attr("transform", "scale(.5)").attr(
      "d",
      "M12.258.001l.256.004.255.005.253.008.251.01.249.012.247.015.246.016.242.019.241.02.239.023.236.024.233.027.231.028.229.031.225.032.223.034.22.036.217.038.214.04.211.041.208.043.205.045.201.046.198.048.194.05.191.051.187.053.183.054.18.056.175.057.172.059.168.06.163.061.16.063.155.064.15.066.074.033.073.033.071.034.07.034.069.035.068.035.067.035.066.035.064.036.064.036.062.036.06.036.06.037.058.037.058.037.055.038.055.038.053.038.052.038.051.039.05.039.048.039.047.039.045.04.044.04.043.04.041.04.04.041.039.041.037.041.036.041.034.041.033.042.032.042.03.042.029.042.027.042.026.043.024.043.023.043.021.043.02.043.018.044.017.043.015.044.013.044.012.044.011.045.009.044.007.045.006.045.004.045.002.045.001.045v17l-.001.045-.002.045-.004.045-.006.045-.007.045-.009.044-.011.045-.012.044-.013.044-.015.044-.017.043-.018.044-.02.043-.021.043-.023.043-.024.043-.026.043-.027.042-.029.042-.03.042-.032.042-.033.042-.034.041-.036.041-.037.041-.039.041-.04.041-.041.04-.043.04-.044.04-.045.04-.047.039-.048.039-.05.039-.051.039-.052.038-.053.038-.055.038-.055.038-.058.037-.058.037-.06.037-.06.036-.062.036-.064.036-.064.036-.066.035-.067.035-.068.035-.069.035-.07.034-.071.034-.073.033-.074.033-.15.066-.155.064-.16.063-.163.061-.168.06-.172.059-.175.057-.18.056-.183.054-.187.053-.191.051-.194.05-.198.048-.201.046-.205.045-.208.043-.211.041-.214.04-.217.038-.22.036-.223.034-.225.032-.229.031-.231.028-.233.027-.236.024-.239.023-.241.02-.242.019-.246.016-.247.015-.249.012-.251.01-.253.008-.255.005-.256.004-.258.001-.258-.001-.256-.004-.255-.005-.253-.008-.251-.01-.249-.012-.247-.015-.245-.016-.243-.019-.241-.02-.238-.023-.236-.024-.234-.027-.231-.028-.228-.031-.226-.032-.223-.034-.22-.036-.217-.038-.214-.04-.211-.041-.208-.043-.204-.045-.201-.046-.198-.048-.195-.05-.19-.051-.187-.053-.184-.054-.179-.056-.176-.057-.172-.059-.167-.06-.164-.061-.159-.063-.155-.064-.151-.066-.074-.033-.072-.033-.072-.034-.07-.034-.069-.035-.068-.035-.067-.035-.066-.035-.064-.036-.063-.036-.062-.036-.061-.036-.06-.037-.058-.037-.057-.037-.056-.038-.055-.038-.053-.038-.052-.038-.051-.039-.049-.039-.049-.039-.046-.039-.046-.04-.044-.04-.043-.04-.041-.04-.04-.041-.039-.041-.037-.041-.036-.041-.034-.041-.033-.042-.032-.042-.03-.042-.029-.042-.027-.042-.026-.043-.024-.043-.023-.043-.021-.043-.02-.043-.018-.044-.017-.043-.015-.044-.013-.044-.012-.044-.011-.045-.009-.044-.007-.045-.006-.045-.004-.045-.002-.045-.001-.045v-17l.001-.045.002-.045.004-.045.006-.045.007-.045.009-.044.011-.045.012-.044.013-.044.015-.044.017-.043.018-.044.02-.043.021-.043.023-.043.024-.043.026-.043.027-.042.029-.042.03-.042.032-.042.033-.042.034-.041.036-.041.037-.041.039-.041.04-.041.041-.04.043-.04.044-.04.046-.04.046-.039.049-.039.049-.039.051-.039.052-.038.053-.038.055-.038.056-.038.057-.037.058-.037.06-.037.061-.036.062-.036.063-.036.064-.036.066-.035.067-.035.068-.035.069-.035.07-.034.072-.034.072-.033.074-.033.151-.066.155-.064.159-.063.164-.061.167-.06.172-.059.176-.057.179-.056.184-.054.187-.053.19-.051.195-.05.198-.048.201-.046.204-.045.208-.043.211-.041.214-.04.217-.038.22-.036.223-.034.226-.032.228-.031.231-.028.234-.027.236-.024.238-.023.241-.02.243-.019.245-.016.247-.015.249-.012.251-.01.253-.008.255-.005.256-.004.258-.001.258.001zm-9.258 20.499v.01l.001.021.003.021.004.022.005.021.006.022.007.022.009.023.01.022.011.023.012.023.013.023.015.023.016.024.017.023.018.024.019.024.021.024.022.025.023.024.024.025.052.049.056.05.061.051.066.051.07.051.075.051.079.052.084.052.088.052.092.052.097.052.102.051.105.052.11.052.114.051.119.051.123.051.127.05.131.05.135.05.139.048.144.049.147.047.152.047.155.047.16.045.163.045.167.043.171.043.176.041.178.041.183.039.187.039.19.037.194.035.197.035.202.033.204.031.209.03.212.029.216.027.219.025.222.024.226.021.23.02.233.018.236.016.24.015.243.012.246.01.249.008.253.005.256.004.259.001.26-.001.257-.004.254-.005.25-.008.247-.011.244-.012.241-.014.237-.016.233-.018.231-.021.226-.021.224-.024.22-.026.216-.027.212-.028.21-.031.205-.031.202-.034.198-.034.194-.036.191-.037.187-.039.183-.04.179-.04.175-.042.172-.043.168-.044.163-.045.16-.046.155-.046.152-.047.148-.048.143-.049.139-.049.136-.05.131-.05.126-.05.123-.051.118-.052.114-.051.11-.052.106-.052.101-.052.096-.052.092-.052.088-.053.083-.051.079-.052.074-.052.07-.051.065-.051.06-.051.056-.05.051-.05.023-.024.023-.025.021-.024.02-.024.019-.024.018-.024.017-.024.015-.023.014-.024.013-.023.012-.023.01-.023.01-.022.008-.022.006-.022.006-.022.004-.022.004-.021.001-.021.001-.021v-4.127l-.077.055-.08.053-.083.054-.085.053-.087.052-.09.052-.093.051-.095.05-.097.05-.1.049-.102.049-.105.048-.106.047-.109.047-.111.046-.114.045-.115.045-.118.044-.12.043-.122.042-.124.042-.126.041-.128.04-.13.04-.132.038-.134.038-.135.037-.138.037-.139.035-.142.035-.143.034-.144.033-.147.032-.148.031-.15.03-.151.03-.153.029-.154.027-.156.027-.158.026-.159.025-.161.024-.162.023-.163.022-.165.021-.166.02-.167.019-.169.018-.169.017-.171.016-.173.015-.173.014-.175.013-.175.012-.177.011-.178.01-.179.008-.179.008-.181.006-.182.005-.182.004-.184.003-.184.002h-.37l-.184-.002-.184-.003-.182-.004-.182-.005-.181-.006-.179-.008-.179-.008-.178-.01-.176-.011-.176-.012-.175-.013-.173-.014-.172-.015-.171-.016-.17-.017-.169-.018-.167-.019-.166-.02-.165-.021-.163-.022-.162-.023-.161-.024-.159-.025-.157-.026-.156-.027-.155-.027-.153-.029-.151-.03-.15-.03-.148-.031-.146-.032-.145-.033-.143-.034-.141-.035-.14-.035-.137-.037-.136-.037-.134-.038-.132-.038-.13-.04-.128-.04-.126-.041-.124-.042-.122-.042-.12-.044-.117-.043-.116-.045-.113-.045-.112-.046-.109-.047-.106-.047-.105-.048-.102-.049-.1-.049-.097-.05-.095-.05-.093-.052-.09-.051-.087-.052-.085-.053-.083-.054-.08-.054-.077-.054v4.127zm0-5.654v.011l.001.021.003.021.004.021.005.022.006.022.007.022.009.022.01.022.011.023.012.023.013.023.015.024.016.023.017.024.018.024.019.024.021.024.022.024.023.025.024.024.052.05.056.05.061.05.066.051.07.051.075.052.079.051.084.052.088.052.092.052.097.052.102.052.105.052.11.051.114.051.119.052.123.05.127.051.131.05.135.049.139.049.144.048.147.048.152.047.155.046.16.045.163.045.167.044.171.042.176.042.178.04.183.04.187.038.19.037.194.036.197.034.202.033.204.032.209.03.212.028.216.027.219.025.222.024.226.022.23.02.233.018.236.016.24.014.243.012.246.01.249.008.253.006.256.003.259.001.26-.001.257-.003.254-.006.25-.008.247-.01.244-.012.241-.015.237-.016.233-.018.231-.02.226-.022.224-.024.22-.025.216-.027.212-.029.21-.03.205-.032.202-.033.198-.035.194-.036.191-.037.187-.039.183-.039.179-.041.175-.042.172-.043.168-.044.163-.045.16-.045.155-.047.152-.047.148-.048.143-.048.139-.05.136-.049.131-.05.126-.051.123-.051.118-.051.114-.052.11-.052.106-.052.101-.052.096-.052.092-.052.088-.052.083-.052.079-.052.074-.051.07-.052.065-.051.06-.05.056-.051.051-.049.023-.025.023-.024.021-.025.02-.024.019-.024.018-.024.017-.024.015-.023.014-.023.013-.024.012-.022.01-.023.01-.023.008-.022.006-.022.006-.022.004-.021.004-.022.001-.021.001-.021v-4.139l-.077.054-.08.054-.083.054-.085.052-.087.053-.09.051-.093.051-.095.051-.097.05-.1.049-.102.049-.105.048-.106.047-.109.047-.111.046-.114.045-.115.044-.118.044-.12.044-.122.042-.124.042-.126.041-.128.04-.13.039-.132.039-.134.038-.135.037-.138.036-.139.036-.142.035-.143.033-.144.033-.147.033-.148.031-.15.03-.151.03-.153.028-.154.028-.156.027-.158.026-.159.025-.161.024-.162.023-.163.022-.165.021-.166.02-.167.019-.169.018-.169.017-.171.016-.173.015-.173.014-.175.013-.175.012-.177.011-.178.009-.179.009-.179.007-.181.007-.182.005-.182.004-.184.003-.184.002h-.37l-.184-.002-.184-.003-.182-.004-.182-.005-.181-.007-.179-.007-.179-.009-.178-.009-.176-.011-.176-.012-.175-.013-.173-.014-.172-.015-.171-.016-.17-.017-.169-.018-.167-.019-.166-.02-.165-.021-.163-.022-.162-.023-.161-.024-.159-.025-.157-.026-.156-.027-.155-.028-.153-.028-.151-.03-.15-.03-.148-.031-.146-.033-.145-.033-.143-.033-.141-.035-.14-.036-.137-.036-.136-.037-.134-.038-.132-.039-.13-.039-.128-.04-.126-.041-.124-.042-.122-.043-.12-.043-.117-.044-.116-.044-.113-.046-.112-.046-.109-.046-.106-.047-.105-.048-.102-.049-.1-.049-.097-.05-.095-.051-.093-.051-.09-.051-.087-.053-.085-.052-.083-.054-.08-.054-.077-.054v4.139zm0-5.666v.011l.001.02.003.022.004.021.005.022.006.021.007.022.009.023.01.022.011.023.012.023.013.023.015.023.016.024.017.024.018.023.019.024.021.025.022.024.023.024.024.025.052.05.056.05.061.05.066.051.07.051.075.052.079.051.084.052.088.052.092.052.097.052.102.052.105.051.11.052.114.051.119.051.123.051.127.05.131.05.135.05.139.049.144.048.147.048.152.047.155.046.16.045.163.045.167.043.171.043.176.042.178.04.183.04.187.038.19.037.194.036.197.034.202.033.204.032.209.03.212.028.216.027.219.025.222.024.226.021.23.02.233.018.236.017.24.014.243.012.246.01.249.008.253.006.256.003.259.001.26-.001.257-.003.254-.006.25-.008.247-.01.244-.013.241-.014.237-.016.233-.018.231-.02.226-.022.224-.024.22-.025.216-.027.212-.029.21-.03.205-.032.202-.033.198-.035.194-.036.191-.037.187-.039.183-.039.179-.041.175-.042.172-.043.168-.044.163-.045.16-.045.155-.047.152-.047.148-.048.143-.049.139-.049.136-.049.131-.051.126-.05.123-.051.118-.052.114-.051.11-.052.106-.052.101-.052.096-.052.092-.052.088-.052.083-.052.079-.052.074-.052.07-.051.065-.051.06-.051.056-.05.051-.049.023-.025.023-.025.021-.024.02-.024.019-.024.018-.024.017-.024.015-.023.014-.024.013-.023.012-.023.01-.022.01-.023.008-.022.006-.022.006-.022.004-.022.004-.021.001-.021.001-.021v-4.153l-.077.054-.08.054-.083.053-.085.053-.087.053-.09.051-.093.051-.095.051-.097.05-.1.049-.102.048-.105.048-.106.048-.109.046-.111.046-.114.046-.115.044-.118.044-.12.043-.122.043-.124.042-.126.041-.128.04-.13.039-.132.039-.134.038-.135.037-.138.036-.139.036-.142.034-.143.034-.144.033-.147.032-.148.032-.15.03-.151.03-.153.028-.154.028-.156.027-.158.026-.159.024-.161.024-.162.023-.163.023-.165.021-.166.02-.167.019-.169.018-.169.017-.171.016-.173.015-.173.014-.175.013-.175.012-.177.01-.178.01-.179.009-.179.007-.181.006-.182.006-.182.004-.184.003-.184.001-.185.001-.185-.001-.184-.001-.184-.003-.182-.004-.182-.006-.181-.006-.179-.007-.179-.009-.178-.01-.176-.01-.176-.012-.175-.013-.173-.014-.172-.015-.171-.016-.17-.017-.169-.018-.167-.019-.166-.02-.165-.021-.163-.023-.162-.023-.161-.024-.159-.024-.157-.026-.156-.027-.155-.028-.153-.028-.151-.03-.15-.03-.148-.032-.146-.032-.145-.033-.143-.034-.141-.034-.14-.036-.137-.036-.136-.037-.134-.038-.132-.039-.13-.039-.128-.041-.126-.041-.124-.041-.122-.043-.12-.043-.117-.044-.116-.044-.113-.046-.112-.046-.109-.046-.106-.048-.105-.048-.102-.048-.1-.05-.097-.049-.095-.051-.093-.051-.09-.052-.087-.052-.085-.053-.083-.053-.08-.054-.077-.054v4.153zm8.74-8.179l-.257.004-.254.005-.25.008-.247.011-.244.012-.241.014-.237.016-.233.018-.231.021-.226.022-.224.023-.22.026-.216.027-.212.028-.21.031-.205.032-.202.033-.198.034-.194.036-.191.038-.187.038-.183.04-.179.041-.175.042-.172.043-.168.043-.163.045-.16.046-.155.046-.152.048-.148.048-.143.048-.139.049-.136.05-.131.05-.126.051-.123.051-.118.051-.114.052-.11.052-.106.052-.101.052-.096.052-.092.052-.088.052-.083.052-.079.052-.074.051-.07.052-.065.051-.06.05-.056.05-.051.05-.023.025-.023.024-.021.024-.02.025-.019.024-.018.024-.017.023-.015.024-.014.023-.013.023-.012.023-.01.023-.01.022-.008.022-.006.023-.006.021-.004.022-.004.021-.001.021-.001.021.001.021.001.021.004.021.004.022.006.021.006.023.008.022.01.022.01.023.012.023.013.023.014.023.015.024.017.023.018.024.019.024.02.025.021.024.023.024.023.025.051.05.056.05.06.05.065.051.07.052.074.051.079.052.083.052.088.052.092.052.096.052.101.052.106.052.11.052.114.052.118.051.123.051.126.051.131.05.136.05.139.049.143.048.148.048.152.048.155.046.16.046.163.045.168.043.172.043.175.042.179.041.183.04.187.038.191.038.194.036.198.034.202.033.205.032.21.031.212.028.216.027.22.026.224.023.226.022.231.021.233.018.237.016.241.014.244.012.247.011.25.008.254.005.257.004.26.001.26-.001.257-.004.254-.005.25-.008.247-.011.244-.012.241-.014.237-.016.233-.018.231-.021.226-.022.224-.023.22-.026.216-.027.212-.028.21-.031.205-.032.202-.033.198-.034.194-.036.191-.038.187-.038.183-.04.179-.041.175-.042.172-.043.168-.043.163-.045.16-.046.155-.046.152-.048.148-.048.143-.048.139-.049.136-.05.131-.05.126-.051.123-.051.118-.051.114-.052.11-.052.106-.052.101-.052.096-.052.092-.052.088-.052.083-.052.079-.052.074-.051.07-.052.065-.051.06-.05.056-.05.051-.05.023-.025.023-.024.021-.024.02-.025.019-.024.018-.024.017-.023.015-.024.014-.023.013-.023.012-.023.01-.023.01-.022.008-.022.006-.023.006-.021.004-.022.004-.021.001-.021.001-.021-.001-.021-.001-.021-.004-.021-.004-.022-.006-.021-.006-.023-.008-.022-.01-.022-.01-.023-.012-.023-.013-.023-.014-.023-.015-.024-.017-.023-.018-.024-.019-.024-.02-.025-.021-.024-.023-.024-.023-.025-.051-.05-.056-.05-.06-.05-.065-.051-.07-.052-.074-.051-.079-.052-.083-.052-.088-.052-.092-.052-.096-.052-.101-.052-.106-.052-.11-.052-.114-.052-.118-.051-.123-.051-.126-.051-.131-.05-.136-.05-.139-.049-.143-.048-.148-.048-.152-.048-.155-.046-.16-.046-.163-.045-.168-.043-.172-.043-.175-.042-.179-.041-.183-.04-.187-.038-.191-.038-.194-.036-.198-.034-.202-.033-.205-.032-.21-.031-.212-.028-.216-.027-.22-.026-.224-.023-.226-.022-.231-.021-.233-.018-.237-.016-.241-.014-.244-.012-.247-.011-.25-.008-.254-.005-.257-.004-.26-.001-.26.001z"
    );
  };
  const insertComputerIcon$1 = function(elem) {
    elem.append("defs").append("symbol").attr("id", "computer").attr("width", "24").attr("height", "24").append("path").attr("transform", "scale(.5)").attr(
      "d",
      "M2 2v13h20v-13h-20zm18 11h-16v-9h16v9zm-10.228 6l.466-1h3.524l.467 1h-4.457zm14.228 3h-24l2-6h2.104l-1.33 4h18.45l-1.297-4h2.073l2 6zm-5-10h-14v-7h14v7z"
    );
  };
  const insertClockIcon$1 = function(elem) {
    elem.append("defs").append("symbol").attr("id", "clock").attr("width", "24").attr("height", "24").append("path").attr("transform", "scale(.5)").attr(
      "d",
      "M12 2c5.514 0 10 4.486 10 10s-4.486 10-10 10-10-4.486-10-10 4.486-10 10-10zm0-2c-6.627 0-12 5.373-12 12s5.373 12 12 12 12-5.373 12-12-5.373-12-12-12zm5.848 12.459c.202.038.202.333.001.372-1.907.361-6.045 1.111-6.547 1.111-.719 0-1.301-.582-1.301-1.301 0-.512.77-5.447 1.125-7.445.034-.192.312-.181.343.014l.985 6.238 5.394 1.011z"
    );
  };
  const insertArrowHead$1 = function(elem) {
    elem.append("defs").append("marker").attr("id", "arrowhead").attr("refX", 9).attr("refY", 5).attr("markerUnits", "userSpaceOnUse").attr("markerWidth", 12).attr("markerHeight", 12).attr("orient", "auto").append("path").attr("d", "M 0 0 L 10 5 L 0 10 z");
  };
  const insertArrowEnd = function(elem) {
    elem.append("defs").append("marker").attr("id", "arrowend").attr("refX", 1).attr("refY", 5).attr("markerUnits", "userSpaceOnUse").attr("markerWidth", 12).attr("markerHeight", 12).attr("orient", "auto").append("path").attr("d", "M 10 0 L 0 5 L 10 10 z");
  };
  const insertArrowFilledHead$1 = function(elem) {
    elem.append("defs").append("marker").attr("id", "filled-head").attr("refX", 18).attr("refY", 7).attr("markerWidth", 20).attr("markerHeight", 28).attr("orient", "auto").append("path").attr("d", "M 18,7 L9,13 L14,7 L9,1 Z");
  };
  const insertDynamicNumber = function(elem) {
    elem.append("defs").append("marker").attr("id", "sequencenumber").attr("refX", 15).attr("refY", 15).attr("markerWidth", 60).attr("markerHeight", 40).attr("orient", "auto").append("circle").attr("cx", 15).attr("cy", 15).attr("r", 6);
  };
  const insertArrowCrossHead$1 = function(elem) {
    const defs = elem.append("defs");
    const marker = defs.append("marker").attr("id", "crosshead").attr("markerWidth", 15).attr("markerHeight", 8).attr("orient", "auto").attr("refX", 16).attr("refY", 4);
    marker.append("path").attr("fill", "black").attr("stroke", "#000000").style("stroke-dasharray", "0, 0").attr("stroke-width", "1px").attr("d", "M 9,2 V 6 L16,4 Z");
    marker.append("path").attr("fill", "none").attr("stroke", "#000000").style("stroke-dasharray", "0, 0").attr("stroke-width", "1px").attr("d", "M 0,1 L 6,7 M 6,1 L 0,7");
  };
  const getC4ShapeFont = (cnf, typeC4Shape) => {
    return {
      fontFamily: cnf[typeC4Shape + "FontFamily"],
      fontSize: cnf[typeC4Shape + "FontSize"],
      fontWeight: cnf[typeC4Shape + "FontWeight"]
    };
  };
  const _drawTextCandidateFunc$3 = function() {
    function byText(content2, g, x2, y2, width2, height2, textAttrs) {
      const text2 = g.append("text").attr("x", x2 + width2 / 2).attr("y", y2 + height2 / 2 + 5).style("text-anchor", "middle").text(content2);
      _setTextAttrs(text2, textAttrs);
    }
    function byTspan(content2, g, x2, y2, width2, height2, textAttrs, conf2) {
      const { fontSize, fontFamily, fontWeight } = conf2;
      const lines = content2.split(common$1.lineBreakRegex);
      for (let i2 = 0; i2 < lines.length; i2++) {
        const dy = i2 * fontSize - fontSize * (lines.length - 1) / 2;
        const text2 = g.append("text").attr("x", x2 + width2 / 2).attr("y", y2).style("text-anchor", "middle").attr("dominant-baseline", "middle").style("font-size", fontSize).style("font-weight", fontWeight).style("font-family", fontFamily);
        text2.append("tspan").attr("dy", dy).text(lines[i2]).attr("alignment-baseline", "mathematical");
        _setTextAttrs(text2, textAttrs);
      }
    }
    function byFo(content2, g, x2, y2, width2, height2, textAttrs, conf2) {
      const s = g.append("switch");
      const f2 = s.append("foreignObject").attr("x", x2).attr("y", y2).attr("width", width2).attr("height", height2);
      const text2 = f2.append("xhtml:div").style("display", "table").style("height", "100%").style("width", "100%");
      text2.append("div").style("display", "table-cell").style("text-align", "center").style("vertical-align", "middle").text(content2);
      byTspan(content2, s, x2, y2, width2, height2, textAttrs, conf2);
      _setTextAttrs(text2, textAttrs);
    }
    function _setTextAttrs(toText, fromTextAttrsDict) {
      for (const key in fromTextAttrsDict) {
        if (fromTextAttrsDict.hasOwnProperty(key)) {
          toText.attr(key, fromTextAttrsDict[key]);
        }
      }
    }
    return function(conf2) {
      return conf2.textPlacement === "fo" ? byFo : conf2.textPlacement === "old" ? byText : byTspan;
    };
  }();
  const svgDraw$5 = {
    drawRect: drawRect$3,
    drawBoundary: drawBoundary$1,
    drawC4Shape,
    drawRels: drawRels$1,
    drawImage,
    insertArrowHead: insertArrowHead$1,
    insertArrowEnd,
    insertArrowFilledHead: insertArrowFilledHead$1,
    insertDynamicNumber,
    insertArrowCrossHead: insertArrowCrossHead$1,
    insertDatabaseIcon: insertDatabaseIcon$1,
    insertComputerIcon: insertComputerIcon$1,
    insertClockIcon: insertClockIcon$1
  };
  let globalBoundaryMaxX = 0, globalBoundaryMaxY = 0;
  let c4ShapeInRow = 4;
  let c4BoundaryInRow = 2;
  parser$o.yy = c4Db;
  let conf$a = {};
  class Bounds {
    constructor(diagObj) {
      this.name = "";
      this.data = {};
      this.data.startx = void 0;
      this.data.stopx = void 0;
      this.data.starty = void 0;
      this.data.stopy = void 0;
      this.data.widthLimit = void 0;
      this.nextData = {};
      this.nextData.startx = void 0;
      this.nextData.stopx = void 0;
      this.nextData.starty = void 0;
      this.nextData.stopy = void 0;
      this.nextData.cnt = 0;
      setConf$9(diagObj.db.getConfig());
    }
    setData(startx, stopx, starty, stopy) {
      this.nextData.startx = this.data.startx = startx;
      this.nextData.stopx = this.data.stopx = stopx;
      this.nextData.starty = this.data.starty = starty;
      this.nextData.stopy = this.data.stopy = stopy;
    }
    updateVal(obj, key, val, fun) {
      if (obj[key] === void 0) {
        obj[key] = val;
      } else {
        obj[key] = fun(val, obj[key]);
      }
    }
    insert(c4Shape) {
      this.nextData.cnt = this.nextData.cnt + 1;
      let _startx = this.nextData.startx === this.nextData.stopx ? this.nextData.stopx + c4Shape.margin : this.nextData.stopx + c4Shape.margin * 2;
      let _stopx = _startx + c4Shape.width;
      let _starty = this.nextData.starty + c4Shape.margin * 2;
      let _stopy = _starty + c4Shape.height;
      if (_startx >= this.data.widthLimit || _stopx >= this.data.widthLimit || this.nextData.cnt > c4ShapeInRow) {
        _startx = this.nextData.startx + c4Shape.margin + conf$a.nextLinePaddingX;
        _starty = this.nextData.stopy + c4Shape.margin * 2;
        this.nextData.stopx = _stopx = _startx + c4Shape.width;
        this.nextData.starty = this.nextData.stopy;
        this.nextData.stopy = _stopy = _starty + c4Shape.height;
        this.nextData.cnt = 1;
      }
      c4Shape.x = _startx;
      c4Shape.y = _starty;
      this.updateVal(this.data, "startx", _startx, Math.min);
      this.updateVal(this.data, "starty", _starty, Math.min);
      this.updateVal(this.data, "stopx", _stopx, Math.max);
      this.updateVal(this.data, "stopy", _stopy, Math.max);
      this.updateVal(this.nextData, "startx", _startx, Math.min);
      this.updateVal(this.nextData, "starty", _starty, Math.min);
      this.updateVal(this.nextData, "stopx", _stopx, Math.max);
      this.updateVal(this.nextData, "stopy", _stopy, Math.max);
    }
    init(diagObj) {
      this.name = "";
      this.data = {
        startx: void 0,
        stopx: void 0,
        starty: void 0,
        stopy: void 0,
        widthLimit: void 0
      };
      this.nextData = {
        startx: void 0,
        stopx: void 0,
        starty: void 0,
        stopy: void 0,
        cnt: 0
      };
      setConf$9(diagObj.db.getConfig());
    }
    bumpLastMargin(margin) {
      this.data.stopx += margin;
      this.data.stopy += margin;
    }
  }
  const setConf$9 = function(cnf) {
    assignWithDepth$1(conf$a, cnf);
    if (cnf.fontFamily) {
      conf$a.personFontFamily = conf$a.systemFontFamily = conf$a.messageFontFamily = cnf.fontFamily;
    }
    if (cnf.fontSize) {
      conf$a.personFontSize = conf$a.systemFontSize = conf$a.messageFontSize = cnf.fontSize;
    }
    if (cnf.fontWeight) {
      conf$a.personFontWeight = conf$a.systemFontWeight = conf$a.messageFontWeight = cnf.fontWeight;
    }
  };
  const c4ShapeFont = (cnf, typeC4Shape) => {
    return {
      fontFamily: cnf[typeC4Shape + "FontFamily"],
      fontSize: cnf[typeC4Shape + "FontSize"],
      fontWeight: cnf[typeC4Shape + "FontWeight"]
    };
  };
  const boundaryFont = (cnf) => {
    return {
      fontFamily: cnf.boundaryFontFamily,
      fontSize: cnf.boundaryFontSize,
      fontWeight: cnf.boundaryFontWeight
    };
  };
  const messageFont$1 = (cnf) => {
    return {
      fontFamily: cnf.messageFontFamily,
      fontSize: cnf.messageFontSize,
      fontWeight: cnf.messageFontWeight
    };
  };
  function calcC4ShapeTextWH(textType, c4Shape, c4ShapeTextWrap, textConf, textLimitWidth) {
    if (!c4Shape[textType].width) {
      if (c4ShapeTextWrap) {
        c4Shape[textType].text = wrapLabel(c4Shape[textType].text, textLimitWidth, textConf);
        c4Shape[textType].textLines = c4Shape[textType].text.split(common$1.lineBreakRegex).length;
        c4Shape[textType].width = textLimitWidth;
        c4Shape[textType].height = calculateTextHeight(c4Shape[textType].text, textConf);
      } else {
        let lines = c4Shape[textType].text.split(common$1.lineBreakRegex);
        c4Shape[textType].textLines = lines.length;
        let lineHeight = 0;
        c4Shape[textType].height = 0;
        c4Shape[textType].width = 0;
        for (const line2 of lines) {
          c4Shape[textType].width = Math.max(
            calculateTextWidth(line2, textConf),
            c4Shape[textType].width
          );
          lineHeight = calculateTextHeight(line2, textConf);
          c4Shape[textType].height = c4Shape[textType].height + lineHeight;
        }
      }
    }
  }
  const drawBoundary = function(diagram2, boundary, bounds2) {
    boundary.x = bounds2.data.startx;
    boundary.y = bounds2.data.starty;
    boundary.width = bounds2.data.stopx - bounds2.data.startx;
    boundary.height = bounds2.data.stopy - bounds2.data.starty;
    boundary.label.y = conf$a.c4ShapeMargin - 35;
    let boundaryTextWrap = boundary.wrap && conf$a.wrap;
    let boundaryLabelConf = boundaryFont(conf$a);
    boundaryLabelConf.fontSize = boundaryLabelConf.fontSize + 2;
    boundaryLabelConf.fontWeight = "bold";
    let textLimitWidth = calculateTextWidth(boundary.label.text, boundaryLabelConf);
    calcC4ShapeTextWH("label", boundary, boundaryTextWrap, boundaryLabelConf, textLimitWidth);
    svgDraw$5.drawBoundary(diagram2, boundary, conf$a);
  };
  const drawC4ShapeArray = function(currentBounds, diagram2, c4ShapeArray2, c4ShapeKeys) {
    let Y = 0;
    for (const c4ShapeKey of c4ShapeKeys) {
      Y = 0;
      const c4Shape = c4ShapeArray2[c4ShapeKey];
      let c4ShapeTypeConf = c4ShapeFont(conf$a, c4Shape.typeC4Shape.text);
      c4ShapeTypeConf.fontSize = c4ShapeTypeConf.fontSize - 2;
      c4Shape.typeC4Shape.width = calculateTextWidth(
        "<<" + c4Shape.typeC4Shape.text + ">>",
        c4ShapeTypeConf
      );
      c4Shape.typeC4Shape.height = c4ShapeTypeConf.fontSize + 2;
      c4Shape.typeC4Shape.Y = conf$a.c4ShapePadding;
      Y = c4Shape.typeC4Shape.Y + c4Shape.typeC4Shape.height - 4;
      c4Shape.image = { width: 0, height: 0, Y: 0 };
      switch (c4Shape.typeC4Shape.text) {
        case "person":
        case "external_person":
          c4Shape.image.width = 48;
          c4Shape.image.height = 48;
          c4Shape.image.Y = Y;
          Y = c4Shape.image.Y + c4Shape.image.height;
          break;
      }
      if (c4Shape.sprite) {
        c4Shape.image.width = 48;
        c4Shape.image.height = 48;
        c4Shape.image.Y = Y;
        Y = c4Shape.image.Y + c4Shape.image.height;
      }
      let c4ShapeTextWrap = c4Shape.wrap && conf$a.wrap;
      let textLimitWidth = conf$a.width - conf$a.c4ShapePadding * 2;
      let c4ShapeLabelConf = c4ShapeFont(conf$a, c4Shape.typeC4Shape.text);
      c4ShapeLabelConf.fontSize = c4ShapeLabelConf.fontSize + 2;
      c4ShapeLabelConf.fontWeight = "bold";
      calcC4ShapeTextWH("label", c4Shape, c4ShapeTextWrap, c4ShapeLabelConf, textLimitWidth);
      c4Shape["label"].Y = Y + 8;
      Y = c4Shape["label"].Y + c4Shape["label"].height;
      if (c4Shape.type && c4Shape.type.text !== "") {
        c4Shape.type.text = "[" + c4Shape.type.text + "]";
        let c4ShapeTypeConf2 = c4ShapeFont(conf$a, c4Shape.typeC4Shape.text);
        calcC4ShapeTextWH("type", c4Shape, c4ShapeTextWrap, c4ShapeTypeConf2, textLimitWidth);
        c4Shape["type"].Y = Y + 5;
        Y = c4Shape["type"].Y + c4Shape["type"].height;
      } else if (c4Shape.techn && c4Shape.techn.text !== "") {
        c4Shape.techn.text = "[" + c4Shape.techn.text + "]";
        let c4ShapeTechnConf = c4ShapeFont(conf$a, c4Shape.techn.text);
        calcC4ShapeTextWH("techn", c4Shape, c4ShapeTextWrap, c4ShapeTechnConf, textLimitWidth);
        c4Shape["techn"].Y = Y + 5;
        Y = c4Shape["techn"].Y + c4Shape["techn"].height;
      }
      let rectHeight = Y;
      let rectWidth = c4Shape.label.width;
      if (c4Shape.descr && c4Shape.descr.text !== "") {
        let c4ShapeDescrConf = c4ShapeFont(conf$a, c4Shape.typeC4Shape.text);
        calcC4ShapeTextWH("descr", c4Shape, c4ShapeTextWrap, c4ShapeDescrConf, textLimitWidth);
        c4Shape["descr"].Y = Y + 20;
        Y = c4Shape["descr"].Y + c4Shape["descr"].height;
        rectWidth = Math.max(c4Shape.label.width, c4Shape.descr.width);
        rectHeight = Y - c4Shape["descr"].textLines * 5;
      }
      rectWidth = rectWidth + conf$a.c4ShapePadding;
      c4Shape.width = Math.max(c4Shape.width || conf$a.width, rectWidth, conf$a.width);
      c4Shape.height = Math.max(c4Shape.height || conf$a.height, rectHeight, conf$a.height);
      c4Shape.margin = c4Shape.margin || conf$a.c4ShapeMargin;
      currentBounds.insert(c4Shape);
      svgDraw$5.drawC4Shape(diagram2, c4Shape, conf$a);
    }
    currentBounds.bumpLastMargin(conf$a.c4ShapeMargin);
  };
  let Point$1 = class Point {
    constructor(x2, y2) {
      this.x = x2;
      this.y = y2;
    }
  };
  let getIntersectPoint = function(fromNode, endPoint) {
    let x1 = fromNode.x;
    let y1 = fromNode.y;
    let x2 = endPoint.x;
    let y2 = endPoint.y;
    let fromCenterX = x1 + fromNode.width / 2;
    let fromCenterY = y1 + fromNode.height / 2;
    let dx = Math.abs(x1 - x2);
    let dy = Math.abs(y1 - y2);
    let tanDYX = dy / dx;
    let fromDYX = fromNode.height / fromNode.width;
    let returnPoint = null;
    if (y1 == y2 && x1 < x2) {
      returnPoint = new Point$1(x1 + fromNode.width, fromCenterY);
    } else if (y1 == y2 && x1 > x2) {
      returnPoint = new Point$1(x1, fromCenterY);
    } else if (x1 == x2 && y1 < y2) {
      returnPoint = new Point$1(fromCenterX, y1 + fromNode.height);
    } else if (x1 == x2 && y1 > y2) {
      returnPoint = new Point$1(fromCenterX, y1);
    }
    if (x1 > x2 && y1 < y2) {
      if (fromDYX >= tanDYX) {
        returnPoint = new Point$1(x1, fromCenterY + tanDYX * fromNode.width / 2);
      } else {
        returnPoint = new Point$1(
          fromCenterX - dx / dy * fromNode.height / 2,
          y1 + fromNode.height
        );
      }
    } else if (x1 < x2 && y1 < y2) {
      if (fromDYX >= tanDYX) {
        returnPoint = new Point$1(x1 + fromNode.width, fromCenterY + tanDYX * fromNode.width / 2);
      } else {
        returnPoint = new Point$1(
          fromCenterX + dx / dy * fromNode.height / 2,
          y1 + fromNode.height
        );
      }
    } else if (x1 < x2 && y1 > y2) {
      if (fromDYX >= tanDYX) {
        returnPoint = new Point$1(x1 + fromNode.width, fromCenterY - tanDYX * fromNode.width / 2);
      } else {
        returnPoint = new Point$1(fromCenterX + fromNode.height / 2 * dx / dy, y1);
      }
    } else if (x1 > x2 && y1 > y2) {
      if (fromDYX >= tanDYX) {
        returnPoint = new Point$1(x1, fromCenterY - fromNode.width / 2 * tanDYX);
      } else {
        returnPoint = new Point$1(fromCenterX - fromNode.height / 2 * dx / dy, y1);
      }
    }
    return returnPoint;
  };
  let getIntersectPoints = function(fromNode, endNode) {
    let endIntersectPoint = { x: 0, y: 0 };
    endIntersectPoint.x = endNode.x + endNode.width / 2;
    endIntersectPoint.y = endNode.y + endNode.height / 2;
    let startPoint = getIntersectPoint(fromNode, endIntersectPoint);
    endIntersectPoint.x = fromNode.x + fromNode.width / 2;
    endIntersectPoint.y = fromNode.y + fromNode.height / 2;
    let endPoint = getIntersectPoint(endNode, endIntersectPoint);
    return { startPoint, endPoint };
  };
  const drawRels = function(diagram2, rels2, getC4ShapeObj, diagObj) {
    let i2 = 0;
    for (let rel of rels2) {
      i2 = i2 + 1;
      let relTextWrap = rel.wrap && conf$a.wrap;
      let relConf = messageFont$1(conf$a);
      let diagramType = diagObj.db.getC4Type();
      if (diagramType === "C4Dynamic") {
        rel.label.text = i2 + ": " + rel.label.text;
      }
      let textLimitWidth = calculateTextWidth(rel.label.text, relConf);
      calcC4ShapeTextWH("label", rel, relTextWrap, relConf, textLimitWidth);
      if (rel.techn && rel.techn.text !== "") {
        textLimitWidth = calculateTextWidth(rel.techn.text, relConf);
        calcC4ShapeTextWH("techn", rel, relTextWrap, relConf, textLimitWidth);
      }
      if (rel.descr && rel.descr.text !== "") {
        textLimitWidth = calculateTextWidth(rel.descr.text, relConf);
        calcC4ShapeTextWH("descr", rel, relTextWrap, relConf, textLimitWidth);
      }
      let fromNode = getC4ShapeObj(rel.from);
      let endNode = getC4ShapeObj(rel.to);
      let points = getIntersectPoints(fromNode, endNode);
      rel.startPoint = points.startPoint;
      rel.endPoint = points.endPoint;
    }
    svgDraw$5.drawRels(diagram2, rels2, conf$a);
  };
  function drawInsideBoundary(diagram2, parentBoundaryAlias, parentBounds, currentBoundaries, diagObj) {
    let currentBounds = new Bounds(diagObj);
    currentBounds.data.widthLimit = parentBounds.data.widthLimit / Math.min(c4BoundaryInRow, currentBoundaries.length);
    for (let [i2, currentBoundary] of currentBoundaries.entries()) {
      let Y = 0;
      currentBoundary.image = { width: 0, height: 0, Y: 0 };
      if (currentBoundary.sprite) {
        currentBoundary.image.width = 48;
        currentBoundary.image.height = 48;
        currentBoundary.image.Y = Y;
        Y = currentBoundary.image.Y + currentBoundary.image.height;
      }
      let currentBoundaryTextWrap = currentBoundary.wrap && conf$a.wrap;
      let currentBoundaryLabelConf = boundaryFont(conf$a);
      currentBoundaryLabelConf.fontSize = currentBoundaryLabelConf.fontSize + 2;
      currentBoundaryLabelConf.fontWeight = "bold";
      calcC4ShapeTextWH(
        "label",
        currentBoundary,
        currentBoundaryTextWrap,
        currentBoundaryLabelConf,
        currentBounds.data.widthLimit
      );
      currentBoundary["label"].Y = Y + 8;
      Y = currentBoundary["label"].Y + currentBoundary["label"].height;
      if (currentBoundary.type && currentBoundary.type.text !== "") {
        currentBoundary.type.text = "[" + currentBoundary.type.text + "]";
        let currentBoundaryTypeConf = boundaryFont(conf$a);
        calcC4ShapeTextWH(
          "type",
          currentBoundary,
          currentBoundaryTextWrap,
          currentBoundaryTypeConf,
          currentBounds.data.widthLimit
        );
        currentBoundary["type"].Y = Y + 5;
        Y = currentBoundary["type"].Y + currentBoundary["type"].height;
      }
      if (currentBoundary.descr && currentBoundary.descr.text !== "") {
        let currentBoundaryDescrConf = boundaryFont(conf$a);
        currentBoundaryDescrConf.fontSize = currentBoundaryDescrConf.fontSize - 2;
        calcC4ShapeTextWH(
          "descr",
          currentBoundary,
          currentBoundaryTextWrap,
          currentBoundaryDescrConf,
          currentBounds.data.widthLimit
        );
        currentBoundary["descr"].Y = Y + 20;
        Y = currentBoundary["descr"].Y + currentBoundary["descr"].height;
      }
      if (i2 == 0 || i2 % c4BoundaryInRow === 0) {
        let _x = parentBounds.data.startx + conf$a.diagramMarginX;
        let _y = parentBounds.data.stopy + conf$a.diagramMarginY + Y;
        currentBounds.setData(_x, _x, _y, _y);
      } else {
        let _x = currentBounds.data.stopx !== currentBounds.data.startx ? currentBounds.data.stopx + conf$a.diagramMarginX : currentBounds.data.startx;
        let _y = currentBounds.data.starty;
        currentBounds.setData(_x, _x, _y, _y);
      }
      currentBounds.name = currentBoundary.alias;
      let currentPersonOrSystemArray = diagObj.db.getC4ShapeArray(currentBoundary.alias);
      let currentPersonOrSystemKeys = diagObj.db.getC4ShapeKeys(currentBoundary.alias);
      if (currentPersonOrSystemKeys.length > 0) {
        drawC4ShapeArray(
          currentBounds,
          diagram2,
          currentPersonOrSystemArray,
          currentPersonOrSystemKeys
        );
      }
      parentBoundaryAlias = currentBoundary.alias;
      let nextCurrentBoundarys = diagObj.db.getBoundarys(parentBoundaryAlias);
      if (nextCurrentBoundarys.length > 0) {
        drawInsideBoundary(
          diagram2,
          parentBoundaryAlias,
          currentBounds,
          nextCurrentBoundarys,
          diagObj
        );
      }
      if (currentBoundary.alias !== "global") {
        drawBoundary(diagram2, currentBoundary, currentBounds);
      }
      parentBounds.data.stopy = Math.max(
        currentBounds.data.stopy + conf$a.c4ShapeMargin,
        parentBounds.data.stopy
      );
      parentBounds.data.stopx = Math.max(
        currentBounds.data.stopx + conf$a.c4ShapeMargin,
        parentBounds.data.stopx
      );
      globalBoundaryMaxX = Math.max(globalBoundaryMaxX, parentBounds.data.stopx);
      globalBoundaryMaxY = Math.max(globalBoundaryMaxY, parentBounds.data.stopy);
    }
  }
  const draw$i = function(_text, id2, _version, diagObj) {
    conf$a = getConfig$1().c4;
    const securityLevel = getConfig$1().securityLevel;
    let sandboxElement;
    if (securityLevel === "sandbox") {
      sandboxElement = select("#i" + id2);
    }
    const root2 = securityLevel === "sandbox" ? select(sandboxElement.nodes()[0].contentDocument.body) : select("body");
    let db2 = diagObj.db;
    diagObj.db.setWrap(conf$a.wrap);
    c4ShapeInRow = db2.getC4ShapeInRow();
    c4BoundaryInRow = db2.getC4BoundaryInRow();
    log$1.debug(`C:${JSON.stringify(conf$a, null, 2)}`);
    const diagram2 = securityLevel === "sandbox" ? root2.select(`[id="${id2}"]`) : select(`[id="${id2}"]`);
    svgDraw$5.insertComputerIcon(diagram2);
    svgDraw$5.insertDatabaseIcon(diagram2);
    svgDraw$5.insertClockIcon(diagram2);
    let screenBounds = new Bounds(diagObj);
    screenBounds.setData(
      conf$a.diagramMarginX,
      conf$a.diagramMarginX,
      conf$a.diagramMarginY,
      conf$a.diagramMarginY
    );
    screenBounds.data.widthLimit = screen.availWidth;
    globalBoundaryMaxX = conf$a.diagramMarginX;
    globalBoundaryMaxY = conf$a.diagramMarginY;
    const title2 = diagObj.db.getTitle();
    let currentBoundaries = diagObj.db.getBoundarys("");
    drawInsideBoundary(diagram2, "", screenBounds, currentBoundaries, diagObj);
    svgDraw$5.insertArrowHead(diagram2);
    svgDraw$5.insertArrowEnd(diagram2);
    svgDraw$5.insertArrowCrossHead(diagram2);
    svgDraw$5.insertArrowFilledHead(diagram2);
    drawRels(diagram2, diagObj.db.getRels(), diagObj.db.getC4Shape, diagObj);
    screenBounds.data.stopx = globalBoundaryMaxX;
    screenBounds.data.stopy = globalBoundaryMaxY;
    const box = screenBounds.data;
    let boxHeight = box.stopy - box.starty;
    let height2 = boxHeight + 2 * conf$a.diagramMarginY;
    let boxWidth = box.stopx - box.startx;
    const width2 = boxWidth + 2 * conf$a.diagramMarginX;
    if (title2) {
      diagram2.append("text").text(title2).attr("x", (box.stopx - box.startx) / 2 - 4 * conf$a.diagramMarginX).attr("y", box.starty + conf$a.diagramMarginY);
    }
    configureSvgSize(diagram2, height2, width2, conf$a.useMaxWidth);
    const extraVertForTitle = title2 ? 60 : 0;
    diagram2.attr(
      "viewBox",
      box.startx - conf$a.diagramMarginX + " -" + (conf$a.diagramMarginY + extraVertForTitle) + " " + width2 + " " + (height2 + extraVertForTitle)
    );
    log$1.debug(`models:`, box);
  };
  const c4Renderer = {
    drawPersonOrSystemArray: drawC4ShapeArray,
    drawBoundary,
    setConf: setConf$9,
    draw: draw$i
  };
  const getStyles$e = (options2) => `.person {
    stroke: ${options2.personBorder};
    fill: ${options2.personBkg};
  }
`;
  const c4Styles = getStyles$e;
  const diagram$i = {
    parser: c4Parser,
    db: c4Db,
    renderer: c4Renderer,
    styles: c4Styles,
    init: (cnf) => {
      c4Renderer.setConf(cnf.c4);
    }
  };
  const c4Diagram = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
    __proto__: null,
    diagram: diagram$i
  }, Symbol.toStringTag, { value: "Module" }));
  var parser$m = function() {
    var o = function(k, v, o2, l) {
      for (o2 = o2 || {}, l = k.length; l--; o2[k[l]] = v)
        ;
      return o2;
    }, $V0 = [1, 9], $V1 = [1, 7], $V2 = [1, 6], $V3 = [1, 8], $V4 = [1, 20, 21, 22, 23, 38, 44, 46, 48, 52, 66, 67, 87, 88, 89, 90, 91, 92, 96, 106, 107, 110, 112, 113, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128], $V5 = [2, 10], $V6 = [1, 20], $V7 = [1, 21], $V8 = [1, 22], $V9 = [1, 23], $Va = [1, 30], $Vb = [1, 32], $Vc = [1, 33], $Vd = [1, 34], $Ve = [1, 62], $Vf = [1, 48], $Vg = [1, 52], $Vh = [1, 36], $Vi = [1, 37], $Vj = [1, 38], $Vk = [1, 39], $Vl = [1, 40], $Vm = [1, 56], $Vn = [1, 63], $Vo = [1, 51], $Vp = [1, 53], $Vq = [1, 55], $Vr = [1, 59], $Vs = [1, 60], $Vt = [1, 41], $Vu = [1, 42], $Vv = [1, 43], $Vw = [1, 44], $Vx = [1, 61], $Vy = [1, 50], $Vz = [1, 54], $VA = [1, 57], $VB = [1, 58], $VC = [1, 49], $VD = [1, 66], $VE = [1, 71], $VF = [1, 20, 21, 22, 23, 38, 42, 44, 46, 48, 52, 66, 67, 87, 88, 89, 90, 91, 92, 96, 106, 107, 110, 112, 113, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128], $VG = [1, 75], $VH = [1, 74], $VI = [1, 76], $VJ = [20, 21, 23, 81, 82], $VK = [1, 99], $VL = [1, 104], $VM = [1, 107], $VN = [1, 108], $VO = [1, 101], $VP = [1, 106], $VQ = [1, 109], $VR = [1, 102], $VS = [1, 114], $VT = [1, 113], $VU = [1, 103], $VV = [1, 105], $VW = [1, 110], $VX = [1, 111], $VY = [1, 112], $VZ = [1, 115], $V_ = [20, 21, 22, 23, 81, 82], $V$ = [20, 21, 22, 23, 53, 81, 82], $V01 = [20, 21, 22, 23, 40, 52, 53, 55, 57, 59, 61, 63, 65, 66, 67, 69, 71, 73, 74, 76, 81, 82, 92, 96, 106, 107, 110, 112, 113, 123, 124, 125, 126, 127, 128], $V11 = [20, 21, 23], $V21 = [20, 21, 23, 52, 66, 67, 81, 82, 92, 96, 106, 107, 110, 112, 113, 123, 124, 125, 126, 127, 128], $V31 = [1, 12, 20, 21, 22, 23, 24, 38, 42, 44, 46, 48, 52, 66, 67, 87, 88, 89, 90, 91, 92, 96, 106, 107, 110, 112, 113, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128], $V41 = [52, 66, 67, 92, 96, 106, 107, 110, 112, 113, 123, 124, 125, 126, 127, 128], $V51 = [1, 150], $V61 = [1, 158], $V71 = [1, 159], $V81 = [1, 160], $V91 = [1, 161], $Va1 = [1, 145], $Vb1 = [1, 146], $Vc1 = [1, 141], $Vd1 = [1, 142], $Ve1 = [1, 153], $Vf1 = [1, 154], $Vg1 = [1, 155], $Vh1 = [1, 156], $Vi1 = [1, 157], $Vj1 = [1, 162], $Vk1 = [1, 163], $Vl1 = [1, 148], $Vm1 = [1, 151], $Vn1 = [1, 147], $Vo1 = [1, 144], $Vp1 = [20, 21, 22, 23, 38, 42, 44, 46, 48, 52, 66, 67, 87, 88, 89, 90, 91, 92, 96, 106, 107, 110, 112, 113, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128], $Vq1 = [1, 166], $Vr1 = [20, 21, 22, 23, 26, 52, 66, 67, 92, 106, 107, 110, 112, 113, 123, 124, 125, 126, 127, 128], $Vs1 = [20, 21, 22, 23, 24, 26, 38, 40, 41, 42, 52, 56, 58, 60, 62, 64, 66, 67, 68, 70, 72, 73, 75, 77, 81, 82, 87, 88, 89, 90, 91, 92, 93, 96, 106, 107, 110, 112, 113, 114, 115, 123, 124, 125, 126, 127, 128], $Vt1 = [12, 21, 22, 24], $Vu1 = [22, 107], $Vv1 = [1, 251], $Vw1 = [1, 246], $Vx1 = [1, 247], $Vy1 = [1, 255], $Vz1 = [1, 252], $VA1 = [1, 249], $VB1 = [1, 248], $VC1 = [1, 250], $VD1 = [1, 253], $VE1 = [1, 254], $VF1 = [1, 256], $VG1 = [1, 274], $VH1 = [20, 21, 23, 107], $VI1 = [20, 21, 22, 23, 66, 67, 87, 103, 106, 107, 110, 111, 112, 113, 114];
    var parser2 = {
      trace: function trace() {
      },
      yy: {},
      symbols_: { "error": 2, "start": 3, "mermaidDoc": 4, "directive": 5, "openDirective": 6, "typeDirective": 7, "closeDirective": 8, "separator": 9, ":": 10, "argDirective": 11, "open_directive": 12, "type_directive": 13, "arg_directive": 14, "close_directive": 15, "graphConfig": 16, "document": 17, "line": 18, "statement": 19, "SEMI": 20, "NEWLINE": 21, "SPACE": 22, "EOF": 23, "GRAPH": 24, "NODIR": 25, "DIR": 26, "FirstStmtSeperator": 27, "ending": 28, "endToken": 29, "spaceList": 30, "spaceListNewline": 31, "verticeStatement": 32, "styleStatement": 33, "linkStyleStatement": 34, "classDefStatement": 35, "classStatement": 36, "clickStatement": 37, "subgraph": 38, "text": 39, "SQS": 40, "SQE": 41, "end": 42, "direction": 43, "acc_title": 44, "acc_title_value": 45, "acc_descr": 46, "acc_descr_value": 47, "acc_descr_multiline_value": 48, "link": 49, "node": 50, "vertex": 51, "AMP": 52, "STYLE_SEPARATOR": 53, "idString": 54, "DOUBLECIRCLESTART": 55, "DOUBLECIRCLEEND": 56, "PS": 57, "PE": 58, "(-": 59, "-)": 60, "STADIUMSTART": 61, "STADIUMEND": 62, "SUBROUTINESTART": 63, "SUBROUTINEEND": 64, "VERTEX_WITH_PROPS_START": 65, "ALPHA": 66, "COLON": 67, "PIPE": 68, "CYLINDERSTART": 69, "CYLINDEREND": 70, "DIAMOND_START": 71, "DIAMOND_STOP": 72, "TAGEND": 73, "TRAPSTART": 74, "TRAPEND": 75, "INVTRAPSTART": 76, "INVTRAPEND": 77, "linkStatement": 78, "arrowText": 79, "TESTSTR": 80, "START_LINK": 81, "LINK": 82, "textToken": 83, "STR": 84, "MD_STR": 85, "keywords": 86, "STYLE": 87, "LINKSTYLE": 88, "CLASSDEF": 89, "CLASS": 90, "CLICK": 91, "DOWN": 92, "UP": 93, "textNoTags": 94, "textNoTagsToken": 95, "DEFAULT": 96, "stylesOpt": 97, "alphaNum": 98, "CALLBACKNAME": 99, "CALLBACKARGS": 100, "HREF": 101, "LINK_TARGET": 102, "HEX": 103, "numList": 104, "INTERPOLATE": 105, "NUM": 106, "COMMA": 107, "style": 108, "styleComponent": 109, "MINUS": 110, "UNIT": 111, "BRKT": 112, "DOT": 113, "PCT": 114, "TAGSTART": 115, "alphaNumToken": 116, "idStringToken": 117, "alphaNumStatement": 118, "direction_tb": 119, "direction_bt": 120, "direction_rl": 121, "direction_lr": 122, "PUNCTUATION": 123, "UNICODE_TEXT": 124, "PLUS": 125, "EQUALS": 126, "MULT": 127, "UNDERSCORE": 128, "graphCodeTokens": 129, "ARROW_CROSS": 130, "ARROW_POINT": 131, "ARROW_CIRCLE": 132, "ARROW_OPEN": 133, "QUOTE": 134, "$accept": 0, "$end": 1 },
      terminals_: { 2: "error", 10: ":", 12: "open_directive", 13: "type_directive", 14: "arg_directive", 15: "close_directive", 20: "SEMI", 21: "NEWLINE", 22: "SPACE", 23: "EOF", 24: "GRAPH", 25: "NODIR", 26: "DIR", 38: "subgraph", 40: "SQS", 41: "SQE", 42: "end", 44: "acc_title", 45: "acc_title_value", 46: "acc_descr", 47: "acc_descr_value", 48: "acc_descr_multiline_value", 52: "AMP", 53: "STYLE_SEPARATOR", 55: "DOUBLECIRCLESTART", 56: "DOUBLECIRCLEEND", 57: "PS", 58: "PE", 59: "(-", 60: "-)", 61: "STADIUMSTART", 62: "STADIUMEND", 63: "SUBROUTINESTART", 64: "SUBROUTINEEND", 65: "VERTEX_WITH_PROPS_START", 66: "ALPHA", 67: "COLON", 68: "PIPE", 69: "CYLINDERSTART", 70: "CYLINDEREND", 71: "DIAMOND_START", 72: "DIAMOND_STOP", 73: "TAGEND", 74: "TRAPSTART", 75: "TRAPEND", 76: "INVTRAPSTART", 77: "INVTRAPEND", 80: "TESTSTR", 81: "START_LINK", 82: "LINK", 84: "STR", 85: "MD_STR", 87: "STYLE", 88: "LINKSTYLE", 89: "CLASSDEF", 90: "CLASS", 91: "CLICK", 92: "DOWN", 93: "UP", 96: "DEFAULT", 99: "CALLBACKNAME", 100: "CALLBACKARGS", 101: "HREF", 102: "LINK_TARGET", 103: "HEX", 105: "INTERPOLATE", 106: "NUM", 107: "COMMA", 110: "MINUS", 111: "UNIT", 112: "BRKT", 113: "DOT", 114: "PCT", 115: "TAGSTART", 119: "direction_tb", 120: "direction_bt", 121: "direction_rl", 122: "direction_lr", 123: "PUNCTUATION", 124: "UNICODE_TEXT", 125: "PLUS", 126: "EQUALS", 127: "MULT", 128: "UNDERSCORE", 130: "ARROW_CROSS", 131: "ARROW_POINT", 132: "ARROW_CIRCLE", 133: "ARROW_OPEN", 134: "QUOTE" },
      productions_: [0, [3, 1], [3, 2], [5, 4], [5, 6], [6, 1], [7, 1], [11, 1], [8, 1], [4, 2], [17, 0], [17, 2], [18, 1], [18, 1], [18, 1], [18, 1], [18, 1], [16, 2], [16, 2], [16, 2], [16, 3], [28, 2], [28, 1], [29, 1], [29, 1], [29, 1], [27, 1], [27, 1], [27, 2], [31, 2], [31, 2], [31, 1], [31, 1], [30, 2], [30, 1], [19, 2], [19, 2], [19, 2], [19, 2], [19, 2], [19, 2], [19, 9], [19, 6], [19, 4], [19, 1], [19, 2], [19, 2], [19, 1], [9, 1], [9, 1], [9, 1], [32, 3], [32, 4], [32, 2], [32, 1], [50, 1], [50, 5], [50, 3], [51, 4], [51, 4], [51, 6], [51, 4], [51, 4], [51, 4], [51, 8], [51, 4], [51, 4], [51, 4], [51, 6], [51, 4], [51, 4], [51, 4], [51, 4], [51, 4], [51, 1], [49, 2], [49, 3], [49, 3], [49, 1], [49, 3], [78, 1], [79, 3], [39, 1], [39, 2], [39, 1], [39, 1], [86, 1], [86, 1], [86, 1], [86, 1], [86, 1], [86, 1], [86, 1], [86, 1], [86, 1], [86, 1], [86, 1], [94, 1], [94, 2], [35, 5], [35, 5], [36, 5], [37, 2], [37, 4], [37, 3], [37, 5], [37, 2], [37, 4], [37, 4], [37, 6], [37, 2], [37, 4], [37, 2], [37, 4], [37, 4], [37, 6], [33, 5], [33, 5], [34, 5], [34, 5], [34, 9], [34, 9], [34, 7], [34, 7], [104, 1], [104, 3], [97, 1], [97, 3], [108, 1], [108, 2], [109, 1], [109, 1], [109, 1], [109, 1], [109, 1], [109, 1], [109, 1], [109, 1], [109, 1], [109, 1], [109, 1], [83, 1], [83, 1], [83, 1], [83, 1], [83, 1], [83, 1], [95, 1], [95, 1], [95, 1], [95, 1], [54, 1], [54, 2], [98, 1], [98, 2], [118, 1], [118, 1], [118, 1], [118, 1], [43, 1], [43, 1], [43, 1], [43, 1], [116, 1], [116, 1], [116, 1], [116, 1], [116, 1], [116, 1], [116, 1], [116, 1], [116, 1], [116, 1], [116, 1], [116, 1], [116, 1], [117, 1], [117, 1], [117, 1], [117, 1], [117, 1], [117, 1], [117, 1], [117, 1], [117, 1], [117, 1], [117, 1], [117, 1], [117, 1], [117, 1], [117, 1], [117, 1], [129, 1], [129, 1], [129, 1], [129, 1], [129, 1], [129, 1], [129, 1], [129, 1], [129, 1], [129, 1], [129, 1], [129, 1], [129, 1], [129, 1], [129, 1], [129, 1], [129, 1], [129, 1], [129, 1], [129, 1], [129, 1], [129, 1], [129, 1], [129, 1], [129, 1], [129, 1]],
      performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate, $$, _$) {
        var $0 = $$.length - 1;
        switch (yystate) {
          case 5:
            yy.parseDirective("%%{", "open_directive");
            break;
          case 6:
            yy.parseDirective($$[$0], "type_directive");
            break;
          case 7:
            $$[$0] = $$[$0].trim().replace(/'/g, '"');
            yy.parseDirective($$[$0], "arg_directive");
            break;
          case 8:
            yy.parseDirective("}%%", "close_directive", "flowchart");
            break;
          case 10:
            this.$ = [];
            break;
          case 11:
            if (!Array.isArray($$[$0]) || $$[$0].length > 0) {
              $$[$0 - 1].push($$[$0]);
            }
            this.$ = $$[$0 - 1];
            break;
          case 12:
          case 97:
          case 153:
          case 155:
          case 156:
            this.$ = $$[$0];
            break;
          case 19:
            yy.setDirection("TB");
            this.$ = "TB";
            break;
          case 20:
            yy.setDirection($$[$0 - 1]);
            this.$ = $$[$0 - 1];
            break;
          case 35:
            this.$ = $$[$0 - 1].nodes;
            break;
          case 36:
          case 37:
          case 38:
          case 39:
          case 40:
            this.$ = [];
            break;
          case 41:
            this.$ = yy.addSubGraph($$[$0 - 6], $$[$0 - 1], $$[$0 - 4]);
            break;
          case 42:
            this.$ = yy.addSubGraph($$[$0 - 3], $$[$0 - 1], $$[$0 - 3]);
            break;
          case 43:
            this.$ = yy.addSubGraph(void 0, $$[$0 - 1], void 0);
            break;
          case 45:
            this.$ = $$[$0].trim();
            yy.setAccTitle(this.$);
            break;
          case 46:
          case 47:
            this.$ = $$[$0].trim();
            yy.setAccDescription(this.$);
            break;
          case 51:
            yy.addLink($$[$0 - 2].stmt, $$[$0], $$[$0 - 1]);
            this.$ = { stmt: $$[$0], nodes: $$[$0].concat($$[$0 - 2].nodes) };
            break;
          case 52:
            yy.addLink($$[$0 - 3].stmt, $$[$0 - 1], $$[$0 - 2]);
            this.$ = { stmt: $$[$0 - 1], nodes: $$[$0 - 1].concat($$[$0 - 3].nodes) };
            break;
          case 53:
            this.$ = { stmt: $$[$0 - 1], nodes: $$[$0 - 1] };
            break;
          case 54:
            this.$ = { stmt: $$[$0], nodes: $$[$0] };
            break;
          case 55:
            this.$ = [$$[$0]];
            break;
          case 56:
            this.$ = $$[$0 - 4].concat($$[$0]);
            break;
          case 57:
            this.$ = [$$[$0 - 2]];
            yy.setClass($$[$0 - 2], $$[$0]);
            break;
          case 58:
            this.$ = $$[$0 - 3];
            yy.addVertex($$[$0 - 3], $$[$0 - 1], "square");
            break;
          case 59:
            this.$ = $$[$0 - 3];
            yy.addVertex($$[$0 - 3], $$[$0 - 1], "doublecircle");
            break;
          case 60:
            this.$ = $$[$0 - 5];
            yy.addVertex($$[$0 - 5], $$[$0 - 2], "circle");
            break;
          case 61:
            this.$ = $$[$0 - 3];
            yy.addVertex($$[$0 - 3], $$[$0 - 1], "ellipse");
            break;
          case 62:
            this.$ = $$[$0 - 3];
            yy.addVertex($$[$0 - 3], $$[$0 - 1], "stadium");
            break;
          case 63:
            this.$ = $$[$0 - 3];
            yy.addVertex($$[$0 - 3], $$[$0 - 1], "subroutine");
            break;
          case 64:
            this.$ = $$[$0 - 7];
            yy.addVertex($$[$0 - 7], $$[$0 - 1], "rect", void 0, void 0, void 0, Object.fromEntries([[$$[$0 - 5], $$[$0 - 3]]]));
            break;
          case 65:
            this.$ = $$[$0 - 3];
            yy.addVertex($$[$0 - 3], $$[$0 - 1], "cylinder");
            break;
          case 66:
            this.$ = $$[$0 - 3];
            yy.addVertex($$[$0 - 3], $$[$0 - 1], "round");
            break;
          case 67:
            this.$ = $$[$0 - 3];
            yy.addVertex($$[$0 - 3], $$[$0 - 1], "diamond");
            break;
          case 68:
            this.$ = $$[$0 - 5];
            yy.addVertex($$[$0 - 5], $$[$0 - 2], "hexagon");
            break;
          case 69:
            this.$ = $$[$0 - 3];
            yy.addVertex($$[$0 - 3], $$[$0 - 1], "odd");
            break;
          case 70:
            this.$ = $$[$0 - 3];
            yy.addVertex($$[$0 - 3], $$[$0 - 1], "trapezoid");
            break;
          case 71:
            this.$ = $$[$0 - 3];
            yy.addVertex($$[$0 - 3], $$[$0 - 1], "inv_trapezoid");
            break;
          case 72:
            this.$ = $$[$0 - 3];
            yy.addVertex($$[$0 - 3], $$[$0 - 1], "lean_right");
            break;
          case 73:
            this.$ = $$[$0 - 3];
            yy.addVertex($$[$0 - 3], $$[$0 - 1], "lean_left");
            break;
          case 74:
            this.$ = $$[$0];
            yy.addVertex($$[$0]);
            break;
          case 75:
            $$[$0 - 1].text = $$[$0];
            this.$ = $$[$0 - 1];
            break;
          case 76:
          case 77:
            $$[$0 - 2].text = $$[$0 - 1];
            this.$ = $$[$0 - 2];
            break;
          case 78:
            this.$ = $$[$0];
            break;
          case 79:
            var inf = yy.destructLink($$[$0], $$[$0 - 2]);
            this.$ = { "type": inf.type, "stroke": inf.stroke, "length": inf.length, "text": $$[$0 - 1] };
            break;
          case 80:
            var inf = yy.destructLink($$[$0]);
            this.$ = { "type": inf.type, "stroke": inf.stroke, "length": inf.length };
            break;
          case 81:
            this.$ = $$[$0 - 1];
            break;
          case 82:
            this.$ = { text: $$[$0], type: "text" };
            break;
          case 83:
            this.$ = { text: $$[$0 - 1].text + "" + $$[$0], type: $$[$0 - 1].type };
            break;
          case 84:
            this.$ = { text: $$[$0], type: "text" };
            break;
          case 85:
            this.$ = { text: $$[$0], type: "markdown" };
            break;
          case 98:
          case 154:
            this.$ = $$[$0 - 1] + "" + $$[$0];
            break;
          case 99:
          case 100:
            this.$ = $$[$0 - 4];
            yy.addClass($$[$0 - 2], $$[$0]);
            break;
          case 101:
            this.$ = $$[$0 - 4];
            yy.setClass($$[$0 - 2], $$[$0]);
            break;
          case 102:
          case 110:
            this.$ = $$[$0 - 1];
            yy.setClickEvent($$[$0 - 1], $$[$0]);
            break;
          case 103:
          case 111:
            this.$ = $$[$0 - 3];
            yy.setClickEvent($$[$0 - 3], $$[$0 - 2]);
            yy.setTooltip($$[$0 - 3], $$[$0]);
            break;
          case 104:
            this.$ = $$[$0 - 2];
            yy.setClickEvent($$[$0 - 2], $$[$0 - 1], $$[$0]);
            break;
          case 105:
            this.$ = $$[$0 - 4];
            yy.setClickEvent($$[$0 - 4], $$[$0 - 3], $$[$0 - 2]);
            yy.setTooltip($$[$0 - 4], $$[$0]);
            break;
          case 106:
          case 112:
            this.$ = $$[$0 - 1];
            yy.setLink($$[$0 - 1], $$[$0]);
            break;
          case 107:
          case 113:
            this.$ = $$[$0 - 3];
            yy.setLink($$[$0 - 3], $$[$0 - 2]);
            yy.setTooltip($$[$0 - 3], $$[$0]);
            break;
          case 108:
          case 114:
            this.$ = $$[$0 - 3];
            yy.setLink($$[$0 - 3], $$[$0 - 2], $$[$0]);
            break;
          case 109:
          case 115:
            this.$ = $$[$0 - 5];
            yy.setLink($$[$0 - 5], $$[$0 - 4], $$[$0]);
            yy.setTooltip($$[$0 - 5], $$[$0 - 2]);
            break;
          case 116:
            this.$ = $$[$0 - 4];
            yy.addVertex($$[$0 - 2], void 0, void 0, $$[$0]);
            break;
          case 117:
          case 119:
            this.$ = $$[$0 - 4];
            yy.updateLink($$[$0 - 2], $$[$0]);
            break;
          case 118:
            this.$ = $$[$0 - 4];
            yy.updateLink([$$[$0 - 2]], $$[$0]);
            break;
          case 120:
            this.$ = $$[$0 - 8];
            yy.updateLinkInterpolate([$$[$0 - 6]], $$[$0 - 2]);
            yy.updateLink([$$[$0 - 6]], $$[$0]);
            break;
          case 121:
            this.$ = $$[$0 - 8];
            yy.updateLinkInterpolate($$[$0 - 6], $$[$0 - 2]);
            yy.updateLink($$[$0 - 6], $$[$0]);
            break;
          case 122:
            this.$ = $$[$0 - 6];
            yy.updateLinkInterpolate([$$[$0 - 4]], $$[$0]);
            break;
          case 123:
            this.$ = $$[$0 - 6];
            yy.updateLinkInterpolate($$[$0 - 4], $$[$0]);
            break;
          case 124:
          case 126:
            this.$ = [$$[$0]];
            break;
          case 125:
          case 127:
            $$[$0 - 2].push($$[$0]);
            this.$ = $$[$0 - 2];
            break;
          case 129:
            this.$ = $$[$0 - 1] + $$[$0];
            break;
          case 151:
            this.$ = $$[$0];
            break;
          case 152:
            this.$ = $$[$0 - 1] + "" + $$[$0];
            break;
          case 157:
            this.$ = "v";
            break;
          case 158:
            this.$ = "-";
            break;
          case 159:
            this.$ = { stmt: "dir", value: "TB" };
            break;
          case 160:
            this.$ = { stmt: "dir", value: "BT" };
            break;
          case 161:
            this.$ = { stmt: "dir", value: "RL" };
            break;
          case 162:
            this.$ = { stmt: "dir", value: "LR" };
            break;
        }
      },
      table: [{ 3: 1, 4: 2, 5: 3, 6: 5, 12: $V0, 16: 4, 21: $V1, 22: $V2, 24: $V3 }, { 1: [3] }, { 1: [2, 1] }, { 3: 10, 4: 2, 5: 3, 6: 5, 12: $V0, 16: 4, 21: $V1, 22: $V2, 24: $V3 }, o($V4, $V5, { 17: 11 }), { 7: 12, 13: [1, 13] }, { 16: 14, 21: $V1, 22: $V2, 24: $V3 }, { 16: 15, 21: $V1, 22: $V2, 24: $V3 }, { 25: [1, 16], 26: [1, 17] }, { 13: [2, 5] }, { 1: [2, 2] }, { 1: [2, 9], 18: 18, 19: 19, 20: $V6, 21: $V7, 22: $V8, 23: $V9, 32: 24, 33: 25, 34: 26, 35: 27, 36: 28, 37: 29, 38: $Va, 43: 31, 44: $Vb, 46: $Vc, 48: $Vd, 50: 35, 51: 45, 52: $Ve, 54: 46, 66: $Vf, 67: $Vg, 87: $Vh, 88: $Vi, 89: $Vj, 90: $Vk, 91: $Vl, 92: $Vm, 96: $Vn, 106: $Vo, 107: $Vp, 110: $Vq, 112: $Vr, 113: $Vs, 117: 47, 119: $Vt, 120: $Vu, 121: $Vv, 122: $Vw, 123: $Vx, 124: $Vy, 125: $Vz, 126: $VA, 127: $VB, 128: $VC }, { 8: 64, 10: [1, 65], 15: $VD }, o([10, 15], [2, 6]), o($V4, [2, 17]), o($V4, [2, 18]), o($V4, [2, 19]), { 20: [1, 68], 21: [1, 69], 22: $VE, 27: 67, 30: 70 }, o($VF, [2, 11]), o($VF, [2, 12]), o($VF, [2, 13]), o($VF, [2, 14]), o($VF, [2, 15]), o($VF, [2, 16]), { 9: 72, 20: $VG, 21: $VH, 23: $VI, 49: 73, 78: 77, 81: [1, 78], 82: [1, 79] }, { 9: 80, 20: $VG, 21: $VH, 23: $VI }, { 9: 81, 20: $VG, 21: $VH, 23: $VI }, { 9: 82, 20: $VG, 21: $VH, 23: $VI }, { 9: 83, 20: $VG, 21: $VH, 23: $VI }, { 9: 84, 20: $VG, 21: $VH, 23: $VI }, { 9: 86, 20: $VG, 21: $VH, 22: [1, 85], 23: $VI }, o($VF, [2, 44]), { 45: [1, 87] }, { 47: [1, 88] }, o($VF, [2, 47]), o($VJ, [2, 54], { 30: 89, 22: $VE }), { 22: [1, 90] }, { 22: [1, 91] }, { 22: [1, 92] }, { 22: [1, 93] }, { 26: $VK, 52: $VL, 66: $VM, 67: $VN, 84: [1, 97], 92: $VO, 98: 96, 99: [1, 94], 101: [1, 95], 106: $VP, 107: $VQ, 110: $VR, 112: $VS, 113: $VT, 116: 100, 118: 98, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, o($VF, [2, 159]), o($VF, [2, 160]), o($VF, [2, 161]), o($VF, [2, 162]), o($V_, [2, 55], { 53: [1, 116] }), o($V$, [2, 74], { 117: 129, 40: [1, 117], 52: $Ve, 55: [1, 118], 57: [1, 119], 59: [1, 120], 61: [1, 121], 63: [1, 122], 65: [1, 123], 66: $Vf, 67: $Vg, 69: [1, 124], 71: [1, 125], 73: [1, 126], 74: [1, 127], 76: [1, 128], 92: $Vm, 96: $Vn, 106: $Vo, 107: $Vp, 110: $Vq, 112: $Vr, 113: $Vs, 123: $Vx, 124: $Vy, 125: $Vz, 126: $VA, 127: $VB, 128: $VC }), o($V01, [2, 151]), o($V01, [2, 176]), o($V01, [2, 177]), o($V01, [2, 178]), o($V01, [2, 179]), o($V01, [2, 180]), o($V01, [2, 181]), o($V01, [2, 182]), o($V01, [2, 183]), o($V01, [2, 184]), o($V01, [2, 185]), o($V01, [2, 186]), o($V01, [2, 187]), o($V01, [2, 188]), o($V01, [2, 189]), o($V01, [2, 190]), o($V01, [2, 191]), { 9: 130, 20: $VG, 21: $VH, 23: $VI }, { 11: 131, 14: [1, 132] }, o($V11, [2, 8]), o($V4, [2, 20]), o($V4, [2, 26]), o($V4, [2, 27]), { 21: [1, 133] }, o($V21, [2, 34], { 30: 134, 22: $VE }), o($VF, [2, 35]), { 50: 135, 51: 45, 52: $Ve, 54: 46, 66: $Vf, 67: $Vg, 92: $Vm, 96: $Vn, 106: $Vo, 107: $Vp, 110: $Vq, 112: $Vr, 113: $Vs, 117: 47, 123: $Vx, 124: $Vy, 125: $Vz, 126: $VA, 127: $VB, 128: $VC }, o($V31, [2, 48]), o($V31, [2, 49]), o($V31, [2, 50]), o($V41, [2, 78], { 79: 136, 68: [1, 138], 80: [1, 137] }), { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 39: 139, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 140, 84: $Vc1, 85: $Vd1, 86: 152, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 93: $Vk1, 95: 143, 96: $Vl1, 106: $VP, 107: $VQ, 110: $Vm1, 112: $VS, 113: $VT, 114: $Vn1, 115: $Vo1, 116: 149, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, o([52, 66, 67, 68, 80, 92, 96, 106, 107, 110, 112, 113, 123, 124, 125, 126, 127, 128], [2, 80]), o($VF, [2, 36]), o($VF, [2, 37]), o($VF, [2, 38]), o($VF, [2, 39]), o($VF, [2, 40]), { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 39: 164, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 140, 84: $Vc1, 85: $Vd1, 86: 152, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 93: $Vk1, 95: 143, 96: $Vl1, 106: $VP, 107: $VQ, 110: $Vm1, 112: $VS, 113: $VT, 114: $Vn1, 115: $Vo1, 116: 149, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, o($Vp1, $V5, { 17: 165 }), o($VF, [2, 45]), o($VF, [2, 46]), o($VJ, [2, 53], { 52: $Vq1 }), { 26: $VK, 52: $VL, 66: $VM, 67: $VN, 92: $VO, 98: 167, 103: [1, 168], 106: $VP, 107: $VQ, 110: $VR, 112: $VS, 113: $VT, 116: 100, 118: 98, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, { 96: [1, 169], 104: 170, 106: [1, 171] }, { 26: $VK, 52: $VL, 66: $VM, 67: $VN, 92: $VO, 96: [1, 172], 98: 173, 106: $VP, 107: $VQ, 110: $VR, 112: $VS, 113: $VT, 116: 100, 118: 98, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, { 26: $VK, 52: $VL, 66: $VM, 67: $VN, 92: $VO, 98: 174, 106: $VP, 107: $VQ, 110: $VR, 112: $VS, 113: $VT, 116: 100, 118: 98, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, o($V11, [2, 102], { 22: [1, 175], 100: [1, 176] }), o($V11, [2, 106], { 22: [1, 177] }), o($V11, [2, 110], { 116: 100, 118: 179, 22: [1, 178], 26: $VK, 52: $VL, 66: $VM, 67: $VN, 92: $VO, 106: $VP, 107: $VQ, 110: $VR, 112: $VS, 113: $VT, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }), o($V11, [2, 112], { 22: [1, 180] }), o($Vr1, [2, 153]), o($Vr1, [2, 155]), o($Vr1, [2, 156]), o($Vr1, [2, 157]), o($Vr1, [2, 158]), o($Vs1, [2, 163]), o($Vs1, [2, 164]), o($Vs1, [2, 165]), o($Vs1, [2, 166]), o($Vs1, [2, 167]), o($Vs1, [2, 168]), o($Vs1, [2, 169]), o($Vs1, [2, 170]), o($Vs1, [2, 171]), o($Vs1, [2, 172]), o($Vs1, [2, 173]), o($Vs1, [2, 174]), o($Vs1, [2, 175]), { 52: $Ve, 54: 181, 66: $Vf, 67: $Vg, 92: $Vm, 96: $Vn, 106: $Vo, 107: $Vp, 110: $Vq, 112: $Vr, 113: $Vs, 117: 47, 123: $Vx, 124: $Vy, 125: $Vz, 126: $VA, 127: $VB, 128: $VC }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 39: 182, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 140, 84: $Vc1, 85: $Vd1, 86: 152, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 93: $Vk1, 95: 143, 96: $Vl1, 106: $VP, 107: $VQ, 110: $Vm1, 112: $VS, 113: $VT, 114: $Vn1, 115: $Vo1, 116: 149, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 39: 183, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 140, 84: $Vc1, 85: $Vd1, 86: 152, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 93: $Vk1, 95: 143, 96: $Vl1, 106: $VP, 107: $VQ, 110: $Vm1, 112: $VS, 113: $VT, 114: $Vn1, 115: $Vo1, 116: 149, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 39: 185, 42: $V91, 52: $VL, 57: [1, 184], 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 140, 84: $Vc1, 85: $Vd1, 86: 152, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 93: $Vk1, 95: 143, 96: $Vl1, 106: $VP, 107: $VQ, 110: $Vm1, 112: $VS, 113: $VT, 114: $Vn1, 115: $Vo1, 116: 149, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 39: 186, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 140, 84: $Vc1, 85: $Vd1, 86: 152, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 93: $Vk1, 95: 143, 96: $Vl1, 106: $VP, 107: $VQ, 110: $Vm1, 112: $VS, 113: $VT, 114: $Vn1, 115: $Vo1, 116: 149, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 39: 187, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 140, 84: $Vc1, 85: $Vd1, 86: 152, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 93: $Vk1, 95: 143, 96: $Vl1, 106: $VP, 107: $VQ, 110: $Vm1, 112: $VS, 113: $VT, 114: $Vn1, 115: $Vo1, 116: 149, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 39: 188, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 140, 84: $Vc1, 85: $Vd1, 86: 152, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 93: $Vk1, 95: 143, 96: $Vl1, 106: $VP, 107: $VQ, 110: $Vm1, 112: $VS, 113: $VT, 114: $Vn1, 115: $Vo1, 116: 149, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, { 66: [1, 189] }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 39: 190, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 140, 84: $Vc1, 85: $Vd1, 86: 152, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 93: $Vk1, 95: 143, 96: $Vl1, 106: $VP, 107: $VQ, 110: $Vm1, 112: $VS, 113: $VT, 114: $Vn1, 115: $Vo1, 116: 149, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 39: 191, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 71: [1, 192], 73: $Va1, 81: $Vb1, 83: 140, 84: $Vc1, 85: $Vd1, 86: 152, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 93: $Vk1, 95: 143, 96: $Vl1, 106: $VP, 107: $VQ, 110: $Vm1, 112: $VS, 113: $VT, 114: $Vn1, 115: $Vo1, 116: 149, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 39: 193, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 140, 84: $Vc1, 85: $Vd1, 86: 152, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 93: $Vk1, 95: 143, 96: $Vl1, 106: $VP, 107: $VQ, 110: $Vm1, 112: $VS, 113: $VT, 114: $Vn1, 115: $Vo1, 116: 149, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 39: 194, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 140, 84: $Vc1, 85: $Vd1, 86: 152, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 93: $Vk1, 95: 143, 96: $Vl1, 106: $VP, 107: $VQ, 110: $Vm1, 112: $VS, 113: $VT, 114: $Vn1, 115: $Vo1, 116: 149, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 39: 195, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 140, 84: $Vc1, 85: $Vd1, 86: 152, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 93: $Vk1, 95: 143, 96: $Vl1, 106: $VP, 107: $VQ, 110: $Vm1, 112: $VS, 113: $VT, 114: $Vn1, 115: $Vo1, 116: 149, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, o($V01, [2, 152]), o($Vt1, [2, 3]), { 8: 196, 15: $VD }, { 15: [2, 7] }, o($V4, [2, 28]), o($V21, [2, 33]), o($VJ, [2, 51], { 30: 197, 22: $VE }), o($V41, [2, 75], { 22: [1, 198] }), { 22: [1, 199] }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 39: 200, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 140, 84: $Vc1, 85: $Vd1, 86: 152, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 93: $Vk1, 95: 143, 96: $Vl1, 106: $VP, 107: $VQ, 110: $Vm1, 112: $VS, 113: $VT, 114: $Vn1, 115: $Vo1, 116: 149, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 82: [1, 201], 83: 202, 86: 152, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 93: $Vk1, 95: 143, 96: $Vl1, 106: $VP, 107: $VQ, 110: $Vm1, 112: $VS, 113: $VT, 114: $Vn1, 115: $Vo1, 116: 149, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, o($Vs1, [2, 82]), o($Vs1, [2, 84]), o($Vs1, [2, 85]), o($Vs1, [2, 141]), o($Vs1, [2, 142]), o($Vs1, [2, 143]), o($Vs1, [2, 144]), o($Vs1, [2, 145]), o($Vs1, [2, 146]), o($Vs1, [2, 147]), o($Vs1, [2, 148]), o($Vs1, [2, 149]), o($Vs1, [2, 150]), o($Vs1, [2, 86]), o($Vs1, [2, 87]), o($Vs1, [2, 88]), o($Vs1, [2, 89]), o($Vs1, [2, 90]), o($Vs1, [2, 91]), o($Vs1, [2, 92]), o($Vs1, [2, 93]), o($Vs1, [2, 94]), o($Vs1, [2, 95]), o($Vs1, [2, 96]), { 9: 204, 20: $VG, 21: $VH, 22: $V51, 23: $VI, 24: $V61, 26: $V71, 38: $V81, 40: [1, 203], 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 202, 86: 152, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 93: $Vk1, 95: 143, 96: $Vl1, 106: $VP, 107: $VQ, 110: $Vm1, 112: $VS, 113: $VT, 114: $Vn1, 115: $Vo1, 116: 149, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, { 18: 18, 19: 19, 20: $V6, 21: $V7, 22: $V8, 23: $V9, 32: 24, 33: 25, 34: 26, 35: 27, 36: 28, 37: 29, 38: $Va, 42: [1, 205], 43: 31, 44: $Vb, 46: $Vc, 48: $Vd, 50: 35, 51: 45, 52: $Ve, 54: 46, 66: $Vf, 67: $Vg, 87: $Vh, 88: $Vi, 89: $Vj, 90: $Vk, 91: $Vl, 92: $Vm, 96: $Vn, 106: $Vo, 107: $Vp, 110: $Vq, 112: $Vr, 113: $Vs, 117: 47, 119: $Vt, 120: $Vu, 121: $Vv, 122: $Vw, 123: $Vx, 124: $Vy, 125: $Vz, 126: $VA, 127: $VB, 128: $VC }, { 22: $VE, 30: 206 }, { 22: [1, 207], 26: $VK, 52: $VL, 66: $VM, 67: $VN, 92: $VO, 106: $VP, 107: $VQ, 110: $VR, 112: $VS, 113: $VT, 116: 100, 118: 179, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, { 22: [1, 208] }, { 22: [1, 209] }, { 22: [1, 210], 107: [1, 211] }, o($Vu1, [2, 124]), { 22: [1, 212] }, { 22: [1, 213], 26: $VK, 52: $VL, 66: $VM, 67: $VN, 92: $VO, 106: $VP, 107: $VQ, 110: $VR, 112: $VS, 113: $VT, 116: 100, 118: 179, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, { 22: [1, 214], 26: $VK, 52: $VL, 66: $VM, 67: $VN, 92: $VO, 106: $VP, 107: $VQ, 110: $VR, 112: $VS, 113: $VT, 116: 100, 118: 179, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, { 84: [1, 215] }, o($V11, [2, 104], { 22: [1, 216] }), { 84: [1, 217], 102: [1, 218] }, { 84: [1, 219] }, o($Vr1, [2, 154]), { 84: [1, 220], 102: [1, 221] }, o($V_, [2, 57], { 117: 129, 52: $Ve, 66: $Vf, 67: $Vg, 92: $Vm, 96: $Vn, 106: $Vo, 107: $Vp, 110: $Vq, 112: $Vr, 113: $Vs, 123: $Vx, 124: $Vy, 125: $Vz, 126: $VA, 127: $VB, 128: $VC }), { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 41: [1, 222], 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 202, 86: 152, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 93: $Vk1, 95: 143, 96: $Vl1, 106: $VP, 107: $VQ, 110: $Vm1, 112: $VS, 113: $VT, 114: $Vn1, 115: $Vo1, 116: 149, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 42: $V91, 52: $VL, 56: [1, 223], 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 202, 86: 152, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 93: $Vk1, 95: 143, 96: $Vl1, 106: $VP, 107: $VQ, 110: $Vm1, 112: $VS, 113: $VT, 114: $Vn1, 115: $Vo1, 116: 149, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 39: 224, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 140, 84: $Vc1, 85: $Vd1, 86: 152, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 93: $Vk1, 95: 143, 96: $Vl1, 106: $VP, 107: $VQ, 110: $Vm1, 112: $VS, 113: $VT, 114: $Vn1, 115: $Vo1, 116: 149, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 42: $V91, 52: $VL, 58: [1, 225], 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 202, 86: 152, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 93: $Vk1, 95: 143, 96: $Vl1, 106: $VP, 107: $VQ, 110: $Vm1, 112: $VS, 113: $VT, 114: $Vn1, 115: $Vo1, 116: 149, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 42: $V91, 52: $VL, 60: [1, 226], 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 202, 86: 152, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 93: $Vk1, 95: 143, 96: $Vl1, 106: $VP, 107: $VQ, 110: $Vm1, 112: $VS, 113: $VT, 114: $Vn1, 115: $Vo1, 116: 149, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 42: $V91, 52: $VL, 62: [1, 227], 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 202, 86: 152, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 93: $Vk1, 95: 143, 96: $Vl1, 106: $VP, 107: $VQ, 110: $Vm1, 112: $VS, 113: $VT, 114: $Vn1, 115: $Vo1, 116: 149, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 42: $V91, 52: $VL, 64: [1, 228], 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 202, 86: 152, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 93: $Vk1, 95: 143, 96: $Vl1, 106: $VP, 107: $VQ, 110: $Vm1, 112: $VS, 113: $VT, 114: $Vn1, 115: $Vo1, 116: 149, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, { 67: [1, 229] }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 70: [1, 230], 73: $Va1, 81: $Vb1, 83: 202, 86: 152, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 93: $Vk1, 95: 143, 96: $Vl1, 106: $VP, 107: $VQ, 110: $Vm1, 112: $VS, 113: $VT, 114: $Vn1, 115: $Vo1, 116: 149, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 72: [1, 231], 73: $Va1, 81: $Vb1, 83: 202, 86: 152, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 93: $Vk1, 95: 143, 96: $Vl1, 106: $VP, 107: $VQ, 110: $Vm1, 112: $VS, 113: $VT, 114: $Vn1, 115: $Vo1, 116: 149, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 39: 232, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 140, 84: $Vc1, 85: $Vd1, 86: 152, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 93: $Vk1, 95: 143, 96: $Vl1, 106: $VP, 107: $VQ, 110: $Vm1, 112: $VS, 113: $VT, 114: $Vn1, 115: $Vo1, 116: 149, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 41: [1, 233], 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 202, 86: 152, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 93: $Vk1, 95: 143, 96: $Vl1, 106: $VP, 107: $VQ, 110: $Vm1, 112: $VS, 113: $VT, 114: $Vn1, 115: $Vo1, 116: 149, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 75: [1, 234], 77: [1, 235], 81: $Vb1, 83: 202, 86: 152, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 93: $Vk1, 95: 143, 96: $Vl1, 106: $VP, 107: $VQ, 110: $Vm1, 112: $VS, 113: $VT, 114: $Vn1, 115: $Vo1, 116: 149, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 75: [1, 237], 77: [1, 236], 81: $Vb1, 83: 202, 86: 152, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 93: $Vk1, 95: 143, 96: $Vl1, 106: $VP, 107: $VQ, 110: $Vm1, 112: $VS, 113: $VT, 114: $Vn1, 115: $Vo1, 116: 149, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, { 9: 238, 20: $VG, 21: $VH, 23: $VI }, o($VJ, [2, 52], { 52: $Vq1 }), o($V41, [2, 77]), o($V41, [2, 76]), { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 68: [1, 239], 73: $Va1, 81: $Vb1, 83: 202, 86: 152, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 93: $Vk1, 95: 143, 96: $Vl1, 106: $VP, 107: $VQ, 110: $Vm1, 112: $VS, 113: $VT, 114: $Vn1, 115: $Vo1, 116: 149, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, o($V41, [2, 79]), o($Vs1, [2, 83]), { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 39: 240, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 140, 84: $Vc1, 85: $Vd1, 86: 152, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 93: $Vk1, 95: 143, 96: $Vl1, 106: $VP, 107: $VQ, 110: $Vm1, 112: $VS, 113: $VT, 114: $Vn1, 115: $Vo1, 116: 149, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, o($Vp1, $V5, { 17: 241 }), o($VF, [2, 43]), { 51: 242, 52: $Ve, 54: 46, 66: $Vf, 67: $Vg, 92: $Vm, 96: $Vn, 106: $Vo, 107: $Vp, 110: $Vq, 112: $Vr, 113: $Vs, 117: 47, 123: $Vx, 124: $Vy, 125: $Vz, 126: $VA, 127: $VB, 128: $VC }, { 22: $Vv1, 66: $Vw1, 67: $Vx1, 87: $Vy1, 97: 243, 103: $Vz1, 106: $VA1, 108: 244, 109: 245, 110: $VB1, 111: $VC1, 112: $VD1, 113: $VE1, 114: $VF1 }, { 22: $Vv1, 66: $Vw1, 67: $Vx1, 87: $Vy1, 97: 257, 103: $Vz1, 106: $VA1, 108: 244, 109: 245, 110: $VB1, 111: $VC1, 112: $VD1, 113: $VE1, 114: $VF1 }, { 22: $Vv1, 66: $Vw1, 67: $Vx1, 87: $Vy1, 97: 258, 103: $Vz1, 105: [1, 259], 106: $VA1, 108: 244, 109: 245, 110: $VB1, 111: $VC1, 112: $VD1, 113: $VE1, 114: $VF1 }, { 22: $Vv1, 66: $Vw1, 67: $Vx1, 87: $Vy1, 97: 260, 103: $Vz1, 105: [1, 261], 106: $VA1, 108: 244, 109: 245, 110: $VB1, 111: $VC1, 112: $VD1, 113: $VE1, 114: $VF1 }, { 106: [1, 262] }, { 22: $Vv1, 66: $Vw1, 67: $Vx1, 87: $Vy1, 97: 263, 103: $Vz1, 106: $VA1, 108: 244, 109: 245, 110: $VB1, 111: $VC1, 112: $VD1, 113: $VE1, 114: $VF1 }, { 22: $Vv1, 66: $Vw1, 67: $Vx1, 87: $Vy1, 97: 264, 103: $Vz1, 106: $VA1, 108: 244, 109: 245, 110: $VB1, 111: $VC1, 112: $VD1, 113: $VE1, 114: $VF1 }, { 26: $VK, 52: $VL, 66: $VM, 67: $VN, 92: $VO, 98: 265, 106: $VP, 107: $VQ, 110: $VR, 112: $VS, 113: $VT, 116: 100, 118: 98, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, o($V11, [2, 103]), { 84: [1, 266] }, o($V11, [2, 107], { 22: [1, 267] }), o($V11, [2, 108]), o($V11, [2, 111]), o($V11, [2, 113], { 22: [1, 268] }), o($V11, [2, 114]), o($V$, [2, 58]), o($V$, [2, 59]), { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 42: $V91, 52: $VL, 58: [1, 269], 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 202, 86: 152, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 93: $Vk1, 95: 143, 96: $Vl1, 106: $VP, 107: $VQ, 110: $Vm1, 112: $VS, 113: $VT, 114: $Vn1, 115: $Vo1, 116: 149, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, o($V$, [2, 66]), o($V$, [2, 61]), o($V$, [2, 62]), o($V$, [2, 63]), { 66: [1, 270] }, o($V$, [2, 65]), o($V$, [2, 67]), { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 72: [1, 271], 73: $Va1, 81: $Vb1, 83: 202, 86: 152, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 93: $Vk1, 95: 143, 96: $Vl1, 106: $VP, 107: $VQ, 110: $Vm1, 112: $VS, 113: $VT, 114: $Vn1, 115: $Vo1, 116: 149, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, o($V$, [2, 69]), o($V$, [2, 70]), o($V$, [2, 72]), o($V$, [2, 71]), o($V$, [2, 73]), o($Vt1, [2, 4]), o([22, 52, 66, 67, 92, 96, 106, 107, 110, 112, 113, 123, 124, 125, 126, 127, 128], [2, 81]), { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 41: [1, 272], 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 202, 86: 152, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 93: $Vk1, 95: 143, 96: $Vl1, 106: $VP, 107: $VQ, 110: $Vm1, 112: $VS, 113: $VT, 114: $Vn1, 115: $Vo1, 116: 149, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, { 18: 18, 19: 19, 20: $V6, 21: $V7, 22: $V8, 23: $V9, 32: 24, 33: 25, 34: 26, 35: 27, 36: 28, 37: 29, 38: $Va, 42: [1, 273], 43: 31, 44: $Vb, 46: $Vc, 48: $Vd, 50: 35, 51: 45, 52: $Ve, 54: 46, 66: $Vf, 67: $Vg, 87: $Vh, 88: $Vi, 89: $Vj, 90: $Vk, 91: $Vl, 92: $Vm, 96: $Vn, 106: $Vo, 107: $Vp, 110: $Vq, 112: $Vr, 113: $Vs, 117: 47, 119: $Vt, 120: $Vu, 121: $Vv, 122: $Vw, 123: $Vx, 124: $Vy, 125: $Vz, 126: $VA, 127: $VB, 128: $VC }, o($V_, [2, 56]), o($V11, [2, 116], { 107: $VG1 }), o($VH1, [2, 126], { 109: 275, 22: $Vv1, 66: $Vw1, 67: $Vx1, 87: $Vy1, 103: $Vz1, 106: $VA1, 110: $VB1, 111: $VC1, 112: $VD1, 113: $VE1, 114: $VF1 }), o($VI1, [2, 128]), o($VI1, [2, 130]), o($VI1, [2, 131]), o($VI1, [2, 132]), o($VI1, [2, 133]), o($VI1, [2, 134]), o($VI1, [2, 135]), o($VI1, [2, 136]), o($VI1, [2, 137]), o($VI1, [2, 138]), o($VI1, [2, 139]), o($VI1, [2, 140]), o($V11, [2, 117], { 107: $VG1 }), o($V11, [2, 118], { 107: $VG1 }), { 22: [1, 276] }, o($V11, [2, 119], { 107: $VG1 }), { 22: [1, 277] }, o($Vu1, [2, 125]), o($V11, [2, 99], { 107: $VG1 }), o($V11, [2, 100], { 107: $VG1 }), o($V11, [2, 101], { 116: 100, 118: 179, 26: $VK, 52: $VL, 66: $VM, 67: $VN, 92: $VO, 106: $VP, 107: $VQ, 110: $VR, 112: $VS, 113: $VT, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }), o($V11, [2, 105]), { 102: [1, 278] }, { 102: [1, 279] }, { 58: [1, 280] }, { 68: [1, 281] }, { 72: [1, 282] }, { 9: 283, 20: $VG, 21: $VH, 23: $VI }, o($VF, [2, 42]), { 22: $Vv1, 66: $Vw1, 67: $Vx1, 87: $Vy1, 103: $Vz1, 106: $VA1, 108: 284, 109: 245, 110: $VB1, 111: $VC1, 112: $VD1, 113: $VE1, 114: $VF1 }, o($VI1, [2, 129]), { 26: $VK, 52: $VL, 66: $VM, 67: $VN, 92: $VO, 98: 285, 106: $VP, 107: $VQ, 110: $VR, 112: $VS, 113: $VT, 116: 100, 118: 98, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, { 26: $VK, 52: $VL, 66: $VM, 67: $VN, 92: $VO, 98: 286, 106: $VP, 107: $VQ, 110: $VR, 112: $VS, 113: $VT, 116: 100, 118: 98, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, o($V11, [2, 109]), o($V11, [2, 115]), o($V$, [2, 60]), { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 39: 287, 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 140, 84: $Vc1, 85: $Vd1, 86: 152, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 93: $Vk1, 95: 143, 96: $Vl1, 106: $VP, 107: $VQ, 110: $Vm1, 112: $VS, 113: $VT, 114: $Vn1, 115: $Vo1, 116: 149, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, o($V$, [2, 68]), o($Vp1, $V5, { 17: 288 }), o($VH1, [2, 127], { 109: 275, 22: $Vv1, 66: $Vw1, 67: $Vx1, 87: $Vy1, 103: $Vz1, 106: $VA1, 110: $VB1, 111: $VC1, 112: $VD1, 113: $VE1, 114: $VF1 }), o($V11, [2, 122], { 116: 100, 118: 179, 22: [1, 289], 26: $VK, 52: $VL, 66: $VM, 67: $VN, 92: $VO, 106: $VP, 107: $VQ, 110: $VR, 112: $VS, 113: $VT, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }), o($V11, [2, 123], { 116: 100, 118: 179, 22: [1, 290], 26: $VK, 52: $VL, 66: $VM, 67: $VN, 92: $VO, 106: $VP, 107: $VQ, 110: $VR, 112: $VS, 113: $VT, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }), { 22: $V51, 24: $V61, 26: $V71, 38: $V81, 41: [1, 291], 42: $V91, 52: $VL, 66: $VM, 67: $VN, 73: $Va1, 81: $Vb1, 83: 202, 86: 152, 87: $Ve1, 88: $Vf1, 89: $Vg1, 90: $Vh1, 91: $Vi1, 92: $Vj1, 93: $Vk1, 95: 143, 96: $Vl1, 106: $VP, 107: $VQ, 110: $Vm1, 112: $VS, 113: $VT, 114: $Vn1, 115: $Vo1, 116: 149, 123: $VU, 124: $VV, 125: $VW, 126: $VX, 127: $VY, 128: $VZ }, { 18: 18, 19: 19, 20: $V6, 21: $V7, 22: $V8, 23: $V9, 32: 24, 33: 25, 34: 26, 35: 27, 36: 28, 37: 29, 38: $Va, 42: [1, 292], 43: 31, 44: $Vb, 46: $Vc, 48: $Vd, 50: 35, 51: 45, 52: $Ve, 54: 46, 66: $Vf, 67: $Vg, 87: $Vh, 88: $Vi, 89: $Vj, 90: $Vk, 91: $Vl, 92: $Vm, 96: $Vn, 106: $Vo, 107: $Vp, 110: $Vq, 112: $Vr, 113: $Vs, 117: 47, 119: $Vt, 120: $Vu, 121: $Vv, 122: $Vw, 123: $Vx, 124: $Vy, 125: $Vz, 126: $VA, 127: $VB, 128: $VC }, { 22: $Vv1, 66: $Vw1, 67: $Vx1, 87: $Vy1, 97: 293, 103: $Vz1, 106: $VA1, 108: 244, 109: 245, 110: $VB1, 111: $VC1, 112: $VD1, 113: $VE1, 114: $VF1 }, { 22: $Vv1, 66: $Vw1, 67: $Vx1, 87: $Vy1, 97: 294, 103: $Vz1, 106: $VA1, 108: 244, 109: 245, 110: $VB1, 111: $VC1, 112: $VD1, 113: $VE1, 114: $VF1 }, o($V$, [2, 64]), o($VF, [2, 41]), o($V11, [2, 120], { 107: $VG1 }), o($V11, [2, 121], { 107: $VG1 })],
      defaultActions: { 2: [2, 1], 9: [2, 5], 10: [2, 2], 132: [2, 7] },
      parseError: function parseError2(str2, hash) {
        if (hash.recoverable) {
          this.trace(str2);
        } else {
          var error = new Error(str2);
          error.hash = hash;
          throw error;
        }
      },
      parse: function parse2(input) {
        var self2 = this, stack = [0], tstack = [], vstack = [null], lstack = [], table = this.table, yytext = "", yylineno = 0, yyleng = 0, TERROR = 2, EOF = 1;
        var args = lstack.slice.call(arguments, 1);
        var lexer2 = Object.create(this.lexer);
        var sharedState = { yy: {} };
        for (var k in this.yy) {
          if (Object.prototype.hasOwnProperty.call(this.yy, k)) {
            sharedState.yy[k] = this.yy[k];
          }
        }
        lexer2.setInput(input, sharedState.yy);
        sharedState.yy.lexer = lexer2;
        sharedState.yy.parser = this;
        if (typeof lexer2.yylloc == "undefined") {
          lexer2.yylloc = {};
        }
        var yyloc = lexer2.yylloc;
        lstack.push(yyloc);
        var ranges = lexer2.options && lexer2.options.ranges;
        if (typeof sharedState.yy.parseError === "function") {
          this.parseError = sharedState.yy.parseError;
        } else {
          this.parseError = Object.getPrototypeOf(this).parseError;
        }
        function lex2() {
          var token2;
          token2 = tstack.pop() || lexer2.lex() || EOF;
          if (typeof token2 !== "number") {
            if (token2 instanceof Array) {
              tstack = token2;
              token2 = tstack.pop();
            }
            token2 = self2.symbols_[token2] || token2;
          }
          return token2;
        }
        var symbol, state2, action, r, yyval = {}, p, len, newState, expected;
        while (true) {
          state2 = stack[stack.length - 1];
          if (this.defaultActions[state2]) {
            action = this.defaultActions[state2];
          } else {
            if (symbol === null || typeof symbol == "undefined") {
              symbol = lex2();
            }
            action = table[state2] && table[state2][symbol];
          }
          if (typeof action === "undefined" || !action.length || !action[0]) {
            var errStr = "";
            expected = [];
            for (p in table[state2]) {
              if (this.terminals_[p] && p > TERROR) {
                expected.push("'" + this.terminals_[p] + "'");
              }
            }
            if (lexer2.showPosition) {
              errStr = "Parse error on line " + (yylineno + 1) + ":\n" + lexer2.showPosition() + "\nExpecting " + expected.join(", ") + ", got '" + (this.terminals_[symbol] || symbol) + "'";
            } else {
              errStr = "Parse error on line " + (yylineno + 1) + ": Unexpected " + (symbol == EOF ? "end of input" : "'" + (this.terminals_[symbol] || symbol) + "'");
            }
            this.parseError(errStr, {
              text: lexer2.match,
              token: this.terminals_[symbol] || symbol,
              line: lexer2.yylineno,
              loc: yyloc,
              expected
            });
          }
          if (action[0] instanceof Array && action.length > 1) {
            throw new Error("Parse Error: multiple actions possible at state: " + state2 + ", token: " + symbol);
          }
          switch (action[0]) {
            case 1:
              stack.push(symbol);
              vstack.push(lexer2.yytext);
              lstack.push(lexer2.yylloc);
              stack.push(action[1]);
              symbol = null;
              {
                yyleng = lexer2.yyleng;
                yytext = lexer2.yytext;
                yylineno = lexer2.yylineno;
                yyloc = lexer2.yylloc;
              }
              break;
            case 2:
              len = this.productions_[action[1]][1];
              yyval.$ = vstack[vstack.length - len];
              yyval._$ = {
                first_line: lstack[lstack.length - (len || 1)].first_line,
                last_line: lstack[lstack.length - 1].last_line,
                first_column: lstack[lstack.length - (len || 1)].first_column,
                last_column: lstack[lstack.length - 1].last_column
              };
              if (ranges) {
                yyval._$.range = [
                  lstack[lstack.length - (len || 1)].range[0],
                  lstack[lstack.length - 1].range[1]
                ];
              }
              r = this.performAction.apply(yyval, [
                yytext,
                yyleng,
                yylineno,
                sharedState.yy,
                action[1],
                vstack,
                lstack
              ].concat(args));
              if (typeof r !== "undefined") {
                return r;
              }
              if (len) {
                stack = stack.slice(0, -1 * len * 2);
                vstack = vstack.slice(0, -1 * len);
                lstack = lstack.slice(0, -1 * len);
              }
              stack.push(this.productions_[action[1]][0]);
              vstack.push(yyval.$);
              lstack.push(yyval._$);
              newState = table[stack[stack.length - 2]][stack[stack.length - 1]];
              stack.push(newState);
              break;
            case 3:
              return true;
          }
        }
        return true;
      }
    };
    var lexer = function() {
      var lexer2 = {
        EOF: 1,
        parseError: function parseError2(str2, hash) {
          if (this.yy.parser) {
            this.yy.parser.parseError(str2, hash);
          } else {
            throw new Error(str2);
          }
        },
        // resets the lexer, sets new input
        setInput: function(input, yy) {
          this.yy = yy || this.yy || {};
          this._input = input;
          this._more = this._backtrack = this.done = false;
          this.yylineno = this.yyleng = 0;
          this.yytext = this.matched = this.match = "";
          this.conditionStack = ["INITIAL"];
          this.yylloc = {
            first_line: 1,
            first_column: 0,
            last_line: 1,
            last_column: 0
          };
          if (this.options.ranges) {
            this.yylloc.range = [0, 0];
          }
          this.offset = 0;
          return this;
        },
        // consumes and returns one char from the input
        input: function() {
          var ch = this._input[0];
          this.yytext += ch;
          this.yyleng++;
          this.offset++;
          this.match += ch;
          this.matched += ch;
          var lines = ch.match(/(?:\r\n?|\n).*/g);
          if (lines) {
            this.yylineno++;
            this.yylloc.last_line++;
          } else {
            this.yylloc.last_column++;
          }
          if (this.options.ranges) {
            this.yylloc.range[1]++;
          }
          this._input = this._input.slice(1);
          return ch;
        },
        // unshifts one char (or a string) into the input
        unput: function(ch) {
          var len = ch.length;
          var lines = ch.split(/(?:\r\n?|\n)/g);
          this._input = ch + this._input;
          this.yytext = this.yytext.substr(0, this.yytext.length - len);
          this.offset -= len;
          var oldLines = this.match.split(/(?:\r\n?|\n)/g);
          this.match = this.match.substr(0, this.match.length - 1);
          this.matched = this.matched.substr(0, this.matched.length - 1);
          if (lines.length - 1) {
            this.yylineno -= lines.length - 1;
          }
          var r = this.yylloc.range;
          this.yylloc = {
            first_line: this.yylloc.first_line,
            last_line: this.yylineno + 1,
            first_column: this.yylloc.first_column,
            last_column: lines ? (lines.length === oldLines.length ? this.yylloc.first_column : 0) + oldLines[oldLines.length - lines.length].length - lines[0].length : this.yylloc.first_column - len
          };
          if (this.options.ranges) {
            this.yylloc.range = [r[0], r[0] + this.yyleng - len];
          }
          this.yyleng = this.yytext.length;
          return this;
        },
        // When called from action, caches matched text and appends it on next action
        more: function() {
          this._more = true;
          return this;
        },
        // When called from action, signals the lexer that this rule fails to match the input, so the next matching rule (regex) should be tested instead.
        reject: function() {
          if (this.options.backtrack_lexer) {
            this._backtrack = true;
          } else {
            return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". You can only invoke reject() in the lexer when the lexer is of the backtracking persuasion (options.backtrack_lexer = true).\n" + this.showPosition(), {
              text: "",
              token: null,
              line: this.yylineno
            });
          }
          return this;
        },
        // retain first n characters of the match
        less: function(n) {
          this.unput(this.match.slice(n));
        },
        // displays already matched input, i.e. for error messages
        pastInput: function() {
          var past = this.matched.substr(0, this.matched.length - this.match.length);
          return (past.length > 20 ? "..." : "") + past.substr(-20).replace(/\n/g, "");
        },
        // displays upcoming input, i.e. for error messages
        upcomingInput: function() {
          var next2 = this.match;
          if (next2.length < 20) {
            next2 += this._input.substr(0, 20 - next2.length);
          }
          return (next2.substr(0, 20) + (next2.length > 20 ? "..." : "")).replace(/\n/g, "");
        },
        // displays the character position where the lexing error occurred, i.e. for error messages
        showPosition: function() {
          var pre = this.pastInput();
          var c2 = new Array(pre.length + 1).join("-");
          return pre + this.upcomingInput() + "\n" + c2 + "^";
        },
        // test the lexed token: return FALSE when not a match, otherwise return token
        test_match: function(match, indexed_rule) {
          var token2, lines, backup;
          if (this.options.backtrack_lexer) {
            backup = {
              yylineno: this.yylineno,
              yylloc: {
                first_line: this.yylloc.first_line,
                last_line: this.last_line,
                first_column: this.yylloc.first_column,
                last_column: this.yylloc.last_column
              },
              yytext: this.yytext,
              match: this.match,
              matches: this.matches,
              matched: this.matched,
              yyleng: this.yyleng,
              offset: this.offset,
              _more: this._more,
              _input: this._input,
              yy: this.yy,
              conditionStack: this.conditionStack.slice(0),
              done: this.done
            };
            if (this.options.ranges) {
              backup.yylloc.range = this.yylloc.range.slice(0);
            }
          }
          lines = match[0].match(/(?:\r\n?|\n).*/g);
          if (lines) {
            this.yylineno += lines.length;
          }
          this.yylloc = {
            first_line: this.yylloc.last_line,
            last_line: this.yylineno + 1,
            first_column: this.yylloc.last_column,
            last_column: lines ? lines[lines.length - 1].length - lines[lines.length - 1].match(/\r?\n?/)[0].length : this.yylloc.last_column + match[0].length
          };
          this.yytext += match[0];
          this.match += match[0];
          this.matches = match;
          this.yyleng = this.yytext.length;
          if (this.options.ranges) {
            this.yylloc.range = [this.offset, this.offset += this.yyleng];
          }
          this._more = false;
          this._backtrack = false;
          this._input = this._input.slice(match[0].length);
          this.matched += match[0];
          token2 = this.performAction.call(this, this.yy, this, indexed_rule, this.conditionStack[this.conditionStack.length - 1]);
          if (this.done && this._input) {
            this.done = false;
          }
          if (token2) {
            return token2;
          } else if (this._backtrack) {
            for (var k in backup) {
              this[k] = backup[k];
            }
            return false;
          }
          return false;
        },
        // return next match in input
        next: function() {
          if (this.done) {
            return this.EOF;
          }
          if (!this._input) {
            this.done = true;
          }
          var token2, match, tempMatch, index2;
          if (!this._more) {
            this.yytext = "";
            this.match = "";
          }
          var rules = this._currentRules();
          for (var i2 = 0; i2 < rules.length; i2++) {
            tempMatch = this._input.match(this.rules[rules[i2]]);
            if (tempMatch && (!match || tempMatch[0].length > match[0].length)) {
              match = tempMatch;
              index2 = i2;
              if (this.options.backtrack_lexer) {
                token2 = this.test_match(tempMatch, rules[i2]);
                if (token2 !== false) {
                  return token2;
                } else if (this._backtrack) {
                  match = false;
                  continue;
                } else {
                  return false;
                }
              } else if (!this.options.flex) {
                break;
              }
            }
          }
          if (match) {
            token2 = this.test_match(match, rules[index2]);
            if (token2 !== false) {
              return token2;
            }
            return false;
          }
          if (this._input === "") {
            return this.EOF;
          } else {
            return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". Unrecognized text.\n" + this.showPosition(), {
              text: "",
              token: null,
              line: this.yylineno
            });
          }
        },
        // return next match that has a token
        lex: function lex2() {
          var r = this.next();
          if (r) {
            return r;
          } else {
            return this.lex();
          }
        },
        // activates a new lexer condition state (pushes the new lexer condition state onto the condition stack)
        begin: function begin(condition) {
          this.conditionStack.push(condition);
        },
        // pop the previously active lexer condition state off the condition stack
        popState: function popState() {
          var n = this.conditionStack.length - 1;
          if (n > 0) {
            return this.conditionStack.pop();
          } else {
            return this.conditionStack[0];
          }
        },
        // produce the lexer rule set which is active for the currently active lexer condition state
        _currentRules: function _currentRules() {
          if (this.conditionStack.length && this.conditionStack[this.conditionStack.length - 1]) {
            return this.conditions[this.conditionStack[this.conditionStack.length - 1]].rules;
          } else {
            return this.conditions["INITIAL"].rules;
          }
        },
        // return the currently active lexer condition state; when an index argument is provided it produces the N-th previous condition state, if available
        topState: function topState(n) {
          n = this.conditionStack.length - 1 - Math.abs(n || 0);
          if (n >= 0) {
            return this.conditionStack[n];
          } else {
            return "INITIAL";
          }
        },
        // alias for begin(condition)
        pushState: function pushState(condition) {
          this.begin(condition);
        },
        // return the number of states currently on the stack
        stateStackSize: function stateStackSize() {
          return this.conditionStack.length;
        },
        options: {},
        performAction: function anonymous(yy, yy_, $avoiding_name_collisions, YY_START) {
          switch ($avoiding_name_collisions) {
            case 0:
              this.begin("open_directive");
              return 12;
            case 1:
              this.begin("type_directive");
              return 13;
            case 2:
              this.popState();
              this.begin("arg_directive");
              return 10;
            case 3:
              this.popState();
              this.popState();
              return 15;
            case 4:
              return 14;
            case 5:
              this.begin("acc_title");
              return 44;
            case 6:
              this.popState();
              return "acc_title_value";
            case 7:
              this.begin("acc_descr");
              return 46;
            case 8:
              this.popState();
              return "acc_descr_value";
            case 9:
              this.begin("acc_descr_multiline");
              break;
            case 10:
              this.popState();
              break;
            case 11:
              return "acc_descr_multiline_value";
            case 12:
              this.begin("md_string");
              break;
            case 13:
              return "MD_STR";
            case 14:
              this.popState();
              break;
            case 15:
              this.begin("string");
              break;
            case 16:
              this.popState();
              break;
            case 17:
              return "STR";
            case 18:
              return 87;
            case 19:
              return 96;
            case 20:
              return 88;
            case 21:
              return 105;
            case 22:
              return 89;
            case 23:
              return 90;
            case 24:
              this.begin("href");
              break;
            case 25:
              this.popState();
              break;
            case 26:
              return 101;
            case 27:
              this.begin("callbackname");
              break;
            case 28:
              this.popState();
              break;
            case 29:
              this.popState();
              this.begin("callbackargs");
              break;
            case 30:
              return 99;
            case 31:
              this.popState();
              break;
            case 32:
              return 100;
            case 33:
              this.begin("click");
              break;
            case 34:
              this.popState();
              break;
            case 35:
              return 91;
            case 36:
              if (yy.lex.firstGraph()) {
                this.begin("dir");
              }
              return 24;
            case 37:
              if (yy.lex.firstGraph()) {
                this.begin("dir");
              }
              return 24;
            case 38:
              if (yy.lex.firstGraph()) {
                this.begin("dir");
              }
              return 24;
            case 39:
              return 38;
            case 40:
              return 42;
            case 41:
              return 102;
            case 42:
              return 102;
            case 43:
              return 102;
            case 44:
              return 102;
            case 45:
              this.popState();
              return 25;
            case 46:
              this.popState();
              return 26;
            case 47:
              this.popState();
              return 26;
            case 48:
              this.popState();
              return 26;
            case 49:
              this.popState();
              return 26;
            case 50:
              this.popState();
              return 26;
            case 51:
              this.popState();
              return 26;
            case 52:
              this.popState();
              return 26;
            case 53:
              this.popState();
              return 26;
            case 54:
              this.popState();
              return 26;
            case 55:
              this.popState();
              return 26;
            case 56:
              return 119;
            case 57:
              return 120;
            case 58:
              return 121;
            case 59:
              return 122;
            case 60:
              return 106;
            case 61:
              return 112;
            case 62:
              return 53;
            case 63:
              return 67;
            case 64:
              return 52;
            case 65:
              return 20;
            case 66:
              return 107;
            case 67:
              return 127;
            case 68:
              return 82;
            case 69:
              return 82;
            case 70:
              return 82;
            case 71:
              return 82;
            case 72:
              return 81;
            case 73:
              return 81;
            case 74:
              return 81;
            case 75:
              return 59;
            case 76:
              return 60;
            case 77:
              return 61;
            case 78:
              return 62;
            case 79:
              return 63;
            case 80:
              return 64;
            case 81:
              return 65;
            case 82:
              return 69;
            case 83:
              return 70;
            case 84:
              return 55;
            case 85:
              return 56;
            case 86:
              return 110;
            case 87:
              return 113;
            case 88:
              return 128;
            case 89:
              return 125;
            case 90:
              return 114;
            case 91:
              return 126;
            case 92:
              return 126;
            case 93:
              return 115;
            case 94:
              return 73;
            case 95:
              return 93;
            case 96:
              return "SEP";
            case 97:
              return 92;
            case 98:
              return 66;
            case 99:
              return 75;
            case 100:
              return 74;
            case 101:
              return 77;
            case 102:
              return 76;
            case 103:
              return 123;
            case 104:
              return 124;
            case 105:
              return 68;
            case 106:
              return 57;
            case 107:
              return 58;
            case 108:
              return 40;
            case 109:
              return 41;
            case 110:
              return 71;
            case 111:
              return 72;
            case 112:
              return 134;
            case 113:
              return 21;
            case 114:
              return 22;
            case 115:
              return 23;
          }
        },
        rules: [/^(?:%%\{)/, /^(?:((?:(?!\}%%)[^:.])*))/, /^(?::)/, /^(?:\}%%)/, /^(?:((?:(?!\}%%).|\n)*))/, /^(?:accTitle\s*:\s*)/, /^(?:(?!\n||)*[^\n]*)/, /^(?:accDescr\s*:\s*)/, /^(?:(?!\n||)*[^\n]*)/, /^(?:accDescr\s*\{\s*)/, /^(?:[\}])/, /^(?:[^\}]*)/, /^(?:["][`])/, /^(?:[^`"]+)/, /^(?:[`]["])/, /^(?:["])/, /^(?:["])/, /^(?:[^"]*)/, /^(?:style\b)/, /^(?:default\b)/, /^(?:linkStyle\b)/, /^(?:interpolate\b)/, /^(?:classDef\b)/, /^(?:class\b)/, /^(?:href[\s]+["])/, /^(?:["])/, /^(?:[^"]*)/, /^(?:call[\s]+)/, /^(?:\([\s]*\))/, /^(?:\()/, /^(?:[^(]*)/, /^(?:\))/, /^(?:[^)]*)/, /^(?:click[\s]+)/, /^(?:[\s\n])/, /^(?:[^\s\n]*)/, /^(?:flowchart-elk\b)/, /^(?:graph\b)/, /^(?:flowchart\b)/, /^(?:subgraph\b)/, /^(?:end\b\s*)/, /^(?:_self\b)/, /^(?:_blank\b)/, /^(?:_parent\b)/, /^(?:_top\b)/, /^(?:(\r?\n)*\s*\n)/, /^(?:\s*LR\b)/, /^(?:\s*RL\b)/, /^(?:\s*TB\b)/, /^(?:\s*BT\b)/, /^(?:\s*TD\b)/, /^(?:\s*BR\b)/, /^(?:\s*<)/, /^(?:\s*>)/, /^(?:\s*\^)/, /^(?:\s*v\b)/, /^(?:.*direction\s+TB[^\n]*)/, /^(?:.*direction\s+BT[^\n]*)/, /^(?:.*direction\s+RL[^\n]*)/, /^(?:.*direction\s+LR[^\n]*)/, /^(?:[0-9]+)/, /^(?:#)/, /^(?::::)/, /^(?::)/, /^(?:&)/, /^(?:;)/, /^(?:,)/, /^(?:\*)/, /^(?:\s*[xo<]?--+[-xo>]\s*)/, /^(?:\s*[xo<]?==+[=xo>]\s*)/, /^(?:\s*[xo<]?-?\.+-[xo>]?\s*)/, /^(?:\s*~~[\~]+\s*)/, /^(?:\s*[xo<]?--\s*)/, /^(?:\s*[xo<]?==\s*)/, /^(?:\s*[xo<]?-\.\s*)/, /^(?:\(-)/, /^(?:-\))/, /^(?:\(\[)/, /^(?:\]\))/, /^(?:\[\[)/, /^(?:\]\])/, /^(?:\[\|)/, /^(?:\[\()/, /^(?:\)\])/, /^(?:\(\(\()/, /^(?:\)\)\))/, /^(?:-)/, /^(?:\.)/, /^(?:[\_])/, /^(?:\+)/, /^(?:%)/, /^(?:=)/, /^(?:=)/, /^(?:<)/, /^(?:>)/, /^(?:\^)/, /^(?:\\\|)/, /^(?:v\b)/, /^(?:[A-Za-z]+)/, /^(?:\\\])/, /^(?:\[\/)/, /^(?:\/\])/, /^(?:\[\\)/, /^(?:[!"#$%&'*+,-.`?\\_/])/, /^(?:[\u00AA\u00B5\u00BA\u00C0-\u00D6\u00D8-\u00F6]|[\u00F8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377]|[\u037A-\u037D\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5]|[\u03F7-\u0481\u048A-\u0527\u0531-\u0556\u0559\u0561-\u0587\u05D0-\u05EA]|[\u05F0-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE]|[\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA]|[\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u08A0]|[\u08A2-\u08AC\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0977]|[\u0979-\u097F\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2]|[\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u0A05-\u0A0A]|[\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39]|[\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8]|[\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0B05-\u0B0C]|[\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C]|[\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99]|[\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0]|[\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C33\u0C35-\u0C39\u0C3D]|[\u0C58\u0C59\u0C60\u0C61\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3]|[\u0CB5-\u0CB9\u0CBD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D05-\u0D0C\u0D0E-\u0D10]|[\u0D12-\u0D3A\u0D3D\u0D4E\u0D60\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1]|[\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81]|[\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3]|[\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6]|[\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A]|[\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081]|[\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D]|[\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0]|[\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310]|[\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F4\u1401-\u166C]|[\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u1700-\u170C\u170E-\u1711]|[\u1720-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7]|[\u17DC\u1820-\u1877\u1880-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191C]|[\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19C1-\u19C7\u1A00-\u1A16]|[\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4B\u1B83-\u1BA0\u1BAE\u1BAF]|[\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1CE9-\u1CEC]|[\u1CEE-\u1CF1\u1CF5\u1CF6\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D]|[\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D]|[\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3]|[\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F]|[\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128]|[\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2183\u2184]|[\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3]|[\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6]|[\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE]|[\u2DD0-\u2DD6\u2DD8-\u2DDE\u2E2F\u3005\u3006\u3031-\u3035\u303B\u303C]|[\u3041-\u3096\u309D-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312D]|[\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FCC]|[\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B]|[\uA640-\uA66E\uA67F-\uA697\uA6A0-\uA6E5\uA717-\uA71F\uA722-\uA788]|[\uA78B-\uA78E\uA790-\uA793\uA7A0-\uA7AA\uA7F8-\uA801\uA803-\uA805]|[\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB]|[\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uAA00-\uAA28]|[\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA80-\uAAAF\uAAB1\uAAB5]|[\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4]|[\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E]|[\uABC0-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D]|[\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36]|[\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D]|[\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC]|[\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF]|[\uFFD2-\uFFD7\uFFDA-\uFFDC])/, /^(?:\|)/, /^(?:\()/, /^(?:\))/, /^(?:\[)/, /^(?:\])/, /^(?:\{)/, /^(?:\})/, /^(?:")/, /^(?:(\r?\n)+)/, /^(?:\s)/, /^(?:$)/],
        conditions: { "close_directive": { "rules": [], "inclusive": false }, "arg_directive": { "rules": [3, 4], "inclusive": false }, "type_directive": { "rules": [2, 3], "inclusive": false }, "open_directive": { "rules": [1], "inclusive": false }, "callbackargs": { "rules": [31, 32], "inclusive": false }, "callbackname": { "rules": [28, 29, 30], "inclusive": false }, "href": { "rules": [25, 26], "inclusive": false }, "click": { "rules": [34, 35], "inclusive": false }, "vertex": { "rules": [], "inclusive": false }, "dir": { "rules": [45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55], "inclusive": false }, "acc_descr_multiline": { "rules": [10, 11], "inclusive": false }, "acc_descr": { "rules": [8], "inclusive": false }, "acc_title": { "rules": [6], "inclusive": false }, "md_string": { "rules": [13, 14], "inclusive": false }, "string": { "rules": [16, 17], "inclusive": false }, "INITIAL": { "rules": [0, 5, 7, 9, 12, 15, 18, 19, 20, 21, 22, 23, 24, 27, 33, 36, 37, 38, 39, 40, 41, 42, 43, 44, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115], "inclusive": true } }
      };
      return lexer2;
    }();
    parser2.lexer = lexer;
    function Parser() {
      this.yy = {};
    }
    Parser.prototype = parser2;
    parser2.Parser = Parser;
    return new Parser();
  }();
  parser$m.parser = parser$m;
  const parser$n = parser$m;
  const MERMAID_DOM_ID_PREFIX$1 = "flowchart-";
  let vertexCounter = 0;
  let config$1 = getConfig$1();
  let vertices = {};
  let edges = [];
  let classes$2 = {};
  let subGraphs = [];
  let subGraphLookup = {};
  let tooltips = {};
  let subCount = 0;
  let firstGraphFlag = true;
  let direction$3;
  let version;
  let funs$1 = [];
  const sanitizeText$3 = (txt) => common$1.sanitizeText(txt, config$1);
  const parseDirective$b = function(statement, context, type2) {
    mermaidAPI.parseDirective(this, statement, context, type2);
  };
  const lookUpDomId$1 = function(id2) {
    const veritceKeys = Object.keys(vertices);
    for (const veritceKey of veritceKeys) {
      if (vertices[veritceKey].id === id2) {
        return vertices[veritceKey].domId;
      }
    }
    return id2;
  };
  const addVertex = function(_id, textObj, type2, style, classes2, dir, props = {}) {
    let txt;
    let id2 = _id;
    if (id2 === void 0) {
      return;
    }
    if (id2.trim().length === 0) {
      return;
    }
    if (vertices[id2] === void 0) {
      vertices[id2] = {
        id: id2,
        labelType: "text",
        domId: MERMAID_DOM_ID_PREFIX$1 + id2 + "-" + vertexCounter,
        styles: [],
        classes: []
      };
    }
    vertexCounter++;
    if (textObj !== void 0) {
      config$1 = getConfig$1();
      txt = sanitizeText$3(textObj.text.trim());
      vertices[id2].labelType = textObj.type;
      if (txt[0] === '"' && txt[txt.length - 1] === '"') {
        txt = txt.substring(1, txt.length - 1);
      }
      vertices[id2].text = txt;
    } else {
      if (vertices[id2].text === void 0) {
        vertices[id2].text = _id;
      }
    }
    if (type2 !== void 0) {
      vertices[id2].type = type2;
    }
    if (style !== void 0 && style !== null) {
      style.forEach(function(s) {
        vertices[id2].styles.push(s);
      });
    }
    if (classes2 !== void 0 && classes2 !== null) {
      classes2.forEach(function(s) {
        vertices[id2].classes.push(s);
      });
    }
    if (dir !== void 0) {
      vertices[id2].dir = dir;
    }
    if (vertices[id2].props === void 0) {
      vertices[id2].props = props;
    } else if (props !== void 0) {
      Object.assign(vertices[id2].props, props);
    }
  };
  const addSingleLink = function(_start, _end, type2) {
    let start2 = _start;
    let end2 = _end;
    const edge = { start: start2, end: end2, type: void 0, text: "", labelType: "text" };
    log$1.info("abc78 Got edge...", edge);
    const linkTextObj = type2.text;
    if (linkTextObj !== void 0) {
      edge.text = sanitizeText$3(linkTextObj.text.trim());
      if (edge.text[0] === '"' && edge.text[edge.text.length - 1] === '"') {
        edge.text = edge.text.substring(1, edge.text.length - 1);
      }
      edge.labelType = linkTextObj.type;
    }
    if (type2 !== void 0) {
      edge.type = type2.type;
      edge.stroke = type2.stroke;
      edge.length = type2.length;
    }
    edges.push(edge);
  };
  const addLink = function(_start, _end, type2) {
    log$1.info("addLink (abc78)", _start, _end, type2);
    let i2, j;
    for (i2 = 0; i2 < _start.length; i2++) {
      for (j = 0; j < _end.length; j++) {
        addSingleLink(_start[i2], _end[j], type2);
      }
    }
  };
  const updateLinkInterpolate = function(positions, interp) {
    positions.forEach(function(pos) {
      if (pos === "default") {
        edges.defaultInterpolate = interp;
      } else {
        edges[pos].interpolate = interp;
      }
    });
  };
  const updateLink = function(positions, style) {
    positions.forEach(function(pos) {
      if (pos === "default") {
        edges.defaultStyle = style;
      } else {
        if (utils.isSubstringInArray("fill", style) === -1) {
          style.push("fill:none");
        }
        edges[pos].style = style;
      }
    });
  };
  const addClass$1 = function(id2, style) {
    if (classes$2[id2] === void 0) {
      classes$2[id2] = { id: id2, styles: [], textStyles: [] };
    }
    if (style !== void 0 && style !== null) {
      style.forEach(function(s) {
        if (s.match("color")) {
          const newStyle1 = s.replace("fill", "bgFill");
          const newStyle2 = newStyle1.replace("color", "fill");
          classes$2[id2].textStyles.push(newStyle2);
        }
        classes$2[id2].styles.push(s);
      });
    }
  };
  const setDirection$3 = function(dir) {
    direction$3 = dir;
    if (direction$3.match(/.*</)) {
      direction$3 = "RL";
    }
    if (direction$3.match(/.*\^/)) {
      direction$3 = "BT";
    }
    if (direction$3.match(/.*>/)) {
      direction$3 = "LR";
    }
    if (direction$3.match(/.*v/)) {
      direction$3 = "TB";
    }
    if (direction$3 === "TD") {
      direction$3 = "TB";
    }
  };
  const setClass$1 = function(ids, className) {
    ids.split(",").forEach(function(_id) {
      let id2 = _id;
      if (vertices[id2] !== void 0) {
        vertices[id2].classes.push(className);
      }
      if (subGraphLookup[id2] !== void 0) {
        subGraphLookup[id2].classes.push(className);
      }
    });
  };
  const setTooltip$1 = function(ids, tooltip) {
    ids.split(",").forEach(function(id2) {
      if (tooltip !== void 0) {
        tooltips[version === "gen-1" ? lookUpDomId$1(id2) : id2] = sanitizeText$3(tooltip);
      }
    });
  };
  const setClickFun$1 = function(id2, functionName, functionArgs) {
    let domId = lookUpDomId$1(id2);
    if (getConfig$1().securityLevel !== "loose") {
      return;
    }
    if (functionName === void 0) {
      return;
    }
    let argList = [];
    if (typeof functionArgs === "string") {
      argList = functionArgs.split(/,(?=(?:(?:[^"]*"){2})*[^"]*$)/);
      for (let i2 = 0; i2 < argList.length; i2++) {
        let item = argList[i2].trim();
        if (item.charAt(0) === '"' && item.charAt(item.length - 1) === '"') {
          item = item.substr(1, item.length - 2);
        }
        argList[i2] = item;
      }
    }
    if (argList.length === 0) {
      argList.push(id2);
    }
    if (vertices[id2] !== void 0) {
      vertices[id2].haveCallback = true;
      funs$1.push(function() {
        const elem = document.querySelector(`[id="${domId}"]`);
        if (elem !== null) {
          elem.addEventListener(
            "click",
            function() {
              utils.runFunc(functionName, ...argList);
            },
            false
          );
        }
      });
    }
  };
  const setLink$2 = function(ids, linkStr, target) {
    ids.split(",").forEach(function(id2) {
      if (vertices[id2] !== void 0) {
        vertices[id2].link = utils.formatUrl(linkStr, config$1);
        vertices[id2].linkTarget = target;
      }
    });
    setClass$1(ids, "clickable");
  };
  const getTooltip$1 = function(id2) {
    return tooltips[id2];
  };
  const setClickEvent$2 = function(ids, functionName, functionArgs) {
    ids.split(",").forEach(function(id2) {
      setClickFun$1(id2, functionName, functionArgs);
    });
    setClass$1(ids, "clickable");
  };
  const bindFunctions$2 = function(element2) {
    funs$1.forEach(function(fun) {
      fun(element2);
    });
  };
  const getDirection$3 = function() {
    return direction$3.trim();
  };
  const getVertices = function() {
    return vertices;
  };
  const getEdges = function() {
    return edges;
  };
  const getClasses$6 = function() {
    return classes$2;
  };
  const setupToolTips$1 = function(element2) {
    let tooltipElem = select(".mermaidTooltip");
    if ((tooltipElem._groups || tooltipElem)[0][0] === null) {
      tooltipElem = select("body").append("div").attr("class", "mermaidTooltip").style("opacity", 0);
    }
    const svg2 = select(element2).select("svg");
    const nodes2 = svg2.selectAll("g.node");
    nodes2.on("mouseover", function() {
      const el = select(this);
      const title2 = el.attr("title");
      if (title2 === null) {
        return;
      }
      const rect2 = this.getBoundingClientRect();
      tooltipElem.transition().duration(200).style("opacity", ".9");
      tooltipElem.text(el.attr("title")).style("left", window.scrollX + rect2.left + (rect2.right - rect2.left) / 2 + "px").style("top", window.scrollY + rect2.top - 14 + document.body.scrollTop + "px");
      tooltipElem.html(tooltipElem.html().replace(/&lt;br\/&gt;/g, "<br/>"));
      el.classed("hover", true);
    }).on("mouseout", function() {
      tooltipElem.transition().duration(500).style("opacity", 0);
      const el = select(this);
      el.classed("hover", false);
    });
  };
  funs$1.push(setupToolTips$1);
  const clear$h = function(ver = "gen-1") {
    vertices = {};
    classes$2 = {};
    edges = [];
    funs$1 = [setupToolTips$1];
    subGraphs = [];
    subGraphLookup = {};
    subCount = 0;
    tooltips = [];
    firstGraphFlag = true;
    version = ver;
    clear$j();
  };
  const setGen = (ver) => {
    version = ver || "gen-2";
  };
  const defaultStyle = function() {
    return "fill:#ffa;stroke: #f66; stroke-width: 3px; stroke-dasharray: 5, 5;fill:#ffa;stroke: #666;";
  };
  const addSubGraph = function(_id, list2, _title) {
    let id2 = _id.text.trim();
    let title2 = _title.text;
    if (_id === _title && _title.text.match(/\s/)) {
      id2 = void 0;
    }
    function uniq(a) {
      const prims = { boolean: {}, number: {}, string: {} };
      const objs = [];
      let dir2;
      const nodeList2 = a.filter(function(item) {
        const type2 = typeof item;
        if (item.stmt && item.stmt === "dir") {
          dir2 = item.value;
          return false;
        }
        if (item.trim() === "") {
          return false;
        }
        if (type2 in prims) {
          return prims[type2].hasOwnProperty(item) ? false : prims[type2][item] = true;
        } else {
          return objs.includes(item) ? false : objs.push(item);
        }
      });
      return { nodeList: nodeList2, dir: dir2 };
    }
    let nodeList = [];
    const { nodeList: nl, dir } = uniq(nodeList.concat.apply(nodeList, list2));
    nodeList = nl;
    if (version === "gen-1") {
      for (let i2 = 0; i2 < nodeList.length; i2++) {
        nodeList[i2] = lookUpDomId$1(nodeList[i2]);
      }
    }
    id2 = id2 || "subGraph" + subCount;
    title2 = title2 || "";
    title2 = sanitizeText$3(title2);
    subCount = subCount + 1;
    const subGraph = {
      id: id2,
      nodes: nodeList,
      title: title2.trim(),
      classes: [],
      dir,
      labelType: _title.type
    };
    log$1.info("Adding", subGraph.id, subGraph.nodes, subGraph.dir);
    subGraph.nodes = makeUniq(subGraph, subGraphs).nodes;
    subGraphs.push(subGraph);
    subGraphLookup[id2] = subGraph;
    return id2;
  };
  const getPosForId = function(id2) {
    for (const [i2, subGraph] of subGraphs.entries()) {
      if (subGraph.id === id2) {
        return i2;
      }
    }
    return -1;
  };
  let secCount = -1;
  const posCrossRef = [];
  const indexNodes2 = function(id2, pos) {
    const nodes2 = subGraphs[pos].nodes;
    secCount = secCount + 1;
    if (secCount > 2e3) {
      return;
    }
    posCrossRef[secCount] = pos;
    if (subGraphs[pos].id === id2) {
      return {
        result: true,
        count: 0
      };
    }
    let count = 0;
    let posCount = 1;
    while (count < nodes2.length) {
      const childPos = getPosForId(nodes2[count]);
      if (childPos >= 0) {
        const res = indexNodes2(id2, childPos);
        if (res.result) {
          return {
            result: true,
            count: posCount + res.count
          };
        } else {
          posCount = posCount + res.count;
        }
      }
      count = count + 1;
    }
    return {
      result: false,
      count: posCount
    };
  };
  const getDepthFirstPos = function(pos) {
    return posCrossRef[pos];
  };
  const indexNodes = function() {
    secCount = -1;
    if (subGraphs.length > 0) {
      indexNodes2("none", subGraphs.length - 1);
    }
  };
  const getSubGraphs = function() {
    return subGraphs;
  };
  const firstGraph = () => {
    if (firstGraphFlag) {
      firstGraphFlag = false;
      return true;
    }
    return false;
  };
  const destructStartLink = (_str) => {
    let str2 = _str.trim();
    let type2 = "arrow_open";
    switch (str2[0]) {
      case "<":
        type2 = "arrow_point";
        str2 = str2.slice(1);
        break;
      case "x":
        type2 = "arrow_cross";
        str2 = str2.slice(1);
        break;
      case "o":
        type2 = "arrow_circle";
        str2 = str2.slice(1);
        break;
    }
    let stroke = "normal";
    if (str2.includes("=")) {
      stroke = "thick";
    }
    if (str2.includes(".")) {
      stroke = "dotted";
    }
    return { type: type2, stroke };
  };
  const countChar = (char2, str2) => {
    const length2 = str2.length;
    let count = 0;
    for (let i2 = 0; i2 < length2; ++i2) {
      if (str2[i2] === char2) {
        ++count;
      }
    }
    return count;
  };
  const destructEndLink = (_str) => {
    const str2 = _str.trim();
    let line2 = str2.slice(0, -1);
    let type2 = "arrow_open";
    switch (str2.slice(-1)) {
      case "x":
        type2 = "arrow_cross";
        if (str2[0] === "x") {
          type2 = "double_" + type2;
          line2 = line2.slice(1);
        }
        break;
      case ">":
        type2 = "arrow_point";
        if (str2[0] === "<") {
          type2 = "double_" + type2;
          line2 = line2.slice(1);
        }
        break;
      case "o":
        type2 = "arrow_circle";
        if (str2[0] === "o") {
          type2 = "double_" + type2;
          line2 = line2.slice(1);
        }
        break;
    }
    let stroke = "normal";
    let length2 = line2.length - 1;
    if (line2[0] === "=") {
      stroke = "thick";
    }
    if (line2[0] === "~") {
      stroke = "invisible";
    }
    let dots = countChar(".", line2);
    if (dots) {
      stroke = "dotted";
      length2 = dots;
    }
    return { type: type2, stroke, length: length2 };
  };
  const destructLink = (_str, _startStr) => {
    const info2 = destructEndLink(_str);
    let startInfo;
    if (_startStr) {
      startInfo = destructStartLink(_startStr);
      if (startInfo.stroke !== info2.stroke) {
        return { type: "INVALID", stroke: "INVALID" };
      }
      if (startInfo.type === "arrow_open") {
        startInfo.type = info2.type;
      } else {
        if (startInfo.type !== info2.type) {
          return { type: "INVALID", stroke: "INVALID" };
        }
        startInfo.type = "double_" + startInfo.type;
      }
      if (startInfo.type === "double_arrow") {
        startInfo.type = "double_arrow_point";
      }
      startInfo.length = info2.length;
      return startInfo;
    }
    return info2;
  };
  const exists = (allSgs, _id) => {
    let res = false;
    allSgs.forEach((sg) => {
      const pos = sg.nodes.indexOf(_id);
      if (pos >= 0) {
        res = true;
      }
    });
    return res;
  };
  const makeUniq = (sg, allSubgraphs) => {
    const res = [];
    sg.nodes.forEach((_id, pos) => {
      if (!exists(allSubgraphs, _id)) {
        res.push(sg.nodes[pos]);
      }
    });
    return { nodes: res };
  };
  const lex = {
    firstGraph
  };
  const flowDb = {
    parseDirective: parseDirective$b,
    defaultConfig: () => defaultConfig.flowchart,
    setAccTitle,
    getAccTitle,
    getAccDescription,
    setAccDescription,
    addVertex,
    lookUpDomId: lookUpDomId$1,
    addLink,
    updateLinkInterpolate,
    updateLink,
    addClass: addClass$1,
    setDirection: setDirection$3,
    setClass: setClass$1,
    setTooltip: setTooltip$1,
    getTooltip: getTooltip$1,
    setClickEvent: setClickEvent$2,
    setLink: setLink$2,
    bindFunctions: bindFunctions$2,
    getDirection: getDirection$3,
    getVertices,
    getEdges,
    getClasses: getClasses$6,
    clear: clear$h,
    setGen,
    defaultStyle,
    addSubGraph,
    getDepthFirstPos,
    indexNodes,
    getSubGraphs,
    destructLink,
    lex,
    exists,
    makeUniq,
    setDiagramTitle,
    getDiagramTitle
  };
  const db$9 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
    __proto__: null,
    addClass: addClass$1,
    addLink,
    addSingleLink,
    addSubGraph,
    addVertex,
    bindFunctions: bindFunctions$2,
    clear: clear$h,
    default: flowDb,
    defaultStyle,
    destructLink,
    firstGraph,
    getClasses: getClasses$6,
    getDepthFirstPos,
    getDirection: getDirection$3,
    getEdges,
    getSubGraphs,
    getTooltip: getTooltip$1,
    getVertices,
    indexNodes,
    lex,
    lookUpDomId: lookUpDomId$1,
    parseDirective: parseDirective$b,
    setClass: setClass$1,
    setClickEvent: setClickEvent$2,
    setDirection: setDirection$3,
    setGen,
    setLink: setLink$2,
    updateLink,
    updateLinkInterpolate
  }, Symbol.toStringTag, { value: "Module" }));
  var symbolTag$3 = "[object Symbol]";
  function isSymbol(value) {
    return typeof value == "symbol" || isObjectLike(value) && baseGetTag(value) == symbolTag$3;
  }
  function arrayMap(array2, iteratee) {
    var index2 = -1, length2 = array2 == null ? 0 : array2.length, result = Array(length2);
    while (++index2 < length2) {
      result[index2] = iteratee(array2[index2], index2, array2);
    }
    return result;
  }
  var INFINITY$3 = 1 / 0;
  var symbolProto$2 = Symbol$2 ? Symbol$2.prototype : void 0, symbolToString = symbolProto$2 ? symbolProto$2.toString : void 0;
  function baseToString(value) {
    if (typeof value == "string") {
      return value;
    }
    if (isArray$1(value)) {
      return arrayMap(value, baseToString) + "";
    }
    if (isSymbol(value)) {
      return symbolToString ? symbolToString.call(value) : "";
    }
    var result = value + "";
    return result == "0" && 1 / value == -INFINITY$3 ? "-0" : result;
  }
  var reWhitespace = /\s/;
  function trimmedEndIndex(string2) {
    var index2 = string2.length;
    while (index2-- && reWhitespace.test(string2.charAt(index2))) {
    }
    return index2;
  }
  var reTrimStart = /^\s+/;
  function baseTrim(string2) {
    return string2 ? string2.slice(0, trimmedEndIndex(string2) + 1).replace(reTrimStart, "") : string2;
  }
  var NAN = 0 / 0;
  var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;
  var reIsBinary = /^0b[01]+$/i;
  var reIsOctal = /^0o[0-7]+$/i;
  var freeParseInt = parseInt;
  function toNumber(value) {
    if (typeof value == "number") {
      return value;
    }
    if (isSymbol(value)) {
      return NAN;
    }
    if (isObject(value)) {
      var other = typeof value.valueOf == "function" ? value.valueOf() : value;
      value = isObject(other) ? other + "" : other;
    }
    if (typeof value != "string") {
      return value === 0 ? value : +value;
    }
    value = baseTrim(value);
    var isBinary2 = reIsBinary.test(value);
    return isBinary2 || reIsOctal.test(value) ? freeParseInt(value.slice(2), isBinary2 ? 2 : 8) : reIsBadHex.test(value) ? NAN : +value;
  }
  var INFINITY$2 = 1 / 0, MAX_INTEGER = 17976931348623157e292;
  function toFinite(value) {
    if (!value) {
      return value === 0 ? value : 0;
    }
    value = toNumber(value);
    if (value === INFINITY$2 || value === -INFINITY$2) {
      var sign2 = value < 0 ? -1 : 1;
      return sign2 * MAX_INTEGER;
    }
    return value === value ? value : 0;
  }
  function toInteger(value) {
    var result = toFinite(value), remainder = result % 1;
    return result === result ? remainder ? result - remainder : result : 0;
  }
  function identity(value) {
    return value;
  }
  var objectCreate = Object.create;
  var baseCreate = function() {
    function object2() {
    }
    return function(proto) {
      if (!isObject(proto)) {
        return {};
      }
      if (objectCreate) {
        return objectCreate(proto);
      }
      object2.prototype = proto;
      var result = new object2();
      object2.prototype = void 0;
      return result;
    };
  }();
  const baseCreate$1 = baseCreate;
  function apply$1(func, thisArg, args) {
    switch (args.length) {
      case 0:
        return func.call(thisArg);
      case 1:
        return func.call(thisArg, args[0]);
      case 2:
        return func.call(thisArg, args[0], args[1]);
      case 3:
        return func.call(thisArg, args[0], args[1], args[2]);
    }
    return func.apply(thisArg, args);
  }
  function noop() {
  }
  function copyArray(source, array2) {
    var index2 = -1, length2 = source.length;
    array2 || (array2 = Array(length2));
    while (++index2 < length2) {
      array2[index2] = source[index2];
    }
    return array2;
  }
  var HOT_COUNT = 800, HOT_SPAN = 16;
  var nativeNow = Date.now;
  function shortOut(func) {
    var count = 0, lastCalled = 0;
    return function() {
      var stamp = nativeNow(), remaining = HOT_SPAN - (stamp - lastCalled);
      lastCalled = stamp;
      if (remaining > 0) {
        if (++count >= HOT_COUNT) {
          return arguments[0];
        }
      } else {
        count = 0;
      }
      return func.apply(void 0, arguments);
    };
  }
  function constant(value) {
    return function() {
      return value;
    };
  }
  var defineProperty = function() {
    try {
      var func = getNative(Object, "defineProperty");
      func({}, "", {});
      return func;
    } catch (e) {
    }
  }();
  const defineProperty$1 = defineProperty;
  var baseSetToString = !defineProperty$1 ? identity : function(func, string2) {
    return defineProperty$1(func, "toString", {
      "configurable": true,
      "enumerable": false,
      "value": constant(string2),
      "writable": true
    });
  };
  const baseSetToString$1 = baseSetToString;
  var setToString = shortOut(baseSetToString$1);
  const setToString$1 = setToString;
  function arrayEach(array2, iteratee) {
    var index2 = -1, length2 = array2 == null ? 0 : array2.length;
    while (++index2 < length2) {
      if (iteratee(array2[index2], index2, array2) === false) {
        break;
      }
    }
    return array2;
  }
  function baseFindIndex(array2, predicate, fromIndex, fromRight) {
    var length2 = array2.length, index2 = fromIndex + (fromRight ? 1 : -1);
    while (fromRight ? index2-- : ++index2 < length2) {
      if (predicate(array2[index2], index2, array2)) {
        return index2;
      }
    }
    return -1;
  }
  function baseIsNaN(value) {
    return value !== value;
  }
  function strictIndexOf(array2, value, fromIndex) {
    var index2 = fromIndex - 1, length2 = array2.length;
    while (++index2 < length2) {
      if (array2[index2] === value) {
        return index2;
      }
    }
    return -1;
  }
  function baseIndexOf(array2, value, fromIndex) {
    return value === value ? strictIndexOf(array2, value, fromIndex) : baseFindIndex(array2, baseIsNaN, fromIndex);
  }
  function arrayIncludes(array2, value) {
    var length2 = array2 == null ? 0 : array2.length;
    return !!length2 && baseIndexOf(array2, value, 0) > -1;
  }
  var MAX_SAFE_INTEGER = 9007199254740991;
  var reIsUint = /^(?:0|[1-9]\d*)$/;
  function isIndex(value, length2) {
    var type2 = typeof value;
    length2 = length2 == null ? MAX_SAFE_INTEGER : length2;
    return !!length2 && (type2 == "number" || type2 != "symbol" && reIsUint.test(value)) && (value > -1 && value % 1 == 0 && value < length2);
  }
  function baseAssignValue(object2, key, value) {
    if (key == "__proto__" && defineProperty$1) {
      defineProperty$1(object2, key, {
        "configurable": true,
        "enumerable": true,
        "value": value,
        "writable": true
      });
    } else {
      object2[key] = value;
    }
  }
  var objectProto$9 = Object.prototype;
  var hasOwnProperty$9 = objectProto$9.hasOwnProperty;
  function assignValue(object2, key, value) {
    var objValue = object2[key];
    if (!(hasOwnProperty$9.call(object2, key) && eq(objValue, value)) || value === void 0 && !(key in object2)) {
      baseAssignValue(object2, key, value);
    }
  }
  function copyObject(source, props, object2, customizer) {
    var isNew = !object2;
    object2 || (object2 = {});
    var index2 = -1, length2 = props.length;
    while (++index2 < length2) {
      var key = props[index2];
      var newValue = customizer ? customizer(object2[key], source[key], key, object2, source) : void 0;
      if (newValue === void 0) {
        newValue = source[key];
      }
      if (isNew) {
        baseAssignValue(object2, key, newValue);
      } else {
        assignValue(object2, key, newValue);
      }
    }
    return object2;
  }
  var nativeMax$2 = Math.max;
  function overRest(func, start2, transform) {
    start2 = nativeMax$2(start2 === void 0 ? func.length - 1 : start2, 0);
    return function() {
      var args = arguments, index2 = -1, length2 = nativeMax$2(args.length - start2, 0), array2 = Array(length2);
      while (++index2 < length2) {
        array2[index2] = args[start2 + index2];
      }
      index2 = -1;
      var otherArgs = Array(start2 + 1);
      while (++index2 < start2) {
        otherArgs[index2] = args[index2];
      }
      otherArgs[start2] = transform(array2);
      return apply$1(func, this, otherArgs);
    };
  }
  function baseRest(func, start2) {
    return setToString$1(overRest(func, start2, identity), func + "");
  }
  function isIterateeCall(value, index2, object2) {
    if (!isObject(object2)) {
      return false;
    }
    var type2 = typeof index2;
    if (type2 == "number" ? isArrayLike(object2) && isIndex(index2, object2.length) : type2 == "string" && index2 in object2) {
      return eq(object2[index2], value);
    }
    return false;
  }
  function createAssigner(assigner) {
    return baseRest(function(object2, sources) {
      var index2 = -1, length2 = sources.length, customizer = length2 > 1 ? sources[length2 - 1] : void 0, guard = length2 > 2 ? sources[2] : void 0;
      customizer = assigner.length > 3 && typeof customizer == "function" ? (length2--, customizer) : void 0;
      if (guard && isIterateeCall(sources[0], sources[1], guard)) {
        customizer = length2 < 3 ? void 0 : customizer;
        length2 = 1;
      }
      object2 = Object(object2);
      while (++index2 < length2) {
        var source = sources[index2];
        if (source) {
          assigner(object2, source, index2, customizer);
        }
      }
      return object2;
    });
  }
  function baseTimes(n, iteratee) {
    var index2 = -1, result = Array(n);
    while (++index2 < n) {
      result[index2] = iteratee(index2);
    }
    return result;
  }
  var objectProto$8 = Object.prototype;
  var hasOwnProperty$8 = objectProto$8.hasOwnProperty;
  function arrayLikeKeys(value, inherited) {
    var isArr = isArray$1(value), isArg = !isArr && isArguments$1(value), isBuff = !isArr && !isArg && isBuffer$1(value), isType = !isArr && !isArg && !isBuff && isTypedArray$1(value), skipIndexes = isArr || isArg || isBuff || isType, result = skipIndexes ? baseTimes(value.length, String) : [], length2 = result.length;
    for (var key in value) {
      if ((inherited || hasOwnProperty$8.call(value, key)) && !(skipIndexes && // Safari 9 has enumerable `arguments.length` in strict mode.
      (key == "length" || // Node.js 0.10 has enumerable non-index properties on buffers.
      isBuff && (key == "offset" || key == "parent") || // PhantomJS 2 has enumerable non-index properties on typed arrays.
      isType && (key == "buffer" || key == "byteLength" || key == "byteOffset") || // Skip index properties.
      isIndex(key, length2)))) {
        result.push(key);
      }
    }
    return result;
  }
  function keys$1(object2) {
    return isArrayLike(object2) ? arrayLikeKeys(object2) : baseKeys(object2);
  }
  function nativeKeysIn(object2) {
    var result = [];
    if (object2 != null) {
      for (var key in Object(object2)) {
        result.push(key);
      }
    }
    return result;
  }
  var objectProto$7 = Object.prototype;
  var hasOwnProperty$7 = objectProto$7.hasOwnProperty;
  function baseKeysIn(object2) {
    if (!isObject(object2)) {
      return nativeKeysIn(object2);
    }
    var isProto = isPrototype(object2), result = [];
    for (var key in object2) {
      if (!(key == "constructor" && (isProto || !hasOwnProperty$7.call(object2, key)))) {
        result.push(key);
      }
    }
    return result;
  }
  function keysIn(object2) {
    return isArrayLike(object2) ? arrayLikeKeys(object2, true) : baseKeysIn(object2);
  }
  var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/, reIsPlainProp = /^\w*$/;
  function isKey(value, object2) {
    if (isArray$1(value)) {
      return false;
    }
    var type2 = typeof value;
    if (type2 == "number" || type2 == "symbol" || type2 == "boolean" || value == null || isSymbol(value)) {
      return true;
    }
    return reIsPlainProp.test(value) || !reIsDeepProp.test(value) || object2 != null && value in Object(object2);
  }
  var MAX_MEMOIZE_SIZE = 500;
  function memoizeCapped(func) {
    var result = memoize(func, function(key) {
      if (cache.size === MAX_MEMOIZE_SIZE) {
        cache.clear();
      }
      return key;
    });
    var cache = result.cache;
    return result;
  }
  var rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;
  var reEscapeChar = /\\(\\)?/g;
  var stringToPath = memoizeCapped(function(string2) {
    var result = [];
    if (string2.charCodeAt(0) === 46) {
      result.push("");
    }
    string2.replace(rePropName, function(match, number2, quote, subString) {
      result.push(quote ? subString.replace(reEscapeChar, "$1") : number2 || match);
    });
    return result;
  });
  const stringToPath$1 = stringToPath;
  function toString$1(value) {
    return value == null ? "" : baseToString(value);
  }
  function castPath(value, object2) {
    if (isArray$1(value)) {
      return value;
    }
    return isKey(value, object2) ? [value] : stringToPath$1(toString$1(value));
  }
  var INFINITY$1 = 1 / 0;
  function toKey(value) {
    if (typeof value == "string" || isSymbol(value)) {
      return value;
    }
    var result = value + "";
    return result == "0" && 1 / value == -INFINITY$1 ? "-0" : result;
  }
  function baseGet(object2, path2) {
    path2 = castPath(path2, object2);
    var index2 = 0, length2 = path2.length;
    while (object2 != null && index2 < length2) {
      object2 = object2[toKey(path2[index2++])];
    }
    return index2 && index2 == length2 ? object2 : void 0;
  }
  function get$1(object2, path2, defaultValue) {
    var result = object2 == null ? void 0 : baseGet(object2, path2);
    return result === void 0 ? defaultValue : result;
  }
  function arrayPush(array2, values2) {
    var index2 = -1, length2 = values2.length, offset = array2.length;
    while (++index2 < length2) {
      array2[offset + index2] = values2[index2];
    }
    return array2;
  }
  var spreadableSymbol = Symbol$2 ? Symbol$2.isConcatSpreadable : void 0;
  function isFlattenable(value) {
    return isArray$1(value) || isArguments$1(value) || !!(spreadableSymbol && value && value[spreadableSymbol]);
  }
  function baseFlatten(array2, depth, predicate, isStrict, result) {
    var index2 = -1, length2 = array2.length;
    predicate || (predicate = isFlattenable);
    result || (result = []);
    while (++index2 < length2) {
      var value = array2[index2];
      if (depth > 0 && predicate(value)) {
        if (depth > 1) {
          baseFlatten(value, depth - 1, predicate, isStrict, result);
        } else {
          arrayPush(result, value);
        }
      } else if (!isStrict) {
        result[result.length] = value;
      }
    }
    return result;
  }
  function flatten(array2) {
    var length2 = array2 == null ? 0 : array2.length;
    return length2 ? baseFlatten(array2, 1) : [];
  }
  function flatRest(func) {
    return setToString$1(overRest(func, void 0, flatten), func + "");
  }
  var getPrototype = overArg(Object.getPrototypeOf, Object);
  const getPrototype$1 = getPrototype;
  var objectTag$2 = "[object Object]";
  var funcProto = Function.prototype, objectProto$6 = Object.prototype;
  var funcToString = funcProto.toString;
  var hasOwnProperty$6 = objectProto$6.hasOwnProperty;
  var objectCtorString = funcToString.call(Object);
  function isPlainObject(value) {
    if (!isObjectLike(value) || baseGetTag(value) != objectTag$2) {
      return false;
    }
    var proto = getPrototype$1(value);
    if (proto === null) {
      return true;
    }
    var Ctor = hasOwnProperty$6.call(proto, "constructor") && proto.constructor;
    return typeof Ctor == "function" && Ctor instanceof Ctor && funcToString.call(Ctor) == objectCtorString;
  }
  function arrayReduce(array2, iteratee, accumulator, initAccum) {
    var index2 = -1, length2 = array2 == null ? 0 : array2.length;
    if (initAccum && length2) {
      accumulator = array2[++index2];
    }
    while (++index2 < length2) {
      accumulator = iteratee(accumulator, array2[index2], index2, array2);
    }
    return accumulator;
  }
  function stackClear() {
    this.__data__ = new ListCache();
    this.size = 0;
  }
  function stackDelete(key) {
    var data = this.__data__, result = data["delete"](key);
    this.size = data.size;
    return result;
  }
  function stackGet(key) {
    return this.__data__.get(key);
  }
  function stackHas(key) {
    return this.__data__.has(key);
  }
  var LARGE_ARRAY_SIZE$1 = 200;
  function stackSet(key, value) {
    var data = this.__data__;
    if (data instanceof ListCache) {
      var pairs2 = data.__data__;
      if (!Map$2 || pairs2.length < LARGE_ARRAY_SIZE$1 - 1) {
        pairs2.push([key, value]);
        this.size = ++data.size;
        return this;
      }
      data = this.__data__ = new MapCache(pairs2);
    }
    data.set(key, value);
    this.size = data.size;
    return this;
  }
  function Stack(entries2) {
    var data = this.__data__ = new ListCache(entries2);
    this.size = data.size;
  }
  Stack.prototype.clear = stackClear;
  Stack.prototype["delete"] = stackDelete;
  Stack.prototype.get = stackGet;
  Stack.prototype.has = stackHas;
  Stack.prototype.set = stackSet;
  function baseAssign(object2, source) {
    return object2 && copyObject(source, keys$1(source), object2);
  }
  function baseAssignIn(object2, source) {
    return object2 && copyObject(source, keysIn(source), object2);
  }
  var freeExports = typeof exports == "object" && exports && !exports.nodeType && exports;
  var freeModule = freeExports && typeof module == "object" && module && !module.nodeType && module;
  var moduleExports = freeModule && freeModule.exports === freeExports;
  var Buffer = moduleExports ? root$1.Buffer : void 0, allocUnsafe = Buffer ? Buffer.allocUnsafe : void 0;
  function cloneBuffer(buffer, isDeep) {
    if (isDeep) {
      return buffer.slice();
    }
    var length2 = buffer.length, result = allocUnsafe ? allocUnsafe(length2) : new buffer.constructor(length2);
    buffer.copy(result);
    return result;
  }
  function arrayFilter(array2, predicate) {
    var index2 = -1, length2 = array2 == null ? 0 : array2.length, resIndex = 0, result = [];
    while (++index2 < length2) {
      var value = array2[index2];
      if (predicate(value, index2, array2)) {
        result[resIndex++] = value;
      }
    }
    return result;
  }
  function stubArray() {
    return [];
  }
  var objectProto$5 = Object.prototype;
  var propertyIsEnumerable = objectProto$5.propertyIsEnumerable;
  var nativeGetSymbols$1 = Object.getOwnPropertySymbols;
  var getSymbols = !nativeGetSymbols$1 ? stubArray : function(object2) {
    if (object2 == null) {
      return [];
    }
    object2 = Object(object2);
    return arrayFilter(nativeGetSymbols$1(object2), function(symbol) {
      return propertyIsEnumerable.call(object2, symbol);
    });
  };
  const getSymbols$1 = getSymbols;
  function copySymbols(source, object2) {
    return copyObject(source, getSymbols$1(source), object2);
  }
  var nativeGetSymbols = Object.getOwnPropertySymbols;
  var getSymbolsIn = !nativeGetSymbols ? stubArray : function(object2) {
    var result = [];
    while (object2) {
      arrayPush(result, getSymbols$1(object2));
      object2 = getPrototype$1(object2);
    }
    return result;
  };
  const getSymbolsIn$1 = getSymbolsIn;
  function copySymbolsIn(source, object2) {
    return copyObject(source, getSymbolsIn$1(source), object2);
  }
  function baseGetAllKeys(object2, keysFunc, symbolsFunc) {
    var result = keysFunc(object2);
    return isArray$1(object2) ? result : arrayPush(result, symbolsFunc(object2));
  }
  function getAllKeys(object2) {
    return baseGetAllKeys(object2, keys$1, getSymbols$1);
  }
  function getAllKeysIn(object2) {
    return baseGetAllKeys(object2, keysIn, getSymbolsIn$1);
  }
  var objectProto$4 = Object.prototype;
  var hasOwnProperty$5 = objectProto$4.hasOwnProperty;
  function initCloneArray(array2) {
    var length2 = array2.length, result = new array2.constructor(length2);
    if (length2 && typeof array2[0] == "string" && hasOwnProperty$5.call(array2, "index")) {
      result.index = array2.index;
      result.input = array2.input;
    }
    return result;
  }
  var Uint8Array$1 = root$1.Uint8Array;
  const Uint8Array$2 = Uint8Array$1;
  function cloneArrayBuffer(arrayBuffer) {
    var result = new arrayBuffer.constructor(arrayBuffer.byteLength);
    new Uint8Array$2(result).set(new Uint8Array$2(arrayBuffer));
    return result;
  }
  function cloneDataView(dataView, isDeep) {
    var buffer = isDeep ? cloneArrayBuffer(dataView.buffer) : dataView.buffer;
    return new dataView.constructor(buffer, dataView.byteOffset, dataView.byteLength);
  }
  var reFlags = /\w*$/;
  function cloneRegExp(regexp) {
    var result = new regexp.constructor(regexp.source, reFlags.exec(regexp));
    result.lastIndex = regexp.lastIndex;
    return result;
  }
  var symbolProto$1 = Symbol$2 ? Symbol$2.prototype : void 0, symbolValueOf$1 = symbolProto$1 ? symbolProto$1.valueOf : void 0;
  function cloneSymbol(symbol) {
    return symbolValueOf$1 ? Object(symbolValueOf$1.call(symbol)) : {};
  }
  function cloneTypedArray(typedArray, isDeep) {
    var buffer = isDeep ? cloneArrayBuffer(typedArray.buffer) : typedArray.buffer;
    return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
  }
  var boolTag$2 = "[object Boolean]", dateTag$2 = "[object Date]", mapTag$3 = "[object Map]", numberTag$2 = "[object Number]", regexpTag$2 = "[object RegExp]", setTag$3 = "[object Set]", stringTag$2 = "[object String]", symbolTag$2 = "[object Symbol]";
  var arrayBufferTag$2 = "[object ArrayBuffer]", dataViewTag$2 = "[object DataView]", float32Tag$1 = "[object Float32Array]", float64Tag$1 = "[object Float64Array]", int8Tag$1 = "[object Int8Array]", int16Tag$1 = "[object Int16Array]", int32Tag$1 = "[object Int32Array]", uint8Tag$1 = "[object Uint8Array]", uint8ClampedTag$1 = "[object Uint8ClampedArray]", uint16Tag$1 = "[object Uint16Array]", uint32Tag$1 = "[object Uint32Array]";
  function initCloneByTag(object2, tag, isDeep) {
    var Ctor = object2.constructor;
    switch (tag) {
      case arrayBufferTag$2:
        return cloneArrayBuffer(object2);
      case boolTag$2:
      case dateTag$2:
        return new Ctor(+object2);
      case dataViewTag$2:
        return cloneDataView(object2, isDeep);
      case float32Tag$1:
      case float64Tag$1:
      case int8Tag$1:
      case int16Tag$1:
      case int32Tag$1:
      case uint8Tag$1:
      case uint8ClampedTag$1:
      case uint16Tag$1:
      case uint32Tag$1:
        return cloneTypedArray(object2, isDeep);
      case mapTag$3:
        return new Ctor();
      case numberTag$2:
      case stringTag$2:
        return new Ctor(object2);
      case regexpTag$2:
        return cloneRegExp(object2);
      case setTag$3:
        return new Ctor();
      case symbolTag$2:
        return cloneSymbol(object2);
    }
  }
  function initCloneObject(object2) {
    return typeof object2.constructor == "function" && !isPrototype(object2) ? baseCreate$1(getPrototype$1(object2)) : {};
  }
  var mapTag$2 = "[object Map]";
  function baseIsMap(value) {
    return isObjectLike(value) && getTag$1(value) == mapTag$2;
  }
  var nodeIsMap = nodeUtil$1 && nodeUtil$1.isMap;
  var isMap = nodeIsMap ? baseUnary(nodeIsMap) : baseIsMap;
  const isMap$1 = isMap;
  var setTag$2 = "[object Set]";
  function baseIsSet(value) {
    return isObjectLike(value) && getTag$1(value) == setTag$2;
  }
  var nodeIsSet = nodeUtil$1 && nodeUtil$1.isSet;
  var isSet = nodeIsSet ? baseUnary(nodeIsSet) : baseIsSet;
  const isSet$1 = isSet;
  var CLONE_DEEP_FLAG$1 = 1, CLONE_FLAT_FLAG = 2, CLONE_SYMBOLS_FLAG$2 = 4;
  var argsTag$1 = "[object Arguments]", arrayTag$1 = "[object Array]", boolTag$1 = "[object Boolean]", dateTag$1 = "[object Date]", errorTag$1 = "[object Error]", funcTag = "[object Function]", genTag = "[object GeneratorFunction]", mapTag$1 = "[object Map]", numberTag$1 = "[object Number]", objectTag$1 = "[object Object]", regexpTag$1 = "[object RegExp]", setTag$1 = "[object Set]", stringTag$1 = "[object String]", symbolTag$1 = "[object Symbol]", weakMapTag = "[object WeakMap]";
  var arrayBufferTag$1 = "[object ArrayBuffer]", dataViewTag$1 = "[object DataView]", float32Tag = "[object Float32Array]", float64Tag = "[object Float64Array]", int8Tag = "[object Int8Array]", int16Tag = "[object Int16Array]", int32Tag = "[object Int32Array]", uint8Tag = "[object Uint8Array]", uint8ClampedTag = "[object Uint8ClampedArray]", uint16Tag = "[object Uint16Array]", uint32Tag = "[object Uint32Array]";
  var cloneableTags = {};
  cloneableTags[argsTag$1] = cloneableTags[arrayTag$1] = cloneableTags[arrayBufferTag$1] = cloneableTags[dataViewTag$1] = cloneableTags[boolTag$1] = cloneableTags[dateTag$1] = cloneableTags[float32Tag] = cloneableTags[float64Tag] = cloneableTags[int8Tag] = cloneableTags[int16Tag] = cloneableTags[int32Tag] = cloneableTags[mapTag$1] = cloneableTags[numberTag$1] = cloneableTags[objectTag$1] = cloneableTags[regexpTag$1] = cloneableTags[setTag$1] = cloneableTags[stringTag$1] = cloneableTags[symbolTag$1] = cloneableTags[uint8Tag] = cloneableTags[uint8ClampedTag] = cloneableTags[uint16Tag] = cloneableTags[uint32Tag] = true;
  cloneableTags[errorTag$1] = cloneableTags[funcTag] = cloneableTags[weakMapTag] = false;
  function baseClone(value, bitmask, customizer, key, object2, stack) {
    var result, isDeep = bitmask & CLONE_DEEP_FLAG$1, isFlat = bitmask & CLONE_FLAT_FLAG, isFull = bitmask & CLONE_SYMBOLS_FLAG$2;
    if (customizer) {
      result = object2 ? customizer(value, key, object2, stack) : customizer(value);
    }
    if (result !== void 0) {
      return result;
    }
    if (!isObject(value)) {
      return value;
    }
    var isArr = isArray$1(value);
    if (isArr) {
      result = initCloneArray(value);
      if (!isDeep) {
        return copyArray(value, result);
      }
    } else {
      var tag = getTag$1(value), isFunc = tag == funcTag || tag == genTag;
      if (isBuffer$1(value)) {
        return cloneBuffer(value, isDeep);
      }
      if (tag == objectTag$1 || tag == argsTag$1 || isFunc && !object2) {
        result = isFlat || isFunc ? {} : initCloneObject(value);
        if (!isDeep) {
          return isFlat ? copySymbolsIn(value, baseAssignIn(result, value)) : copySymbols(value, baseAssign(result, value));
        }
      } else {
        if (!cloneableTags[tag]) {
          return object2 ? value : {};
        }
        result = initCloneByTag(value, tag, isDeep);
      }
    }
    stack || (stack = new Stack());
    var stacked = stack.get(value);
    if (stacked) {
      return stacked;
    }
    stack.set(value, result);
    if (isSet$1(value)) {
      value.forEach(function(subValue) {
        result.add(baseClone(subValue, bitmask, customizer, subValue, value, stack));
      });
    } else if (isMap$1(value)) {
      value.forEach(function(subValue, key2) {
        result.set(key2, baseClone(subValue, bitmask, customizer, key2, value, stack));
      });
    }
    var keysFunc = isFull ? isFlat ? getAllKeysIn : getAllKeys : isFlat ? keysIn : keys$1;
    var props = isArr ? void 0 : keysFunc(value);
    arrayEach(props || value, function(subValue, key2) {
      if (props) {
        key2 = subValue;
        subValue = value[key2];
      }
      assignValue(result, key2, baseClone(subValue, bitmask, customizer, key2, value, stack));
    });
    return result;
  }
  var CLONE_SYMBOLS_FLAG$1 = 4;
  function clone$1(value) {
    return baseClone(value, CLONE_SYMBOLS_FLAG$1);
  }
  var CLONE_DEEP_FLAG = 1, CLONE_SYMBOLS_FLAG = 4;
  function cloneDeep(value) {
    return baseClone(value, CLONE_DEEP_FLAG | CLONE_SYMBOLS_FLAG);
  }
  var HASH_UNDEFINED = "__lodash_hash_undefined__";
  function setCacheAdd(value) {
    this.__data__.set(value, HASH_UNDEFINED);
    return this;
  }
  function setCacheHas(value) {
    return this.__data__.has(value);
  }
  function SetCache(values2) {
    var index2 = -1, length2 = values2 == null ? 0 : values2.length;
    this.__data__ = new MapCache();
    while (++index2 < length2) {
      this.add(values2[index2]);
    }
  }
  SetCache.prototype.add = SetCache.prototype.push = setCacheAdd;
  SetCache.prototype.has = setCacheHas;
  function arraySome(array2, predicate) {
    var index2 = -1, length2 = array2 == null ? 0 : array2.length;
    while (++index2 < length2) {
      if (predicate(array2[index2], index2, array2)) {
        return true;
      }
    }
    return false;
  }
  function cacheHas(cache, key) {
    return cache.has(key);
  }
  var COMPARE_PARTIAL_FLAG$5 = 1, COMPARE_UNORDERED_FLAG$3 = 2;
  function equalArrays(array2, other, bitmask, customizer, equalFunc, stack) {
    var isPartial = bitmask & COMPARE_PARTIAL_FLAG$5, arrLength = array2.length, othLength = other.length;
    if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
      return false;
    }
    var arrStacked = stack.get(array2);
    var othStacked = stack.get(other);
    if (arrStacked && othStacked) {
      return arrStacked == other && othStacked == array2;
    }
    var index2 = -1, result = true, seen = bitmask & COMPARE_UNORDERED_FLAG$3 ? new SetCache() : void 0;
    stack.set(array2, other);
    stack.set(other, array2);
    while (++index2 < arrLength) {
      var arrValue = array2[index2], othValue = other[index2];
      if (customizer) {
        var compared = isPartial ? customizer(othValue, arrValue, index2, other, array2, stack) : customizer(arrValue, othValue, index2, array2, other, stack);
      }
      if (compared !== void 0) {
        if (compared) {
          continue;
        }
        result = false;
        break;
      }
      if (seen) {
        if (!arraySome(other, function(othValue2, othIndex) {
          if (!cacheHas(seen, othIndex) && (arrValue === othValue2 || equalFunc(arrValue, othValue2, bitmask, customizer, stack))) {
            return seen.push(othIndex);
          }
        })) {
          result = false;
          break;
        }
      } else if (!(arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
        result = false;
        break;
      }
    }
    stack["delete"](array2);
    stack["delete"](other);
    return result;
  }
  function mapToArray(map2) {
    var index2 = -1, result = Array(map2.size);
    map2.forEach(function(value, key) {
      result[++index2] = [key, value];
    });
    return result;
  }
  function setToArray(set2) {
    var index2 = -1, result = Array(set2.size);
    set2.forEach(function(value) {
      result[++index2] = value;
    });
    return result;
  }
  var COMPARE_PARTIAL_FLAG$4 = 1, COMPARE_UNORDERED_FLAG$2 = 2;
  var boolTag = "[object Boolean]", dateTag = "[object Date]", errorTag = "[object Error]", mapTag = "[object Map]", numberTag = "[object Number]", regexpTag = "[object RegExp]", setTag = "[object Set]", stringTag = "[object String]", symbolTag = "[object Symbol]";
  var arrayBufferTag = "[object ArrayBuffer]", dataViewTag = "[object DataView]";
  var symbolProto = Symbol$2 ? Symbol$2.prototype : void 0, symbolValueOf = symbolProto ? symbolProto.valueOf : void 0;
  function equalByTag(object2, other, tag, bitmask, customizer, equalFunc, stack) {
    switch (tag) {
      case dataViewTag:
        if (object2.byteLength != other.byteLength || object2.byteOffset != other.byteOffset) {
          return false;
        }
        object2 = object2.buffer;
        other = other.buffer;
      case arrayBufferTag:
        if (object2.byteLength != other.byteLength || !equalFunc(new Uint8Array$2(object2), new Uint8Array$2(other))) {
          return false;
        }
        return true;
      case boolTag:
      case dateTag:
      case numberTag:
        return eq(+object2, +other);
      case errorTag:
        return object2.name == other.name && object2.message == other.message;
      case regexpTag:
      case stringTag:
        return object2 == other + "";
      case mapTag:
        var convert = mapToArray;
      case setTag:
        var isPartial = bitmask & COMPARE_PARTIAL_FLAG$4;
        convert || (convert = setToArray);
        if (object2.size != other.size && !isPartial) {
          return false;
        }
        var stacked = stack.get(object2);
        if (stacked) {
          return stacked == other;
        }
        bitmask |= COMPARE_UNORDERED_FLAG$2;
        stack.set(object2, other);
        var result = equalArrays(convert(object2), convert(other), bitmask, customizer, equalFunc, stack);
        stack["delete"](object2);
        return result;
      case symbolTag:
        if (symbolValueOf) {
          return symbolValueOf.call(object2) == symbolValueOf.call(other);
        }
    }
    return false;
  }
  var COMPARE_PARTIAL_FLAG$3 = 1;
  var objectProto$3 = Object.prototype;
  var hasOwnProperty$4 = objectProto$3.hasOwnProperty;
  function equalObjects(object2, other, bitmask, customizer, equalFunc, stack) {
    var isPartial = bitmask & COMPARE_PARTIAL_FLAG$3, objProps = getAllKeys(object2), objLength = objProps.length, othProps = getAllKeys(other), othLength = othProps.length;
    if (objLength != othLength && !isPartial) {
      return false;
    }
    var index2 = objLength;
    while (index2--) {
      var key = objProps[index2];
      if (!(isPartial ? key in other : hasOwnProperty$4.call(other, key))) {
        return false;
      }
    }
    var objStacked = stack.get(object2);
    var othStacked = stack.get(other);
    if (objStacked && othStacked) {
      return objStacked == other && othStacked == object2;
    }
    var result = true;
    stack.set(object2, other);
    stack.set(other, object2);
    var skipCtor = isPartial;
    while (++index2 < objLength) {
      key = objProps[index2];
      var objValue = object2[key], othValue = other[key];
      if (customizer) {
        var compared = isPartial ? customizer(othValue, objValue, key, other, object2, stack) : customizer(objValue, othValue, key, object2, other, stack);
      }
      if (!(compared === void 0 ? objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack) : compared)) {
        result = false;
        break;
      }
      skipCtor || (skipCtor = key == "constructor");
    }
    if (result && !skipCtor) {
      var objCtor = object2.constructor, othCtor = other.constructor;
      if (objCtor != othCtor && ("constructor" in object2 && "constructor" in other) && !(typeof objCtor == "function" && objCtor instanceof objCtor && typeof othCtor == "function" && othCtor instanceof othCtor)) {
        result = false;
      }
    }
    stack["delete"](object2);
    stack["delete"](other);
    return result;
  }
  var COMPARE_PARTIAL_FLAG$2 = 1;
  var argsTag = "[object Arguments]", arrayTag = "[object Array]", objectTag = "[object Object]";
  var objectProto$2 = Object.prototype;
  var hasOwnProperty$3 = objectProto$2.hasOwnProperty;
  function baseIsEqualDeep(object2, other, bitmask, customizer, equalFunc, stack) {
    var objIsArr = isArray$1(object2), othIsArr = isArray$1(other), objTag = objIsArr ? arrayTag : getTag$1(object2), othTag = othIsArr ? arrayTag : getTag$1(other);
    objTag = objTag == argsTag ? objectTag : objTag;
    othTag = othTag == argsTag ? objectTag : othTag;
    var objIsObj = objTag == objectTag, othIsObj = othTag == objectTag, isSameTag = objTag == othTag;
    if (isSameTag && isBuffer$1(object2)) {
      if (!isBuffer$1(other)) {
        return false;
      }
      objIsArr = true;
      objIsObj = false;
    }
    if (isSameTag && !objIsObj) {
      stack || (stack = new Stack());
      return objIsArr || isTypedArray$1(object2) ? equalArrays(object2, other, bitmask, customizer, equalFunc, stack) : equalByTag(object2, other, objTag, bitmask, customizer, equalFunc, stack);
    }
    if (!(bitmask & COMPARE_PARTIAL_FLAG$2)) {
      var objIsWrapped = objIsObj && hasOwnProperty$3.call(object2, "__wrapped__"), othIsWrapped = othIsObj && hasOwnProperty$3.call(other, "__wrapped__");
      if (objIsWrapped || othIsWrapped) {
        var objUnwrapped = objIsWrapped ? object2.value() : object2, othUnwrapped = othIsWrapped ? other.value() : other;
        stack || (stack = new Stack());
        return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
      }
    }
    if (!isSameTag) {
      return false;
    }
    stack || (stack = new Stack());
    return equalObjects(object2, other, bitmask, customizer, equalFunc, stack);
  }
  function baseIsEqual(value, other, bitmask, customizer, stack) {
    if (value === other) {
      return true;
    }
    if (value == null || other == null || !isObjectLike(value) && !isObjectLike(other)) {
      return value !== value && other !== other;
    }
    return baseIsEqualDeep(value, other, bitmask, customizer, baseIsEqual, stack);
  }
  var COMPARE_PARTIAL_FLAG$1 = 1, COMPARE_UNORDERED_FLAG$1 = 2;
  function baseIsMatch(object2, source, matchData, customizer) {
    var index2 = matchData.length, length2 = index2, noCustomizer = !customizer;
    if (object2 == null) {
      return !length2;
    }
    object2 = Object(object2);
    while (index2--) {
      var data = matchData[index2];
      if (noCustomizer && data[2] ? data[1] !== object2[data[0]] : !(data[0] in object2)) {
        return false;
      }
    }
    while (++index2 < length2) {
      data = matchData[index2];
      var key = data[0], objValue = object2[key], srcValue = data[1];
      if (noCustomizer && data[2]) {
        if (objValue === void 0 && !(key in object2)) {
          return false;
        }
      } else {
        var stack = new Stack();
        if (customizer) {
          var result = customizer(objValue, srcValue, key, object2, source, stack);
        }
        if (!(result === void 0 ? baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG$1 | COMPARE_UNORDERED_FLAG$1, customizer, stack) : result)) {
          return false;
        }
      }
    }
    return true;
  }
  function isStrictComparable(value) {
    return value === value && !isObject(value);
  }
  function getMatchData(object2) {
    var result = keys$1(object2), length2 = result.length;
    while (length2--) {
      var key = result[length2], value = object2[key];
      result[length2] = [key, value, isStrictComparable(value)];
    }
    return result;
  }
  function matchesStrictComparable(key, srcValue) {
    return function(object2) {
      if (object2 == null) {
        return false;
      }
      return object2[key] === srcValue && (srcValue !== void 0 || key in Object(object2));
    };
  }
  function baseMatches(source) {
    var matchData = getMatchData(source);
    if (matchData.length == 1 && matchData[0][2]) {
      return matchesStrictComparable(matchData[0][0], matchData[0][1]);
    }
    return function(object2) {
      return object2 === source || baseIsMatch(object2, source, matchData);
    };
  }
  function baseHasIn(object2, key) {
    return object2 != null && key in Object(object2);
  }
  function hasPath(object2, path2, hasFunc) {
    path2 = castPath(path2, object2);
    var index2 = -1, length2 = path2.length, result = false;
    while (++index2 < length2) {
      var key = toKey(path2[index2]);
      if (!(result = object2 != null && hasFunc(object2, key))) {
        break;
      }
      object2 = object2[key];
    }
    if (result || ++index2 != length2) {
      return result;
    }
    length2 = object2 == null ? 0 : object2.length;
    return !!length2 && isLength(length2) && isIndex(key, length2) && (isArray$1(object2) || isArguments$1(object2));
  }
  function hasIn(object2, path2) {
    return object2 != null && hasPath(object2, path2, baseHasIn);
  }
  var COMPARE_PARTIAL_FLAG = 1, COMPARE_UNORDERED_FLAG = 2;
  function baseMatchesProperty(path2, srcValue) {
    if (isKey(path2) && isStrictComparable(srcValue)) {
      return matchesStrictComparable(toKey(path2), srcValue);
    }
    return function(object2) {
      var objValue = get$1(object2, path2);
      return objValue === void 0 && objValue === srcValue ? hasIn(object2, path2) : baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG | COMPARE_UNORDERED_FLAG);
    };
  }
  function baseProperty(key) {
    return function(object2) {
      return object2 == null ? void 0 : object2[key];
    };
  }
  function basePropertyDeep(path2) {
    return function(object2) {
      return baseGet(object2, path2);
    };
  }
  function property(path2) {
    return isKey(path2) ? baseProperty(toKey(path2)) : basePropertyDeep(path2);
  }
  function baseIteratee(value) {
    if (typeof value == "function") {
      return value;
    }
    if (value == null) {
      return identity;
    }
    if (typeof value == "object") {
      return isArray$1(value) ? baseMatchesProperty(value[0], value[1]) : baseMatches(value);
    }
    return property(value);
  }
  function createBaseFor(fromRight) {
    return function(object2, iteratee, keysFunc) {
      var index2 = -1, iterable = Object(object2), props = keysFunc(object2), length2 = props.length;
      while (length2--) {
        var key = props[fromRight ? length2 : ++index2];
        if (iteratee(iterable[key], key, iterable) === false) {
          break;
        }
      }
      return object2;
    };
  }
  var baseFor = createBaseFor();
  const baseFor$1 = baseFor;
  function baseForOwn(object2, iteratee) {
    return object2 && baseFor$1(object2, iteratee, keys$1);
  }
  function createBaseEach(eachFunc, fromRight) {
    return function(collection, iteratee) {
      if (collection == null) {
        return collection;
      }
      if (!isArrayLike(collection)) {
        return eachFunc(collection, iteratee);
      }
      var length2 = collection.length, index2 = fromRight ? length2 : -1, iterable = Object(collection);
      while (fromRight ? index2-- : ++index2 < length2) {
        if (iteratee(iterable[index2], index2, iterable) === false) {
          break;
        }
      }
      return collection;
    };
  }
  var baseEach = createBaseEach(baseForOwn);
  const baseEach$1 = baseEach;
  var now = function() {
    return root$1.Date.now();
  };
  const now$1 = now;
  var objectProto$1 = Object.prototype;
  var hasOwnProperty$2 = objectProto$1.hasOwnProperty;
  var defaults = baseRest(function(object2, sources) {
    object2 = Object(object2);
    var index2 = -1;
    var length2 = sources.length;
    var guard = length2 > 2 ? sources[2] : void 0;
    if (guard && isIterateeCall(sources[0], sources[1], guard)) {
      length2 = 1;
    }
    while (++index2 < length2) {
      var source = sources[index2];
      var props = keysIn(source);
      var propsIndex = -1;
      var propsLength = props.length;
      while (++propsIndex < propsLength) {
        var key = props[propsIndex];
        var value = object2[key];
        if (value === void 0 || eq(value, objectProto$1[key]) && !hasOwnProperty$2.call(object2, key)) {
          object2[key] = source[key];
        }
      }
    }
    return object2;
  });
  const defaults$1 = defaults;
  function assignMergeValue(object2, key, value) {
    if (value !== void 0 && !eq(object2[key], value) || value === void 0 && !(key in object2)) {
      baseAssignValue(object2, key, value);
    }
  }
  function isArrayLikeObject(value) {
    return isObjectLike(value) && isArrayLike(value);
  }
  function safeGet(object2, key) {
    if (key === "constructor" && typeof object2[key] === "function") {
      return;
    }
    if (key == "__proto__") {
      return;
    }
    return object2[key];
  }
  function toPlainObject(value) {
    return copyObject(value, keysIn(value));
  }
  function baseMergeDeep(object2, source, key, srcIndex, mergeFunc, customizer, stack) {
    var objValue = safeGet(object2, key), srcValue = safeGet(source, key), stacked = stack.get(srcValue);
    if (stacked) {
      assignMergeValue(object2, key, stacked);
      return;
    }
    var newValue = customizer ? customizer(objValue, srcValue, key + "", object2, source, stack) : void 0;
    var isCommon = newValue === void 0;
    if (isCommon) {
      var isArr = isArray$1(srcValue), isBuff = !isArr && isBuffer$1(srcValue), isTyped = !isArr && !isBuff && isTypedArray$1(srcValue);
      newValue = srcValue;
      if (isArr || isBuff || isTyped) {
        if (isArray$1(objValue)) {
          newValue = objValue;
        } else if (isArrayLikeObject(objValue)) {
          newValue = copyArray(objValue);
        } else if (isBuff) {
          isCommon = false;
          newValue = cloneBuffer(srcValue, true);
        } else if (isTyped) {
          isCommon = false;
          newValue = cloneTypedArray(srcValue, true);
        } else {
          newValue = [];
        }
      } else if (isPlainObject(srcValue) || isArguments$1(srcValue)) {
        newValue = objValue;
        if (isArguments$1(objValue)) {
          newValue = toPlainObject(objValue);
        } else if (!isObject(objValue) || isFunction(objValue)) {
          newValue = initCloneObject(srcValue);
        }
      } else {
        isCommon = false;
      }
    }
    if (isCommon) {
      stack.set(srcValue, newValue);
      mergeFunc(newValue, srcValue, srcIndex, customizer, stack);
      stack["delete"](srcValue);
    }
    assignMergeValue(object2, key, newValue);
  }
  function baseMerge(object2, source, srcIndex, customizer, stack) {
    if (object2 === source) {
      return;
    }
    baseFor$1(source, function(srcValue, key) {
      stack || (stack = new Stack());
      if (isObject(srcValue)) {
        baseMergeDeep(object2, source, key, srcIndex, baseMerge, customizer, stack);
      } else {
        var newValue = customizer ? customizer(safeGet(object2, key), srcValue, key + "", object2, source, stack) : void 0;
        if (newValue === void 0) {
          newValue = srcValue;
        }
        assignMergeValue(object2, key, newValue);
      }
    }, keysIn);
  }
  function arrayIncludesWith(array2, value, comparator) {
    var index2 = -1, length2 = array2 == null ? 0 : array2.length;
    while (++index2 < length2) {
      if (comparator(value, array2[index2])) {
        return true;
      }
    }
    return false;
  }
  function last(array2) {
    var length2 = array2 == null ? 0 : array2.length;
    return length2 ? array2[length2 - 1] : void 0;
  }
  function castFunction(value) {
    return typeof value == "function" ? value : identity;
  }
  function forEach(collection, iteratee) {
    var func = isArray$1(collection) ? arrayEach : baseEach$1;
    return func(collection, castFunction(iteratee));
  }
  function baseFilter(collection, predicate) {
    var result = [];
    baseEach$1(collection, function(value, index2, collection2) {
      if (predicate(value, index2, collection2)) {
        result.push(value);
      }
    });
    return result;
  }
  function filter(collection, predicate) {
    var func = isArray$1(collection) ? arrayFilter : baseFilter;
    return func(collection, baseIteratee(predicate));
  }
  function createFind(findIndexFunc) {
    return function(collection, predicate, fromIndex) {
      var iterable = Object(collection);
      if (!isArrayLike(collection)) {
        var iteratee = baseIteratee(predicate);
        collection = keys$1(collection);
        predicate = function(key) {
          return iteratee(iterable[key], key, iterable);
        };
      }
      var index2 = findIndexFunc(collection, predicate, fromIndex);
      return index2 > -1 ? iterable[iteratee ? collection[index2] : index2] : void 0;
    };
  }
  var nativeMax$1 = Math.max;
  function findIndex(array2, predicate, fromIndex) {
    var length2 = array2 == null ? 0 : array2.length;
    if (!length2) {
      return -1;
    }
    var index2 = fromIndex == null ? 0 : toInteger(fromIndex);
    if (index2 < 0) {
      index2 = nativeMax$1(length2 + index2, 0);
    }
    return baseFindIndex(array2, baseIteratee(predicate), index2);
  }
  var find = createFind(findIndex);
  const find$1 = find;
  function baseMap(collection, iteratee) {
    var index2 = -1, result = isArrayLike(collection) ? Array(collection.length) : [];
    baseEach$1(collection, function(value, key, collection2) {
      result[++index2] = iteratee(value, key, collection2);
    });
    return result;
  }
  function map(collection, iteratee) {
    var func = isArray$1(collection) ? arrayMap : baseMap;
    return func(collection, baseIteratee(iteratee));
  }
  function forIn(object2, iteratee) {
    return object2 == null ? object2 : baseFor$1(object2, castFunction(iteratee), keysIn);
  }
  function forOwn(object2, iteratee) {
    return object2 && baseForOwn(object2, castFunction(iteratee));
  }
  function baseGt(value, other) {
    return value > other;
  }
  var objectProto = Object.prototype;
  var hasOwnProperty$1 = objectProto.hasOwnProperty;
  function baseHas(object2, key) {
    return object2 != null && hasOwnProperty$1.call(object2, key);
  }
  function has(object2, path2) {
    return object2 != null && hasPath(object2, path2, baseHas);
  }
  function baseValues(object2, props) {
    return arrayMap(props, function(key) {
      return object2[key];
    });
  }
  function values(object2) {
    return object2 == null ? [] : baseValues(object2, keys$1(object2));
  }
  function isUndefined(value) {
    return value === void 0;
  }
  function baseLt(value, other) {
    return value < other;
  }
  function mapValues(object2, iteratee) {
    var result = {};
    iteratee = baseIteratee(iteratee);
    baseForOwn(object2, function(value, key, object3) {
      baseAssignValue(result, key, iteratee(value, key, object3));
    });
    return result;
  }
  function baseExtremum(array2, iteratee, comparator) {
    var index2 = -1, length2 = array2.length;
    while (++index2 < length2) {
      var value = array2[index2], current = iteratee(value);
      if (current != null && (computed === void 0 ? current === current && !isSymbol(current) : comparator(current, computed))) {
        var computed = current, result = value;
      }
    }
    return result;
  }
  function max(array2) {
    return array2 && array2.length ? baseExtremum(array2, identity, baseGt) : void 0;
  }
  var merge$1 = createAssigner(function(object2, source, srcIndex) {
    baseMerge(object2, source, srcIndex);
  });
  const merge$2 = merge$1;
  function min(array2) {
    return array2 && array2.length ? baseExtremum(array2, identity, baseLt) : void 0;
  }
  function minBy(array2, iteratee) {
    return array2 && array2.length ? baseExtremum(array2, baseIteratee(iteratee), baseLt) : void 0;
  }
  function baseSet(object2, path2, value, customizer) {
    if (!isObject(object2)) {
      return object2;
    }
    path2 = castPath(path2, object2);
    var index2 = -1, length2 = path2.length, lastIndex = length2 - 1, nested = object2;
    while (nested != null && ++index2 < length2) {
      var key = toKey(path2[index2]), newValue = value;
      if (key === "__proto__" || key === "constructor" || key === "prototype") {
        return object2;
      }
      if (index2 != lastIndex) {
        var objValue = nested[key];
        newValue = customizer ? customizer(objValue, key, nested) : void 0;
        if (newValue === void 0) {
          newValue = isObject(objValue) ? objValue : isIndex(path2[index2 + 1]) ? [] : {};
        }
      }
      assignValue(nested, key, newValue);
      nested = nested[key];
    }
    return object2;
  }
  function basePickBy(object2, paths, predicate) {
    var index2 = -1, length2 = paths.length, result = {};
    while (++index2 < length2) {
      var path2 = paths[index2], value = baseGet(object2, path2);
      if (predicate(value, path2)) {
        baseSet(result, castPath(path2, object2), value);
      }
    }
    return result;
  }
  function baseSortBy(array2, comparer) {
    var length2 = array2.length;
    array2.sort(comparer);
    while (length2--) {
      array2[length2] = array2[length2].value;
    }
    return array2;
  }
  function compareAscending(value, other) {
    if (value !== other) {
      var valIsDefined = value !== void 0, valIsNull = value === null, valIsReflexive = value === value, valIsSymbol = isSymbol(value);
      var othIsDefined = other !== void 0, othIsNull = other === null, othIsReflexive = other === other, othIsSymbol = isSymbol(other);
      if (!othIsNull && !othIsSymbol && !valIsSymbol && value > other || valIsSymbol && othIsDefined && othIsReflexive && !othIsNull && !othIsSymbol || valIsNull && othIsDefined && othIsReflexive || !valIsDefined && othIsReflexive || !valIsReflexive) {
        return 1;
      }
      if (!valIsNull && !valIsSymbol && !othIsSymbol && value < other || othIsSymbol && valIsDefined && valIsReflexive && !valIsNull && !valIsSymbol || othIsNull && valIsDefined && valIsReflexive || !othIsDefined && valIsReflexive || !othIsReflexive) {
        return -1;
      }
    }
    return 0;
  }
  function compareMultiple(object2, other, orders) {
    var index2 = -1, objCriteria = object2.criteria, othCriteria = other.criteria, length2 = objCriteria.length, ordersLength = orders.length;
    while (++index2 < length2) {
      var result = compareAscending(objCriteria[index2], othCriteria[index2]);
      if (result) {
        if (index2 >= ordersLength) {
          return result;
        }
        var order2 = orders[index2];
        return result * (order2 == "desc" ? -1 : 1);
      }
    }
    return object2.index - other.index;
  }
  function baseOrderBy(collection, iteratees, orders) {
    if (iteratees.length) {
      iteratees = arrayMap(iteratees, function(iteratee) {
        if (isArray$1(iteratee)) {
          return function(value) {
            return baseGet(value, iteratee.length === 1 ? iteratee[0] : iteratee);
          };
        }
        return iteratee;
      });
    } else {
      iteratees = [identity];
    }
    var index2 = -1;
    iteratees = arrayMap(iteratees, baseUnary(baseIteratee));
    var result = baseMap(collection, function(value, key, collection2) {
      var criteria = arrayMap(iteratees, function(iteratee) {
        return iteratee(value);
      });
      return { "criteria": criteria, "index": ++index2, "value": value };
    });
    return baseSortBy(result, function(object2, other) {
      return compareMultiple(object2, other, orders);
    });
  }
  function basePick(object2, paths) {
    return basePickBy(object2, paths, function(value, path2) {
      return hasIn(object2, path2);
    });
  }
  var pick = flatRest(function(object2, paths) {
    return object2 == null ? {} : basePick(object2, paths);
  });
  const pick$1 = pick;
  var nativeCeil = Math.ceil, nativeMax = Math.max;
  function baseRange(start2, end2, step, fromRight) {
    var index2 = -1, length2 = nativeMax(nativeCeil((end2 - start2) / (step || 1)), 0), result = Array(length2);
    while (length2--) {
      result[fromRight ? length2 : ++index2] = start2;
      start2 += step;
    }
    return result;
  }
  function createRange(fromRight) {
    return function(start2, end2, step) {
      if (step && typeof step != "number" && isIterateeCall(start2, end2, step)) {
        end2 = step = void 0;
      }
      start2 = toFinite(start2);
      if (end2 === void 0) {
        end2 = start2;
        start2 = 0;
      } else {
        end2 = toFinite(end2);
      }
      step = step === void 0 ? start2 < end2 ? 1 : -1 : toFinite(step);
      return baseRange(start2, end2, step, fromRight);
    };
  }
  var range = createRange();
  const range$1 = range;
  function baseReduce(collection, iteratee, accumulator, initAccum, eachFunc) {
    eachFunc(collection, function(value, index2, collection2) {
      accumulator = initAccum ? (initAccum = false, value) : iteratee(accumulator, value, index2, collection2);
    });
    return accumulator;
  }
  function reduce(collection, iteratee, accumulator) {
    var func = isArray$1(collection) ? arrayReduce : baseReduce, initAccum = arguments.length < 3;
    return func(collection, baseIteratee(iteratee), accumulator, initAccum, baseEach$1);
  }
  var sortBy = baseRest(function(collection, iteratees) {
    if (collection == null) {
      return [];
    }
    var length2 = iteratees.length;
    if (length2 > 1 && isIterateeCall(collection, iteratees[0], iteratees[1])) {
      iteratees = [];
    } else if (length2 > 2 && isIterateeCall(iteratees[0], iteratees[1], iteratees[2])) {
      iteratees = [iteratees[0]];
    }
    return baseOrderBy(collection, baseFlatten(iteratees, 1), []);
  });
  const sortBy$1 = sortBy;
  var INFINITY = 1 / 0;
  var createSet = !(Set$2 && 1 / setToArray(new Set$2([, -0]))[1] == INFINITY) ? noop : function(values2) {
    return new Set$2(values2);
  };
  const createSet$1 = createSet;
  var LARGE_ARRAY_SIZE = 200;
  function baseUniq(array2, iteratee, comparator) {
    var index2 = -1, includes2 = arrayIncludes, length2 = array2.length, isCommon = true, result = [], seen = result;
    if (comparator) {
      isCommon = false;
      includes2 = arrayIncludesWith;
    } else if (length2 >= LARGE_ARRAY_SIZE) {
      var set2 = iteratee ? null : createSet$1(array2);
      if (set2) {
        return setToArray(set2);
      }
      isCommon = false;
      includes2 = cacheHas;
      seen = new SetCache();
    } else {
      seen = iteratee ? [] : result;
    }
    outer:
      while (++index2 < length2) {
        var value = array2[index2], computed = iteratee ? iteratee(value) : value;
        value = comparator || value !== 0 ? value : 0;
        if (isCommon && computed === computed) {
          var seenIndex = seen.length;
          while (seenIndex--) {
            if (seen[seenIndex] === computed) {
              continue outer;
            }
          }
          if (iteratee) {
            seen.push(computed);
          }
          result.push(value);
        } else if (!includes2(seen, computed, comparator)) {
          if (seen !== result) {
            seen.push(computed);
          }
          result.push(value);
        }
      }
    return result;
  }
  var union = baseRest(function(arrays) {
    return baseUniq(baseFlatten(arrays, 1, isArrayLikeObject, true));
  });
  const union$1 = union;
  var idCounter = 0;
  function uniqueId(prefix) {
    var id2 = ++idCounter;
    return toString$1(prefix) + id2;
  }
  function baseZipObject(props, values2, assignFunc) {
    var index2 = -1, length2 = props.length, valsLength = values2.length, result = {};
    while (++index2 < length2) {
      var value = index2 < valsLength ? values2[index2] : void 0;
      assignFunc(result, props[index2], value);
    }
    return result;
  }
  function zipObject(props, values2) {
    return baseZipObject(props || [], values2 || [], assignValue);
  }
  var DEFAULT_EDGE_NAME = "\0";
  var GRAPH_NODE = "\0";
  var EDGE_KEY_DELIM = "";
  class Graph {
    constructor(opts = {}) {
      this._isDirected = has(opts, "directed") ? opts.directed : true;
      this._isMultigraph = has(opts, "multigraph") ? opts.multigraph : false;
      this._isCompound = has(opts, "compound") ? opts.compound : false;
      this._label = void 0;
      this._defaultNodeLabelFn = constant(void 0);
      this._defaultEdgeLabelFn = constant(void 0);
      this._nodes = {};
      if (this._isCompound) {
        this._parent = {};
        this._children = {};
        this._children[GRAPH_NODE] = {};
      }
      this._in = {};
      this._preds = {};
      this._out = {};
      this._sucs = {};
      this._edgeObjs = {};
      this._edgeLabels = {};
    }
    /* === Graph functions ========= */
    isDirected() {
      return this._isDirected;
    }
    isMultigraph() {
      return this._isMultigraph;
    }
    isCompound() {
      return this._isCompound;
    }
    setGraph(label) {
      this._label = label;
      return this;
    }
    graph() {
      return this._label;
    }
    /* === Node functions ========== */
    setDefaultNodeLabel(newDefault) {
      if (!isFunction(newDefault)) {
        newDefault = constant(newDefault);
      }
      this._defaultNodeLabelFn = newDefault;
      return this;
    }
    nodeCount() {
      return this._nodeCount;
    }
    nodes() {
      return keys$1(this._nodes);
    }
    sources() {
      var self2 = this;
      return filter(this.nodes(), function(v) {
        return isEmpty(self2._in[v]);
      });
    }
    sinks() {
      var self2 = this;
      return filter(this.nodes(), function(v) {
        return isEmpty(self2._out[v]);
      });
    }
    setNodes(vs, value) {
      var args = arguments;
      var self2 = this;
      forEach(vs, function(v) {
        if (args.length > 1) {
          self2.setNode(v, value);
        } else {
          self2.setNode(v);
        }
      });
      return this;
    }
    setNode(v, value) {
      if (has(this._nodes, v)) {
        if (arguments.length > 1) {
          this._nodes[v] = value;
        }
        return this;
      }
      this._nodes[v] = arguments.length > 1 ? value : this._defaultNodeLabelFn(v);
      if (this._isCompound) {
        this._parent[v] = GRAPH_NODE;
        this._children[v] = {};
        this._children[GRAPH_NODE][v] = true;
      }
      this._in[v] = {};
      this._preds[v] = {};
      this._out[v] = {};
      this._sucs[v] = {};
      ++this._nodeCount;
      return this;
    }
    node(v) {
      return this._nodes[v];
    }
    hasNode(v) {
      return has(this._nodes, v);
    }
    removeNode(v) {
      var self2 = this;
      if (has(this._nodes, v)) {
        var removeEdge = function(e) {
          self2.removeEdge(self2._edgeObjs[e]);
        };
        delete this._nodes[v];
        if (this._isCompound) {
          this._removeFromParentsChildList(v);
          delete this._parent[v];
          forEach(this.children(v), function(child) {
            self2.setParent(child);
          });
          delete this._children[v];
        }
        forEach(keys$1(this._in[v]), removeEdge);
        delete this._in[v];
        delete this._preds[v];
        forEach(keys$1(this._out[v]), removeEdge);
        delete this._out[v];
        delete this._sucs[v];
        --this._nodeCount;
      }
      return this;
    }
    setParent(v, parent) {
      if (!this._isCompound) {
        throw new Error("Cannot set parent in a non-compound graph");
      }
      if (isUndefined(parent)) {
        parent = GRAPH_NODE;
      } else {
        parent += "";
        for (var ancestor = parent; !isUndefined(ancestor); ancestor = this.parent(ancestor)) {
          if (ancestor === v) {
            throw new Error("Setting " + parent + " as parent of " + v + " would create a cycle");
          }
        }
        this.setNode(parent);
      }
      this.setNode(v);
      this._removeFromParentsChildList(v);
      this._parent[v] = parent;
      this._children[parent][v] = true;
      return this;
    }
    _removeFromParentsChildList(v) {
      delete this._children[this._parent[v]][v];
    }
    parent(v) {
      if (this._isCompound) {
        var parent = this._parent[v];
        if (parent !== GRAPH_NODE) {
          return parent;
        }
      }
    }
    children(v) {
      if (isUndefined(v)) {
        v = GRAPH_NODE;
      }
      if (this._isCompound) {
        var children2 = this._children[v];
        if (children2) {
          return keys$1(children2);
        }
      } else if (v === GRAPH_NODE) {
        return this.nodes();
      } else if (this.hasNode(v)) {
        return [];
      }
    }
    predecessors(v) {
      var predsV = this._preds[v];
      if (predsV) {
        return keys$1(predsV);
      }
    }
    successors(v) {
      var sucsV = this._sucs[v];
      if (sucsV) {
        return keys$1(sucsV);
      }
    }
    neighbors(v) {
      var preds = this.predecessors(v);
      if (preds) {
        return union$1(preds, this.successors(v));
      }
    }
    isLeaf(v) {
      var neighbors;
      if (this.isDirected()) {
        neighbors = this.successors(v);
      } else {
        neighbors = this.neighbors(v);
      }
      return neighbors.length === 0;
    }
    filterNodes(filter2) {
      var copy2 = new this.constructor({
        directed: this._isDirected,
        multigraph: this._isMultigraph,
        compound: this._isCompound
      });
      copy2.setGraph(this.graph());
      var self2 = this;
      forEach(this._nodes, function(value, v) {
        if (filter2(v)) {
          copy2.setNode(v, value);
        }
      });
      forEach(this._edgeObjs, function(e) {
        if (copy2.hasNode(e.v) && copy2.hasNode(e.w)) {
          copy2.setEdge(e, self2.edge(e));
        }
      });
      var parents2 = {};
      function findParent(v) {
        var parent = self2.parent(v);
        if (parent === void 0 || copy2.hasNode(parent)) {
          parents2[v] = parent;
          return parent;
        } else if (parent in parents2) {
          return parents2[parent];
        } else {
          return findParent(parent);
        }
      }
      if (this._isCompound) {
        forEach(copy2.nodes(), function(v) {
          copy2.setParent(v, findParent(v));
        });
      }
      return copy2;
    }
    /* === Edge functions ========== */
    setDefaultEdgeLabel(newDefault) {
      if (!isFunction(newDefault)) {
        newDefault = constant(newDefault);
      }
      this._defaultEdgeLabelFn = newDefault;
      return this;
    }
    edgeCount() {
      return this._edgeCount;
    }
    edges() {
      return values(this._edgeObjs);
    }
    setPath(vs, value) {
      var self2 = this;
      var args = arguments;
      reduce(vs, function(v, w2) {
        if (args.length > 1) {
          self2.setEdge(v, w2, value);
        } else {
          self2.setEdge(v, w2);
        }
        return w2;
      });
      return this;
    }
    /*
     * setEdge(v, w, [value, [name]])
     * setEdge({ v, w, [name] }, [value])
     */
    setEdge() {
      var v, w2, name2, value;
      var valueSpecified = false;
      var arg0 = arguments[0];
      if (typeof arg0 === "object" && arg0 !== null && "v" in arg0) {
        v = arg0.v;
        w2 = arg0.w;
        name2 = arg0.name;
        if (arguments.length === 2) {
          value = arguments[1];
          valueSpecified = true;
        }
      } else {
        v = arg0;
        w2 = arguments[1];
        name2 = arguments[3];
        if (arguments.length > 2) {
          value = arguments[2];
          valueSpecified = true;
        }
      }
      v = "" + v;
      w2 = "" + w2;
      if (!isUndefined(name2)) {
        name2 = "" + name2;
      }
      var e = edgeArgsToId(this._isDirected, v, w2, name2);
      if (has(this._edgeLabels, e)) {
        if (valueSpecified) {
          this._edgeLabels[e] = value;
        }
        return this;
      }
      if (!isUndefined(name2) && !this._isMultigraph) {
        throw new Error("Cannot set a named edge when isMultigraph = false");
      }
      this.setNode(v);
      this.setNode(w2);
      this._edgeLabels[e] = valueSpecified ? value : this._defaultEdgeLabelFn(v, w2, name2);
      var edgeObj = edgeArgsToObj(this._isDirected, v, w2, name2);
      v = edgeObj.v;
      w2 = edgeObj.w;
      Object.freeze(edgeObj);
      this._edgeObjs[e] = edgeObj;
      incrementOrInitEntry(this._preds[w2], v);
      incrementOrInitEntry(this._sucs[v], w2);
      this._in[w2][e] = edgeObj;
      this._out[v][e] = edgeObj;
      this._edgeCount++;
      return this;
    }
    edge(v, w2, name2) {
      var e = arguments.length === 1 ? edgeObjToId(this._isDirected, arguments[0]) : edgeArgsToId(this._isDirected, v, w2, name2);
      return this._edgeLabels[e];
    }
    hasEdge(v, w2, name2) {
      var e = arguments.length === 1 ? edgeObjToId(this._isDirected, arguments[0]) : edgeArgsToId(this._isDirected, v, w2, name2);
      return has(this._edgeLabels, e);
    }
    removeEdge(v, w2, name2) {
      var e = arguments.length === 1 ? edgeObjToId(this._isDirected, arguments[0]) : edgeArgsToId(this._isDirected, v, w2, name2);
      var edge = this._edgeObjs[e];
      if (edge) {
        v = edge.v;
        w2 = edge.w;
        delete this._edgeLabels[e];
        delete this._edgeObjs[e];
        decrementOrRemoveEntry(this._preds[w2], v);
        decrementOrRemoveEntry(this._sucs[v], w2);
        delete this._in[w2][e];
        delete this._out[v][e];
        this._edgeCount--;
      }
      return this;
    }
    inEdges(v, u) {
      var inV = this._in[v];
      if (inV) {
        var edges2 = values(inV);
        if (!u) {
          return edges2;
        }
        return filter(edges2, function(edge) {
          return edge.v === u;
        });
      }
    }
    outEdges(v, w2) {
      var outV = this._out[v];
      if (outV) {
        var edges2 = values(outV);
        if (!w2) {
          return edges2;
        }
        return filter(edges2, function(edge) {
          return edge.w === w2;
        });
      }
    }
    nodeEdges(v, w2) {
      var inEdges = this.inEdges(v, w2);
      if (inEdges) {
        return inEdges.concat(this.outEdges(v, w2));
      }
    }
  }
  Graph.prototype._nodeCount = 0;
  Graph.prototype._edgeCount = 0;
  function incrementOrInitEntry(map2, k) {
    if (map2[k]) {
      map2[k]++;
    } else {
      map2[k] = 1;
    }
  }
  function decrementOrRemoveEntry(map2, k) {
    if (!--map2[k]) {
      delete map2[k];
    }
  }
  function edgeArgsToId(isDirected, v_, w_, name2) {
    var v = "" + v_;
    var w2 = "" + w_;
    if (!isDirected && v > w2) {
      var tmp = v;
      v = w2;
      w2 = tmp;
    }
    return v + EDGE_KEY_DELIM + w2 + EDGE_KEY_DELIM + (isUndefined(name2) ? DEFAULT_EDGE_NAME : name2);
  }
  function edgeArgsToObj(isDirected, v_, w_, name2) {
    var v = "" + v_;
    var w2 = "" + w_;
    if (!isDirected && v > w2) {
      var tmp = v;
      v = w2;
      w2 = tmp;
    }
    var edgeObj = { v, w: w2 };
    if (name2) {
      edgeObj.name = name2;
    }
    return edgeObj;
  }
  function edgeObjToId(isDirected, edgeObj) {
    return edgeArgsToId(isDirected, edgeObj.v, edgeObj.w, edgeObj.name);
  }
  class List {
    constructor() {
      var sentinel = {};
      sentinel._next = sentinel._prev = sentinel;
      this._sentinel = sentinel;
    }
    dequeue() {
      var sentinel = this._sentinel;
      var entry = sentinel._prev;
      if (entry !== sentinel) {
        unlink(entry);
        return entry;
      }
    }
    enqueue(entry) {
      var sentinel = this._sentinel;
      if (entry._prev && entry._next) {
        unlink(entry);
      }
      entry._next = sentinel._next;
      sentinel._next._prev = entry;
      sentinel._next = entry;
      entry._prev = sentinel;
    }
    toString() {
      var strs = [];
      var sentinel = this._sentinel;
      var curr = sentinel._prev;
      while (curr !== sentinel) {
        strs.push(JSON.stringify(curr, filterOutLinks));
        curr = curr._prev;
      }
      return "[" + strs.join(", ") + "]";
    }
  }
  function unlink(entry) {
    entry._prev._next = entry._next;
    entry._next._prev = entry._prev;
    delete entry._next;
    delete entry._prev;
  }
  function filterOutLinks(k, v) {
    if (k !== "_next" && k !== "_prev") {
      return v;
    }
  }
  var DEFAULT_WEIGHT_FN = constant(1);
  function greedyFAS(g, weightFn) {
    if (g.nodeCount() <= 1) {
      return [];
    }
    var state2 = buildState(g, weightFn || DEFAULT_WEIGHT_FN);
    var results = doGreedyFAS(state2.graph, state2.buckets, state2.zeroIdx);
    return flatten(
      map(results, function(e) {
        return g.outEdges(e.v, e.w);
      })
    );
  }
  function doGreedyFAS(g, buckets, zeroIdx) {
    var results = [];
    var sources = buckets[buckets.length - 1];
    var sinks = buckets[0];
    var entry;
    while (g.nodeCount()) {
      while (entry = sinks.dequeue()) {
        removeNode(g, buckets, zeroIdx, entry);
      }
      while (entry = sources.dequeue()) {
        removeNode(g, buckets, zeroIdx, entry);
      }
      if (g.nodeCount()) {
        for (var i2 = buckets.length - 2; i2 > 0; --i2) {
          entry = buckets[i2].dequeue();
          if (entry) {
            results = results.concat(removeNode(g, buckets, zeroIdx, entry, true));
            break;
          }
        }
      }
    }
    return results;
  }
  function removeNode(g, buckets, zeroIdx, entry, collectPredecessors) {
    var results = collectPredecessors ? [] : void 0;
    forEach(g.inEdges(entry.v), function(edge) {
      var weight = g.edge(edge);
      var uEntry = g.node(edge.v);
      if (collectPredecessors) {
        results.push({ v: edge.v, w: edge.w });
      }
      uEntry.out -= weight;
      assignBucket(buckets, zeroIdx, uEntry);
    });
    forEach(g.outEdges(entry.v), function(edge) {
      var weight = g.edge(edge);
      var w2 = edge.w;
      var wEntry = g.node(w2);
      wEntry["in"] -= weight;
      assignBucket(buckets, zeroIdx, wEntry);
    });
    g.removeNode(entry.v);
    return results;
  }
  function buildState(g, weightFn) {
    var fasGraph = new Graph();
    var maxIn = 0;
    var maxOut = 0;
    forEach(g.nodes(), function(v) {
      fasGraph.setNode(v, { v, in: 0, out: 0 });
    });
    forEach(g.edges(), function(e) {
      var prevWeight = fasGraph.edge(e.v, e.w) || 0;
      var weight = weightFn(e);
      var edgeWeight = prevWeight + weight;
      fasGraph.setEdge(e.v, e.w, edgeWeight);
      maxOut = Math.max(maxOut, fasGraph.node(e.v).out += weight);
      maxIn = Math.max(maxIn, fasGraph.node(e.w)["in"] += weight);
    });
    var buckets = range$1(maxOut + maxIn + 3).map(function() {
      return new List();
    });
    var zeroIdx = maxIn + 1;
    forEach(fasGraph.nodes(), function(v) {
      assignBucket(buckets, zeroIdx, fasGraph.node(v));
    });
    return { graph: fasGraph, buckets, zeroIdx };
  }
  function assignBucket(buckets, zeroIdx, entry) {
    if (!entry.out) {
      buckets[0].enqueue(entry);
    } else if (!entry["in"]) {
      buckets[buckets.length - 1].enqueue(entry);
    } else {
      buckets[entry.out - entry["in"] + zeroIdx].enqueue(entry);
    }
  }
  function run$2(g) {
    var fas = g.graph().acyclicer === "greedy" ? greedyFAS(g, weightFn(g)) : dfsFAS(g);
    forEach(fas, function(e) {
      var label = g.edge(e);
      g.removeEdge(e);
      label.forwardName = e.name;
      label.reversed = true;
      g.setEdge(e.w, e.v, label, uniqueId("rev"));
    });
    function weightFn(g2) {
      return function(e) {
        return g2.edge(e).weight;
      };
    }
  }
  function dfsFAS(g) {
    var fas = [];
    var stack = {};
    var visited = {};
    function dfs2(v) {
      if (has(visited, v)) {
        return;
      }
      visited[v] = true;
      stack[v] = true;
      forEach(g.outEdges(v), function(e) {
        if (has(stack, e.w)) {
          fas.push(e);
        } else {
          dfs2(e.w);
        }
      });
      delete stack[v];
    }
    forEach(g.nodes(), dfs2);
    return fas;
  }
  function undo$2(g) {
    forEach(g.edges(), function(e) {
      var label = g.edge(e);
      if (label.reversed) {
        g.removeEdge(e);
        var forwardName = label.forwardName;
        delete label.reversed;
        delete label.forwardName;
        g.setEdge(e.w, e.v, label, forwardName);
      }
    });
  }
  function addDummyNode(g, type2, attrs, name2) {
    var v;
    do {
      v = uniqueId(name2);
    } while (g.hasNode(v));
    attrs.dummy = type2;
    g.setNode(v, attrs);
    return v;
  }
  function simplify(g) {
    var simplified = new Graph().setGraph(g.graph());
    forEach(g.nodes(), function(v) {
      simplified.setNode(v, g.node(v));
    });
    forEach(g.edges(), function(e) {
      var simpleLabel = simplified.edge(e.v, e.w) || { weight: 0, minlen: 1 };
      var label = g.edge(e);
      simplified.setEdge(e.v, e.w, {
        weight: simpleLabel.weight + label.weight,
        minlen: Math.max(simpleLabel.minlen, label.minlen)
      });
    });
    return simplified;
  }
  function asNonCompoundGraph(g) {
    var simplified = new Graph({ multigraph: g.isMultigraph() }).setGraph(g.graph());
    forEach(g.nodes(), function(v) {
      if (!g.children(v).length) {
        simplified.setNode(v, g.node(v));
      }
    });
    forEach(g.edges(), function(e) {
      simplified.setEdge(e, g.edge(e));
    });
    return simplified;
  }
  function intersectRect$3(rect2, point2) {
    var x2 = rect2.x;
    var y2 = rect2.y;
    var dx = point2.x - x2;
    var dy = point2.y - y2;
    var w2 = rect2.width / 2;
    var h = rect2.height / 2;
    if (!dx && !dy) {
      throw new Error("Not possible to find intersection inside of the rectangle");
    }
    var sx, sy;
    if (Math.abs(dy) * w2 > Math.abs(dx) * h) {
      if (dy < 0) {
        h = -h;
      }
      sx = h * dx / dy;
      sy = h;
    } else {
      if (dx < 0) {
        w2 = -w2;
      }
      sx = w2;
      sy = w2 * dy / dx;
    }
    return { x: x2 + sx, y: y2 + sy };
  }
  function buildLayerMatrix(g) {
    var layering = map(range$1(maxRank(g) + 1), function() {
      return [];
    });
    forEach(g.nodes(), function(v) {
      var node2 = g.node(v);
      var rank2 = node2.rank;
      if (!isUndefined(rank2)) {
        layering[rank2][node2.order] = v;
      }
    });
    return layering;
  }
  function normalizeRanks(g) {
    var min$12 = min(
      map(g.nodes(), function(v) {
        return g.node(v).rank;
      })
    );
    forEach(g.nodes(), function(v) {
      var node2 = g.node(v);
      if (has(node2, "rank")) {
        node2.rank -= min$12;
      }
    });
  }
  function removeEmptyRanks(g) {
    var offset = min(
      map(g.nodes(), function(v) {
        return g.node(v).rank;
      })
    );
    var layers = [];
    forEach(g.nodes(), function(v) {
      var rank2 = g.node(v).rank - offset;
      if (!layers[rank2]) {
        layers[rank2] = [];
      }
      layers[rank2].push(v);
    });
    var delta = 0;
    var nodeRankFactor = g.graph().nodeRankFactor;
    forEach(layers, function(vs, i2) {
      if (isUndefined(vs) && i2 % nodeRankFactor !== 0) {
        --delta;
      } else if (delta) {
        forEach(vs, function(v) {
          g.node(v).rank += delta;
        });
      }
    });
  }
  function addBorderNode$1(g, prefix, rank2, order2) {
    var node2 = {
      width: 0,
      height: 0
    };
    if (arguments.length >= 4) {
      node2.rank = rank2;
      node2.order = order2;
    }
    return addDummyNode(g, "border", node2, prefix);
  }
  function maxRank(g) {
    return max(
      map(g.nodes(), function(v) {
        var rank2 = g.node(v).rank;
        if (!isUndefined(rank2)) {
          return rank2;
        }
      })
    );
  }
  function partition(collection, fn) {
    var result = { lhs: [], rhs: [] };
    forEach(collection, function(value) {
      if (fn(value)) {
        result.lhs.push(value);
      } else {
        result.rhs.push(value);
      }
    });
    return result;
  }
  function time(name2, fn) {
    var start2 = now$1();
    try {
      return fn();
    } finally {
      console.log(name2 + " time: " + (now$1() - start2) + "ms");
    }
  }
  function notime(name2, fn) {
    return fn();
  }
  function addBorderSegments(g) {
    function dfs2(v) {
      var children2 = g.children(v);
      var node2 = g.node(v);
      if (children2.length) {
        forEach(children2, dfs2);
      }
      if (has(node2, "minRank")) {
        node2.borderLeft = [];
        node2.borderRight = [];
        for (var rank2 = node2.minRank, maxRank2 = node2.maxRank + 1; rank2 < maxRank2; ++rank2) {
          addBorderNode(g, "borderLeft", "_bl", v, node2, rank2);
          addBorderNode(g, "borderRight", "_br", v, node2, rank2);
        }
      }
    }
    forEach(g.children(), dfs2);
  }
  function addBorderNode(g, prop, prefix, sg, sgNode, rank2) {
    var label = { width: 0, height: 0, rank: rank2, borderType: prop };
    var prev2 = sgNode[prop][rank2 - 1];
    var curr = addDummyNode(g, "border", label, prefix);
    sgNode[prop][rank2] = curr;
    g.setParent(curr, sg);
    if (prev2) {
      g.setEdge(prev2, curr, { weight: 1 });
    }
  }
  function adjust(g) {
    var rankDir = g.graph().rankdir.toLowerCase();
    if (rankDir === "lr" || rankDir === "rl") {
      swapWidthHeight(g);
    }
  }
  function undo$1(g) {
    var rankDir = g.graph().rankdir.toLowerCase();
    if (rankDir === "bt" || rankDir === "rl") {
      reverseY(g);
    }
    if (rankDir === "lr" || rankDir === "rl") {
      swapXY(g);
      swapWidthHeight(g);
    }
  }
  function swapWidthHeight(g) {
    forEach(g.nodes(), function(v) {
      swapWidthHeightOne(g.node(v));
    });
    forEach(g.edges(), function(e) {
      swapWidthHeightOne(g.edge(e));
    });
  }
  function swapWidthHeightOne(attrs) {
    var w2 = attrs.width;
    attrs.width = attrs.height;
    attrs.height = w2;
  }
  function reverseY(g) {
    forEach(g.nodes(), function(v) {
      reverseYOne(g.node(v));
    });
    forEach(g.edges(), function(e) {
      var edge = g.edge(e);
      forEach(edge.points, reverseYOne);
      if (has(edge, "y")) {
        reverseYOne(edge);
      }
    });
  }
  function reverseYOne(attrs) {
    attrs.y = -attrs.y;
  }
  function swapXY(g) {
    forEach(g.nodes(), function(v) {
      swapXYOne(g.node(v));
    });
    forEach(g.edges(), function(e) {
      var edge = g.edge(e);
      forEach(edge.points, swapXYOne);
      if (has(edge, "x")) {
        swapXYOne(edge);
      }
    });
  }
  function swapXYOne(attrs) {
    var x2 = attrs.x;
    attrs.x = attrs.y;
    attrs.y = x2;
  }
  function run$1(g) {
    g.graph().dummyChains = [];
    forEach(g.edges(), function(edge) {
      normalizeEdge(g, edge);
    });
  }
  function normalizeEdge(g, e) {
    var v = e.v;
    var vRank = g.node(v).rank;
    var w2 = e.w;
    var wRank = g.node(w2).rank;
    var name2 = e.name;
    var edgeLabel = g.edge(e);
    var labelRank = edgeLabel.labelRank;
    if (wRank === vRank + 1)
      return;
    g.removeEdge(e);
    var dummy, attrs, i2;
    for (i2 = 0, ++vRank; vRank < wRank; ++i2, ++vRank) {
      edgeLabel.points = [];
      attrs = {
        width: 0,
        height: 0,
        edgeLabel,
        edgeObj: e,
        rank: vRank
      };
      dummy = addDummyNode(g, "edge", attrs, "_d");
      if (vRank === labelRank) {
        attrs.width = edgeLabel.width;
        attrs.height = edgeLabel.height;
        attrs.dummy = "edge-label";
        attrs.labelpos = edgeLabel.labelpos;
      }
      g.setEdge(v, dummy, { weight: edgeLabel.weight }, name2);
      if (i2 === 0) {
        g.graph().dummyChains.push(dummy);
      }
      v = dummy;
    }
    g.setEdge(v, w2, { weight: edgeLabel.weight }, name2);
  }
  function undo(g) {
    forEach(g.graph().dummyChains, function(v) {
      var node2 = g.node(v);
      var origLabel = node2.edgeLabel;
      var w2;
      g.setEdge(node2.edgeObj, origLabel);
      while (node2.dummy) {
        w2 = g.successors(v)[0];
        g.removeNode(v);
        origLabel.points.push({ x: node2.x, y: node2.y });
        if (node2.dummy === "edge-label") {
          origLabel.x = node2.x;
          origLabel.y = node2.y;
          origLabel.width = node2.width;
          origLabel.height = node2.height;
        }
        v = w2;
        node2 = g.node(v);
      }
    });
  }
  function longestPath(g) {
    var visited = {};
    function dfs2(v) {
      var label = g.node(v);
      if (has(visited, v)) {
        return label.rank;
      }
      visited[v] = true;
      var rank2 = min(
        map(g.outEdges(v), function(e) {
          return dfs2(e.w) - g.edge(e).minlen;
        })
      );
      if (rank2 === Number.POSITIVE_INFINITY || // return value of _.map([]) for Lodash 3
      rank2 === void 0 || // return value of _.map([]) for Lodash 4
      rank2 === null) {
        rank2 = 0;
      }
      return label.rank = rank2;
    }
    forEach(g.sources(), dfs2);
  }
  function slack(g, e) {
    return g.node(e.w).rank - g.node(e.v).rank - g.edge(e).minlen;
  }
  function feasibleTree(g) {
    var t = new Graph({ directed: false });
    var start2 = g.nodes()[0];
    var size2 = g.nodeCount();
    t.setNode(start2, {});
    var edge, delta;
    while (tightTree(t, g) < size2) {
      edge = findMinSlackEdge(t, g);
      delta = t.hasNode(edge.v) ? slack(g, edge) : -slack(g, edge);
      shiftRanks(t, g, delta);
    }
    return t;
  }
  function tightTree(t, g) {
    function dfs2(v) {
      forEach(g.nodeEdges(v), function(e) {
        var edgeV = e.v, w2 = v === edgeV ? e.w : edgeV;
        if (!t.hasNode(w2) && !slack(g, e)) {
          t.setNode(w2, {});
          t.setEdge(v, w2, {});
          dfs2(w2);
        }
      });
    }
    forEach(t.nodes(), dfs2);
    return t.nodeCount();
  }
  function findMinSlackEdge(t, g) {
    return minBy(g.edges(), function(e) {
      if (t.hasNode(e.v) !== t.hasNode(e.w)) {
        return slack(g, e);
      }
    });
  }
  function shiftRanks(t, g, delta) {
    forEach(t.nodes(), function(v) {
      g.node(v).rank += delta;
    });
  }
  function CycleException() {
  }
  CycleException.prototype = new Error();
  function dfs$1(g, vs, order2) {
    if (!isArray$1(vs)) {
      vs = [vs];
    }
    var navigation = (g.isDirected() ? g.successors : g.neighbors).bind(g);
    var acc = [];
    var visited = {};
    forEach(vs, function(v) {
      if (!g.hasNode(v)) {
        throw new Error("Graph does not have node: " + v);
      }
      doDfs(g, v, order2 === "post", visited, navigation, acc);
    });
    return acc;
  }
  function doDfs(g, v, postorder2, visited, navigation, acc) {
    if (!has(visited, v)) {
      visited[v] = true;
      if (!postorder2) {
        acc.push(v);
      }
      forEach(navigation(v), function(w2) {
        doDfs(g, w2, postorder2, visited, navigation, acc);
      });
      if (postorder2) {
        acc.push(v);
      }
    }
  }
  function postorder$1(g, vs) {
    return dfs$1(g, vs, "post");
  }
  function preorder(g, vs) {
    return dfs$1(g, vs, "pre");
  }
  networkSimplex.initLowLimValues = initLowLimValues;
  networkSimplex.initCutValues = initCutValues;
  networkSimplex.calcCutValue = calcCutValue;
  networkSimplex.leaveEdge = leaveEdge;
  networkSimplex.enterEdge = enterEdge;
  networkSimplex.exchangeEdges = exchangeEdges;
  function networkSimplex(g) {
    g = simplify(g);
    longestPath(g);
    var t = feasibleTree(g);
    initLowLimValues(t);
    initCutValues(t, g);
    var e, f2;
    while (e = leaveEdge(t)) {
      f2 = enterEdge(t, g, e);
      exchangeEdges(t, g, e, f2);
    }
  }
  function initCutValues(t, g) {
    var vs = postorder$1(t, t.nodes());
    vs = vs.slice(0, vs.length - 1);
    forEach(vs, function(v) {
      assignCutValue(t, g, v);
    });
  }
  function assignCutValue(t, g, child) {
    var childLab = t.node(child);
    var parent = childLab.parent;
    t.edge(child, parent).cutvalue = calcCutValue(t, g, child);
  }
  function calcCutValue(t, g, child) {
    var childLab = t.node(child);
    var parent = childLab.parent;
    var childIsTail = true;
    var graphEdge = g.edge(child, parent);
    var cutValue = 0;
    if (!graphEdge) {
      childIsTail = false;
      graphEdge = g.edge(parent, child);
    }
    cutValue = graphEdge.weight;
    forEach(g.nodeEdges(child), function(e) {
      var isOutEdge = e.v === child, other = isOutEdge ? e.w : e.v;
      if (other !== parent) {
        var pointsToHead = isOutEdge === childIsTail, otherWeight = g.edge(e).weight;
        cutValue += pointsToHead ? otherWeight : -otherWeight;
        if (isTreeEdge(t, child, other)) {
          var otherCutValue = t.edge(child, other).cutvalue;
          cutValue += pointsToHead ? -otherCutValue : otherCutValue;
        }
      }
    });
    return cutValue;
  }
  function initLowLimValues(tree, root2) {
    if (arguments.length < 2) {
      root2 = tree.nodes()[0];
    }
    dfsAssignLowLim(tree, {}, 1, root2);
  }
  function dfsAssignLowLim(tree, visited, nextLim, v, parent) {
    var low = nextLim;
    var label = tree.node(v);
    visited[v] = true;
    forEach(tree.neighbors(v), function(w2) {
      if (!has(visited, w2)) {
        nextLim = dfsAssignLowLim(tree, visited, nextLim, w2, v);
      }
    });
    label.low = low;
    label.lim = nextLim++;
    if (parent) {
      label.parent = parent;
    } else {
      delete label.parent;
    }
    return nextLim;
  }
  function leaveEdge(tree) {
    return find$1(tree.edges(), function(e) {
      return tree.edge(e).cutvalue < 0;
    });
  }
  function enterEdge(t, g, edge) {
    var v = edge.v;
    var w2 = edge.w;
    if (!g.hasEdge(v, w2)) {
      v = edge.w;
      w2 = edge.v;
    }
    var vLabel = t.node(v);
    var wLabel = t.node(w2);
    var tailLabel = vLabel;
    var flip = false;
    if (vLabel.lim > wLabel.lim) {
      tailLabel = wLabel;
      flip = true;
    }
    var candidates = filter(g.edges(), function(edge2) {
      return flip === isDescendant$1(t, t.node(edge2.v), tailLabel) && flip !== isDescendant$1(t, t.node(edge2.w), tailLabel);
    });
    return minBy(candidates, function(edge2) {
      return slack(g, edge2);
    });
  }
  function exchangeEdges(t, g, e, f2) {
    var v = e.v;
    var w2 = e.w;
    t.removeEdge(v, w2);
    t.setEdge(f2.v, f2.w, {});
    initLowLimValues(t);
    initCutValues(t, g);
    updateRanks(t, g);
  }
  function updateRanks(t, g) {
    var root2 = find$1(t.nodes(), function(v) {
      return !g.node(v).parent;
    });
    var vs = preorder(t, root2);
    vs = vs.slice(1);
    forEach(vs, function(v) {
      var parent = t.node(v).parent, edge = g.edge(v, parent), flipped = false;
      if (!edge) {
        edge = g.edge(parent, v);
        flipped = true;
      }
      g.node(v).rank = g.node(parent).rank + (flipped ? edge.minlen : -edge.minlen);
    });
  }
  function isTreeEdge(tree, u, v) {
    return tree.hasEdge(u, v);
  }
  function isDescendant$1(tree, vLabel, rootLabel) {
    return rootLabel.low <= vLabel.lim && vLabel.lim <= rootLabel.lim;
  }
  function rank(g) {
    switch (g.graph().ranker) {
      case "network-simplex":
        networkSimplexRanker(g);
        break;
      case "tight-tree":
        tightTreeRanker(g);
        break;
      case "longest-path":
        longestPathRanker(g);
        break;
      default:
        networkSimplexRanker(g);
    }
  }
  var longestPathRanker = longestPath;
  function tightTreeRanker(g) {
    longestPath(g);
    feasibleTree(g);
  }
  function networkSimplexRanker(g) {
    networkSimplex(g);
  }
  function run(g) {
    var root2 = addDummyNode(g, "root", {}, "_root");
    var depths = treeDepths(g);
    var height2 = max(values(depths)) - 1;
    var nodeSep = 2 * height2 + 1;
    g.graph().nestingRoot = root2;
    forEach(g.edges(), function(e) {
      g.edge(e).minlen *= nodeSep;
    });
    var weight = sumWeights(g) + 1;
    forEach(g.children(), function(child) {
      dfs(g, root2, nodeSep, weight, height2, depths, child);
    });
    g.graph().nodeRankFactor = nodeSep;
  }
  function dfs(g, root2, nodeSep, weight, height2, depths, v) {
    var children2 = g.children(v);
    if (!children2.length) {
      if (v !== root2) {
        g.setEdge(root2, v, { weight: 0, minlen: nodeSep });
      }
      return;
    }
    var top2 = addBorderNode$1(g, "_bt");
    var bottom2 = addBorderNode$1(g, "_bb");
    var label = g.node(v);
    g.setParent(top2, v);
    label.borderTop = top2;
    g.setParent(bottom2, v);
    label.borderBottom = bottom2;
    forEach(children2, function(child) {
      dfs(g, root2, nodeSep, weight, height2, depths, child);
      var childNode = g.node(child);
      var childTop = childNode.borderTop ? childNode.borderTop : child;
      var childBottom = childNode.borderBottom ? childNode.borderBottom : child;
      var thisWeight = childNode.borderTop ? weight : 2 * weight;
      var minlen = childTop !== childBottom ? 1 : height2 - depths[v] + 1;
      g.setEdge(top2, childTop, {
        weight: thisWeight,
        minlen,
        nestingEdge: true
      });
      g.setEdge(childBottom, bottom2, {
        weight: thisWeight,
        minlen,
        nestingEdge: true
      });
    });
    if (!g.parent(v)) {
      g.setEdge(root2, top2, { weight: 0, minlen: height2 + depths[v] });
    }
  }
  function treeDepths(g) {
    var depths = {};
    function dfs2(v, depth) {
      var children2 = g.children(v);
      if (children2 && children2.length) {
        forEach(children2, function(child) {
          dfs2(child, depth + 1);
        });
      }
      depths[v] = depth;
    }
    forEach(g.children(), function(v) {
      dfs2(v, 1);
    });
    return depths;
  }
  function sumWeights(g) {
    return reduce(
      g.edges(),
      function(acc, e) {
        return acc + g.edge(e).weight;
      },
      0
    );
  }
  function cleanup(g) {
    var graphLabel = g.graph();
    g.removeNode(graphLabel.nestingRoot);
    delete graphLabel.nestingRoot;
    forEach(g.edges(), function(e) {
      var edge = g.edge(e);
      if (edge.nestingEdge) {
        g.removeEdge(e);
      }
    });
  }
  function addSubgraphConstraints(g, cg, vs) {
    var prev2 = {}, rootPrev;
    forEach(vs, function(v) {
      var child = g.parent(v), parent, prevChild;
      while (child) {
        parent = g.parent(child);
        if (parent) {
          prevChild = prev2[parent];
          prev2[parent] = child;
        } else {
          prevChild = rootPrev;
          rootPrev = child;
        }
        if (prevChild && prevChild !== child) {
          cg.setEdge(prevChild, child);
          return;
        }
        child = parent;
      }
    });
  }
  function buildLayerGraph(g, rank2, relationship) {
    var root2 = createRootNode(g), result = new Graph({ compound: true }).setGraph({ root: root2 }).setDefaultNodeLabel(function(v) {
      return g.node(v);
    });
    forEach(g.nodes(), function(v) {
      var node2 = g.node(v), parent = g.parent(v);
      if (node2.rank === rank2 || node2.minRank <= rank2 && rank2 <= node2.maxRank) {
        result.setNode(v);
        result.setParent(v, parent || root2);
        forEach(g[relationship](v), function(e) {
          var u = e.v === v ? e.w : e.v, edge = result.edge(u, v), weight = !isUndefined(edge) ? edge.weight : 0;
          result.setEdge(u, v, { weight: g.edge(e).weight + weight });
        });
        if (has(node2, "minRank")) {
          result.setNode(v, {
            borderLeft: node2.borderLeft[rank2],
            borderRight: node2.borderRight[rank2]
          });
        }
      }
    });
    return result;
  }
  function createRootNode(g) {
    var v;
    while (g.hasNode(v = uniqueId("_root")))
      ;
    return v;
  }
  function crossCount(g, layering) {
    var cc = 0;
    for (var i2 = 1; i2 < layering.length; ++i2) {
      cc += twoLayerCrossCount(g, layering[i2 - 1], layering[i2]);
    }
    return cc;
  }
  function twoLayerCrossCount(g, northLayer, southLayer) {
    var southPos = zipObject(
      southLayer,
      map(southLayer, function(v, i2) {
        return i2;
      })
    );
    var southEntries = flatten(
      map(northLayer, function(v) {
        return sortBy$1(
          map(g.outEdges(v), function(e) {
            return { pos: southPos[e.w], weight: g.edge(e).weight };
          }),
          "pos"
        );
      })
    );
    var firstIndex = 1;
    while (firstIndex < southLayer.length)
      firstIndex <<= 1;
    var treeSize = 2 * firstIndex - 1;
    firstIndex -= 1;
    var tree = map(new Array(treeSize), function() {
      return 0;
    });
    var cc = 0;
    forEach(
      // @ts-expect-error
      southEntries.forEach(function(entry) {
        var index2 = entry.pos + firstIndex;
        tree[index2] += entry.weight;
        var weightSum = 0;
        while (index2 > 0) {
          if (index2 % 2) {
            weightSum += tree[index2 + 1];
          }
          index2 = index2 - 1 >> 1;
          tree[index2] += entry.weight;
        }
        cc += entry.weight * weightSum;
      })
    );
    return cc;
  }
  function initOrder(g) {
    var visited = {};
    var simpleNodes = filter(g.nodes(), function(v) {
      return !g.children(v).length;
    });
    var maxRank2 = max(
      map(simpleNodes, function(v) {
        return g.node(v).rank;
      })
    );
    var layers = map(range$1(maxRank2 + 1), function() {
      return [];
    });
    function dfs2(v) {
      if (has(visited, v))
        return;
      visited[v] = true;
      var node2 = g.node(v);
      layers[node2.rank].push(v);
      forEach(g.successors(v), dfs2);
    }
    var orderedVs = sortBy$1(simpleNodes, function(v) {
      return g.node(v).rank;
    });
    forEach(orderedVs, dfs2);
    return layers;
  }
  function barycenter(g, movable) {
    return map(movable, function(v) {
      var inV = g.inEdges(v);
      if (!inV.length) {
        return { v };
      } else {
        var result = reduce(
          inV,
          function(acc, e) {
            var edge = g.edge(e), nodeU = g.node(e.v);
            return {
              sum: acc.sum + edge.weight * nodeU.order,
              weight: acc.weight + edge.weight
            };
          },
          { sum: 0, weight: 0 }
        );
        return {
          v,
          barycenter: result.sum / result.weight,
          weight: result.weight
        };
      }
    });
  }
  function resolveConflicts(entries2, cg) {
    var mappedEntries = {};
    forEach(entries2, function(entry, i2) {
      var tmp = mappedEntries[entry.v] = {
        indegree: 0,
        in: [],
        out: [],
        vs: [entry.v],
        i: i2
      };
      if (!isUndefined(entry.barycenter)) {
        tmp.barycenter = entry.barycenter;
        tmp.weight = entry.weight;
      }
    });
    forEach(cg.edges(), function(e) {
      var entryV = mappedEntries[e.v];
      var entryW = mappedEntries[e.w];
      if (!isUndefined(entryV) && !isUndefined(entryW)) {
        entryW.indegree++;
        entryV.out.push(mappedEntries[e.w]);
      }
    });
    var sourceSet = filter(mappedEntries, function(entry) {
      return !entry.indegree;
    });
    return doResolveConflicts(sourceSet);
  }
  function doResolveConflicts(sourceSet) {
    var entries2 = [];
    function handleIn(vEntry) {
      return function(uEntry) {
        if (uEntry.merged) {
          return;
        }
        if (isUndefined(uEntry.barycenter) || isUndefined(vEntry.barycenter) || uEntry.barycenter >= vEntry.barycenter) {
          mergeEntries(vEntry, uEntry);
        }
      };
    }
    function handleOut(vEntry) {
      return function(wEntry) {
        wEntry["in"].push(vEntry);
        if (--wEntry.indegree === 0) {
          sourceSet.push(wEntry);
        }
      };
    }
    while (sourceSet.length) {
      var entry = sourceSet.pop();
      entries2.push(entry);
      forEach(entry["in"].reverse(), handleIn(entry));
      forEach(entry.out, handleOut(entry));
    }
    return map(
      filter(entries2, function(entry2) {
        return !entry2.merged;
      }),
      function(entry2) {
        return pick$1(entry2, ["vs", "i", "barycenter", "weight"]);
      }
    );
  }
  function mergeEntries(target, source) {
    var sum = 0;
    var weight = 0;
    if (target.weight) {
      sum += target.barycenter * target.weight;
      weight += target.weight;
    }
    if (source.weight) {
      sum += source.barycenter * source.weight;
      weight += source.weight;
    }
    target.vs = source.vs.concat(target.vs);
    target.barycenter = sum / weight;
    target.weight = weight;
    target.i = Math.min(source.i, target.i);
    source.merged = true;
  }
  function sort(entries2, biasRight) {
    var parts = partition(entries2, function(entry) {
      return has(entry, "barycenter");
    });
    var sortable = parts.lhs, unsortable = sortBy$1(parts.rhs, function(entry) {
      return -entry.i;
    }), vs = [], sum = 0, weight = 0, vsIndex = 0;
    sortable.sort(compareWithBias(!!biasRight));
    vsIndex = consumeUnsortable(vs, unsortable, vsIndex);
    forEach(sortable, function(entry) {
      vsIndex += entry.vs.length;
      vs.push(entry.vs);
      sum += entry.barycenter * entry.weight;
      weight += entry.weight;
      vsIndex = consumeUnsortable(vs, unsortable, vsIndex);
    });
    var result = { vs: flatten(vs) };
    if (weight) {
      result.barycenter = sum / weight;
      result.weight = weight;
    }
    return result;
  }
  function consumeUnsortable(vs, unsortable, index2) {
    var last$1;
    while (unsortable.length && (last$1 = last(unsortable)).i <= index2) {
      unsortable.pop();
      vs.push(last$1.vs);
      index2++;
    }
    return index2;
  }
  function compareWithBias(bias) {
    return function(entryV, entryW) {
      if (entryV.barycenter < entryW.barycenter) {
        return -1;
      } else if (entryV.barycenter > entryW.barycenter) {
        return 1;
      }
      return !bias ? entryV.i - entryW.i : entryW.i - entryV.i;
    };
  }
  function sortSubgraph(g, v, cg, biasRight) {
    var movable = g.children(v);
    var node2 = g.node(v);
    var bl = node2 ? node2.borderLeft : void 0;
    var br = node2 ? node2.borderRight : void 0;
    var subgraphs = {};
    if (bl) {
      movable = filter(movable, function(w2) {
        return w2 !== bl && w2 !== br;
      });
    }
    var barycenters = barycenter(g, movable);
    forEach(barycenters, function(entry) {
      if (g.children(entry.v).length) {
        var subgraphResult = sortSubgraph(g, entry.v, cg, biasRight);
        subgraphs[entry.v] = subgraphResult;
        if (has(subgraphResult, "barycenter")) {
          mergeBarycenters(entry, subgraphResult);
        }
      }
    });
    var entries2 = resolveConflicts(barycenters, cg);
    expandSubgraphs(entries2, subgraphs);
    var result = sort(entries2, biasRight);
    if (bl) {
      result.vs = flatten([bl, result.vs, br]);
      if (g.predecessors(bl).length) {
        var blPred = g.node(g.predecessors(bl)[0]), brPred = g.node(g.predecessors(br)[0]);
        if (!has(result, "barycenter")) {
          result.barycenter = 0;
          result.weight = 0;
        }
        result.barycenter = (result.barycenter * result.weight + blPred.order + brPred.order) / (result.weight + 2);
        result.weight += 2;
      }
    }
    return result;
  }
  function expandSubgraphs(entries2, subgraphs) {
    forEach(entries2, function(entry) {
      entry.vs = flatten(
        entry.vs.map(function(v) {
          if (subgraphs[v]) {
            return subgraphs[v].vs;
          }
          return v;
        })
      );
    });
  }
  function mergeBarycenters(target, other) {
    if (!isUndefined(target.barycenter)) {
      target.barycenter = (target.barycenter * target.weight + other.barycenter * other.weight) / (target.weight + other.weight);
      target.weight += other.weight;
    } else {
      target.barycenter = other.barycenter;
      target.weight = other.weight;
    }
  }
  function order(g) {
    var maxRank$1 = maxRank(g), downLayerGraphs = buildLayerGraphs(g, range$1(1, maxRank$1 + 1), "inEdges"), upLayerGraphs = buildLayerGraphs(g, range$1(maxRank$1 - 1, -1, -1), "outEdges");
    var layering = initOrder(g);
    assignOrder(g, layering);
    var bestCC = Number.POSITIVE_INFINITY, best;
    for (var i2 = 0, lastBest = 0; lastBest < 4; ++i2, ++lastBest) {
      sweepLayerGraphs(i2 % 2 ? downLayerGraphs : upLayerGraphs, i2 % 4 >= 2);
      layering = buildLayerMatrix(g);
      var cc = crossCount(g, layering);
      if (cc < bestCC) {
        lastBest = 0;
        best = cloneDeep(layering);
        bestCC = cc;
      }
    }
    assignOrder(g, best);
  }
  function buildLayerGraphs(g, ranks, relationship) {
    return map(ranks, function(rank2) {
      return buildLayerGraph(g, rank2, relationship);
    });
  }
  function sweepLayerGraphs(layerGraphs, biasRight) {
    var cg = new Graph();
    forEach(layerGraphs, function(lg) {
      var root2 = lg.graph().root;
      var sorted = sortSubgraph(lg, root2, cg, biasRight);
      forEach(sorted.vs, function(v, i2) {
        lg.node(v).order = i2;
      });
      addSubgraphConstraints(lg, cg, sorted.vs);
    });
  }
  function assignOrder(g, layering) {
    forEach(layering, function(layer) {
      forEach(layer, function(v, i2) {
        g.node(v).order = i2;
      });
    });
  }
  function parentDummyChains(g) {
    var postorderNums = postorder(g);
    forEach(g.graph().dummyChains, function(v) {
      var node2 = g.node(v);
      var edgeObj = node2.edgeObj;
      var pathData = findPath(g, postorderNums, edgeObj.v, edgeObj.w);
      var path2 = pathData.path;
      var lca = pathData.lca;
      var pathIdx = 0;
      var pathV = path2[pathIdx];
      var ascending2 = true;
      while (v !== edgeObj.w) {
        node2 = g.node(v);
        if (ascending2) {
          while ((pathV = path2[pathIdx]) !== lca && g.node(pathV).maxRank < node2.rank) {
            pathIdx++;
          }
          if (pathV === lca) {
            ascending2 = false;
          }
        }
        if (!ascending2) {
          while (pathIdx < path2.length - 1 && g.node(pathV = path2[pathIdx + 1]).minRank <= node2.rank) {
            pathIdx++;
          }
          pathV = path2[pathIdx];
        }
        g.setParent(v, pathV);
        v = g.successors(v)[0];
      }
    });
  }
  function findPath(g, postorderNums, v, w2) {
    var vPath = [];
    var wPath = [];
    var low = Math.min(postorderNums[v].low, postorderNums[w2].low);
    var lim = Math.max(postorderNums[v].lim, postorderNums[w2].lim);
    var parent;
    var lca;
    parent = v;
    do {
      parent = g.parent(parent);
      vPath.push(parent);
    } while (parent && (postorderNums[parent].low > low || lim > postorderNums[parent].lim));
    lca = parent;
    parent = w2;
    while ((parent = g.parent(parent)) !== lca) {
      wPath.push(parent);
    }
    return { path: vPath.concat(wPath.reverse()), lca };
  }
  function postorder(g) {
    var result = {};
    var lim = 0;
    function dfs2(v) {
      var low = lim;
      forEach(g.children(v), dfs2);
      result[v] = { low, lim: lim++ };
    }
    forEach(g.children(), dfs2);
    return result;
  }
  function findType1Conflicts(g, layering) {
    var conflicts = {};
    function visitLayer(prevLayer, layer) {
      var k0 = 0, scanPos = 0, prevLayerLength = prevLayer.length, lastNode = last(layer);
      forEach(layer, function(v, i2) {
        var w2 = findOtherInnerSegmentNode(g, v), k1 = w2 ? g.node(w2).order : prevLayerLength;
        if (w2 || v === lastNode) {
          forEach(layer.slice(scanPos, i2 + 1), function(scanNode) {
            forEach(g.predecessors(scanNode), function(u) {
              var uLabel = g.node(u), uPos = uLabel.order;
              if ((uPos < k0 || k1 < uPos) && !(uLabel.dummy && g.node(scanNode).dummy)) {
                addConflict(conflicts, u, scanNode);
              }
            });
          });
          scanPos = i2 + 1;
          k0 = k1;
        }
      });
      return layer;
    }
    reduce(layering, visitLayer);
    return conflicts;
  }
  function findType2Conflicts(g, layering) {
    var conflicts = {};
    function scan(south, southPos, southEnd, prevNorthBorder, nextNorthBorder) {
      var v;
      forEach(range$1(southPos, southEnd), function(i2) {
        v = south[i2];
        if (g.node(v).dummy) {
          forEach(g.predecessors(v), function(u) {
            var uNode = g.node(u);
            if (uNode.dummy && (uNode.order < prevNorthBorder || uNode.order > nextNorthBorder)) {
              addConflict(conflicts, u, v);
            }
          });
        }
      });
    }
    function visitLayer(north, south) {
      var prevNorthPos = -1, nextNorthPos, southPos = 0;
      forEach(south, function(v, southLookahead) {
        if (g.node(v).dummy === "border") {
          var predecessors = g.predecessors(v);
          if (predecessors.length) {
            nextNorthPos = g.node(predecessors[0]).order;
            scan(south, southPos, southLookahead, prevNorthPos, nextNorthPos);
            southPos = southLookahead;
            prevNorthPos = nextNorthPos;
          }
        }
        scan(south, southPos, south.length, nextNorthPos, north.length);
      });
      return south;
    }
    reduce(layering, visitLayer);
    return conflicts;
  }
  function findOtherInnerSegmentNode(g, v) {
    if (g.node(v).dummy) {
      return find$1(g.predecessors(v), function(u) {
        return g.node(u).dummy;
      });
    }
  }
  function addConflict(conflicts, v, w2) {
    if (v > w2) {
      var tmp = v;
      v = w2;
      w2 = tmp;
    }
    var conflictsV = conflicts[v];
    if (!conflictsV) {
      conflicts[v] = conflictsV = {};
    }
    conflictsV[w2] = true;
  }
  function hasConflict(conflicts, v, w2) {
    if (v > w2) {
      var tmp = v;
      v = w2;
      w2 = tmp;
    }
    return has(conflicts[v], w2);
  }
  function verticalAlignment(g, layering, conflicts, neighborFn) {
    var root2 = {}, align = {}, pos = {};
    forEach(layering, function(layer) {
      forEach(layer, function(v, order2) {
        root2[v] = v;
        align[v] = v;
        pos[v] = order2;
      });
    });
    forEach(layering, function(layer) {
      var prevIdx = -1;
      forEach(layer, function(v) {
        var ws = neighborFn(v);
        if (ws.length) {
          ws = sortBy$1(ws, function(w3) {
            return pos[w3];
          });
          var mp = (ws.length - 1) / 2;
          for (var i2 = Math.floor(mp), il = Math.ceil(mp); i2 <= il; ++i2) {
            var w2 = ws[i2];
            if (align[v] === v && prevIdx < pos[w2] && !hasConflict(conflicts, v, w2)) {
              align[w2] = v;
              align[v] = root2[v] = root2[w2];
              prevIdx = pos[w2];
            }
          }
        }
      });
    });
    return { root: root2, align };
  }
  function horizontalCompaction(g, layering, root2, align, reverseSep) {
    var xs = {}, blockG = buildBlockGraph(g, layering, root2, reverseSep), borderType = reverseSep ? "borderLeft" : "borderRight";
    function iterate(setXsFunc, nextNodesFunc) {
      var stack = blockG.nodes();
      var elem = stack.pop();
      var visited = {};
      while (elem) {
        if (visited[elem]) {
          setXsFunc(elem);
        } else {
          visited[elem] = true;
          stack.push(elem);
          stack = stack.concat(nextNodesFunc(elem));
        }
        elem = stack.pop();
      }
    }
    function pass1(elem) {
      xs[elem] = blockG.inEdges(elem).reduce(function(acc, e) {
        return Math.max(acc, xs[e.v] + blockG.edge(e));
      }, 0);
    }
    function pass2(elem) {
      var min2 = blockG.outEdges(elem).reduce(function(acc, e) {
        return Math.min(acc, xs[e.w] - blockG.edge(e));
      }, Number.POSITIVE_INFINITY);
      var node2 = g.node(elem);
      if (min2 !== Number.POSITIVE_INFINITY && node2.borderType !== borderType) {
        xs[elem] = Math.max(xs[elem], min2);
      }
    }
    iterate(pass1, blockG.predecessors.bind(blockG));
    iterate(pass2, blockG.successors.bind(blockG));
    forEach(align, function(v) {
      xs[v] = xs[root2[v]];
    });
    return xs;
  }
  function buildBlockGraph(g, layering, root2, reverseSep) {
    var blockGraph = new Graph(), graphLabel = g.graph(), sepFn = sep(graphLabel.nodesep, graphLabel.edgesep, reverseSep);
    forEach(layering, function(layer) {
      var u;
      forEach(layer, function(v) {
        var vRoot = root2[v];
        blockGraph.setNode(vRoot);
        if (u) {
          var uRoot = root2[u], prevMax = blockGraph.edge(uRoot, vRoot);
          blockGraph.setEdge(uRoot, vRoot, Math.max(sepFn(g, v, u), prevMax || 0));
        }
        u = v;
      });
    });
    return blockGraph;
  }
  function findSmallestWidthAlignment(g, xss) {
    return minBy(values(xss), function(xs) {
      var max2 = Number.NEGATIVE_INFINITY;
      var min2 = Number.POSITIVE_INFINITY;
      forIn(xs, function(x2, v) {
        var halfWidth = width$1(g, v) / 2;
        max2 = Math.max(x2 + halfWidth, max2);
        min2 = Math.min(x2 - halfWidth, min2);
      });
      return max2 - min2;
    });
  }
  function alignCoordinates(xss, alignTo) {
    var alignToVals = values(alignTo), alignToMin = min(alignToVals), alignToMax = max(alignToVals);
    forEach(["u", "d"], function(vert) {
      forEach(["l", "r"], function(horiz) {
        var alignment = vert + horiz, xs = xss[alignment], delta;
        if (xs === alignTo)
          return;
        var xsVals = values(xs);
        delta = horiz === "l" ? alignToMin - min(xsVals) : alignToMax - max(xsVals);
        if (delta) {
          xss[alignment] = mapValues(xs, function(x2) {
            return x2 + delta;
          });
        }
      });
    });
  }
  function balance(xss, align) {
    return mapValues(xss.ul, function(ignore, v) {
      if (align) {
        return xss[align.toLowerCase()][v];
      } else {
        var xs = sortBy$1(map(xss, v));
        return (xs[1] + xs[2]) / 2;
      }
    });
  }
  function positionX(g) {
    var layering = buildLayerMatrix(g);
    var conflicts = merge$2(findType1Conflicts(g, layering), findType2Conflicts(g, layering));
    var xss = {};
    var adjustedLayering;
    forEach(["u", "d"], function(vert) {
      adjustedLayering = vert === "u" ? layering : values(layering).reverse();
      forEach(["l", "r"], function(horiz) {
        if (horiz === "r") {
          adjustedLayering = map(adjustedLayering, function(inner) {
            return values(inner).reverse();
          });
        }
        var neighborFn = (vert === "u" ? g.predecessors : g.successors).bind(g);
        var align = verticalAlignment(g, adjustedLayering, conflicts, neighborFn);
        var xs = horizontalCompaction(g, adjustedLayering, align.root, align.align, horiz === "r");
        if (horiz === "r") {
          xs = mapValues(xs, function(x2) {
            return -x2;
          });
        }
        xss[vert + horiz] = xs;
      });
    });
    var smallestWidth = findSmallestWidthAlignment(g, xss);
    alignCoordinates(xss, smallestWidth);
    return balance(xss, g.graph().align);
  }
  function sep(nodeSep, edgeSep, reverseSep) {
    return function(g, v, w2) {
      var vLabel = g.node(v);
      var wLabel = g.node(w2);
      var sum = 0;
      var delta;
      sum += vLabel.width / 2;
      if (has(vLabel, "labelpos")) {
        switch (vLabel.labelpos.toLowerCase()) {
          case "l":
            delta = -vLabel.width / 2;
            break;
          case "r":
            delta = vLabel.width / 2;
            break;
        }
      }
      if (delta) {
        sum += reverseSep ? delta : -delta;
      }
      delta = 0;
      sum += (vLabel.dummy ? edgeSep : nodeSep) / 2;
      sum += (wLabel.dummy ? edgeSep : nodeSep) / 2;
      sum += wLabel.width / 2;
      if (has(wLabel, "labelpos")) {
        switch (wLabel.labelpos.toLowerCase()) {
          case "l":
            delta = wLabel.width / 2;
            break;
          case "r":
            delta = -wLabel.width / 2;
            break;
        }
      }
      if (delta) {
        sum += reverseSep ? delta : -delta;
      }
      delta = 0;
      return sum;
    };
  }
  function width$1(g, v) {
    return g.node(v).width;
  }
  function position$1(g) {
    g = asNonCompoundGraph(g);
    positionY(g);
    forOwn(positionX(g), function(x2, v) {
      g.node(v).x = x2;
    });
  }
  function positionY(g) {
    var layering = buildLayerMatrix(g);
    var rankSep = g.graph().ranksep;
    var prevY = 0;
    forEach(layering, function(layer) {
      var maxHeight = max(
        map(layer, function(v) {
          return g.node(v).height;
        })
      );
      forEach(layer, function(v) {
        g.node(v).y = prevY + maxHeight / 2;
      });
      prevY += maxHeight + rankSep;
    });
  }
  function layout(g, opts) {
    var time$12 = opts && opts.debugTiming ? time : notime;
    time$12("layout", function() {
      var layoutGraph = time$12("  buildLayoutGraph", function() {
        return buildLayoutGraph(g);
      });
      time$12("  runLayout", function() {
        runLayout(layoutGraph, time$12);
      });
      time$12("  updateInputGraph", function() {
        updateInputGraph(g, layoutGraph);
      });
    });
  }
  function runLayout(g, time2) {
    time2("    makeSpaceForEdgeLabels", function() {
      makeSpaceForEdgeLabels(g);
    });
    time2("    removeSelfEdges", function() {
      removeSelfEdges(g);
    });
    time2("    acyclic", function() {
      run$2(g);
    });
    time2("    nestingGraph.run", function() {
      run(g);
    });
    time2("    rank", function() {
      rank(asNonCompoundGraph(g));
    });
    time2("    injectEdgeLabelProxies", function() {
      injectEdgeLabelProxies(g);
    });
    time2("    removeEmptyRanks", function() {
      removeEmptyRanks(g);
    });
    time2("    nestingGraph.cleanup", function() {
      cleanup(g);
    });
    time2("    normalizeRanks", function() {
      normalizeRanks(g);
    });
    time2("    assignRankMinMax", function() {
      assignRankMinMax(g);
    });
    time2("    removeEdgeLabelProxies", function() {
      removeEdgeLabelProxies(g);
    });
    time2("    normalize.run", function() {
      run$1(g);
    });
    time2("    parentDummyChains", function() {
      parentDummyChains(g);
    });
    time2("    addBorderSegments", function() {
      addBorderSegments(g);
    });
    time2("    order", function() {
      order(g);
    });
    time2("    insertSelfEdges", function() {
      insertSelfEdges(g);
    });
    time2("    adjustCoordinateSystem", function() {
      adjust(g);
    });
    time2("    position", function() {
      position$1(g);
    });
    time2("    positionSelfEdges", function() {
      positionSelfEdges(g);
    });
    time2("    removeBorderNodes", function() {
      removeBorderNodes(g);
    });
    time2("    normalize.undo", function() {
      undo(g);
    });
    time2("    fixupEdgeLabelCoords", function() {
      fixupEdgeLabelCoords(g);
    });
    time2("    undoCoordinateSystem", function() {
      undo$1(g);
    });
    time2("    translateGraph", function() {
      translateGraph(g);
    });
    time2("    assignNodeIntersects", function() {
      assignNodeIntersects(g);
    });
    time2("    reversePoints", function() {
      reversePointsForReversedEdges(g);
    });
    time2("    acyclic.undo", function() {
      undo$2(g);
    });
  }
  function updateInputGraph(inputGraph, layoutGraph) {
    forEach(inputGraph.nodes(), function(v) {
      var inputLabel = inputGraph.node(v);
      var layoutLabel = layoutGraph.node(v);
      if (inputLabel) {
        inputLabel.x = layoutLabel.x;
        inputLabel.y = layoutLabel.y;
        if (layoutGraph.children(v).length) {
          inputLabel.width = layoutLabel.width;
          inputLabel.height = layoutLabel.height;
        }
      }
    });
    forEach(inputGraph.edges(), function(e) {
      var inputLabel = inputGraph.edge(e);
      var layoutLabel = layoutGraph.edge(e);
      inputLabel.points = layoutLabel.points;
      if (has(layoutLabel, "x")) {
        inputLabel.x = layoutLabel.x;
        inputLabel.y = layoutLabel.y;
      }
    });
    inputGraph.graph().width = layoutGraph.graph().width;
    inputGraph.graph().height = layoutGraph.graph().height;
  }
  var graphNumAttrs = ["nodesep", "edgesep", "ranksep", "marginx", "marginy"];
  var graphDefaults = { ranksep: 50, edgesep: 20, nodesep: 50, rankdir: "tb" };
  var graphAttrs = ["acyclicer", "ranker", "rankdir", "align"];
  var nodeNumAttrs = ["width", "height"];
  var nodeDefaults = { width: 0, height: 0 };
  var edgeNumAttrs = ["minlen", "weight", "width", "height", "labeloffset"];
  var edgeDefaults = {
    minlen: 1,
    weight: 1,
    width: 0,
    height: 0,
    labeloffset: 10,
    labelpos: "r"
  };
  var edgeAttrs = ["labelpos"];
  function buildLayoutGraph(inputGraph) {
    var g = new Graph({ multigraph: true, compound: true });
    var graph = canonicalize(inputGraph.graph());
    g.setGraph(
      merge$2({}, graphDefaults, selectNumberAttrs(graph, graphNumAttrs), pick$1(graph, graphAttrs))
    );
    forEach(inputGraph.nodes(), function(v) {
      var node2 = canonicalize(inputGraph.node(v));
      g.setNode(v, defaults$1(selectNumberAttrs(node2, nodeNumAttrs), nodeDefaults));
      g.setParent(v, inputGraph.parent(v));
    });
    forEach(inputGraph.edges(), function(e) {
      var edge = canonicalize(inputGraph.edge(e));
      g.setEdge(
        e,
        merge$2({}, edgeDefaults, selectNumberAttrs(edge, edgeNumAttrs), pick$1(edge, edgeAttrs))
      );
    });
    return g;
  }
  function makeSpaceForEdgeLabels(g) {
    var graph = g.graph();
    graph.ranksep /= 2;
    forEach(g.edges(), function(e) {
      var edge = g.edge(e);
      edge.minlen *= 2;
      if (edge.labelpos.toLowerCase() !== "c") {
        if (graph.rankdir === "TB" || graph.rankdir === "BT") {
          edge.width += edge.labeloffset;
        } else {
          edge.height += edge.labeloffset;
        }
      }
    });
  }
  function injectEdgeLabelProxies(g) {
    forEach(g.edges(), function(e) {
      var edge = g.edge(e);
      if (edge.width && edge.height) {
        var v = g.node(e.v);
        var w2 = g.node(e.w);
        var label = { rank: (w2.rank - v.rank) / 2 + v.rank, e };
        addDummyNode(g, "edge-proxy", label, "_ep");
      }
    });
  }
  function assignRankMinMax(g) {
    var maxRank2 = 0;
    forEach(g.nodes(), function(v) {
      var node2 = g.node(v);
      if (node2.borderTop) {
        node2.minRank = g.node(node2.borderTop).rank;
        node2.maxRank = g.node(node2.borderBottom).rank;
        maxRank2 = max(maxRank2, node2.maxRank);
      }
    });
    g.graph().maxRank = maxRank2;
  }
  function removeEdgeLabelProxies(g) {
    forEach(g.nodes(), function(v) {
      var node2 = g.node(v);
      if (node2.dummy === "edge-proxy") {
        g.edge(node2.e).labelRank = node2.rank;
        g.removeNode(v);
      }
    });
  }
  function translateGraph(g) {
    var minX = Number.POSITIVE_INFINITY;
    var maxX = 0;
    var minY = Number.POSITIVE_INFINITY;
    var maxY = 0;
    var graphLabel = g.graph();
    var marginX = graphLabel.marginx || 0;
    var marginY = graphLabel.marginy || 0;
    function getExtremes(attrs) {
      var x2 = attrs.x;
      var y2 = attrs.y;
      var w2 = attrs.width;
      var h = attrs.height;
      minX = Math.min(minX, x2 - w2 / 2);
      maxX = Math.max(maxX, x2 + w2 / 2);
      minY = Math.min(minY, y2 - h / 2);
      maxY = Math.max(maxY, y2 + h / 2);
    }
    forEach(g.nodes(), function(v) {
      getExtremes(g.node(v));
    });
    forEach(g.edges(), function(e) {
      var edge = g.edge(e);
      if (has(edge, "x")) {
        getExtremes(edge);
      }
    });
    minX -= marginX;
    minY -= marginY;
    forEach(g.nodes(), function(v) {
      var node2 = g.node(v);
      node2.x -= minX;
      node2.y -= minY;
    });
    forEach(g.edges(), function(e) {
      var edge = g.edge(e);
      forEach(edge.points, function(p) {
        p.x -= minX;
        p.y -= minY;
      });
      if (has(edge, "x")) {
        edge.x -= minX;
      }
      if (has(edge, "y")) {
        edge.y -= minY;
      }
    });
    graphLabel.width = maxX - minX + marginX;
    graphLabel.height = maxY - minY + marginY;
  }
  function assignNodeIntersects(g) {
    forEach(g.edges(), function(e) {
      var edge = g.edge(e);
      var nodeV = g.node(e.v);
      var nodeW = g.node(e.w);
      var p1, p2;
      if (!edge.points) {
        edge.points = [];
        p1 = nodeW;
        p2 = nodeV;
      } else {
        p1 = edge.points[0];
        p2 = edge.points[edge.points.length - 1];
      }
      edge.points.unshift(intersectRect$3(nodeV, p1));
      edge.points.push(intersectRect$3(nodeW, p2));
    });
  }
  function fixupEdgeLabelCoords(g) {
    forEach(g.edges(), function(e) {
      var edge = g.edge(e);
      if (has(edge, "x")) {
        if (edge.labelpos === "l" || edge.labelpos === "r") {
          edge.width -= edge.labeloffset;
        }
        switch (edge.labelpos) {
          case "l":
            edge.x -= edge.width / 2 + edge.labeloffset;
            break;
          case "r":
            edge.x += edge.width / 2 + edge.labeloffset;
            break;
        }
      }
    });
  }
  function reversePointsForReversedEdges(g) {
    forEach(g.edges(), function(e) {
      var edge = g.edge(e);
      if (edge.reversed) {
        edge.points.reverse();
      }
    });
  }
  function removeBorderNodes(g) {
    forEach(g.nodes(), function(v) {
      if (g.children(v).length) {
        var node2 = g.node(v);
        var t = g.node(node2.borderTop);
        var b = g.node(node2.borderBottom);
        var l = g.node(last(node2.borderLeft));
        var r = g.node(last(node2.borderRight));
        node2.width = Math.abs(r.x - l.x);
        node2.height = Math.abs(b.y - t.y);
        node2.x = l.x + node2.width / 2;
        node2.y = t.y + node2.height / 2;
      }
    });
    forEach(g.nodes(), function(v) {
      if (g.node(v).dummy === "border") {
        g.removeNode(v);
      }
    });
  }
  function removeSelfEdges(g) {
    forEach(g.edges(), function(e) {
      if (e.v === e.w) {
        var node2 = g.node(e.v);
        if (!node2.selfEdges) {
          node2.selfEdges = [];
        }
        node2.selfEdges.push({ e, label: g.edge(e) });
        g.removeEdge(e);
      }
    });
  }
  function insertSelfEdges(g) {
    var layers = buildLayerMatrix(g);
    forEach(layers, function(layer) {
      var orderShift = 0;
      forEach(layer, function(v, i2) {
        var node2 = g.node(v);
        node2.order = i2 + orderShift;
        forEach(node2.selfEdges, function(selfEdge) {
          addDummyNode(
            g,
            "selfedge",
            {
              width: selfEdge.label.width,
              height: selfEdge.label.height,
              rank: node2.rank,
              order: i2 + ++orderShift,
              e: selfEdge.e,
              label: selfEdge.label
            },
            "_se"
          );
        });
        delete node2.selfEdges;
      });
    });
  }
  function positionSelfEdges(g) {
    forEach(g.nodes(), function(v) {
      var node2 = g.node(v);
      if (node2.dummy === "selfedge") {
        var selfNode = g.node(node2.e.v);
        var x2 = selfNode.x + selfNode.width / 2;
        var y2 = selfNode.y;
        var dx = node2.x - x2;
        var dy = selfNode.height / 2;
        g.setEdge(node2.e, node2.label);
        g.removeNode(v);
        node2.label.points = [
          { x: x2 + 2 * dx / 3, y: y2 - dy },
          { x: x2 + 5 * dx / 6, y: y2 - dy },
          { x: x2 + dx, y: y2 },
          { x: x2 + 5 * dx / 6, y: y2 + dy },
          { x: x2 + 2 * dx / 3, y: y2 + dy }
        ];
        node2.label.x = node2.x;
        node2.label.y = node2.y;
      }
    });
  }
  function selectNumberAttrs(obj, attrs) {
    return mapValues(pick$1(obj, attrs), Number);
  }
  function canonicalize(attrs) {
    var newAttrs = {};
    forEach(attrs, function(v, k) {
      newAttrs[k.toLowerCase()] = v;
    });
    return newAttrs;
  }
  function isSubgraph(g, v) {
    return !!g.children(v).length;
  }
  function edgeToId(e) {
    return escapeId(e.v) + ":" + escapeId(e.w) + ":" + escapeId(e.name);
  }
  var ID_DELIM = /:/g;
  function escapeId(str2) {
    return str2 ? String(str2).replace(ID_DELIM, "\\:") : "";
  }
  function applyStyle$2(dom, styleFn) {
    if (styleFn) {
      dom.attr("style", styleFn);
    }
  }
  function applyClass(dom, classFn, otherClasses) {
    if (classFn) {
      dom.attr("class", classFn).attr("class", otherClasses + " " + dom.attr("class"));
    }
  }
  function applyTransition(selection2, g) {
    var graph = g.graph();
    if (isPlainObject(graph)) {
      var transition = graph.transition;
      if (isFunction(transition)) {
        return transition(selection2);
      }
    }
    return selection2;
  }
  var arrows = {
    normal,
    vee,
    undirected
  };
  function setArrows(value) {
    arrows = value;
  }
  function normal(parent, id2, edge, type2) {
    var marker = parent.append("marker").attr("id", id2).attr("viewBox", "0 0 10 10").attr("refX", 9).attr("refY", 5).attr("markerUnits", "strokeWidth").attr("markerWidth", 8).attr("markerHeight", 6).attr("orient", "auto");
    var path2 = marker.append("path").attr("d", "M 0 0 L 10 5 L 0 10 z").style("stroke-width", 1).style("stroke-dasharray", "1,0");
    applyStyle$2(path2, edge[type2 + "Style"]);
    if (edge[type2 + "Class"]) {
      path2.attr("class", edge[type2 + "Class"]);
    }
  }
  function vee(parent, id2, edge, type2) {
    var marker = parent.append("marker").attr("id", id2).attr("viewBox", "0 0 10 10").attr("refX", 9).attr("refY", 5).attr("markerUnits", "strokeWidth").attr("markerWidth", 8).attr("markerHeight", 6).attr("orient", "auto");
    var path2 = marker.append("path").attr("d", "M 0 0 L 10 5 L 0 10 L 4 5 z").style("stroke-width", 1).style("stroke-dasharray", "1,0");
    applyStyle$2(path2, edge[type2 + "Style"]);
    if (edge[type2 + "Class"]) {
      path2.attr("class", edge[type2 + "Class"]);
    }
  }
  function undirected(parent, id2, edge, type2) {
    var marker = parent.append("marker").attr("id", id2).attr("viewBox", "0 0 10 10").attr("refX", 9).attr("refY", 5).attr("markerUnits", "strokeWidth").attr("markerWidth", 8).attr("markerHeight", 6).attr("orient", "auto");
    var path2 = marker.append("path").attr("d", "M 0 5 L 10 5").style("stroke-width", 1).style("stroke-dasharray", "1,0");
    applyStyle$2(path2, edge[type2 + "Style"]);
    if (edge[type2 + "Class"]) {
      path2.attr("class", edge[type2 + "Class"]);
    }
  }
  function addHtmlLabel$1(root2, node2) {
    var fo = root2.append("foreignObject").attr("width", "100000");
    var div = fo.append("xhtml:div");
    div.attr("xmlns", "http://www.w3.org/1999/xhtml");
    var label = node2.label;
    switch (typeof label) {
      case "function":
        div.insert(label);
        break;
      case "object":
        div.insert(function() {
          return label;
        });
        break;
      default:
        div.html(label);
    }
    applyStyle$2(div, node2.labelStyle);
    div.style("display", "inline-block");
    div.style("white-space", "nowrap");
    var client = div.node().getBoundingClientRect();
    fo.attr("width", client.width).attr("height", client.height);
    return fo;
  }
  function addSVGLabel(root2, node2) {
    var domNode = root2;
    domNode.node().appendChild(node2.label);
    applyStyle$2(domNode, node2.labelStyle);
    return domNode;
  }
  function addTextLabel(root2, node2) {
    var domNode = root2.append("text");
    var lines = processEscapeSequences(node2.label).split("\n");
    for (var i2 = 0; i2 < lines.length; i2++) {
      domNode.append("tspan").attr("xml:space", "preserve").attr("dy", "1em").attr("x", "1").text(lines[i2]);
    }
    applyStyle$2(domNode, node2.labelStyle);
    return domNode;
  }
  function processEscapeSequences(text2) {
    var newText = "";
    var escaped = false;
    var ch;
    for (var i2 = 0; i2 < text2.length; ++i2) {
      ch = text2[i2];
      if (escaped) {
        switch (ch) {
          case "n":
            newText += "\n";
            break;
          default:
            newText += ch;
        }
        escaped = false;
      } else if (ch === "\\") {
        escaped = true;
      } else {
        newText += ch;
      }
    }
    return newText;
  }
  function addLabel(root2, node2, location2) {
    var label = node2.label;
    var labelSvg = root2.append("g");
    if (node2.labelType === "svg") {
      addSVGLabel(labelSvg, node2);
    } else if (typeof label !== "string" || node2.labelType === "html") {
      addHtmlLabel$1(labelSvg, node2);
    } else {
      addTextLabel(labelSvg, node2);
    }
    var labelBBox = labelSvg.node().getBBox();
    var y2;
    switch (location2) {
      case "top":
        y2 = -node2.height / 2;
        break;
      case "bottom":
        y2 = node2.height / 2 - labelBBox.height;
        break;
      default:
        y2 = -labelBBox.height / 2;
    }
    labelSvg.attr("transform", "translate(" + -labelBBox.width / 2 + "," + y2 + ")");
    return labelSvg;
  }
  var createClusters = function(selection2, g) {
    var clusters = g.nodes().filter(function(v) {
      return isSubgraph(g, v);
    });
    var svgClusters = selection2.selectAll("g.cluster").data(clusters, function(v) {
      return v;
    });
    applyTransition(svgClusters.exit(), g).style("opacity", 0).remove();
    var enterSelection = svgClusters.enter().append("g").attr("class", "cluster").attr("id", function(v) {
      var node2 = g.node(v);
      return node2.id;
    }).style("opacity", 0).each(function(v) {
      var node2 = g.node(v);
      var thisGroup = select(this);
      select(this).append("rect");
      var labelGroup = thisGroup.append("g").attr("class", "label");
      addLabel(labelGroup, node2, node2.clusterLabelPos);
    });
    svgClusters = svgClusters.merge(enterSelection);
    svgClusters = applyTransition(svgClusters, g).style("opacity", 1);
    svgClusters.selectAll("rect").each(function(c2) {
      var node2 = g.node(c2);
      var domCluster = select(this);
      applyStyle$2(domCluster, node2.style);
    });
    return svgClusters;
  };
  function setCreateClusters(value) {
    createClusters = value;
  }
  let createEdgeLabels = function(selection2, g) {
    var svgEdgeLabels = selection2.selectAll("g.edgeLabel").data(g.edges(), function(e) {
      return edgeToId(e);
    }).classed("update", true);
    svgEdgeLabels.exit().remove();
    svgEdgeLabels.enter().append("g").classed("edgeLabel", true).style("opacity", 0);
    svgEdgeLabels = selection2.selectAll("g.edgeLabel");
    svgEdgeLabels.each(function(e) {
      var root2 = select(this);
      root2.select(".label").remove();
      var edge = g.edge(e);
      var label = addLabel(root2, g.edge(e), 0).classed("label", true);
      var bbox = label.node().getBBox();
      if (edge.labelId) {
        label.attr("id", edge.labelId);
      }
      if (!has(edge, "width")) {
        edge.width = bbox.width;
      }
      if (!has(edge, "height")) {
        edge.height = bbox.height;
      }
    });
    var exitSelection;
    if (svgEdgeLabels.exit) {
      exitSelection = svgEdgeLabels.exit();
    } else {
      exitSelection = svgEdgeLabels.selectAll(null);
    }
    applyTransition(exitSelection, g).style("opacity", 0).remove();
    return svgEdgeLabels;
  };
  function setCreateEdgeLabels(value) {
    createEdgeLabels = value;
  }
  function intersectNode$1(node2, point2) {
    return node2.intersect(point2);
  }
  var createEdgePaths = function(selection2, g, arrows2) {
    var previousPaths = selection2.selectAll("g.edgePath").data(g.edges(), function(e) {
      return edgeToId(e);
    }).classed("update", true);
    var newPaths = enter(previousPaths, g);
    exit$1(previousPaths, g);
    var svgPaths = previousPaths.merge !== void 0 ? previousPaths.merge(newPaths) : previousPaths;
    applyTransition(svgPaths, g).style("opacity", 1);
    svgPaths.each(function(e) {
      var domEdge = select(this);
      var edge = g.edge(e);
      edge.elem = this;
      if (edge.id) {
        domEdge.attr("id", edge.id);
      }
      applyClass(
        domEdge,
        edge["class"],
        (domEdge.classed("update") ? "update " : "") + "edgePath"
      );
    });
    svgPaths.selectAll("path.path").each(function(e) {
      var edge = g.edge(e);
      edge.arrowheadId = uniqueId("arrowhead");
      var domEdge = select(this).attr("marker-end", function() {
        return "url(" + makeFragmentRef(location.href, edge.arrowheadId) + ")";
      }).style("fill", "none");
      applyTransition(domEdge, g).attr("d", function(e3) {
        return calcPoints(g, e3);
      });
      applyStyle$2(domEdge, edge.style);
    });
    svgPaths.selectAll("defs *").remove();
    svgPaths.selectAll("defs").each(function(e) {
      var edge = g.edge(e);
      var arrowhead = arrows2[edge.arrowhead];
      arrowhead(select(this), edge.arrowheadId, edge, "arrowhead");
    });
    return svgPaths;
  };
  function setCreateEdgePaths(value) {
    createEdgePaths = value;
  }
  function makeFragmentRef(url, fragmentId) {
    var baseUrl = url.split("#")[0];
    return baseUrl + "#" + fragmentId;
  }
  function calcPoints(g, e) {
    var edge = g.edge(e);
    var tail = g.node(e.v);
    var head2 = g.node(e.w);
    var points = edge.points.slice(1, edge.points.length - 1);
    points.unshift(intersectNode$1(tail, points[0]));
    points.push(intersectNode$1(head2, points[points.length - 1]));
    return createLine(edge, points);
  }
  function createLine(edge, points) {
    var line2 = (line$1 || svg$2.line)().x(function(d) {
      return d.x;
    }).y(function(d) {
      return d.y;
    });
    (line2.curve || line2.interpolate)(edge.curve);
    return line2(points);
  }
  function getCoords(elem) {
    var bbox = elem.getBBox();
    var matrix = elem.ownerSVGElement.getScreenCTM().inverse().multiply(elem.getScreenCTM()).translate(bbox.width / 2, bbox.height / 2);
    return { x: matrix.e, y: matrix.f };
  }
  function enter(svgPaths, g) {
    var svgPathsEnter = svgPaths.enter().append("g").attr("class", "edgePath").style("opacity", 0);
    svgPathsEnter.append("path").attr("class", "path").attr("d", function(e) {
      var edge = g.edge(e);
      var sourceElem = g.node(e.v).elem;
      var points = range$1(edge.points.length).map(function() {
        return getCoords(sourceElem);
      });
      return createLine(edge, points);
    });
    svgPathsEnter.append("defs");
    return svgPathsEnter;
  }
  function exit$1(svgPaths, g) {
    var svgPathExit = svgPaths.exit();
    applyTransition(svgPathExit, g).style("opacity", 0).remove();
  }
  var createNodes = function(selection2, g, shapes2) {
    var simpleNodes = g.nodes().filter(function(v) {
      return !isSubgraph(g, v);
    });
    var svgNodes = selection2.selectAll("g.node").data(simpleNodes, function(v) {
      return v;
    }).classed("update", true);
    svgNodes.exit().remove();
    svgNodes.enter().append("g").attr("class", "node").style("opacity", 0);
    svgNodes = selection2.selectAll("g.node");
    svgNodes.each(function(v) {
      var node2 = g.node(v);
      var thisGroup = select(this);
      applyClass(
        thisGroup,
        node2["class"],
        (thisGroup.classed("update") ? "update " : "") + "node"
      );
      thisGroup.select("g.label").remove();
      var labelGroup = thisGroup.append("g").attr("class", "label");
      var labelDom = addLabel(labelGroup, node2);
      var shape = shapes2[node2.shape];
      var bbox = pick$1(labelDom.node().getBBox(), "width", "height");
      node2.elem = this;
      if (node2.id) {
        thisGroup.attr("id", node2.id);
      }
      if (node2.labelId) {
        labelGroup.attr("id", node2.labelId);
      }
      if (has(node2, "width")) {
        bbox.width = node2.width;
      }
      if (has(node2, "height")) {
        bbox.height = node2.height;
      }
      bbox.width += node2.paddingLeft + node2.paddingRight;
      bbox.height += node2.paddingTop + node2.paddingBottom;
      labelGroup.attr(
        "transform",
        "translate(" + (node2.paddingLeft - node2.paddingRight) / 2 + "," + (node2.paddingTop - node2.paddingBottom) / 2 + ")"
      );
      var root2 = select(this);
      root2.select(".label-container").remove();
      var shapeSvg = shape(root2, bbox, node2).classed("label-container", true);
      applyStyle$2(shapeSvg, node2.style);
      var shapeBBox = shapeSvg.node().getBBox();
      node2.width = shapeBBox.width;
      node2.height = shapeBBox.height;
    });
    var exitSelection;
    if (svgNodes.exit) {
      exitSelection = svgNodes.exit();
    } else {
      exitSelection = svgNodes.selectAll(null);
    }
    applyTransition(exitSelection, g).style("opacity", 0).remove();
    return svgNodes;
  };
  function setCreateNodes(value) {
    createNodes = value;
  }
  function positionClusters(selection2, g) {
    var created = selection2.filter(function() {
      return !select(this).classed("update");
    });
    function translate(v) {
      var node2 = g.node(v);
      return "translate(" + node2.x + "," + node2.y + ")";
    }
    created.attr("transform", translate);
    applyTransition(selection2, g).style("opacity", 1).attr("transform", translate);
    applyTransition(created.selectAll("rect"), g).attr("width", function(v) {
      return g.node(v).width;
    }).attr("height", function(v) {
      return g.node(v).height;
    }).attr("x", function(v) {
      var node2 = g.node(v);
      return -node2.width / 2;
    }).attr("y", function(v) {
      var node2 = g.node(v);
      return -node2.height / 2;
    });
  }
  function positionEdgeLabels(selection2, g) {
    var created = selection2.filter(function() {
      return !select(this).classed("update");
    });
    function translate(e) {
      var edge = g.edge(e);
      return has(edge, "x") ? "translate(" + edge.x + "," + edge.y + ")" : "";
    }
    created.attr("transform", translate);
    applyTransition(selection2, g).style("opacity", 1).attr("transform", translate);
  }
  function positionNodes$1(selection2, g) {
    var created = selection2.filter(function() {
      return !select(this).classed("update");
    });
    function translate(v) {
      var node2 = g.node(v);
      return "translate(" + node2.x + "," + node2.y + ")";
    }
    created.attr("transform", translate);
    applyTransition(selection2, g).style("opacity", 1).attr("transform", translate);
  }
  function intersectEllipse$1(node2, rx, ry, point2) {
    var cx = node2.x;
    var cy = node2.y;
    var px = cx - point2.x;
    var py = cy - point2.y;
    var det = Math.sqrt(rx * rx * py * py + ry * ry * px * px);
    var dx = Math.abs(rx * ry * px / det);
    if (point2.x < cx) {
      dx = -dx;
    }
    var dy = Math.abs(rx * ry * py / det);
    if (point2.y < cy) {
      dy = -dy;
    }
    return { x: cx + dx, y: cy + dy };
  }
  function intersectCircle$1(node2, rx, point2) {
    return intersectEllipse$1(node2, rx, rx, point2);
  }
  function intersectLine$1(p1, p2, q1, q2) {
    var a1, a2, b1, b2, c1, c2;
    var r1, r2, r3, r4;
    var denom, offset, num;
    var x2, y2;
    a1 = p2.y - p1.y;
    b1 = p1.x - p2.x;
    c1 = p2.x * p1.y - p1.x * p2.y;
    r3 = a1 * q1.x + b1 * q1.y + c1;
    r4 = a1 * q2.x + b1 * q2.y + c1;
    if (r3 !== 0 && r4 !== 0 && sameSign$1(r3, r4)) {
      return;
    }
    a2 = q2.y - q1.y;
    b2 = q1.x - q2.x;
    c2 = q2.x * q1.y - q1.x * q2.y;
    r1 = a2 * p1.x + b2 * p1.y + c2;
    r2 = a2 * p2.x + b2 * p2.y + c2;
    if (r1 !== 0 && r2 !== 0 && sameSign$1(r1, r2)) {
      return;
    }
    denom = a1 * b2 - a2 * b1;
    if (denom === 0) {
      return;
    }
    offset = Math.abs(denom / 2);
    num = b1 * c2 - b2 * c1;
    x2 = num < 0 ? (num - offset) / denom : (num + offset) / denom;
    num = a2 * c1 - a1 * c2;
    y2 = num < 0 ? (num - offset) / denom : (num + offset) / denom;
    return { x: x2, y: y2 };
  }
  function sameSign$1(r1, r2) {
    return r1 * r2 > 0;
  }
  function intersectPolygon$1(node2, polyPoints, point2) {
    var x1 = node2.x;
    var y1 = node2.y;
    var intersections = [];
    var minX = Number.POSITIVE_INFINITY;
    var minY = Number.POSITIVE_INFINITY;
    polyPoints.forEach(function(entry) {
      minX = Math.min(minX, entry.x);
      minY = Math.min(minY, entry.y);
    });
    var left2 = x1 - node2.width / 2 - minX;
    var top2 = y1 - node2.height / 2 - minY;
    for (var i2 = 0; i2 < polyPoints.length; i2++) {
      var p1 = polyPoints[i2];
      var p2 = polyPoints[i2 < polyPoints.length - 1 ? i2 + 1 : 0];
      var intersect2 = intersectLine$1(
        node2,
        point2,
        { x: left2 + p1.x, y: top2 + p1.y },
        { x: left2 + p2.x, y: top2 + p2.y }
      );
      if (intersect2) {
        intersections.push(intersect2);
      }
    }
    if (!intersections.length) {
      console.log("NO INTERSECTION FOUND, RETURN NODE CENTER", node2);
      return node2;
    }
    if (intersections.length > 1) {
      intersections.sort(function(p, q) {
        var pdx = p.x - point2.x;
        var pdy = p.y - point2.y;
        var distp = Math.sqrt(pdx * pdx + pdy * pdy);
        var qdx = q.x - point2.x;
        var qdy = q.y - point2.y;
        var distq = Math.sqrt(qdx * qdx + qdy * qdy);
        return distp < distq ? -1 : distp === distq ? 0 : 1;
      });
    }
    return intersections[0];
  }
  function intersectRect$2(node2, point2) {
    var x2 = node2.x;
    var y2 = node2.y;
    var dx = point2.x - x2;
    var dy = point2.y - y2;
    var w2 = node2.width / 2;
    var h = node2.height / 2;
    var sx, sy;
    if (Math.abs(dy) * w2 > Math.abs(dx) * h) {
      if (dy < 0) {
        h = -h;
      }
      sx = dy === 0 ? 0 : h * dx / dy;
      sy = h;
    } else {
      if (dx < 0) {
        w2 = -w2;
      }
      sx = w2;
      sy = dx === 0 ? 0 : w2 * dy / dx;
    }
    return { x: x2 + sx, y: y2 + sy };
  }
  var shapes$2 = {
    rect: rect$2,
    ellipse,
    circle: circle$2,
    diamond
  };
  function setShapes(value) {
    shapes$2 = value;
  }
  function rect$2(parent, bbox, node2) {
    var shapeSvg = parent.insert("rect", ":first-child").attr("rx", node2.rx).attr("ry", node2.ry).attr("x", -bbox.width / 2).attr("y", -bbox.height / 2).attr("width", bbox.width).attr("height", bbox.height);
    node2.intersect = function(point2) {
      return intersectRect$2(node2, point2);
    };
    return shapeSvg;
  }
  function ellipse(parent, bbox, node2) {
    var rx = bbox.width / 2;
    var ry = bbox.height / 2;
    var shapeSvg = parent.insert("ellipse", ":first-child").attr("x", -bbox.width / 2).attr("y", -bbox.height / 2).attr("rx", rx).attr("ry", ry);
    node2.intersect = function(point2) {
      return intersectEllipse$1(node2, rx, ry, point2);
    };
    return shapeSvg;
  }
  function circle$2(parent, bbox, node2) {
    var r = Math.max(bbox.width, bbox.height) / 2;
    var shapeSvg = parent.insert("circle", ":first-child").attr("x", -bbox.width / 2).attr("y", -bbox.height / 2).attr("r", r);
    node2.intersect = function(point2) {
      return intersectCircle$1(node2, r, point2);
    };
    return shapeSvg;
  }
  function diamond(parent, bbox, node2) {
    var w2 = bbox.width * Math.SQRT2 / 2;
    var h = bbox.height * Math.SQRT2 / 2;
    var points = [
      { x: 0, y: -h },
      { x: -w2, y: 0 },
      { x: 0, y: h },
      { x: w2, y: 0 }
    ];
    var shapeSvg = parent.insert("polygon", ":first-child").attr(
      "points",
      points.map(function(p) {
        return p.x + "," + p.y;
      }).join(" ")
    );
    node2.intersect = function(p) {
      return intersectPolygon$1(node2, points, p);
    };
    return shapeSvg;
  }
  function render$1() {
    var fn = function(svg2, g) {
      preProcessGraph(g);
      var outputGroup = createOrSelectGroup(svg2, "output");
      var clustersGroup = createOrSelectGroup(outputGroup, "clusters");
      var edgePathsGroup = createOrSelectGroup(outputGroup, "edgePaths");
      var edgeLabels2 = createEdgeLabels(createOrSelectGroup(outputGroup, "edgeLabels"), g);
      var nodes2 = createNodes(createOrSelectGroup(outputGroup, "nodes"), g, shapes$2);
      layout(g);
      positionNodes$1(nodes2, g);
      positionEdgeLabels(edgeLabels2, g);
      createEdgePaths(edgePathsGroup, g, arrows);
      var clusters = createClusters(clustersGroup, g);
      positionClusters(clusters, g);
      postProcessGraph(g);
    };
    fn.createNodes = function(value) {
      if (!arguments.length)
        return createNodes;
      setCreateNodes(value);
      return fn;
    };
    fn.createClusters = function(value) {
      if (!arguments.length)
        return createClusters;
      setCreateClusters(value);
      return fn;
    };
    fn.createEdgeLabels = function(value) {
      if (!arguments.length)
        return createEdgeLabels;
      setCreateEdgeLabels(value);
      return fn;
    };
    fn.createEdgePaths = function(value) {
      if (!arguments.length)
        return createEdgePaths;
      setCreateEdgePaths(value);
      return fn;
    };
    fn.shapes = function(value) {
      if (!arguments.length)
        return shapes$2;
      setShapes(value);
      return fn;
    };
    fn.arrows = function(value) {
      if (!arguments.length)
        return arrows;
      setArrows(value);
      return fn;
    };
    return fn;
  }
  var NODE_DEFAULT_ATTRS = {
    paddingLeft: 10,
    paddingRight: 10,
    paddingTop: 10,
    paddingBottom: 10,
    rx: 0,
    ry: 0,
    shape: "rect"
  };
  var EDGE_DEFAULT_ATTRS = {
    arrowhead: "normal",
    curve: curveLinear
  };
  function preProcessGraph(g) {
    g.nodes().forEach(function(v) {
      var node2 = g.node(v);
      if (!has(node2, "label") && !g.children(v).length) {
        node2.label = v;
      }
      if (has(node2, "paddingX")) {
        defaults$1(node2, {
          paddingLeft: node2.paddingX,
          paddingRight: node2.paddingX
        });
      }
      if (has(node2, "paddingY")) {
        defaults$1(node2, {
          paddingTop: node2.paddingY,
          paddingBottom: node2.paddingY
        });
      }
      if (has(node2, "padding")) {
        defaults$1(node2, {
          paddingLeft: node2.padding,
          paddingRight: node2.padding,
          paddingTop: node2.padding,
          paddingBottom: node2.padding
        });
      }
      defaults$1(node2, NODE_DEFAULT_ATTRS);
      forEach(["paddingLeft", "paddingRight", "paddingTop", "paddingBottom"], function(k) {
        node2[k] = Number(node2[k]);
      });
      if (has(node2, "width")) {
        node2._prevWidth = node2.width;
      }
      if (has(node2, "height")) {
        node2._prevHeight = node2.height;
      }
    });
    g.edges().forEach(function(e) {
      var edge = g.edge(e);
      if (!has(edge, "label")) {
        edge.label = "";
      }
      defaults$1(edge, EDGE_DEFAULT_ATTRS);
    });
  }
  function postProcessGraph(g) {
    forEach(g.nodes(), function(v) {
      var node2 = g.node(v);
      if (has(node2, "_prevWidth")) {
        node2.width = node2._prevWidth;
      } else {
        delete node2.width;
      }
      if (has(node2, "_prevHeight")) {
        node2.height = node2._prevHeight;
      } else {
        delete node2.height;
      }
      delete node2._prevWidth;
      delete node2._prevHeight;
    });
  }
  function createOrSelectGroup(root2, name2) {
    var selection2 = root2.select("g." + name2);
    if (selection2.empty()) {
      selection2 = root2.append("g").attr("class", name2);
    }
    return selection2;
  }
  function question$1(parent, bbox, node2) {
    const w2 = bbox.width;
    const h = bbox.height;
    const s = (w2 + h) * 0.9;
    const points = [
      { x: s / 2, y: 0 },
      { x: s, y: -s / 2 },
      { x: s / 2, y: -s },
      { x: 0, y: -s / 2 }
    ];
    const shapeSvg = insertPolygonShape$2(parent, s, s, points);
    node2.intersect = function(point2) {
      return intersectPolygon$1(node2, points, point2);
    };
    return shapeSvg;
  }
  function hexagon$1(parent, bbox, node2) {
    const f2 = 4;
    const h = bbox.height;
    const m = h / f2;
    const w2 = bbox.width + 2 * m;
    const points = [
      { x: m, y: 0 },
      { x: w2 - m, y: 0 },
      { x: w2, y: -h / 2 },
      { x: w2 - m, y: -h },
      { x: m, y: -h },
      { x: 0, y: -h / 2 }
    ];
    const shapeSvg = insertPolygonShape$2(parent, w2, h, points);
    node2.intersect = function(point2) {
      return intersectPolygon$1(node2, points, point2);
    };
    return shapeSvg;
  }
  function rect_left_inv_arrow$1(parent, bbox, node2) {
    const w2 = bbox.width;
    const h = bbox.height;
    const points = [
      { x: -h / 2, y: 0 },
      { x: w2, y: 0 },
      { x: w2, y: -h },
      { x: -h / 2, y: -h },
      { x: 0, y: -h / 2 }
    ];
    const shapeSvg = insertPolygonShape$2(parent, w2, h, points);
    node2.intersect = function(point2) {
      return intersectPolygon$1(node2, points, point2);
    };
    return shapeSvg;
  }
  function lean_right$1(parent, bbox, node2) {
    const w2 = bbox.width;
    const h = bbox.height;
    const points = [
      { x: -2 * h / 6, y: 0 },
      { x: w2 - h / 6, y: 0 },
      { x: w2 + 2 * h / 6, y: -h },
      { x: h / 6, y: -h }
    ];
    const shapeSvg = insertPolygonShape$2(parent, w2, h, points);
    node2.intersect = function(point2) {
      return intersectPolygon$1(node2, points, point2);
    };
    return shapeSvg;
  }
  function lean_left$1(parent, bbox, node2) {
    const w2 = bbox.width;
    const h = bbox.height;
    const points = [
      { x: 2 * h / 6, y: 0 },
      { x: w2 + h / 6, y: 0 },
      { x: w2 - 2 * h / 6, y: -h },
      { x: -h / 6, y: -h }
    ];
    const shapeSvg = insertPolygonShape$2(parent, w2, h, points);
    node2.intersect = function(point2) {
      return intersectPolygon$1(node2, points, point2);
    };
    return shapeSvg;
  }
  function trapezoid$1(parent, bbox, node2) {
    const w2 = bbox.width;
    const h = bbox.height;
    const points = [
      { x: -2 * h / 6, y: 0 },
      { x: w2 + 2 * h / 6, y: 0 },
      { x: w2 - h / 6, y: -h },
      { x: h / 6, y: -h }
    ];
    const shapeSvg = insertPolygonShape$2(parent, w2, h, points);
    node2.intersect = function(point2) {
      return intersectPolygon$1(node2, points, point2);
    };
    return shapeSvg;
  }
  function inv_trapezoid$1(parent, bbox, node2) {
    const w2 = bbox.width;
    const h = bbox.height;
    const points = [
      { x: h / 6, y: 0 },
      { x: w2 - h / 6, y: 0 },
      { x: w2 + 2 * h / 6, y: -h },
      { x: -2 * h / 6, y: -h }
    ];
    const shapeSvg = insertPolygonShape$2(parent, w2, h, points);
    node2.intersect = function(point2) {
      return intersectPolygon$1(node2, points, point2);
    };
    return shapeSvg;
  }
  function rect_right_inv_arrow$1(parent, bbox, node2) {
    const w2 = bbox.width;
    const h = bbox.height;
    const points = [
      { x: 0, y: 0 },
      { x: w2 + h / 2, y: 0 },
      { x: w2, y: -h / 2 },
      { x: w2 + h / 2, y: -h },
      { x: 0, y: -h }
    ];
    const shapeSvg = insertPolygonShape$2(parent, w2, h, points);
    node2.intersect = function(point2) {
      return intersectPolygon$1(node2, points, point2);
    };
    return shapeSvg;
  }
  function stadium$1(parent, bbox, node2) {
    const h = bbox.height;
    const w2 = bbox.width + h / 4;
    const shapeSvg = parent.insert("rect", ":first-child").attr("rx", h / 2).attr("ry", h / 2).attr("x", -w2 / 2).attr("y", -h / 2).attr("width", w2).attr("height", h);
    node2.intersect = function(point2) {
      return intersectRect$2(node2, point2);
    };
    return shapeSvg;
  }
  function subroutine$1(parent, bbox, node2) {
    const w2 = bbox.width;
    const h = bbox.height;
    const points = [
      { x: 0, y: 0 },
      { x: w2, y: 0 },
      { x: w2, y: -h },
      { x: 0, y: -h },
      { x: 0, y: 0 },
      { x: -8, y: 0 },
      { x: w2 + 8, y: 0 },
      { x: w2 + 8, y: -h },
      { x: -8, y: -h },
      { x: -8, y: 0 }
    ];
    const shapeSvg = insertPolygonShape$2(parent, w2, h, points);
    node2.intersect = function(point2) {
      return intersectPolygon$1(node2, points, point2);
    };
    return shapeSvg;
  }
  function cylinder$1(parent, bbox, node2) {
    const w2 = bbox.width;
    const rx = w2 / 2;
    const ry = rx / (2.5 + w2 / 50);
    const h = bbox.height + ry;
    const shape = "M 0," + ry + " a " + rx + "," + ry + " 0,0,0 " + w2 + " 0 a " + rx + "," + ry + " 0,0,0 " + -w2 + " 0 l 0," + h + " a " + rx + "," + ry + " 0,0,0 " + w2 + " 0 l 0," + -h;
    const shapeSvg = parent.attr("label-offset-y", ry).insert("path", ":first-child").attr("d", shape).attr("transform", "translate(" + -w2 / 2 + "," + -(h / 2 + ry) + ")");
    node2.intersect = function(point2) {
      const pos = intersectRect$2(node2, point2);
      const x2 = pos.x - node2.x;
      if (rx != 0 && (Math.abs(x2) < node2.width / 2 || Math.abs(x2) == node2.width / 2 && Math.abs(pos.y - node2.y) > node2.height / 2 - ry)) {
        let y2 = ry * ry * (1 - x2 * x2 / (rx * rx));
        if (y2 != 0) {
          y2 = Math.sqrt(y2);
        }
        y2 = ry - y2;
        if (point2.y - node2.y > 0) {
          y2 = -y2;
        }
        pos.y += y2;
      }
      return pos;
    };
    return shapeSvg;
  }
  function addToRender(render2) {
    render2.shapes().question = question$1;
    render2.shapes().hexagon = hexagon$1;
    render2.shapes().stadium = stadium$1;
    render2.shapes().subroutine = subroutine$1;
    render2.shapes().cylinder = cylinder$1;
    render2.shapes().rect_left_inv_arrow = rect_left_inv_arrow$1;
    render2.shapes().lean_right = lean_right$1;
    render2.shapes().lean_left = lean_left$1;
    render2.shapes().trapezoid = trapezoid$1;
    render2.shapes().inv_trapezoid = inv_trapezoid$1;
    render2.shapes().rect_right_inv_arrow = rect_right_inv_arrow$1;
  }
  function addToRenderV2(addShape) {
    addShape({ question: question$1 });
    addShape({ hexagon: hexagon$1 });
    addShape({ stadium: stadium$1 });
    addShape({ subroutine: subroutine$1 });
    addShape({ cylinder: cylinder$1 });
    addShape({ rect_left_inv_arrow: rect_left_inv_arrow$1 });
    addShape({ lean_right: lean_right$1 });
    addShape({ lean_left: lean_left$1 });
    addShape({ trapezoid: trapezoid$1 });
    addShape({ inv_trapezoid: inv_trapezoid$1 });
    addShape({ rect_right_inv_arrow: rect_right_inv_arrow$1 });
  }
  function insertPolygonShape$2(parent, w2, h, points) {
    return parent.insert("polygon", ":first-child").attr(
      "points",
      points.map(function(d) {
        return d.x + "," + d.y;
      }).join(" ")
    ).attr("transform", "translate(" + -w2 / 2 + "," + h / 2 + ")");
  }
  const flowChartShapes = {
    addToRender,
    addToRenderV2
  };
  const conf$9 = {};
  const setConf$8 = function(cnf) {
    const keys2 = Object.keys(cnf);
    for (const key of keys2) {
      conf$9[key] = cnf[key];
    }
  };
  const addVertices$2 = function(vert, g, svgId, root2, _doc, diagObj) {
    const svg2 = !root2 ? select(`[id="${svgId}"]`) : root2.select(`[id="${svgId}"]`);
    const doc = !_doc ? document : _doc;
    const keys2 = Object.keys(vert);
    keys2.forEach(function(id2) {
      const vertex = vert[id2];
      let classStr = "default";
      if (vertex.classes.length > 0) {
        classStr = vertex.classes.join(" ");
      }
      const styles2 = getStylesFromArray(vertex.styles);
      let vertexText = vertex.text !== void 0 ? vertex.text : vertex.id;
      let vertexNode;
      if (evaluate(getConfig$1().flowchart.htmlLabels)) {
        const node2 = {
          label: vertexText.replace(
            /fa[blrs]?:fa-[\w-]+/g,
            (s) => `<i class='${s.replace(":", " ")}'></i>`
          )
        };
        vertexNode = addHtmlLabel$1(svg2, node2).node();
        vertexNode.parentNode.removeChild(vertexNode);
      } else {
        const svgLabel = doc.createElementNS("http://www.w3.org/2000/svg", "text");
        svgLabel.setAttribute("style", styles2.labelStyle.replace("color:", "fill:"));
        const rows = vertexText.split(common$1.lineBreakRegex);
        for (const row of rows) {
          const tspan = doc.createElementNS("http://www.w3.org/2000/svg", "tspan");
          tspan.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", "preserve");
          tspan.setAttribute("dy", "1em");
          tspan.setAttribute("x", "1");
          tspan.textContent = row;
          svgLabel.appendChild(tspan);
        }
        vertexNode = svgLabel;
      }
      let radious = 0;
      let _shape = "";
      switch (vertex.type) {
        case "round":
          radious = 5;
          _shape = "rect";
          break;
        case "square":
          _shape = "rect";
          break;
        case "diamond":
          _shape = "question";
          break;
        case "hexagon":
          _shape = "hexagon";
          break;
        case "odd":
          _shape = "rect_left_inv_arrow";
          break;
        case "lean_right":
          _shape = "lean_right";
          break;
        case "lean_left":
          _shape = "lean_left";
          break;
        case "trapezoid":
          _shape = "trapezoid";
          break;
        case "inv_trapezoid":
          _shape = "inv_trapezoid";
          break;
        case "odd_right":
          _shape = "rect_left_inv_arrow";
          break;
        case "circle":
          _shape = "circle";
          break;
        case "ellipse":
          _shape = "ellipse";
          break;
        case "stadium":
          _shape = "stadium";
          break;
        case "subroutine":
          _shape = "subroutine";
          break;
        case "cylinder":
          _shape = "cylinder";
          break;
        case "group":
          _shape = "rect";
          break;
        default:
          _shape = "rect";
      }
      log$1.warn("Adding node", vertex.id, vertex.domId);
      g.setNode(diagObj.db.lookUpDomId(vertex.id), {
        labelType: "svg",
        labelStyle: styles2.labelStyle,
        shape: _shape,
        label: vertexNode,
        rx: radious,
        ry: radious,
        class: classStr,
        style: styles2.style,
        id: diagObj.db.lookUpDomId(vertex.id)
      });
    });
  };
  const addEdges$2 = function(edges2, g, diagObj) {
    let cnt2 = 0;
    let defaultStyle2;
    let defaultLabelStyle;
    if (edges2.defaultStyle !== void 0) {
      const defaultStyles = getStylesFromArray(edges2.defaultStyle);
      defaultStyle2 = defaultStyles.style;
      defaultLabelStyle = defaultStyles.labelStyle;
    }
    edges2.forEach(function(edge) {
      cnt2++;
      const linkId = "L-" + edge.start + "-" + edge.end;
      const linkNameStart = "LS-" + edge.start;
      const linkNameEnd = "LE-" + edge.end;
      const edgeData = {};
      if (edge.type === "arrow_open") {
        edgeData.arrowhead = "none";
      } else {
        edgeData.arrowhead = "normal";
      }
      let style = "";
      let labelStyle = "";
      if (edge.style !== void 0) {
        const styles2 = getStylesFromArray(edge.style);
        style = styles2.style;
        labelStyle = styles2.labelStyle;
      } else {
        switch (edge.stroke) {
          case "normal":
            style = "fill:none";
            if (defaultStyle2 !== void 0) {
              style = defaultStyle2;
            }
            if (defaultLabelStyle !== void 0) {
              labelStyle = defaultLabelStyle;
            }
            break;
          case "dotted":
            style = "fill:none;stroke-width:2px;stroke-dasharray:3;";
            break;
          case "thick":
            style = " stroke-width: 3.5px;fill:none";
            break;
        }
      }
      edgeData.style = style;
      edgeData.labelStyle = labelStyle;
      if (edge.interpolate !== void 0) {
        edgeData.curve = interpolateToCurve(edge.interpolate, curveLinear);
      } else if (edges2.defaultInterpolate !== void 0) {
        edgeData.curve = interpolateToCurve(edges2.defaultInterpolate, curveLinear);
      } else {
        edgeData.curve = interpolateToCurve(conf$9.curve, curveLinear);
      }
      if (edge.text === void 0) {
        if (edge.style !== void 0) {
          edgeData.arrowheadStyle = "fill: #333";
        }
      } else {
        edgeData.arrowheadStyle = "fill: #333";
        edgeData.labelpos = "c";
        if (evaluate(getConfig$1().flowchart.htmlLabels)) {
          edgeData.labelType = "html";
          edgeData.label = `<span id="L-${linkId}" class="edgeLabel L-${linkNameStart}' L-${linkNameEnd}" style="${edgeData.labelStyle}">${edge.text.replace(
            /fa[blrs]?:fa-[\w-]+/g,
            (s) => `<i class='${s.replace(":", " ")}'></i>`
          )}</span>`;
        } else {
          edgeData.labelType = "text";
          edgeData.label = edge.text.replace(common$1.lineBreakRegex, "\n");
          if (edge.style === void 0) {
            edgeData.style = edgeData.style || "stroke: #333; stroke-width: 1.5px;fill:none";
          }
          edgeData.labelStyle = edgeData.labelStyle.replace("color:", "fill:");
        }
      }
      edgeData.id = linkId;
      edgeData.class = linkNameStart + " " + linkNameEnd;
      edgeData.minlen = edge.length || 1;
      g.setEdge(diagObj.db.lookUpDomId(edge.start), diagObj.db.lookUpDomId(edge.end), edgeData, cnt2);
    });
  };
  const getClasses$5 = function(text2, diagObj) {
    log$1.info("Extracting classes");
    diagObj.db.clear();
    try {
      diagObj.parse(text2);
      return diagObj.db.getClasses();
    } catch (e) {
      log$1.error(e);
      return {};
    }
  };
  const draw$h = function(text2, id2, _version, diagObj) {
    log$1.info("Drawing flowchart");
    diagObj.db.clear();
    const { securityLevel, flowchart: conf2 } = getConfig$1();
    let sandboxElement;
    if (securityLevel === "sandbox") {
      sandboxElement = select("#i" + id2);
    }
    const root2 = securityLevel === "sandbox" ? select(sandboxElement.nodes()[0].contentDocument.body) : select("body");
    const doc = securityLevel === "sandbox" ? sandboxElement.nodes()[0].contentDocument : document;
    try {
      diagObj.parser.parse(text2);
    } catch (err) {
      log$1.debug("Parsing failed");
    }
    let dir = diagObj.db.getDirection();
    if (dir === void 0) {
      dir = "TD";
    }
    const nodeSpacing = conf2.nodeSpacing || 50;
    const rankSpacing = conf2.rankSpacing || 50;
    const g = new Graph({
      multigraph: true,
      compound: true
    }).setGraph({
      rankdir: dir,
      nodesep: nodeSpacing,
      ranksep: rankSpacing,
      marginx: 8,
      marginy: 8
    }).setDefaultEdgeLabel(function() {
      return {};
    });
    let subG;
    const subGraphs2 = diagObj.db.getSubGraphs();
    for (let i3 = subGraphs2.length - 1; i3 >= 0; i3--) {
      subG = subGraphs2[i3];
      diagObj.db.addVertex(subG.id, subG.title, "group", void 0, subG.classes);
    }
    const vert = diagObj.db.getVertices();
    log$1.warn("Get vertices", vert);
    const edges2 = diagObj.db.getEdges();
    let i2 = 0;
    for (i2 = subGraphs2.length - 1; i2 >= 0; i2--) {
      subG = subGraphs2[i2];
      selectAll("cluster").append("text");
      for (let j = 0; j < subG.nodes.length; j++) {
        log$1.warn(
          "Setting subgraph",
          subG.nodes[j],
          diagObj.db.lookUpDomId(subG.nodes[j]),
          diagObj.db.lookUpDomId(subG.id)
        );
        g.setParent(diagObj.db.lookUpDomId(subG.nodes[j]), diagObj.db.lookUpDomId(subG.id));
      }
    }
    addVertices$2(vert, g, id2, root2, doc, diagObj);
    addEdges$2(edges2, g, diagObj);
    const render2 = new render$1();
    flowChartShapes.addToRender(render2);
    render2.arrows().none = function normal2(parent, id3, edge, type2) {
      const marker = parent.append("marker").attr("id", id3).attr("viewBox", "0 0 10 10").attr("refX", 9).attr("refY", 5).attr("markerUnits", "strokeWidth").attr("markerWidth", 8).attr("markerHeight", 6).attr("orient", "auto");
      const path2 = marker.append("path").attr("d", "M 0 0 L 0 0 L 0 0 z");
      applyStyle$2(path2, edge[type2 + "Style"]);
    };
    render2.arrows().normal = function normal2(parent, id3) {
      const marker = parent.append("marker").attr("id", id3).attr("viewBox", "0 0 10 10").attr("refX", 9).attr("refY", 5).attr("markerUnits", "strokeWidth").attr("markerWidth", 8).attr("markerHeight", 6).attr("orient", "auto");
      marker.append("path").attr("d", "M 0 0 L 10 5 L 0 10 z").attr("class", "arrowheadPath").style("stroke-width", 1).style("stroke-dasharray", "1,0");
    };
    const svg2 = root2.select(`[id="${id2}"]`);
    const element2 = root2.select("#" + id2 + " g");
    render2(element2, g);
    element2.selectAll("g.node").attr("title", function() {
      return diagObj.db.getTooltip(this.id);
    });
    diagObj.db.indexNodes("subGraph" + i2);
    for (i2 = 0; i2 < subGraphs2.length; i2++) {
      subG = subGraphs2[i2];
      if (subG.title !== "undefined") {
        const clusterRects = doc.querySelectorAll(
          "#" + id2 + ' [id="' + diagObj.db.lookUpDomId(subG.id) + '"] rect'
        );
        const clusterEl = doc.querySelectorAll(
          "#" + id2 + ' [id="' + diagObj.db.lookUpDomId(subG.id) + '"]'
        );
        const xPos = clusterRects[0].x.baseVal.value;
        const yPos = clusterRects[0].y.baseVal.value;
        const _width = clusterRects[0].width.baseVal.value;
        const cluster = select(clusterEl[0]);
        const te = cluster.select(".label");
        te.attr("transform", `translate(${xPos + _width / 2}, ${yPos + 14})`);
        te.attr("id", id2 + "Text");
        for (let j = 0; j < subG.classes.length; j++) {
          clusterEl[0].classList.add(subG.classes[j]);
        }
      }
    }
    if (!conf2.htmlLabels) {
      const labels = doc.querySelectorAll('[id="' + id2 + '"] .edgeLabel .label');
      for (const label of labels) {
        const dim = label.getBBox();
        const rect2 = doc.createElementNS("http://www.w3.org/2000/svg", "rect");
        rect2.setAttribute("rx", 0);
        rect2.setAttribute("ry", 0);
        rect2.setAttribute("width", dim.width);
        rect2.setAttribute("height", dim.height);
        label.insertBefore(rect2, label.firstChild);
      }
    }
    setupGraphViewbox$1(g, svg2, conf2.diagramPadding, conf2.useMaxWidth);
    const keys2 = Object.keys(vert);
    keys2.forEach(function(key) {
      const vertex = vert[key];
      if (vertex.link) {
        const node2 = root2.select("#" + id2 + ' [id="' + diagObj.db.lookUpDomId(key) + '"]');
        if (node2) {
          const link = doc.createElementNS("http://www.w3.org/2000/svg", "a");
          link.setAttributeNS("http://www.w3.org/2000/svg", "class", vertex.classes.join(" "));
          link.setAttributeNS("http://www.w3.org/2000/svg", "href", vertex.link);
          link.setAttributeNS("http://www.w3.org/2000/svg", "rel", "noopener");
          if (securityLevel === "sandbox") {
            link.setAttributeNS("http://www.w3.org/2000/svg", "target", "_top");
          } else if (vertex.linkTarget) {
            link.setAttributeNS("http://www.w3.org/2000/svg", "target", vertex.linkTarget);
          }
          const linkNode = node2.insert(function() {
            return link;
          }, ":first-child");
          const shape = node2.select(".label-container");
          if (shape) {
            linkNode.append(function() {
              return shape.node();
            });
          }
          const label = node2.select(".label");
          if (label) {
            linkNode.append(function() {
              return label.node();
            });
          }
        }
      }
    });
  };
  const flowRenderer = {
    setConf: setConf$8,
    addVertices: addVertices$2,
    addEdges: addEdges$2,
    getClasses: getClasses$5,
    draw: draw$h
  };
  function write(g) {
    var json2 = {
      options: {
        directed: g.isDirected(),
        multigraph: g.isMultigraph(),
        compound: g.isCompound()
      },
      nodes: writeNodes(g),
      edges: writeEdges(g)
    };
    if (!isUndefined(g.graph())) {
      json2.value = clone$1(g.graph());
    }
    return json2;
  }
  function writeNodes(g) {
    return map(g.nodes(), function(v) {
      var nodeValue = g.node(v);
      var parent = g.parent(v);
      var node2 = { v };
      if (!isUndefined(nodeValue)) {
        node2.value = nodeValue;
      }
      if (!isUndefined(parent)) {
        node2.parent = parent;
      }
      return node2;
    });
  }
  function writeEdges(g) {
    return map(g.edges(), function(e) {
      var edgeValue = g.edge(e);
      var edge = { v: e.v, w: e.w };
      if (!isUndefined(e.name)) {
        edge.name = e.name;
      }
      if (!isUndefined(edgeValue)) {
        edge.value = edgeValue;
      }
      return edge;
    });
  }
  const insertMarkers$3 = (elem, markerArray, type2, id2) => {
    markerArray.forEach((markerName) => {
      markers$1[markerName](elem, type2, id2);
    });
  };
  const extension$1 = (elem, type2, id2) => {
    log$1.trace("Making markers for ", id2);
    elem.append("defs").append("marker").attr("id", type2 + "-extensionStart").attr("class", "marker extension " + type2).attr("refX", 0).attr("refY", 7).attr("markerWidth", 190).attr("markerHeight", 240).attr("orient", "auto").append("path").attr("d", "M 1,7 L18,13 V 1 Z");
    elem.append("defs").append("marker").attr("id", type2 + "-extensionEnd").attr("class", "marker extension " + type2).attr("refX", 19).attr("refY", 7).attr("markerWidth", 20).attr("markerHeight", 28).attr("orient", "auto").append("path").attr("d", "M 1,1 V 13 L18,7 Z");
  };
  const composition = (elem, type2) => {
    elem.append("defs").append("marker").attr("id", type2 + "-compositionStart").attr("class", "marker composition " + type2).attr("refX", 0).attr("refY", 7).attr("markerWidth", 190).attr("markerHeight", 240).attr("orient", "auto").append("path").attr("d", "M 18,7 L9,13 L1,7 L9,1 Z");
    elem.append("defs").append("marker").attr("id", type2 + "-compositionEnd").attr("class", "marker composition " + type2).attr("refX", 19).attr("refY", 7).attr("markerWidth", 20).attr("markerHeight", 28).attr("orient", "auto").append("path").attr("d", "M 18,7 L9,13 L1,7 L9,1 Z");
  };
  const aggregation = (elem, type2) => {
    elem.append("defs").append("marker").attr("id", type2 + "-aggregationStart").attr("class", "marker aggregation " + type2).attr("refX", 0).attr("refY", 7).attr("markerWidth", 190).attr("markerHeight", 240).attr("orient", "auto").append("path").attr("d", "M 18,7 L9,13 L1,7 L9,1 Z");
    elem.append("defs").append("marker").attr("id", type2 + "-aggregationEnd").attr("class", "marker aggregation " + type2).attr("refX", 19).attr("refY", 7).attr("markerWidth", 20).attr("markerHeight", 28).attr("orient", "auto").append("path").attr("d", "M 18,7 L9,13 L1,7 L9,1 Z");
  };
  const dependency = (elem, type2) => {
    elem.append("defs").append("marker").attr("id", type2 + "-dependencyStart").attr("class", "marker dependency " + type2).attr("refX", 0).attr("refY", 7).attr("markerWidth", 190).attr("markerHeight", 240).attr("orient", "auto").append("path").attr("d", "M 5,7 L9,13 L1,7 L9,1 Z");
    elem.append("defs").append("marker").attr("id", type2 + "-dependencyEnd").attr("class", "marker dependency " + type2).attr("refX", 19).attr("refY", 7).attr("markerWidth", 20).attr("markerHeight", 28).attr("orient", "auto").append("path").attr("d", "M 18,7 L9,13 L14,7 L9,1 Z");
  };
  const lollipop = (elem, type2) => {
    elem.append("defs").append("marker").attr("id", type2 + "-lollipopStart").attr("class", "marker lollipop " + type2).attr("refX", 0).attr("refY", 7).attr("markerWidth", 190).attr("markerHeight", 240).attr("orient", "auto").append("circle").attr("stroke", "black").attr("fill", "white").attr("cx", 6).attr("cy", 7).attr("r", 6);
  };
  const point$2 = (elem, type2) => {
    elem.append("marker").attr("id", type2 + "-pointEnd").attr("class", "marker " + type2).attr("viewBox", "0 0 10 10").attr("refX", 10).attr("refY", 5).attr("markerUnits", "userSpaceOnUse").attr("markerWidth", 12).attr("markerHeight", 12).attr("orient", "auto").append("path").attr("d", "M 0 0 L 10 5 L 0 10 z").attr("class", "arrowMarkerPath").style("stroke-width", 1).style("stroke-dasharray", "1,0");
    elem.append("marker").attr("id", type2 + "-pointStart").attr("class", "marker " + type2).attr("viewBox", "0 0 10 10").attr("refX", 0).attr("refY", 5).attr("markerUnits", "userSpaceOnUse").attr("markerWidth", 12).attr("markerHeight", 12).attr("orient", "auto").append("path").attr("d", "M 0 5 L 10 10 L 10 0 z").attr("class", "arrowMarkerPath").style("stroke-width", 1).style("stroke-dasharray", "1,0");
  };
  const circle$1 = (elem, type2) => {
    elem.append("marker").attr("id", type2 + "-circleEnd").attr("class", "marker " + type2).attr("viewBox", "0 0 10 10").attr("refX", 11).attr("refY", 5).attr("markerUnits", "userSpaceOnUse").attr("markerWidth", 11).attr("markerHeight", 11).attr("orient", "auto").append("circle").attr("cx", "5").attr("cy", "5").attr("r", "5").attr("class", "arrowMarkerPath").style("stroke-width", 1).style("stroke-dasharray", "1,0");
    elem.append("marker").attr("id", type2 + "-circleStart").attr("class", "marker " + type2).attr("viewBox", "0 0 10 10").attr("refX", -1).attr("refY", 5).attr("markerUnits", "userSpaceOnUse").attr("markerWidth", 11).attr("markerHeight", 11).attr("orient", "auto").append("circle").attr("cx", "5").attr("cy", "5").attr("r", "5").attr("class", "arrowMarkerPath").style("stroke-width", 1).style("stroke-dasharray", "1,0");
  };
  const cross = (elem, type2) => {
    elem.append("marker").attr("id", type2 + "-crossEnd").attr("class", "marker cross " + type2).attr("viewBox", "0 0 11 11").attr("refX", 12).attr("refY", 5.2).attr("markerUnits", "userSpaceOnUse").attr("markerWidth", 11).attr("markerHeight", 11).attr("orient", "auto").append("path").attr("d", "M 1,1 l 9,9 M 10,1 l -9,9").attr("class", "arrowMarkerPath").style("stroke-width", 2).style("stroke-dasharray", "1,0");
    elem.append("marker").attr("id", type2 + "-crossStart").attr("class", "marker cross " + type2).attr("viewBox", "0 0 11 11").attr("refX", -1).attr("refY", 5.2).attr("markerUnits", "userSpaceOnUse").attr("markerWidth", 11).attr("markerHeight", 11).attr("orient", "auto").append("path").attr("d", "M 1,1 l 9,9 M 10,1 l -9,9").attr("class", "arrowMarkerPath").style("stroke-width", 2).style("stroke-dasharray", "1,0");
  };
  const barb = (elem, type2) => {
    elem.append("defs").append("marker").attr("id", type2 + "-barbEnd").attr("refX", 19).attr("refY", 7).attr("markerWidth", 20).attr("markerHeight", 14).attr("markerUnits", "strokeWidth").attr("orient", "auto").append("path").attr("d", "M 19,7 L9,13 L14,7 L9,1 Z");
  };
  const markers$1 = {
    extension: extension$1,
    composition,
    aggregation,
    dependency,
    lollipop,
    point: point$2,
    circle: circle$1,
    cross,
    barb
  };
  const insertMarkers$4 = insertMarkers$3;
  function applyStyle$1(dom, styleFn) {
    if (styleFn) {
      dom.attr("style", styleFn);
    }
  }
  function addHtmlLabel(node2) {
    const fo = select(document.createElementNS("http://www.w3.org/2000/svg", "foreignObject"));
    const div = fo.append("xhtml:div");
    const label = node2.label;
    const labelClass = node2.isNode ? "nodeLabel" : "edgeLabel";
    div.html(
      '<span class="' + labelClass + '" ' + (node2.labelStyle ? 'style="' + node2.labelStyle + '"' : "") + ">" + label + "</span>"
    );
    applyStyle$1(div, node2.labelStyle);
    div.style("display", "inline-block");
    div.style("white-space", "nowrap");
    div.attr("xmlns", "http://www.w3.org/1999/xhtml");
    return fo.node();
  }
  const createLabel = (_vertexText, style, isTitle, isNode) => {
    let vertexText = _vertexText || "";
    if (typeof vertexText === "object") {
      vertexText = vertexText[0];
    }
    if (evaluate(getConfig$1().flowchart.htmlLabels)) {
      vertexText = vertexText.replace(/\\n|\n/g, "<br />");
      log$1.info("vertexText" + vertexText);
      const node2 = {
        isNode,
        label: decodeEntities(vertexText).replace(
          /fa[blrs]?:fa-[\w-]+/g,
          (s) => `<i class='${s.replace(":", " ")}'></i>`
        ),
        labelStyle: style.replace("fill:", "color:")
      };
      let vertexNode = addHtmlLabel(node2);
      return vertexNode;
    } else {
      const svgLabel = document.createElementNS("http://www.w3.org/2000/svg", "text");
      svgLabel.setAttribute("style", style.replace("color:", "fill:"));
      let rows = [];
      if (typeof vertexText === "string") {
        rows = vertexText.split(/\\n|\n|<br\s*\/?>/gi);
      } else if (Array.isArray(vertexText)) {
        rows = vertexText;
      } else {
        rows = [];
      }
      for (const row of rows) {
        const tspan = document.createElementNS("http://www.w3.org/2000/svg", "tspan");
        tspan.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", "preserve");
        tspan.setAttribute("dy", "1em");
        tspan.setAttribute("x", "0");
        if (isTitle) {
          tspan.setAttribute("class", "title-row");
        } else {
          tspan.setAttribute("class", "row");
        }
        tspan.textContent = row.trim();
        svgLabel.appendChild(tspan);
      }
      return svgLabel;
    }
  };
  const createLabel$1 = createLabel;
  function toString(node2, options2) {
    var { includeImageAlt = true } = options2 || {};
    return one(node2, includeImageAlt);
  }
  function one(node2, includeImageAlt) {
    return node2 && typeof node2 === "object" && // @ts-ignore looks like a literal.
    (node2.value || // @ts-ignore looks like an image.
    (includeImageAlt ? node2.alt : "") || // @ts-ignore looks like a parent.
    "children" in node2 && all(node2.children, includeImageAlt) || Array.isArray(node2) && all(node2, includeImageAlt)) || "";
  }
  function all(values2, includeImageAlt) {
    var result = [];
    var index2 = -1;
    while (++index2 < values2.length) {
      result[index2] = one(values2[index2], includeImageAlt);
    }
    return result.join("");
  }
  function splice(list2, start2, remove2, items) {
    const end2 = list2.length;
    let chunkStart = 0;
    let parameters;
    if (start2 < 0) {
      start2 = -start2 > end2 ? 0 : end2 + start2;
    } else {
      start2 = start2 > end2 ? end2 : start2;
    }
    remove2 = remove2 > 0 ? remove2 : 0;
    if (items.length < 1e4) {
      parameters = Array.from(items);
      parameters.unshift(start2, remove2);
      [].splice.apply(list2, parameters);
    } else {
      if (remove2)
        [].splice.apply(list2, [start2, remove2]);
      while (chunkStart < items.length) {
        parameters = items.slice(chunkStart, chunkStart + 1e4);
        parameters.unshift(start2, 0);
        [].splice.apply(list2, parameters);
        chunkStart += 1e4;
        start2 += 1e4;
      }
    }
  }
  function push(list2, items) {
    if (list2.length > 0) {
      splice(list2, list2.length, 0, items);
      return list2;
    }
    return items;
  }
  const hasOwnProperty = {}.hasOwnProperty;
  function combineExtensions(extensions) {
    const all2 = {};
    let index2 = -1;
    while (++index2 < extensions.length) {
      syntaxExtension(all2, extensions[index2]);
    }
    return all2;
  }
  function syntaxExtension(all2, extension2) {
    let hook;
    for (hook in extension2) {
      const maybe = hasOwnProperty.call(all2, hook) ? all2[hook] : void 0;
      const left2 = maybe || (all2[hook] = {});
      const right2 = extension2[hook];
      let code;
      for (code in right2) {
        if (!hasOwnProperty.call(left2, code))
          left2[code] = [];
        const value = right2[code];
        constructs(
          // @ts-expect-error Looks like a list.
          left2[code],
          Array.isArray(value) ? value : value ? [value] : []
        );
      }
    }
  }
  function constructs(existing, list2) {
    let index2 = -1;
    const before = [];
    while (++index2 < list2.length) {
      (list2[index2].add === "after" ? existing : before).push(list2[index2]);
    }
    splice(existing, 0, 0, before);
  }
  const unicodePunctuationRegex = /[!-/:-@[-`{-~\u00A1\u00A7\u00AB\u00B6\u00B7\u00BB\u00BF\u037E\u0387\u055A-\u055F\u0589\u058A\u05BE\u05C0\u05C3\u05C6\u05F3\u05F4\u0609\u060A\u060C\u060D\u061B\u061E\u061F\u066A-\u066D\u06D4\u0700-\u070D\u07F7-\u07F9\u0830-\u083E\u085E\u0964\u0965\u0970\u09FD\u0A76\u0AF0\u0C77\u0C84\u0DF4\u0E4F\u0E5A\u0E5B\u0F04-\u0F12\u0F14\u0F3A-\u0F3D\u0F85\u0FD0-\u0FD4\u0FD9\u0FDA\u104A-\u104F\u10FB\u1360-\u1368\u1400\u166E\u169B\u169C\u16EB-\u16ED\u1735\u1736\u17D4-\u17D6\u17D8-\u17DA\u1800-\u180A\u1944\u1945\u1A1E\u1A1F\u1AA0-\u1AA6\u1AA8-\u1AAD\u1B5A-\u1B60\u1BFC-\u1BFF\u1C3B-\u1C3F\u1C7E\u1C7F\u1CC0-\u1CC7\u1CD3\u2010-\u2027\u2030-\u2043\u2045-\u2051\u2053-\u205E\u207D\u207E\u208